window.addEventListener("load", function() {
	(new futomiGyroscope()).startMeter();
}, false);

function futomiGyroscope() {
	this.el_frame = document.getElementById("frame");
	this.width = window.innerWidth;
	this.height = window.innerHeight - this.el_frame.offsetHeight;
	//
	document.body.style.width = this.width + "px";
	document.body.style.height = this.height + "px";
	//
	this.el_gyro_width = this.width * 0.75;
	this.el_gyro_height = this.el_gyro_width;
	this.el_gyro_frame = document.getElementById("gyro_frame");
	this.el_gyro_frame.style.width = this.el_gyro_width + "px";
	this.el_gyro_frame.style.height = this.el_gyro_height + "px";
	//
	this.el_compass_width = this.width * 0.70;
	this.el_compass_height = this.el_compass_width;
	this.el_compass_frame = document.getElementById("compass_frame");
	this.el_compass_frame.style.width = this.el_compass_width + "px";
	this.el_compass_frame.style.height = this.el_compass_height + "px";
	//
	this.el_heading_degree = document.getElementById("heading_degree");
	this.el_heading_string = document.getElementById("heading_string");
	this.el_heading_frame  = document.getElementById("heading_frame");
	this.el_heading_frame.style.fontSize = (this.width * 0.05) + "px";
	//
	this.el_pich = document.getElementById("pich");
	this.el_roll = document.getElementById("roll");
	this.el_pich_roll_frame  = document.getElementById("pich_roll_frame");
	this.el_pich_roll_frame.style.fontSize = (this.width * 0.05) + "px";
	//
	this.prealpha = 0;
	this.alpha = 0;
	this.beta = 0;
	this.gamma = 0;
	//
	this.beta_offset = 0;
	this.gamma_offset = 0;
	//
	this.tm = (new Date()).getTime();
	//
	this.canvas_gyro_inner = null;
	this.ctx_gyro_inner = null;
	this.canvas_gyro_indicator = null;
	this.ctx_gyro_indicator = null;
	//
	this.transition = "transform 0.3s linear 0s";
}

var proto = futomiGyroscope.prototype;

proto.startMeter = function() {
	this.prepareGyroInner();
	this.prepareGyroIndicator();
	this.prepareGyroOuter();
	//
	this.prepareCompassInner();
	this.prepareCompassOuter();
	//
	var _this = this;
	window.addEventListener('deviceorientation', function(e) {
		var tm = (new Date()).getTime();
		if(tm - _this.tm >= 100) {
			_this.alpha = e.webkitCompassHeading ? (360 - e.webkitCompassHeading) : e.alpha;
			_this.beta = -e.beta;
			_this.gamma = -e.gamma;
			_this.drawGyro();
			_this.drawCompass();
			_this.tm = tm;
		}
	}, false);
	// menubar
	var el_toolbar_btn_calibration = document.getElementById("toolbar_btn_calibration");
	var el_dialog_calibration = document.getElementById("dialog_calibration");
	el_toolbar_btn_calibration.addEventListener("click", function() {
		el_dialog_calibration.style.display = "block";
	}, false);
	// calibration dialog
	el_dialog_calibration.addEventListener("click", function(e) {
		if(e.target.id === "dialog_calibration_btn_clear") {
			_this.beta_offset = 0;
			_this.gamma_offset = 0;
			el_dialog_calibration.style.display = "none";
		} else if(e.target.id === "dialog_calibration_btn_calibrate") {
			_this.beta_offset = _this.beta;
			_this.gamma_offset = _this.gamma;
			el_dialog_calibration.style.display = "none";
		}
	}, false);
	el_dialog_calibration.addEventListener("submit", function(e) {
		e.preventDefault();
	}, false);
	// toolbar on the bottom
	var el_toolbar_bottom = document.getElementById("toolbar_bottom");
	var el_dialog_info = document.getElementById("dialog_info");
	this.el_frame.addEventListener("click", function() {
		if(el_toolbar_bottom.style.display === "block") {
			el_toolbar_bottom.style.display = "none";
		} else {
			el_toolbar_bottom.style.display = "block";
		}
	}, false);
	el_toolbar_bottom.addEventListener("click", function(e) {
		if(e.target.id === "toolbar_bottom_btn_info") {
			el_toolbar_bottom.style.display = "none";
			el_dialog_info.style.display = "block";
		} else if(e.target.id === "toolbar_bottom_btn_calibration") {
			el_toolbar_bottom.style.display = "none";
			el_dialog_calibration.style.display = "block";
		}
	}, false);
	// Information dialog
	el_dialog_info.addEventListener("click", function(e) {
		if(e.target.id === "dialog_info_btn_close") {
			el_dialog_info.style.display = "none";
		} else if(e.target.id === "dialog_info_btn_visit") {
			window.open("https://twitter.com/futomi", "_new");
		}
	}, false);
	el_dialog_info.addEventListener("submit", function(e) {
		e.preventDefault();
	}, false);
};

proto.prepareGyroOuter = function() {
	var el_gyro_width = this.el_gyro_width;
	//
	var c = document.createElement("canvas");
	c.style.position = "absolute";
	c.style.left = "0px";
	c.style.top = "0px";
	c.style.zIndex = 20;
	c.width = this.el_gyro_width + 1;
	c.height = this.el_gyro_height + 1;
	var ctx = c.getContext("2d");
	//
	var r = c.width * 0.9 / 2;
	var angle = 60 * Math.PI / 180;
	var cx = c.width / 2;
	var cy = c.height / 2;
	//
	var line_width_thick = this.el_gyro_width / 100;
	var line_width_thin = line_width_thick / 2;
	// NbsOpX
	(function () {
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(0, 0);
		ctx.lineTo(0, c.height);
		ctx.lineTo(c.width, c.height);
		ctx.lineTo(c.width, 0);
		ctx.closePath();
		var makeInnerPath = function(ctx) {
			ctx.moveTo(cx - r * Math.sin(angle), cy - r * Math.cos(angle));
			ctx.arc(cx, cy, r, (Math.PI * 3 / 2) - angle, (Math.PI * 3 / 2) + angle, false);
			ctx.arc(cx, cy, r, (Math.PI / 2) - angle, (Math.PI / 2) + angle, false);
			ctx.closePath();
		};
		makeInnerPath(ctx);
		//
		ctx.clip();
		ctx.fillStyle = "#000000";
		ctx.fill();
		//
		ctx.beginPath();
		makeInnerPath(ctx);
		ctx.strokeStyle = "#ffffff";
		ctx.lineWidth = line_width_thick;
		ctx.stroke();
		ctx.restore();
	})();
	// ڐij
	(function () {
		var indicator_angle_list = [
			10 * Math.PI / 180,
			20 * Math.PI / 180,
			30 * Math.PI / 180,
			60 * Math.PI / 180
		];
		ctx.beginPath();
		for( var i=0; i<indicator_angle_list.length; i++ ) {
			var rad = indicator_angle_list[i];
			var sin = Math.sin(rad);
			var cos = Math.cos(rad);
			var mag = ( i=== 2 ) ? 1.1 : 1.05;
			ctx.moveTo(cx + r * sin,       cy - r * cos);
			ctx.lineTo(cx + r * sin * mag, cy - r * cos * mag);
			ctx.moveTo(cx - r * sin,       cy - r * cos);
			ctx.lineTo(cx - r * sin * mag, cy - r * cos * mag);
		}
		ctx.strokeStyle = "#ffffff";
		ctx.lineWidth = line_width_thin;
		ctx.stroke();
	})();
	// tOp`̃pX𐶐֐IuWFNg
	var makeInvertedTrianglePath = function(ctx, side_len) {
		var x = side_len * Math.cos(Math.PI / 3);
		var y = side_len * Math.sin(Math.PI / 3);
		ctx.moveTo(0, 0);
		ctx.lineTo(x, -y);
		ctx.lineTo(-x, -y);
		ctx.closePath();
	};
	// ڐi45xtOp`j
	(function () {
		ctx.strokeStyle = "#ffffff";
		ctx.lineWidth = line_width_thin;
		var tx = (r + el_gyro_width / 100) * Math.sin(45 * Math.PI / 180);
		var ty = (r + el_gyro_width / 100) * Math.cos(45 * Math.PI / 180);
		//
		ctx.save();
		ctx.translate(cx + tx, cy - ty);
		ctx.rotate(45 * Math.PI / 180);
		ctx.beginPath();
		makeInvertedTrianglePath(ctx, r * 0.05);
		ctx.stroke();
		ctx.restore();
		//
		ctx.save();
		ctx.translate(cx - tx, cy - ty);
		ctx.rotate(-45 * Math.PI / 180);
		ctx.beginPath();
		makeInvertedTrianglePath(ctx, r * 0.05);
		ctx.stroke();
		ctx.restore();
	})();
	// 㑤ʒ̋tOp`̖ڐ
	(function () {
		ctx.save();
		ctx.translate(cx, cy - r - (el_gyro_width / 100));
		ctx.beginPath();
		makeInvertedTrianglePath(ctx, r * 0.1);
		ctx.lineWidth = line_width_thick;
		ctx.stroke();
		ctx.restore();
	})();
	// Eʒ̖ڐ
	(function () {
		var x = cx + r * Math.sin(angle);
		ctx.beginPath();
		ctx.moveTo(x, cy);
		ctx.lineTo(x + r * 0.1, cy);
		ctx.lineWidth = line_width_thick;
		ctx.stroke();
	})();
	// ẺF̖ڐ
	(function () {
		var hlen = r * Math.sin(angle) * 0.1;
		var x = r * Math.sin(angle) * 0.87;
		var vlen = hlen * 0.8;
		var y = cy - (vlen / 2);
		ctx.strokeStyle = "#C9AF00";
		ctx.lineWidth = line_width_thin;
		ctx.beginPath();
		ctx.strokeRect(cx + x, y, hlen, vlen);
		ctx.beginPath();
		ctx.strokeRect(cx - x - hlen, y, hlen, vlen);
	})();
	// ̉F̋@̐}`
	(function () {
		ctx.save();
		var x = r * 0.6;
		var y = r * 0.2;
		ctx.translate(cx, cy);
		ctx.beginPath();
		ctx.moveTo(0, 0);
		ctx.lineTo(x, y);
		ctx.lineTo(x/3, y);
		ctx.lineTo(x/3, y*0.8);
		ctx.lineTo(-x/3, y*0.8);
		ctx.lineTo(-x/3, y);
		ctx.lineTo(-x, y);
		ctx.closePath();
		ctx.strokeStyle = "#C9AF00";
		ctx.lineWidth = line_width_thick;
		ctx.stroke();
		ctx.fillStyle = "#000000";
		ctx.fill();
		//
		ctx.beginPath();
		ctx.moveTo(x, y);
		ctx.lineTo(0, y/2);
		ctx.lineTo(-x, y);
		ctx.moveTo(0, 0);
		ctx.lineTo(0, y/2);
		ctx.stroke();
		ctx.restore();
	})();
	//
	this.el_gyro_frame.appendChild(c);
};

proto.prepareGyroInner = function() {
	var c = document.createElement("canvas");
	c.style.position = "absolute";
	c.style.zIndex = 10;
	c.width = this.el_gyro_width * 2;
	var height_per_deg = this.el_gyro_height * 0.9 / 45;
	var deg_range = 180;
	c.height = height_per_deg * deg_range * 2;
	c.style.left = "-" + ((c.width - this.el_gyro_width ) / 2) + "px";
	c.style.top = "-" + ((c.height - this.el_gyro_height ) / 2) + "px";
	c.style.transition = this.transition;
	//
	var ctx = c.getContext("2d");
	// background
	ctx.fillStyle = "#506589";
	ctx.fillRect(0, 0, c.width, c.height/2);
	ctx.fillStyle = "#6D604C";
	ctx.fillRect(0, c.height/2, c.width, c.height);
	// indicator
	var line_width_thick = this.el_gyro_width / 100;
	var line_width_thin = line_width_thick / 2;
	var line_length_long = this.el_gyro_width / 4;
	var line_length_short = line_length_long / 2;
	var font_size = parseInt(c.width / 25);
	ctx.font = font_size + "px Arial";
	ctx.fillStyle = "#ffffff";
	ctx.strokeStyle = "#ffffff";
	ctx.textAlign = "center";
	ctx.textBaseline = "middle";
	var y_middle = c.height / 2;
	//
	ctx.beginPath();
	ctx.moveTo(0, y_middle);
	ctx.lineTo(c.width, y_middle);
	ctx.lineWidth = line_width_thick;
	ctx.stroke();
	//
	for( var i=5; i<=deg_range; i+=5 ) {
		var line_width = line_width_thick;
		var line_length = line_length_short;
		if( i % 10 === 0 ) {
			line_width = line_width_thin;
			line_length = line_length_long;
		}
		var x = (c.width - line_length) / 2;
		var y_diff = i * height_per_deg;
		//
		ctx.beginPath();
		ctx.moveTo(x, y_middle + y_diff);
		ctx.lineTo(x + line_length, y_middle + y_diff);
		ctx.closePath();
		ctx.moveTo(x, y_middle - y_diff);
		ctx.lineTo(x + line_length, y_middle - y_diff);
		ctx.closePath();
		ctx.lineWidth = line_width;
		ctx.stroke();
		//
		if( i % 10 === 0 ) {
			ctx.beginPath();
			ctx.fillText(i, x - font_size, y_middle + y_diff);
			ctx.fill();
			ctx.beginPath();
			ctx.fillText(i, x + line_length + font_size, y_middle + y_diff);
			ctx.fill();
			//
			ctx.beginPath();
			ctx.fillText(i, x - font_size, y_middle - y_diff);
			ctx.fill();
			ctx.beginPath();
			ctx.fillText(i, x + line_length + font_size, y_middle - y_diff);
			ctx.fill();
		}
	}
	//
	this.el_gyro_frame.appendChild(c);
	this.canvas_gyro_inner = c;
	this.ctx_gyro_inner = ctx;
};

proto.prepareGyroIndicator = function() {
	var el_gyro_width = this.el_gyro_width;
	//
	var c = document.createElement("canvas");
	c.style.position = "absolute";
	c.style.left = "0px";
	c.style.top = "0px";
	c.style.zIndex = 30;
	c.width = this.el_gyro_width;
	c.height = this.el_gyro_height;
	var ctx = c.getContext("2d");
	//
	var r = c.width * 0.9 / 2;
	var cx = c.width / 2;
	var cy = c.height / 2;
	c.style.transition = this.transition;
	//
	var ctx = c.getContext("2d");
	ctx.beginPath();
	var x = cx;
	var y = cy - r;
	var s = c.width * 0.05;
	var rad60 = 60 * Math.PI / 180;
	ctx.moveTo(x, y);
	ctx.lineTo(x - s * Math.cos(rad60), y + s * Math.sin(rad60));
	ctx.lineTo(x + s * Math.cos(rad60), y + s * Math.sin(rad60));
	ctx.closePath();
	ctx.fillStyle = "#ffffff";
	ctx.fill();
	//
	this.el_gyro_frame.appendChild(c);
	this.canvas_gyro_indicator = c;
	this.ctx_gyro_indicator = ctx;
};

proto.prepareCompassOuter = function() {
	var el_compass_width = this.el_compass_width;
	//
	var c = document.createElement("canvas");
	c.style.position = "absolute";
	c.style.left = "0px";
	c.style.top = "0px";
	c.style.zIndex = 20;
	c.width = this.el_compass_width;
	c.height = this.el_compass_width;
	var ctx = c.getContext("2d");
	//
	var r = c.width * 0.9 / 2;
	var cx = c.width / 2;
	var cy = c.height / 2;
	//
	var line_width_thick = this.el_gyro_width / 100;
	var line_width_thin = line_width_thick / 2;
	// NbsOpX
	(function () {
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(0, 0);
		ctx.lineTo(0, c.height);
		ctx.lineTo(c.width, c.height);
		ctx.lineTo(c.width, 0);
		ctx.closePath();
		ctx.arc(cx, cy, r, 0, Math.PI * 2, false);
		ctx.closePath();
		//
		ctx.clip();
		ctx.fillStyle = "#000000";
		ctx.fill();
	})();
	// ڐij
	(function () {
		ctx.beginPath();
		for( var deg=45; deg<360; deg+=45 ) {
			var rad = deg * Math.PI / 180;
			var sin = Math.sin(rad);
			var cos = Math.cos(rad);
			ctx.moveTo(cx + r * sin,       cy - r * cos);
			ctx.lineTo(cx + r * sin * 1.05, cy - r * cos * 1.05);
		}
		ctx.strokeStyle = "#ffffff";
		ctx.lineWidth = line_width_thin;
		ctx.stroke();
	})();
	// tOp`̃pX𐶐֐IuWFNg
	var makeInvertedTrianglePath = function(ctx, side_len) {
		var x = side_len * Math.cos(Math.PI / 3);
		var y = side_len * Math.sin(Math.PI / 3);
		ctx.moveTo(0, 0);
		ctx.lineTo(x, -y);
		ctx.lineTo(-x, -y);
		ctx.closePath();
	};
	// 㑤ʒ̋tOp`̖ڐ
	(function () {
		ctx.save();
		ctx.translate(cx, cy - r - (el_compass_width / 100));
		ctx.beginPath();
		makeInvertedTrianglePath(ctx, r * 0.1);
		ctx.lineWidth = line_width_thick;
		ctx.stroke();
		ctx.restore();
	})();
	//
	this.el_compass_frame.appendChild(c);
};

proto.prepareCompassInner = function() {
	var c = document.createElement("canvas");
	c.style.position = "absolute";
	c.style.left = "0px";
	c.style.top = "0px";
	c.style.zIndex = 10;
	c.width = this.el_compass_width;
	c.height = this.el_compass_width;
	var ctx = c.getContext("2d");
	//
	var r = c.width * 0.9 / 2;
	var cx = c.width / 2;
	var cy = c.height / 2;
	c.style.transition = this.transition;
	//
	var ctx = c.getContext("2d");
	// background
	ctx.fillStyle = "#000000";
	ctx.fillRect(0, 0, c.width, c.height);
	// indicator
	var line_width_thick = this.el_gyro_width / 100;
	var line_width_thin = line_width_thick / 2;
	var line_length_long = r * 0.15;
	var line_length_short = r * 0.1;
	ctx.strokeStyle = "#ffffff";
	ctx.lineWidth = line_width_thin;
	var base_r = r * 0.95;
	// ڐ
	ctx.beginPath();
	for( var deg=0; deg<360; deg+=5 ) {
		var rad = deg * Math.PI / 180;
		var sin = Math.sin(rad);
		var cos = Math.cos(rad);
		var len = (deg % 10) ? line_length_short : line_length_long;
		var x1 = cx + (base_r * sin);
		var y1 = cy - (base_r * cos);
		var x2 = cx + ((base_r - len) * sin);
		var y2 = cy - ((base_r - len) * cos);
		ctx.moveTo(x1, y1);
		ctx.lineTo(x2, y2);
	}
	ctx.stroke();
	// ڐ莚
	var font_size = parseInt(c.width / 15);
	ctx.font = font_size + "px Arial";
	ctx.textAlign = "center";
	ctx.textBaseline = "top";
	ctx.fillStyle = "#ffffff";
	for( var deg=0; deg<360; deg+=30 ) {
		var n = deg / 10;
		if( deg === 0 ) {
			n = "N";
		} else if( deg === 90 ) {
			n = "E";
		} else if( deg === 180 ) {
			n = "S";
		} else if( deg === 270 ) {
			n = "W";
		}
		ctx.save();
		var rad = deg * Math.PI / 180;
		var radius = (r - line_length_long ) * 0.9;
		ctx.translate(cx + (radius * Math.sin(rad)), cy - (radius * Math.cos(rad)));
		ctx.rotate(rad);
		ctx.fillText(n, 0, 0);
		ctx.restore();
	}
	//
	this.el_compass_frame.appendChild(c);
	this.canvas_compass_inner = c;
	this.ctx_compass_inner = ctx;
};

proto.drawGyro = function() {
	var beta = this.beta - this.beta_offset;
	var gamma = this.gamma - this.gamma_offset;
	var c = this.canvas_gyro_inner;
	var rad = gamma * Math.PI / 180;
	var distance = beta * c.height / 360;
	var x = distance * Math.sin(rad);
	var y = distance * Math.cos(rad);
	c.style.transform = "translate3d(" + x + "px," + y + "px, 0px) rotateZ(" + (-gamma) + "deg)";
	var ci = this.canvas_gyro_indicator;
	ci.style.transform = "rotateZ(" + (-gamma) + "deg)";
	//
	this.el_pich.textContent = Math.round(beta);
	this.el_roll.textContent = Math.round(gamma);
};

proto.drawCompass = function() {
	var alpha = this.alpha;
	if(alpha === null || alpha === undefined) {
		return;
	}
	var prealpha = this.prealpha;
	var c = this.canvas_compass_inner;
	var cross = ( Math.abs(alpha - prealpha) > 180 ) ? true : false;
	if(cross) {
		c.style.transition = "";
	} else {
		c.style.transition = this.transition;
	}
	c.style.transform = "rotateZ(" + (360 - alpha) + "deg)";
	this.prealpha = alpha;
	//
	this.el_heading_degree.textContent = alpha.toFixed(0);
	var string = "N";
	if(alpha < 22.5) {
		string = "N";
	} else if(alpha < 67.5) {
		string = "NE";
	} else if(alpha < 112.5) {
		string = "E";
	} else if(alpha < 157.5) {
		string = "SE";
	} else if(alpha < 202.5) {
		string = "S";
	} else if(alpha < 247.5) {
		string = "SW";
	} else if(alpha < 292.5) {
		string = "W";
	} else if(alpha < 337.5) {
		string = "NW";
	} else {
		string = "N";
	}
	this.el_heading_string.textContent = string;
}
