/* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this
* file, You can obtain one at http://mozilla.org/MPL/2.0/. */ 

$(document).ready(function() {
    /* reset function*/
    $("#reset").click(function(){
        $("select#lc").prop('selectedIndex', 0);
        $("select#vs").prop('selectedIndex', 0);
        $("select#vf").prop('selectedIndex', 0);
        $("#amps").val('20');
        $("#alertbx1").html("Enter basic data and Evaluate to get the resistance value");
    });
    
    /* main app and calculation */
    $("body").delegate('#submit','click',function(){
        var r = 0;
        var t = 0;
        var lc = $("#lc").val();
        var vs = $("#vs").val();
        var vf = $("#vf").val();    
        var amps = $("#amps").val()/1000;
        
        /* values extracted from the inputs 
         * 
         * entering into the main calculation part
        */
        if (vs >= Math.round(lc*vf)) {
            /* calculating the resistance */
            r = (vs - (lc * vf))/amps;      
            r = Math.round(r * 100) / 100;
            
            /* calculating the resistor power rating */
            vs = Math.round(vs);
            if (vs >= 48) {
                t="1w";
            }
            else if (vs < 48 && vs > 24) {
                t="0.5w";
            }
            else {
                t="0.25w";
            }
            
            /* return messages/output */
            if (r >= 0.47) {
                if (r < 470) {
                    $("#alertbx1").html("You need " + r + "Ω (ohms), " + t + " resistor. Tolerance ±5%.");
                }
                else if ((r >= 470) && (r <= 999)) {
                    r = Math.round(r / 100);
                    $("#alertbx1").html("You need " + r + "kΩ (kilo ohms), " + t + " resistor. Tolerance ±10%.");
                }
                else {
                    r = Math.round(r / 1000);
                    $("#alertbx1").html("You need " + r + "MΩ (mega ohms), " + t + " resistor. Tolerance ±20%.");
                }
            }
            else {
                $("#alertbx1").html("Registor not needed. Just connect the power supply with the series circuit");
            }
        }
        else {
            $("#alertbx1").html("Insufficient voltage to operate. Please check.");
        }
    });
});
