/**
 * 
 */

var Collection = function() {
	this.playlist = new Playlist();
	this.covers = new Array;
	this.artists = new Array;
	this.numbers = new Array;
	this.playlists = new Array;
	this.musicClips = new Array;
};

Collection.prototype.addMusicClips = function(xmlDoc) {
	x = xmlDoc.getElementsByTagName("Video");
	for (var y = 0; y < x.length; y++) {
		xP2 = (x[y].getElementsByTagName("Media"));
		xP = (xP2[0].getElementsByTagName("Part"));
		var musicClipBuild = new musicClip(x, y, xP);
		this.musicClips[y] = musicClipBuild;
	}
	finishedCheck();
}

Collection.prototype.addCovers = function(xmlDoc) {
	x = xmlDoc.getElementsByTagName("Directory");
	var vorigenaam = "";
	var o = 0;
	var placeNumber = 0;
	cdMax = x.length + 1;
	for (var y = 0; y < x.length; y++) {
		var coverBuild = new Cover(y, x);
		if (coverBuild.naam == vorigenaam) {
			o++;
		} else {
			this.covers[placeNumber] = coverBuild;
			placeNumber++;
			o = 0;
		}
		var forNext = [ y, o, x, placeNumber ];
		loadXMLDoc("/library/metadata/" + x[y].getAttribute("ratingKey")
				+ "/children?X-Plex-Token=" + token, addCD, 10000, forNext);
		vorigenaam = coverBuild.naam;
	}
}

Collection.prototype.addNummers = function(xml) {
	// Add the numbers
	var k = 0;
	for (var i = 0; i < this.covers.length; i++) {
		for (var y = 0; y < this.covers[i].cds.length; y++) {
			for (var j = 0; j < this.covers[i].cds[y].nummers.length; j++) {
				this.numbers[k] = this.covers[i].cds[y].nummers[j];
				this.playlist.random[k] = this.covers[i].cds[y].nummers[j];
				k++;
			}
		}
	}
	for (var i = 0; i < this.musicClips.length; i++) {
		this.numbers[k] = this.musicClips[i];
		this.playlist.random[k] = this.musicClips[i];
		k++;
	}
	this.addArtist(xml);
}

Collection.prototype.addArtist = function(xmlDoc2) {
	// Artiesten
	x = xmlDoc2.getElementsByTagName("Directory");
	for (var y = 0; y < x.length; y++) {
		var artistBuild = new Artist(y, x);
		this.artists[y] = artistBuild;

		// Add the nummers to artiesten
		k = 0;
		for (var j = 0; j < this.numbers.length; j++) {
			if (this.artists[y].nummer == this.numbers[j].artiestNummer
					&& this.artists[y].sameCheck(this.numbers[j].naam)) {
				this.artists[y].nummers[k] = this.numbers[j];
				k++;
			} else if (this.numbers[j].originalTitle != null && this.numbers[j].is != "musicClip") {
				if (this.numbers[j].originalTitle.latinise().indexOf(
						this.artists[y].naam.latinise()) > -1
						&& this.artists[y].sameCheck(this.numbers[j].naam)) {
					this.artists[y].nummers[k] = this.numbers[j];
					k++;
				}
			} else if (this.numbers[j].naam != null) {
				if (this.numbers[j].sort.latinise().indexOf(
						this.artists[y].naam.latinise()) > -1) {
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + ' - ','');
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + '- ','');
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + '-','');
					
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + ' ~ ','');
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + '~ ','');
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + ': ','');
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(this.artists[y].naam.latinise() + ' ','');
					
					this.numbers[j].naam = this.numbers[j].naam.replace(/"/g,'');
					this.numbers[j].naam = this.numbers[j].naam.replace(/ *\([^)]*\) */g,'');
					this.numbers[j].naam = this.numbers[j].naam.replace(/\[.*?\]\s?/g,'');
					this.numbers[j].naam = this.numbers[j].naam.replace(/ft\..*/g,'');
					this.numbers[j].naam = this.numbers[j].naam.replace(/feat.*/g,'');
					this.numbers[j].naam = this.numbers[j].naam.replace(' - Official Music Video','');
					this.numbers[j].naam = this.numbers[j].naam.latinise().replace(' ' + this.artists[y].naam.latinise(),'');
					
					if (this.numbers[j].is == "musicClip") {
						if (this.numbers[j].originalTitle == undefined) {
							this.numbers[j].originalTitle = this.artists[y].naam;
						} else {
							this.numbers[j].originalTitle = this.numbers[j].originalTitle + " & " + this.artists[y].naam;
						}
					}
					this.artists[y].nummers[k] = this.numbers[j];
					k++;
				}
			}
		}
	}

	for (var y = 0; y < this.artists.length; y++) { //Haal artiesten met 1 nummer weg
		if (this.artists[y].nummers.length == 1) {
			console.log(this.artists[y].naam + " " + this.artists.length);
			this.artists.splice(y, 1);
			this.artists.length - 1;
		}
	}
	
	if (librarySup) {
		loadXMLDoc("/playlists/?X-Plex-Token=" + token, addPlayLists, 10000, "");
	}
}

Collection.prototype.addPlayLists = function(xmlDoc) {
	x = xmlDoc.getElementsByTagName("Playlist");
	var k = 0;
	var l = 1;
	if (x.length == 0) {
		listMax = 1;
		finishedCheckFinal();
	} else {
		for (var i = 0; i < x.length; i++) {
			if (x[i].getAttribute("playlistType") == "audio") {
				this.playlists[l] = new Playlists(x, i, this.numbers, l);
				listMax++;
				k++;
				l++;
			}
		}
	}
	this.playlists[0] = new Playlists();
	this.playlists[0].title = "G4D playlist";
	this.playlists[0].vCount = 40;
	this.playlists[0].composite = "img/icon-128.png";
	this.playlists[0].nummers = new Array;
	this.playlists[0].local = true;
	this.playlists[0].imgCover = this.playlists[0].composite;
	this.sortByProp("vCount", "numbers");
	if (this.numbers.length > 100) {
		var maxG4d = 100;
	} else {
		var maxG4d = this.numbers.length;
	}
	for (var j = 0; j < maxG4d; j++) {
		this.playlists[0].nummers[j] = this.numbers[j];
	}
}

Collection.prototype.sortByProp2 = function(p) {
	return this.numbers.sort(function(a, b) {
		return (a[p] > b[p]) ? 1 : (a[p] < b[p]) ? -1 : 0;
	});
}

Collection.prototype.sortByProp = function(p, wat) {
	return this[wat].sort(function(a, b) {
		if (p == 'lastViewedAt') {
			return (a[p] < b[p]) ? 1 : (a[p] > b[p]) ? -1 : 0;
		} else if (p == 'vCount' || p == 'viewCount') {
			return b[p] - a[p];
		} else {
			return (a[p] > b[p]) ? 1 : (a[p] < b[p]) ? -1 : 0;
		}
	});
}

Collection.prototype.show = function(array) {
	showArray = array;
	sortOn = showArray[0];
	show = showArray[1];
	showNummer = showArray[2];
	menuItem = showArray[3];
	if (window.innerWidth < 500) {
		if (showArray[4] == 0 || typeof showArray[4] == "undefined") {
			showMenu();
		}
		albumWidth = 200;
		maxCovers = 20;
	} else {
		albumWidth = 300;
		maxCovers = 40;
	}
	if (showArray[4] == 0 || typeof showArray[4] == "undefined") {
		document.getElementById('content').scrollTop = 0;
		}
	if (showArray[4] > maxCovers) {
		maxCovers = showArray[4];
	}
	if (maxCovers > this[show].length) {
		maxCovers = this[show].length;
	}
	showArray[4] = maxCovers;
	if (albumOn == true) {
		showCoverDiv(true);
	}
	menuReload(menuItem);
	this.sortByProp(sortOn, show);
	if (show == "musicClips") {
		this.playlist.showed = this[show];
	}
	var divContent = "";
	divContent = divContent + "<ul>";
	for (var i = 0; i < maxCovers; i++) {
		if (show == "playlists") {
			titel = this[show][i].title;
			listOrder = this[show][i].ratingKey;
			imgUrl = urlBase + this[show][i].composite + '/?X-Plex-Token='
					+ localStorage.token;
			if (this[show][i].local == true) {
				imgUrl = this[show][i].composite;
			}
		} else if (show == "covers") {
			listOrder = this[show][i].imgNummer();
			imgUrl = this[show][i].imgCover;
			titel = this[show][i].naam;
		} else if (show == "musicClips") {
			listOrder = this[show][i].key;
			imgUrl = this[show][i].imgCover;
			titel = this[show][i].naam;
		} else {
			titel = this[show][i].naam;
			listOrder = this[show][i].imgNummer();
			imgUrl = urlBase
					+ '/photo/:/transcode?url=http%3A%2F%2F127.0.0.1%3A32400'
					+ this[show][i].thumb + '/&width=' + albumWidth
					+ '&height=' + albumWidth + '&minSize=1&X-Plex-Token='
					+ localStorage.token;
		}
//		if (show == "artists" && this[show][i].nummers.length == 1) {
//			console.log("Don't show: " + this[show][i].naam);
//		} else 
		if (show !== "musicClips"){
			divContent = divContent + '<li class="coverLi" onmousedown="coverAlle.showPlaylist(' + listOrder
			+ ", '" + showNummer + "', " + i + ", '" + show + "', '"
			+ imgUrl + "', '" + this[show][i].naam + "'"
			+ ')"><a><div id="coverWrapper"><div class="coverImg musicImg" id="coverImg" STYLE="data-background-image: url(' + imgUrl + ');><img id="albumCovers"></div><div id="coverTitel">' + titel + '</div></div></a></li>';
		} else {
			divContent = divContent + '<li class="coverLi" onmousedown="coverAlle.play('
					+ "" + i + "" + ')"><a><div id="coverWrapper"><div class="coverImg clipImg" id="coverImg" STYLE="data-background-image: url(' + imgUrl + ');><img id="albumCovers"></div><div id="coverTitel">' + titel + '</div></div></a></li>';
		}

	}
	divContent = divContent + "</ul>";
	var div = document.getElementById('content');
	div.innerHTML = divContent;
	nowShowed = show;
	scherm();
}

Collection.prototype.showPlaylist = function(listOrder, sortOn, cover, show,
		imgUrl, artiestNaam) {
	newAlbum = true;
	if (this.playlist.nowShowsAlbum !== listOrder) {
		newAlbum = false;
	}
	if (sortOn == "artiestNummer") {
		// this.playlist.fillShowed(listOrder, sortOn, this.numbers,
		// artiestNaam);
		this.playlist.showed = this.artists[cover].nummers;
		this.playlist.sortByProp('naam');
	} else if (sortOn == "iets") {
		this.playlist.showed = this.playlists[cover].nummers;
	} else {
		this.playlist.showed = this.covers[cover]
				.fillShowed(this.playlist.showed);
	}
	if (show == "covers") {
		imgUrl = this[show][cover].imgCoverBig;
	}
	this.playlist.showed.show = show;
	this.playlist.showed.imgUrl = imgUrl;
	this.playlist.showed.listOrder = listOrder;
	this.showPlaylistDraw();
}

Collection.prototype.showPlaylistDraw = function(plek) {
	if (window.innerWidth <= 1024 && menuOn == true) {
		showMenu();
	}
	showCoverDiv(newAlbum);
	this.playlist.showCover();
	this.playlist.showList();
	this.playlist.nowShowsAlbum = this.playlist.showed.listOrder;
	scherm();
	if (typeof plek != "undefined") {
		extraSpace = document.getElementById('albumCover').style.height;
		extraSpace = 300 + (plek * 51)
		document.getElementById('albumNummers').scrollTop = extraSpace;
	} else {
		document.getElementById('albumNummers').scrollTop = 0;
	}
}

Collection.prototype.play = function(nummer) {
	console.log("Speelt list shuffle = " + shuffleOn);
	random = false;
	this.playlist.now = this.playlist.showed;
	if (shuffleOn) {
		this.playlist.ordFill(nummer);
		this.playlist.play(0);
	} else {
		this.playlist.ordFill();
		this.playlist.play(nummer);
	}
}

Collection.prototype.randomPlay = function() {
	console.log("Speelt random list");
	random = true;
	this.playlist.now = this.playlist.random;
	this.playlist.ordFill("random");
	this.playlist.play(1);
}

Collection.prototype.addToList = function(i) {
	console.log("Voegt dit nummer aan een playList: " + addingNummer.naam);
	addingNummer.addToList(i);
	if (librarySup) {
		loadXMLDoc("/playlists/?X-Plex-Token=" + token, addPlayLists, 10000, "");
	}
}

Collection.prototype.playControl = function(actie) {
	this.playlist.playControl(actie);
}

Collection.prototype.currentPlaying = function() {
	return this.playlist.nowplays.nummer;
}
Collection.prototype.currentPlayingNummer = function() {
	return this.playlist.nowplaysNumerOrder;
}

Collection.prototype.currentMaxTime = function() {
		return this.playlist.nowplays.tijd;
}