
var Module;
if (typeof Module === 'undefined') Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
if (!Module.expectedDataFileDownloads) {
  Module.expectedDataFileDownloads = 0;
  Module.finishedDataFileDownloads = 0;
}
Module.expectedDataFileDownloads++;
(function() {
    function fetchRemotePackage(packageName, callback, errback) {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', packageName, true);
      xhr.responseType = 'arraybuffer';
      xhr.onprogress = function(event) {
        var url = packageName;
        if (event.loaded && event.total) {
          if (!xhr.addedTotal) {
            xhr.addedTotal = true;
            if (!Module.dataFileDownloads) Module.dataFileDownloads = {};
            Module.dataFileDownloads[url] = {
              loaded: event.loaded,
              total: event.total
            };
          } else {
            Module.dataFileDownloads[url].loaded = event.loaded;
          }
          var total = 0;
          var loaded = 0;
          var num = 0;
          for (var download in Module.dataFileDownloads) {
          var data = Module.dataFileDownloads[download];
            total += data.total;
            loaded += data.loaded;
            num++;
          }
          total = Math.ceil(total * Module.expectedDataFileDownloads/num);
          if (Module['setStatus']) Module['setStatus']('Downloading data... (' + loaded + '/' + total + ')');
        } else if (!Module.dataFileDownloads) {
          if (Module['setStatus']) Module['setStatus']('Downloading data...');
        }
      };
      xhr.onload = function(event) {
        var packageData = xhr.response;
        callback(packageData);
      };
      xhr.send(null);
    };
    function handleError(error) {
      console.error('package error:', error);
    };
      var fetched = null, fetchedCallback = null;
      fetchRemotePackage('gaberln.data', function(data) {
        if (fetchedCallback) {
          fetchedCallback(data);
          fetchedCallback = null;
        } else {
          fetched = data;
        }
      }, handleError);
  function runWithFS() {
function assert(check, msg) {
  if (!check) throw msg + new Error().stack;
}
Module['FS_createPath']('/', 'data', true, true);
    function DataRequest(start, end, crunched, audio) {
      this.start = start;
      this.end = end;
      this.crunched = crunched;
      this.audio = audio;
    }
    DataRequest.prototype = {
      requests: {},
      open: function(mode, name) {
        this.name = name;
        this.requests[name] = this;
        Module['addRunDependency']('fp ' + this.name);
      },
      send: function() {},
      onload: function() {
        var byteArray = this.byteArray.subarray(this.start, this.end);
          this.finish(byteArray);
      },
      finish: function(byteArray) {
        var that = this;
        Module['FS_createPreloadedFile'](this.name, null, byteArray, true, true, function() {
          Module['removeRunDependency']('fp ' + that.name);
        }, function() {
          if (that.audio) {
            Module['removeRunDependency']('fp ' + that.name); // workaround for chromium bug 124926 (still no audio with this, but at least we don't hang)
          } else {
            Module.printErr('Preloading file ' + that.name + ' failed');
          }
        }, false, true); // canOwn this data in the filesystem, it is a slide into the heap that will never change
        this.requests[this.name] = null;
      },
    };
      new DataRequest(0, 58864, 0, 0).open('GET', '/data/CaviarDreams.ttf');
    new DataRequest(58864, 62130, 0, 0).open('GET', '/data/about.png');
    new DataRequest(62130, 69530, 0, 0).open('GET', '/data/ball.png');
    new DataRequest(69530, 120980, 0, 0).open('GET', '/data/dirt.png');
    new DataRequest(120980, 121811, 0, 0).open('GET', '/data/fence.png');
    new DataRequest(121811, 391494, 0, 0).open('GET', '/data/grass.png');
    new DataRequest(391494, 412260, 0, 1).open('GET', '/data/hit-ground.wav');
    new DataRequest(412260, 493964, 0, 1).open('GET', '/data/hit-hacky_sack.wav');
    new DataRequest(493964, 512344, 0, 0).open('GET', '/data/main_menu.png');
    new DataRequest(512344, 536487, 0, 0).open('GET', '/data/overlay.png');
    new DataRequest(536487, 538876, 0, 0).open('GET', '/data/play.png');
    new DataRequest(538876, 636021, 0, 0).open('GET', '/data/shoe.png');
    new DataRequest(636021, 773901, 0, 0).open('GET', '/data/sky.png');
    var PACKAGE_PATH = window['encodeURIComponent'](window.location.pathname.toString().substring(0, window.location.pathname.toString().lastIndexOf('/')) + '/');
    var PACKAGE_NAME = 'gaberln.data';
    var REMOTE_PACKAGE_NAME = 'gaberln.data';
    var PACKAGE_UUID = '03590f04-25f3-4582-8631-cf43c38cb1df';
    function processPackageData(arrayBuffer) {
      Module.finishedDataFileDownloads++;
      assert(arrayBuffer, 'Loading data file failed.');
      var byteArray = new Uint8Array(arrayBuffer);
      var curr;
      // copy the entire loaded file into a spot in the heap. Files will refer to slices in that. They cannot be freed though.
      var ptr = Module['_malloc'](byteArray.length);
      Module['HEAPU8'].set(byteArray, ptr);
      DataRequest.prototype.byteArray = Module['HEAPU8'].subarray(ptr, ptr+byteArray.length);
          DataRequest.prototype.requests["/data/CaviarDreams.ttf"].onload();
          DataRequest.prototype.requests["/data/about.png"].onload();
          DataRequest.prototype.requests["/data/ball.png"].onload();
          DataRequest.prototype.requests["/data/dirt.png"].onload();
          DataRequest.prototype.requests["/data/fence.png"].onload();
          DataRequest.prototype.requests["/data/grass.png"].onload();
          DataRequest.prototype.requests["/data/hit-ground.wav"].onload();
          DataRequest.prototype.requests["/data/hit-hacky_sack.wav"].onload();
          DataRequest.prototype.requests["/data/main_menu.png"].onload();
          DataRequest.prototype.requests["/data/overlay.png"].onload();
          DataRequest.prototype.requests["/data/play.png"].onload();
          DataRequest.prototype.requests["/data/shoe.png"].onload();
          DataRequest.prototype.requests["/data/sky.png"].onload();
          Module['removeRunDependency']('datafile_gaberln.data');
    };
    Module['addRunDependency']('datafile_gaberln.data');
    if (!Module.preloadResults) Module.preloadResults = {};
      Module.preloadResults[PACKAGE_NAME] = {fromCache: false};
      if (fetched) {
        processPackageData(fetched);
        fetched = null;
      } else {
        fetchedCallback = processPackageData;
      }
  }
  if (Module['calledRun']) {
    runWithFS();
  } else {
    if (!Module['preRun']) Module['preRun'] = [];
    Module["preRun"].push(runWithFS); // FS is not initialized yet, wait for it
  }
})();
// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function readBinary(filename) { return Module['read'](filename, true) };
  Module['load'] = function load(f) {
    globalEval(read(f));
  };
  Module['arguments'] = process['argv'].slice(2);
  module['exports'] = Module;
}
else if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }
  Module['readBinary'] = function readBinary(f) {
    return read(f, 'binary');
  };
  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  this['Module'] = Module;
  eval("if (typeof gc === 'function' && gc.toString().indexOf('[native code]') > 0) var gc = undefined"); // wipe out the SpiderMonkey shell 'gc' function, which can confuse closure (uses it as a minified name, and it is then initted to a non-falsey value unexpectedly)
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  if (typeof console !== 'undefined') {
    Module['print'] = function print(x) {
      console.log(x);
    };
    Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }
  if (ENVIRONMENT_IS_WEB) {
    this['Module'] = Module;
  } else {
    Module['load'] = importScripts;
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      return '(((' +target + ')+' + (quantum-1) + ')&' + -quantum + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          if (Types.types[field]) {
            alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
          } else {
            alignSize = type.alignSize || QUANTUM_SIZE;
          }
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else if (field[0] === '<') {
        // vector type
        size = alignSize = Types.types[field].flatSize; // fully aligned
      } else if (field[0] === 'i') {
        // illegal integer field, that could not be legalized because it is an internal structure field
        // it is ok to have such fields, if we just use them as markers of field size and nothing more complex
        size = alignSize = parseInt(field.substr(1))/8;
        assert(size % 1 === 0, 'cannot handle non-byte-size field ' + field);
      } else {
        assert(false, 'invalid type for calculateStructAlignment');
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    if (type.name_[0] === '[') {
      // arrays have 2 elements, so we get the proper difference. then we scale here. that way we avoid
      // allocating a potentially huge array for [999999 x i8] etc.
      type.flatSize = parseInt(type.name_.substr(1))*type.flatSize/2;
    }
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  getAsmConst: function (code, numArgs) {
    // code is a constant string on the heap, so we can cache these
    if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
    var func = Runtime.asmConstCache[code];
    if (func) return func;
    var args = [];
    for (var i = 0; i < numArgs; i++) {
      args.push(String.fromCharCode(36) + i); // $0, $1 etc
    }
    return Runtime.asmConstCache[code] = eval('(function(' + args.join(',') + '){ ' + Pointer_stringify(code) + ' })'); // new Function does not allow upvars in node
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;
      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }
      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function processJSString(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+7)&-8); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+7)&-8); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+7)&-8); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*(+4294967296))) : ((+((low>>>0)))+((+((high|0)))*(+4294967296)))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      value = intArrayFromString(value);
      type = 'array';
    }
    if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
  for(var i = 0; i < str.length; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[(((outPtr)+(i*2))>>1)]=codeUnit
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[(((outPtr)+(str.length*2))>>1)]=0
}
Module['stringToUTF16'] = stringToUTF16;
// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
  var iChar = 0;
  for(var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++iCodeUnit);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[(((outPtr)+(iChar*4))>>2)]=codeUnit
    ++iChar;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[(((outPtr)+(iChar*4))>>2)]=0
}
Module['stringToUTF32'] = stringToUTF32;
function demangle(func) {
  try {
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    var i = 3;
    // params, etc.
    var basicTypes = {
      'v': 'void',
      'b': 'bool',
      'c': 'char',
      's': 'short',
      'i': 'int',
      'l': 'long',
      'f': 'float',
      'd': 'double',
      'w': 'wchar_t',
      'a': 'signed char',
      'h': 'unsigned char',
      't': 'unsigned short',
      'j': 'unsigned int',
      'm': 'unsigned long',
      'x': 'long long',
      'y': 'unsigned long long',
      'z': '...'
    };
    function dump(x) {
      //return;
      if (x) Module.print(x);
      Module.print(func);
      var pre = '';
      for (var a = 0; a < i; a++) pre += ' ';
      Module.print (pre + '^');
    }
    var subs = [];
    function parseNested() {
      i++;
      if (func[i] === 'K') i++; // ignore const
      var parts = [];
      while (func[i] !== 'E') {
        if (func[i] === 'S') { // substitution
          i++;
          var next = func.indexOf('_', i);
          var num = func.substring(i, next) || 0;
          parts.push(subs[num] || '?');
          i = next+1;
          continue;
        }
        if (func[i] === 'C') { // constructor
          parts.push(parts[parts.length-1]);
          i += 2;
          continue;
        }
        var size = parseInt(func.substr(i));
        var pre = size.toString().length;
        if (!size || !pre) { i--; break; } // counter i++ below us
        var curr = func.substr(i + pre, size);
        parts.push(curr);
        subs.push(curr);
        i += pre + size;
      }
      i++; // skip E
      return parts;
    }
    var first = true;
    function parse(rawList, limit, allowVoid) { // main parser
      limit = limit || Infinity;
      var ret = '', list = [];
      function flushList() {
        return '(' + list.join(', ') + ')';
      }
      var name;
      if (func[i] === 'N') {
        // namespaced N-E
        name = parseNested().join('::');
        limit--;
        if (limit === 0) return rawList ? [name] : name;
      } else {
        // not namespaced
        if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
        var size = parseInt(func.substr(i));
        if (size) {
          var pre = size.toString().length;
          name = func.substr(i + pre, size);
          i += pre + size;
        }
      }
      first = false;
      if (func[i] === 'I') {
        i++;
        var iList = parse(true);
        var iRet = parse(true, 1, true);
        ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
      } else {
        ret = name;
      }
      paramLoop: while (i < func.length && limit-- > 0) {
        //dump('paramLoop');
        var c = func[i++];
        if (c in basicTypes) {
          list.push(basicTypes[c]);
        } else {
          switch (c) {
            case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
            case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
            case 'L': { // literal
              i++; // skip basic type
              var end = func.indexOf('E', i);
              var size = end - i;
              list.push(func.substr(i, size));
              i += size + 2; // size + 'EE'
              break;
            }
            case 'A': { // array
              var size = parseInt(func.substr(i));
              i += size.toString().length;
              if (func[i] !== '_') throw '?';
              i++; // skip _
              list.push(parse(true, 1, true)[0] + ' [' + size + ']');
              break;
            }
            case 'E': break paramLoop;
            default: ret += '?' + c; break paramLoop;
          }
        }
      }
      if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
      return rawList ? list : ret + flushList();
    }
    return parse();
  } catch(e) {
    return func;
  }
}
function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}
function stackTrace() {
  var stack = new Error().stack;
  return stack ? demangleAll(stack) : '(no stack trace available)'; // Stack trace is not available at least on IE10 and Safari 6.
}
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return (x+4095)&-4096;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=str.charCodeAt(i)
  }
  if (!dontAddNull) HEAP8[(((buffer)+(str.length))|0)]=0
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
var memoryInitializer = null;
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 11624;
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } });
var __ZTVN10__cxxabiv120__si_class_type_infoE;
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,160,21,0,0,92,0,0,0,22,0,0,0,100,0,0,0,32,0,0,0,2,0,0,0,6,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZTVN10__cxxabiv117__class_type_infoE;
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,176,21,0,0,92,0,0,0,88,0,0,0,100,0,0,0,32,0,0,0,2,0,0,0,2,0,0,0,6,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZN4BallC1EP4GameP8Renderer;
var __ZN4BallD1Ev;
var __ZN5FieldC1EP4GameP8Renderer;
var __ZN4GameC1EP8Renderer;
var __ZN4GameD1Ev;
var __ZN8TextAreaD1Ev;
var __ZN4MenuC1EP4GameP8Renderer;
var __ZN18OpenGLTextureImageC1EiiPv;
var __ZN4ShoeC1EP8Renderer;
var __ZN8TimestepC1Ef;
/* memory initializer */ allocate([168,8,0,0,0,0,0,0,248,6,0,0,0,0,0,0,70,97,105,108,101,100,32,116,111,32,108,105,110,107,32,112,114,111,103,114,97,109,33,0,48,5,0,0,0,0,0,0,8,10,0,0,0,0,0,0,80,73,67,84,0,0,0,0,104,109,116,120,0,0,0,0,83,128,246,52,0,0,0,0,98,97,100,32,102,111,114,109,97,116,0,0,0,0,0,0,114,101,113,95,99,111,109,112,32,62,61,32,49,32,38,38,32,114,101,113,95,99,111,109,112,32,60,61,32,52,0,0,98,97,100,32,102,105,108,101,0,0,0,0,0,0,0,0,98,97,100,32,112,97,108,101,116,116,101,0,0,0,0,0,98,97,100,32,99,111,109,112,114,101,115,115,105,111,110,0,110,111,32,112,114,101,115,101,116,32,100,105,99,116,0,0,98,97,100,32,122,108,105,98,32,104,101,97,100,101,114,0,114,101,97,100,32,112,97,115,116,32,98,117,102,102,101,114,0,0,0,0,0,0,0,0,104,116,116,112,58,47,47,116,104,112,46,105,111,47,50,48,49,49,47,103,97,98,101,114,108,110,47,0,0,0,0,0,122,108,105,98,32,99,111,114,114,117,112,116,0,0,0,0,104,104,101,97,0,0,0,0,97,45,62,110,117,109,95,98,105,116,115,32,61,61,32,48,0,0,0,0,0,0,0,0,115,105,122,101,115,91,105,93,32,60,61,32,40,49,32,60,60,32,105,41,0,0,0,0,98,97,100,32,99,111,100,101,108,101,110,103,116,104,115,0,99,111,108,111,114,0,0,0,99,32,61,61,32,49,56,0,67,43,43,49,49,32,47,32,79,112,101,110,71,76,0,0,99,32,62,61,32,48,32,38,38,32,99,32,60,32,49,57,0,0,0,0,0,0,0,0,122,45,62,99,111,100,101,95,98,117,102,102,101,114,32,60,32,40,49,85,32,60,60,32,122,45,62,110,117,109,95,98,105,116,115,41,0,0,0,0,122,45,62,115,105,122,101,91,98,93,32,61,61,32,115,0,111,117,116,112,117,116,32,98,117,102,102,101,114,32,108,105,109,105,116,0,0,0,0,0,49,0,0,0,0,0,0,0,98,97,100,32,100,105,115,116,0,0,0,0,0,0,0,0,103,108,121,102,0,0,0,0,100,97,116,97,47,67,97,118,105,97,114,68,114,101,97,109,115,46,116,116,102,0,0,0,98,97,100,32,104,117,102,102,109,97,110,32,99,111,100,101,0,0,0,0,0,0,0,0,35,63,82,65,68,73,65,78,67,69,10,0,0,0,0,0,105,110,118,97,108,105,100,32,100,101,99,111,100,101,100,32,115,99,97,110,108,105,110,101,32,108,101,110,103,116,104,0,112,114,111,106,101,99,116,105,111,110,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,100,97,116,97,32,108,97,121,111,117,116,0,117,110,115,117,112,112,111,114,116,101,100,32,102,111,114,109,97,116,0,0,0,0,0,0,110,111,116,32,72,68,82,0,88,68,71,95,68,65,84,65,95,72,79,77,69,0,0,0,98,97,100,32,99,111,100,101,32,108,101,110,103,116,104,115,0,0,0,0,0,0,0,0,98,97,100,32,68,72,84,32,104,101,97,100,101,114,0,0,98,97,100,32,68,81,84,32,116,97,98,108,101,0,0,0,32,0,0,0,0,0,0,0,98,97,100,32,68,81,84,32,116,121,112,101,0,0,0,0,104,101,97,100,0,0,0,0,98,97,100,32,68,82,73,32,108,101,110,0,0,0,0,0,100,97,116,97,47,37,115,0,112,114,111,103,114,101,115,115,105,118,101,32,106,112,101,103,0,0,0,0,0,0,0,0,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,98,97,100,32,84,81,0,0,98,97,100,32,86,0,0,0,98,97,100,32,72,0,0,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,73,68,0,0,0,0,0,0,0,0,115,116,100,58,58,101,120,99,101,112,116,105,111,110,0,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,0,0,0,0,48,32,119,105,100,116,104,0,71,114,97,112,104,105,99,115,58,32,84,105,109,32,83,97,109,111,102,102,32,40,115,97,109,111,102,102,46,99,111,109,41,0,0,0,0,0,0,0,110,111,32,104,101,97,100,101,114,32,104,101,105,103,104,116,0,0,0,0,0,0,0,0,108,111,99,97,0,0,0,0,111,110,108,121,32,56,45,98,105,116,0,0,0,0,0,0,98,97,100,32,83,79,70,32,108,101,110,0,0,0,0,0,114,98,0,0,0,0,0,0,115,104,111,101,46,112,110,103,0,0,0,0,0,0,0,0,110,111,32,83,79,70,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,110,111,32,83,79,73,0,0,98,97,100,32,112,110,103,32,115,105,103,0,0,0,0,0,105,109,103,95,110,43,49,32,61,61,32,111,117,116,95,110,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,102,105,108,116,101,114,0,0,110,111,116,32,101,110,111,117,103,104,32,112,105,120,101,108,115,0,0,0,0,0,0,0,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,32,124,124,32,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,43,49,0,0,0,0,0,0,0,0,67,111,100,101,58,32,84,104,111,109,97,115,32,80,101,114,108,32,40,116,104,112,46,105,111,41,0,0,0,0,0,0,111,117,116,95,110,32,61,61,32,50,32,124,124,32,111,117,116,95,110,32,61,61,32,52,0,0,0,0,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,10,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,32,42,32,112,114,111,106,101,99,116,105,111,110,59,10,125,10,0,0,0,99,109,97,112,0,0,0,0,46,46,47,115,114,99,47,115,116,98,95,108,111,97,100,101,114,47,115,116,98,95,105,109,97,103,101,46,99,0,0,0,46,47,46,37,115,0,0,0,115,45,62,105,109,103,95,111,117,116,95,110,32,61,61,32,52,0,0,0,0,0,0,0,110,111,32,73,68,65,84,0,111,117,116,111,102,100,97,116,97,0,0,0,0,0,0,0,111,117,116,111,102,109,101,109,0,0,0,0,0,0,0,0,71,97,98,101,114,108,110,32,50,46,48,46,49,0,0,0,110,111,32,80,76,84,69,0,116,82,78,83,32,119,105,116,104,32,97,108,112,104,97,0,37,115,47,103,97,98,101,114,108,110,46,115,97,118,0,0,98,97,100,32,116,82,78,83,32,108,101,110,0,0,0,0,116,82,78,83,32,98,101,102,111,114,101,32,80,76,84,69,0,0,0,0,0,0,0,0,115,107,121,46,112,110,103,0,116,82,78,83,32,97,102,116,101,114,32,73,68,65,84,0,105,110,118,97,108,105,100,32,80,76,84,69,0,0,0,0,102,105,114,115,116,32,110,111,116,32,73,72,68,82,0,0,37,115,47,46,108,111,99,97,108,47,115,104,97,114,101,47,37,115,0,0,0,0,0,0,102,101,110,99,101,46,112,110,103,0,0,0,0,0,0,0,48,45,112,105,120,101,108,32,105,109,97,103,101,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,10,117,110,105,102,111,114,109,32,118,101,99,52,32,99,111,108,111,114,59,10,117,110,105,102,111,114,109,32,115,97,109,112,108,101,114,50,68,32,115,97,109,112,108,101,114,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,116,101,120,116,117,114,101,50,68,40,115,97,109,112,108,101,114,44,32,116,101,120,41,32,42,32,99,111,108,111,114,59,10,125,10,0,98,97,100,32,105,110,116,101,114,108,97,99,101,32,109,101,116,104,111,100,0,0,0,0,98,97,100,32,102,105,108,116,101,114,32,109,101,116,104,111,100,0,0,0,0,0,0,0,98,97,100,32,99,111,109,112,32,109,101,116,104,111,100,0,45,0,0,0,0,0,0,0,109,97,105,110,95,109,101,110,117,46,112,110,103,0,0,0,98,97,100,32,99,116,121,112,101,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,114,98,0,0,0,0,0,0,56,98,105,116,32,111,110,108,121,0,0,0,0,0,0,0,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,0,104,105,116,45,104,97,99,107,121,95,115,97,99,107,46,119,97,118,0,0,0,0,0,0,98,97,100,32,73,72,68,82,32,108,101,110,0,0,0,0,117,110,107,110,111,119,110,32,105,109,97,103,101,32,116,121,112,101,0,0,0,0,0,0,109,117,108,116,105,112,108,101,32,73,72,68,82,0,0,0,72,79,77,69,0,0,0,0,110,111,116,32,71,73,70,0,103,114,97,115,115,46,112,110,103,0,0,0,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,10,97,116,116,114,105,98,117,116,101,32,118,101,99,50,32,116,101,120,99,111,111,114,100,59,10,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,10,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,32,42,32,112,114,111,106,101,99,116,105,111,110,59,10,32,32,32,116,101,120,32,61,32,116,101,120,99,111,111,114,100,59,10,125,10,0,0,0,0,0,0,43,88,32,0,0,0,0,0,45,89,32,0,0,0,0,0,97,98,111,117,116,46,112,110,103,0,0,0,0,0,0,0,70,79,82,77,65,84,61,51,50,45,98,105,116,95,114,108,101,95,114,103,98,101,0,0,35,63,82,65,68,73,65,78,67,69,0,0,0,0,0,0,119,98,0,0,0,0,0,0,104,105,116,45,103,114,111,117,110,100,46,119,97,118,0,0,101,45,62,121,48,32,60,61,32,115,116,97,114,116,95,112,111,105,110,116,0,0,0,0,37,100,0,0,0,0,0,0,122,45,62,118,97,108,105,100,0,0,0,0,0,0,0,0,37,115,47,37,115,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,117,110,105,102,111,114,109,32,118,101,99,52,32,99,111,108,111,114,59,10,10,118,111,105,100,32,109,97,105,110,40,41,10,123,10,32,32,32,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,99,111,108,111,114,59,10,125,10,0,0,0,0,0,0,0,0,100,105,114,116,46,112,110,103,0,0,0,0,0,0,0,0,117,110,105,99,111,100,101,95,99,111,100,101,112,111,105,110,116,32,60,61,32,116,116,85,83,72,79,82,84,40,100,97,116,97,32,43,32,101,110,100,67,111,117,110,116,32,43,32,50,42,105,116,101,109,41,0,112,108,97,121,46,112,110,103,0,0,0,0,0,0,0,0,46,46,47,115,114,99,47,115,116,98,95,108,111,97,100,101,114,47,115,116,98,95,116,114,117,101,116,121,112,101,46,104,0,0,0,0,0,0,0,0,98,97,100,32,83,79,83,0,98,97,100,32,65,67,32,104,117,102,102,0,0,0,0,0,98,97,100,32,68,67,32,104,117,102,102,0,0,0,0,0,98,97,100,32,83,79,83,32,108,101,110,0,0,0,0,0,98,97,100,32,83,79,83,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,40,40,40,106,45,62,99,111,100,101,95,98,117,102,102,101,114,41,32,62,62,32,40,51,50,32,45,32,104,45,62,115,105,122,101,91,99,93,41,41,32,38,32,98,109,97,115,107,91,104,45,62,115,105,122,101,91,99,93,93,41,32,61,61,32,104,45,62,99,111,100,101,91,99,93,0,0,0,0,0,98,97,100,32,114,101,113,95,99,111,109,112,0,0,0,0,48,0,0,0,0,0,0,0,98,97,100,32,109,97,115,107,115,0,0,0,0,0,0,0,98,97,100,32,98,112,112,0,105,110,118,97,108,105,100,0,104,115,122,32,61,61,32,49,48,56,0,0,0,0,0,0,66,77,80,32,82,76,69,0,109,111,110,111,99,104,114,111,109,101,0,0,0,0,0,0,98,97,100,32,66,77,80,0,117,110,107,110,111,119,110,32,66,77,80,0,0,0,0,0,110,111,116,32,66,77,80,0,105,108,108,101,103,97,108,32,99,111,100,101,32,105,110,32,114,97,115,116,101,114,0,0,109,97,120,112,0,0,0,0,107,101,114,110,0,0,0,0,116,111,111,32,109,97,110,121,32,99,111,100,101,115,0,0,110,111,32,99,108,101,97,114,32,99,111,100,101,0,0,0,117,110,107,110,111,119,110,32,99,111,100,101,0,0,0,0,109,105,115,115,105,110,103,32,99,111,108,111,114,32,116,97,98,108,101,0,0,0,0,0,98,97,100,32,73,109,97,103,101,32,68,101,115,99,114,105,112,116,111,114,0,0,0,0,119,114,111,110,103,32,99,111,108,111,114,32,102,111,114,109,97,116,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,98,105,116,32,100,101,112,116,104,0,0,0,119,114,111,110,103,32,99,104,97,110,110,101,108,32,99,111,117,110,116,0,0,0,0,0,119,114,111,110,103,32,118,101,114,115,105,111,110,0,0,0,110,111,116,32,80,83,68,0,66,101,115,116,32,83,99,111,114,101,58,32,37,100,0,0,111,118,101,114,108,97,121,46,112,110,103,0,0,0,0,0,98,97,108,108,46,112,110,103,0,0,0,0,0,0,0,0,115,116,98,116,116,95,71,101,116,71,108,121,112,104,83,104,97,112,101,0,0,0,0,0,115,116,98,116,116,95,70,105,110,100,71,108,121,112,104,73,110,100,101,120,0,0,0,0,102,105,108,108,95,98,105,116,115,0,0,0,0,0,0,0,98,109,112,95,108,111,97,100,0,0,0,0,0,0,0,0,100,101,99,111,100,101,0,0,115,116,98,116,116,95,95,114,97,115,116,101,114,105,122,101,95,115,111,114,116,101,100,95,101,100,103,101,115,0,0,0,112,97,114,115,101,95,117,110,99,111,109,112,114,101,115,115,101,100,95,98,108,111,99,107,0,0,0,0,0,0,0,0,99,111,109,112,117,116,101,95,104,117,102,102,109,97,110,95,99,111,100,101,115,0,0,0,99,114,101,97,116,101,95,112,110,103,95,105,109,97,103,101,95,114,97,119,0,0,0,0,99,111,109,112,117,116,101,95,116,114,97,110,115,112,97,114,101,110,99,121,0,0,0,0,122,104,117,102,102,109,97,110,95,100,101,99,111,100,101,0,122,98,117,105,108,100,95,104,117,102,102,109,97,110,0,0,115,116,98,105,95,100,101,95,105,112,104,111,110,101,0,0,99,111,110,118,101,114,116,95,102,111,114,109,97,116,0,0,110,101,119,95,97,99,116,105,118,101,0,0,0,0,0,0,0,0,0,0,240,14,0,0,94,0,0,0,110,0,0,0,8,0,0,0,22,0,0,0,30,0,0,0,108,0,0,0,82,0,0,0,8,0,0,0,6,0,0,0,0,0,0,0,90,78,52,71,97,109,101,54,114,101,110,100,101,114,69,118,69,51,36,95,48,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,71,97,109,101,54,114,101,110,100,101,114,69,118,69,51,36,95,48,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,70,118,118,69,69,69,0,0,0,0,0,0,0,0,0,0,0,128,14,0,0,0,0,0,0,152,14,0,0,136,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,137,80,78,71,13,10,26,10,88,88,88,88,32,99,104,117,110,107,32,110,111,116,32,107,110,111,119,110,0,0,0,0,0,0,0,0,104,21,0,0,48,0,0,0,84,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,21,0,0,90,0,0,0,14,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,21,0,0,92,0,0,0,106,0,0,0,100,0,0,0,32,0,0,0,2,0,0,0,4,0,0,0,4,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,21,0,0,60,0,0,0,80,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,21,0,0,20,0,0,0,4,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,21,0,0,104,0,0,0,56,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,54,0,0,0,114,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,22,0,0,50,0,0,0,102,0,0,0,34,0,0,0,10,0,0,0,220,255,255,255,24,22,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,22,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,22,0,0,52,0,0,0,24,0,0,0,6,0,0,0,24,0,0,0,220,255,255,255,88,22,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,22,0,0,2,0,0,0,40,0,0,0,26,0,0,0,20,0,0,0,220,255,255,255,120,22,0,0,4,0,0,0,64,0,0,0,78,0,0,0,14,0,0,0,216,255,255,255,120,22,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,22,0,0,26,0,0,0,62,0,0,0,10,0,0,0,14,0,0,0,252,255,255,255,160,22,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,22,0,0,28,0,0,0,74,0,0,0,42,0,0,0,2,0,0,0,220,255,255,255,176,22,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,22,0,0,16,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,22,0,0,16,0,0,0,70,0,0,0,86,0,0,0,14,0,0,0,252,255,255,255,224,22,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,16,0,0,0,76,0,0,0,46,0,0,0,14,0,0,0,252,255,255,255,0,23,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,23,0,0,66,0,0,0,18,0,0,0,2,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,38,0,0,0,6,0,0,0,2,0,0,0,2,0,0,0,10,0,0,0,8,0,0,0,2,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,23,0,0,98,0,0,0,72,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,23,0,0,12,0,0,0,58,0,0,0,2,0,0,0,12,0,0,0,2,0,0,0,6,0,0,0,4,0,0,0,38,0,0,0,6,0,0,0,2,0,0,0,2,0,0,0,10,0,0,0,8,0,0,0,2,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,78,83,116,51,95,95,49,49,55,98,97,100,95,102,117,110,99,116,105,111,110,95,99,97,108,108,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,118,118,69,69,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,57,73,109,97,103,101,73,116,101,109,0,0,0,0,0,0,56,84,101,120,116,73,116,101,109,0,0,0,0,0,0,0,56,84,101,120,116,65,114,101,97,0,0,0,0,0,0,0,56,83,68,76,83,111,117,110,100,0,0,0,0,0,0,0,56,82,101,110,100,101,114,101,114,0,0,0,0,0,0,0,54,66,117,116,116,111,110,0,53,83,111,117,110,100,0,0,53,73,109,97,103,101,0,0,53,70,105,101,108,100,0,0,52,83,104,111,101,0,0,0,52,77,101,110,117,0,0,0,52,73,116,101,109,0,0,0,52,71,97,109,101,0,0,0,52,66,97,108,108,0,0,0,49,56,79,112,101,110,71,76,84,101,120,116,117,114,101,73,109,97,103,101,0,0,0,0,49,54,69,118,101,110,116,66,114,111,97,100,99,97,115,116,101,114,0,0,0,0,0,0,49,52,83,68,76,69,118,101,110,116,83,111,117,114,99,101,0,0,0,0,0,0,0,0,49,52,79,112,101,110,71,76,82,101,110,100,101,114,101,114,0,0,0,0,0,0,0,0,49,51,69,118,101,110,116,76,105,115,116,101,110,101,114,0,49,50,80,97,114,97,108,108,97,120,73,116,101,109,0,0,49,49,83,68,76,82,101,110,100,101,114,101,114,0,0,0,49,49,69,118,101,110,116,83,111,117,114,99,101,0,0,0,0,0,0,0,8,19,0,0,0,0,0,0,24,19,0,0,0,0,0,0,40,19,0,0,96,21,0,0,0,0,0,0,0,0,0,0,56,19,0,0,96,21,0,0,0,0,0,0,0,0,0,0,88,19,0,0,0,0,0,0,128,19,0,0,176,21,0,0,0,0,0,0,0,0,0,0,168,19,0,0,176,21,0,0,0,0,0,0,0,0,0,0,208,19,0,0,192,21,0,0,0,0,0,0,0,0,0,0,248,19,0,0,88,21,0,0,0,0,0,0,0,0,0,0,32,20,0,0,152,22,0,0,0,0,0,0,0,0,0,0,48,20,0,0,208,21,0,0,0,0,0,0,0,0,0,0,64,20,0,0,152,22,0,0,0,0,0,0,0,0,0,0,80,20,0,0,56,22,0,0,0,0,0,0,0,0,0,0,96,20,0,0,8,16,0,0,112,20,0,0,0,0,0,0,2,0,0,0,208,21,0,0,2,0,0,0,32,23,0,0,2,36,0,0,0,0,0,0,120,20,0,0,0,0,0,0,128,20,0,0,0,0,0,0,136,20,0,0,32,23,0,0,0,0,0,0,8,16,0,0,144,20,0,0,0,0,0,0,2,0,0,0,208,21,0,0,2,0,0,0,32,23,0,0,2,36,0,0,8,16,0,0,152,20,0,0,0,0,0,0,2,0,0,0,208,21,0,0,2,0,0,0,224,22,0,0,2,36,0,0,0,0,0,0,160,20,0,0,0,0,0,0,168,20,0,0,224,22,0,0,0,0,0,0,8,16,0,0,176,20,0,0,0,0,0,0,2,0,0,0,208,21,0,0,2,0,0,0,32,23,0,0,2,36,0,0,0,0,0,0,184,20,0,0,64,22,0,0,0,0,0,0,8,16,0,0,208,20,0,0,0,0,0,0,2,0,0,0,32,23,0,0,2,0,0,0,72,23,0,0,2,4,0,0,0,0,0,0,232,20,0,0,224,22,0,0,0,0,0,0,0,0,0,0,0,21,0,0,16,22,0,0,0,0,0,0,0,0,0,0,24,21,0,0,0,0,0,0,40,21,0,0,208,21,0,0,0,0,0,0,0,0,0,0,56,21,0,0,16,23,0,0,0,0,0,0,0,0,0,0,72,21,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,7,0,0,0,9,0,0,0,13,0,0,0,17,0,0,0,25,0,0,0,33,0,0,0,49,0,0,0,65,0,0,0,97,0,0,0,129,0,0,0,193,0,0,0,1,1,0,0,129,1,0,0,1,2,0,0,1,3,0,0,1,4,0,0,1,6,0,0,1,8,0,0,1,12,0,0,1,16,0,0,1,24,0,0,1,32,0,0,1,48,0,0,1,64,0,0,1,96,0,0,0,0,0,0,0,0,0,0,0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,255,1,0,0,255,3,0,0,255,7,0,0,255,15,0,0,255,31,0,0,255,63,0,0,255,127,0,0,255,255,0,0,0,0,0,0,0,1,0,5,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,27,0,0,0,31,0,0,0,35,0,0,0,43,0,0,0,51,0,0,0,59,0,0,0,67,0,0,0,83,0,0,0,99,0,0,0,115,0,0,0,131,0,0,0,163,0,0,0,195,0,0,0,227,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,46,186,232,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  function ___gxx_personality_v0() {
    }
  var _fabsf=Math_abs;
  var _sqrtf=Math_sqrt;
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            continue;
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          if (stream.tty.output.length) {
            stream.tty.ops.put_char(stream.tty, 10);
          }
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              result = process['stdin']['read']();
              if (!result) {
                if (process['stdin']['_readableState'] && process['stdin']['_readableState']['ended']) {
                  return null;  // EOF
                }
                return undefined;  // no data available
              }
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }}};
  var MEMFS={ops_table:null,CONTENT_OWNING:1,CONTENT_FLEXIBLE:2,CONTENT_FIXED:3,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 0777, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            },
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.contents = [];
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },ensureFlexible:function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
          var contents = node.contents;
          node.contents = Array.prototype.slice.call(contents);
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.contents.length;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            if (attr.size < contents.length) contents.length = attr.size;
            else while (attr.size > contents.length) contents.push(0);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 0777 | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else
          {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          var node = stream.node;
          node.timestamp = Date.now();
          var contents = node.contents;
          if (length && contents.length === 0 && position === 0 && buffer.subarray) {
            // just replace it with the new data
            if (canOwn && offset === 0) {
              node.contents = buffer; // this could be a subarray of Emscripten HEAP, or allocated from some other source.
              node.contentMode = (buffer.buffer === HEAP8.buffer) ? MEMFS.CONTENT_OWNING : MEMFS.CONTENT_FIXED;
            } else {
              node.contents = new Uint8Array(buffer.subarray(offset, offset+length));
              node.contentMode = MEMFS.CONTENT_FIXED;
            }
            return length;
          }
          MEMFS.ensureFlexible(node);
          var contents = node.contents;
          while (contents.length < position) contents.push(0);
          for (var i = 0; i < length; i++) {
            contents[position + i] = buffer[offset + i];
          }
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.contents.length;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.ungotten = [];
          stream.position = position;
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.ensureFlexible(stream.node);
          var contents = stream.node.contents;
          var limit = offset + length;
          while (limit > contents.length) contents.push(0);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        }}};
  var IDBFS={dbs:{},indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },reconcile:function (src, dst, callback) {
        var total = 0;
        var create = {};
        for (var key in src.files) {
          if (!src.files.hasOwnProperty(key)) continue;
          var e = src.files[key];
          var e2 = dst.files[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create[key] = e;
            total++;
          }
        }
        var remove = {};
        for (var key in dst.files) {
          if (!dst.files.hasOwnProperty(key)) continue;
          var e = dst.files[key];
          var e2 = src.files[key];
          if (!e2) {
            remove[key] = e;
            total++;
          }
        }
        if (!total) {
          // early out
          return callback(null);
        }
        var completed = 0;
        function done(err) {
          if (err) return callback(err);
          if (++completed >= total) {
            return callback(null);
          }
        };
        // create a single transaction to handle and IDB reads / writes we'll need to do
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        transaction.onerror = function transaction_onerror() { callback(this.error); };
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
        for (var path in create) {
          if (!create.hasOwnProperty(path)) continue;
          var entry = create[path];
          if (dst.type === 'local') {
            // save file to local
            try {
              if (FS.isDir(entry.mode)) {
                FS.mkdir(path, entry.mode);
              } else if (FS.isFile(entry.mode)) {
                var stream = FS.open(path, 'w+', 0666);
                FS.write(stream, entry.contents, 0, entry.contents.length, 0, true /* canOwn */);
                FS.close(stream);
              }
              done(null);
            } catch (e) {
              return done(e);
            }
          } else {
            // save file to IDB
            var req = store.put(entry, path);
            req.onsuccess = function req_onsuccess() { done(null); };
            req.onerror = function req_onerror() { done(this.error); };
          }
        }
        for (var path in remove) {
          if (!remove.hasOwnProperty(path)) continue;
          var entry = remove[path];
          if (dst.type === 'local') {
            // delete file from local
            try {
              if (FS.isDir(entry.mode)) {
                // TODO recursive delete?
                FS.rmdir(path);
              } else if (FS.isFile(entry.mode)) {
                FS.unlink(path);
              }
              done(null);
            } catch (e) {
              return done(e);
            }
          } else {
            // delete file from IDB
            var req = store.delete(path);
            req.onsuccess = function req_onsuccess() { done(null); };
            req.onerror = function req_onerror() { done(this.error); };
          }
        }
      },getLocalSet:function (mount, callback) {
        var files = {};
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
        var check = FS.readdir(mount.mountpoint)
          .filter(isRealDir)
          .map(toAbsolute(mount.mountpoint));
        while (check.length) {
          var path = check.pop();
          var stat, node;
          try {
            var lookup = FS.lookupPath(path);
            node = lookup.node;
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path)
              .filter(isRealDir)
              .map(toAbsolute(path)));
            files[path] = { mode: stat.mode, timestamp: stat.mtime };
          } else if (FS.isFile(stat.mode)) {
            files[path] = { contents: node.contents, mode: stat.mode, timestamp: stat.mtime };
          } else {
            return callback(new Error('node type not supported'));
          }
        }
        return callback(null, { type: 'local', files: files });
      },getDB:function (name, callback) {
        // look it up in the cache
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        req.onupgradeneeded = function req_onupgradeneeded() {
          db = req.result;
          db.createObjectStore(IDBFS.DB_STORE_NAME);
        };
        req.onsuccess = function req_onsuccess() {
          db = req.result;
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function req_onerror() {
          callback(this.error);
        };
      },getRemoteSet:function (mount, callback) {
        var files = {};
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function transaction_onerror() { callback(this.error); };
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          store.openCursor().onsuccess = function store_openCursor_onsuccess(event) {
            var cursor = event.target.result;
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, files: files });
            }
            files[cursor.key] = cursor.value;
            cursor.continue();
          };
        });
      }};
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so 
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          return flags;
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.position = position;
          return position;
        }}};
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      // we don't currently perform any user-space buffering of data
    }var FS={root:null,mounts:[],devices:[null],streams:[null],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:null,genericErrors:{},handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || { recurse_count: 0 };
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
        // start at the root
        var current = FS.root;
        var current_path = '/';
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            current = current.mount.root;
          }
          // follow symlinks
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
            this.parent = null;
            this.mount = null;
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            FS.hashAddNode(this);
          };
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
          FS.FSNode.prototype = {};
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); },
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); },
            },
          });
        }
        return new FS.FSNode(parent, name, mode, rdev);
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 2097155;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        return FS.nodePermissions(dir, 'x');
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 1;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        if (stream.__proto__) {
          // reuse the object
          stream.__proto__ = FS.FSStream.prototype;
        } else {
          var newStream = new FS.FSStream();
          for (var p in stream) {
            newStream[p] = stream[p];
          }
          stream = newStream;
        }
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
        var completed = 0;
        var total = FS.mounts.length;
        function done(err) {
          if (err) {
            return callback(err);
          }
          if (++completed >= total) {
            callback(null);
          }
        };
        // sync all mounts
        for (var i = 0; i < FS.mounts.length; i++) {
          var mount = FS.mounts[i];
          if (!mount.type.syncfs) {
            done(null);
            continue;
          }
          mount.type.syncfs(mount, populate, done);
        }
      },mount:function (type, opts, mountpoint) {
        var lookup;
        if (mountpoint) {
          lookup = FS.lookupPath(mountpoint, { follow: false });
          mountpoint = lookup.path;  // use the absolute path
        }
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          root: null
        };
        // create a root node for the fs
        var root = type.mount(mount);
        root.mount = mount;
        mount.root = root;
        // assign the mount info to the mountpoint's node
        if (lookup) {
          lookup.node.mount = mount;
          lookup.node.mounted = true;
          // compatibility update FS.root if we mount to /
          if (mountpoint === '/') {
            FS.root = mount.root;
          }
        }
        // add to our cached list of mounts
        FS.mounts.push(mount);
        return root;
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 0666;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 0777;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 0666;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function (path) {
        var lookup = FS.lookupPath(path, { follow: false });
        var link = lookup.node;
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 0666 : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.errnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = '';
          var utf8 = new Runtime.UTF8Processor();
          for (var i = 0; i < length; i++) {
            ret += utf8.processCChar(buf[i]);
          }
        } else if (opts.encoding === 'binary') {
          ret = buf;
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var utf8 = new Runtime.UTF8Processor();
          var buf = new Uint8Array(utf8.processJSString(data));
          FS.write(stream, buf, 0, buf.length, 0);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0);
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function() { return 0; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=stdin.fd;
        assert(stdin.fd === 1, 'invalid handle for stdin (' + stdin.fd + ')');
        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=stdout.fd;
        assert(stdout.fd === 2, 'invalid handle for stdout (' + stdout.fd + ')');
        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=stderr.fd;
        assert(stderr.fd === 3, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno) {
          this.errno = errno;
          for (var key in ERRNO_CODES) {
            if (ERRNO_CODES[key] === errno) {
              this.code = key;
              break;
            }
          }
          this.message = ERRNO_MESSAGES[errno];
          this.stack = stackTrace();
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
        FS.nameTable = new Array(4096);
        FS.root = FS.createNode(null, '/', 16384 | 0777, 0);
        FS.mount(MEMFS, {}, '/');
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        FS.ensureErrnoError();
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          function LazyUint8Array() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};
  function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      var mode = HEAP32[((varargs)>>2)];
      path = Pointer_stringify(path);
      try {
        var stream = FS.open(path, oflag, mode);
        return stream.fd;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 512;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 1024;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var ret = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return (ret == -1) ? 0 : ret;
    }
  var SOCKFS={mount:function (mount) {
        return FS.createNode(null, '/', 16384 | 0777, 0);
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }
        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };
        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;
        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });
        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;
        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;
          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }
          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              var url = 'ws://' + addr + ':' + port;
              // the node ws library API is slightly different than the browser's
              var opts = ENVIRONMENT_IS_NODE ? {headers: {'websocket-protocol': ['binary']}} : ['binary'];
              // If node we use the ws library.
              var WebSocket = ENVIRONMENT_IS_NODE ? require('ws') : window['WebSocket'];
              ws = new WebSocket(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }
          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };
          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }
          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;
          var handleOpen = function () {
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };
          function handleMessage(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
            data = new Uint8Array(data);  // make a typed array view on the array buffer
            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }
            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
          };
          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('error', function() {
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onmessage = function peer_socket_onmessage(event) {
              handleMessage(event.data);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (64 | 1) : 0;
          }
          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;
          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (64 | 1);
          }
          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 4;
          }
          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }
          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 21531:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port || _mkport();
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP);
          }
          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }
          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }
          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;
          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });
          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;
              // push to queue for accept to pick up
              sock.pending.push(newsock);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
            }
          });
          sock.server.on('closed', function() {
            sock.server = null;
          });
          sock.server.on('error', function() {
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }
          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          var data;
          if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
            data = buffer.slice(offset, offset + length);
          } else {  // ArrayBufferView
            data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
          }
          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }
          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }
          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };
          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }
          return res;
        }}};function _send(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _write(fd, buf, len);
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        FS.close(stream);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      var stream = FS.getStream(fildes);
      if (stream) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      _fsync(stream);
      return _close(stream);
    }
  function _recv(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _read(fd, buf, len);
    }
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) {
        return 0;
      }
      var bytesRead = 0;
      var streamObj = FS.getStream(stream);
      while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[((ptr++)|0)]=streamObj.ungotten.pop()
        bytesToRead--;
        bytesRead++;
      }
      var err = _read(stream, ptr, bytesToRead);
      if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      }
      bytesRead += err;
      if (bytesRead < bytesToRead) streamObj.eof = true;
      return Math.floor(bytesRead / size);
    }
  Module["_strlen"] = _strlen;function _strdup(ptr) {
      var len = _strlen(ptr);
      var newStr = _malloc(len + 1);
      (_memcpy(newStr, ptr, len)|0);
      HEAP8[(((newStr)+(len))|0)]=0;
      return newStr;
    }
  function _llvm_lifetime_start() {}
  function _llvm_lifetime_end() {}
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i64=_memset;
  function _strncmp(px, py, n) {
      var i = 0;
      while (i < n) {
        var x = HEAPU8[(((px)+(i))|0)];
        var y = HEAPU8[(((py)+(i))|0)];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
      return 0;
    }function _strcmp(px, py) {
      return _strncmp(px, py, TOTAL_MEMORY);
    }
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  var _llvm_va_start=undefined;
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          var flagPadSign = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              case 32:
                flagPadSign = true;
                break;
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (currArg >= 0) {
                if (flagAlwaysSigned) {
                  prefix = '+' + prefix;
                } else if (flagPadSign) {
                  prefix = ' ' + prefix;
                }
              }
              // Move sign to prefix so we zero-pad after the sign
              if (argText.charAt(0) == '-') {
                prefix = '-' + prefix;
                argText = argText.substr(1);
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (currArg >= 0) {
                  if (flagAlwaysSigned) {
                    argText = '+' + argText;
                  } else if (flagPadSign) {
                    argText = ' ' + argText;
                  }
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }function _asprintf(s, format, varargs) {
      return _sprintf(-s, format, varargs);
    }function _vasprintf(s, format, va_arg) {
      return _asprintf(s, format, HEAP32[((va_arg)>>2)]);
    }
  var _llvm_memcpy_p0i8_p0i8_i64=_memcpy;
  var GL={counter:1,lastError:0,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],clientBuffers:[],currArrayBuffer:0,currElementArrayBuffer:0,byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},packAlignment:4,unpackAlignment:4,init:function () {
        Browser.moduleContextCreatedCallbacks.push(GL.initExtensions);
      },recordError:function recordError(errorCode) {
        if (!GL.lastError) {
          GL.lastError = errorCode;
        }
      },getNewId:function (table) {
        var ret = GL.counter++;
        for (var i = table.length; i < ret; i++) {
          table[i] = null;
        }
        return ret;
      },MINI_TEMP_BUFFER_SIZE:16,miniTempBuffer:null,miniTempBufferViews:[0],MAX_TEMP_BUFFER_SIZE:2097152,tempBufferIndexLookup:null,tempVertexBuffers:null,tempIndexBuffers:null,tempQuadIndexBuffer:null,generateTempBuffers:function (quads) {
        GL.tempBufferIndexLookup = new Uint8Array(GL.MAX_TEMP_BUFFER_SIZE+1);
        GL.tempVertexBuffers = [];
        GL.tempIndexBuffers = [];
        var last = -1, curr = -1;
        var size = 1;
        for (var i = 0; i <= GL.MAX_TEMP_BUFFER_SIZE; i++) {
          if (i > size) {
            size <<= 1;
          }
          if (size != last) {
            curr++;
            GL.tempVertexBuffers[curr] = Module.ctx.createBuffer();
            Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, GL.tempVertexBuffers[curr]);
            Module.ctx.bufferData(Module.ctx.ARRAY_BUFFER, size, Module.ctx.DYNAMIC_DRAW);
            Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, null);
            GL.tempIndexBuffers[curr] = Module.ctx.createBuffer();
            Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, GL.tempIndexBuffers[curr]);
            Module.ctx.bufferData(Module.ctx.ELEMENT_ARRAY_BUFFER, size, Module.ctx.DYNAMIC_DRAW);
            Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, null);
            last = size;
          }
          GL.tempBufferIndexLookup[i] = curr;
        }
        if (quads) {
          // GL_QUAD indexes can be precalculated
          GL.tempQuadIndexBuffer = Module.ctx.createBuffer();
          Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, GL.tempQuadIndexBuffer);
          var numIndexes = GL.MAX_TEMP_BUFFER_SIZE >> 1;
          var quadIndexes = new Uint16Array(numIndexes);
          var i = 0, v = 0;
          while (1) {
            quadIndexes[i++] = v;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+1;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+2;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+2;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+3;
            if (i >= numIndexes) break;
            v += 4;
          }
          Module.ctx.bufferData(Module.ctx.ELEMENT_ARRAY_BUFFER, quadIndexes, Module.ctx.STATIC_DRAW);
          Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, null);
        }
      },findToken:function (source, token) {
        function isIdentChar(ch) {
          if (ch >= 48 && ch <= 57) // 0-9
            return true;
          if (ch >= 65 && ch <= 90) // A-Z
            return true;
          if (ch >= 97 && ch <= 122) // a-z
            return true;
          return false;
        }
        var i = -1;
        do {
          i = source.indexOf(token, i + 1);
          if (i < 0) {
            break;
          }
          if (i > 0 && isIdentChar(source[i - 1])) {
            continue;
          }
          i += token.length;
          if (i < source.length - 1 && isIdentChar(source[i + 1])) {
            continue;
          }
          return true;
        } while (true);
        return false;
      },getSource:function (shader, count, string, length) {
        var source = '';
        for (var i = 0; i < count; ++i) {
          var frag;
          if (length) {
            var len = HEAP32[(((length)+(i*4))>>2)];
            if (len < 0) {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
            } else {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)], len);
            }
          } else {
            frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
          }
          source += frag;
        }
        // Let's see if we need to enable the standard derivatives extension
        type = Module.ctx.getShaderParameter(GL.shaders[shader], 0x8B4F /* GL_SHADER_TYPE */);
        if (type == 0x8B30 /* GL_FRAGMENT_SHADER */) {
          if (GL.findToken(source, "dFdx") ||
              GL.findToken(source, "dFdy") ||
              GL.findToken(source, "fwidth")) {
            source = "#extension GL_OES_standard_derivatives : enable\n" + source;
            var extension = Module.ctx.getExtension("OES_standard_derivatives");
          }
        }
        return source;
      },computeImageSize:function (width, height, sizePerPixel, alignment) {
        function roundedToNextMultipleOf(x, y) {
          return Math.floor((x + y - 1) / y) * y
        }
        var plainRowSize = width * sizePerPixel;
        var alignedRowSize = roundedToNextMultipleOf(plainRowSize, alignment);
        return (height <= 0) ? 0 :
                 ((height - 1) * alignedRowSize + plainRowSize);
      },getTexPixelData:function (type, format, width, height, pixels, internalFormat) {
        var sizePerPixel;
        switch (type) {
          case 0x1401 /* GL_UNSIGNED_BYTE */:
            switch (format) {
              case 0x1906 /* GL_ALPHA */:
              case 0x1909 /* GL_LUMINANCE */:
                sizePerPixel = 1;
                break;
              case 0x1907 /* GL_RGB */:
                sizePerPixel = 3;
                break;
              case 0x1908 /* GL_RGBA */:
                sizePerPixel = 4;
                break;
              case 0x190A /* GL_LUMINANCE_ALPHA */:
                sizePerPixel = 2;
                break;
              default:
                throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x1403 /* GL_UNSIGNED_SHORT */:
            if (format == 0x1902 /* GL_DEPTH_COMPONENT */) {
              sizePerPixel = 2;
            } else {
              throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x1405 /* GL_UNSIGNED_INT */:
            if (format == 0x1902 /* GL_DEPTH_COMPONENT */) {
              sizePerPixel = 4;
            } else {
              throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x84FA /* UNSIGNED_INT_24_8_WEBGL */:
            sizePerPixel = 4;
            break;
          case 0x8363 /* GL_UNSIGNED_SHORT_5_6_5 */:
          case 0x8033 /* GL_UNSIGNED_SHORT_4_4_4_4 */:
          case 0x8034 /* GL_UNSIGNED_SHORT_5_5_5_1 */:
            sizePerPixel = 2;
            break;
          case 0x1406 /* GL_FLOAT */:
            switch (format) {
              case 0x1907 /* GL_RGB */:
                sizePerPixel = 3*4;
                break;
              case 0x1908 /* GL_RGBA */:
                sizePerPixel = 4*4;
                break;
              default:
                throw 'Invalid format (' + format + ')';
            }
            internalFormat = Module.ctx.RGBA;
            break;
          default:
            throw 'Invalid type (' + type + ')';
        }
        var bytes = GL.computeImageSize(width, height, sizePerPixel, GL.unpackAlignment);
        if (type == 0x1401 /* GL_UNSIGNED_BYTE */) {
          pixels = HEAPU8.subarray((pixels),(pixels+bytes));
        } else if (type == 0x1406 /* GL_FLOAT */) {
          pixels = HEAPF32.subarray((pixels)>>2,(pixels+bytes)>>2);
        } else if (type == 0x1405 /* GL_UNSIGNED_INT */ || type == 0x84FA /* UNSIGNED_INT_24_8_WEBGL */) {
          pixels = HEAPU32.subarray((pixels)>>2,(pixels+bytes)>>2);
        } else {
          pixels = HEAPU16.subarray((pixels)>>1,(pixels+bytes)>>1);
        }
        return {
          pixels: pixels,
          internalFormat: internalFormat
        }
      },calcBufLength:function calcBufLength(size, type, stride, count) {
        if (stride > 0) {
          return count * stride;  // XXXvlad this is not exactly correct I don't think
        }
        var typeSize = GL.byteSizeByType[type - GL.byteSizeByTypeRoot];
        return size * typeSize * count;
      },usedTempBuffers:[],preDrawHandleClientVertexAttribBindings:function preDrawHandleClientVertexAttribBindings(count) {
        GL.resetBufferBinding = false;
        var used = GL.usedTempBuffers;
        used.length = 0;
        // TODO: initial pass to detect ranges we need to upload, might not need an upload per attrib
        for (var i = 0; i < GL.maxVertexAttribs; ++i) {
          var cb = GL.clientBuffers[i];
          if (!cb.clientside || !cb.enabled) continue;
          GL.resetBufferBinding = true;
          var size = GL.calcBufLength(cb.size, cb.type, cb.stride, count);
          var index = GL.tempBufferIndexLookup[size];
          var buf;
          do {
            buf = GL.tempVertexBuffers[index++];
          } while (used.indexOf(buf) >= 0);
          used.push(buf);
          Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, buf);
          Module.ctx.bufferSubData(Module.ctx.ARRAY_BUFFER,
                                   0,
                                   HEAPU8.subarray(cb.ptr, cb.ptr + size));
          Module.ctx.vertexAttribPointer(i, cb.size, cb.type, cb.normalized, cb.stride, 0);
        }
      },postDrawHandleClientVertexAttribBindings:function postDrawHandleClientVertexAttribBindings() {
        if (GL.resetBufferBinding) {
          Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, GL.buffers[GL.currArrayBuffer]);
        }
      },initExtensions:function () {
        if (GL.initExtensions.done) return;
        GL.initExtensions.done = true;
        if (!Module.useWebGL) return; // an app might link both gl and 2d backends
        GL.miniTempBuffer = new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);
        for (var i = 0; i < GL.MINI_TEMP_BUFFER_SIZE; i++) {
          GL.miniTempBufferViews[i] = GL.miniTempBuffer.subarray(0, i+1);
        }
        GL.maxVertexAttribs = Module.ctx.getParameter(Module.ctx.MAX_VERTEX_ATTRIBS);
        for (var i = 0; i < GL.maxVertexAttribs; i++) {
          GL.clientBuffers[i] = { enabled: false, clientside: false, size: 0, type: 0, normalized: 0, stride: 0, ptr: 0 };
        }
        GL.generateTempBuffers();
        // Detect the presence of a few extensions manually, this GL interop layer itself will need to know if they exist. 
        GL.compressionExt = Module.ctx.getExtension('WEBGL_compressed_texture_s3tc') ||
                            Module.ctx.getExtension('MOZ_WEBGL_compressed_texture_s3tc') ||
                            Module.ctx.getExtension('WEBKIT_WEBGL_compressed_texture_s3tc');
        GL.anisotropicExt = Module.ctx.getExtension('EXT_texture_filter_anisotropic') ||
                            Module.ctx.getExtension('MOZ_EXT_texture_filter_anisotropic') ||
                            Module.ctx.getExtension('WEBKIT_EXT_texture_filter_anisotropic');
        GL.floatExt = Module.ctx.getExtension('OES_texture_float');
        // These are the 'safe' feature-enabling extensions that don't add any performance impact related to e.g. debugging, and
        // should be enabled by default so that client GLES2/GL code will not need to go through extra hoops to get its stuff working.
        // As new extensions are ratified at http://www.khronos.org/registry/webgl/extensions/ , feel free to add your new extensions
        // here, as long as they don't produce a performance impact for users that might not be using those extensions.
        // E.g. debugging-related extensions should probably be off by default.
        var automaticallyEnabledExtensions = [ "OES_texture_float", "OES_texture_half_float", "OES_standard_derivatives",
                                               "OES_vertex_array_object", "WEBGL_compressed_texture_s3tc", "WEBGL_depth_texture",
                                               "OES_element_index_uint", "EXT_texture_filter_anisotropic", "ANGLE_instanced_arrays",
                                               "OES_texture_float_linear", "OES_texture_half_float_linear", "WEBGL_compressed_texture_atc",
                                               "WEBGL_compressed_texture_pvrtc", "EXT_color_buffer_half_float", "WEBGL_color_buffer_float",
                                               "EXT_frag_depth", "EXT_sRGB", "WEBGL_draw_buffers", "WEBGL_shared_resources" ];
        function shouldEnableAutomatically(extension) {
          for(var i in automaticallyEnabledExtensions) {
            var include = automaticallyEnabledExtensions[i];
            if (ext.indexOf(include) != -1) {
              return true;
            }
          }
          return false;
        }
        var extensions = Module.ctx.getSupportedExtensions();
        for(var e in extensions) {
          var ext = extensions[e].replace('MOZ_', '').replace('WEBKIT_', '');
          if (automaticallyEnabledExtensions.indexOf(ext) != -1) {
            Module.ctx.getExtension(ext); // Calling .getExtension enables that extension permanently, no need to store the return value to be enabled.
          }
        }
      },populateUniformTable:function (program) {
        var p = GL.programs[program];
        GL.programInfos[program] = {
          uniforms: {},
          maxUniformLength: 0, // This is eagerly computed below, since we already enumerate all uniforms anyway.
          maxAttributeLength: -1 // This is lazily computed and cached, computed when/if first asked, "-1" meaning not computed yet.
        };
        var ptable = GL.programInfos[program];
        var utable = ptable.uniforms;
        // A program's uniform table maps the string name of an uniform to an integer location of that uniform.
        // The global GL.uniforms map maps integer locations to WebGLUniformLocations.
        var numUniforms = Module.ctx.getProgramParameter(p, Module.ctx.ACTIVE_UNIFORMS);
        for (var i = 0; i < numUniforms; ++i) {
          var u = Module.ctx.getActiveUniform(p, i);
          var name = u.name;
          ptable.maxUniformLength = Math.max(ptable.maxUniformLength, name.length+1);
          // Strip off any trailing array specifier we might have got, e.g. "[0]".
          if (name.indexOf(']', name.length-1) !== -1) {
            var ls = name.lastIndexOf('[');
            name = name.slice(0, ls);
          }
          // Optimize memory usage slightly: If we have an array of uniforms, e.g. 'vec3 colors[3];', then 
          // only store the string 'colors' in utable, and 'colors[0]', 'colors[1]' and 'colors[2]' will be parsed as 'colors'+i.
          // Note that for the GL.uniforms table, we still need to fetch the all WebGLUniformLocations for all the indices.
          var loc = Module.ctx.getUniformLocation(p, name);
          var id = GL.getNewId(GL.uniforms);
          utable[name] = [u.size, id];
          GL.uniforms[id] = loc;
          for (var j = 1; j < u.size; ++j) {
            var n = name + '['+j+']';
            loc = Module.ctx.getUniformLocation(p, n);
            id = GL.getNewId(GL.uniforms);
            GL.uniforms[id] = loc;
          }
        }
      }};function _glCreateProgram() {
      var id = GL.getNewId(GL.programs);
      var program = Module.ctx.createProgram();
      program.name = id;
      GL.programs[id] = program;
      return id;
    }
  function _glCreateShader(shaderType) {
      var id = GL.getNewId(GL.shaders);
      GL.shaders[id] = Module.ctx.createShader(shaderType);
      return id;
    }
  function _glShaderSource(shader, count, string, length) {
      var source = GL.getSource(shader, count, string, length);
      Module.ctx.shaderSource(GL.shaders[shader], source);
    }
  function _glCompileShader(shader) {
      Module.ctx.compileShader(GL.shaders[shader]);
    }
  function _glAttachShader(program, shader) {
      Module.ctx.attachShader(GL.programs[program],
                              GL.shaders[shader]);
    }
  function _glLinkProgram(program) {
      Module.ctx.linkProgram(GL.programs[program]);
      GL.programInfos[program] = null; // uniforms no longer keep the same names after linking
      GL.populateUniformTable(program);
    }
  function _glGetProgramiv(program, pname, p) {
      if (pname == 0x8B84) { // GL_INFO_LOG_LENGTH
        HEAP32[((p)>>2)]=Module.ctx.getProgramInfoLog(GL.programs[program]).length + 1;
      } else if (pname == 0x8B87 /* GL_ACTIVE_UNIFORM_MAX_LENGTH */) {
        var ptable = GL.programInfos[program];
        if (ptable) {
          HEAP32[((p)>>2)]=ptable.maxUniformLength;
          return;
        } else if (program < GL.counter) {
          GL.recordError(0x0502 /* GL_INVALID_OPERATION */);
        } else {
          GL.recordError(0x0501 /* GL_INVALID_VALUE */);
        }
      } else if (pname == 0x8B8A /* GL_ACTIVE_ATTRIBUTE_MAX_LENGTH */) {
        var ptable = GL.programInfos[program];
        if (ptable) {
          if (ptable.maxAttributeLength == -1) {
            var program = GL.programs[program];
            var numAttribs = Module.ctx.getProgramParameter(program, Module.ctx.ACTIVE_ATTRIBUTES);
            ptable.maxAttributeLength = 0; // Spec says if there are no active attribs, 0 must be returned.
            for(var i = 0; i < numAttribs; ++i) {
              var activeAttrib = Module.ctx.getActiveAttrib(program, i);
              ptable.maxAttributeLength = Math.max(ptable.maxAttributeLength, activeAttrib.name.length+1);
            }
          }
          HEAP32[((p)>>2)]=ptable.maxAttributeLength;
          return;
        } else if (program < GL.counter) {
          GL.recordError(0x0502 /* GL_INVALID_OPERATION */);
        } else {
          GL.recordError(0x0501 /* GL_INVALID_VALUE */);
        }
      } else {
        HEAP32[((p)>>2)]=Module.ctx.getProgramParameter(GL.programs[program], pname);
      }
    }
  function _glGenTextures(n, textures) {
      for (var i = 0; i < n; i++) {
        var id = GL.getNewId(GL.textures);
        var texture = Module.ctx.createTexture();
        texture.name = id;
        GL.textures[id] = texture;
        HEAP32[(((textures)+(i*4))>>2)]=id;
      }
    }
  function _glBindTexture(target, texture) {
      Module.ctx.bindTexture(target, texture ? GL.textures[texture] : null);
    }
  function _glTexParameteri(x0, x1, x2) { Module.ctx.texParameteri(x0, x1, x2) }
  var _llvm_memset_p0i8_i32=_memset;
  function _glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels) {
      if (pixels) {
        var data = GL.getTexPixelData(type, format, width, height, pixels, internalFormat);
        pixels = data.pixels;
        internalFormat = data.internalFormat;
      } else {
        pixels = null;
      }
      Module.ctx.texImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
    }
  function _glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) {
      if (pixels) {
        var data = GL.getTexPixelData(type, format, width, height, pixels, -1);
        pixels = data.pixels;
      } else {
        pixels = null;
      }
      Module.ctx.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
  function _glDeleteTextures(n, textures) {
      for (var i = 0; i < n; i++) {
        var id = HEAP32[(((textures)+(i*4))>>2)];
        var texture = GL.textures[id];
        Module.ctx.deleteTexture(texture);
        texture.name = 0;
        GL.textures[id] = null;
      }
    }
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }function __ZSt9terminatev() {
      _exit(-1234);
    }
  function _glClearColor(x0, x1, x2, x3) { Module.ctx.clearColor(x0, x1, x2, x3) }
  function _glEnable(x0) { Module.ctx.enable(x0) }
  function _glBlendFunc(x0, x1) { Module.ctx.blendFunc(x0, x1) }
  function _glViewport(x0, x1, x2, x3) { Module.ctx.viewport(x0, x1, x2, x3) }
  function _glClear(x0) { Module.ctx.clear(x0) }
  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }
  function _glUseProgram(program) {
      Module.ctx.useProgram(program ? GL.programs[program] : null);
    }
  function _glGetAttribLocation(program, name) {
      program = GL.programs[program];
      name = Pointer_stringify(name);
      return Module.ctx.getAttribLocation(program, name);
    }
  function _glEnableVertexAttribArray(index) {
      var cb = GL.clientBuffers[index];
      cb.enabled = true;
      Module.ctx.enableVertexAttribArray(index);
    }
  function _glVertexAttribPointer(index, size, type, normalized, stride, ptr) {
      var cb = GL.clientBuffers[index];
      if (!GL.currArrayBuffer) {
        cb.size = size;
        cb.type = type;
        cb.normalized = normalized;
        cb.stride = stride;
        cb.ptr = ptr;
        cb.clientside = true;
        return;
      }
      cb.clientside = false;
      Module.ctx.vertexAttribPointer(index, size, type, normalized, stride, ptr);
    }
  function _glUniformMatrix4fv(location, count, transpose, value) {
      location = GL.uniforms[location];
      var view;
      if (count == 1) {
        // avoid allocation for the common case of uploading one uniform matrix
        view = GL.miniTempBufferViews[15];
        for (var i = 0; i < 16; i++) {
          view[i] = HEAPF32[(((value)+(i*4))>>2)];
        }
      } else {
        view = HEAPF32.subarray((value)>>2,(value+count*64)>>2);
      }
      Module.ctx.uniformMatrix4fv(location, transpose, view);
    }
  function _glGetUniformLocation(program, name) {
      name = Pointer_stringify(name);
      var arrayOffset = 0;
      // If user passed an array accessor "[index]", parse the array index off the accessor.
      if (name.indexOf(']', name.length-1) !== -1) {
        var ls = name.lastIndexOf('[');
        var arrayIndex = name.slice(ls+1, -1);
        if (arrayIndex.length > 0) {
          arrayOffset = parseInt(arrayIndex);
          if (arrayOffset < 0) {
            return -1;
          }
        }
        name = name.slice(0, ls);
      }
      var ptable = GL.programInfos[program];
      if (!ptable) {
        return -1;
      }
      var utable = ptable.uniforms;
      var uniformInfo = utable[name]; // returns pair [ dimension_of_uniform_array, uniform_location ]
      if (uniformInfo && arrayOffset < uniformInfo[0]) { // Check if user asked for an out-of-bounds element, i.e. for 'vec4 colors[3];' user could ask for 'colors[10]' which should return -1.
        return uniformInfo[1]+arrayOffset;
      } else {
        return -1;
      }
    }
  function _glUniform4f(location, v0, v1, v2, v3) {
      location = GL.uniforms[location];
      Module.ctx.uniform4f(location, v0, v1, v2, v3);
    }
  function _glDrawArrays(mode, first, count) {
      // bind any client-side buffers
      GL.preDrawHandleClientVertexAttribBindings(first + count);
      Module.ctx.drawArrays(mode, first, count);
      GL.postDrawHandleClientVertexAttribBindings();
    }
  function _glDisableVertexAttribArray(index) {
      var cb = GL.clientBuffers[index];
      cb.enabled = false;
      Module.ctx.disableVertexAttribArray(index);
    }
  var _sin=Math_sin;
  var _cos=Math_cos;
  function _fputs(s, stream) {
      // int fputs(const char *restrict s, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputs.html
      return _write(stream, s, _strlen(s));
    }
  function _fputc(c, stream) {
      // int fputc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputc.html
      var chr = unSign(c & 0xFF);
      HEAP8[((_fputc.ret)|0)]=chr
      var ret = _write(stream, _fputc.ret, 1);
      if (ret == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return -1;
      } else {
        return chr;
      }
    }function _puts(s) {
      // int puts(const char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/puts.html
      // NOTE: puts() always writes an extra newline.
      var stdout = HEAP32[((_stdout)>>2)];
      var ret = _fputs(s, stdout);
      if (ret < 0) {
        return ret;
      } else {
        var newlineRet = _fputc(10, stdout);
        return (newlineRet < 0) ? -1 : ret + 1;
      }
    }
  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }
  function ___resumeException(ptr) {
      if (HEAP32[((_llvm_eh_exception.buf)>>2)] == 0) HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr;
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }function ___cxa_find_matching_catch(thrown, throwntype) {
      if (thrown == -1) thrown = HEAP32[((_llvm_eh_exception.buf)>>2)];
      if (throwntype == -1) throwntype = HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)];
      var typeArray = Array.prototype.slice.call(arguments, 2);
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  function _gettimeofday(ptr) {
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  function _strchr(ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = HEAP8[(ptr)];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }
  function _stat(path, buf, dontResolveLastLink) {
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/stat.html
      // int stat(const char *path, struct stat *buf);
      // NOTE: dontResolveLastLink is a shortcut for lstat(). It should never be
      //       used in client code.
      path = typeof path !== 'string' ? Pointer_stringify(path) : path;
      try {
        var stat = dontResolveLastLink ? FS.lstat(path) : FS.stat(path);
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode
        HEAP32[(((buf)+(16))>>2)]=stat.nlink
        HEAP32[(((buf)+(20))>>2)]=stat.uid
        HEAP32[(((buf)+(24))>>2)]=stat.gid
        HEAP32[(((buf)+(28))>>2)]=stat.rdev
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size
        HEAP32[(((buf)+(40))>>2)]=4096
        HEAP32[(((buf)+(44))>>2)]=stat.blocks
        HEAP32[(((buf)+(48))>>2)]=Math.floor(stat.atime.getTime() / 1000)
        HEAP32[(((buf)+(52))>>2)]=0
        HEAP32[(((buf)+(56))>>2)]=Math.floor(stat.mtime.getTime() / 1000)
        HEAP32[(((buf)+(60))>>2)]=0
        HEAP32[(((buf)+(64))>>2)]=Math.floor(stat.ctime.getTime() / 1000)
        HEAP32[(((buf)+(68))>>2)]=0
        HEAP32[(((buf)+(72))>>2)]=stat.ino
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _mknod(path, mode, dev) {
      // int mknod(const char *path, mode_t mode, dev_t dev);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/mknod.html
      path = Pointer_stringify(path);
      // we don't want this in the JS API as the JS API
      // uses mknod to create all nodes.
      switch (mode & 61440) {
        case 32768:
        case 8192:
        case 24576:
        case 4096:
        case 49152:
          break;
        default:
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
      }
      try {
        FS.mknod(path, mode, dev);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _mkdir(path, mode) {
      // int mkdir(const char *path, mode_t mode);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/mkdir.html
      path = Pointer_stringify(path);
      try {
        FS.mkdir(path, mode, 0);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _strrchr(ptr, chr) {
      var ptr2 = ptr + _strlen(ptr);
      do {
        if (HEAP8[(ptr2)] == chr) return ptr2;
        ptr2--;
      } while (ptr2 >= ptr);
      return 0;
    }
  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = 'root';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/emscripten';
        ENV['LANG'] = 'en_US.UTF-8';
        ENV['_'] = './this.program';
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        writeAsciiToMemory(line, poolPtr);
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        var ctx;
        try {
          if (useWebGL) {
            var contextAttributes = {
              antialias: false,
              alpha: false
            };
            if (webGLContextAttributes) {
              for (var attribute in webGLContextAttributes) {
                contextAttributes[attribute] = webGLContextAttributes[attribute];
              }
            }
            ['experimental-webgl', 'webgl'].some(function(webglId) {
              return ctx = canvas.getContext(webglId, contextAttributes);
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          setTimeout(func, 1000/60);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           window['setTimeout'];
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x, y;
          if (event.type == 'touchstart' ||
              event.type == 'touchend' ||
              event.type == 'touchmove') {
            var t = event.touches.item(0);
            if (t) {
              x = t.pageX - (window.scrollX + rect.left);
              y = t.pageY - (window.scrollY + rect.top);
            } else {
              return;
            }
          } else {
            x = event.pageX - (window.scrollX + rect.left);
            y = event.pageY - (window.scrollY + rect.top);
          }
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      }};var SDL={defaults:{width:320,height:200,copyOnLock:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},keyCodes:{16:1249,17:1248,18:1250,33:1099,34:1102,37:1104,38:1106,39:1103,40:1105,46:127,96:1112,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,173:45,188:44,190:46,191:47,192:96},scanCodes:{8:42,9:43,13:40,27:41,32:44,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,305:224,308:226},loadRect:function (rect) {
        return {
          x: HEAP32[((rect + 0)>>2)],
          y: HEAP32[((rect + 4)>>2)],
          w: HEAP32[((rect + 8)>>2)],
          h: HEAP32[((rect + 12)>>2)]
        };
      },loadColorToCSSRGB:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgb(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ')';
      },loadColorToCSSRGBA:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgba(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ',' + (((rgba >> 24)&255)/255) + ')';
      },translateColorToCSSRGBA:function (rgba) {
        return 'rgba(' + (rgba&0xff) + ',' + (rgba>>8 & 0xff) + ',' + (rgba>>16 & 0xff) + ',' + (rgba>>>24)/0xff + ')';
      },translateRGBAToCSSRGBA:function (r, g, b, a) {
        return 'rgba(' + (r&0xff) + ',' + (g&0xff) + ',' + (b&0xff) + ',' + (a&0xff)/255 + ')';
      },translateRGBAToColor:function (r, g, b, a) {
        return r | g << 8 | b << 16 | a << 24;
      },makeSurface:function (width, height, flags, usePageCanvas, source, rmask, gmask, bmask, amask) {
        flags = flags || 0;
        var surf = _malloc(60);  // SDL_Surface has 15 fields of quantum size
        var buffer = _malloc(width*height*4); // TODO: only allocate when locked the first time
        var pixelFormat = _malloc(44);
        flags |= 1; // SDL_HWSURFACE - this tells SDL_MUSTLOCK that this needs to be locked
        //surface with SDL_HWPALETTE flag is 8bpp surface (1 byte)
        var is_SDL_HWPALETTE = flags & 0x00200000;  
        var bpp = is_SDL_HWPALETTE ? 1 : 4;
        HEAP32[((surf)>>2)]=flags         // SDL_Surface.flags
        HEAP32[(((surf)+(4))>>2)]=pixelFormat // SDL_Surface.format TODO
        HEAP32[(((surf)+(8))>>2)]=width         // SDL_Surface.w
        HEAP32[(((surf)+(12))>>2)]=height        // SDL_Surface.h
        HEAP32[(((surf)+(16))>>2)]=width * bpp       // SDL_Surface.pitch, assuming RGBA or indexed for now,
                                                                                 // since that is what ImageData gives us in browsers
        HEAP32[(((surf)+(20))>>2)]=buffer      // SDL_Surface.pixels
        HEAP32[(((surf)+(36))>>2)]=0      // SDL_Surface.offset
        HEAP32[(((surf)+(56))>>2)]=1
        HEAP32[((pixelFormat)>>2)]=0 /* XXX missing C define SDL_PIXELFORMAT_RGBA8888 */ // SDL_PIXELFORMAT_RGBA8888
        HEAP32[(((pixelFormat)+(4))>>2)]=0 // TODO
        HEAP8[(((pixelFormat)+(8))|0)]=bpp * 8
        HEAP8[(((pixelFormat)+(9))|0)]=bpp
        HEAP32[(((pixelFormat)+(12))>>2)]=rmask || 0x000000ff
        HEAP32[(((pixelFormat)+(16))>>2)]=gmask || 0x0000ff00
        HEAP32[(((pixelFormat)+(20))>>2)]=bmask || 0x00ff0000
        HEAP32[(((pixelFormat)+(24))>>2)]=amask || 0xff000000
        // Decide if we want to use WebGL or not
        var useWebGL = (flags & 0x04000000) != 0; // SDL_OPENGL
        SDL.GL = SDL.GL || useWebGL;
        var canvas;
        if (!usePageCanvas) {
          if (SDL.canvasPool.length > 0) {
            canvas = SDL.canvasPool.pop();
          } else {
            canvas = document.createElement('canvas');
          }
          canvas.width = width;
          canvas.height = height;
        } else {
          canvas = Module['canvas'];
        }
        var webGLContextAttributes = {
          antialias: ((SDL.glAttributes[13 /*SDL_GL_MULTISAMPLEBUFFERS*/] != 0) && (SDL.glAttributes[14 /*SDL_GL_MULTISAMPLESAMPLES*/] > 1)),
          depth: (SDL.glAttributes[6 /*SDL_GL_DEPTH_SIZE*/] > 0),
          stencil: (SDL.glAttributes[7 /*SDL_GL_STENCIL_SIZE*/] > 0)
        };
        var ctx = Browser.createContext(canvas, useWebGL, usePageCanvas, webGLContextAttributes);
        SDL.surfaces[surf] = {
          width: width,
          height: height,
          canvas: canvas,
          ctx: ctx,
          surf: surf,
          buffer: buffer,
          pixelFormat: pixelFormat,
          alpha: 255,
          flags: flags,
          locked: 0,
          usePageCanvas: usePageCanvas,
          source: source,
          isFlagSet: function(flag) {
            return flags & flag;
          }
        };
        return surf;
      },copyIndexedColorData:function (surfData, rX, rY, rW, rH) {
        // HWPALETTE works with palette
        // setted by SDL_SetColors
        if (!surfData.colors) {
          return;
        }
        var fullWidth  = Module['canvas'].width;
        var fullHeight = Module['canvas'].height;
        var startX  = rX || 0;
        var startY  = rY || 0;
        var endX    = (rW || (fullWidth - startX)) + startX;
        var endY    = (rH || (fullHeight - startY)) + startY;
        var buffer  = surfData.buffer;
        var data    = surfData.image.data;
        var colors  = surfData.colors;
        for (var y = startY; y < endY; ++y) {
          var indexBase = y * fullWidth;
          var colorBase = indexBase * 4;
          for (var x = startX; x < endX; ++x) {
            // HWPALETTE have only 256 colors (not rgba)
            var index = HEAPU8[((buffer + indexBase + x)|0)] * 3;
            var colorOffset = colorBase + x * 4;
            data[colorOffset   ] = colors[index   ];
            data[colorOffset +1] = colors[index +1];
            data[colorOffset +2] = colors[index +2];
            //unused: data[colorOffset +3] = color[index +3];
          }
        }
      },freeSurface:function (surf) {
        var refcountPointer = surf + 56;
        var refcount = HEAP32[((refcountPointer)>>2)];
        if (refcount > 1) {
          HEAP32[((refcountPointer)>>2)]=refcount - 1;
          return;
        }
        var info = SDL.surfaces[surf];
        if (!info.usePageCanvas && info.canvas) SDL.canvasPool.push(info.canvas);
        _free(info.buffer);
        _free(info.pixelFormat);
        _free(surf);
        SDL.surfaces[surf] = null;
      },touchX:0,touchY:0,savedKeydown:null,receiveEvent:function (event) {
        switch(event.type) {
          case 'touchstart':
            event.preventDefault();
            var touch = event.touches[0];
            touchX = touch.pageX;
            touchY = touch.pageY;
            var event = {
              type: 'mousedown',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.DOMButtons[0] = 1;
            SDL.events.push(event);
            break;
          case 'touchmove':
            event.preventDefault();
            var touch = event.touches[0];
            touchX = touch.pageX;
            touchY = touch.pageY;
            event = {
              type: 'mousemove',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.events.push(event);
            break;
          case 'touchend':
            event.preventDefault();
            event = {
              type: 'mouseup',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.DOMButtons[0] = 0;
            SDL.events.push(event);
            break;
          case 'mousemove':
            if (Browser.pointerLock) {
              // workaround for firefox bug 750111
              if ('mozMovementX' in event) {
                event['movementX'] = event['mozMovementX'];
                event['movementY'] = event['mozMovementY'];
              }
              // workaround for Firefox bug 782777
              if (event['movementX'] == 0 && event['movementY'] == 0) {
                // ignore a mousemove event if it doesn't contain any movement info
                // (without pointer lock, we infer movement from pageX/pageY, so this check is unnecessary)
                event.preventDefault();
                return;
              }
            }
            // fall through
          case 'keydown': case 'keyup': case 'keypress': case 'mousedown': case 'mouseup': case 'DOMMouseScroll': case 'mousewheel':
            // If we preventDefault on keydown events, the subsequent keypress events
            // won't fire. However, it's fine (and in some cases necessary) to
            // preventDefault for keys that don't generate a character. Otherwise,
            // preventDefault is the right thing to do in general.
            if (event.type !== 'keydown' || (event.keyCode === 8 /* backspace */ || event.keyCode === 9 /* tab */)) {
              event.preventDefault();
            }
            if (event.type == 'DOMMouseScroll' || event.type == 'mousewheel') {
              var button = (event.type == 'DOMMouseScroll' ? event.detail : -event.wheelDelta) > 0 ? 4 : 3;
              var event2 = {
                type: 'mousedown',
                button: button,
                pageX: event.pageX,
                pageY: event.pageY
              };
              SDL.events.push(event2);
              event = {
                type: 'mouseup',
                button: button,
                pageX: event.pageX,
                pageY: event.pageY
              };
            } else if (event.type == 'mousedown') {
              SDL.DOMButtons[event.button] = 1;
            } else if (event.type == 'mouseup') {
              // ignore extra ups, can happen if we leave the canvas while pressing down, then return,
              // since we add a mouseup in that case
              if (!SDL.DOMButtons[event.button]) {
                return;
              }
              SDL.DOMButtons[event.button] = 0;
            }
            // We can only request fullscreen as the result of user input.
            // Due to this limitation, we toggle a boolean on keydown which
            // SDL_WM_ToggleFullScreen will check and subsequently set another
            // flag indicating for us to request fullscreen on the following
            // keyup. This isn't perfect, but it enables SDL_WM_ToggleFullScreen
            // to work as the result of a keypress (which is an extremely
            // common use case).
            if (event.type === 'keydown') {
              SDL.canRequestFullscreen = true;
            } else if (event.type === 'keyup') {
              if (SDL.isRequestingFullscreen) {
                Module['requestFullScreen'](true, true);
                SDL.isRequestingFullscreen = false;
              }
              SDL.canRequestFullscreen = false;
            }
            // SDL expects a unicode character to be passed to its keydown events.
            // Unfortunately, the browser APIs only provide a charCode property on
            // keypress events, so we must backfill in keydown events with their
            // subsequent keypress event's charCode.
            if (event.type === 'keypress' && SDL.savedKeydown) {
              // charCode is read-only
              SDL.savedKeydown.keypressCharCode = event.charCode;
              SDL.savedKeydown = null;
            } else if (event.type === 'keydown') {
              SDL.savedKeydown = event;
            }
            // Don't push keypress events unless SDL_StartTextInput has been called.
            if (event.type !== 'keypress' || SDL.textInput) {
              SDL.events.push(event);
            }
            break;
          case 'mouseout':
            // Un-press all pressed mouse buttons, because we might miss the release outside of the canvas
            for (var i = 0; i < 3; i++) {
              if (SDL.DOMButtons[i]) {
                SDL.events.push({
                  type: 'mouseup',
                  button: i,
                  pageX: event.pageX,
                  pageY: event.pageY
                });
                SDL.DOMButtons[i] = 0;
              }
            }
            event.preventDefault();
            break;
          case 'blur':
          case 'visibilitychange': {
            // Un-press all pressed keys: TODO
            for (var code in SDL.keyboardMap) {
              SDL.events.push({
                type: 'keyup',
                keyCode: SDL.keyboardMap[code]
              });
            }
            event.preventDefault();
            break;
          }
          case 'unload':
            if (Browser.mainLoop.runner) {
              SDL.events.push(event);
              // Force-run a main event loop, since otherwise this event will never be caught!
              Browser.mainLoop.runner();
            }
            return;
          case 'resize':
            SDL.events.push(event);
            // manually triggered resize event doesn't have a preventDefault member
            if (event.preventDefault) {
              event.preventDefault();
            }
            break;
        }
        if (SDL.events.length >= 10000) {
          Module.printErr('SDL event queue full, dropping events');
          SDL.events = SDL.events.slice(0, 10000);
        }
        return;
      },handleEvent:function (event) {
        if (event.handled) return;
        event.handled = true;
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            var code = event.keyCode;
            if (code >= 65 && code <= 90) {
              code += 32; // make lowercase for SDL
            } else {
              code = SDL.keyCodes[event.keyCode] || event.keyCode;
            }
            HEAP8[(((SDL.keyboardState)+(code))|0)]=down;
            // TODO: lmeta, rmeta, numlock, capslock, KMOD_MODE, KMOD_RESERVED
            SDL.modState = (HEAP8[(((SDL.keyboardState)+(1248))|0)] ? 0x0040 | 0x0080 : 0) | // KMOD_LCTRL & KMOD_RCTRL
              (HEAP8[(((SDL.keyboardState)+(1249))|0)] ? 0x0001 | 0x0002 : 0) | // KMOD_LSHIFT & KMOD_RSHIFT
              (HEAP8[(((SDL.keyboardState)+(1250))|0)] ? 0x0100 | 0x0200 : 0); // KMOD_LALT & KMOD_RALT
            if (down) {
              SDL.keyboardMap[code] = event.keyCode; // save the DOM input, which we can use to unpress it during blur
            } else {
              delete SDL.keyboardMap[code];
            }
            break;
          }
          case 'mousedown': case 'mouseup':
            if (event.type == 'mousedown') {
              // SDL_BUTTON(x) is defined as (1 << ((x)-1)).  SDL buttons are 1-3,
              // and DOM buttons are 0-2, so this means that the below formula is
              // correct.
              SDL.buttonState |= 1 << event.button;
            } else if (event.type == 'mouseup') {
              SDL.buttonState &= ~(1 << event.button);
            }
            // fall through
          case 'mousemove': {
            Browser.calculateMouseEvent(event);
            break;
          }
        }
      },makeCEvent:function (event, ptr) {
        if (typeof event === 'number') {
          // This is a pointer to a native C event that was SDL_PushEvent'ed
          _memcpy(ptr, event, 28); // XXX
          return;
        }
        SDL.handleEvent(event);
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            //Module.print('Received key event: ' + event.keyCode);
            var key = event.keyCode;
            if (key >= 65 && key <= 90) {
              key += 32; // make lowercase for SDL
            } else {
              key = SDL.keyCodes[event.keyCode] || event.keyCode;
            }
            var scan;
            if (key >= 1024) {
              scan = key - 1024;
            } else {
              scan = SDL.scanCodes[key] || key;
            }
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type]
            HEAP8[(((ptr)+(8))|0)]=down ? 1 : 0
            HEAP8[(((ptr)+(9))|0)]=0 // TODO
            HEAP32[(((ptr)+(12))>>2)]=scan
            HEAP32[(((ptr)+(16))>>2)]=key
            HEAP16[(((ptr)+(20))>>1)]=SDL.modState
            // some non-character keys (e.g. backspace and tab) won't have keypressCharCode set, fill in with the keyCode.
            HEAP32[(((ptr)+(24))>>2)]=event.keypressCharCode || key
            break;
          }
          case 'keypress': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type]
            // Not filling in windowID for now
            var cStr = intArrayFromString(String.fromCharCode(event.charCode));
            for (var i = 0; i < cStr.length; ++i) {
              HEAP8[(((ptr)+(8 + i))|0)]=cStr[i];
            }
            break;
          }
          case 'mousedown': case 'mouseup': case 'mousemove': {
            if (event.type != 'mousemove') {
              var down = event.type === 'mousedown';
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP8[(((ptr)+(8))|0)]=event.button+1; // DOM buttons are 0-2, SDL 1-3
              HEAP8[(((ptr)+(9))|0)]=down ? 1 : 0;
              HEAP32[(((ptr)+(12))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(16))>>2)]=Browser.mouseY;
            } else {
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP8[(((ptr)+(8))|0)]=SDL.buttonState;
              HEAP32[(((ptr)+(12))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(16))>>2)]=Browser.mouseY;
              HEAP32[(((ptr)+(20))>>2)]=Browser.mouseMovementX;
              HEAP32[(((ptr)+(24))>>2)]=Browser.mouseMovementY;
            }
            break;
          }
          case 'unload': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            break;
          }
          case 'resize': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=event.w;
            HEAP32[(((ptr)+(8))>>2)]=event.h;
            break;
          }
          case 'joystick_button_up': case 'joystick_button_down': {
            var state = event.type === 'joystick_button_up' ? 0 : 1;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))|0)]=event.index;
            HEAP8[(((ptr)+(5))|0)]=event.button;
            HEAP8[(((ptr)+(6))|0)]=state;
            break;
          }
          case 'joystick_axis_motion': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))|0)]=event.index;
            HEAP8[(((ptr)+(5))|0)]=event.axis;
            HEAP32[(((ptr)+(8))>>2)]=SDL.joystickAxisValueConversion(event.value);
            break;
          }
          default: throw 'Unhandled SDL event: ' + event.type;
        }
      },estimateTextWidth:function (fontData, text) {
        var h = fontData.size;
        var fontString = h + 'px ' + fontData.name;
        var tempCtx = SDL.ttfContext;
        tempCtx.save();
        tempCtx.font = fontString;
        var ret = tempCtx.measureText(text).width | 0;
        tempCtx.restore();
        return ret;
      },allocateChannels:function (num) { // called from Mix_AllocateChannels and init
        if (SDL.numChannels && SDL.numChannels >= num && num != 0) return;
        SDL.numChannels = num;
        SDL.channels = [];
        for (var i = 0; i < num; i++) {
          SDL.channels[i] = {
            audio: null,
            volume: 1.0
          };
        }
      },setGetVolume:function (info, volume) {
        if (!info) return 0;
        var ret = info.volume * 128; // MIX_MAX_VOLUME
        if (volume != -1) {
          info.volume = volume / 128;
          if (info.audio) info.audio.volume = info.volume;
        }
        return ret;
      },debugSurface:function (surfData) {
        console.log('dumping surface ' + [surfData.surf, surfData.source, surfData.width, surfData.height]);
        var image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
        var data = image.data;
        var num = Math.min(surfData.width, surfData.height);
        for (var i = 0; i < num; i++) {
          console.log('   diagonal ' + i + ':' + [data[i*surfData.width*4 + i*4 + 0], data[i*surfData.width*4 + i*4 + 1], data[i*surfData.width*4 + i*4 + 2], data[i*surfData.width*4 + i*4 + 3]]);
        }
      },joystickEventState:0,lastJoystickState:{},joystickNamePool:{},recordJoystickState:function (joystick, state) {
        // Standardize button state.
        var buttons = new Array(state.buttons.length);
        for (var i = 0; i < state.buttons.length; i++) {
          buttons[i] = SDL.getJoystickButtonState(state.buttons[i]);
        }
        SDL.lastJoystickState[joystick] = {
          buttons: buttons,
          axes: state.axes.slice(0),
          timestamp: state.timestamp,
          index: state.index,
          id: state.id
        };
      },getJoystickButtonState:function (button) {
        if (typeof button === 'object') {
          // Current gamepad API editor's draft (Firefox Nightly)
          // https://dvcs.w3.org/hg/gamepad/raw-file/default/gamepad.html#idl-def-GamepadButton
          return button.pressed;
        } else {
          // Current gamepad API working draft (Firefox / Chrome Stable)
          // http://www.w3.org/TR/2012/WD-gamepad-20120529/#gamepad-interface
          return button > 0;
        }
      },queryJoysticks:function () {
        for (var joystick in SDL.lastJoystickState) {
          var state = SDL.getGamepad(joystick - 1);
          var prevState = SDL.lastJoystickState[joystick];
          // Check only if the timestamp has differed.
          // NOTE: Timestamp is not available in Firefox.
          if (typeof state.timestamp !== 'number' || state.timestamp !== prevState.timestamp) {
            var i;
            for (i = 0; i < state.buttons.length; i++) {
              var buttonState = SDL.getJoystickButtonState(state.buttons[i]);
              // NOTE: The previous state already has a boolean representation of
              //       its button, so no need to standardize its button state here.
              if (buttonState !== prevState.buttons[i]) {
                // Insert button-press event.
                SDL.events.push({
                  type: buttonState ? 'joystick_button_down' : 'joystick_button_up',
                  joystick: joystick,
                  index: joystick - 1,
                  button: i
                });
              }
            }
            for (i = 0; i < state.axes.length; i++) {
              if (state.axes[i] !== prevState.axes[i]) {
                // Insert axes-change event.
                SDL.events.push({
                  type: 'joystick_axis_motion',
                  joystick: joystick,
                  index: joystick - 1,
                  axis: i,
                  value: state.axes[i]
                });
              }
            }
            SDL.recordJoystickState(joystick, state);
          }
        }
      },joystickAxisValueConversion:function (value) {
        // Ensures that 0 is 0, 1 is 32767, and -1 is 32768.
        return Math.ceil(((value+1) * 32767.5) - 32768);
      },getGamepads:function () {
        var fcn = navigator.getGamepads || navigator.webkitGamepads || navigator.mozGamepads || navigator.gamepads || navigator.webkitGetGamepads;
        if (fcn !== undefined) {
          // The function must be applied on the navigator object.
          return fcn.apply(navigator);
        } else {
          return [];
        }
      },getGamepad:function (deviceIndex) {
        var gamepads = SDL.getGamepads();
        if (gamepads.length > deviceIndex && deviceIndex >= 0) {
          return gamepads[deviceIndex];
        }
        return null;
      }};function _SDL_PollEvent(ptr) {
      if (SDL.initFlags & 0x200 && SDL.joystickEventState) {
        // If SDL_INIT_JOYSTICK was supplied AND the joystick system is configured
        // to automatically query for events, query for joystick events.
        SDL.queryJoysticks();
      }
      if (SDL.events.length === 0) return 0;
      if (ptr) {
        SDL.makeCEvent(SDL.events.shift(), ptr);
      }
      return 1;
    }
  function _Mix_LoadWAV_RW(rwopsID, freesrc) {
      var rwops = SDL.rwops[rwopsID];
      if (rwops === undefined)
        return 0;
      var filename = '';
      var audio;
      var bytes;
      if (rwops.filename !== undefined) {
        filename = PATH.resolve(rwops.filename);
        var raw = Module["preloadedAudios"][filename];
        if (!raw) {
          if (raw === null) Module.printErr('Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!');
          Runtime.warnOnce('Cannot find preloaded audio ' + filename);
          // see if we can read the file-contents from the in-memory FS
          var fileObject = FS.findObject(filename);
          if (fileObject === null) Module.printErr('Couldn\'t find file for: ' + filename);
          // We found the file. Load the contents
          if (fileObject && !fileObject.isFolder && fileObject.read) {
            bytes = fileObject.contents;
          } else {
            return 0;
          }
        }
        if (Module['freePreloadedMediaOnUse']) {
          Module["preloadedAudios"][filename] = null;
        }
        audio = raw;
      }
      else if (rwops.bytes !== undefined) {
        bytes = HEAPU8.subarray(rwops.bytes, rwops.bytes + rwops.count);
      }
      else {
        return 0;
      }
      // Here, we didn't find a preloaded audio but we either were passed a filepath for
      // which we loaded bytes, or we were passed some bytes
      if (audio === undefined && bytes) {
        var blob = new Blob([new Uint8Array(bytes)], {type: rwops.mimetype});
        var url = URL.createObjectURL(blob);
        audio = new Audio();
        audio.src = url;
      }
      var id = SDL.audios.length;
      // Keep the loaded audio in the audio arrays, ready for playback
      SDL.audios.push({
        source: filename,
        audio: audio
      });
      return id;
    }
  function _SDL_RWFromFile(_name, mode) {
      var id = SDL.rwops.length; // TODO: recycle ids when they are null
      var name = Pointer_stringify(_name)
      SDL.rwops.push({ filename: name, mimetype: Browser.getMimetype(name) });
      return id;
    }
  function _Mix_FreeChunk(id) {
      SDL.audios[id] = null;
    }
  function _Mix_PlayChannel(channel, id, loops) {
      // TODO: handle loops
      // Get the audio element associated with the ID
      var info = SDL.audios[id];
      if (!info) return -1;
      var audio = info.audio;
      if (!audio) return -1;
      // If the user asks us to allocate a channel automatically, get the first
      // free one.
      if (channel == -1) {
        for (var i = SDL.channelMinimumNumber; i < SDL.numChannels; i++) {
          if (!SDL.channels[i].audio) {
            channel = i;
            break;
          }
        }
        if (channel == -1) {
          Module.printErr('All ' + SDL.numChannels + ' channels in use!');
          return -1;
        }
      }
      // We clone the audio node to utilize the preloaded audio buffer, since
      // the browser has already preloaded the audio file.
      var channelInfo = SDL.channels[channel];
      channelInfo.audio = audio = audio.cloneNode(true);
      audio.numChannels = info.audio.numChannels;
      audio.frequency = info.audio.frequency;
      // TODO: handle N loops. Behavior matches Mix_PlayMusic
      audio.loop = loops != 0; 
      audio['onended'] = function SDL_audio_onended() { // TODO: cache these
        channelInfo.audio = null;
        if (SDL.channelFinished) {
          Runtime.getFuncWrapper(SDL.channelFinished, 'vi')(channel);
        }
      }
      // Either play the element, or load the dynamic data into it
      if (info.buffer) {
        var contextCtor = null;
        if (audio && ('mozSetup' in audio)) { // Audio Data API
          try {
            audio['mozSetup'](audio.numChannels, audio.frequency);
            audio["mozWriteAudio"](info.buffer);
          } catch (e) {
            // Workaround for Firefox bug 783052
            // ignore this exception!
          }
        /*
        } else if (contextCtor = (window.AudioContext || // WebAudio API
                                  window.webkitAudioContext)) {
          var currentIndex = 0;
          var numChannels = parseInt(audio.numChannels);
          var context = new contextCtor();
          var source = context.createBufferSource();
          source.loop = false;
          source.buffer = context.createBuffer(numChannels, 1, audio.frequency);
          var jsNode = context.createJavaScriptNode(2048, numChannels, numChannels);
          jsNode.onaudioprocess = function jsNode_onaudioprocess(event) {
            var buffers = new Array(numChannels);
            for (var i = 0; i < numChannels; ++i) {
              buffers[i] = event.outputBuffer.getChannelData(i);
            }
            var remaining = info.buffer.length - currentIndex;
            if (remaining > 2048) {
              remaining = 2048;
            }
            for (var i = 0; i < remaining;) {
              for (var j = 0; j < numChannels; ++j) {
                buffers[j][i] = info.buffer[currentIndex + i + j] * audio.volume;
              }
              i += j;
            }
            currentIndex += remaining * numChannels;
            for (var i = remaining; i < 2048;) {
              for (var j = 0; j < numChannels; ++j) {
                buffers[j][i] = 0; // silence
              }
              i += j;
            }
          };
          source.connect(jsNode);
          jsNode.connect(context.destination);
          source.noteOn(0);
        */
        }
      } else {
        audio.play();
      }
      audio.volume = channelInfo.volume;
      return channel;
    }var _Mix_PlayChannelTimed=_Mix_PlayChannel;
  function _SDL_Init(initFlags) {
      SDL.startTime = Date.now();
      SDL.initFlags = initFlags;
      // capture all key events. we just keep down and up, but also capture press to prevent default actions
      if (!Module['doNotCaptureKeyboard']) {
        document.addEventListener("keydown", SDL.receiveEvent);
        document.addEventListener("keyup", SDL.receiveEvent);
        document.addEventListener("keypress", SDL.receiveEvent);
        window.addEventListener("blur", SDL.receiveEvent);
        document.addEventListener("visibilitychange", SDL.receiveEvent);
      }
      if (initFlags & 0x200) {
        // SDL_INIT_JOYSTICK
        // Firefox will not give us Joystick data unless we register this NOP
        // callback.
        // https://bugzilla.mozilla.org/show_bug.cgi?id=936104
        addEventListener("gamepadconnected", function() {});
      }
      window.addEventListener("unload", SDL.receiveEvent);
      SDL.keyboardState = _malloc(0x10000); // Our SDL needs 512, but 64K is safe for older SDLs
      _memset(SDL.keyboardState, 0, 0x10000);
      // Initialize this structure carefully for closure
      SDL.DOMEventToSDLEvent['keydown'] = 0x300 /* SDL_KEYDOWN */;
      SDL.DOMEventToSDLEvent['keyup'] = 0x301 /* SDL_KEYUP */;
      SDL.DOMEventToSDLEvent['keypress'] = 0x303 /* SDL_TEXTINPUT */;
      SDL.DOMEventToSDLEvent['mousedown'] = 0x401 /* SDL_MOUSEBUTTONDOWN */;
      SDL.DOMEventToSDLEvent['mouseup'] = 0x402 /* SDL_MOUSEBUTTONUP */;
      SDL.DOMEventToSDLEvent['mousemove'] = 0x400 /* SDL_MOUSEMOTION */;
      SDL.DOMEventToSDLEvent['unload'] = 0x100 /* SDL_QUIT */;
      SDL.DOMEventToSDLEvent['resize'] = 0x7001 /* SDL_VIDEORESIZE/SDL_EVENT_COMPAT2 */;
      // These are not technically DOM events; the HTML gamepad API is poll-based.
      // However, we define them here, as the rest of the SDL code assumes that
      // all SDL events originate as DOM events.
      SDL.DOMEventToSDLEvent['joystick_axis_motion'] = 0x600 /* SDL_JOYAXISMOTION */;
      SDL.DOMEventToSDLEvent['joystick_button_down'] = 0x603 /* SDL_JOYBUTTONDOWN */;
      SDL.DOMEventToSDLEvent['joystick_button_up'] = 0x604 /* SDL_JOYBUTTONUP */;
      return 0; // success
    }
  function _Mix_Init(flags) {
      if (!flags) return 0;
      return 8; /* MIX_INIT_OGG */
    }
  function _Mix_OpenAudio(frequency, format, channels, chunksize) {
      SDL.allocateChannels(32);
      // Just record the values for a later call to Mix_QuickLoad_RAW
      SDL.mixerFrequency = frequency;
      SDL.mixerFormat = format;
      SDL.mixerNumChannels = channels;
      SDL.mixerChunkSize = chunksize;
      return 0;
    }
  function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop) {
      Module['noExitRuntime'] = true;
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
        if (Browser.mainLoop.shouldPause) {
          // catch pauses from non-main loop sources
          Browser.mainLoop.paused = true;
          Browser.mainLoop.shouldPause = false;
          return;
        }
        if (Module['preMainLoop']) {
          Module['preMainLoop']();
        }
        try {
          Runtime.dynCall('v', func);
        } catch (e) {
          if (e instanceof ExitStatus) {
            return;
          } else {
            if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
            throw e;
          }
        }
        if (Module['postMainLoop']) {
          Module['postMainLoop']();
        }
        if (Browser.mainLoop.shouldPause) {
          // catch pauses from the main loop itself
          Browser.mainLoop.paused = true;
          Browser.mainLoop.shouldPause = false;
          return;
        }
        Browser.mainLoop.scheduler();
      }
      if (fps && fps > 0) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          setTimeout(Browser.mainLoop.runner, 1000/fps); // doing this each time means that on exception, we stop
        }
      } else {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        }
      }
      Browser.mainLoop.scheduler();
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }
  function _SDL_GL_SwapBuffers() {}
  function _SDL_SetVideoMode(width, height, depth, flags) {
      ['mousedown', 'mouseup', 'mousemove', 'DOMMouseScroll', 'mousewheel', 'mouseout'].forEach(function(event) {
        Module['canvas'].addEventListener(event, SDL.receiveEvent, true);
      });
      // (0,0) means 'use fullscreen' in native; in Emscripten, use the current canvas size.
      if (width == 0 && height == 0) {
        var canvas = Module['canvas'];
        width = canvas.width;
        height = canvas.height;
      }
      Browser.setCanvasSize(width, height, true);
      // Free the old surface first.
      if (SDL.screen) {
        SDL.freeSurface(SDL.screen);
        SDL.screen = null;
      }
      SDL.screen = SDL.makeSurface(width, height, flags, true, 'screen');
      if (!SDL.addedResizeListener) {
        SDL.addedResizeListener = true;
        Browser.resizeListeners.push(function(w, h) {
          SDL.receiveEvent({
            type: 'resize',
            w: w,
            h: h
          });
        });
      }
      return SDL.screen;
    }
  function _get_window_width() { return window.innerWidth; }
  function _get_window_height() { return window.innerHeight; }
  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        return FS.llseek(stream, offset, whence);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var ret = _lseek(stream, offset, whence);
      if (ret == -1) {
        return -1;
      }
      stream = FS.getStream(stream);
      stream.eof = false;
      return 0;
    }
  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      stream = FS.getStream(stream);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      if (FS.isChrdev(stream.node.mode)) {
        ___setErrNo(ERRNO_CODES.ESPIPE);
        return -1;
      } else {
        return stream.position;
      }
    }
  function ___assert_fail(condition, filename, line, func) {
      ABORT = true;
      throw 'Assertion failed: ' + Pointer_stringify(condition) + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + stackTrace();
    }
  function _qsort(base, num, size, cmp) {
      if (num == 0 || size == 0) return;
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var keys = [];
      for (var i = 0; i < num; i++) keys.push(i);
      keys.sort(function(a, b) {
        return Module['dynCall_iii'](cmp, base+a*size, base+b*size);
      });
      // apply the sort
      var temp = _malloc(num*size);
      _memcpy(temp, base, num*size);
      for (var i = 0; i < num; i++) {
        if (keys[i] == i) continue; // already in place
        _memcpy(base+i*size, temp+keys[i]*size, size);
      }
      _free(temp);
    }
  function _isspace(chr) {
      return (chr == 32) || (chr >= 9 && chr <= 13);
    }function __parseInt(str, endptr, base, min, max, bits, unsign) {
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
      // Check for a plus/minus sign.
      var multiplier = 1;
      if (HEAP8[(str)] == 45) {
        multiplier = -1;
        str++;
      } else if (HEAP8[(str)] == 43) {
        str++;
      }
      // Find base.
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            str++;
          }
        }
      } else if (finalBase==16) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            str += 2;
          }
        }
      }
      if (!finalBase) finalBase = 10;
      // Get digits.
      var chr;
      var ret = 0;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          ret = ret * finalBase + digit;
          str++;
        }
      }
      // Apply sign.
      ret *= multiplier;
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
      // Unsign if needed.
      if (unsign) {
        if (Math.abs(ret) > max) {
          ret = max;
          ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          ret = unSign(ret, bits);
        }
      }
      // Validate range.
      if (ret > max || ret < min) {
        ret = ret > max ? max : min;
        ___setErrNo(ERRNO_CODES.ERANGE);
      }
      if (bits == 64) {
        return ((asm["setTempRet0"]((tempDouble=ret,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)),ret>>>0)|0);
      }
      return ret;
    }function _strtol(str, endptr, base) {
      return __parseInt(str, endptr, base, -2147483648, 2147483647, 32);  // LONG_MIN, LONG_MAX.
    }
  function _ldexp(x, exp_) {
      return x * Math.pow(2, exp_);
    }
  var _llvm_pow_f64=Math_pow;
  var _floorf=Math_floor;
  var _ceilf=Math_ceil;
  function _abort() {
      Module['abort']();
    }
  function ___errno_location() {
      return ___errno_state;
    }
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 79:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  function ___cxa_call_unexpected(exception) {
      Module.printErr('Unexpected exception thrown, this is not properly supported - aborting');
      ABORT = true;
      throw exception;
    }
FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
__ATINIT__.unshift({ func: function() { TTY.init() } });__ATEXIT__.push({ func: function() { TTY.shutdown() } });TTY.utf8 = new Runtime.UTF8Processor();
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); NODEFS.staticInit(); }
__ATINIT__.push({ func: function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); } });
GL.init()
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
___buildEnvironment(ENV);
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
var Math_min = Math.min;
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vif(index,a1,a2) {
  try {
    Module["dynCall_vif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiff(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiff"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiif(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiiiif"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer){"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;var n=env.__ZTVN10__cxxabiv117__class_type_infoE|0;var o=+env.NaN;var p=+env.Infinity;var q=0;var r=0;var s=0;var t=0;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=env.abort;var ab=env.assert;var ac=env.asmPrintInt;var ad=env.asmPrintFloat;var ae=env.min;var af=env.invoke_ii;var ag=env.invoke_vif;var ah=env.invoke_viiiii;var ai=env.invoke_vi;var aj=env.invoke_vii;var ak=env.invoke_iiiii;var al=env.invoke_iiii;var am=env.invoke_viii;var an=env.invoke_v;var ao=env.invoke_viiiiiiff;var ap=env.invoke_viiiiiif;var aq=env.invoke_viiiiii;var ar=env.invoke_iii;var as=env.invoke_iiiiii;var at=env.invoke_viiii;var au=env._llvm_lifetime_end;var av=env._lseek;var aw=env._glClearColor;var ax=env._fclose;var ay=env._glLinkProgram;var az=env._glBindTexture;var aA=env._fflush;var aB=env._strtol;var aC=env._fputc;var aD=env._Mix_PlayChannel;var aE=env._fwrite;var aF=env._llvm_eh_exception;var aG=env._fputs;var aH=env._glCompileShader;var aI=env._isspace;var aJ=env._Mix_Init;var aK=env._glDeleteTextures;var aL=env._read;var aM=env._Mix_OpenAudio;var aN=env._fsync;var aO=env._glGenTextures;var aP=env.___gxx_personality_v0;var aQ=env.___resumeException;var aR=env._glCreateShader;var aS=env._strcmp;var aT=env._strncmp;var aU=env._glTexSubImage2D;var aV=env._snprintf;var aW=env._SDL_RWFromFile;var aX=env._get_window_height;var aY=env._ceilf;var aZ=env._glGetProgramiv;var a_=env._glVertexAttribPointer;var a$=env._mknod;var a0=env._glGetUniformLocation;var a1=env._close;var a2=env._strchr;var a3=env._Mix_LoadWAV_RW;var a4=env.___setErrNo;var a5=env._glDrawArrays;var a6=env._ftell;var a7=env._exit;var a8=env._sprintf;var a9=env._strrchr;var ba=env._glAttachShader;var bb=env._asprintf;var bc=env.___cxa_is_number_type;var bd=env.___cxa_does_inherit;var be=env._recv;var bf=env.__ZSt18uncaught_exceptionv;var bg=env._cos;var bh=env._puts;var bi=env.___cxa_call_unexpected;var bj=env._SDL_Init;var bk=env._get_window_width;var bl=env.__exit;var bm=env._fabsf;var bn=env._floorf;var bo=env._qsort;var bp=env.___cxa_throw;var bq=env._glDisableVertexAttribArray;var br=env._ldexp;var bs=env._send;var bt=env._glShaderSource;var bu=env._pread;var bv=env._SDL_SetVideoMode;var bw=env._fopen;var bx=env._open;var by=env._sqrtf;var bz=env._sysconf;var bA=env._SDL_PollEvent;var bB=env._glClear;var bC=env._mkdir;var bD=env._glEnableVertexAttribArray;var bE=env.___cxa_find_matching_catch;var bF=env._strdup;var bG=env._glUniform4f;var bH=env.__formatString;var bI=env._SDL_GL_SwapBuffers;var bJ=env._getenv;var bK=env.__ZSt9terminatev;var bL=env._gettimeofday;var bM=env._llvm_pow_f64;var bN=env._sbrk;var bO=env.___errno_location;var bP=env._llvm_lifetime_start;var bQ=env.__parseInt;var bR=env._glUseProgram;var bS=env._glTexImage2D;var bT=env.___assert_fail;var bU=env._fread;var bV=env._abort;var bW=env.___buildEnvironment;var bX=env._glEnable;var bY=env.__reallyNegative;var bZ=env._fseek;var b_=env._write;var b$=env._glGetAttribLocation;var b0=env.___cxa_allocate_exception;var b1=env._sin;var b2=env._glBlendFunc;var b3=env._glCreateProgram;var b4=env._stat;var b5=env.___cxa_pure_virtual;var b6=env._vasprintf;var b7=env._glViewport;var b8=env._emscripten_set_main_loop;var b9=env._Mix_FreeChunk;var ca=env._glUniformMatrix4fv;var cb=env._pwrite;var cc=env._glTexParameteri;var cd=env._time;var ce=0.0;
// EMSCRIPTEN_START_FUNCS
function cu(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7&-8;return b|0}function cv(){return i|0}function cw(a){a=a|0;i=a}function cx(a,b){a=a|0;b=b|0;if((q|0)==0){q=a;r=b}}function cy(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0]}function cz(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0];a[k+4|0]=a[b+4|0];a[k+5|0]=a[b+5|0];a[k+6|0]=a[b+6|0];a[k+7|0]=a[b+7|0]}function cA(a){a=a|0;D=a}function cB(a){a=a|0;E=a}function cC(a){a=a|0;F=a}function cD(a){a=a|0;G=a}function cE(a){a=a|0;H=a}function cF(a){a=a|0;I=a}function cG(a){a=a|0;J=a}function cH(a){a=a|0;K=a}function cI(a){a=a|0;L=a}function cJ(a){a=a|0;M=a}function cK(){c[954]=n+8;c[956]=m+8;c[1366]=n+8;c[1368]=n+8;c[1370]=m+8;c[1374]=m+8;c[1378]=n+8;c[1380]=m+8;c[1384]=m+8;c[1388]=m+8;c[1392]=m+8;c[1396]=m+8;c[1400]=m+8;c[1404]=m+8;c[1408]=m+8;c[1412]=n+8;c[1422]=n+8;c[1424]=n+8;c[1426]=m+8;c[1446]=n+8;c[1448]=m+8;c[1460]=m+8;c[1472]=m+8;c[1476]=m+8;c[1480]=n+8;c[1482]=m+8;c[1486]=m+8;c[1490]=n+8}function cL(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0;e=d;f=cr[c[(c[e>>2]|0)+12>>2]&15](d,3344)|0;h=d;i=+(cr[c[(c[h>>2]|0)+40>>2]&15](d,f)|0);j=+(cr[c[(c[h>>2]|0)+44>>2]&15](d,f)|0);c[a+4>>2]=d;g[a+8>>2]=0.0;g[a+12>>2]=0.0;g[a+16>>2]=i;g[a+20>>2]=j;c[a+24>>2]=f;g[a+28>>2]=0.0;g[a+32>>2]=1.0;c[a>>2]=4520;c[a+36>>2]=4544;c[a+40>>2]=b;b=cr[c[(c[e>>2]|0)+12>>2]&15](d,3328)|0;e=cr[c[(c[h>>2]|0)+40>>2]&15](d,b)|0;j=+(cr[c[(c[h>>2]|0)+44>>2]&15](d,b)|0);c[a+48>>2]=d;g[a+52>>2]=0.0;g[a+56>>2]=0.0;g[a+60>>2]=+(e|0);g[a+64>>2]=j;c[a+44>>2]=4152;c[a+68>>2]=b;g[a+72>>2]=0.0;g[a+76>>2]=1.0;b=d;c[a+80>>2]=cr[c[(c[b>>2]|0)+20>>2]&15](d,2496)|0;c[a+84>>2]=cr[c[(c[b>>2]|0)+20>>2]&15](d,2104)|0;g[a+88>>2]=5.0;g[a+92>>2]=0.0;return}function cM(a){a=a|0;var b=0,d=0;c[a>>2]=4520;c[a+36>>2]=4544;b=c[a+84>>2]|0;if((b|0)!=0){ci[c[(c[b>>2]|0)+4>>2]&127](b)}b=c[a+80>>2]|0;if((b|0)==0){d=a;fz(d);return}ci[c[(c[b>>2]|0)+4>>2]&127](b);d=a;fz(d);return}function cN(a){a=a|0;var b=0;c[a>>2]=4520;c[a+36>>2]=4544;b=c[a+84>>2]|0;if((b|0)!=0){ci[c[(c[b>>2]|0)+4>>2]&127](b)}b=c[a+80>>2]|0;if((b|0)==0){return}ci[c[(c[b>>2]|0)+4>>2]&127](b);return}function cO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0.0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0;d=i;i=i+16|0;e=d|0;f=d+8|0;h=c[a+4>>2]|0;cm[c[(c[h>>2]|0)+32>>2]&15](h,e,f);h=c[b>>2]|0;do{if((h|0)==0){j=a+92|0;k=+g[j>>2]+.5;g[j>>2]=k;l=a+12|0;m=+g[l>>2]+k;g[l>>2]=m;n=a+20|0;if(m>+(c[f>>2]|0)- +g[n>>2]){c0(c[a+40>>2]|0);g[l>>2]=+(c[f>>2]|0)- +g[n>>2];m=+g[j>>2]*-.6;g[j>>2]=m;do{if(+O(+m)>1.0){j=c[a+80>>2]|0;if((j|0)==0){break}ci[c[(c[j>>2]|0)+8>>2]&127](j)}}while(0);j=a+88|0;m=+g[j>>2]*.5;g[j>>2]=m;o=m}else{o=+g[a+88>>2]}j=a+88|0;m=o*.99;g[j>>2]=m;n=a+8|0;k=+g[n>>2]+m;g[n>>2]=k;if(k<0.0){g[n>>2]=0.0;p=m*-.9;g[j>>2]=p;q=0.0;r=p}else{q=k;r=m}s=a+16|0;m=+(c[e>>2]|0)- +g[s>>2];if(q>m){g[n>>2]=m;k=r*-.9;g[j>>2]=k;t=k;u=m}else{t=r;u=q}j=a+28|0;g[j>>2]=t+ +g[j>>2];g[a+52>>2]=u;g[a+56>>2]=+g[l>>2];v=n;w=s}else if((h|0)==1){s=a+40|0;n=c[s>>2]|0;if((c[n+20>>2]|0)!=1){i=d;return}j=a+8|0;x=a+16|0;m=+g[x>>2]*.5;y=a+20|0;z=c[b+4>>2]|0;k=+(z|0)-(+g[j>>2]+m);A=c[b+8>>2]|0;p=+(A|0)-(+g[a+12>>2]+ +g[y>>2]*.5);if(+P(k*k+p*p)>=m){v=j;w=x;break}if(!(cZ(n,z,A)|0)){v=j;w=x;break}A=a+88|0;g[A>>2]=+g[A>>2]-k*10.0/+g[x>>2];k=+g[y>>2];g[a+92>>2]=(p+k*.5)*-30.0/k;y=(c[s>>2]|0)+704|0;c[y>>2]=(c[y>>2]|0)+1;y=c[a+84>>2]|0;if((y|0)==0){v=j;w=x;break}ci[c[(c[y>>2]|0)+8>>2]&127](y);v=j;w=x}else{v=a+8|0;w=a+16|0}}while(0);g[(c[a+40>>2]|0)+712>>2]=(+g[v>>2]/(+(c[e>>2]|0)- +g[w>>2])+-.5)*2.0;i=d;return}function cP(a,b){a=a|0;b=b|0;cO(a-96+60|0,b);return}function cQ(a){a=a|0;df(a|0);df(a+44|0);return}function cR(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0;e=i;i=i+16|0;f=e|0;h=e+8|0;c[a>>2]=4328;c[a+4>>2]=b;b=d;j=cr[c[(c[b>>2]|0)+12>>2]&15](d,1672)|0;k=d;l=+(cr[c[(c[k>>2]|0)+40>>2]&15](d,j)|0);m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,j)|0);c[a+12>>2]=d;g[a+16>>2]=0.0;n=a+20|0;g[n>>2]=0.0;o=a+24|0;g[o>>2]=l;p=a+28|0;g[p>>2]=m;c[a+32>>2]=j;g[a+36>>2]=0.0;g[a+40>>2]=1.0;c[a+8>>2]=4768;g[a+44>>2]=0.0;j=cr[c[(c[b>>2]|0)+12>>2]&15](d,2664)|0;q=cr[c[(c[k>>2]|0)+40>>2]&15](d,j)|0;m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,j)|0);c[a+52>>2]=d;g[a+56>>2]=0.0;r=a+60|0;g[r>>2]=0.0;s=a+64|0;g[s>>2]=+(q|0);q=a+68|0;g[q>>2]=m;c[a+72>>2]=j;g[a+76>>2]=0.0;g[a+80>>2]=1.0;c[a+48>>2]=4768;g[a+84>>2]=0.0;j=cr[c[(c[b>>2]|0)+12>>2]&15](d,2200)|0;t=cr[c[(c[k>>2]|0)+40>>2]&15](d,j)|0;m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,j)|0);c[a+92>>2]=d;g[a+96>>2]=0.0;u=a+100|0;g[u>>2]=0.0;v=a+104|0;g[v>>2]=+(t|0);t=a+108|0;g[t>>2]=m;c[a+112>>2]=j;g[a+116>>2]=0.0;g[a+120>>2]=1.0;c[a+88>>2]=4768;g[a+124>>2]=0.0;j=cr[c[(c[b>>2]|0)+12>>2]&15](d,1752)|0;b=cr[c[(c[k>>2]|0)+40>>2]&15](d,j)|0;m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,j)|0);c[a+132>>2]=d;g[a+136>>2]=0.0;k=a+140|0;g[k>>2]=0.0;w=a+144|0;g[w>>2]=+(b|0);b=a+148|0;g[b>>2]=m;c[a+152>>2]=j;g[a+156>>2]=0.0;g[a+160>>2]=1.0;c[a+128>>2]=4768;g[a+164>>2]=0.0;cm[c[(c[d>>2]|0)+32>>2]&15](d,f,h);m=+(c[f>>2]|0);g[w>>2]=m;g[v>>2]=m;g[s>>2]=m;g[o>>2]=m;m=+(c[h>>2]|0)- +g[t>>2];g[u>>2]=m;l=+g[q>>2];x=m-l;g[r>>2]=x;g[n>>2]=0.0;g[p>>2]=x;g[k>>2]=x+l- +g[b>>2];i=e;return}function cS(a){a=a|0;var b=0;b=(c[a+4>>2]|0)+712|0;g[a+44>>2]=+g[b>>2]/20.0;g[a+84>>2]=+g[b>>2]*.5;g[a+124>>2]=+g[b>>2];g[a+164>>2]=+g[b>>2]/1.5;dg(a+8|0);dg(a+48|0);dg(a+88|0);dg(a+128|0);return}function cT(a,b){a=a|0;b=b|0;return}function cU(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0;d=i;i=i+16|0;e=d|0;f=a|0;h=a+8|0;j=h;c[h>>2]=j;c[a+12>>2]=j;c[a+16>>2]=0;c[a>>2]=4472;c[a+4>>2]=4496;c[a+20>>2]=0;c[a+24>>2]=b;j=a+28|0;dx(j,a,b);h=a+320|0;cL(h,a,b);k=a+416|0;d$(k,b);l=a+464|0;cR(l,a,b);m=c[(c[b>>2]|0)+16>>2]|0;g[e>>2]=0.0;g[e+4>>2]=0.0;g[e+8>>2]=0.0;g[e+12>>2]=1.0;n=ck[m&3](b,e,200,496)|0;e=b;m=cr[c[(c[e>>2]|0)+40>>2]&15](b,n)|0;o=+(cr[c[(c[e>>2]|0)+44>>2]&15](b,n)|0);c[a+636>>2]=b;g[a+640>>2]=0.0;g[a+644>>2]=0.0;g[a+648>>2]=+(m|0);g[a+652>>2]=o;c[a+656>>2]=n;g[a+660>>2]=0.0;g[a+664>>2]=1.0;c[a+632>>2]=4184;c[a+668>>2]=bF(496)|0;g[a+672>>2]=0.0;g[a+676>>2]=0.0;g[a+680>>2]=0.0;g[a+684>>2]=1.0;c[a+688>>2]=200;d5(a+692|0,50.0);n=a;fF(a+704|0,0,16);cj[c[(c[n>>2]|0)+12>>2]&63](f,(j|0)==0?0:a+64|0);cj[c[(c[n>>2]|0)+12>>2]&63](f,(h|0)==0?0:a+356|0);cj[c[(c[n>>2]|0)+12>>2]&63](f,l|0);cj[c[(c[n>>2]|0)+12>>2]&63](f,(k|0)==0?0:a+452|0);cV(a);dA(j);i=d;return}function cV(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=c[a+24>>2]|0;e=cf[c[(c[d>>2]|0)+24>>2]&15](d)|0;ec(e);d=eb(1616,(f=i,i=i+8|0,c[f>>2]=e,f)|0)|0;i=f;f=bw(d|0,2064)|0;e=a+708|0;if((f|0)==0){c[e>>2]=0;ft(d);i=b;return}if((bU(e|0,4,1,f|0)|0)!=1){c[e>>2]=0}ax(f|0)|0;ft(d);i=b;return}function cW(a){a=a|0;cX(a);fz(a);return}function cX(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=a|0;c[b>>2]=4472;d=a+4|0;c[d>>2]=4496;c[a+632>>2]=4184;e=c[a+656>>2]|0;if((e|0)!=0){ci[c[(c[e>>2]|0)+4>>2]&127](e)}ft(c[a+668>>2]|0);cN(a+320|0);de(a+28|0);c[b>>2]=4592;c[d>>2]=4616;d=a+8|0;b=a+16|0;if((c[b>>2]|0)==0){return}e=c[a+12>>2]|0;a=d;f=(c[d>>2]|0)+4|0;d=e|0;c[(c[d>>2]|0)+4>>2]=c[f>>2];c[c[f>>2]>>2]=c[d>>2];c[b>>2]=0;if((e|0)==(a|0)){return}else{g=e}while(1){e=c[g+4>>2]|0;fz(g);if((e|0)==(a|0)){break}else{g=e}}return}function cY(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;b=i;i=i+40|0;d=b|0;e=b+24|0;f=b+32|0;h=d+16|0;j=d;c[h>>2]=j;c[d>>2]=3672;c[d+4>>2]=a;d6(a+692|0,d);k=c[h>>2]|0;do{if((k|0)==(j|0)){ci[c[(c[d>>2]|0)+16>>2]&127](j)}else{if((k|0)==0){break}ci[c[(c[k>>2]|0)+20>>2]&127](k)}}while(0);k=a+24|0;j=c[k>>2]|0;ci[c[(c[j>>2]|0)+28>>2]&127](j);cS(a+464|0);d2(a+416|0);cQ(a+320|0);j=c[k>>2]|0;cm[c[(c[j>>2]|0)+32>>2]&15](j,e,f);j=c[a+704>>2]|0;if((j|0)==0){l=a+28|0;dD(l);m=c[k>>2]|0;n=m;o=c[n>>2]|0;p=o+56|0;q=c[p>>2]|0;ci[q&127](m);i=b;return}d=a+632|0;dj(d,2536,(h=i,i=i+8|0,c[h>>2]=j,h)|0);i=h;g[a+640>>2]=(+(c[e>>2]|0)- +g[a+648>>2])*.5;g[a+644>>2]=+((c[f>>2]|0)/4|0|0)- +g[a+652>>2]*.5;dh(d);l=a+28|0;dD(l);m=c[k>>2]|0;n=m;o=c[n>>2]|0;p=o+56|0;q=c[p>>2]|0;ci[q&127](m);i=b;return}function cZ(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0;e=i;i=i+16|0;f=e+8|0;h=c[a+24>>2]|0;cm[c[(c[h>>2]|0)+32>>2]&15](h,e|0,f);c[a+716>>2]=30;j=+(b-100|0);g[a+456>>2]=j;k=+(c[f>>2]|0);if(+g[a+428>>2]==k){g[a+424>>2]=j}j=+(d|0);d=a+460|0;g[d>>2]=j;if(j>=k- +g[a+436>>2]){l=1;i=e;return l|0}g[d>>2]=k;l=0;i=e;return l|0}function c_(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;e=d|0;f=d+8|0;do{if((c[b>>2]|0)==0){h=a+716|0;j=c[h>>2]|0;if((j|0)<=0){break}k=j-1|0;c[h>>2]=k;if((k|0)!=0){break}k=c[a+24>>2]|0;cm[c[(c[k>>2]|0)+32>>2]&15](k,e,f);g[a+460>>2]=+(c[f>>2]|0)}}while(0);f=c[a+12>>2]|0;e=a+8|0;if((f|0)==(e|0)){i=d;return}else{l=f}do{f=c[l+8>>2]|0;cj[c[c[f>>2]>>2]&63](f,b);l=c[l+4>>2]|0;}while((l|0)!=(e|0));i=d;return}function c$(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[a+12>>2]|0;e=a+8|0;if((d|0)==(e|0)){return}else{f=d}do{d=c[f+8>>2]|0;cj[c[c[d>>2]>>2]&63](d,b);f=c[f+4>>2]|0;}while((f|0)!=(e|0));return}function c0(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;d=a+704|0;e=c[d>>2]|0;f=a+708|0;if((e|0)<=(c[f>>2]|0)){c[d>>2]=0;i=b;return}c[f>>2]=e;e=c[a+24>>2]|0;g=cf[c[(c[e>>2]|0)+24>>2]&15](e)|0;ec(g);e=eb(1616,(h=i,i=i+8|0,c[h>>2]=g,h)|0)|0;i=h;h=bw(e|0,2488)|0;if((h|0)!=0){g=f;aE(g|0,4,1,h|0)|0;ax(h|0)|0}ft(e);dA(a+28|0);c[d>>2]=0;i=b;return}function c1(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=a+8|0;e=fx(12)|0;f=e;g=e+8|0;if((g|0)!=0){c[g>>2]=b}b=d|0;c[(c[b>>2]|0)+4>>2]=f;c[e>>2]=c[b>>2];c[b>>2]=f;c[e+4>>2]=d;d=a+16|0;c[d>>2]=(c[d>>2]|0)+1;return}function c2(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a-20+16|0;a=d+8|0;e=fx(12)|0;f=e+8|0;if((f|0)!=0){c[f>>2]=b}b=a;c[(c[b>>2]|0)+4>>2]=e;c[e>>2]=c[b>>2];c[a>>2]=e;c[e+4>>2]=a;a=d+16|0;c[a>>2]=(c[a>>2]|0)+1;return}function c3(a){a=a|0;fz(a);return}function c4(a){a=a|0;var b=0,d=0;b=fx(8)|0;if((b|0)==0){d=b;return d|0}c[b>>2]=3672;c[b+4>>2]=c[a+4>>2];d=b;return d|0}function c5(a,b){a=a|0;b=b|0;if((b|0)==0){return}c[b>>2]=3672;c[b+4>>2]=c[a+4>>2];return}function c6(a){a=a|0;return}function c7(a){a=a|0;fz(a);return}function c8(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b|0;e=c[a+4>>2]|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;cj[c[c[e>>2]>>2]&63](e,d);i=b;return}function c9(a,b){a=a|0;b=b|0;var d=0;if((c[b+4>>2]|0)!=3712){d=0;return d|0}d=a+4|0;return d|0}function da(a){a=a|0;return 3816}function db(a){a=a|0;return}function dc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;c[a>>2]=4592;c[a+4>>2]=4616;b=a+8|0;d=a+16|0;if((c[d>>2]|0)==0){return}e=c[a+12>>2]|0;a=b;f=(c[b>>2]|0)+4|0;b=e|0;c[(c[b>>2]|0)+4>>2]=c[f>>2];c[c[f>>2]>>2]=c[b>>2];c[d>>2]=0;if((e|0)==(a|0)){return}else{g=e}while(1){e=c[g+4>>2]|0;fz(g);if((e|0)==(a|0)){break}else{g=e}}return}function dd(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;c[a>>2]=4592;c[a+4>>2]=4616;b=a+8|0;d=a+16|0;if((c[d>>2]|0)==0){e=a;fz(e);return}f=c[a+12>>2]|0;g=b;h=(c[b>>2]|0)+4|0;b=f|0;c[(c[b>>2]|0)+4>>2]=c[h>>2];c[c[h>>2]>>2]=c[b>>2];c[d>>2]=0;if((f|0)==(g|0)){e=a;fz(e);return}else{i=f}while(1){f=c[i+4>>2]|0;fz(i);if((f|0)==(g|0)){break}else{i=f}}e=a;fz(e);return}function de(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;c[a>>2]=4400;b=a+36|0;c[b>>2]=4424;d=a+40|0;c[d>>2]=4448;e=c[a+288>>2]|0;if((e|0)!=0){fz(e)}e=c[a+280>>2]|0;if((e|0)!=0){fz(e)}e=c[a+272>>2]|0;if((e|0)!=0){fz(e)}du(a+212|0);c[a+152>>2]=4184;e=c[a+176>>2]|0;if((e|0)!=0){ci[c[(c[e>>2]|0)+4>>2]&127](e)}ft(c[a+188>>2]|0);c[b>>2]=4592;c[d>>2]=4616;d=a+44|0;b=a+52|0;if((c[b>>2]|0)==0){return}e=c[a+48>>2]|0;a=d;f=(c[d>>2]|0)+4|0;d=e|0;c[(c[d>>2]|0)+4>>2]=c[f>>2];c[c[f>>2]>>2]=c[d>>2];c[b>>2]=0;if((e|0)==(a|0)){return}else{g=e}while(1){e=c[g+4>>2]|0;fz(g);if((e|0)==(a|0)){break}else{g=e}}return}function df(a){a=a|0;var b=0;b=c[a+4>>2]|0;co[c[(c[b>>2]|0)+36>>2]&3](b,c[a+24>>2]|0,~~+g[a+8>>2],~~+g[a+12>>2],~~+g[a+16>>2],~~+g[a+20>>2],+g[a+28>>2],+g[a+32>>2]);return}function dg(a){a=a|0;var b=0;b=c[a+4>>2]|0;cp[c[(c[b>>2]|0)+52>>2]&3](b,c[a+24>>2]|0,~~+g[a+8>>2],~~+g[a+12>>2],~~+g[a+16>>2],~~+g[a+20>>2],+g[a+36>>2]);return}function dh(a){a=a|0;var b=0;b=c[a+4>>2]|0;co[c[(c[b>>2]|0)+36>>2]&3](b,c[a+24>>2]|0,~~+g[a+8>>2],~~+g[a+12>>2],~~+g[a+16>>2],~~+g[a+20>>2],+g[a+28>>2],+g[a+32>>2]);return}function di(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+16|0;e=d|0;f=a+36|0;if((aS(c[f>>2]|0,b|0)|0)==0){i=d;return}h=a+24|0;j=c[h>>2]|0;if((j|0)!=0){ci[c[(c[j>>2]|0)+4>>2]&127](j)}j=bF(b|0)|0;ft(c[f>>2]|0);c[f>>2]=j;j=a+4|0;f=c[j>>2]|0;k=c[(c[f>>2]|0)+16>>2]|0;l=e;m=a+40|0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];m=ck[k&3](f,e,c[a+56>>2]|0,b)|0;c[h>>2]=m;b=c[j>>2]|0;g[a+16>>2]=+(cr[c[(c[b>>2]|0)+40>>2]&15](b,m)|0);m=c[j>>2]|0;g[a+20>>2]=+(cr[c[(c[m>>2]|0)+44>>2]&15](m,c[h>>2]|0)|0);i=d;return}function dj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+24|0;f=e|0;g=e+16|0;h=f;c[h>>2]=d;c[h+4>>2]=0;b6(g|0,b|0,f|0)|0;di(a,c[g>>2]|0);ft(c[g>>2]|0);i=e;return}function dk(a){a=a|0;return}function dl(a){a=a|0;fz(a);return}function dm(a){a=a|0;return}function dn(a){a=a|0;fz(a);return}function dp(a){a=a|0;var b=0;c[a>>2]=4184;b=c[a+24>>2]|0;if((b|0)!=0){ci[c[(c[b>>2]|0)+4>>2]&127](b)}ft(c[a+36>>2]|0);return}function dq(a){a=a|0;var b=0;c[a>>2]=4184;b=c[a+24>>2]|0;if((b|0)!=0){ci[c[(c[b>>2]|0)+4>>2]&127](b)}ft(c[a+36>>2]|0);fz(a);return}function dr(a,b){a=a|0;b=b|0;var d=0.0,e=0.0;if((c[b>>2]|0)!=1){return}d=+(c[b+4>>2]|0);e=+g[a+8>>2];if(d<e){return}if(d>e+ +g[a+16>>2]){return}e=+(c[b+8>>2]|0);d=+g[a+12>>2];if(e<d){return}if(e>d+ +g[a+20>>2]){return}b=c[a+40>>2]|0;if((b+108|0)==(a|0)){c[b+56>>2]=1;return}if((b+64|0)!=(a|0)){return}c[(c[b+60>>2]|0)+20>>2]=1;return}function ds(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0;d=a-44+8|0;a=d;if((c[b>>2]|0)!=1){return}e=+(c[b+4>>2]|0);f=+g[d+8>>2];if(e<f){return}if(e>f+ +g[d+16>>2]){return}f=+(c[b+8>>2]|0);e=+g[d+12>>2];if(f<e){return}if(f>e+ +g[d+20>>2]){return}b=c[d+40>>2]|0;if((b+108|0)==(a|0)){c[b+56>>2]=1;return}if((b+64|0)!=(a|0)){return}c[(c[b+60>>2]|0)+20>>2]=1;return}function dt(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;c[a>>2]=4216;b=a+44|0;d=a+48|0;e=b;f=c[d>>2]|0;if((f|0)!=(e|0)){g=f;do{f=c[g+8>>2]|0;if((f|0)!=0){ci[c[(c[f>>2]|0)+4>>2]&127](f)}g=c[g+4>>2]|0;}while((g|0)!=(e|0))}g=a+52|0;if((c[g>>2]|0)==0){h=a;fz(h);return}f=c[d>>2]|0;d=(c[b>>2]|0)+4|0;b=f|0;c[(c[b>>2]|0)+4>>2]=c[d>>2];c[c[d>>2]>>2]=c[b>>2];c[g>>2]=0;if((f|0)==(e|0)){h=a;fz(h);return}else{i=f}while(1){f=c[i+4>>2]|0;fz(i);if((f|0)==(e|0)){break}else{i=f}}h=a;fz(h);return}function du(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;c[a>>2]=4216;b=a+44|0;d=a+48|0;e=b;f=c[d>>2]|0;if((f|0)!=(e|0)){g=f;do{f=c[g+8>>2]|0;if((f|0)!=0){ci[c[(c[f>>2]|0)+4>>2]&127](f)}g=c[g+4>>2]|0;}while((g|0)!=(e|0))}g=a+52|0;if((c[g>>2]|0)==0){return}a=c[d>>2]|0;d=(c[b>>2]|0)+4|0;b=a|0;c[(c[b>>2]|0)+4>>2]=c[d>>2];c[c[d>>2]>>2]=c[b>>2];c[g>>2]=0;if((a|0)==(e|0)){return}else{h=a}while(1){a=c[h+4>>2]|0;fz(h);if((a|0)==(e|0)){break}else{h=a}}return}function dv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;d=i;i=i+48|0;e=d|0;f=d+32|0;h=fx(60)|0;j=c[a+4>>2]|0;k=a+24|0;l=f;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];c[l+8>>2]=c[k+8>>2];c[l+12>>2]=c[k+12>>2];l=c[a+40>>2]|0;m=f;f=d+16|0;c[f>>2]=c[k>>2];c[f+4>>2]=c[k+4>>2];c[f+8>>2]=c[k+8>>2];c[f+12>>2]=c[k+12>>2];k=e;n=c[(c[j>>2]|0)+16>>2]|0;c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[k+12>>2]=c[m+12>>2];m=ck[n&3](j,e,l,b)|0;e=j;n=cr[c[(c[e>>2]|0)+40>>2]&15](j,m)|0;o=+(cr[c[(c[e>>2]|0)+44>>2]&15](j,m)|0);c[h+4>>2]=j;g[h+8>>2]=0.0;g[h+12>>2]=0.0;g[h+16>>2]=+(n|0);g[h+20>>2]=o;c[h+24>>2]=m;g[h+28>>2]=0.0;g[h+32>>2]=1.0;c[h>>2]=4184;c[h+36>>2]=bF(b|0)|0;b=h+40|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];c[h+56>>2]=l;l=a+44|0;f=fx(12)|0;b=f;m=f+8|0;if((m|0)==0){p=l;q=l|0;r=c[q>>2]|0;s=r+4|0;c[s>>2]=b;t=c[q>>2]|0;u=f;c[u>>2]=t;c[q>>2]=b;v=f+4|0;w=v;c[w>>2]=p;x=a+52|0;y=c[x>>2]|0;z=y+1|0;c[x>>2]=z;i=d;return}c[m>>2]=h;p=l;q=l|0;r=c[q>>2]|0;s=r+4|0;c[s>>2]=b;t=c[q>>2]|0;u=f;c[u>>2]=t;c[q>>2]=b;v=f+4|0;w=v;c[w>>2]=p;x=a+52|0;y=c[x>>2]|0;z=y+1|0;c[x>>2]=z;i=d;return}function dw(a){a=a|0;var b=0,d=0,e=0;b=a+44|0;d=c[a+48>>2]|0;if((d|0)==(b|0)){return}else{e=d}do{d=c[e+8>>2]|0;ci[c[(c[d>>2]|0)+8>>2]&127](d);e=c[e+4>>2]|0;}while((e|0)!=(b|0));return}function dx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0;e=i;i=i+16|0;f=e|0;h=d;j=cr[c[(c[h>>2]|0)+12>>2]&15](d,2016)|0;k=d;l=+(cr[c[(c[k>>2]|0)+40>>2]&15](d,j)|0);m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,j)|0);c[a+4>>2]=d;g[a+8>>2]=0.0;g[a+12>>2]=0.0;g[a+16>>2]=l;g[a+20>>2]=m;c[a+24>>2]=j;g[a+28>>2]=0.0;g[a+32>>2]=1.0;j=a+36|0;n=a+44|0;o=n;c[n>>2]=o;c[a+48>>2]=o;c[a+52>>2]=0;c[a>>2]=4400;c[a+36>>2]=4424;c[a+40>>2]=4448;c[a+56>>2]=0;c[a+60>>2]=b;b=cr[c[(c[h>>2]|0)+12>>2]&15](d,2736)|0;o=cr[c[(c[k>>2]|0)+40>>2]&15](d,b)|0;m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,b)|0);c[a+68>>2]=d;g[a+72>>2]=0.0;g[a+76>>2]=0.0;g[a+80>>2]=+(o|0);g[a+84>>2]=m;c[a+88>>2]=b;g[a+92>>2]=0.0;g[a+96>>2]=1.0;b=a+100|0;c[a+64>>2]=4280;c[b>>2]=4304;c[a+104>>2]=a;o=j;cj[c[(c[o>>2]|0)+12>>2]&63](j,b);b=cr[c[(c[h>>2]|0)+12>>2]&15](d,2432)|0;h=cr[c[(c[k>>2]|0)+40>>2]&15](d,b)|0;m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,b)|0);c[a+112>>2]=d;g[a+116>>2]=0.0;g[a+120>>2]=0.0;g[a+124>>2]=+(h|0);g[a+128>>2]=m;c[a+132>>2]=b;g[a+136>>2]=0.0;g[a+140>>2]=1.0;b=a+144|0;c[a+108>>2]=4280;c[b>>2]=4304;c[a+148>>2]=a;cj[c[(c[o>>2]|0)+12>>2]&63](j,b);b=c[(c[d>>2]|0)+16>>2]|0;g[f>>2]=0.0;g[f+4>>2]=0.0;g[f+8>>2]=0.0;g[f+12>>2]=1.0;j=ck[b&3](d,f,25,2008)|0;f=cr[c[(c[k>>2]|0)+40>>2]&15](d,j)|0;m=+(cr[c[(c[k>>2]|0)+44>>2]&15](d,j)|0);c[a+156>>2]=d;g[a+160>>2]=0.0;g[a+164>>2]=0.0;g[a+168>>2]=+(f|0);g[a+172>>2]=m;c[a+176>>2]=j;g[a+180>>2]=0.0;g[a+184>>2]=1.0;c[a+152>>2]=4184;c[a+188>>2]=bF(2008)|0;g[a+192>>2]=0.0;g[a+196>>2]=0.0;g[a+200>>2]=0.0;g[a+204>>2]=1.0;c[a+208>>2]=25;j=a+212|0;c[a+216>>2]=d;fF(a+220|0,0,16);c[j>>2]=4216;g[a+236>>2]=0.0;g[a+240>>2]=0.0;g[a+244>>2]=0.0;g[a+248>>2]=1.0;c[a+252>>2]=20;d=a+256|0;f=d;c[d>>2]=f;c[a+260>>2]=f;f=a+268|0;d=a+272|0;k=a+276|0;b=a+280|0;o=a+284|0;h=a+288|0;fF(a+264|0,0,28);dv(j,1576);dv(j,1264);dv(j,976);dv(j,768);dv(j,376);dv(j,240);dy(a);a=c[d>>2]|0;if((a|0)!=0){fz(a);c[d>>2]=0}a=fx(20)|0;c[a>>2]=f;c[a+4>>2]=300;c[a+8>>2]=-1;m=+g[f>>2];g[a+12>>2]=m;g[a+16>>2]=m;c[d>>2]=a;a=c[b>>2]|0;if((a|0)!=0){fz(a);c[b>>2]=0}a=fx(20)|0;c[a>>2]=k;c[a+4>>2]=300;c[a+8>>2]=-1;m=+g[k>>2];g[a+12>>2]=m;g[a+16>>2]=m;c[b>>2]=a;a=c[h>>2]|0;if((a|0)!=0){fz(a);c[h>>2]=0}a=fx(20)|0;c[a>>2]=o;c[a+4>>2]=300;c[a+8>>2]=-1;m=+g[o>>2];g[a+12>>2]=m;g[a+16>>2]=m;c[h>>2]=a;i=e;return}function dy(a){a=a|0;var b=0,d=0,e=0,f=0,h=0.0,j=0,k=0,l=0.0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0,G=0,H=0.0,I=0.0,J=0,K=0.0,L=0,M=0;b=i;i=i+16|0;d=b|0;e=b+8|0;f=c[a+4>>2]|0;cm[c[(c[f>>2]|0)+32>>2]&15](f,d,e);f=c[a+60>>2]|0;do{if((c[f+20>>2]|0)==0){h=(+(c[e>>2]|0)- +g[a+20>>2])*.5;j=c[a+272>>2]|0;do{if((j|0)==0){g[a+268>>2]=h}else{k=j|0;l=+g[c[k>>2]>>2];if(l==h){break}m=j+8|0;do{if((c[m>>2]|0)==-1){n=l;o=j+16|0}else{p=ea()|0;q=c[m>>2]|0;r=c[j+4>>2]|0;if((p|0)<(r+q|0)){s=+(p-q|0)/+(r|0);r=j+16|0;n=s*+g[r>>2]+(1.0-s)*+g[j+12>>2];o=r;break}else{c[m>>2]=-1;r=j+16|0;n=+g[r>>2];o=r;break}}}while(0);g[j+12>>2]=n;g[c[k>>2]>>2]=h;g[o>>2]=h;c[m>>2]=ea()|0}}while(0);j=c[a+280>>2]|0;if((j|0)==0){g[a+276>>2]=.699999988079071;break}r=j|0;h=+g[c[r>>2]>>2];if(h==.699999988079071){break}q=j+8|0;do{if((c[q>>2]|0)==-1){t=h;u=j+16|0}else{p=ea()|0;v=c[q>>2]|0;w=c[j+4>>2]|0;if((p|0)<(w+v|0)){l=+(p-v|0)/+(w|0);w=j+16|0;t=l*+g[w>>2]+(1.0-l)*+g[j+12>>2];u=w;break}else{c[q>>2]=-1;w=j+16|0;t=+g[w>>2];u=w;break}}}while(0);g[j+12>>2]=t;g[c[r>>2]>>2]=.699999988079071;g[u>>2]=.699999988079071;c[q>>2]=ea()|0}else{w=a+268|0;h=+g[a+20>>2];do{if((c[f+704>>2]|0)==0){l=50.0-h;v=c[a+272>>2]|0;if((v|0)==0){g[w>>2]=l;break}p=v|0;s=+g[c[p>>2]>>2];if(s==l){break}x=v+8|0;do{if((c[x>>2]|0)==-1){y=s;z=v+16|0}else{A=ea()|0;B=c[x>>2]|0;C=c[v+4>>2]|0;if((A|0)<(C+B|0)){D=+(A-B|0)/+(C|0);C=v+16|0;y=D*+g[C>>2]+(1.0-D)*+g[v+12>>2];z=C;break}else{c[x>>2]=-1;C=v+16|0;y=+g[C>>2];z=C;break}}}while(0);g[v+12>>2]=y;g[c[p>>2]>>2]=l;g[z>>2]=l;c[x>>2]=ea()|0}else{s=-0.0-h;m=c[a+272>>2]|0;if((m|0)==0){g[w>>2]=s;break}k=m|0;D=+g[c[k>>2]>>2];if(D==s){break}C=m+8|0;do{if((c[C>>2]|0)==-1){E=D;F=m+16|0}else{B=ea()|0;A=c[C>>2]|0;G=c[m+4>>2]|0;if((B|0)<(G+A|0)){H=+(B-A|0)/+(G|0);G=m+16|0;E=H*+g[G>>2]+(1.0-H)*+g[m+12>>2];F=G;break}else{c[C>>2]=-1;G=m+16|0;E=+g[G>>2];F=G;break}}}while(0);g[m+12>>2]=E;g[c[k>>2]>>2]=s;g[F>>2]=s;c[C>>2]=ea()|0}}while(0);w=c[a+280>>2]|0;if((w|0)==0){g[a+276>>2]=0.0;break}q=w|0;h=+g[c[q>>2]>>2];if(h==0.0){break}r=w+8|0;do{if((c[r>>2]|0)==-1){I=h;J=w+16|0}else{j=ea()|0;x=c[r>>2]|0;p=c[w+4>>2]|0;if((j|0)<(p+x|0)){D=+(j-x|0)/+(p|0);p=w+16|0;I=D*+g[p>>2]+(1.0-D)*+g[w+12>>2];J=p;break}else{c[r>>2]=-1;p=w+16|0;I=+g[p>>2];J=p;break}}}while(0);g[w+12>>2]=I;g[c[q>>2]>>2]=0.0;g[J>>2]=0.0;c[r>>2]=ea()|0}}while(0);J=a+16|0;F=a+8|0;g[F>>2]=(+(c[d>>2]|0)- +g[J>>2])*.5;z=c[a+272>>2]|0;do{if((z|0)==0){K=+g[a+268>>2]}else{f=z+8|0;if((c[f>>2]|0)==-1){K=+g[c[z>>2]>>2];break}u=ea()|0;o=c[f>>2]|0;p=c[z+4>>2]|0;if((u|0)<(p+o|0)){I=+(u-o|0)/+(p|0);K=I*+g[z+16>>2]+(1.0-I)*+g[z+12>>2];break}else{c[f>>2]=-1;K=+g[z+16>>2];break}}}while(0);g[a+12>>2]=K;I=+g[F>>2];E=+g[J>>2];g[a+72>>2]=I+(E- +g[a+80>>2])*.5;g[a+116>>2]=I+(E- +g[a+124>>2])*.5;g[a+160>>2]=I+(E- +g[a+168>>2])*.5;E=+g[a+20>>2];I=K+E+-50.0- +g[a+128>>2];g[a+120>>2]=I;K=I+-25.0- +g[a+84>>2];g[a+76>>2]=K;g[a+164>>2]=K+-25.0- +g[a+172>>2];J=(c[d>>2]|0)/2|0;d=~~(+((c[e>>2]|0)/2|0|0)+E*.125);e=a+256|0;F=c[a+260>>2]|0;if((F|0)==(e|0)){i=b;return}else{L=0;M=F}do{L=~~(+(L|0)+ +g[(c[M+8>>2]|0)+20>>2]);M=c[M+4>>2]|0;}while((M|0)!=(e|0));E=+(J|0);J=d-((L|0)/2|0)|0;L=F;while(1){F=c[L+8>>2]|0;g[F+8>>2]=E- +g[F+16>>2]*.5;K=+(J|0);g[F+12>>2]=K;d=c[L+4>>2]|0;if((d|0)==(e|0)){break}else{J=~~(K+ +g[F+20>>2]);L=d}}i=b;return}function dz(a){a=a|0;return}function dA(a){a=a|0;var b=0,d=0;b=i;dj(a+152|0,3312,(d=i,i=i+8|0,c[d>>2]=c[(c[a+60>>2]|0)+708>>2],d)|0);i=d;i=b;return}function dB(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0,j=0,k=0,l=0;d=i;do{if((c[b>>2]|0)==1){e=+(c[b+4>>2]|0);f=+g[a+8>>2];if(e<f){break}if(e>f+ +g[a+16>>2]){break}f=+(c[b+8>>2]|0);e=+g[a+12>>2];if(f<e){break}if(f>e+ +g[a+20>>2]){break}h=a+60|0;j=c[h>>2]|0;if((c[j+20>>2]|0)==1){dj(a+152|0,3312,(k=i,i=i+8|0,c[k>>2]=c[j+708>>2],k)|0);i=k;c[(c[h>>2]|0)+20>>2]=0;i=d;return}h=a+56|0;if((c[h>>2]|0)!=1){break}c[h>>2]=0;i=d;return}}while(0);h=c[a+48>>2]|0;k=a+44|0;if((h|0)==(k|0)){i=d;return}else{l=h}do{h=c[l+8>>2]|0;cj[c[c[h>>2]>>2]&63](h,b);l=c[l+4>>2]|0;}while((l|0)!=(k|0));i=d;return}function dC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0.0,j=0,k=0,l=0,m=0;d=i;e=a-292+256|0;do{if((c[b>>2]|0)==1){f=+(c[b+4>>2]|0);h=+g[a-292+264>>2];if(f<h){break}if(f>h+ +g[e+16>>2]){break}h=+(c[b+8>>2]|0);f=+g[e+12>>2];if(h<f){break}if(h>f+ +g[e+20>>2]){break}j=e+60|0;k=c[j>>2]|0;if((c[k+20>>2]|0)==1){dj(e+152|0,3312,(l=i,i=i+8|0,c[l>>2]=c[k+708>>2],l)|0);i=l;c[(c[j>>2]|0)+20>>2]=0;i=d;return}j=e+56|0;if((c[j>>2]|0)!=1){break}c[j>>2]=0;i=d;return}}while(0);a=c[e+48>>2]|0;j=e+44|0;if((a|0)==(j|0)){i=d;return}else{m=a}do{a=c[m+8>>2]|0;cj[c[c[a>>2]>>2]&63](a,b);m=c[m+4>>2]|0;}while((m|0)!=(j|0));i=d;return}function dD(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0;b=i;i=i+32|0;d=b|0;e=b+8|0;f=b+16|0;dy(a);h=a+284|0;j=(c[a+56>>2]|0)==1?1.0:0.0;k=a+288|0;l=c[k>>2]|0;do{if((l|0)==0){g[h>>2]=j}else{m=l|0;n=+g[c[m>>2]>>2];if(n==j){break}o=l+8|0;do{if((c[o>>2]|0)==-1){p=n;q=l+16|0}else{r=ea()|0;s=c[o>>2]|0;t=c[l+4>>2]|0;if((r|0)<(t+s|0)){u=+(r-s|0)/+(t|0);t=l+16|0;p=u*+g[t>>2]+(1.0-u)*+g[l+12>>2];q=t;break}else{c[o>>2]=-1;t=l+16|0;p=+g[t>>2];q=t;break}}}while(0);g[l+12>>2]=p;g[c[m>>2]>>2]=j;g[q>>2]=j;c[o>>2]=ea()|0}}while(0);q=a+4|0;l=c[q>>2]|0;cm[c[(c[l>>2]|0)+32>>2]&15](l,d,e);l=c[q>>2]|0;q=c[(c[l>>2]|0)+48>>2]|0;t=c[a+280>>2]|0;do{if((t|0)==0){v=+g[a+276>>2]}else{s=t+8|0;if((c[s>>2]|0)==-1){v=+g[c[t>>2]>>2];break}r=ea()|0;w=c[s>>2]|0;x=c[t+4>>2]|0;if((r|0)<(x+w|0)){j=+(r-w|0)/+(x|0);v=j*+g[t+16>>2]+(1.0-j)*+g[t+12>>2];break}else{c[s>>2]=-1;v=+g[t+16>>2];break}}}while(0);g[f>>2]=0.0;g[f+4>>2]=0.0;g[f+8>>2]=0.0;g[f+12>>2]=v;cq[q&15](l,f,0,0,c[d>>2]|0,c[e>>2]|0);df(a|0);e=c[k>>2]|0;do{if((e|0)==0){y=+g[h>>2]}else{d=e+8|0;if((c[d>>2]|0)==-1){y=+g[c[e>>2]>>2];break}f=ea()|0;l=c[d>>2]|0;q=c[e+4>>2]|0;if((f|0)<(q+l|0)){v=+(f-l|0)/+(q|0);y=v*+g[e+16>>2]+(1.0-v)*+g[e+12>>2];break}else{c[d>>2]=-1;y=+g[e+16>>2];break}}}while(0);v=1.0-y;e=a+152|0;g[a+184>>2]=v;d=a+108|0;g[a+140>>2]=v;q=a+64|0;g[a+96>>2]=v;l=c[k>>2]|0;do{if((l|0)==0){z=+g[h>>2]}else{k=l+8|0;if((c[k>>2]|0)==-1){z=+g[c[l>>2]>>2];break}f=ea()|0;t=c[k>>2]|0;s=c[l+4>>2]|0;if((f|0)<(s+t|0)){v=+(f-t|0)/+(s|0);z=v*+g[l+16>>2]+(1.0-v)*+g[l+12>>2];break}else{c[k>>2]=-1;z=+g[l+16>>2];break}}}while(0);l=a+260|0;h=a+256|0;a=c[l>>2]|0;if((a|0)!=(h|0)){k=a;do{g[(c[k+8>>2]|0)+32>>2]=z;k=c[k+4>>2]|0;}while((k|0)!=(h|0))}ci[c[(c[q>>2]|0)+8>>2]&127](q);ci[c[(c[d>>2]|0)+8>>2]&127](d);dh(e);e=c[l>>2]|0;if((e|0)==(h|0)){i=b;return}else{A=e}do{e=c[A+8>>2]|0;ci[c[(c[e>>2]|0)+8>>2]&127](e);A=c[A+4>>2]|0;}while((A|0)!=(h|0));i=b;return}function dE(a){a=a|0;fz(a);return}function dF(a){a=a|0;de(a);return}function dG(a){a=a|0;de(a);fz(a);return}function dH(a){a=a|0;de(a-292+256|0);return}function dI(a){a=a|0;var b=0;b=a-292+256|0;de(b);fz(b);return}function dJ(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+24|0;e=d|0;f=d+8|0;g=d+16|0;c[e>>2]=a;c[f>>2]=b;b=b3()|0;a=aR(35633)|0;bt(a|0,1,e|0,0);aH(a|0);ba(b|0,a|0);a=aR(35632)|0;bt(a|0,1,f|0,0);aH(a|0);ba(b|0,a|0);ay(b|0);c[g>>2]=0;aZ(b|0,35714,g|0);if((c[g>>2]|0)!=0){i=d;return b|0}bh(24)|0;i=d;return b|0}function dK(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0;c[a>>2]=4568;f=a+4|0;c[f>>2]=0;c[a+8>>2]=b;c[a+12>>2]=d;h=a+16|0;g[h>>2]=0.0;i=a+20|0;g[i>>2]=0.0;aO(1,f|0);az(3553,c[f>>2]|0);cc(3553,10241,9729);cc(3553,10240,9729);cc(3553,10242,33071);cc(3553,10243,33071);f=1;while(1){if((f|0)<(b|0)){f=f<<1}else{j=1;break}}while(1){if((j|0)<(d|0)){j=j<<1}else{break}}g[h>>2]=+(b|0)/+(f|0);g[i>>2]=+(d|0)/+(j|0);i=$(f<<2,j)|0;h=fy((i|0)>-1?i:-1)|0;fF(h|0,0,i|0);bS(3553,0,6408,f|0,j|0,0,6408,5121,h|0);if((h|0)!=0){fA(h)}if((e|0)==0){az(3553,0);return}aU(3553,0,0,0,b|0,d|0,6408,5121,e|0);az(3553,0);return}function dL(a){a=a|0;c[a>>2]=4568;aK(1,a+4|0);fz(a);return}function dM(a){a=a|0;c[a>>2]=4568;aK(1,a+4|0);return}function dN(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;e=i;i=i+16|0;c[a>>2]=4688;f=a+4|0;g[f>>2]=1.0;h=a+8|0;j=a+24|0;fF(h|0,0,16);g[j>>2]=1.0;k=a+28|0;l=a+44|0;fF(k|0,0,16);g[l>>2]=1.0;m=a+48|0;n=a+64|0;fF(m|0,0,16);g[n>>2]=1.0;aw(+0.0,+0.0,+0.0,+1.0);bX(3042);b2(770,771);c[a+80>>2]=480;o=(d*480|0|0)/(b|0)|0;c[a+84>>2]=o;p=+(b|0);q=p/480.0;r=+(d|0);s=+(o|0);t=r/s;u=q<t?q:t;g[a+68>>2]=u;t=u*480.0;o=~~((p-t)*.5);c[a+72>>2]=o;p=s*u;d=~~((r-p)*.5);c[a+76>>2]=d;r=0.0-s;b=e|0;fF(b|0,0,12);g[f>>2]=.004166666883975267;f=h;c[f>>2]=0;c[f+4>>2]=0;g[a+16>>2]=-1.0;g[a+20>>2]=0.0;g[j>>2]=2.0/r;g[k>>2]=0.0;g[a+32>>2]=(-0.0-s)/r;k=a+36|0;c[k>>2]=0;c[k+4>>2]=0;g[l>>2]=-2.0;g[m>>2]=-1.0;m=a+52|0;c[m>>2]=c[b>>2];c[m+4>>2]=c[b+4>>2];c[m+8>>2]=c[b+8>>2];g[n>>2]=1.0;b7(o|0,d|0,~~t|0,~~p|0);c[a+88>>2]=dJ(c[12]|0,c[14]|0)|0;c[a+92>>2]=dJ(c[2]|0,c[4]|0)|0;i=e;return}function dO(a){a=a|0;fz(a);return}function dP(a){a=a|0;return}function dQ(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=a+68|0;c[b>>2]=~~(+((c[b>>2]|0)-(c[a+72>>2]|0)|0)/+g[e>>2]);c[d>>2]=~~(+((c[d>>2]|0)-(c[a+76>>2]|0)|0)/+g[e>>2]);return}function dR(a){a=a|0;bB(16384);return}function dS(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[a+80>>2];c[d>>2]=c[a+84>>2];return}function dT(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=+k;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0;l=i;i=i+592|0;m=l|0;n=l+64|0;o=l+128|0;p=l+192|0;q=l+256|0;r=l+320|0;s=l+384|0;t=l+448|0;u=l+480|0;v=l+512|0;w=l+576|0;x=t|0;y=+(d|0);g[x>>2]=y;z=+(e|0);g[t+4>>2]=z;A=+(f+d|0);g[t+8>>2]=A;g[t+12>>2]=z;g[t+16>>2]=y;B=+(h+e|0);g[t+20>>2]=B;g[t+24>>2]=A;g[t+28>>2]=B;t=u|0;g[t>>2]=0.0;g[u+4>>2]=0.0;B=+g[b+16>>2];g[u+8>>2]=B;g[u+12>>2]=0.0;g[u+16>>2]=0.0;A=+g[b+20>>2];g[u+20>>2]=A;g[u+24>>2]=B;g[u+28>>2]=A;A=y+ +(f|0)*.5;y=z+ +(h|0)*.5;g[v>>2]=1.0;fF(v+4|0,0,16);g[v+20>>2]=1.0;fF(v+24|0,0,16);g[v+40>>2]=1.0;fF(v+44|0,0,16);g[v+60>>2]=1.0;g[q>>2]=1.0;fF(q+4|0,0,16);g[q+20>>2]=1.0;fF(q+24|0,0,16);g[q+40>>2]=1.0;fF(q+44|0,0,16);g[q+60>>2]=1.0;g[q+12>>2]=-0.0-A;g[q+28>>2]=-0.0-y;h=p;d_(p,v,q);q=v;fG(q|0,h|0,64)|0;z=j/180.0*3.141592653589793;j=+S(z);B=+R(z);h=o+4|0;fF(h|0,0,12);fF(o+24|0,0,16);g[o+40>>2]=1.0;fF(o+44|0,0,16);g[o+60>>2]=1.0;g[o>>2]=B;g[h>>2]=-0.0-j;g[o+16>>2]=j;g[o+20>>2]=B;h=n;d_(n,v,o);fG(q|0,h|0,64)|0;g[s>>2]=1.0;fF(s+4|0,0,16);g[s+20>>2]=1.0;fF(s+24|0,0,16);g[s+40>>2]=1.0;fF(s+44|0,0,16);g[s+60>>2]=1.0;g[s+12>>2]=A;g[s+28>>2]=y;h=r;d_(r,v,s);fG(q|0,h|0,64)|0;h=m;d_(m,v,a+4|0);fG(q|0,h|0,64)|0;h=c[a+92>>2]|0;a=c[b+4>>2]|0;g[w>>2]=1.0;g[w+4>>2]=1.0;g[w+8>>2]=1.0;g[w+12>>2]=k;dU(h,x,t,a,w,v);i=l;return}function dU(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0;j=i;k=f;f=i;i=i+16|0;c[f>>2]=c[k>>2];c[f+4>>2]=c[k+4>>2];c[f+8>>2]=c[k+8>>2];c[f+12>>2]=c[k+12>>2];bR(a|0);k=(b|0)!=0;if(k){l=b$(a|0,1112)|0;bD(l|0);a_(l|0,2,5126,0,0,b|0)}b=(d|0)!=0;if(b){az(3553,e|0);e=b$(a|0,864)|0;bD(e|0);a_(e|0,2,5126,0,0,d|0)}ca(a0(a|0,624)|0,1,0,h|0);h=a0(a|0,360)|0;bG(h|0,+(+g[f>>2]),+(+g[f+4>>2]),+(+g[f+8>>2]),+(+g[f+12>>2]));a5(5,0,4);if(b){bq(b$(a|0,864)|0);az(3553,0)}if(!k){bR(0);i=j;return}bq(b$(a|0,1112)|0);bR(0);i=j;return}function dV(a,b){a=a|0;b=b|0;return c[b+8>>2]|0}function dW(a,b){a=a|0;b=b|0;return c[b+12>>2]|0}function dX(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0;j=i;i=i+48|0;k=b;b=i;i=i+16|0;c[b>>2]=c[k>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];k=j|0;l=j+32|0;m=k|0;n=+(d|0);g[m>>2]=n;o=+(e|0);g[k+4>>2]=o;p=+(f+d|0);g[k+8>>2]=p;g[k+12>>2]=o;g[k+16>>2]=n;n=+(h+e|0);g[k+20>>2]=n;g[k+24>>2]=p;g[k+28>>2]=n;k=c[a+88>>2]|0;e=l;h=b;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];dU(k,m,0,0,l,a+4|0);i=j;return}function dY(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;var k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0;k=i;i=i+80|0;l=k|0;m=k+32|0;n=k+64|0;o=l|0;p=+(d|0);g[o>>2]=p;q=+(e|0);g[l+4>>2]=q;r=+(f+d|0);g[l+8>>2]=r;g[l+12>>2]=q;g[l+16>>2]=p;p=+(h+e|0);g[l+20>>2]=p;g[l+24>>2]=r;g[l+28>>2]=p;p=+(f|0)/+(c[b+8>>2]|0)*.5;r=j*.5+.5;j=(1.0-r)*p+r*(1.0-p);r=+g[b+16>>2];q=r*(j-p);s=r*(p+j);j=+g[b+20>>2];f=m|0;g[f>>2]=q;g[m+4>>2]=0.0;g[m+8>>2]=s;g[m+12>>2]=0.0;g[m+16>>2]=q;g[m+20>>2]=j;g[m+24>>2]=s;g[m+28>>2]=j;m=c[a+92>>2]|0;l=c[b+4>>2]|0;g[n>>2]=1.0;g[n+4>>2]=1.0;g[n+8>>2]=1.0;g[n+12>>2]=1.0;dU(m,o,f,l,n,a+4|0);i=k;return}function dZ(a){a=a|0;return}function d_(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;g[a>>2]=1.0;fF(a+4|0,0,16);g[a+20>>2]=1.0;fF(a+24|0,0,16);g[a+40>>2]=1.0;fF(a+44|0,0,16);g[a+60>>2]=1.0;d=+g[b>>2];e=+g[b+16>>2];f=+g[b+32>>2];h=+g[b+48>>2];i=+g[b+4>>2];j=+g[b+20>>2];k=+g[b+36>>2];l=+g[b+52>>2];m=+g[b+8>>2];n=+g[b+24>>2];o=+g[b+40>>2];p=+g[b+56>>2];q=+g[b+12>>2];r=+g[b+28>>2];s=+g[b+44>>2];t=+g[b+60>>2];b=0;do{u=+g[c+(b<<4)>>2];v=+g[c+(b<<4)+4>>2];w=+g[c+(b<<4)+8>>2];x=+g[c+(b<<4)+12>>2];g[a+(b<<4)>>2]=d*u+0.0+e*v+f*w+h*x;g[a+(b<<4)+4>>2]=i*u+0.0+j*v+k*w+l*x;g[a+(b<<4)+8>>2]=m*u+0.0+n*v+o*w+p*x;g[a+(b<<4)+12>>2]=q*u+0.0+r*v+s*w+t*x;b=b+1|0;}while((b|0)<4);return}function d$(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;d=i;i=i+16|0;e=d+8|0;f=cr[c[(c[b>>2]|0)+12>>2]&15](b,1088)|0;h=b;j=+(cr[c[(c[h>>2]|0)+40>>2]&15](b,f)|0);k=+(cr[c[(c[h>>2]|0)+44>>2]&15](b,f)|0);c[a+4>>2]=b;g[a+8>>2]=0.0;h=a+12|0;g[h>>2]=0.0;l=a+16|0;g[l>>2]=j;m=a+20|0;g[m>>2]=k;c[a+24>>2]=f;g[a+28>>2]=0.0;g[a+32>>2]=1.0;c[a>>2]=4352;c[a+36>>2]=4376;g[a+40>>2]=0.0;f=a+44|0;g[f>>2]=0.0;cm[c[(c[b>>2]|0)+32>>2]&15](b,d|0,e);k=+(c[e>>2]|0);g[h>>2]=k;g[f>>2]=k;g[l>>2]=+g[l>>2]*.5;g[m>>2]=+g[m>>2]*.5;i=d;return}function d0(a,b){a=a|0;b=b|0;if((c[b>>2]|0)!=0){return}b=a+8|0;g[b>>2]=+g[b>>2]*.5+ +g[a+40>>2]*.5;b=a+12|0;g[b>>2]=+g[b>>2]*.5+ +g[a+44>>2]*.5;return}function d1(a,b){a=a|0;b=b|0;var d=0;d=a-48+12|0;if((c[b>>2]|0)!=0){return}b=d+8|0;g[b>>2]=+g[b>>2]*.5+ +g[d+40>>2]*.5;b=d+12|0;g[b>>2]=+g[b>>2]*.5+ +g[d+44>>2]*.5;return}function d2(a){a=a|0;var b=0,d=0,e=0,f=0.0,h=0,j=0.0;b=i;i=i+16|0;d=b|0;e=c[a+4>>2]|0;cm[c[(c[e>>2]|0)+32>>2]&15](e,d,b+8|0);e=a+8|0;f=+g[e>>2];h=a+16|0;j=+g[h>>2];if(f+j*.5<+((c[d>>2]|0)/2|0|0)){g[e>>2]=f+j;g[h>>2]=j*-1.0;df(a|0);j=+g[h>>2];g[e>>2]=j+ +g[e>>2];g[h>>2]=j*-1.0;i=b;return}else{df(a|0);i=b;return}}function d3(a){a=a|0;return}function d4(a){a=a|0;fz(a);return}function d5(a,b){a=a|0;b=+b;g[a>>2]=b;c[a+4>>2]=ea()|0;c[a+8>>2]=0;return}function d6(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0;d=ea()|0;e=a+4|0;f=a+8|0;h=d-(c[e>>2]|0)+(c[f>>2]|0)|0;c[f>>2]=h;c[e>>2]=d;d=~~(1.0e3/+g[a>>2]);if((h|0)<=(d|0)){return}h=b+16|0;while(1){b=c[h>>2]|0;if((b|0)==0){i=563;break}ci[c[(c[b>>2]|0)+24>>2]&127](b);b=(c[f>>2]|0)-d|0;c[f>>2]=b;if((b|0)<=(d|0)){i=567;break}}if((i|0)==563){d=b0(4)|0;c[d>>2]=4072;bp(d|0,5496,90)}else if((i|0)==567){return}}function d7(a){a=a|0;return}function d8(a){a=a|0;fz(a);return}function d9(a){a=a|0;return 928}function ea(){var b=0,d=0,e=0;b=i;i=i+8|0;d=b|0;if(!(a[3840]|0)){bL(7168,0)|0;a[3840]=1}if((bL(d|0,0)|0)!=0){e=0;i=b;return e|0}e=(((c[d+4>>2]|0)-(c[1793]|0)|0)/1e3|0)+(((c[d>>2]|0)-(c[1792]|0)|0)*1e3|0)|0;i=b;return e|0}function eb(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+24|0;e=d|0;f=d+16|0;g=e;c[g>>2]=b;c[g+4>>2]=0;b6(f|0,a|0,e|0)|0;i=d;return c[f>>2]|0}function ec(b){b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;c=i;i=i+160|0;d=c|0;e=c+80|0;f=bF(b|0)|0;L637:do{if((f|0)!=0){b=f;do{if((a[b]|0)==0){break L637}g=a2(b|0,47)|0;if((g|0)==0){break L637}h=a[g]|0;a[g]=0;do{if((a[f]|0)!=0){if((b4(f|0,d|0)|0)==0){break}bC(f|0,448)|0}}while(0);a[g]=h;b=g+1|0;}while((b|0)!=0)}}while(0);if((a[f]|0)==0){ft(f);i=c;return}if((b4(f|0,e|0)|0)==0){ft(f);i=c;return}bC(f|0,448)|0;ft(f);i=c;return}function ed(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;a=i;d=c[b>>2]|0;b=a9(d|0,47)|0;e=(b|0)==0?d:b+1|0;b=bJ(696)|0;if((b|0)!=0){aV(7176,4096,2560,(f=i,i=i+16|0,c[f>>2]=b,c[f+8>>2]=e,f)|0)|0;i=f;i=a;return}b=bJ(2184)|0;if((b|0)==0){aV(7176,4096,1504,(f=i,i=i+8|0,c[f>>2]=e,f)|0)|0;i=f;i=a;return}else{aV(7176,4096,1728,(f=i,i=i+16|0,c[f>>2]=b,c[f+8>>2]=e,f)|0)|0;i=f;i=a;return}}function ee(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;b=a+24|0;if((bA(b|0)|0)==0){d=1;return d|0}e=b|0;f=a+72|0;g=f|0;h=b+12|0;i=a+76|0;j=a+40|0;k=a+80|0;l=a+84|0;m=a|0;n=a;a=b+12|0;while(1){o=c[e>>2]|0;if((o|0)==1025){c[g>>2]=1;c[i>>2]=c[h>>2];c[k>>2]=c[j>>2];p=c[l>>2]|0;cm[c[(c[p>>2]|0)+8>>2]&15](p,i,k);cj[c[c[n>>2]>>2]&63](m,f)}else if((o|0)==1024){c[g>>2]=2;c[i>>2]=c[a>>2];c[k>>2]=c[j>>2];p=c[l>>2]|0;cm[c[(c[p>>2]|0)+8>>2]&15](p,i,k);cj[c[c[n>>2]>>2]&63](m,f)}else if((o|0)==1026){c[g>>2]=3;c[i>>2]=c[h>>2];c[k>>2]=c[j>>2];p=c[l>>2]|0;cm[c[(c[p>>2]|0)+8>>2]&15](p,i,k);cj[c[c[n>>2]>>2]&63](m,f)}else if((o|0)==256){d=0;q=611;break}if((bA(b|0)|0)==0){d=1;q=613;break}}if((q|0)==611){return d|0}else if((q|0)==613){return d|0}return 0}function ef(a){a=a|0;c[a>>2]=4248;b9(c[a+4>>2]|0);fz(a);return}function eg(a){a=a|0;c[a>>2]=4248;b9(c[a+4>>2]|0);return}function eh(a){a=a|0;aD(-1|0,c[a+4>>2]|0,0,-1|0)|0;return}function ei(a){a=a|0;dP(a|0);fz(a);return}function ej(a){a=a|0;dP(a|0);return}function ek(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;a=i;i=i+8|0;d=a|0;e=eb(816,(f=i,i=i+8|0,c[f>>2]=b,f)|0)|0;i=f;c[d>>2]=0;f=el(e,d)|0;b=eL(f,c[d>>2]|0)|0;ft(f);ft(e);i=a;return b|0}function el(a,b){a=a|0;b=b|0;var d=0,e=0;d=bw(a|0,1080)|0;if((d|0)==0){e=0;return e|0}bZ(d|0,0,2)|0;c[b>>2]=a6(d|0)|0;bZ(d|0,0,0)|0;a=c[b>>2]|0;b=fs(a)|0;bU(b|0,a|0,1,d|0)|0;ax(d|0)|0;e=b;return e|0}function em(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;a=i;i=i+24|0;f=b;b=i;i=i+16|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=a|0;g=a+8|0;c[f>>2]=0;h=el(528,f)|0;j=c[f>>2]|0;f=g;k=b;c[f>>2]=c[k>>2];c[f+4>>2]=c[k+4>>2];c[f+8>>2]=c[k+8>>2];c[f+12>>2]=c[k+12>>2];k=eM(h,j,g,d,e)|0;ft(h);i=a;return k|0}function en(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;d=eb(816,(e=i,i=i+8|0,c[e>>2]=b,e)|0)|0;i=e;e=fx(8)|0;c[e>>2]=4248;c[e+4>>2]=a3(aW(d|0,1080)|0,1)|0;ft(d);i=a;return e|0}function eo(a,b){a=a|0;b=b|0;ed(0,b);bj(33)|0;aJ(0)|0;aM(22050,-32752|0,1,1024)|0;b=fx(920)|0;et(b);c[2818]=b;b8(2,30,0);return 0}function ep(){var b=0;b=c[2818]|0;a[b+912|0]=(ee(b+104|0)|0)&1^1;cY(b+192|0);return}function eq(a){a=a|0;return 7176}function er(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;c[a>>2]=4592;c[a+4>>2]=4616;b=a+8|0;d=a+16|0;if((c[d>>2]|0)==0){return}e=c[a+12>>2]|0;a=b;f=(c[b>>2]|0)+4|0;b=e|0;c[(c[b>>2]|0)+4>>2]=c[f>>2];c[c[f>>2]>>2]=c[b>>2];c[d>>2]=0;if((e|0)==(a|0)){return}else{g=e}while(1){e=c[g+4>>2]|0;fz(g);if((e|0)==(a|0)){break}else{g=e}}return}function es(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0;c[a>>2]=4592;c[a+4>>2]=4616;b=a+8|0;d=a+16|0;if((c[d>>2]|0)==0){e=a;fz(e);return}f=c[a+12>>2]|0;g=b;h=(c[b>>2]|0)+4|0;b=f|0;c[(c[b>>2]|0)+4>>2]=c[h>>2];c[c[h>>2]>>2]=c[b>>2];c[d>>2]=0;if((f|0)==(g|0)){e=a;fz(e);return}else{i=f}while(1){f=c[i+4>>2]|0;fz(i);if((f|0)==(g|0)){break}else{i=f}}e=a;fz(e);return}function et(b){b=b|0;var d=0,e=0,f=0,g=0;d=bk()|0;e=bv(d|0,aX()|0,0,67108864)|0;c[b>>2]=e;d=b+4|0;dN(d|0,c[e+8>>2]|0,c[e+12>>2]|0);c[d>>2]=4800;e=b+104|0;f=d|0;d=b+112|0;g=d;c[d>>2]=g;c[b+116>>2]=g;c[b+120>>2]=0;c[e>>2]=4640;c[b+108>>2]=4664;fF(b+128|0,0,60);c[b+188>>2]=f;g=b+192|0;cU(g,f);a[b+912|0]=0;cj[c[(c[e>>2]|0)+12>>2]&63](e|0,g|0);return}function eu(e,f,h,j,k){e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0,aW=0,aX=0,aY=0,aZ=0,a_=0,a$=0,a0=0,a1=0,a2=0,a3=0,a4=0,a5=0,a6=0,a7=0,a8=0,a9=0,ba=0,bb=0,bc=0,bd=0,be=0,bf=0,bg=0,bh=0,bi=0,bj=0,bk=0,bl=0,bm=0,bn=0,bo=0,bp=0,bq=0,br=0,bs=0,bt=0,bu=0,bv=0,bw=0,bx=0,by=0,bz=0,bA=0,bB=0,bC=0,bD=0,bE=0,bF=0,bG=0,bH=0,bI=0,bJ=0,bK=0,bL=0,bM=0,bN=0,bO=0,bP=0,bQ=0,bR=0,bS=0,bT=0,bU=0,bV=0,bW=0,bX=0,bY=0,bZ=0,b_=0,b$=0,b0=0,b1=0,b2=0,b3=0,b4=0,b5=0,b6=0,b7=0,b8=0,b9=0,ca=0,cb=0,cc=0,cd=0,ce=0,cg=0,ch=0,ci=0,ck=0,cm=0,cn=0,co=0,cp=0,cq=0,cr=0,ct=0,cu=0,cv=0,cw=0,cx=0,cy=0,cz=0,cA=0,cB=0,cC=0,cD=0,cE=0,cF=0,cG=0,cH=0,cI=0,cJ=0,cK=0,cL=0,cM=0,cN=0,cO=0,cP=0,cQ=0,cR=0,cS=0,cT=0,cU=0,cV=0,cW=0,cX=0,cY=0,cZ=0,c_=0,c$=0,c0=0,c1=0,c2=0,c3=0,c4=0,c5=0,c6=0,c7=0,c8=0,c9=0,da=0,db=0,dc=0,dd=0,de=0,df=0,dg=0,dh=0,di=0,dj=0,dk=0,dl=0,dm=0,dn=0,dp=0,dq=0,dr=0,ds=0,dt=0,du=0,dv=0,dw=0,dx=0,dy=0,dz=0,dA=0,dB=0,dC=0,dD=0,dE=0,dF=0,dG=0,dH=0,dI=0,dJ=0,dK=0,dL=0,dM=0,dN=0,dO=0,dP=0,dQ=0,dR=0,dS=0,dT=0,dU=0,dV=0,dW=0,dX=0,dY=0,dZ=0,d_=0,d$=0,d0=0,d1=0,d2=0,d3=0,d4=0,d5=0,d6=0,d7=0,d8=0,d9=0,ea=0,eb=0,ec=0,ed=0,ee=0,ef=0,eg=0,eh=0,ei=0,ej=0,ek=0,el=0,em=0,en=0,eo=0,ep=0,eq=0,er=0,es=0,et=0,eu=0,ew=0,ex=0,ey=0,ez=0,eA=0,eB=0,eC=0,eD=0,eE=0,eF=0,eG=0,eH=0,eI=0,eJ=0,eK=0,eL=0,eM=0,eN=0,eO=0,eP=0,eQ=0,eR=0,eU=0,eX=0,eY=0,eZ=0,e2=0,e3=0,e4=0,e5=0,e6=0,e9=0,fa=0,fb=0,fc=0,fd=0,fe=0,ff=0,fg=0,fh=0,fi=0,fj=0,fk=0,fl=0,fm=0,fn=0,fo=0,fp=0,fq=0,fr=0,fu=0,fv=0,fw=0,fx=0,fy=0,fz=0,fA=0,fB=0,fC=0,fD=0,fE=0,fH=0,fI=0,fJ=0,fK=0,fL=0,fM=0,fN=0,fO=0,fP=0,fQ=0,fR=0,fS=0,fT=0,fU=0,fV=0,fW=0,fX=0,fY=0,fZ=0,f_=0,f$=0,f0=0,f1=0,f2=0,f3=0,f4=0,f5=0,f6=0,f7=0,f8=0,f9=0,ga=0,gb=0,gc=0,gd=0,ge=0,gf=0,gg=0,gh=0,gi=0,gj=0,gk=0,gl=0,gm=0,gn=0,go=0,gp=0,gq=0,gr=0,gs=0,gt=0,gu=0,gv=0,gw=0,gx=0,gy=0,gz=0,gA=0,gB=0,gC=0,gD=0,gE=0,gF=0,gG=0,gH=0,gI=0,gJ=0,gK=0,gL=0,gM=0,gN=0,gO=0,gP=0,gQ=0,gR=0,gS=0,gT=0,gU=0,gV=0,gW=0,gX=0,gY=0,gZ=0,g_=0,g$=0,g0=0,g1=0,g2=0,g3=0,g4=0,g5=0,g6=0,g7=0,g8=0,g9=0,ha=0,hb=0,hc=0,hd=0,he=0,hf=0,hg=0,hh=0,hi=0,hj=0,hk=0,hl=0,hm=0,hn=0,ho=0,hp=0,hq=0,hr=0,hs=0,ht=0,hu=0,hv=0,hw=0,hx=0,hy=0,hz=0,hA=0,hB=0,hC=0,hD=0,hE=0,hF=0,hG=0,hH=0,hI=0,hJ=0,hK=0,hL=0,hM=0,hN=0,hO=0,hP=0,hQ=0,hR=0,hS=0,hT=0,hU=0,hV=0,hW=0,hX=0,hY=0,hZ=0,h_=0,h$=0,h0=0,h1=0,h2=0,h3=0,h4=0,h5=0,h6=0,h7=0,h8=0,h9=0,ia=0,ib=0,ic=0,id=0,ie=0,ig=0,ih=0,ii=0,ij=0,ik=0,il=0,im=0,io=0,ip=0,iq=0,ir=0,is=0,it=0,iu=0,iv=0,iw=0,ix=0,iy=0,iz=0,iA=0,iB=0,iC=0,iD=0,iE=0,iF=0,iG=0,iH=0,iI=0,iJ=0,iK=0,iL=0,iM=0,iN=0,iO=0,iP=0,iQ=0,iR=0,iS=0,iT=0,iU=0,iV=0,iW=0,iX=0,iY=0,iZ=0,i_=0,i$=0,i0=0,i1=0,i2=0,i3=0,i4=0,i5=0,i6=0,i7=0,i8=0,i9=0,ja=0,jb=0,jc=0,jd=0,je=0,jf=0,jg=0,jh=0,ji=0,jj=0,jk=0,jl=0,jm=0,jn=0,jo=0,jp=0,jq=0,jr=0,js=0.0,jt=0.0,ju=0.0,jv=0.0,jw=0,jx=0,jy=0,jz=0,jA=0,jB=0,jC=0,jD=0,jE=0,jF=0,jG=0,jH=0,jI=0,jJ=0,jK=0,jL=0,jM=0,jN=0,jO=0,jP=0,jQ=0,jR=0,jS=0,jT=0,jU=0,jV=0,jW=0,jX=0,jY=0,jZ=0,j_=0,j$=0,j0=0,j1=0,j2=0,j3=0,j4=0,j5=0,j6=0,j7=0,j8=0,j9=0,ka=0,kb=0,kc=0,kd=0,ke=0,kf=0,kg=0,kh=0,ki=0,kj=0,kk=0,kl=0,km=0,kn=0,ko=0,kp=0,kq=0,kr=0,ks=0,kt=0,ku=0,kv=0,kw=0,kx=0,ky=0,kz=0,kA=0,kB=0,kC=0,kD=0,kE=0,kF=0,kG=0,kH=0,kI=0,kJ=0,kK=0,kL=0,kM=0,kN=0,kO=0,kP=0,kQ=0,kR=0,kS=0,kT=0,kU=0,kV=0,kW=0,kX=0,kY=0,kZ=0,k_=0,k$=0,k0=0,k1=0,k2=0,k3=0,k4=0,k5=0,k6=0,k7=0,k8=0,k9=0,la=0,lb=0,lc=0,ld=0,le=0,lf=0,lg=0,lh=0,li=0,lj=0,lk=0,ll=0,lm=0,ln=0,lo=0,lp=0,lq=0,lr=0,ls=0,lt=0,lu=0,lv=0,lw=0,lx=0,ly=0,lz=0,lA=0,lB=0,lC=0,lD=0,lE=0,lF=0,lG=0,lH=0,lI=0,lJ=0,lK=0,lL=0,lM=0,lN=0,lO=0,lP=0,lQ=0,lR=0,lS=0,lT=0,lU=0,lV=0,lW=0,lX=0,lY=0,lZ=0,l_=0,l$=0,l0=0,l1=0,l2=0,l3=0,l4=0,l5=0,l6=0,l7=0;l=i;i=i+46960|0;m=l|0;n=l+32|0;o=l+40|0;p=l+48|0;q=l+18560|0;r=l+18576|0;s=l+18704|0;t=l+18832|0;u=l+18848|0;v=l+18976|0;w=l+32968|0;c[w>>2]=e;x=eV(w,1)|0;w=e+176|0;y=c[w>>2]|0;z=e+168|0;c[z>>2]=y;if((x|0)!=0){x=v|0;c[x>>2]=e;if(k>>>0>4>>>0){c[2832]=2952;A=0;i=l;return A|0}c[e+8>>2]=0;B=v+13984|0;c[B>>2]=0;L731:do{if((eV(v,0)|0)!=0){C=v+13956|0;D=a[C]|0;L733:do{if(D<<24>>24==-1){E=c[x>>2]|0;F=E+168|0;G=c[F>>2]|0;H=E+172|0;do{if(G>>>0<(c[H>>2]|0)>>>0){I=G}else{J=E+32|0;if((c[J>>2]|0)==0){K=-1;break L733}L=E+40|0;M=cl[c[E+16>>2]&3](c[E+28>>2]|0,L,c[E+36>>2]|0)|0;if((M|0)==0){c[J>>2]=0;J=(c[H>>2]|0)-1|0;c[F>>2]=J;a[J]=0;I=c[F>>2]|0;break}else{c[F>>2]=L;c[H>>2]=E+40+M;I=L;break}}}while(0);c[F>>2]=I+1;if((a[I]|0)!=-1){K=-1;break}while(1){E=c[x>>2]|0;H=E+168|0;G=c[H>>2]|0;L=E+172|0;do{if(G>>>0<(c[L>>2]|0)>>>0){N=G}else{M=E+32|0;if((c[M>>2]|0)==0){K=0;break L733}J=E+40|0;O=cl[c[E+16>>2]&3](c[E+28>>2]|0,J,c[E+36>>2]|0)|0;if((O|0)==0){c[M>>2]=0;M=(c[L>>2]|0)-1|0;c[H>>2]=M;a[M]=0;N=c[H>>2]|0;break}else{c[H>>2]=J;c[L>>2]=E+40+O;N=J;break}}}while(0);c[H>>2]=N+1;E=a[N]|0;if(E<<24>>24!=-1){K=E;break}}}else{a[C]=-1;K=D}}while(0);D=v+13964|0;F=v+13952|0;E=v+13948|0;L=v+13960|0;G=v+13860|0;J=v+13804|0;O=v+13748|0;M=v+13988|0;P=v+13968|0;R=r|0;S=v+13712|0;T=v+13708|0;U=s|0;V=K;L753:while(1){L755:do{if((V<<24>>24|0)==(-38|0)){W=c[x>>2]|0;X=W+168|0;Y=c[X>>2]|0;Z=W+172|0;_=c[Z>>2]|0;do{if(Y>>>0<_>>>0){aa=Y+1|0;c[X>>2]=aa;ab=d[Y]|0;ac=aa;ad=_}else{aa=W+32|0;if((c[aa>>2]|0)==0){ab=0;ac=Y;ad=_;break}ae=W+40|0;af=cl[c[W+16>>2]&3](c[W+28>>2]|0,ae,c[W+36>>2]|0)|0;if((af|0)==0){c[aa>>2]=0;aa=(c[Z>>2]|0)-1|0;c[X>>2]=aa;a[aa]=0;ag=c[X>>2]|0;ah=c[Z>>2]|0}else{c[X>>2]=ae;aa=W+40+af|0;c[Z>>2]=aa;ag=ae;ah=aa}aa=ag+1|0;c[X>>2]=aa;ab=d[ag]|0;ac=aa;ad=ah}}while(0);_=ab<<8;do{if(ac>>>0<ad>>>0){c[X>>2]=ac+1;ai=d[ac]|0}else{Y=W+32|0;if((c[Y>>2]|0)==0){ai=0;break}H=W+40|0;aa=cl[c[W+16>>2]&3](c[W+28>>2]|0,H,c[W+36>>2]|0)|0;if((aa|0)==0){c[Y>>2]=0;Y=(c[Z>>2]|0)-1|0;c[X>>2]=Y;a[Y]=0;aj=c[X>>2]|0}else{c[X>>2]=H;c[Z>>2]=W+40+aa;aj=H}c[X>>2]=aj+1;ai=d[aj]|0}}while(0);X=ai|_;W=c[x>>2]|0;Z=W+168|0;H=c[Z>>2]|0;aa=W+172|0;do{if(H>>>0<(c[aa>>2]|0)>>>0){ak=H}else{Y=W+32|0;if((c[Y>>2]|0)==0){al=705;break L753}ae=W+40|0;af=cl[c[W+16>>2]&3](c[W+28>>2]|0,ae,c[W+36>>2]|0)|0;if((af|0)==0){c[Y>>2]=0;Y=(c[aa>>2]|0)-1|0;c[Z>>2]=Y;a[Y]=0;ak=c[Z>>2]|0;break}else{c[Z>>2]=ae;c[aa>>2]=W+40+af;ak=ae;break}}}while(0);c[Z>>2]=ak+1;W=a[ak]|0;aa=W&255;c[D>>2]=aa;if(W<<24>>24==0|(W&255)>>>0>4>>>0){break L753}W=c[x>>2]|0;if((aa|0)>(c[W+8>>2]|0)){break L753}if((X|0)==((aa<<1)+6|0)){am=0;an=aa;ao=W}else{al=713;break L753}while(1){W=(am|0)<(an|0);aa=ao+168|0;H=c[aa>>2]|0;_=ao+172|0;do{if(H>>>0<(c[_>>2]|0)>>>0){c[aa>>2]=H+1;ap=d[H]|0}else{ae=ao+32|0;if((c[ae>>2]|0)==0){ap=0;break}af=ao+40|0;Y=cl[c[ao+16>>2]&3](c[ao+28>>2]|0,af,c[ao+36>>2]|0)|0;if((Y|0)==0){c[ae>>2]=0;ae=(c[_>>2]|0)-1|0;c[aa>>2]=ae;a[ae]=0;aq=c[aa>>2]|0}else{c[aa>>2]=af;c[_>>2]=ao+40+Y;aq=af}c[aa>>2]=aq+1;ap=d[aq]|0}}while(0);if(!W){break}aa=c[x>>2]|0;_=aa+168|0;H=c[_>>2]|0;af=aa+172|0;do{if(H>>>0<(c[af>>2]|0)>>>0){c[_>>2]=H+1;ar=d[H]|0}else{Y=aa+32|0;if((c[Y>>2]|0)==0){ar=0;break}ae=aa+40|0;as=cl[c[aa+16>>2]&3](c[aa+28>>2]|0,ae,c[aa+36>>2]|0)|0;if((as|0)==0){c[Y>>2]=0;Y=(c[af>>2]|0)-1|0;c[_>>2]=Y;a[Y]=0;at=c[_>>2]|0}else{c[_>>2]=ae;c[af>>2]=aa+40+as;at=ae}c[_>>2]=at+1;ar=d[at]|0}}while(0);_=c[(c[x>>2]|0)+8>>2]|0;aa=0;while(1){if((aa|0)>=(_|0)){break}if((c[v+13724+(aa*56|0)>>2]|0)==(ap|0)){break}else{aa=aa+1|0}}if((aa|0)==(_|0)){break L731}c[v+13724+(aa*56|0)+16>>2]=ar>>>4;if(ar>>>0>63>>>0){al=734;break L753}af=ar&15;c[v+13724+(aa*56|0)+20>>2]=af;if(af>>>0>3>>>0){al=736;break L753}c[v+13968+(am<<2)>>2]=aa;am=am+1|0;an=c[D>>2]|0;ao=c[x>>2]|0}if((ap|0)!=0){al=739;break L753}X=c[x>>2]|0;Z=X+168|0;af=c[Z>>2]|0;H=X+172|0;do{if(af>>>0<(c[H>>2]|0)>>>0){c[Z>>2]=af+1}else{W=X+32|0;if((c[W>>2]|0)==0){break}ae=X+40|0;as=cl[c[X+16>>2]&3](c[X+28>>2]|0,ae,c[X+36>>2]|0)|0;if((as|0)==0){c[W>>2]=0;W=(c[H>>2]|0)-1|0;c[Z>>2]=W;a[W]=0;au=c[Z>>2]|0}else{c[Z>>2]=ae;c[H>>2]=X+40+as;au=ae}c[Z>>2]=au+1}}while(0);Z=c[x>>2]|0;X=Z+168|0;H=c[X>>2]|0;af=Z+172|0;do{if(H>>>0<(c[af>>2]|0)>>>0){av=H;al=752}else{ae=Z+32|0;if((c[ae>>2]|0)==0){break}as=Z+40|0;W=cl[c[Z+16>>2]&3](c[Z+28>>2]|0,as,c[Z+36>>2]|0)|0;if((W|0)==0){c[ae>>2]=0;ae=(c[af>>2]|0)-1|0;c[X>>2]=ae;a[ae]=0;av=c[X>>2]|0;al=752;break}else{c[X>>2]=as;c[af>>2]=Z+40+W;av=as;al=752;break}}}while(0);if((al|0)==752){al=0;c[X>>2]=av+1;if((a[av]|0)!=0){al=753;break L753}}c[F>>2]=0;c[E>>2]=0;c[L>>2]=0;c[G>>2]=0;c[J>>2]=0;c[O>>2]=0;a[C]=-1;Z=c[B>>2]|0;af=(Z|0)==0?2147483647:Z;c[M>>2]=af;L832:do{if((c[D>>2]|0)==1){Z=c[P>>2]|0;H=(c[v+13724+(Z*56|0)+28>>2]|0)+7>>3;as=(c[v+13724+(Z*56|0)+32>>2]|0)+7>>3;if((as|0)<=0){break}W=(H|0)>0;ae=v+13724+(Z*56|0)+16|0;Y=v+13724+(Z*56|0)+20|0;aw=v+13724+(Z*56|0)+44|0;ax=v+13724+(Z*56|0)+36|0;ay=v+13724+(Z*56|0)+12|0;az=0;do{if(W){aA=0;do{if((e7(v,R,v+4+((c[ae>>2]|0)*1680|0)|0,v+6724+((c[Y>>2]|0)*1680|0)|0,Z)|0)==0){break L731}aB=c[ax>>2]|0;aC=(c[aw>>2]|0)+(($(aB,az)|0)+aA<<3)|0;e8(aC,aB,R,v+13444+(c[ay>>2]<<6)|0);aB=(c[M>>2]|0)-1|0;c[M>>2]=aB;if((aB|0)<1){L897:do{if((c[F>>2]|0)<24){L898:while(1){L900:do{if((c[L>>2]|0)==0){aB=c[x>>2]|0;aC=aB+168|0;aD=c[aC>>2]|0;aE=aB+172|0;do{if(aD>>>0<(c[aE>>2]|0)>>>0){aF=aD}else{aG=aB+32|0;if((c[aG>>2]|0)==0){aH=0;break L900}aI=aB+40|0;aJ=cl[c[aB+16>>2]&3](c[aB+28>>2]|0,aI,c[aB+36>>2]|0)|0;if((aJ|0)==0){c[aG>>2]=0;aG=(c[aE>>2]|0)-1|0;c[aC>>2]=aG;a[aG]=0;aF=c[aC>>2]|0;break}else{c[aC>>2]=aI;c[aE>>2]=aB+40+aJ;aF=aI;break}}}while(0);c[aC>>2]=aF+1;aB=a[aF]|0;if(aB<<24>>24!=-1){aH=aB&255;break}aB=c[x>>2]|0;aE=aB+168|0;aD=c[aE>>2]|0;aI=aB+172|0;do{if(aD>>>0<(c[aI>>2]|0)>>>0){aK=aD}else{aJ=aB+32|0;if((c[aJ>>2]|0)==0){aH=255;break L900}aG=aB+40|0;aL=cl[c[aB+16>>2]&3](c[aB+28>>2]|0,aG,c[aB+36>>2]|0)|0;if((aL|0)==0){c[aJ>>2]=0;aJ=(c[aI>>2]|0)-1|0;c[aE>>2]=aJ;a[aJ]=0;aK=c[aE>>2]|0;break}else{c[aE>>2]=aG;c[aI>>2]=aB+40+aL;aK=aG;break}}}while(0);c[aE>>2]=aK+1;aM=a[aK]|0;if(aM<<24>>24==0){aH=255}else{break L898}}else{aH=0}}while(0);aB=c[F>>2]|0;c[E>>2]=aH<<24-aB|c[E>>2];aI=aB+8|0;c[F>>2]=aI;if((aI|0)>=25){break L897}}a[C]=aM;c[L>>2]=1}}while(0);if(((a[C]|0)+48&255)>>>0>=8>>>0){break L832}c[F>>2]=0;c[E>>2]=0;c[L>>2]=0;c[G>>2]=0;c[J>>2]=0;c[O>>2]=0;a[C]=-1;aI=c[B>>2]|0;c[M>>2]=(aI|0)==0?2147483647:aI}aA=aA+1|0;}while((aA|0)<(H|0))}az=az+1|0;}while((az|0)<(as|0))}else{as=c[S>>2]|0;if((as|0)<=0){break}az=0;H=c[T>>2]|0;ay=as;as=af;while(1){if((H|0)>0){aw=0;ax=as;while(1){Z=c[D>>2]|0;if((Z|0)>0){Y=0;ae=Z;while(1){Z=c[v+13968+(Y<<2)>>2]|0;W=v+13724+(Z*56|0)+8|0;aa=c[W>>2]|0;if((aa|0)>0){_=v+13724+(Z*56|0)+4|0;aA=v+13724+(Z*56|0)+16|0;aI=v+13724+(Z*56|0)+20|0;aB=v+13724+(Z*56|0)+44|0;aD=v+13724+(Z*56|0)+36|0;aC=v+13724+(Z*56|0)+12|0;aG=0;aL=c[_>>2]|0;aJ=aa;while(1){if((aL|0)>0){aa=0;aN=aL;aO=aJ;while(1){if((e7(v,U,v+4+((c[aA>>2]|0)*1680|0)|0,v+6724+((c[aI>>2]|0)*1680|0)|0,Z)|0)==0){break L731}aP=($(aO,az)|0)+aG|0;aQ=($(aN,aw)|0)+aa|0;aR=c[aD>>2]|0;aS=(c[aB>>2]|0)+(aQ+($(aR,aP)|0)<<3)|0;e8(aS,aR,U,v+13444+(c[aC>>2]<<6)|0);aR=aa+1|0;aS=c[_>>2]|0;aP=c[W>>2]|0;if((aR|0)<(aS|0)){aa=aR;aN=aS;aO=aP}else{aT=aS;aU=aP;break}}}else{aT=aL;aU=aJ}aO=aG+1|0;if((aO|0)<(aU|0)){aG=aO;aL=aT;aJ=aU}else{break}}aV=c[D>>2]|0}else{aV=ae}aJ=Y+1|0;if((aJ|0)<(aV|0)){Y=aJ;ae=aV}else{break}}aW=c[M>>2]|0}else{aW=ax}ae=aW-1|0;c[M>>2]=ae;if((ae|0)<1){L858:do{if((c[F>>2]|0)<24){L859:while(1){L861:do{if((c[L>>2]|0)==0){Y=c[x>>2]|0;aJ=Y+168|0;aL=c[aJ>>2]|0;aG=Y+172|0;do{if(aL>>>0<(c[aG>>2]|0)>>>0){aX=aL}else{W=Y+32|0;if((c[W>>2]|0)==0){aY=0;break L861}_=Y+40|0;aC=cl[c[Y+16>>2]&3](c[Y+28>>2]|0,_,c[Y+36>>2]|0)|0;if((aC|0)==0){c[W>>2]=0;W=(c[aG>>2]|0)-1|0;c[aJ>>2]=W;a[W]=0;aX=c[aJ>>2]|0;break}else{c[aJ>>2]=_;c[aG>>2]=Y+40+aC;aX=_;break}}}while(0);c[aJ>>2]=aX+1;Y=a[aX]|0;if(Y<<24>>24!=-1){aY=Y&255;break}Y=c[x>>2]|0;aG=Y+168|0;aL=c[aG>>2]|0;aE=Y+172|0;do{if(aL>>>0<(c[aE>>2]|0)>>>0){aZ=aL}else{_=Y+32|0;if((c[_>>2]|0)==0){aY=255;break L861}aC=Y+40|0;W=cl[c[Y+16>>2]&3](c[Y+28>>2]|0,aC,c[Y+36>>2]|0)|0;if((W|0)==0){c[_>>2]=0;_=(c[aE>>2]|0)-1|0;c[aG>>2]=_;a[_]=0;aZ=c[aG>>2]|0;break}else{c[aG>>2]=aC;c[aE>>2]=Y+40+W;aZ=aC;break}}}while(0);c[aG>>2]=aZ+1;a_=a[aZ]|0;if(a_<<24>>24==0){aY=255}else{break L859}}else{aY=0}}while(0);Y=c[F>>2]|0;c[E>>2]=aY<<24-Y|c[E>>2];aE=Y+8|0;c[F>>2]=aE;if((aE|0)>=25){break L858}}a[C]=a_;c[L>>2]=1}}while(0);if(((a[C]|0)+48&255)>>>0>=8>>>0){break L832}c[F>>2]=0;c[E>>2]=0;c[L>>2]=0;c[G>>2]=0;c[J>>2]=0;c[O>>2]=0;a[C]=-1;aE=c[B>>2]|0;Y=(aE|0)==0?2147483647:aE;c[M>>2]=Y;a$=Y}else{a$=ae}Y=aw+1|0;a0=c[T>>2]|0;if((Y|0)<(a0|0)){aw=Y;ax=a$}else{break}}a1=a0;a2=c[S>>2]|0;a3=a$}else{a1=H;a2=ay;a3=as}ax=az+1|0;if((ax|0)<(a2|0)){az=ax;H=a1;ay=a2;as=a3}else{break}}}}while(0);af=a[C]|0;if(af<<24>>24!=-1){a4=af;break}L926:while(1){af=c[x>>2]|0;do{if((c[af+16>>2]|0)==0){al=821}else{if((cf[c[af+24>>2]&15](c[af+28>>2]|0)|0)==0){break}if((c[af+32>>2]|0)==0){al=837;break L755}else{al=821}}}while(0);if((al|0)==821){al=0;if((c[af+168>>2]|0)>>>0>=(c[af+172>>2]|0)>>>0){al=837;break L755}}X=c[x>>2]|0;as=X+168|0;ay=c[as>>2]|0;H=X+172|0;do{if(ay>>>0<(c[H>>2]|0)>>>0){a5=ay}else{az=X+32|0;if((c[az>>2]|0)==0){continue L926}ax=X+40|0;aw=cl[c[X+16>>2]&3](c[X+28>>2]|0,ax,c[X+36>>2]|0)|0;if((aw|0)==0){c[az>>2]=0;az=(c[H>>2]|0)-1|0;c[as>>2]=az;a[az]=0;a5=c[as>>2]|0;break}else{c[as>>2]=ax;c[H>>2]=X+40+aw;a5=ax;break}}}while(0);c[as>>2]=a5+1;X=d[a5]|0;if((X|0)==255){break}else if((X|0)!=0){break L731}}X=c[x>>2]|0;H=X+168|0;ay=c[H>>2]|0;af=X+172|0;do{if(ay>>>0<(c[af>>2]|0)>>>0){c[H>>2]=ay+1;a6=a[ay]|0}else{ax=X+32|0;if((c[ax>>2]|0)==0){a6=0;break}aw=X+40|0;az=cl[c[X+16>>2]&3](c[X+28>>2]|0,aw,c[X+36>>2]|0)|0;if((az|0)==0){c[ax>>2]=0;ax=(c[af>>2]|0)-1|0;c[H>>2]=ax;a[ax]=0;a7=c[H>>2]|0}else{c[H>>2]=aw;c[af>>2]=X+40+az;a7=aw}c[H>>2]=a7+1;a6=a[a7]|0}}while(0);a[C]=a6;a8=a6;al=838}else if((V<<24>>24|0)==(-39|0)){al=858;break L753}else{if((eW(v,V&255)|0)==0){break L731}else{al=837}}}while(0);if((al|0)==837){al=0;a8=a[C]|0;al=838}do{if((al|0)==838){al=0;if(a8<<24>>24!=-1){a4=a8;break}H=c[x>>2]|0;X=H+168|0;af=c[X>>2]|0;ay=H+172|0;do{if(af>>>0<(c[ay>>2]|0)>>>0){a9=af}else{aw=H+32|0;if((c[aw>>2]|0)==0){V=-1;continue L753}az=H+40|0;ax=cl[c[H+16>>2]&3](c[H+28>>2]|0,az,c[H+36>>2]|0)|0;if((ax|0)==0){c[aw>>2]=0;aw=(c[ay>>2]|0)-1|0;c[X>>2]=aw;a[aw]=0;a9=c[X>>2]|0;break}else{c[X>>2]=az;c[ay>>2]=H+40+ax;a9=az;break}}}while(0);c[X>>2]=a9+1;if((a[a9]|0)!=-1){V=-1;continue L753}while(1){H=c[x>>2]|0;ay=H+168|0;af=c[ay>>2]|0;az=H+172|0;do{if(af>>>0<(c[az>>2]|0)>>>0){ba=af}else{ax=H+32|0;if((c[ax>>2]|0)==0){V=0;continue L753}aw=H+40|0;Y=cl[c[H+16>>2]&3](c[H+28>>2]|0,aw,c[H+36>>2]|0)|0;if((Y|0)==0){c[ax>>2]=0;ax=(c[az>>2]|0)-1|0;c[ay>>2]=ax;a[ax]=0;ba=c[ay>>2]|0;break}else{c[ay>>2]=aw;c[az>>2]=H+40+Y;ba=aw;break}}}while(0);c[ay>>2]=ba+1;H=a[ba]|0;if(H<<24>>24!=-1){V=H;continue L753}}}}while(0);a[C]=-1;V=a4}if((al|0)==713){c[2832]=2832;break}else if((al|0)==705){c[D>>2]=0}else if((al|0)==734){c[2832]=2816;break}else if((al|0)==736){c[2832]=2800;break}else if((al|0)==739){c[2832]=2792;break}else if((al|0)==753){c[2832]=2792;break}else if((al|0)==858){V=c[x>>2]|0;C=c[V+8>>2]|0;S=(k|0)==0?C:k;T=(C|0)==3&(S|0)<3?1:C;C=(T|0)>0;L982:do{if(C){M=v+13700|0;O=v+13704|0;J=0;G=c[V>>2]|0;while(1){L=u+(J<<5)|0;E=fs(G+3|0)|0;c[v+13724+(J*56|0)+52>>2]=E;if((E|0)==0){break}E=(c[M>>2]|0)/(c[v+13724+(J*56|0)+4>>2]|0)|0;c[u+(J<<5)+12>>2]=E;F=(c[O>>2]|0)/(c[v+13724+(J*56|0)+8>>2]|0)|0;c[u+(J<<5)+16>>2]=F;c[u+(J<<5)+24>>2]=F>>1;U=c[x>>2]|0;R=c[U>>2]|0;c[u+(J<<5)+20>>2]=((E-1+R|0)>>>0)/(E>>>0)|0;c[u+(J<<5)+28>>2]=0;P=c[v+13724+(J*56|0)+44>>2]|0;c[u+(J<<5)+8>>2]=P;c[u+(J<<5)+4>>2]=P;do{if((E|0)==1){if((F|0)==1){c[L>>2]=6;break}else if((F|0)==2){c[L>>2]=10;break}else{al=876;break}}else if((E|0)==2){if((F|0)==1){c[L>>2]=2;break}else if((F|0)==2){c[L>>2]=4;break}else{al=876;break}}else{al=876}}while(0);if((al|0)==876){al=0;c[L>>2]=8}F=J+1|0;if((F|0)<(T|0)){J=F;G=R}else{bb=U;bc=R;break L982}}if((c[(c[x>>2]|0)+8>>2]|0)>0){G=0;do{J=v+13724+(G*56|0)+44|0;if((c[J>>2]|0)!=0){ft(c[v+13724+(G*56|0)+48>>2]|0);c[J>>2]=0}J=v+13724+(G*56|0)+52|0;O=c[J>>2]|0;if((O|0)!=0){ft(O);c[J>>2]=0}G=G+1|0;}while((G|0)<(c[(c[x>>2]|0)+8>>2]|0))}c[2832]=1560;A=0;i=l;return A|0}else{bb=V;bc=c[V>>2]|0}}while(0);V=$(bc,S)|0;D=c[bb+4>>2]|0;G=fs(($(V,D)|0)+1|0)|0;if((G|0)==0){if((c[bb+8>>2]|0)>0){V=0;do{J=v+13724+(V*56|0)+44|0;if((c[J>>2]|0)!=0){ft(c[v+13724+(V*56|0)+48>>2]|0);c[J>>2]=0}J=v+13724+(V*56|0)+52|0;O=c[J>>2]|0;if((O|0)!=0){ft(O);c[J>>2]=0}V=V+1|0;}while((V|0)<(c[(c[x>>2]|0)+8>>2]|0))}c[2832]=1560;A=0;i=l;return A|0}L1027:do{if((D|0)==0){bd=bb}else{V=(S|0)>2;J=t|0;O=t+4|0;M=t+8|0;F=(S|0)==1;E=0;P=bc;X=bb;while(1){H=G+($($(P,S)|0,E)|0)|0;if(C){az=0;do{af=u+(az<<5)+24|0;as=c[af>>2]|0;aw=c[u+(az<<5)+16>>2]|0;if((as|0)<(aw>>1|0)){be=u+(az<<5)+8|0;bf=u+(az<<5)+4|0}else{be=u+(az<<5)+4|0;bf=u+(az<<5)+8|0}c[t+(az<<2)>>2]=cs[c[u+(az<<5)>>2]&15](c[v+13724+(az*56|0)+52>>2]|0,c[bf>>2]|0,c[be>>2]|0,c[u+(az<<5)+20>>2]|0,c[u+(az<<5)+12>>2]|0)|0;Y=as+1|0;c[af>>2]=Y;do{if((Y|0)>=(aw|0)){c[af>>2]=0;as=u+(az<<5)+8|0;ax=c[as>>2]|0;c[u+(az<<5)+4>>2]=ax;aE=u+(az<<5)+28|0;aL=(c[aE>>2]|0)+1|0;c[aE>>2]=aL;if((aL|0)>=(c[v+13724+(az*56|0)+32>>2]|0)){break}c[as>>2]=ax+(c[v+13724+(az*56|0)+36>>2]|0)}}while(0);az=az+1|0;}while((az|0)<(T|0));bg=c[x>>2]|0}else{bg=X}az=c[J>>2]|0;L1044:do{if(V){if((c[bg+8>>2]|0)!=3){if((c[bg>>2]|0)==0){bh=bg;break}else{bi=H;bj=0}while(1){R=a[az+bj|0]|0;a[bi+2|0]=R;a[bi+1|0]=R;a[bi]=R;a[bi+3|0]=-1;R=bj+1|0;U=c[x>>2]|0;if(R>>>0<(c[U>>2]|0)>>>0){bi=bi+S|0;bj=R}else{bh=U;break L1044}}}U=c[O>>2]|0;R=c[M>>2]|0;L=c[bg>>2]|0;if((L|0)>0){bk=0;bl=H}else{bh=bg;break}while(1){af=d[az+bk|0]<<16|32768;aw=(d[R+bk|0]|0)-128|0;Y=(d[U+bk|0]|0)-128|0;ay=(aw*91881|0)+af|0;ax=(aw*-46802|0)+af+(Y*-22554|0)|0;aw=(Y*116130|0)+af|0;af=ay>>16;Y=ax>>16;as=aw>>16;if(af>>>0>255>>>0){bm=~(ay>>31&255)}else{bm=af&255}if(Y>>>0>255>>>0){bn=~(ax>>31&255)}else{bn=Y&255}if(as>>>0>255>>>0){bo=~(aw>>31&255)}else{bo=as&255}a[bl]=bm;a[bl+1|0]=bn;a[bl+2|0]=bo;a[bl+3|0]=-1;as=bk+1|0;if((as|0)<(L|0)){bk=as;bl=bl+S|0}else{break}}bh=c[x>>2]|0}else{L=c[bg>>2]|0;U=(L|0)==0;if(F){if(U){bh=bg;break}R=L>>>0>1>>>0?L:1;fG(H|0,az|0,R)|0;bh=bg;break}else{if(U){bh=bg;break}else{bp=H;bq=0}while(1){a[bp]=a[az+bq|0]|0;a[bp+1|0]=-1;U=bq+1|0;R=c[x>>2]|0;if(U>>>0<(c[R>>2]|0)>>>0){bp=bp+2|0;bq=U}else{bh=R;break}}}}}while(0);az=E+1|0;if(az>>>0>=(c[bh+4>>2]|0)>>>0){bd=bh;break L1027}E=az;P=c[bh>>2]|0;X=bh}}}while(0);if((c[bd+8>>2]|0)>0){S=0;while(1){T=v+13724+(S*56|0)+44|0;if((c[T>>2]|0)!=0){ft(c[v+13724+(S*56|0)+48>>2]|0);c[T>>2]=0}T=v+13724+(S*56|0)+52|0;C=c[T>>2]|0;if((C|0)!=0){ft(C);c[T>>2]=0}T=S+1|0;C=c[x>>2]|0;if((T|0)<(c[C+8>>2]|0)){S=T}else{br=C;break}}}else{br=bd}c[f>>2]=c[br>>2];c[h>>2]=c[br+4>>2];if((j|0)==0){A=G;i=l;return A|0}c[j>>2]=c[br+8>>2];A=G;i=l;return A|0}c[2832]=2848}}while(0);if((c[(c[x>>2]|0)+8>>2]|0)>0){bs=0}else{A=0;i=l;return A|0}while(1){br=v+13724+(bs*56|0)+44|0;if((c[br>>2]|0)!=0){ft(c[v+13724+(bs*56|0)+48>>2]|0);c[br>>2]=0}br=v+13724+(bs*56|0)+52|0;bd=c[br>>2]|0;if((bd|0)!=0){ft(bd);c[br>>2]=0}br=bs+1|0;if((br|0)<(c[(c[x>>2]|0)+8>>2]|0)){bs=br}else{A=0;break}}i=l;return A|0}bs=e+172|0;x=e+32|0;v=e+16|0;br=e+28|0;bd=e+40|0;bh=e+36|0;bq=0;bp=y;while(1){if((bq|0)>=8){al=935;break}do{if(bp>>>0<(c[bs>>2]|0)>>>0){y=bp+1|0;c[z>>2]=y;bt=a[bp]|0;bu=y}else{if((c[x>>2]|0)==0){bt=0;bu=bp;break}y=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((y|0)==0){c[x>>2]=0;bg=(c[bs>>2]|0)-1|0;c[z>>2]=bg;a[bg]=0;bv=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+y;bv=bd}y=bv+1|0;c[z>>2]=y;bt=a[bv]|0;bu=y}}while(0);if(bt<<24>>24==(a[4e3+bq|0]|0)){bq=bq+1|0;bp=bu}else{break}}if((al|0)==935){c[z>>2]=c[w>>2];bu=q|0;c[bu>>2]=e;if(k>>>0>4>>>0){c[2832]=2952;A=0;i=l;return A|0}bp=(eT(q,0,k)|0)==0;bq=q+12|0;bt=c[bq>>2]|0;do{if(bp){bw=0;bx=bt}else{c[bq>>2]=0;bv=c[bu>>2]|0;do{if((k|0)==0){by=bt}else{G=bv+12|0;y=c[G>>2]|0;if((y|0)==(k|0)){by=bt;break}bg=e_(bt,y,k,c[bv>>2]|0,c[bv+4>>2]|0)|0;c[G>>2]=k;if((bg|0)==0){A=0}else{by=bg;break}i=l;return A|0}}while(0);c[f>>2]=c[bv>>2];c[h>>2]=c[bv+4>>2];if((j|0)==0){bw=by;bx=0;break}c[j>>2]=c[bv+8>>2];bw=by;bx=0}}while(0);ft(bx);c[bq>>2]=0;bq=q+8|0;ft(c[bq>>2]|0);c[bq>>2]=0;bq=q+4|0;ft(c[bq>>2]|0);c[bq>>2]=0;A=bw;i=l;return A|0}c[2832]=1136;bw=c[w>>2]|0;c[z>>2]=bw;do{if(bw>>>0<(c[bs>>2]|0)>>>0){bz=bw;al=949}else{if((c[x>>2]|0)==0){break}bq=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bq|0)==0){c[x>>2]=0;q=(c[bs>>2]|0)-1|0;c[z>>2]=q;a[q]=0;bz=c[z>>2]|0;al=949;break}else{c[z>>2]=bd;c[bs>>2]=e+40+bq;bz=bd;al=949;break}}}while(0);L1136:do{if((al|0)==949){bw=bz+1|0;c[z>>2]=bw;if((a[bz]|0)!=66){break}do{if(bw>>>0<(c[bs>>2]|0)>>>0){bA=bw}else{if((c[x>>2]|0)==0){break L1136}bq=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bq|0)==0){c[x>>2]=0;q=(c[bs>>2]|0)-1|0;c[z>>2]=q;a[q]=0;bA=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+bq;bA=bd;break}}}while(0);bw=bA+1|0;c[z>>2]=bw;if((a[bA]|0)!=77){break}bv=c[bs>>2]|0;do{if(bw>>>0<bv>>>0){bq=bA+2|0;c[z>>2]=bq;bB=bq;bC=bv}else{if((c[x>>2]|0)==0){bB=bw;bC=bv;break}bq=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bq|0)==0){c[x>>2]=0;q=(c[bs>>2]|0)-1|0;c[z>>2]=q;a[q]=0;bD=c[z>>2]|0;bE=c[bs>>2]|0}else{c[z>>2]=bd;q=e+40+bq|0;c[bs>>2]=q;bD=bd;bE=q}q=bD+1|0;c[z>>2]=q;bB=q;bC=bE}}while(0);do{if(bB>>>0<bC>>>0){bv=bB+1|0;c[z>>2]=bv;bF=bv;bG=bC}else{if((c[x>>2]|0)==0){bF=bB;bG=bC;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;bH=c[z>>2]|0;bI=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;bH=bd;bI=bw}bw=bH+1|0;c[z>>2]=bw;bF=bw;bG=bI}}while(0);do{if(bF>>>0<bG>>>0){bw=bF+1|0;c[z>>2]=bw;bJ=bw;bK=bG}else{if((c[x>>2]|0)==0){bJ=bF;bK=bG;break}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;bL=c[z>>2]|0;bM=c[bs>>2]|0}else{c[z>>2]=bd;bv=e+40+bw|0;c[bs>>2]=bv;bL=bd;bM=bv}bv=bL+1|0;c[z>>2]=bv;bJ=bv;bK=bM}}while(0);do{if(bJ>>>0<bK>>>0){bv=bJ+1|0;c[z>>2]=bv;bN=bv;bO=bK}else{if((c[x>>2]|0)==0){bN=bJ;bO=bK;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;bP=c[z>>2]|0;bQ=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;bP=bd;bQ=bw}bw=bP+1|0;c[z>>2]=bw;bN=bw;bO=bQ}}while(0);do{if(bN>>>0<bO>>>0){bw=bN+1|0;c[z>>2]=bw;bR=bw;bS=bO}else{if((c[x>>2]|0)==0){bR=bN;bS=bO;break}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;bT=c[z>>2]|0;bU=c[bs>>2]|0}else{c[z>>2]=bd;bv=e+40+bw|0;c[bs>>2]=bv;bT=bd;bU=bv}bv=bT+1|0;c[z>>2]=bv;bR=bv;bS=bU}}while(0);do{if(bR>>>0<bS>>>0){bv=bR+1|0;c[z>>2]=bv;bV=bv;bW=bS}else{if((c[x>>2]|0)==0){bV=bR;bW=bS;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;bX=c[z>>2]|0;bY=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;bX=bd;bY=bw}bw=bX+1|0;c[z>>2]=bw;bV=bw;bW=bY}}while(0);do{if(bV>>>0<bW>>>0){bw=bV+1|0;c[z>>2]=bw;bZ=bw;b_=bW}else{if((c[x>>2]|0)==0){bZ=bV;b_=bW;break}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;b$=c[z>>2]|0;b0=c[bs>>2]|0}else{c[z>>2]=bd;bv=e+40+bw|0;c[bs>>2]=bv;b$=bd;b0=bv}bv=b$+1|0;c[z>>2]=bv;bZ=bv;b_=b0}}while(0);do{if(bZ>>>0<b_>>>0){bv=bZ+1|0;c[z>>2]=bv;b1=bv;b2=b_}else{if((c[x>>2]|0)==0){b1=bZ;b2=b_;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;b3=c[z>>2]|0;b4=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;b3=bd;b4=bw}bw=b3+1|0;c[z>>2]=bw;b1=bw;b2=b4}}while(0);do{if(b1>>>0<b2>>>0){bw=b1+1|0;c[z>>2]=bw;b5=bw;b6=b2}else{if((c[x>>2]|0)==0){b5=b1;b6=b2;break}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;b7=c[z>>2]|0;b8=c[bs>>2]|0}else{c[z>>2]=bd;bv=e+40+bw|0;c[bs>>2]=bv;b7=bd;b8=bv}bv=b7+1|0;c[z>>2]=bv;b5=bv;b6=b8}}while(0);do{if(b5>>>0<b6>>>0){bv=b5+1|0;c[z>>2]=bv;b9=bv;ca=b6}else{if((c[x>>2]|0)==0){b9=b5;ca=b6;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;cb=c[z>>2]|0;cc=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;cb=bd;cc=bw}bw=cb+1|0;c[z>>2]=bw;b9=bw;ca=cc}}while(0);do{if(b9>>>0<ca>>>0){bw=b9+1|0;c[z>>2]=bw;cd=bw;ce=ca}else{if((c[x>>2]|0)==0){cd=b9;ce=ca;break}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;cg=c[z>>2]|0;ch=c[bs>>2]|0}else{c[z>>2]=bd;bv=e+40+bw|0;c[bs>>2]=bv;cg=bd;ch=bv}bv=cg+1|0;c[z>>2]=bv;cd=bv;ce=ch}}while(0);do{if(cd>>>0<ce>>>0){bv=cd+1|0;c[z>>2]=bv;ci=bv;ck=ce}else{if((c[x>>2]|0)==0){ci=cd;ck=ce;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;cm=c[z>>2]|0;cn=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;cm=bd;cn=bw}bw=cm+1|0;c[z>>2]=bw;ci=bw;ck=cn}}while(0);do{if(ci>>>0<ck>>>0){bw=ci+1|0;c[z>>2]=bw;co=d[ci]|0;cp=bw;cq=ck}else{if((c[x>>2]|0)==0){co=0;cp=ci;cq=ck;break}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;cr=c[z>>2]|0;ct=c[bs>>2]|0}else{c[z>>2]=bd;bv=e+40+bw|0;c[bs>>2]=bv;cr=bd;ct=bv}bv=cr+1|0;c[z>>2]=bv;co=d[cr]|0;cp=bv;cq=ct}}while(0);do{if(cp>>>0<cq>>>0){bv=cp+1|0;c[z>>2]=bv;cu=d[cp]|0;cv=bv;cw=cq}else{if((c[x>>2]|0)==0){cu=0;cv=cp;cw=cq;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;cx=c[z>>2]|0;cy=c[bs>>2]|0}else{c[z>>2]=bd;bw=e+40+bv|0;c[bs>>2]=bw;cx=bd;cy=bw}bw=cx+1|0;c[z>>2]=bw;cu=d[cx]|0;cv=bw;cw=cy}}while(0);bw=cu<<8|co;do{if(cv>>>0<cw>>>0){bv=cv+1|0;c[z>>2]=bv;cz=d[cv]|0;cA=bv;cB=cw}else{if((c[x>>2]|0)==0){cz=0;cA=cv;cB=cw;break}bv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bv|0)==0){c[x>>2]=0;q=(c[bs>>2]|0)-1|0;c[z>>2]=q;a[q]=0;cC=c[z>>2]|0;cD=c[bs>>2]|0}else{c[z>>2]=bd;q=e+40+bv|0;c[bs>>2]=q;cC=bd;cD=q}q=cC+1|0;c[z>>2]=q;cz=d[cC]|0;cA=q;cB=cD}}while(0);do{if(cA>>>0<cB>>>0){c[z>>2]=cA+1;cE=d[cA]|0}else{if((c[x>>2]|0)==0){cE=0;break}q=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((q|0)==0){c[x>>2]=0;bv=(c[bs>>2]|0)-1|0;c[z>>2]=bv;a[bv]=0;cF=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+q;cF=bd}c[z>>2]=cF+1;cE=d[cF]|0}}while(0);q=bw|(cE<<8|cz)<<16;if(!((q|0)==108|(q|0)==56|(q|0)==40|(q|0)==12)){break}c[z>>2]=c[w>>2];A=e1(e,f,h,j,k)|0;i=l;return A|0}}while(0);cz=c[w>>2]|0;c[z>>2]=cz;do{if(cz>>>0<(c[bs>>2]|0)>>>0){cG=cz;al=1075}else{if((c[x>>2]|0)==0){al=1108;break}cE=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cE|0)==0){c[x>>2]=0;cF=(c[bs>>2]|0)-1|0;c[z>>2]=cF;a[cF]=0;cG=c[z>>2]|0;al=1075;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cE;cG=bd;al=1075;break}}}while(0);L1300:do{if((al|0)==1075){cz=cG+1|0;c[z>>2]=cz;if((a[cG]|0)!=71){al=1108;break}do{if(cz>>>0<(c[bs>>2]|0)>>>0){cH=cz}else{if((c[x>>2]|0)==0){al=1108;break L1300}cE=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cE|0)==0){c[x>>2]=0;cF=(c[bs>>2]|0)-1|0;c[z>>2]=cF;a[cF]=0;cH=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cE;cH=bd;break}}}while(0);cz=cH+1|0;c[z>>2]=cz;if((a[cH]|0)!=73){al=1108;break}do{if(cz>>>0<(c[bs>>2]|0)>>>0){cI=cz}else{if((c[x>>2]|0)==0){al=1108;break L1300}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;cE=(c[bs>>2]|0)-1|0;c[z>>2]=cE;a[cE]=0;cI=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+bw;cI=bd;break}}}while(0);cz=cI+1|0;c[z>>2]=cz;if((a[cI]|0)!=70){al=1108;break}do{if(cz>>>0<(c[bs>>2]|0)>>>0){cJ=cz}else{if((c[x>>2]|0)==0){al=1108;break L1300}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;cE=(c[bs>>2]|0)-1|0;c[z>>2]=cE;a[cE]=0;cJ=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+bw;cJ=bd;break}}}while(0);cz=cJ+1|0;c[z>>2]=cz;if((a[cJ]|0)!=56){al=1108;break}do{if(cz>>>0<(c[bs>>2]|0)>>>0){cK=cz}else{if((c[x>>2]|0)==0){al=1108;break L1300}bw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((bw|0)==0){c[x>>2]=0;cE=(c[bs>>2]|0)-1|0;c[z>>2]=cE;a[cE]=0;cK=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+bw;cK=bd;break}}}while(0);cz=cK+1|0;c[z>>2]=cz;bw=d[cK]|0;if(!((bw|0)==57|(bw|0)==55)){al=1108;break}if(cz>>>0<(c[bs>>2]|0)>>>0){cL=cz;cM=cK+2|0}else{if((c[x>>2]|0)==0){cz=c[w>>2]|0;c[z>>2]=cz;cN=cz;break}cz=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cz|0)==0){c[x>>2]=0;bw=(c[bs>>2]|0)-1|0;c[z>>2]=bw;a[bw]=0;cO=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+cz;cO=bd}cL=cO;cM=cO+1|0}c[z>>2]=cM;cz=(a[cL]|0)==97;bw=c[w>>2]|0;c[z>>2]=bw;if(!cz){cN=bw;break}fF(p|0,0,18508);bw=p+8|0;L1347:do{if((eS(e,p,j,0)|0)==0){cP=0}else{cz=p|0;cE=p+4|0;cF=$(c[cz>>2]<<2,c[cE>>2]|0)|0;cA=fs(cF)|0;c[bw>>2]=cA;if((cA|0)==0){c[2832]=1560;cP=0;break}cB=c[p+16>>2]|0;cD=p+32+(cB<<2)|0;L1352:do{if((cF|0)>0){cC=p+32+(cB<<2)+2|0;cw=p+32+(cB<<2)+1|0;cv=p+32+(cB<<2)+3|0;co=0;cu=cA;while(1){a[cu+co|0]=a[cC]|0;a[cu+(co|1)|0]=a[cw]|0;a[cu+(co|2)|0]=a[cD]|0;a[cu+(co|3)|0]=a[cv]|0;cy=co+4|0;if((cy|0)>=($(c[cz>>2]<<2,c[cE>>2]|0)|0)){break L1352}co=cy;cu=c[bw>>2]|0}}}while(0);cD=p+28|0;cA=p+24|0;cB=e+20|0;L1358:while(1){cF=c[z>>2]|0;do{if(cF>>>0<(c[bs>>2]|0)>>>0){cQ=cF}else{if((c[x>>2]|0)==0){al=1344;break L1358}cu=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cu|0)==0){c[x>>2]=0;co=(c[bs>>2]|0)-1|0;c[z>>2]=co;a[co]=0;cQ=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cu;cQ=bd;break}}}while(0);cR=cQ+1|0;c[z>>2]=cR;cF=d[cQ]|0;if((cF|0)==44){break}else if((cF|0)==59){cP=1;break L1347}else if((cF|0)!=33){al=1344;break}do{if(cR>>>0<(c[bs>>2]|0)>>>0){cS=cR;al=1293}else{if((c[x>>2]|0)==0){cT=cR;break}cF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cF|0)==0){c[x>>2]=0;cu=(c[bs>>2]|0)-1|0;c[z>>2]=cu;a[cu]=0;cS=c[z>>2]|0;al=1293;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cF;cS=bd;al=1293;break}}}while(0);L1374:do{if((al|0)==1293){al=0;cF=cS+1|0;c[z>>2]=cF;if((a[cS]|0)!=-7){cT=cF;break}do{if(cF>>>0<(c[bs>>2]|0)>>>0){cU=cF;al=1299}else{if((c[x>>2]|0)==0){cV=0;cW=cF;break}cu=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cu|0)==0){c[x>>2]=0;co=(c[bs>>2]|0)-1|0;c[z>>2]=co;a[co]=0;cU=c[z>>2]|0;al=1299;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cu;cU=bd;al=1299;break}}}while(0);do{if((al|0)==1299){al=0;cF=cU+1|0;c[z>>2]=cF;cu=a[cU]|0;if(cu<<24>>24!=4){cV=cu&255;cW=cF;break}cu=c[bs>>2]|0;do{if(cF>>>0<cu>>>0){co=cU+2|0;c[z>>2]=co;cX=d[cF]|0;cY=co;cZ=cu}else{if((c[x>>2]|0)==0){cX=0;cY=cF;cZ=cu;break}co=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((co|0)==0){c[x>>2]=0;cv=(c[bs>>2]|0)-1|0;c[z>>2]=cv;a[cv]=0;c_=c[z>>2]|0;c$=c[bs>>2]|0}else{c[z>>2]=bd;cv=e+40+co|0;c[bs>>2]=cv;c_=bd;c$=cv}cv=c_+1|0;c[z>>2]=cv;cX=d[c_]|0;cY=cv;cZ=c$}}while(0);c[cD>>2]=cX;do{if(cY>>>0<cZ>>>0){cu=cY+1|0;c[z>>2]=cu;c0=cu;c1=cZ}else{if((c[x>>2]|0)==0){c0=cY;c1=cZ;break}cu=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cu|0)==0){c[x>>2]=0;cF=(c[bs>>2]|0)-1|0;c[z>>2]=cF;a[cF]=0;c2=c[z>>2]|0;c3=c[bs>>2]|0}else{c[z>>2]=bd;cF=e+40+cu|0;c[bs>>2]=cF;c2=bd;c3=cF}cF=c2+1|0;c[z>>2]=cF;c0=cF;c1=c3}}while(0);do{if(c0>>>0<c1>>>0){cF=c0+1|0;c[z>>2]=cF;c4=cF;c5=c1}else{if((c[x>>2]|0)==0){c4=c0;c5=c1;break}cF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cF|0)==0){c[x>>2]=0;cu=(c[bs>>2]|0)-1|0;c[z>>2]=cu;a[cu]=0;c6=c[z>>2]|0;c7=c[bs>>2]|0}else{c[z>>2]=bd;cu=e+40+cF|0;c[bs>>2]=cu;c6=bd;c7=cu}cu=c6+1|0;c[z>>2]=cu;c4=cu;c5=c7}}while(0);do{if(c4>>>0<c5>>>0){cu=c4+1|0;c[z>>2]=cu;c8=d[c4]|0;c9=cu}else{if((c[x>>2]|0)==0){c8=0;c9=c4;break}cu=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cu|0)==0){c[x>>2]=0;cF=(c[bs>>2]|0)-1|0;c[z>>2]=cF;a[cF]=0;da=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+cu;da=bd}cu=da+1|0;c[z>>2]=cu;c8=d[da]|0;c9=cu}}while(0);c[cA>>2]=c8;cT=c9;break L1374}}while(0);do{if((c[v>>2]|0)!=0){cu=c[bs>>2]|0;cF=cu-cW|0;if((cF|0)>=(cV|0)){break}c[z>>2]=cu;cj[c[cB>>2]&63](c[br>>2]|0,cV-cF|0);continue L1358}}while(0);c[z>>2]=cW+cV;continue L1358}}while(0);L1429:while(1){do{if(cT>>>0<(c[bs>>2]|0)>>>0){db=cT}else{if((c[x>>2]|0)==0){continue L1358}cF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cF|0)==0){c[x>>2]=0;cu=(c[bs>>2]|0)-1|0;c[z>>2]=cu;a[cu]=0;db=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cF;db=bd;break}}}while(0);cF=db+1|0;c[z>>2]=cF;cu=a[db]|0;cv=cu&255;if(cu<<24>>24==0){continue L1358}do{if((c[v>>2]|0)!=0){cu=c[bs>>2]|0;co=cu-cF|0;if((co|0)>=(cv|0)){break}c[z>>2]=cu;cj[c[cB>>2]&63](c[br>>2]|0,cv-co|0);cT=c[z>>2]|0;continue L1429}}while(0);cF=db+(cv+1)|0;c[z>>2]=cF;cT=cF}}if((al|0)==1344){c[2832]=3152;cP=0;break}cF=c[bs>>2]|0;do{if(cR>>>0<cF>>>0){co=cQ+2|0;c[z>>2]=co;dc=d[cR]|0;dd=co;de=cF}else{if((c[x>>2]|0)==0){dc=0;dd=cR;de=cF;break}co=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((co|0)==0){c[x>>2]=0;cu=(c[bs>>2]|0)-1|0;c[z>>2]=cu;a[cu]=0;df=c[z>>2]|0;dg=c[bs>>2]|0}else{c[z>>2]=bd;cu=e+40+co|0;c[bs>>2]=cu;df=bd;dg=cu}cu=df+1|0;c[z>>2]=cu;dc=d[df]|0;dd=cu;de=dg}}while(0);do{if(dd>>>0<de>>>0){cF=dd+1|0;c[z>>2]=cF;dh=d[dd]|0;di=cF;dj=de}else{if((c[x>>2]|0)==0){dh=0;di=dd;dj=de;break}cF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cF|0)==0){c[x>>2]=0;cu=(c[bs>>2]|0)-1|0;c[z>>2]=cu;a[cu]=0;dk=c[z>>2]|0;dl=c[bs>>2]|0}else{c[z>>2]=bd;cu=e+40+cF|0;c[bs>>2]=cu;dk=bd;dl=cu}cu=dk+1|0;c[z>>2]=cu;dh=d[dk]|0;di=cu;dj=dl}}while(0);cu=dh<<8|dc;do{if(di>>>0<dj>>>0){cF=di+1|0;c[z>>2]=cF;dm=d[di]|0;dn=cF;dp=dj}else{if((c[x>>2]|0)==0){dm=0;dn=di;dp=dj;break}cF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cF|0)==0){c[x>>2]=0;co=(c[bs>>2]|0)-1|0;c[z>>2]=co;a[co]=0;dq=c[z>>2]|0;dr=c[bs>>2]|0}else{c[z>>2]=bd;co=e+40+cF|0;c[bs>>2]=co;dq=bd;dr=co}co=dq+1|0;c[z>>2]=co;dm=d[dq]|0;dn=co;dp=dr}}while(0);do{if(dn>>>0<dp>>>0){co=dn+1|0;c[z>>2]=co;ds=d[dn]|0;dt=co;du=dp}else{if((c[x>>2]|0)==0){ds=0;dt=dn;du=dp;break}co=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((co|0)==0){c[x>>2]=0;cF=(c[bs>>2]|0)-1|0;c[z>>2]=cF;a[cF]=0;dv=c[z>>2]|0;dw=c[bs>>2]|0}else{c[z>>2]=bd;cF=e+40+co|0;c[bs>>2]=cF;dv=bd;dw=cF}cF=dv+1|0;c[z>>2]=cF;ds=d[dv]|0;dt=cF;du=dw}}while(0);cF=ds<<8|dm;do{if(dt>>>0<du>>>0){co=dt+1|0;c[z>>2]=co;dx=d[dt]|0;dy=co;dz=du}else{if((c[x>>2]|0)==0){dx=0;dy=dt;dz=du;break}co=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((co|0)==0){c[x>>2]=0;cw=(c[bs>>2]|0)-1|0;c[z>>2]=cw;a[cw]=0;dA=c[z>>2]|0;dB=c[bs>>2]|0}else{c[z>>2]=bd;cw=e+40+co|0;c[bs>>2]=cw;dA=bd;dB=cw}cw=dA+1|0;c[z>>2]=cw;dx=d[dA]|0;dy=cw;dz=dB}}while(0);do{if(dy>>>0<dz>>>0){cw=dy+1|0;c[z>>2]=cw;dC=d[dy]|0;dD=cw;dE=dz}else{if((c[x>>2]|0)==0){dC=0;dD=dy;dE=dz;break}cw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cw|0)==0){c[x>>2]=0;co=(c[bs>>2]|0)-1|0;c[z>>2]=co;a[co]=0;dF=c[z>>2]|0;dG=c[bs>>2]|0}else{c[z>>2]=bd;co=e+40+cw|0;c[bs>>2]=co;dF=bd;dG=co}co=dF+1|0;c[z>>2]=co;dC=d[dF]|0;dD=co;dE=dG}}while(0);co=dC<<8|dx;do{if(dD>>>0<dE>>>0){cw=dD+1|0;c[z>>2]=cw;dH=d[dD]|0;dI=cw;dJ=dE}else{if((c[x>>2]|0)==0){dH=0;dI=dD;dJ=dE;break}cw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cw|0)==0){c[x>>2]=0;cC=(c[bs>>2]|0)-1|0;c[z>>2]=cC;a[cC]=0;dK=c[z>>2]|0;dL=c[bs>>2]|0}else{c[z>>2]=bd;cC=e+40+cw|0;c[bs>>2]=cC;dK=bd;dL=cC}cC=dK+1|0;c[z>>2]=cC;dH=d[dK]|0;dI=cC;dJ=dL}}while(0);do{if(dI>>>0<dJ>>>0){cC=dI+1|0;c[z>>2]=cC;dM=d[dI]|0;dN=cC}else{if((c[x>>2]|0)==0){dM=0;dN=dI;break}cC=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cC|0)==0){c[x>>2]=0;cw=(c[bs>>2]|0)-1|0;c[z>>2]=cw;a[cw]=0;dO=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+cC;dO=bd}cC=dO+1|0;c[z>>2]=cC;dM=d[dO]|0;dN=cC}}while(0);cC=c[cz>>2]|0;do{if((co+cu|0)<=(cC|0)){cw=(dM<<8|dH)+cF|0;if((cw|0)>(c[cE>>2]|0)){break}cy=cC<<2;cx=p+18504|0;c[cx>>2]=cy;cq=cu<<2;c[p+18480>>2]=cq;cp=$(cy,cF)|0;c[p+18484>>2]=cp;c[p+18488>>2]=(co<<2)+cq;c[p+18492>>2]=$(cw,cy)|0;c[p+18496>>2]=cq;c[p+18500>>2]=cp;do{if(dN>>>0<(c[bs>>2]|0)>>>0){dP=dN;al=1189}else{if((c[x>>2]|0)==0){cp=p+18476|0;c[cp>>2]=0;dQ=cp;dR=cy;dS=dN;al=1191;break}cp=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cp|0)==0){c[x>>2]=0;cq=(c[bs>>2]|0)-1|0;c[z>>2]=cq;a[cq]=0;dP=c[z>>2]|0;al=1189;break}else{c[z>>2]=bd;c[bs>>2]=e+40+cp;dP=bd;al=1189;break}}}while(0);do{if((al|0)==1189){cy=dP+1|0;c[z>>2]=cy;cp=d[dP]|0;cq=p+18476|0;c[cq>>2]=cp;cw=c[cx>>2]|0;if((cp&64|0)==0){dQ=cq;dR=cw;dS=cy;al=1191;break}c[p+18472>>2]=cw<<3;c[p+18468>>2]=3;dT=cp;dU=cy}}while(0);if((al|0)==1191){c[p+18472>>2]=dR;c[p+18468>>2]=0;dT=c[dQ>>2]|0;dU=dS}if((dT&128|0)==0){if((c[p+12>>2]&128|0)==0){c[2832]=3168;cP=0;break L1347}else{dV=0}do{a[p+32+(dV<<2)+3|0]=-1;dV=dV+1|0;}while((dV|0)<256);cx=c[cA>>2]|0;do{if((cx|0)>-1){if((c[cD>>2]&1|0)==0){break}a[p+32+(cx<<2)+3|0]=0}}while(0);c[p+18464>>2]=p+32;dW=dU}else{cx=2<<(dT&7);if((cx|0)>0){cy=((c[cA>>2]|0)==0&(c[cD>>2]&1|0)!=0)<<31>>31;cp=0;cw=dU;while(1){cq=c[bs>>2]|0;do{if(cw>>>0<cq>>>0){ct=cw+1|0;c[z>>2]=ct;dX=a[cw]|0;dY=ct;dZ=cq}else{if((c[x>>2]|0)==0){dX=0;dY=cw;dZ=cq;break}ct=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((ct|0)==0){c[x>>2]=0;cr=(c[bs>>2]|0)-1|0;c[z>>2]=cr;a[cr]=0;d_=c[z>>2]|0;d$=c[bs>>2]|0}else{c[z>>2]=bd;cr=e+40+ct|0;c[bs>>2]=cr;d_=bd;d$=cr}cr=d_+1|0;c[z>>2]=cr;dX=a[d_]|0;dY=cr;dZ=d$}}while(0);a[p+1056+(cp<<2)+2|0]=dX;do{if(dY>>>0<dZ>>>0){cq=dY+1|0;c[z>>2]=cq;d0=a[dY]|0;d1=cq;d2=dZ}else{if((c[x>>2]|0)==0){d0=0;d1=dY;d2=dZ;break}cq=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cq|0)==0){c[x>>2]=0;cv=(c[bs>>2]|0)-1|0;c[z>>2]=cv;a[cv]=0;d3=c[z>>2]|0;d4=c[bs>>2]|0}else{c[z>>2]=bd;cv=e+40+cq|0;c[bs>>2]=cv;d3=bd;d4=cv}cv=d3+1|0;c[z>>2]=cv;d0=a[d3]|0;d1=cv;d2=d4}}while(0);a[p+1056+(cp<<2)+1|0]=d0;do{if(d1>>>0<d2>>>0){cv=d1+1|0;c[z>>2]=cv;d5=a[d1]|0;d6=cv}else{if((c[x>>2]|0)==0){d5=0;d6=d1;break}cv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cv|0)==0){c[x>>2]=0;cq=(c[bs>>2]|0)-1|0;c[z>>2]=cq;a[cq]=0;d7=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+cv;d7=bd}cv=d7+1|0;c[z>>2]=cv;d5=a[d7]|0;d6=cv}}while(0);a[p+1056+(cp<<2)|0]=d5;a[p+1056+(cp<<2)+3|0]=cy;cv=cp+1|0;if((cv|0)<(cx|0)){cp=cv;cw=d6}else{d8=d6;break}}}else{d8=dU}c[p+18464>>2]=p+1056;dW=d8}do{if(dW>>>0<(c[bs>>2]|0)>>>0){c[z>>2]=dW+1;d9=a[dW]|0}else{if((c[x>>2]|0)==0){d9=0;break}cw=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cw|0)==0){c[x>>2]=0;cp=(c[bs>>2]|0)-1|0;c[z>>2]=cp;a[cp]=0;ea=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+cw;ea=bd}c[z>>2]=ea+1;d9=a[ea]|0}}while(0);cw=d9&255;cp=1<<cw;if((cp|0)>0){cx=0;do{b[p+2080+(cx<<2)>>1]=-1;cy=cx&255;a[p+2080+(cx<<2)+2|0]=cy;a[p+2080+(cx<<2)+3|0]=cy;cx=cx+1|0;}while((cx|0)<(cp|0))}cx=cp+2|0;cy=cp+1|0;cv=0;cq=0;cr=0;ct=0;L1593:while(1){ck=cv;ci=cq;cn=cr;cm=-1;ce=cx;cd=cw;L1595:while(1){ch=cd+1|0;cg=(1<<ch)-1|0;ca=ck;b9=ci;cc=cn;cb=cm;b6=ce;while(1){if((b9|0)<(ch|0)){b5=cc;b8=b9;b7=ca;b2=c[z>>2]|0;while(1){if((b7|0)==0){do{if(b2>>>0<(c[bs>>2]|0)>>>0){eb=b2}else{if((c[x>>2]|0)==0){break L1593}b1=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((b1|0)==0){c[x>>2]=0;b4=(c[bs>>2]|0)-1|0;c[z>>2]=b4;a[b4]=0;eb=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+b1;eb=bd;break}}}while(0);b1=eb+1|0;c[z>>2]=b1;b4=a[eb]|0;if(b4<<24>>24==0){break L1593}ec=b4&255;ed=b1}else{ec=b7;ed=b2}b1=ec-1|0;do{if(ed>>>0<(c[bs>>2]|0)>>>0){b4=ed+1|0;c[z>>2]=b4;ee=d[ed]|0;ef=b4}else{if((c[x>>2]|0)==0){ee=0;ef=ed;break}b4=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((b4|0)==0){c[x>>2]=0;b3=(c[bs>>2]|0)-1|0;c[z>>2]=b3;a[b3]=0;eg=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+b4;eg=bd}b4=eg+1|0;c[z>>2]=b4;ee=d[eg]|0;ef=b4}}while(0);b4=ee<<b8|b5;b3=b8+8|0;if((b3|0)<(ch|0)){b5=b4;b8=b3;b7=b1;b2=ef}else{eh=b4;ei=b3;ej=b1;break}}}else{eh=cc;ei=b9;ej=ca}b2=eh&cg;b7=eh>>ch;b8=ei-ch|0;if((b2|0)==(cp|0)){cv=ej;cq=b8;cr=b7;ct=1;continue L1593}if((b2|0)==(cy|0)){al=1257;break L1593}if((b2|0)>(b6|0)){al=1284;break L1593}if(!ct){al=1274;break L1593}if((cb|0)>-1){b5=b6+1|0;if((b5|0)>4096){al=1277;break L1593}b[p+2080+(b6<<2)>>1]=cb&65535;ae=a[p+2080+(cb<<2)+2|0]|0;a[p+2080+(b6<<2)+2|0]=ae;if((b2|0)==(b5|0)){ek=ae}else{ek=a[p+2080+(b2<<2)+2|0]|0}a[p+2080+(b6<<2)+3|0]=ek;el=b5}else{if((b2|0)==(b6|0)){al=1282;break L1593}else{el=b6}}e0(p,b2&65535);if((el&cg|0)==0&(el|0)<4096){ck=ej;ci=b8;cn=b7;cm=b2;ce=el;cd=ch;continue L1595}else{ca=ej;b9=b8;cc=b7;cb=b2;b6=el}}}}L1636:do{if((al|0)==1257){do{if((c[v>>2]|0)==0){em=c[z>>2]|0;al=1261}else{ct=c[bs>>2]|0;cy=c[z>>2]|0;cr=ct-cy|0;if((cr|0)>=(ej|0)){em=cy;al=1261;break}c[z>>2]=ct;cj[c[cB>>2]&63](c[br>>2]|0,ej-cr|0)}}while(0);if((al|0)==1261){c[z>>2]=em+ej}L1644:while(1){cr=c[z>>2]|0;do{if(cr>>>0<(c[bs>>2]|0)>>>0){en=cr}else{if((c[x>>2]|0)==0){break L1636}ct=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((ct|0)==0){c[x>>2]=0;cy=(c[bs>>2]|0)-1|0;c[z>>2]=cy;a[cy]=0;en=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+ct;en=bd;break}}}while(0);cr=en+1|0;c[z>>2]=cr;ct=a[en]|0;cy=ct&255;if(ct<<24>>24==0){break L1636}do{if((c[v>>2]|0)!=0){ct=c[bs>>2]|0;cq=ct-cr|0;if((cq|0)>=(cy|0)){break}c[z>>2]=ct;cj[c[cB>>2]&63](c[br>>2]|0,cy-cq|0);continue L1644}}while(0);c[z>>2]=en+(cy+1)}}else if((al|0)==1274){c[2832]=3136;cP=0;break L1347}else if((al|0)==1277){c[2832]=3120;cP=0;break L1347}else if((al|0)==1282){c[2832]=3080;cP=0;break L1347}else if((al|0)==1284){c[2832]=3080;cP=0;break L1347}}while(0);cr=c[bw>>2]|0;if((cr|0)==0){cP=0;break L1347}if((k|0)==4|(k|0)==0){cP=cr;break L1347}cP=e_(cr,4,k,c[cz>>2]|0,c[cE>>2]|0)|0;break L1347}}while(0);c[2832]=3192;cP=0}}while(0);bw=(cP|0)==1?0:cP;if((bw|0)==0){A=0;i=l;return A|0}c[f>>2]=c[p>>2];c[h>>2]=c[p+4>>2];A=bw;i=l;return A|0}}while(0);if((al|0)==1108){p=c[w>>2]|0;c[z>>2]=p;cN=p}p=c[bs>>2]|0;do{if(cN>>>0<p>>>0){cP=cN+1|0;c[z>>2]=cP;eo=d[cN]|0;ep=cP;eq=p}else{if((c[x>>2]|0)==0){eo=0;ep=cN;eq=p;break}cP=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((cP|0)==0){c[x>>2]=0;en=(c[bs>>2]|0)-1|0;c[z>>2]=en;a[en]=0;er=c[z>>2]|0;es=c[bs>>2]|0}else{c[z>>2]=bd;en=e+40+cP|0;c[bs>>2]=en;er=bd;es=en}en=er+1|0;c[z>>2]=en;eo=d[er]|0;ep=en;eq=es}}while(0);es=eo<<8;do{if(ep>>>0<eq>>>0){eo=ep+1|0;c[z>>2]=eo;et=d[ep]|0;eu=eo;ew=eq}else{if((c[x>>2]|0)==0){et=0;eu=ep;ew=eq;break}eo=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eo|0)==0){c[x>>2]=0;er=(c[bs>>2]|0)-1|0;c[z>>2]=er;a[er]=0;ex=c[z>>2]|0;ey=c[bs>>2]|0}else{c[z>>2]=bd;er=e+40+eo|0;c[bs>>2]=er;ex=bd;ey=er}er=ex+1|0;c[z>>2]=er;et=d[ex]|0;eu=er;ew=ey}}while(0);ey=(et|es)<<16;do{if(eu>>>0<ew>>>0){es=eu+1|0;c[z>>2]=es;ez=d[eu]|0;eA=es;eB=ew}else{if((c[x>>2]|0)==0){ez=0;eA=eu;eB=ew;break}es=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((es|0)==0){c[x>>2]=0;et=(c[bs>>2]|0)-1|0;c[z>>2]=et;a[et]=0;eC=c[z>>2]|0;eD=c[bs>>2]|0}else{c[z>>2]=bd;et=e+40+es|0;c[bs>>2]=et;eC=bd;eD=et}et=eC+1|0;c[z>>2]=et;ez=d[eC]|0;eA=et;eB=eD}}while(0);eD=ez<<8;do{if(eA>>>0<eB>>>0){c[z>>2]=eA+1;eE=d[eA]|0}else{if((c[x>>2]|0)==0){eE=0;break}ez=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((ez|0)==0){c[x>>2]=0;eC=(c[bs>>2]|0)-1|0;c[z>>2]=eC;a[eC]=0;eF=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+ez;eF=bd}c[z>>2]=eF+1;eE=d[eF]|0}}while(0);eF=c[w>>2]|0;c[z>>2]=eF;if((eD|ey|eE|0)==943870035){eE=c[bs>>2]|0;do{if(eF>>>0<eE>>>0){ey=eF+1|0;c[z>>2]=ey;eG=d[eF]|0;eH=ey;eI=eE}else{if((c[x>>2]|0)==0){eG=0;eH=eF;eI=eE;break}ey=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((ey|0)==0){c[x>>2]=0;eD=(c[bs>>2]|0)-1|0;c[z>>2]=eD;a[eD]=0;eJ=c[z>>2]|0;eK=c[bs>>2]|0}else{c[z>>2]=bd;eD=e+40+ey|0;c[bs>>2]=eD;eJ=bd;eK=eD}eD=eJ+1|0;c[z>>2]=eD;eG=d[eJ]|0;eH=eD;eI=eK}}while(0);eK=eG<<8;do{if(eH>>>0<eI>>>0){eG=eH+1|0;c[z>>2]=eG;eL=d[eH]|0;eM=eG;eN=eI}else{if((c[x>>2]|0)==0){eL=0;eM=eH;eN=eI;break}eG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eG|0)==0){c[x>>2]=0;eJ=(c[bs>>2]|0)-1|0;c[z>>2]=eJ;a[eJ]=0;eO=c[z>>2]|0;eP=c[bs>>2]|0}else{c[z>>2]=bd;eJ=e+40+eG|0;c[bs>>2]=eJ;eO=bd;eP=eJ}eJ=eO+1|0;c[z>>2]=eJ;eL=d[eO]|0;eM=eJ;eN=eP}}while(0);eP=(eL|eK)<<16;do{if(eM>>>0<eN>>>0){eK=eM+1|0;c[z>>2]=eK;eQ=d[eM]|0;eR=eK;eU=eN}else{if((c[x>>2]|0)==0){eQ=0;eR=eM;eU=eN;break}eK=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eK|0)==0){c[x>>2]=0;eL=(c[bs>>2]|0)-1|0;c[z>>2]=eL;a[eL]=0;eX=c[z>>2]|0;eY=c[bs>>2]|0}else{c[z>>2]=bd;eL=e+40+eK|0;c[bs>>2]=eL;eX=bd;eY=eL}eL=eX+1|0;c[z>>2]=eL;eQ=d[eX]|0;eR=eL;eU=eY}}while(0);eY=eQ<<8;do{if(eR>>>0<eU>>>0){eQ=eR+1|0;c[z>>2]=eQ;eZ=d[eR]|0;e2=eQ}else{if((c[x>>2]|0)==0){eZ=0;e2=eR;break}eQ=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eQ|0)==0){c[x>>2]=0;eX=(c[bs>>2]|0)-1|0;c[z>>2]=eX;a[eX]=0;e3=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+eQ;e3=bd}eQ=e3+1|0;c[z>>2]=eQ;eZ=d[e3]|0;e2=eQ}}while(0);if((eY|eP|eZ|0)!=943870035){c[2832]=3304;A=0;i=l;return A|0}eZ=c[bs>>2]|0;do{if(e2>>>0<eZ>>>0){eP=e2+1|0;c[z>>2]=eP;e4=d[e2]|0;e5=eP;e6=eZ}else{if((c[x>>2]|0)==0){e4=0;e5=e2;e6=eZ;break}eP=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eP|0)==0){c[x>>2]=0;eY=(c[bs>>2]|0)-1|0;c[z>>2]=eY;a[eY]=0;e9=c[z>>2]|0;fa=c[bs>>2]|0}else{c[z>>2]=bd;eY=e+40+eP|0;c[bs>>2]=eY;e9=bd;fa=eY}eY=e9+1|0;c[z>>2]=eY;e4=d[e9]|0;e5=eY;e6=fa}}while(0);fa=e4<<8;do{if(e5>>>0<e6>>>0){e4=e5+1|0;c[z>>2]=e4;fb=d[e5]|0;fc=e4}else{if((c[x>>2]|0)==0){fb=0;fc=e5;break}e4=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((e4|0)==0){c[x>>2]=0;e9=(c[bs>>2]|0)-1|0;c[z>>2]=e9;a[e9]=0;fd=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+e4;fd=bd}e4=fd+1|0;c[z>>2]=e4;fb=d[fd]|0;fc=e4}}while(0);if((fb|fa|0)!=1){c[2832]=3288;A=0;i=l;return A|0}do{if((c[v>>2]|0)==0){al=1425}else{fa=c[bs>>2]|0;fb=fa-fc|0;if((fb|0)>=6){al=1425;break}c[z>>2]=fa;cj[c[e+20>>2]&63](c[br>>2]|0,6-fb|0);fe=c[z>>2]|0}}while(0);if((al|0)==1425){fb=fc+6|0;c[z>>2]=fb;fe=fb}fb=c[bs>>2]|0;do{if(fe>>>0<fb>>>0){fc=fe+1|0;c[z>>2]=fc;ff=d[fe]|0;fg=fc;fh=fb}else{if((c[x>>2]|0)==0){ff=0;fg=fe;fh=fb;break}fc=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fc|0)==0){c[x>>2]=0;fa=(c[bs>>2]|0)-1|0;c[z>>2]=fa;a[fa]=0;fi=c[z>>2]|0;fj=c[bs>>2]|0}else{c[z>>2]=bd;fa=e+40+fc|0;c[bs>>2]=fa;fi=bd;fj=fa}fa=fi+1|0;c[z>>2]=fa;ff=d[fi]|0;fg=fa;fh=fj}}while(0);fj=ff<<8;do{if(fg>>>0<fh>>>0){ff=fg+1|0;c[z>>2]=ff;fk=d[fg]|0;fl=ff}else{if((c[x>>2]|0)==0){fk=0;fl=fg;break}ff=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((ff|0)==0){c[x>>2]=0;fi=(c[bs>>2]|0)-1|0;c[z>>2]=fi;a[fi]=0;fm=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+ff;fm=bd}ff=fm+1|0;c[z>>2]=ff;fk=d[fm]|0;fl=ff}}while(0);fm=fk|fj;if(fm>>>0>16>>>0){c[2832]=3264;A=0;i=l;return A|0}fj=c[bs>>2]|0;do{if(fl>>>0<fj>>>0){fk=fl+1|0;c[z>>2]=fk;fn=d[fl]|0;fo=fk;fp=fj}else{if((c[x>>2]|0)==0){fn=0;fo=fl;fp=fj;break}fk=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fk|0)==0){c[x>>2]=0;fg=(c[bs>>2]|0)-1|0;c[z>>2]=fg;a[fg]=0;fq=c[z>>2]|0;fr=c[bs>>2]|0}else{c[z>>2]=bd;fg=e+40+fk|0;c[bs>>2]=fg;fq=bd;fr=fg}fg=fq+1|0;c[z>>2]=fg;fn=d[fq]|0;fo=fg;fp=fr}}while(0);fr=fn<<8;do{if(fo>>>0<fp>>>0){fn=fo+1|0;c[z>>2]=fn;fu=d[fo]|0;fv=fn;fw=fp}else{if((c[x>>2]|0)==0){fu=0;fv=fo;fw=fp;break}fn=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fn|0)==0){c[x>>2]=0;fq=(c[bs>>2]|0)-1|0;c[z>>2]=fq;a[fq]=0;fx=c[z>>2]|0;fy=c[bs>>2]|0}else{c[z>>2]=bd;fq=e+40+fn|0;c[bs>>2]=fq;fx=bd;fy=fq}fq=fx+1|0;c[z>>2]=fq;fu=d[fx]|0;fv=fq;fw=fy}}while(0);fy=(fu|fr)<<16;do{if(fv>>>0<fw>>>0){fr=fv+1|0;c[z>>2]=fr;fz=d[fv]|0;fA=fr;fB=fw}else{if((c[x>>2]|0)==0){fz=0;fA=fv;fB=fw;break}fr=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fr|0)==0){c[x>>2]=0;fu=(c[bs>>2]|0)-1|0;c[z>>2]=fu;a[fu]=0;fC=c[z>>2]|0;fD=c[bs>>2]|0}else{c[z>>2]=bd;fu=e+40+fr|0;c[bs>>2]=fu;fC=bd;fD=fu}fu=fC+1|0;c[z>>2]=fu;fz=d[fC]|0;fA=fu;fB=fD}}while(0);fD=fz<<8;do{if(fA>>>0<fB>>>0){fz=fA+1|0;c[z>>2]=fz;fE=d[fA]|0;fH=fz;fI=fB}else{if((c[x>>2]|0)==0){fE=0;fH=fA;fI=fB;break}fz=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fz|0)==0){c[x>>2]=0;fC=(c[bs>>2]|0)-1|0;c[z>>2]=fC;a[fC]=0;fJ=c[z>>2]|0;fK=c[bs>>2]|0}else{c[z>>2]=bd;fC=e+40+fz|0;c[bs>>2]=fC;fJ=bd;fK=fC}fC=fJ+1|0;c[z>>2]=fC;fE=d[fJ]|0;fH=fC;fI=fK}}while(0);fK=fD|fy|fE;do{if(fH>>>0<fI>>>0){fE=fH+1|0;c[z>>2]=fE;fL=d[fH]|0;fM=fE;fN=fI}else{if((c[x>>2]|0)==0){fL=0;fM=fH;fN=fI;break}fE=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fE|0)==0){c[x>>2]=0;fy=(c[bs>>2]|0)-1|0;c[z>>2]=fy;a[fy]=0;fO=c[z>>2]|0;fP=c[bs>>2]|0}else{c[z>>2]=bd;fy=e+40+fE|0;c[bs>>2]=fy;fO=bd;fP=fy}fy=fO+1|0;c[z>>2]=fy;fL=d[fO]|0;fM=fy;fN=fP}}while(0);fP=fL<<8;do{if(fM>>>0<fN>>>0){fL=fM+1|0;c[z>>2]=fL;fQ=d[fM]|0;fR=fL;fS=fN}else{if((c[x>>2]|0)==0){fQ=0;fR=fM;fS=fN;break}fL=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fL|0)==0){c[x>>2]=0;fO=(c[bs>>2]|0)-1|0;c[z>>2]=fO;a[fO]=0;fT=c[z>>2]|0;fU=c[bs>>2]|0}else{c[z>>2]=bd;fO=e+40+fL|0;c[bs>>2]=fO;fT=bd;fU=fO}fO=fT+1|0;c[z>>2]=fO;fQ=d[fT]|0;fR=fO;fS=fU}}while(0);fU=(fQ|fP)<<16;do{if(fR>>>0<fS>>>0){fP=fR+1|0;c[z>>2]=fP;fV=d[fR]|0;fW=fP;fX=fS}else{if((c[x>>2]|0)==0){fV=0;fW=fR;fX=fS;break}fP=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fP|0)==0){c[x>>2]=0;fQ=(c[bs>>2]|0)-1|0;c[z>>2]=fQ;a[fQ]=0;fY=c[z>>2]|0;fZ=c[bs>>2]|0}else{c[z>>2]=bd;fQ=e+40+fP|0;c[bs>>2]=fQ;fY=bd;fZ=fQ}fQ=fY+1|0;c[z>>2]=fQ;fV=d[fY]|0;fW=fQ;fX=fZ}}while(0);fZ=fV<<8;do{if(fW>>>0<fX>>>0){fV=fW+1|0;c[z>>2]=fV;f_=d[fW]|0;f$=fV;f0=fX}else{if((c[x>>2]|0)==0){f_=0;f$=fW;f0=fX;break}fV=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fV|0)==0){c[x>>2]=0;fY=(c[bs>>2]|0)-1|0;c[z>>2]=fY;a[fY]=0;f1=c[z>>2]|0;f2=c[bs>>2]|0}else{c[z>>2]=bd;fY=e+40+fV|0;c[bs>>2]=fY;f1=bd;f2=fY}fY=f1+1|0;c[z>>2]=fY;f_=d[f1]|0;f$=fY;f0=f2}}while(0);f2=fZ|fU|f_;do{if(f$>>>0<f0>>>0){f_=f$+1|0;c[z>>2]=f_;f3=d[f$]|0;f4=f_;f5=f0}else{if((c[x>>2]|0)==0){f3=0;f4=f$;f5=f0;break}f_=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((f_|0)==0){c[x>>2]=0;fU=(c[bs>>2]|0)-1|0;c[z>>2]=fU;a[fU]=0;f6=c[z>>2]|0;f7=c[bs>>2]|0}else{c[z>>2]=bd;fU=e+40+f_|0;c[bs>>2]=fU;f6=bd;f7=fU}fU=f6+1|0;c[z>>2]=fU;f3=d[f6]|0;f4=fU;f5=f7}}while(0);f7=f3<<8;do{if(f4>>>0<f5>>>0){f3=f4+1|0;c[z>>2]=f3;f8=d[f4]|0;f9=f3}else{if((c[x>>2]|0)==0){f8=0;f9=f4;break}f3=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((f3|0)==0){c[x>>2]=0;f6=(c[bs>>2]|0)-1|0;c[z>>2]=f6;a[f6]=0;ga=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+f3;ga=bd}f3=ga+1|0;c[z>>2]=f3;f8=d[ga]|0;f9=f3}}while(0);if((f8|f7|0)!=8){c[2832]=3240;A=0;i=l;return A|0}f7=c[bs>>2]|0;do{if(f9>>>0<f7>>>0){f8=f9+1|0;c[z>>2]=f8;gb=d[f9]|0;gc=f8;gd=f7}else{if((c[x>>2]|0)==0){gb=0;gc=f9;gd=f7;break}f8=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((f8|0)==0){c[x>>2]=0;ga=(c[bs>>2]|0)-1|0;c[z>>2]=ga;a[ga]=0;ge=c[z>>2]|0;gf=c[bs>>2]|0}else{c[z>>2]=bd;ga=e+40+f8|0;c[bs>>2]=ga;ge=bd;gf=ga}ga=ge+1|0;c[z>>2]=ga;gb=d[ge]|0;gc=ga;gd=gf}}while(0);gf=gb<<8;do{if(gc>>>0<gd>>>0){gb=gc+1|0;c[z>>2]=gb;gg=d[gc]|0;gh=gb}else{if((c[x>>2]|0)==0){gg=0;gh=gc;break}gb=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gb|0)==0){c[x>>2]=0;ge=(c[bs>>2]|0)-1|0;c[z>>2]=ge;a[ge]=0;gi=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+gb;gi=bd}gb=gi+1|0;c[z>>2]=gb;gg=d[gi]|0;gh=gb}}while(0);if((gg|gf|0)!=3){c[2832]=3216;A=0;i=l;return A|0}gf=c[bs>>2]|0;do{if(gh>>>0<gf>>>0){gg=gh+1|0;c[z>>2]=gg;gj=d[gh]|0;gk=gg;gl=gf}else{if((c[x>>2]|0)==0){gj=0;gk=gh;gl=gf;break}gg=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gg|0)==0){c[x>>2]=0;gi=(c[bs>>2]|0)-1|0;c[z>>2]=gi;a[gi]=0;gm=c[z>>2]|0;gn=c[bs>>2]|0}else{c[z>>2]=bd;gi=e+40+gg|0;c[bs>>2]=gi;gm=bd;gn=gi}gi=gm+1|0;c[z>>2]=gi;gj=d[gm]|0;gk=gi;gl=gn}}while(0);gn=gj<<8;do{if(gk>>>0<gl>>>0){gj=gk+1|0;c[z>>2]=gj;go=d[gk]|0;gp=gj;gq=gl}else{if((c[x>>2]|0)==0){go=0;gp=gk;gq=gl;break}gj=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gj|0)==0){c[x>>2]=0;gm=(c[bs>>2]|0)-1|0;c[z>>2]=gm;a[gm]=0;gr=c[z>>2]|0;gs=c[bs>>2]|0}else{c[z>>2]=bd;gm=e+40+gj|0;c[bs>>2]=gm;gr=bd;gs=gm}gm=gr+1|0;c[z>>2]=gm;go=d[gr]|0;gp=gm;gq=gs}}while(0);gs=(go|gn)<<16;do{if(gp>>>0<gq>>>0){gn=gp+1|0;c[z>>2]=gn;gt=d[gp]|0;gu=gn;gv=gq}else{if((c[x>>2]|0)==0){gt=0;gu=gp;gv=gq;break}gn=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gn|0)==0){c[x>>2]=0;go=(c[bs>>2]|0)-1|0;c[z>>2]=go;a[go]=0;gw=c[z>>2]|0;gx=c[bs>>2]|0}else{c[z>>2]=bd;go=e+40+gn|0;c[bs>>2]=go;gw=bd;gx=go}go=gw+1|0;c[z>>2]=go;gt=d[gw]|0;gu=go;gv=gx}}while(0);gx=gt<<8;do{if(gu>>>0<gv>>>0){gt=gu+1|0;c[z>>2]=gt;gy=d[gu]|0;gz=gt}else{if((c[x>>2]|0)==0){gy=0;gz=gu;break}gt=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gt|0)==0){c[x>>2]=0;gw=(c[bs>>2]|0)-1|0;c[z>>2]=gw;a[gw]=0;gA=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+gt;gA=bd}gt=gA+1|0;c[z>>2]=gt;gy=d[gA]|0;gz=gt}}while(0);gA=gx|gs|gy;do{if((c[v>>2]|0)==0){al=1561}else{gy=c[bs>>2]|0;gs=gy-gz|0;if((gs|0)>=(gA|0)){al=1561;break}c[z>>2]=gy;cj[c[e+20>>2]&63](c[br>>2]|0,gA-gs|0);gB=c[z>>2]|0}}while(0);if((al|0)==1561){gs=gz+gA|0;c[z>>2]=gs;gB=gs}gs=c[bs>>2]|0;do{if(gB>>>0<gs>>>0){gA=gB+1|0;c[z>>2]=gA;gC=d[gB]|0;gD=gA;gE=gs}else{if((c[x>>2]|0)==0){gC=0;gD=gB;gE=gs;break}gA=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gA|0)==0){c[x>>2]=0;gz=(c[bs>>2]|0)-1|0;c[z>>2]=gz;a[gz]=0;gF=c[z>>2]|0;gG=c[bs>>2]|0}else{c[z>>2]=bd;gz=e+40+gA|0;c[bs>>2]=gz;gF=bd;gG=gz}gz=gF+1|0;c[z>>2]=gz;gC=d[gF]|0;gD=gz;gE=gG}}while(0);gG=gC<<8;do{if(gD>>>0<gE>>>0){gC=gD+1|0;c[z>>2]=gC;gH=d[gD]|0;gI=gC;gJ=gE}else{if((c[x>>2]|0)==0){gH=0;gI=gD;gJ=gE;break}gC=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gC|0)==0){c[x>>2]=0;gF=(c[bs>>2]|0)-1|0;c[z>>2]=gF;a[gF]=0;gK=c[z>>2]|0;gL=c[bs>>2]|0}else{c[z>>2]=bd;gF=e+40+gC|0;c[bs>>2]=gF;gK=bd;gL=gF}gF=gK+1|0;c[z>>2]=gF;gH=d[gK]|0;gI=gF;gJ=gL}}while(0);gL=(gH|gG)<<16;do{if(gI>>>0<gJ>>>0){gG=gI+1|0;c[z>>2]=gG;gM=d[gI]|0;gN=gG;gO=gJ}else{if((c[x>>2]|0)==0){gM=0;gN=gI;gO=gJ;break}gG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gG|0)==0){c[x>>2]=0;gH=(c[bs>>2]|0)-1|0;c[z>>2]=gH;a[gH]=0;gP=c[z>>2]|0;gQ=c[bs>>2]|0}else{c[z>>2]=bd;gH=e+40+gG|0;c[bs>>2]=gH;gP=bd;gQ=gH}gH=gP+1|0;c[z>>2]=gH;gM=d[gP]|0;gN=gH;gO=gQ}}while(0);gQ=gM<<8;do{if(gN>>>0<gO>>>0){gM=gN+1|0;c[z>>2]=gM;gR=d[gN]|0;gS=gM}else{if((c[x>>2]|0)==0){gR=0;gS=gN;break}gM=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gM|0)==0){c[x>>2]=0;gP=(c[bs>>2]|0)-1|0;c[z>>2]=gP;a[gP]=0;gT=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+gM;gT=bd}gM=gT+1|0;c[z>>2]=gM;gR=d[gT]|0;gS=gM}}while(0);gT=gQ|gL|gR;do{if((c[v>>2]|0)==0){al=1593}else{gR=c[bs>>2]|0;gL=gR-gS|0;if((gL|0)>=(gT|0)){al=1593;break}c[z>>2]=gR;cj[c[e+20>>2]&63](c[br>>2]|0,gT-gL|0);gU=c[z>>2]|0}}while(0);if((al|0)==1593){gL=gS+gT|0;c[z>>2]=gL;gU=gL}gL=c[bs>>2]|0;do{if(gU>>>0<gL>>>0){gT=gU+1|0;c[z>>2]=gT;gV=d[gU]|0;gW=gT;gX=gL}else{if((c[x>>2]|0)==0){gV=0;gW=gU;gX=gL;break}gT=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gT|0)==0){c[x>>2]=0;gS=(c[bs>>2]|0)-1|0;c[z>>2]=gS;a[gS]=0;gY=c[z>>2]|0;gZ=c[bs>>2]|0}else{c[z>>2]=bd;gS=e+40+gT|0;c[bs>>2]=gS;gY=bd;gZ=gS}gS=gY+1|0;c[z>>2]=gS;gV=d[gY]|0;gW=gS;gX=gZ}}while(0);gZ=gV<<8;do{if(gW>>>0<gX>>>0){gV=gW+1|0;c[z>>2]=gV;g_=d[gW]|0;g$=gV;g0=gX}else{if((c[x>>2]|0)==0){g_=0;g$=gW;g0=gX;break}gV=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gV|0)==0){c[x>>2]=0;gY=(c[bs>>2]|0)-1|0;c[z>>2]=gY;a[gY]=0;g1=c[z>>2]|0;g2=c[bs>>2]|0}else{c[z>>2]=bd;gY=e+40+gV|0;c[bs>>2]=gY;g1=bd;g2=gY}gY=g1+1|0;c[z>>2]=gY;g_=d[g1]|0;g$=gY;g0=g2}}while(0);g2=(g_|gZ)<<16;do{if(g$>>>0<g0>>>0){gZ=g$+1|0;c[z>>2]=gZ;g3=d[g$]|0;g4=gZ;g5=g0}else{if((c[x>>2]|0)==0){g3=0;g4=g$;g5=g0;break}gZ=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((gZ|0)==0){c[x>>2]=0;g_=(c[bs>>2]|0)-1|0;c[z>>2]=g_;a[g_]=0;g6=c[z>>2]|0;g7=c[bs>>2]|0}else{c[z>>2]=bd;g_=e+40+gZ|0;c[bs>>2]=g_;g6=bd;g7=g_}g_=g6+1|0;c[z>>2]=g_;g3=d[g6]|0;g4=g_;g5=g7}}while(0);g7=g3<<8;do{if(g4>>>0<g5>>>0){g3=g4+1|0;c[z>>2]=g3;g8=d[g4]|0;g9=g3}else{if((c[x>>2]|0)==0){g8=0;g9=g4;break}g3=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((g3|0)==0){c[x>>2]=0;g6=(c[bs>>2]|0)-1|0;c[z>>2]=g6;a[g6]=0;ha=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+g3;ha=bd}g3=ha+1|0;c[z>>2]=g3;g8=d[ha]|0;g9=g3}}while(0);ha=g7|g2|g8;do{if((c[v>>2]|0)==0){al=1625}else{g8=c[bs>>2]|0;g2=g8-g9|0;if((g2|0)>=(ha|0)){al=1625;break}c[z>>2]=g8;cj[c[e+20>>2]&63](c[br>>2]|0,ha-g2|0);hb=c[z>>2]|0}}while(0);if((al|0)==1625){g2=g9+ha|0;c[z>>2]=g2;hb=g2}g2=c[bs>>2]|0;do{if(hb>>>0<g2>>>0){ha=hb+1|0;c[z>>2]=ha;hc=d[hb]|0;hd=ha;he=g2}else{if((c[x>>2]|0)==0){hc=0;hd=hb;he=g2;break}ha=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((ha|0)==0){c[x>>2]=0;g9=(c[bs>>2]|0)-1|0;c[z>>2]=g9;a[g9]=0;hf=c[z>>2]|0;hg=c[bs>>2]|0}else{c[z>>2]=bd;g9=e+40+ha|0;c[bs>>2]=g9;hf=bd;hg=g9}g9=hf+1|0;c[z>>2]=g9;hc=d[hf]|0;hd=g9;he=hg}}while(0);hg=hc<<8;do{if(hd>>>0<he>>>0){hc=hd+1|0;c[z>>2]=hc;hh=d[hd]|0;hi=hc}else{if((c[x>>2]|0)==0){hh=0;hi=hd;break}hc=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hc|0)==0){c[x>>2]=0;hf=(c[bs>>2]|0)-1|0;c[z>>2]=hf;a[hf]=0;hj=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hc;hj=bd}hc=hj+1|0;c[z>>2]=hc;hh=d[hj]|0;hi=hc}}while(0);hj=hh|hg;if(hj>>>0>1>>>0){c[2832]=168;A=0;i=l;return A|0}hg=fs($(fK<<2,f2)|0)|0;if((hg|0)==0){c[2832]=1560;A=0;i=l;return A|0}hh=$(f2,fK)|0;if((hj|0)==0){hj=(hh|0)>0;hd=0;do{he=hg+hd|0;L2074:do{if((hd|0)>(fm|0)){if(!hj){break}hc=((hd|0)==3)<<31>>31;hf=0;g2=he;while(1){a[g2]=hc;hb=hf+1|0;if((hb|0)<(hh|0)){hf=hb;g2=g2+4|0}else{break}}}else{if(hj){hk=1;hl=he}else{break}while(1){g2=c[z>>2]|0;do{if(g2>>>0<(c[bs>>2]|0)>>>0){c[z>>2]=g2+1;hm=a[g2]|0}else{if((c[x>>2]|0)==0){hm=0;break}hf=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hf|0)==0){c[x>>2]=0;hc=(c[bs>>2]|0)-1|0;c[z>>2]=hc;a[hc]=0;hn=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hf;hn=bd}c[z>>2]=hn+1;hm=a[hn]|0}}while(0);a[hl]=hm;if((hk|0)>=(hh|0)){break L2074}hk=hk+1|0;hl=hl+4|0}}}while(0);hd=hd+1|0;}while((hd|0)<4)}else{hd=$(fK,fm<<1)|0;do{if((c[v>>2]|0)==0){al=1649}else{hl=c[bs>>2]|0;hk=hl-hi|0;if((hk|0)>=(hd|0)){al=1649;break}c[z>>2]=hl;cj[c[e+20>>2]&63](c[br>>2]|0,hd-hk|0)}}while(0);if((al|0)==1649){c[z>>2]=hi+hd}hd=(hh|0)>0;hi=0;do{hk=hg+hi|0;L2102:do{if((hi|0)<(fm|0)){hl=hk;hm=0;while(1){hn=(hm|0)<(hh|0);L2109:while(1){if(!hn){break L2102}hj=c[z>>2]|0;do{if(hj>>>0<(c[bs>>2]|0)>>>0){ho=hj}else{if((c[x>>2]|0)==0){hp=0;hq=hj;al=1667;break L2109}he=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((he|0)==0){c[x>>2]=0;g2=(c[bs>>2]|0)-1|0;c[z>>2]=g2;a[g2]=0;ho=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+he;ho=bd;break}}}while(0);hr=ho+1|0;c[z>>2]=hr;hs=a[ho]|0;ht=hs&255;if(hs<<24>>24!=-128){al=1666;break}}do{if((al|0)==1666){al=0;if(hs<<24>>24>-1){hp=ht;hq=hr;al=1667;break}hn=257-ht|0;do{if(hr>>>0<(c[bs>>2]|0)>>>0){c[z>>2]=ho+2;hu=a[hr]|0}else{if((c[x>>2]|0)==0){hu=0;break}hj=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hj|0)==0){c[x>>2]=0;he=(c[bs>>2]|0)-1|0;c[z>>2]=he;a[he]=0;hv=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hj;hv=bd}c[z>>2]=hv+1;hu=a[hv]|0}}while(0);hj=hn;he=hl;while(1){a[he]=hu;g2=hj-1|0;if((g2|0)==0){break}else{hj=g2;he=he+4|0}}hw=hn;hx=(ht*-4|0)+1028|0}}while(0);if((al|0)==1667){al=0;he=hp+1|0;hj=he;g2=hl;hf=hq;while(1){do{if(hf>>>0<(c[bs>>2]|0)>>>0){c[z>>2]=hf+1;hy=a[hf]|0}else{if((c[x>>2]|0)==0){hy=0;break}hc=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hc|0)==0){c[x>>2]=0;hb=(c[bs>>2]|0)-1|0;c[z>>2]=hb;a[hb]=0;hz=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hc;hz=bd}c[z>>2]=hz+1;hy=a[hz]|0}}while(0);a[g2]=hy;hn=hj-1|0;if((hn|0)==0){break}hj=hn;g2=g2+4|0;hf=c[z>>2]|0}hw=he;hx=(hp<<2)+4|0}hl=hl+hx|0;hm=hw+hm|0}}else{if(!hd){break}hm=((hi|0)==3)<<31>>31;hl=0;hf=hk;while(1){a[hf]=hm;g2=hl+1|0;if((g2|0)<(hh|0)){hl=g2;hf=hf+4|0}else{break}}}}while(0);hi=hi+1|0;}while((hi|0)<4)}do{if((k|0)==4|(k|0)==0){hA=hg}else{hi=e_(hg,4,k,f2,fK)|0;if((hi|0)==0){A=0}else{hA=hi;break}i=l;return A|0}}while(0);if((j|0)!=0){c[j>>2]=fm}c[h>>2]=fK;c[f>>2]=f2;A=hA;i=l;return A|0}else{hB=0;hC=eF}while(1){if((hB|0)>=4){hD=1;hE=hC;al=1716;break}do{if(hC>>>0<(c[bs>>2]|0)>>>0){eF=hC+1|0;c[z>>2]=eF;hF=d[hC]|0;hG=eF}else{if((c[x>>2]|0)==0){hF=0;hG=hC;break}eF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eF|0)==0){c[x>>2]=0;hA=(c[bs>>2]|0)-1|0;c[z>>2]=hA;a[hA]=0;hH=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+eF;hH=bd}eF=hH+1|0;c[z>>2]=eF;hF=d[hH]|0;hG=eF}}while(0);if((hF|0)==(d[80+hB|0]|0)){hB=hB+1|0;hC=hG}else{break}}L2172:do{if((al|0)==1716){while(1){al=0;do{if(hE>>>0<(c[bs>>2]|0)>>>0){hG=hE+1|0;c[z>>2]=hG;hI=hG}else{if((c[x>>2]|0)==0){hI=hE;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hC=(c[bs>>2]|0)-1|0;c[z>>2]=hC;a[hC]=0;hJ=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hG;hJ=bd}hG=hJ+1|0;c[z>>2]=hG;hI=hG}}while(0);if((hD|0)>=84){hK=0;hL=hI;break}hD=hD+1|0;hE=hI;al=1716}while(1){if((hK|0)>=4){break}do{if(hL>>>0<(c[bs>>2]|0)>>>0){hG=hL+1|0;c[z>>2]=hG;hM=d[hL]|0;hN=hG}else{if((c[x>>2]|0)==0){hM=0;hN=hL;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hC=(c[bs>>2]|0)-1|0;c[z>>2]=hC;a[hC]=0;hO=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hG;hO=bd}hG=hO+1|0;c[z>>2]=hG;hM=d[hO]|0;hN=hG}}while(0);if((hM|0)==(d[64+hK|0]|0)){hK=hK+1|0;hL=hN}else{break L2172}}hG=c[w>>2]|0;c[z>>2]=hG;hC=c[bs>>2]|0;hB=0;hF=hG;hH=hG>>>0<hC>>>0;hG=hC;while(1){do{if(hH){hC=hF+1|0;c[z>>2]=hC;hP=hC;hQ=hG}else{if((c[x>>2]|0)==0){hP=hF;hQ=hG;break}hC=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hC|0)==0){c[x>>2]=0;eF=(c[bs>>2]|0)-1|0;c[z>>2]=eF;a[eF]=0;hR=c[z>>2]|0;hS=c[bs>>2]|0}else{c[z>>2]=bd;eF=e+40+hC|0;c[bs>>2]=eF;hR=bd;hS=eF}eF=hR+1|0;c[z>>2]=eF;hP=eF;hQ=hS}}while(0);eF=hB+1|0;hT=hP>>>0<hQ>>>0;if((eF|0)<92){hB=eF;hF=hP;hH=hT;hG=hQ}else{break}}do{if(hT){hG=hP+1|0;c[z>>2]=hG;hU=d[hP]|0;hV=hG;hW=hQ}else{if((c[x>>2]|0)==0){hU=0;hV=hP;hW=hQ;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hH=(c[bs>>2]|0)-1|0;c[z>>2]=hH;a[hH]=0;hX=c[z>>2]|0;hY=c[bs>>2]|0}else{c[z>>2]=bd;hH=e+40+hG|0;c[bs>>2]=hH;hX=bd;hY=hH}hH=hX+1|0;c[z>>2]=hH;hU=d[hX]|0;hV=hH;hW=hY}}while(0);hH=hU<<8;do{if(hV>>>0<hW>>>0){hG=hV+1|0;c[z>>2]=hG;hZ=d[hV]|0;h_=hG;h$=hW}else{if((c[x>>2]|0)==0){hZ=0;h_=hV;h$=hW;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hF=(c[bs>>2]|0)-1|0;c[z>>2]=hF;a[hF]=0;h0=c[z>>2]|0;h1=c[bs>>2]|0}else{c[z>>2]=bd;hF=e+40+hG|0;c[bs>>2]=hF;h0=bd;h1=hF}hF=h0+1|0;c[z>>2]=hF;hZ=d[h0]|0;h_=hF;h$=h1}}while(0);hF=hZ|hH;do{if(h_>>>0<h$>>>0){hG=h_+1|0;c[z>>2]=hG;h2=d[h_]|0;h3=hG;h4=h$}else{if((c[x>>2]|0)==0){h2=0;h3=h_;h4=h$;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hB=(c[bs>>2]|0)-1|0;c[z>>2]=hB;a[hB]=0;h5=c[z>>2]|0;h6=c[bs>>2]|0}else{c[z>>2]=bd;hB=e+40+hG|0;c[bs>>2]=hB;h5=bd;h6=hB}hB=h5+1|0;c[z>>2]=hB;h2=d[h5]|0;h3=hB;h4=h6}}while(0);hH=h2<<8;do{if(h3>>>0<h4>>>0){hB=h3+1|0;c[z>>2]=hB;h7=d[h3]|0;h8=hB}else{if((c[x>>2]|0)==0){h7=0;h8=h3;break}hB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hB|0)==0){c[x>>2]=0;hG=(c[bs>>2]|0)-1|0;c[z>>2]=hG;a[hG]=0;h9=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hB;h9=bd}hB=h9+1|0;c[z>>2]=hB;h7=d[h9]|0;h8=hB}}while(0);hB=h7|hH;do{if((c[v>>2]|0)==0){ia=h8;al=1775}else{if((cf[c[e+24>>2]&15](c[br>>2]|0)|0)==0){break}if((c[x>>2]|0)==0){al=1776;break}ia=c[z>>2]|0;al=1775}}while(0);if((al|0)==1775){if(ia>>>0>=(c[bs>>2]|0)>>>0){al=1776}}if((al|0)==1776){c[2832]=136;A=0;i=l;return A|0}if((268435456/(hF>>>0)|0)>>>0<hB>>>0){c[2832]=2088;A=0;i=l;return A|0}hH=c[z>>2]|0;hG=c[bs>>2]|0;do{if(hH>>>0<hG>>>0){eF=hH+1|0;c[z>>2]=eF;ib=eF;ic=hG}else{if((c[x>>2]|0)==0){ib=hH;ic=hG;break}eF=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((eF|0)==0){c[x>>2]=0;hC=(c[bs>>2]|0)-1|0;c[z>>2]=hC;a[hC]=0;id=c[z>>2]|0;ie=c[bs>>2]|0}else{c[z>>2]=bd;hC=e+40+eF|0;c[bs>>2]=hC;id=bd;ie=hC}hC=id+1|0;c[z>>2]=hC;ib=hC;ic=ie}}while(0);do{if(ib>>>0<ic>>>0){hG=ib+1|0;c[z>>2]=hG;ig=hG;ih=ic}else{if((c[x>>2]|0)==0){ig=ib;ih=ic;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hH=(c[bs>>2]|0)-1|0;c[z>>2]=hH;a[hH]=0;ii=c[z>>2]|0;ij=c[bs>>2]|0}else{c[z>>2]=bd;hH=e+40+hG|0;c[bs>>2]=hH;ii=bd;ij=hH}hH=ii+1|0;c[z>>2]=hH;ig=hH;ih=ij}}while(0);do{if(ig>>>0<ih>>>0){hH=ig+1|0;c[z>>2]=hH;ik=hH;il=ih}else{if((c[x>>2]|0)==0){ik=ig;il=ih;break}hH=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hH|0)==0){c[x>>2]=0;hG=(c[bs>>2]|0)-1|0;c[z>>2]=hG;a[hG]=0;im=c[z>>2]|0;io=c[bs>>2]|0}else{c[z>>2]=bd;hG=e+40+hH|0;c[bs>>2]=hG;im=bd;io=hG}hG=im+1|0;c[z>>2]=hG;ik=hG;il=io}}while(0);do{if(ik>>>0<il>>>0){hG=ik+1|0;c[z>>2]=hG;ip=hG;iq=il}else{if((c[x>>2]|0)==0){ip=ik;iq=il;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hH=(c[bs>>2]|0)-1|0;c[z>>2]=hH;a[hH]=0;ir=c[z>>2]|0;is=c[bs>>2]|0}else{c[z>>2]=bd;hH=e+40+hG|0;c[bs>>2]=hH;ir=bd;is=hH}hH=ir+1|0;c[z>>2]=hH;ip=hH;iq=is}}while(0);do{if(ip>>>0<iq>>>0){hH=ip+1|0;c[z>>2]=hH;it=hH;iu=iq}else{if((c[x>>2]|0)==0){it=ip;iu=iq;break}hH=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hH|0)==0){c[x>>2]=0;hG=(c[bs>>2]|0)-1|0;c[z>>2]=hG;a[hG]=0;iv=c[z>>2]|0;iw=c[bs>>2]|0}else{c[z>>2]=bd;hG=e+40+hH|0;c[bs>>2]=hG;iv=bd;iw=hG}hG=iv+1|0;c[z>>2]=hG;it=hG;iu=iw}}while(0);do{if(it>>>0<iu>>>0){hG=it+1|0;c[z>>2]=hG;ix=hG;iy=iu}else{if((c[x>>2]|0)==0){ix=it;iy=iu;break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hH=(c[bs>>2]|0)-1|0;c[z>>2]=hH;a[hH]=0;iz=c[z>>2]|0;iA=c[bs>>2]|0}else{c[z>>2]=bd;hH=e+40+hG|0;c[bs>>2]=hH;iz=bd;iA=hH}hH=iz+1|0;c[z>>2]=hH;ix=hH;iy=iA}}while(0);do{if(ix>>>0<iy>>>0){hH=ix+1|0;c[z>>2]=hH;iB=hH;iC=iy}else{if((c[x>>2]|0)==0){iB=ix;iC=iy;break}hH=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hH|0)==0){c[x>>2]=0;hG=(c[bs>>2]|0)-1|0;c[z>>2]=hG;a[hG]=0;iD=c[z>>2]|0;iE=c[bs>>2]|0}else{c[z>>2]=bd;hG=e+40+hH|0;c[bs>>2]=hG;iD=bd;iE=hG}hG=iD+1|0;c[z>>2]=hG;iB=hG;iC=iE}}while(0);do{if(iB>>>0<iC>>>0){c[z>>2]=iB+1}else{if((c[x>>2]|0)==0){break}hG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hG|0)==0){c[x>>2]=0;hH=(c[bs>>2]|0)-1|0;c[z>>2]=hH;a[hH]=0;iF=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hG;iF=bd}c[z>>2]=iF+1}}while(0);hG=hF<<2;hH=$(hB,hG)|0;hC=fs(hH)|0;fF(hC|0,-1|0,hH|0);hH=n|0;eF=o|0;hA=e+24|0;f2=0;fK=0;L2332:while(1){if((fK|0)==10){al=1837;break}iG=fK+1|0;fm=c[z>>2]|0;hg=c[bs>>2]|0;do{if(fm>>>0<hg>>>0){hi=fm+1|0;c[z>>2]=hi;iH=d[fm]|0;iI=hi;iJ=hg}else{if((c[x>>2]|0)==0){iH=0;iI=fm;iJ=hg;break}hi=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hi|0)==0){c[x>>2]=0;hh=(c[bs>>2]|0)-1|0;c[z>>2]=hh;a[hh]=0;iK=c[z>>2]|0;iL=c[bs>>2]|0}else{c[z>>2]=bd;hh=e+40+hi|0;c[bs>>2]=hh;iK=bd;iL=hh}hh=iK+1|0;c[z>>2]=hh;iH=d[iK]|0;iI=hh;iJ=iL}}while(0);do{if(iI>>>0<iJ>>>0){hg=iI+1|0;c[z>>2]=hg;iM=a[iI]|0;iN=hg;iO=iJ}else{if((c[x>>2]|0)==0){iM=0;iN=iI;iO=iJ;break}hg=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hg|0)==0){c[x>>2]=0;fm=(c[bs>>2]|0)-1|0;c[z>>2]=fm;a[fm]=0;iP=c[z>>2]|0;iQ=c[bs>>2]|0}else{c[z>>2]=bd;fm=e+40+hg|0;c[bs>>2]=fm;iP=bd;iQ=fm}fm=iP+1|0;c[z>>2]=fm;iM=a[iP]|0;iN=fm;iO=iQ}}while(0);a[m+(fK*3|0)|0]=iM;do{if(iN>>>0<iO>>>0){fm=iN+1|0;c[z>>2]=fm;iR=a[iN]|0;iS=fm;iT=iO}else{if((c[x>>2]|0)==0){iR=0;iS=iN;iT=iO;break}fm=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((fm|0)==0){c[x>>2]=0;hg=(c[bs>>2]|0)-1|0;c[z>>2]=hg;a[hg]=0;iU=c[z>>2]|0;iV=c[bs>>2]|0}else{c[z>>2]=bd;hg=e+40+fm|0;c[bs>>2]=hg;iU=bd;iV=hg}hg=iU+1|0;c[z>>2]=hg;iR=a[iU]|0;iS=hg;iT=iV}}while(0);a[m+(fK*3|0)+1|0]=iR;do{if(iS>>>0<iT>>>0){hg=iS+1|0;c[z>>2]=hg;iW=a[iS]|0;iX=hg}else{if((c[x>>2]|0)==0){iW=0;iX=iS;break}hg=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hg|0)==0){c[x>>2]=0;fm=(c[bs>>2]|0)-1|0;c[z>>2]=fm;a[fm]=0;iY=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hg;iY=bd}hg=iY+1|0;c[z>>2]=hg;iW=a[iY]|0;iX=hg}}while(0);a[m+(fK*3|0)+2|0]=iW;iZ=iW&255|f2;do{if((c[v>>2]|0)==0){i_=iX;al=1870}else{if((cf[c[hA>>2]&15](c[br>>2]|0)|0)==0){break}if((c[x>>2]|0)==0){al=1871;break L2332}i_=c[z>>2]|0;al=1870}}while(0);if((al|0)==1870){al=0;if(i_>>>0>=(c[bs>>2]|0)>>>0){al=1871;break}}if(iM<<24>>24!=8){al=1873;break}if((iH|0)==0){al=1875;break}else{f2=iZ;fK=iG}}L2379:do{if((al|0)==1837){c[2832]=88;i$=0}else if((al|0)==1871){c[2832]=136;i$=0}else if((al|0)==1873){c[2832]=88;i$=0}else if((al|0)==1875){c[j>>2]=(iZ>>>4&1)+3;if((hB|0)==0){i$=hC;break}fK=(iG|0)>0;f2=(hF|0)!=0;hg=o+3|0;fm=o+2|0;hh=o+1|0;hi=n+3|0;hd=n+2|0;hw=n+1|0;hx=0;L2385:while(1){if(fK){hp=hC+($(hx,hG)|0)|0;hy=0;do{hz=d[m+(hy*3|0)+1|0]|0;do{if((hz|0)==0){if(!f2){break}hq=d[m+(hy*3|0)+2|0]|0;ht=hp;hu=0;while(1){if((e$(e,hq,ht)|0)==0){i$=0;break L2379}hv=hu+1|0;if((hv|0)<(hF|0)){ht=ht+4|0;hu=hv}else{break}}}else if((hz|0)==1){if(!f2){break}hu=m+(hy*3|0)+2|0;ht=hp;hq=hF;while(1){cy=c[z>>2]|0;do{if(cy>>>0<(c[bs>>2]|0)>>>0){hv=cy+1|0;c[z>>2]=hv;i0=a[cy]|0;i1=hv}else{if((c[x>>2]|0)==0){i0=0;i1=cy;break}hv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hv|0)==0){c[x>>2]=0;hr=(c[bs>>2]|0)-1|0;c[z>>2]=hr;a[hr]=0;i2=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hv;i2=bd}hv=i2+1|0;c[z>>2]=hv;i0=a[i2]|0;i1=hv}}while(0);do{if((c[v>>2]|0)==0){i3=i1;al=1900}else{if((cf[c[hA>>2]&15](c[br>>2]|0)|0)==0){break}if((c[x>>2]|0)==0){al=1901;break L2385}i3=c[z>>2]|0;al=1900}}while(0);if((al|0)==1900){al=0;if(i3>>>0>=(c[bs>>2]|0)>>>0){al=1901;break L2385}}cy=a[hu]|0;if((e$(e,cy&255,hH)|0)==0){i$=0;break L2379}hv=(i0&255|0)>(hq|0)?hq&255:i0;hr=hv&255;if(hv<<24>>24==0){i4=ht}else{ho=ht;hs=1;hk=cy;while(1){cy=hk&255;if((cy&128|0)!=0){a[ho]=a[hH]|0}if((cy&64|0)!=0){a[ho+1|0]=a[hw]|0}if((cy&32|0)!=0){a[ho+2|0]=a[hd]|0}if((cy&16|0)!=0){a[ho+3|0]=a[hi]|0}if((hs|0)>=(hr|0)){break}ho=ho+4|0;hs=hs+1|0;hk=a[hu]|0}i4=ht+((hv&255)>>>0>1>>>0?hr<<2:4)|0}hk=hq-hr|0;if((hk|0)>0){ht=i4;hq=hk}else{break}}}else if((hz|0)==2){if(!f2){break}hq=m+(hy*3|0)+2|0;ht=hp;hu=hF;while(1){hk=c[z>>2]|0;do{if(hk>>>0<(c[bs>>2]|0)>>>0){hs=hk+1|0;c[z>>2]=hs;i5=d[hk]|0;i6=hs}else{if((c[x>>2]|0)==0){i5=0;i6=hk;break}hs=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hs|0)==0){c[x>>2]=0;ho=(c[bs>>2]|0)-1|0;c[z>>2]=ho;a[ho]=0;i7=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hs;i7=bd}hs=i7+1|0;c[z>>2]=hs;i5=d[i7]|0;i6=hs}}while(0);do{if((c[v>>2]|0)==0){i8=i6;al=1927}else{if((cf[c[hA>>2]&15](c[br>>2]|0)|0)==0){break}if((c[x>>2]|0)==0){al=1928;break L2385}i8=c[z>>2]|0;al=1927}}while(0);if((al|0)==1927){al=0;if(i8>>>0>=(c[bs>>2]|0)>>>0){al=1928;break L2385}}do{if(i5>>>0>127>>>0){if((i5|0)==128){hk=c[z>>2]|0;hr=c[bs>>2]|0;do{if(hk>>>0<hr>>>0){hv=hk+1|0;c[z>>2]=hv;i9=d[hk]|0;ja=hv;jb=hr}else{if((c[x>>2]|0)==0){i9=0;ja=hk;jb=hr;break}hv=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hv|0)==0){c[x>>2]=0;hs=(c[bs>>2]|0)-1|0;c[z>>2]=hs;a[hs]=0;jc=c[z>>2]|0;jd=c[bs>>2]|0}else{c[z>>2]=bd;hs=e+40+hv|0;c[bs>>2]=hs;jc=bd;jd=hs}hs=jc+1|0;c[z>>2]=hs;i9=d[jc]|0;ja=hs;jb=jd}}while(0);hr=i9<<8;do{if(ja>>>0<jb>>>0){c[z>>2]=ja+1;je=d[ja]|0}else{if((c[x>>2]|0)==0){je=0;break}hk=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hk|0)==0){c[x>>2]=0;b1=(c[bs>>2]|0)-1|0;c[z>>2]=b1;a[b1]=0;jf=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+hk;jf=bd}c[z>>2]=jf+1;je=d[jf]|0}}while(0);jg=je|hr}else{jg=i5-127|0}if((jg|0)>(hu|0)){al=1948;break L2385}hk=a[hq]|0;if((e$(e,hk&255,eF)|0)==0){i$=0;break L2379}if((jg|0)>0){jh=ht;ji=1;jj=hk}else{jk=jg;jl=ht;break}while(1){hk=jj&255;if((hk&128|0)!=0){a[jh]=a[eF]|0}if((hk&64|0)!=0){a[jh+1|0]=a[hh]|0}if((hk&32|0)!=0){a[jh+2|0]=a[fm]|0}if((hk&16|0)!=0){a[jh+3|0]=a[hg]|0}if((ji|0)>=(jg|0)){break}jh=jh+4|0;ji=ji+1|0;jj=a[hq]|0}jk=jg;jl=ht+(jg<<2)|0}else{hr=i5+1|0;if((hr|0)>(hu|0)){al=1963;break L2385}hk=d[hq]|0;b1=ht;hs=0;while(1){if((e$(e,hk,b1)|0)==0){i$=0;break L2379}hv=hs+1|0;ho=b1+4|0;if((hv|0)<(hr|0)){b1=ho;hs=hv}else{jk=hr;jl=ho;break}}}}while(0);hr=hu-jk|0;if((hr|0)>0){ht=jl;hu=hr}else{break}}}else{al=1886;break L2385}}while(0);hy=hy+1|0;}while((hy|0)<(iG|0))}hy=hx+1|0;if((hy|0)<(hB|0)){hx=hy}else{i$=hC;break L2379}}if((al|0)==1886){c[2832]=88;i$=0;break}else if((al|0)==1901){c[2832]=136;i$=0;break}else if((al|0)==1928){c[2832]=136;i$=0;break}else if((al|0)==1948){c[2832]=136;i$=0;break}else if((al|0)==1963){c[2832]=136;i$=0;break}}}while(0);if((i$|0)==0){ft(hC);jm=0}else{jm=hC}c[f>>2]=hF;c[h>>2]=hB;if((k|0)==0){jn=c[j>>2]|0}else{jn=k}A=e_(jm,4,jn,hF,hB)|0;i=l;return A|0}}while(0);jn=c[w>>2]|0;c[z>>2]=jn;jm=0;i$=jn;while(1){if((jm|0)==11){al=1985;break}jn=576+jm|0;do{if(i$>>>0<(c[bs>>2]|0)>>>0){iG=i$+1|0;c[z>>2]=iG;jo=d[i$]|0;jp=iG}else{if((c[x>>2]|0)==0){jo=0;jp=i$;break}iG=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((iG|0)==0){c[x>>2]=0;jl=(c[bs>>2]|0)-1|0;c[z>>2]=jl;a[jl]=0;jq=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+iG;jq=bd}iG=jq+1|0;c[z>>2]=iG;jo=d[jq]|0;jp=iG}}while(0);if((jo|0)==(a[jn]|0)){jm=jm+1|0;i$=jp}else{break}}if((al|0)==1985){c[z>>2]=c[w>>2];jp=ev(e,f,h,j,k)|0;if((k|0)==0){jr=c[j>>2]|0}else{jr=k}i$=$(c[h>>2]|0,c[f>>2]|0)|0;jm=fs($(jr,i$)|0)|0;if((jm|0)==0){ft(jp);c[2832]=1560;A=0;i=l;return A|0}jo=jr-1+(jr&1)|0;if((i$|0)>0){jq=(jo|0)>0;js=+g[1628];jt=+g[1630];hB=0;do{if(jq){hF=$(hB,jr)|0;hC=0;while(1){iG=hC+hF|0;ju=+Q(+(js*+g[jp+(iG<<2)>>2]),+jt)*255.0+.5;jv=ju<0.0?0.0:ju;a[jm+iG|0]=jv>255.0?-1:~~jv&255;iG=hC+1|0;if((iG|0)<(jo|0)){hC=iG}else{jw=jo;break}}}else{jw=0}if((jw|0)<(jr|0)){hC=jw+($(hB,jr)|0)|0;jv=+g[jp+(hC<<2)>>2]*255.0+.5;ju=jv<0.0?0.0:jv;a[jm+hC|0]=ju>255.0?-1:~~ju&255}hB=hB+1|0;}while((hB|0)<(i$|0))}ft(jp);A=jm;i=l;return A|0}jm=c[w>>2]|0;c[z>>2]=jm;jp=c[bs>>2]|0;do{if(jm>>>0<jp>>>0){i$=jm+1|0;c[z>>2]=i$;jx=i$;jy=jp}else{if((c[x>>2]|0)==0){jx=jm;jy=jp;break}i$=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((i$|0)==0){c[x>>2]=0;hB=(c[bs>>2]|0)-1|0;c[z>>2]=hB;a[hB]=0;jz=c[z>>2]|0;jA=c[bs>>2]|0}else{c[z>>2]=bd;hB=e+40+i$|0;c[bs>>2]=hB;jz=bd;jA=hB}hB=jz+1|0;c[z>>2]=hB;jx=hB;jy=jA}}while(0);do{if(jx>>>0<jy>>>0){jB=jx;al=2010}else{if((c[x>>2]|0)==0){jC=jx;jD=jy;al=2012;break}jA=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jA|0)==0){c[x>>2]=0;jz=(c[bs>>2]|0)-1|0;c[z>>2]=jz;a[jz]=0;jB=c[z>>2]|0;al=2010;break}else{c[z>>2]=bd;c[bs>>2]=e+40+jA;jB=bd;al=2010;break}}}while(0);do{if((al|0)==2010){jy=jB+1|0;c[z>>2]=jy;if((d[jB]|0)>>>0>1>>>0){break}jC=jy;jD=c[bs>>2]|0;al=2012}}while(0);L2575:do{if((al|0)==2012){do{if(jC>>>0<jD>>>0){jB=jC+1|0;c[z>>2]=jB;jE=a[jC]|0;jF=jB}else{if((c[x>>2]|0)==0){jE=0;jF=jC;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jy=(c[bs>>2]|0)-1|0;c[z>>2]=jy;a[jy]=0;jG=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+jB;jG=bd}jB=jG+1|0;c[z>>2]=jB;jE=a[jG]|0;jF=jB}}while(0);if((jE-1&255)>>>0>1>>>0&jE<<24>>24!=3&jE<<24>>24!=9&jE<<24>>24!=10&jE<<24>>24!=11){break}jB=c[bs>>2]|0;do{if(jF>>>0<jB>>>0){jy=jF+1|0;c[z>>2]=jy;jH=jy;jI=jB}else{if((c[x>>2]|0)==0){jH=jF;jI=jB;break}jy=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jy|0)==0){c[x>>2]=0;jx=(c[bs>>2]|0)-1|0;c[z>>2]=jx;a[jx]=0;jJ=c[z>>2]|0;jK=c[bs>>2]|0}else{c[z>>2]=bd;jx=e+40+jy|0;c[bs>>2]=jx;jJ=bd;jK=jx}jx=jJ+1|0;c[z>>2]=jx;jH=jx;jI=jK}}while(0);do{if(jH>>>0<jI>>>0){jB=jH+1|0;c[z>>2]=jB;jL=jB;jM=jI}else{if((c[x>>2]|0)==0){jL=jH;jM=jI;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jx=(c[bs>>2]|0)-1|0;c[z>>2]=jx;a[jx]=0;jN=c[z>>2]|0;jO=c[bs>>2]|0}else{c[z>>2]=bd;jx=e+40+jB|0;c[bs>>2]=jx;jN=bd;jO=jx}jx=jN+1|0;c[z>>2]=jx;jL=jx;jM=jO}}while(0);do{if(jL>>>0<jM>>>0){jx=jL+1|0;c[z>>2]=jx;jP=jx;jQ=jM}else{if((c[x>>2]|0)==0){jP=jL;jQ=jM;break}jx=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jx|0)==0){c[x>>2]=0;jB=(c[bs>>2]|0)-1|0;c[z>>2]=jB;a[jB]=0;jR=c[z>>2]|0;jS=c[bs>>2]|0}else{c[z>>2]=bd;jB=e+40+jx|0;c[bs>>2]=jB;jR=bd;jS=jB}jB=jR+1|0;c[z>>2]=jB;jP=jB;jQ=jS}}while(0);do{if(jP>>>0<jQ>>>0){jB=jP+1|0;c[z>>2]=jB;jT=jB;jU=jQ}else{if((c[x>>2]|0)==0){jT=jP;jU=jQ;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jx=(c[bs>>2]|0)-1|0;c[z>>2]=jx;a[jx]=0;jV=c[z>>2]|0;jW=c[bs>>2]|0}else{c[z>>2]=bd;jx=e+40+jB|0;c[bs>>2]=jx;jV=bd;jW=jx}jx=jV+1|0;c[z>>2]=jx;jT=jx;jU=jW}}while(0);do{if(jT>>>0<jU>>>0){jx=jT+1|0;c[z>>2]=jx;jX=jx;jY=jU}else{if((c[x>>2]|0)==0){jX=jT;jY=jU;break}jx=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jx|0)==0){c[x>>2]=0;jB=(c[bs>>2]|0)-1|0;c[z>>2]=jB;a[jB]=0;jZ=c[z>>2]|0;j_=c[bs>>2]|0}else{c[z>>2]=bd;jB=e+40+jx|0;c[bs>>2]=jB;jZ=bd;j_=jB}jB=jZ+1|0;c[z>>2]=jB;jX=jB;jY=j_}}while(0);do{if(jX>>>0<jY>>>0){jB=jX+1|0;c[z>>2]=jB;j$=jB;j0=jY}else{if((c[x>>2]|0)==0){j$=jX;j0=jY;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jx=(c[bs>>2]|0)-1|0;c[z>>2]=jx;a[jx]=0;j1=c[z>>2]|0;j2=c[bs>>2]|0}else{c[z>>2]=bd;jx=e+40+jB|0;c[bs>>2]=jx;j1=bd;j2=jx}jx=j1+1|0;c[z>>2]=jx;j$=jx;j0=j2}}while(0);do{if(j$>>>0<j0>>>0){jx=j$+1|0;c[z>>2]=jx;j3=jx;j4=j0}else{if((c[x>>2]|0)==0){j3=j$;j4=j0;break}jx=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jx|0)==0){c[x>>2]=0;jB=(c[bs>>2]|0)-1|0;c[z>>2]=jB;a[jB]=0;j5=c[z>>2]|0;j6=c[bs>>2]|0}else{c[z>>2]=bd;jB=e+40+jx|0;c[bs>>2]=jB;j5=bd;j6=jB}jB=j5+1|0;c[z>>2]=jB;j3=jB;j4=j6}}while(0);do{if(j3>>>0<j4>>>0){jB=j3+1|0;c[z>>2]=jB;j7=jB;j8=j4}else{if((c[x>>2]|0)==0){j7=j3;j8=j4;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jx=(c[bs>>2]|0)-1|0;c[z>>2]=jx;a[jx]=0;j9=c[z>>2]|0;ka=c[bs>>2]|0}else{c[z>>2]=bd;jx=e+40+jB|0;c[bs>>2]=jx;j9=bd;ka=jx}jx=j9+1|0;c[z>>2]=jx;j7=jx;j8=ka}}while(0);do{if(j7>>>0<j8>>>0){jx=j7+1|0;c[z>>2]=jx;kb=jx;kc=j8}else{if((c[x>>2]|0)==0){kb=j7;kc=j8;break}jx=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jx|0)==0){c[x>>2]=0;jB=(c[bs>>2]|0)-1|0;c[z>>2]=jB;a[jB]=0;kd=c[z>>2]|0;ke=c[bs>>2]|0}else{c[z>>2]=bd;jB=e+40+jx|0;c[bs>>2]=jB;kd=bd;ke=jB}jB=kd+1|0;c[z>>2]=jB;kb=jB;kc=ke}}while(0);do{if(kb>>>0<kc>>>0){jB=kb+1|0;c[z>>2]=jB;kf=d[kb]|0;kg=jB;kh=kc}else{if((c[x>>2]|0)==0){kf=0;kg=kb;kh=kc;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jx=(c[bs>>2]|0)-1|0;c[z>>2]=jx;a[jx]=0;ki=c[z>>2]|0;kj=c[bs>>2]|0}else{c[z>>2]=bd;jx=e+40+jB|0;c[bs>>2]=jx;ki=bd;kj=jx}jx=ki+1|0;c[z>>2]=jx;kf=d[ki]|0;kg=jx;kh=kj}}while(0);jx=kf<<8;do{if(kg>>>0<kh>>>0){jB=kg+1|0;c[z>>2]=jB;kk=d[kg]|0;kl=jB}else{if((c[x>>2]|0)==0){kk=0;kl=kg;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jy=(c[bs>>2]|0)-1|0;c[z>>2]=jy;a[jy]=0;km=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+jB;km=bd}jB=km+1|0;c[z>>2]=jB;kk=d[km]|0;kl=jB}}while(0);if((kk|jx|0)==0){break}jB=c[bs>>2]|0;do{if(kl>>>0<jB>>>0){jy=kl+1|0;c[z>>2]=jy;kn=d[kl]|0;ko=jy;kp=jB}else{if((c[x>>2]|0)==0){kn=0;ko=kl;kp=jB;break}jy=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jy|0)==0){c[x>>2]=0;jA=(c[bs>>2]|0)-1|0;c[z>>2]=jA;a[jA]=0;kq=c[z>>2]|0;kr=c[bs>>2]|0}else{c[z>>2]=bd;jA=e+40+jy|0;c[bs>>2]=jA;kq=bd;kr=jA}jA=kq+1|0;c[z>>2]=jA;kn=d[kq]|0;ko=jA;kp=kr}}while(0);jB=kn<<8;do{if(ko>>>0<kp>>>0){jx=ko+1|0;c[z>>2]=jx;ks=d[ko]|0;kt=jx}else{if((c[x>>2]|0)==0){ks=0;kt=ko;break}jx=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jx|0)==0){c[x>>2]=0;jA=(c[bs>>2]|0)-1|0;c[z>>2]=jA;a[jA]=0;ku=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+jx;ku=bd}jx=ku+1|0;c[z>>2]=jx;ks=d[ku]|0;kt=jx}}while(0);if((ks|jB|0)==0){break}do{if(kt>>>0<(c[bs>>2]|0)>>>0){kv=kt}else{if((c[x>>2]|0)==0){break L2575}jx=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jx|0)==0){c[x>>2]=0;jA=(c[bs>>2]|0)-1|0;c[z>>2]=jA;a[jA]=0;kv=c[z>>2]|0;break}else{c[z>>2]=bd;c[bs>>2]=e+40+jx;kv=bd;break}}}while(0);c[z>>2]=kv+1;jB=d[kv]|0;if(!((jB|0)==32|(jB|0)==24|(jB|0)==16|(jB|0)==8)){break}jB=c[w>>2]|0;c[z>>2]=jB;jx=n|0;jA=c[bs>>2]|0;do{if(jB>>>0<jA>>>0){jy=jB+1|0;c[z>>2]=jy;kw=a[jB]|0;kx=jy;ky=jA}else{if((c[x>>2]|0)==0){kw=0;kx=jB;ky=jA;break}jy=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jy|0)==0){c[x>>2]=0;jz=(c[bs>>2]|0)-1|0;c[z>>2]=jz;a[jz]=0;kz=c[z>>2]|0;kA=c[bs>>2]|0}else{c[z>>2]=bd;jz=e+40+jy|0;c[bs>>2]=jz;kz=bd;kA=jz}jz=kz+1|0;c[z>>2]=jz;kw=a[kz]|0;kx=jz;ky=kA}}while(0);jA=kw&255;do{if(kx>>>0<ky>>>0){jB=kx+1|0;c[z>>2]=jB;kB=a[kx]|0;kC=jB;kD=ky}else{if((c[x>>2]|0)==0){kB=0;kC=kx;kD=ky;break}jB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jB|0)==0){c[x>>2]=0;jz=(c[bs>>2]|0)-1|0;c[z>>2]=jz;a[jz]=0;kE=c[z>>2]|0;kF=c[bs>>2]|0}else{c[z>>2]=bd;jz=e+40+jB|0;c[bs>>2]=jz;kE=bd;kF=jz}jz=kE+1|0;c[z>>2]=jz;kB=a[kE]|0;kC=jz;kD=kF}}while(0);do{if(kC>>>0<kD>>>0){jz=kC+1|0;c[z>>2]=jz;kG=a[kC]|0;kH=jz;kI=kD}else{if((c[x>>2]|0)==0){kG=0;kH=kC;kI=kD;break}jz=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jz|0)==0){c[x>>2]=0;jB=(c[bs>>2]|0)-1|0;c[z>>2]=jB;a[jB]=0;kJ=c[z>>2]|0;kK=c[bs>>2]|0}else{c[z>>2]=bd;jB=e+40+jz|0;c[bs>>2]=jB;kJ=bd;kK=jB}jB=kJ+1|0;c[z>>2]=jB;kG=a[kJ]|0;kH=jB;kI=kK}}while(0);jB=kG&255;do{if(kH>>>0<kI>>>0){jz=kH+1|0;c[z>>2]=jz;kL=d[kH]|0;kM=jz;kN=kI}else{if((c[x>>2]|0)==0){kL=0;kM=kH;kN=kI;break}jz=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jz|0)==0){c[x>>2]=0;jy=(c[bs>>2]|0)-1|0;c[z>>2]=jy;a[jy]=0;kO=c[z>>2]|0;kP=c[bs>>2]|0}else{c[z>>2]=bd;jy=e+40+jz|0;c[bs>>2]=jy;kO=bd;kP=jy}jy=kO+1|0;c[z>>2]=jy;kL=d[kO]|0;kM=jy;kN=kP}}while(0);do{if(kM>>>0<kN>>>0){jy=kM+1|0;c[z>>2]=jy;kQ=d[kM]|0;kR=jy;kS=kN}else{if((c[x>>2]|0)==0){kQ=0;kR=kM;kS=kN;break}jy=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jy|0)==0){c[x>>2]=0;jz=(c[bs>>2]|0)-1|0;c[z>>2]=jz;a[jz]=0;kT=c[z>>2]|0;kU=c[bs>>2]|0}else{c[z>>2]=bd;jz=e+40+jy|0;c[bs>>2]=jz;kT=bd;kU=jz}jz=kT+1|0;c[z>>2]=jz;kQ=d[kT]|0;kR=jz;kS=kU}}while(0);jz=kQ<<8|kL;do{if(kR>>>0<kS>>>0){jy=kR+1|0;c[z>>2]=jy;kV=d[kR]|0;kW=jy;kX=kS}else{if((c[x>>2]|0)==0){kV=0;kW=kR;kX=kS;break}jy=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jy|0)==0){c[x>>2]=0;jp=(c[bs>>2]|0)-1|0;c[z>>2]=jp;a[jp]=0;kY=c[z>>2]|0;kZ=c[bs>>2]|0}else{c[z>>2]=bd;jp=e+40+jy|0;c[bs>>2]=jp;kY=bd;kZ=jp}jp=kY+1|0;c[z>>2]=jp;kV=d[kY]|0;kW=jp;kX=kZ}}while(0);do{if(kW>>>0<kX>>>0){jp=kW+1|0;c[z>>2]=jp;k_=d[kW]|0;k$=jp;k0=kX}else{if((c[x>>2]|0)==0){k_=0;k$=kW;k0=kX;break}jp=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jp|0)==0){c[x>>2]=0;jy=(c[bs>>2]|0)-1|0;c[z>>2]=jy;a[jy]=0;k1=c[z>>2]|0;k2=c[bs>>2]|0}else{c[z>>2]=bd;jy=e+40+jp|0;c[bs>>2]=jy;k1=bd;k2=jy}jy=k1+1|0;c[z>>2]=jy;k_=d[k1]|0;k$=jy;k0=k2}}while(0);jy=k_<<8|kV;do{if(k$>>>0<k0>>>0){jp=k$+1|0;c[z>>2]=jp;k3=a[k$]|0;k4=jp;k5=k0}else{if((c[x>>2]|0)==0){k3=0;k4=k$;k5=k0;break}jp=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jp|0)==0){c[x>>2]=0;jm=(c[bs>>2]|0)-1|0;c[z>>2]=jm;a[jm]=0;k6=c[z>>2]|0;k7=c[bs>>2]|0}else{c[z>>2]=bd;jm=e+40+jp|0;c[bs>>2]=jm;k6=bd;k7=jm}jm=k6+1|0;c[z>>2]=jm;k3=a[k6]|0;k4=jm;k5=k7}}while(0);jm=k3&255;do{if(k4>>>0<k5>>>0){jp=k4+1|0;c[z>>2]=jp;k8=jp;k9=k5}else{if((c[x>>2]|0)==0){k8=k4;k9=k5;break}jp=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jp|0)==0){c[x>>2]=0;hB=(c[bs>>2]|0)-1|0;c[z>>2]=hB;a[hB]=0;la=c[z>>2]|0;lb=c[bs>>2]|0}else{c[z>>2]=bd;hB=e+40+jp|0;c[bs>>2]=hB;la=bd;lb=hB}hB=la+1|0;c[z>>2]=hB;k8=hB;k9=lb}}while(0);do{if(k8>>>0<k9>>>0){hB=k8+1|0;c[z>>2]=hB;lc=hB;ld=k9}else{if((c[x>>2]|0)==0){lc=k8;ld=k9;break}hB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hB|0)==0){c[x>>2]=0;jp=(c[bs>>2]|0)-1|0;c[z>>2]=jp;a[jp]=0;le=c[z>>2]|0;lf=c[bs>>2]|0}else{c[z>>2]=bd;jp=e+40+hB|0;c[bs>>2]=jp;le=bd;lf=jp}jp=le+1|0;c[z>>2]=jp;lc=jp;ld=lf}}while(0);do{if(lc>>>0<ld>>>0){jp=lc+1|0;c[z>>2]=jp;lg=jp;lh=ld}else{if((c[x>>2]|0)==0){lg=lc;lh=ld;break}jp=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jp|0)==0){c[x>>2]=0;hB=(c[bs>>2]|0)-1|0;c[z>>2]=hB;a[hB]=0;li=c[z>>2]|0;lj=c[bs>>2]|0}else{c[z>>2]=bd;hB=e+40+jp|0;c[bs>>2]=hB;li=bd;lj=hB}hB=li+1|0;c[z>>2]=hB;lg=hB;lh=lj}}while(0);do{if(lg>>>0<lh>>>0){hB=lg+1|0;c[z>>2]=hB;lk=hB;ll=lh}else{if((c[x>>2]|0)==0){lk=lg;ll=lh;break}hB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hB|0)==0){c[x>>2]=0;jp=(c[bs>>2]|0)-1|0;c[z>>2]=jp;a[jp]=0;lm=c[z>>2]|0;ln=c[bs>>2]|0}else{c[z>>2]=bd;jp=e+40+hB|0;c[bs>>2]=jp;lm=bd;ln=jp}jp=lm+1|0;c[z>>2]=jp;lk=jp;ll=ln}}while(0);do{if(lk>>>0<ll>>>0){jp=lk+1|0;c[z>>2]=jp;lo=d[lk]|0;lp=jp;lq=ll}else{if((c[x>>2]|0)==0){lo=0;lp=lk;lq=ll;break}jp=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jp|0)==0){c[x>>2]=0;hB=(c[bs>>2]|0)-1|0;c[z>>2]=hB;a[hB]=0;lr=c[z>>2]|0;ls=c[bs>>2]|0}else{c[z>>2]=bd;hB=e+40+jp|0;c[bs>>2]=hB;lr=bd;ls=hB}hB=lr+1|0;c[z>>2]=hB;lo=d[lr]|0;lp=hB;lq=ls}}while(0);do{if(lp>>>0<lq>>>0){hB=lp+1|0;c[z>>2]=hB;lt=d[lp]|0;lu=hB;lv=lq}else{if((c[x>>2]|0)==0){lt=0;lu=lp;lv=lq;break}hB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hB|0)==0){c[x>>2]=0;jp=(c[bs>>2]|0)-1|0;c[z>>2]=jp;a[jp]=0;lw=c[z>>2]|0;lx=c[bs>>2]|0}else{c[z>>2]=bd;jp=e+40+hB|0;c[bs>>2]=jp;lw=bd;lx=jp}jp=lw+1|0;c[z>>2]=jp;lt=d[lw]|0;lu=jp;lv=lx}}while(0);jp=lt<<8|lo;do{if(lu>>>0<lv>>>0){hB=lu+1|0;c[z>>2]=hB;ly=d[lu]|0;lz=hB;lA=lv}else{if((c[x>>2]|0)==0){ly=0;lz=lu;lA=lv;break}hB=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((hB|0)==0){c[x>>2]=0;i$=(c[bs>>2]|0)-1|0;c[z>>2]=i$;a[i$]=0;lB=c[z>>2]|0;lC=c[bs>>2]|0}else{c[z>>2]=bd;i$=e+40+hB|0;c[bs>>2]=i$;lB=bd;lC=i$}i$=lB+1|0;c[z>>2]=i$;ly=d[lB]|0;lz=i$;lA=lC}}while(0);do{if(lz>>>0<lA>>>0){i$=lz+1|0;c[z>>2]=i$;lD=d[lz]|0;lE=i$;lF=lA}else{if((c[x>>2]|0)==0){lD=0;lE=lz;lF=lA;break}i$=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((i$|0)==0){c[x>>2]=0;hB=(c[bs>>2]|0)-1|0;c[z>>2]=hB;a[hB]=0;lG=c[z>>2]|0;lH=c[bs>>2]|0}else{c[z>>2]=bd;hB=e+40+i$|0;c[bs>>2]=hB;lG=bd;lH=hB}hB=lG+1|0;c[z>>2]=hB;lD=d[lG]|0;lE=hB;lF=lH}}while(0);hB=lD<<8|ly;do{if(lE>>>0<lF>>>0){i$=lE+1|0;c[z>>2]=i$;lI=a[lE]|0;lJ=i$;lK=lF}else{if((c[x>>2]|0)==0){lI=0;lJ=lE;lK=lF;break}i$=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((i$|0)==0){c[x>>2]=0;jr=(c[bs>>2]|0)-1|0;c[z>>2]=jr;a[jr]=0;lL=c[z>>2]|0;lM=c[bs>>2]|0}else{c[z>>2]=bd;jr=e+40+i$|0;c[bs>>2]=jr;lL=bd;lM=jr}jr=lL+1|0;c[z>>2]=jr;lI=a[lL]|0;lJ=jr;lK=lM}}while(0);jr=lI&255;do{if(lJ>>>0<lK>>>0){c[z>>2]=lJ+1;lN=a[lJ]|0}else{if((c[x>>2]|0)==0){lN=0;break}i$=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((i$|0)==0){c[x>>2]=0;jw=(c[bs>>2]|0)-1|0;c[z>>2]=jw;a[jw]=0;lO=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+i$;lO=bd}c[z>>2]=lO+1;lN=a[lO]|0}}while(0);i$=(kG&255)>>>0>7>>>0;if((jp|0)==0|(hB|0)==0){A=0;i=l;return A|0}if(((i$?jB-8|0:jB)-1|0)>>>0>2>>>0){A=0;i=l;return A|0}if(!((lI<<24>>24|0)==32|(lI<<24>>24|0)==24|(lI<<24>>24|0)==16|(lI<<24>>24|0)==8)){A=0;i=l;return A|0}jw=kB<<24>>24!=0;jo=jw?jm:jr;c[f>>2]=jp;c[h>>2]=hB;jq=jo>>>3;hC=(k-1|0)>>>0>3>>>0?jq:k;c[j>>2]=jq;hF=$(hB,jp)|0;jn=fs($(hC,hF)|0)|0;if((jn|0)==0){c[2832]=1560;A=0;i=l;return A|0}do{if((c[v>>2]|0)==0){lP=c[z>>2]|0;al=2254}else{iG=c[bs>>2]|0;jl=c[z>>2]|0;jk=iG-jl|0;if((jk|0)>=(jA|0)){lP=jl;al=2254;break}c[z>>2]=iG;cj[c[e+20>>2]&63](c[br>>2]|0,jA-jk|0)}}while(0);if((al|0)==2254){c[z>>2]=lP+jA}L2896:do{if(jw){do{if((c[v>>2]|0)==0){lQ=c[z>>2]|0;al=2260}else{jr=c[bs>>2]|0;jB=c[z>>2]|0;jk=jr-jB|0;if((jk|0)>=(jz|0)){lQ=jB;al=2260;break}c[z>>2]=jr;cj[c[e+20>>2]&63](c[br>>2]|0,jz-jk|0)}}while(0);if((al|0)==2260){c[z>>2]=lQ+jz}jk=($(jm,jy)|0)>>>3;jr=fs(jk)|0;if((jr|0)==0){c[2832]=1560;A=0;i=l;return A|0}jB=c[v>>2]|0;do{if((jB|0)==0){lR=c[z>>2]|0;lS=c[bs>>2]|0;al=2266}else{iG=c[bs>>2]|0;jl=c[z>>2]|0;i5=iG-jl|0;if((i5|0)>=(jk|0)){lR=jl;lS=iG;al=2266;break}fG(jr|0,jl|0,i5)|0;jl=jk-i5|0;iG=(cl[jB&3](c[br>>2]|0,jr+i5|0,jl)|0)==(jl|0);c[z>>2]=c[bs>>2];if(iG){lT=jr;break L2896}}}while(0);do{if((al|0)==2266){jB=lR+jk|0;if(jB>>>0>lS>>>0){break}fG(jr|0,lR|0,jk)|0;c[z>>2]=jB;lT=jr;break L2896}}while(0);ft(jn);ft(jr);c[2832]=152;A=0;i=l;return A|0}else{lT=0}}while(0);if((hF|0)!=0){jm=(jo|0)==0;jz=n+1|0;jA=n+2|0;jk=n+3|0;jB=0;iG=0;jl=0;i5=0;jg=0;jj=0;ji=0;jh=1;while(1){do{if(i$){if((jj|0)!=0){if((jh|0)==0&(ji|0)!=0){lU=jg;lV=i5;lW=jl;lX=iG;lY=jj;lZ=ji;break}else{l_=jj;l$=ji;al=2283;break}}je=c[z>>2]|0;do{if(je>>>0<(c[bs>>2]|0)>>>0){c[z>>2]=je+1;l0=a[je]|0}else{if((c[x>>2]|0)==0){l0=0;break}jf=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jf|0)==0){c[x>>2]=0;ja=(c[bs>>2]|0)-1|0;c[z>>2]=ja;a[ja]=0;l1=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+jf;l1=bd}c[z>>2]=l1+1;l0=a[l1]|0}}while(0);je=l0&255;l_=(je&127)+1|0;l$=je>>>7;al=2283}else{l_=jj;l$=ji;al=2283}}while(0);do{if((al|0)==2283){al=0;if(jw){jr=c[z>>2]|0;do{if(jr>>>0<(c[bs>>2]|0)>>>0){c[z>>2]=jr+1;l2=a[jr]|0}else{if((c[x>>2]|0)==0){l2=0;break}je=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((je|0)==0){c[x>>2]=0;jf=(c[bs>>2]|0)-1|0;c[z>>2]=jf;a[jf]=0;l3=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+je;l3=bd}c[z>>2]=l3+1;l2=a[l3]|0}}while(0);jr=l2&255;je=$(jr>>>0<jy>>>0?jr:0,jq)|0;if(jm){lU=jg;lV=i5;lW=jl;lX=iG;lY=l_;lZ=l$;break}else{l4=0}do{a[n+l4|0]=a[lT+(l4+je)|0]|0;l4=l4+1|0;}while((l4<<3|0)<(jo|0))}else{if(jm){lU=jg;lV=i5;lW=jl;lX=iG;lY=l_;lZ=l$;break}je=0;jr=c[z>>2]|0;while(1){do{if(jr>>>0<(c[bs>>2]|0)>>>0){jf=jr+1|0;c[z>>2]=jf;l5=a[jr]|0;l6=jf}else{if((c[x>>2]|0)==0){l5=0;l6=jr;break}jf=cl[c[v>>2]&3](c[br>>2]|0,bd,c[bh>>2]|0)|0;if((jf|0)==0){c[x>>2]=0;ja=(c[bs>>2]|0)-1|0;c[z>>2]=ja;a[ja]=0;l7=c[z>>2]|0}else{c[z>>2]=bd;c[bs>>2]=e+40+jf;l7=bd}jf=l7+1|0;c[z>>2]=jf;l5=a[l7]|0;l6=jf}}while(0);a[n+je|0]=l5;jf=je+1|0;if((jf<<3|0)<(jo|0)){je=jf;jr=l6}else{break}}}if((jo|0)==8){jr=a[jx]|0;lU=jr;lV=jr;lW=jr;lX=-1;lY=l_;lZ=l$;break}else if((jo|0)==16){jr=a[jx]|0;lU=jr;lV=jr;lW=jr;lX=a[jz]|0;lY=l_;lZ=l$;break}else if((jo|0)==24){lU=a[jA]|0;lV=a[jz]|0;lW=a[jx]|0;lX=-1;lY=l_;lZ=l$;break}else if((jo|0)==32){lU=a[jA]|0;lV=a[jz]|0;lW=a[jx]|0;lX=a[jk]|0;lY=l_;lZ=l$;break}else{lU=jg;lV=i5;lW=jl;lX=iG;lY=l_;lZ=l$;break}}}while(0);if((hC|0)==1){a[jn+jB|0]=(((lV&255)*150|0)+((lW&255)*29|0)+((lU&255)*77|0)|0)>>>8&255}else if((hC|0)==2){jr=jB<<1;a[jn+jr|0]=(((lV&255)*150|0)+((lW&255)*29|0)+((lU&255)*77|0)|0)>>>8&255;a[jn+(jr|1)|0]=lX}else if((hC|0)==3){jr=jB*3|0;a[jn+jr|0]=lU;a[jn+(jr+1)|0]=lV;a[jn+(jr+2)|0]=lW}else if((hC|0)==4){jr=jB<<2;a[jn+jr|0]=lU;a[jn+(jr|1)|0]=lV;a[jn+(jr|2)|0]=lW;a[jn+(jr|3)|0]=lX}jr=jB+1|0;if((jr|0)<(hF|0)){jB=jr;iG=lX;jl=lW;i5=lV;jg=lU;jj=lY-1|0;ji=lZ;jh=0}else{break}}}if((lN&32)==0){jh=$(hC,jp)|0;ji=hB-1|0;jj=(jh|0)>0;jg=0;do{if(jj){i5=jh;jl=$(jg,jh)|0;iG=$(ji-jg|0,jh)|0;while(1){jB=jn+jl|0;hF=a[jB]|0;jk=jn+iG|0;a[jB]=a[jk]|0;a[jk]=hF;hF=i5-1|0;if((hF|0)>0){i5=hF;jl=jl+1|0;iG=iG+1|0}else{break}}}jg=jg+1|0;}while((jg<<1|0)<(hB|0))}if((lT|0)==0){A=jn;i=l;return A|0}ft(lT);A=jn;i=l;return A|0}}while(0);c[z>>2]=c[w>>2];c[2832]=2144;A=0;i=l;return A|0}function ev(b,e,f,h,j){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0.0,az=0,aA=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0;k=i;i=i+1040|0;l=k+1024|0;m=k+1032|0;n=k|0;o=m;if((aS(eQ(b,n)|0,2472)|0)!=0){c[2832]=688;p=0;i=k;return p|0}q=eQ(b,n)|0;c[l>>2]=q;do{if((a[q]|0)!=0){r=0;s=q;do{t=(aS(s|0,2448)|0)==0;r=t?1:r;s=eQ(b,n)|0;c[l>>2]=s;}while((a[s]|0)!=0);if((r|0)==0){break}s=eQ(b,n)|0;c[l>>2]=s;if((aT(s|0,2424,3)|0)!=0){c[2832]=640;p=0;i=k;return p|0}t=s+3|0;c[l>>2]=t;s=aB(t|0,l|0,10)|0;t=c[l>>2]|0;if((a[t]|0)==32){u=t;do{u=u+1|0;}while((a[u]|0)==32);c[l>>2]=u;v=u}else{v=t}if((aT(v|0,2416,3)|0)!=0){c[2832]=640;p=0;i=k;return p|0}r=v+3|0;c[l>>2]=r;w=aB(r|0,0,10)|0;c[e>>2]=w;c[f>>2]=s;c[h>>2]=3;r=(j|0)==0?3:j;x=fs($($(r<<2,s)|0,w)|0)|0;y=x;L3018:do{if((w-8|0)>>>0>32759>>>0){z=0;A=2376}else{L3020:do{if((s|0)>0){B=b+168|0;C=b+172|0;D=w<<2;E=(w|0)>0;F=b+32|0;G=b+16|0;H=b+28|0;I=b+40|0;J=b+36|0;K=(r|0)<3;L=0;M=0;while(1){N=c[B>>2]|0;O=c[C>>2]|0;do{if(N>>>0<O>>>0){P=N+1|0;c[B>>2]=P;Q=d[N]|0;R=P;S=O}else{if((c[F>>2]|0)==0){Q=0;R=N;S=O;break}P=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((P|0)==0){c[F>>2]=0;T=(c[C>>2]|0)-1|0;c[B>>2]=T;a[T]=0;U=c[B>>2]|0;V=c[C>>2]|0}else{c[B>>2]=I;T=b+40+P|0;c[C>>2]=T;U=I;V=T}T=U+1|0;c[B>>2]=T;Q=d[U]|0;R=T;S=V}}while(0);do{if(R>>>0<S>>>0){O=R+1|0;c[B>>2]=O;W=d[R]|0;X=O;Y=S}else{if((c[F>>2]|0)==0){W=0;X=R;Y=S;break}O=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((O|0)==0){c[F>>2]=0;N=(c[C>>2]|0)-1|0;c[B>>2]=N;a[N]=0;Z=c[B>>2]|0;_=c[C>>2]|0}else{c[B>>2]=I;N=b+40+O|0;c[C>>2]=N;Z=I;_=N}N=Z+1|0;c[B>>2]=N;W=d[Z]|0;X=N;Y=_}}while(0);do{if(X>>>0<Y>>>0){N=X+1|0;c[B>>2]=N;aa=d[X]|0;ab=N}else{if((c[F>>2]|0)==0){aa=0;ab=X;break}N=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((N|0)==0){c[F>>2]=0;O=(c[C>>2]|0)-1|0;c[B>>2]=O;a[O]=0;ac=c[B>>2]|0}else{c[B>>2]=I;c[C>>2]=b+40+N;ac=I}N=ac+1|0;c[B>>2]=N;aa=d[ac]|0;ab=N}}while(0);if(!((Q|0)==2&(W|0)==2)){ad=Q;ae=W;break}if((aa&128|0)!=0){ad=2;ae=2;break}N=aa<<8;do{if(ab>>>0<(c[C>>2]|0)>>>0){c[B>>2]=ab+1;af=d[ab]|0}else{if((c[F>>2]|0)==0){af=0;break}O=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((O|0)==0){c[F>>2]=0;T=(c[C>>2]|0)-1|0;c[B>>2]=T;a[T]=0;ag=c[B>>2]|0}else{c[B>>2]=I;c[C>>2]=b+40+O;ag=I}c[B>>2]=ag+1;af=d[ag]|0}}while(0);if((af|N|0)!=(w|0)){A=2448;break}if((L|0)==0){ah=fs(D)|0}else{ah=L}O=0;do{if(E){T=0;while(1){P=c[B>>2]|0;do{if(P>>>0<(c[C>>2]|0)>>>0){ai=P;A=2463}else{if((c[F>>2]|0)==0){aj=T;break}ak=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((ak|0)==0){c[F>>2]=0;al=(c[C>>2]|0)-1|0;c[B>>2]=al;a[al]=0;ai=c[B>>2]|0;A=2463;break}else{c[B>>2]=I;c[C>>2]=b+40+ak;ai=I;A=2463;break}}}while(0);L3077:do{if((A|0)==2463){A=0;P=ai+1|0;c[B>>2]=P;ak=a[ai]|0;al=ak&255;if((ak&255)>>>0>128>>>0){do{if(P>>>0<(c[C>>2]|0)>>>0){c[B>>2]=ai+2;am=a[P]|0}else{if((c[F>>2]|0)==0){am=0;break}an=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((an|0)==0){c[F>>2]=0;ao=(c[C>>2]|0)-1|0;c[B>>2]=ao;a[ao]=0;ap=c[B>>2]|0}else{c[B>>2]=I;c[C>>2]=b+40+an;ap=I}c[B>>2]=ap+1;if(ak<<24>>24==-128){aj=T;break L3077}else{am=a[ap]|0}}}while(0);an=(ak^-128)&255;ao=an>>>0>1>>>0;aq=T;ar=0;while(1){a[ah+((aq<<2)+O)|0]=am;as=ar+1|0;if((as|0)<(an|0)){aq=aq+1|0;ar=as}else{break}}aj=(ao?an:1)+T|0;break}if(ak<<24>>24==0){aj=T;break}ar=al>>>0>1>>>0;aq=T;as=1;at=P;while(1){do{if(at>>>0<(c[C>>2]|0)>>>0){c[B>>2]=at+1;au=a[at]|0}else{if((c[F>>2]|0)==0){au=0;break}av=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((av|0)==0){c[F>>2]=0;aw=(c[C>>2]|0)-1|0;c[B>>2]=aw;a[aw]=0;ax=c[B>>2]|0}else{c[B>>2]=I;c[C>>2]=b+40+av;ax=I}c[B>>2]=ax+1;au=a[ax]|0}}while(0);a[ah+((aq<<2)+O)|0]=au;if((as|0)>=(al|0)){break}aq=aq+1|0;as=as+1|0;at=c[B>>2]|0}aj=(ar?al:1)+T|0}}while(0);if((aj|0)<(w|0)){T=aj}else{break}}}O=O+1|0;}while((O|0)<4);if(E){O=$(M,w)|0;N=0;do{T=$(N+O|0,r)|0;at=y+(T<<2)|0;as=N<<2;aq=a[ah+(as|3)|0]|0;do{if(aq<<24>>24==0){if((r|0)==4){g[y+(T+3<<2)>>2]=1.0;A=2494}else if((r|0)==3){A=2494}else if((r|0)==2){g[y+(T+1<<2)>>2]=1.0;A=2496}else if((r|0)==1){A=2496}else{break}if((A|0)==2494){A=0;g[y+(T+2<<2)>>2]=0.0;g[y+(T+1<<2)>>2]=0.0;g[at>>2]=0.0;break}else if((A|0)==2496){A=0;g[at>>2]=0.0;break}}else{ay=+br(+1.0,(aq&255)-136|0);P=d[ah+as|0]|0;if(K){g[at>>2]=ay*+((d[ah+(as|1)|0]|0)+P+(d[ah+(as|2)|0]|0)|0)/3.0}else{g[at>>2]=ay*+(P|0);g[y+(T+1<<2)>>2]=ay*+(d[ah+(as|1)|0]|0);g[y+(T+2<<2)>>2]=ay*+(d[ah+(as|2)|0]|0)}if((r|0)==4){g[y+(T+3<<2)>>2]=1.0;break}else if((r|0)==2){g[y+(T+1<<2)>>2]=1.0;break}else{break}}}while(0);N=N+1|0;}while((N|0)<(w|0))}N=M+1|0;if((N|0)<(s|0)){L=ah;M=N}else{az=ah;break L3020}}if((A|0)==2448){ft(x);ft(L);c[2832]=592;p=0;i=k;return p|0}do{if(ab>>>0<(c[C>>2]|0)>>>0){aA=ab;A=2427}else{if((c[F>>2]|0)==0){A=2434;break}M=cl[c[G>>2]&3](c[H>>2]|0,I,c[J>>2]|0)|0;if((M|0)==0){c[F>>2]=0;E=(c[C>>2]|0)-1|0;c[B>>2]=E;a[E]=0;aA=c[B>>2]|0;A=2427;break}else{c[B>>2]=I;c[C>>2]=b+40+M;aA=I;A=2427;break}}}while(0);do{if((A|0)==2427){c[B>>2]=aA+1;I=a[aA]|0;if(I<<24>>24==0){A=2434;break}ay=+br(+1.0,(I&255)-136|0);if(K){g[y>>2]=+(ae+aa+ad|0)*ay/3.0}else{g[y>>2]=+(ad|0)*ay;g[x+4>>2]=+(ae|0)*ay;g[x+8>>2]=+(aa|0)*ay}if((r|0)==2){g[x+4>>2]=1.0;break}else if((r|0)==4){g[x+12>>2]=1.0;break}else{break}}}while(0);do{if((A|0)==2434){if((r|0)==4){g[x+12>>2]=1.0;A=2436}else if((r|0)==3){A=2436}else if((r|0)==2){g[x+4>>2]=1.0;A=2438}else if((r|0)==1){A=2438}else{break}if((A|0)==2436){g[x+8>>2]=0.0;g[x+4>>2]=0.0;g[y>>2]=0.0;break}else if((A|0)==2438){g[y>>2]=0.0;break}}}while(0);ft(L);aC=0;aD=1;aE=G;A=2379;break L3018}else{az=0}}while(0);ft(az);p=y;i=k;return p|0}}while(0);while(1){if((A|0)==2376){A=0;if((z|0)<(s|0)){aF=z;aG=0}else{p=y;break}}else if((A|0)==2379){A=0;x=c[aE>>2]|0;do{if((x|0)==0){aH=c[b+168>>2]|0;aI=c[b+172>>2]|0;A=2383}else{t=b+172|0;u=c[t>>2]|0;K=b+168|0;B=c[K>>2]|0;I=u-B|0;if((I|0)>=4){aH=B;aI=u;A=2383;break}fG(o|0,B|0,I)|0;B=c[b+28>>2]|0;u=o+I|0;C=4-I|0;cl[x&3](B,u,C)|0;c[K>>2]=c[t>>2]}}while(0);do{if((A|0)==2383){A=0;x=aH+4|0;if(x>>>0>aI>>>0){break}t=aH;c[m>>2]=d[t]|d[t+1|0]<<8|d[t+2|0]<<16|d[t+3|0]<<24;c[b+168>>2]=x}}while(0);x=$(($(aC,w)|0)+aD|0,r)|0;t=y+(x<<2)|0;K=a[o+3|0]|0;do{if(K<<24>>24==0){if((r|0)==1){A=2396}else if((r|0)==4){g[y+(x+3<<2)>>2]=1.0;A=2394}else if((r|0)==3){A=2394}else if((r|0)==2){g[y+(x+1<<2)>>2]=1.0;A=2396}else{break}if((A|0)==2396){A=0;g[t>>2]=0.0;break}else if((A|0)==2394){A=0;g[y+(x+2<<2)>>2]=0.0;g[y+(x+1<<2)>>2]=0.0;g[t>>2]=0.0;break}}else{ay=+br(+1.0,(K&255)-136|0);C=d[o]|0;if((r|0)<3){g[t>>2]=ay*+((d[o+1|0]|0)+C+(d[o+2|0]|0)|0)/3.0}else{g[t>>2]=ay*+(C|0);g[y+(x+1<<2)>>2]=ay*+(d[o+1|0]|0);g[y+(x+2<<2)>>2]=ay*+(d[o+2|0]|0)}if((r|0)==2){g[y+(x+1<<2)>>2]=1.0;break}else if((r|0)==4){g[y+(x+3<<2)>>2]=1.0;break}else{break}}}while(0);aF=aC;aG=aD+1|0}if((aG|0)<(w|0)){aC=aF;aD=aG;aE=b+16|0;A=2379;continue}else{z=aF+1|0;A=2376;continue}}i=k;return p|0}}while(0);c[2832]=664;p=0;i=k;return p|0}function ew(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0;j=i;i=i+2512|0;k=j|0;l=j+2024|0;m=j+2480|0;n=j+2504|0;o=b+20|0;c[o>>2]=e;p=b+16|0;c[p>>2]=e;q=b+24|0;c[q>>2]=e+f;f=b+28|0;c[f>>2]=g;g=b|0;do{if((h|0)==0){r=b+4|0}else{e=c[g>>2]|0;s=b+4|0;t=c[s>>2]|0;if(e>>>0<t>>>0){u=e+1|0;c[g>>2]=u;w=d[e]|0;x=u}else{w=0;x=e}if(x>>>0<t>>>0){c[g>>2]=x+1;y=d[x]|0}else{y=0}if((((y|w<<8)>>>0)%31|0|0)!=0){c[2832]=200;z=0;i=j;return z|0}if((y&32|0)!=0){c[2832]=184;z=0;i=j;return z|0}if((w&15|0)==8){r=s;break}c[2832]=168;z=0;i=j;return z|0}}while(0);w=b+8|0;c[w>>2]=0;y=b+12|0;c[y>>2]=0;x=l|0;h=m|0;s=b+32|0;t=b+2052|0;e=n|0;u=n+1|0;A=n+3|0;B=n+2|0;C=0;D=0;L3221:while(1){if((C|0)<1){E=D;F=C;while(1){if(E>>>0>=1<<F>>>0){G=2523;break L3221}H=c[g>>2]|0;if(H>>>0<(c[r>>2]|0)>>>0){c[g>>2]=H+1;I=d[H]|0}else{I=0}H=I<<F|E;c[y>>2]=H;J=F+8|0;c[w>>2]=J;if((J|0)<25){E=H;F=J}else{K=J;L=H;break}}}else{K=C;L=D}F=L&1;E=L>>>1;c[y>>2]=E;H=K-1|0;c[w>>2]=H;if((H|0)<2){J=E;M=H;while(1){if(J>>>0>=1<<M>>>0){G=2529;break L3221}N=c[g>>2]|0;if(N>>>0<(c[r>>2]|0)>>>0){c[g>>2]=N+1;O=d[N]|0}else{O=0}N=O<<M|J;c[y>>2]=N;P=M+8|0;c[w>>2]=P;if((P|0)<25){J=N;M=P}else{Q=P;R=N;break}}}else{Q=H;R=E}M=R&3;J=R>>>2;c[y>>2]=J;N=Q-2|0;c[w>>2]=N;if((M|0)==3){z=0;G=2691;break}else if((M|0)==0){P=N&7;if((P|0)==0){S=N;T=J}else{if((N|0)<(P|0)){U=J;V=N;while(1){if(U>>>0>=1<<V>>>0){G=2537;break L3221}W=c[g>>2]|0;if(W>>>0<(c[r>>2]|0)>>>0){c[g>>2]=W+1;X=d[W]|0}else{X=0}W=X<<V|U;c[y>>2]=W;Y=V+8|0;c[w>>2]=Y;if((Y|0)<25){U=W;V=Y}else{Z=Y;_=W;break}}}else{Z=N;_=J}V=_>>>(P>>>0);c[y>>2]=V;U=Z-P|0;c[w>>2]=U;S=U;T=V}if((S|0)>0){V=7-S|0;U=(((V|0)>-1?V:-1)+S|0)>>>3;V=0;E=T;H=S;while(1){a[n+V|0]=E&255;$=E>>>8;W=H-8|0;if((W|0)>0){V=V+1|0;E=$;H=W}else{break}}H=S-8-(U<<3)|0;c[y>>2]=$;c[w>>2]=H;aa=H;ab=U+1|0}else{aa=S;ab=0}if((aa|0)!=0){G=2549;break}if((ab|0)<4){H=c[r>>2]|0;E=ab;V=c[g>>2]|0;while(1){if(V>>>0<H>>>0){P=V+1|0;c[g>>2]=P;ac=a[V]|0;ad=P}else{ac=0;ad=V}P=E+1|0;a[n+E|0]=ac;if((P|0)<4){E=P;V=ad}else{break}}}V=d[u]<<8|d[e];if((d[A]<<8|d[B]|0)!=(V^65535|0)){G=2554;break}E=c[g>>2]|0;if((E+V|0)>>>0>(c[r>>2]|0)>>>0){G=2556;break}H=c[p>>2]|0;U=c[q>>2]|0;if((H+V|0)>>>0>U>>>0){if((c[f>>2]|0)==0){G=2559;break}P=c[o>>2]|0;W=P;Y=H-W|0;ae=Y+V|0;af=U-W|0;while(1){if((ae|0)>(af|0)){af=af<<1}else{break}}ae=fu(P,af)|0;if((ae|0)==0){G=2563;break}c[o>>2]=ae;W=ae+Y|0;c[p>>2]=W;c[q>>2]=ae+af;ag=W;ah=c[g>>2]|0}else{ag=H;ah=E}fG(ag|0,ah|0,V)|0;c[g>>2]=(c[g>>2]|0)+V;c[p>>2]=(c[p>>2]|0)+V}else if((M|0)==1){if((a[11327]|0)==0){fF(11336,8,144);fF(11480,9,112);fF(11592,7,24);W=11616;ae=W|0;v=134744072;a[ae]=v&255;v=v>>8;a[ae+1|0]=v&255;v=v>>8;a[ae+2|0]=v&255;v=v>>8;a[ae+3|0]=v&255;ae=W+4|0;v=134744072;a[ae]=v&255;v=v>>8;a[ae+1|0]=v&255;v=v>>8;a[ae+2|0]=v&255;v=v>>8;a[ae+3|0]=v&255;fF(11296,5,32)}if((eY(s,11336,288)|0)==0){z=0;G=2696;break}if((eY(t,11296,32)|0)==0){z=0;G=2697;break}else{G=2630}}else{if((N|0)<5){ae=J;W=N;while(1){if(ae>>>0>=1<<W>>>0){G=2572;break L3221}U=c[g>>2]|0;if(U>>>0<(c[r>>2]|0)>>>0){c[g>>2]=U+1;ai=d[U]|0}else{ai=0}U=ai<<W|ae;c[y>>2]=U;aj=W+8|0;c[w>>2]=aj;if((aj|0)<25){ae=U;W=aj}else{ak=aj;al=U;break}}}else{ak=N;al=J}W=al>>>5;c[y>>2]=W;ae=ak-5|0;c[w>>2]=ae;M=(al&31)+257|0;if((ae|0)<5){V=W;E=ae;while(1){if(V>>>0>=1<<E>>>0){G=2578;break L3221}H=c[g>>2]|0;if(H>>>0<(c[r>>2]|0)>>>0){c[g>>2]=H+1;am=d[H]|0}else{am=0}H=am<<E|V;c[y>>2]=H;af=E+8|0;c[w>>2]=af;if((af|0)<25){V=H;E=af}else{an=af;ao=H;break}}}else{an=ae;ao=W}E=ao>>>5;c[y>>2]=E;V=an-5|0;c[w>>2]=V;J=(ao&31)+1|0;if((V|0)<4){N=E;H=V;while(1){if(N>>>0>=1<<H>>>0){G=2584;break L3221}af=c[g>>2]|0;if(af>>>0<(c[r>>2]|0)>>>0){c[g>>2]=af+1;ap=d[af]|0}else{ap=0}af=ap<<H|N;c[y>>2]=af;Y=H+8|0;c[w>>2]=Y;if((Y|0)<25){N=af;H=Y}else{aq=Y;ar=af;break}}}else{aq=V;ar=E}H=ar>>>4;c[y>>2]=H;N=aq-4|0;c[w>>2]=N;W=(ar&15)+4|0;fF(h|0,0,19);ae=0;af=N;N=H;do{if((af|0)<3){H=N;Y=af;while(1){if(H>>>0>=1<<Y>>>0){G=2591;break L3221}P=c[g>>2]|0;if(P>>>0<(c[r>>2]|0)>>>0){c[g>>2]=P+1;as=d[P]|0}else{as=0}P=as<<Y|H;c[y>>2]=P;U=Y+8|0;c[w>>2]=U;if((U|0)<25){H=P;Y=U}else{at=U;au=P;break}}}else{at=af;au=N}N=au>>>3;c[y>>2]=N;af=at-3|0;c[w>>2]=af;a[m+(d[3848+ae|0]|0)|0]=au&7;ae=ae+1|0;}while((ae|0)<(W|0));if((eY(k,h,19)|0)==0){z=0;G=2685;break}W=J+M|0;if((W|0)>0){ae=0;while(1){af=eZ(b,k)|0;if(af>>>0>=19>>>0){G=2599;break L3221}do{if((af|0)<16){a[l+ae|0]=af&255;av=ae+1|0}else{if((af|0)==16){N=c[w>>2]|0;E=c[y>>2]|0;if((N|0)<2){V=E;Y=N;while(1){if(V>>>0>=1<<Y>>>0){G=2605;break L3221}H=c[g>>2]|0;if(H>>>0<(c[r>>2]|0)>>>0){c[g>>2]=H+1;aw=d[H]|0}else{aw=0}H=aw<<Y|V;c[y>>2]=H;P=Y+8|0;c[w>>2]=P;if((P|0)<25){V=H;Y=P}else{ax=P;ay=H;break}}}else{ax=N;ay=E}c[y>>2]=ay>>>2;c[w>>2]=ax-2;Y=(ay&3)+3|0;fF(l+ae|0,a[l+(ae-1)|0]|0,Y|0);av=Y+ae|0;break}else if((af|0)==18){Y=c[w>>2]|0;V=c[y>>2]|0;if((Y|0)<7){H=V;P=Y;while(1){if(H>>>0>=1<<P>>>0){G=2621;break L3221}U=c[g>>2]|0;if(U>>>0<(c[r>>2]|0)>>>0){c[g>>2]=U+1;az=d[U]|0}else{az=0}U=az<<P|H;c[y>>2]=U;aj=P+8|0;c[w>>2]=aj;if((aj|0)<25){H=U;P=aj}else{aA=aj;aB=U;break}}}else{aA=Y;aB=V}c[y>>2]=aB>>>7;c[w>>2]=aA-7;P=(aB&127)+11|0;fF(l+ae|0,0,P|0);av=P+ae|0;break}else if((af|0)==17){P=c[w>>2]|0;H=c[y>>2]|0;if((P|0)<3){E=H;N=P;while(1){if(E>>>0>=1<<N>>>0){G=2613;break L3221}U=c[g>>2]|0;if(U>>>0<(c[r>>2]|0)>>>0){c[g>>2]=U+1;aC=d[U]|0}else{aC=0}U=aC<<N|E;c[y>>2]=U;aj=N+8|0;c[w>>2]=aj;if((aj|0)<25){E=U;N=aj}else{aD=aj;aE=U;break}}}else{aD=P;aE=H}c[y>>2]=aE>>>3;c[w>>2]=aD-3;N=(aE&7)+3|0;fF(l+ae|0,0,N|0);av=N+ae|0;break}else{G=2618;break L3221}}}while(0);if((av|0)<(W|0)){ae=av}else{aF=av;break}}}else{aF=0}if((aF|0)!=(W|0)){G=2627;break}if((eY(s,x,M)|0)==0){z=0;G=2683;break}if((eY(t,l+M|0,J)|0)==0){z=0;G=2686;break}else{G=2630}}L3358:do{if((G|0)==2630){L3359:while(1){G=0;ae=eZ(b,s)|0;if((ae|0)<256){if((ae|0)<0){G=2632;break L3221}af=c[p>>2]|0;N=c[q>>2]|0;if(af>>>0<N>>>0){aG=af}else{if((c[f>>2]|0)==0){G=2635;break L3221}E=c[o>>2]|0;V=E;Y=af-V|0;af=Y+1|0;U=N-V|0;while(1){if((af|0)>(U|0)){U=U<<1}else{break}}af=fu(E,U)|0;if((af|0)==0){G=2639;break L3221}c[o>>2]=af;H=af+Y|0;c[p>>2]=H;c[q>>2]=af+U;aG=H}c[p>>2]=aG+1;a[aG]=ae&255;G=2630;continue}if((ae|0)==256){break L3358}H=ae-257|0;af=c[6384+(H<<2)>>2]|0;if((ae-265|0)>>>0<20>>>0){P=c[6256+(H<<2)>>2]|0;H=c[w>>2]|0;V=c[y>>2]|0;if((H|0)<(P|0)){N=V;aj=H;while(1){if(N>>>0>=1<<aj>>>0){G=2646;break L3221}aH=c[g>>2]|0;if(aH>>>0<(c[r>>2]|0)>>>0){c[g>>2]=aH+1;aI=d[aH]|0}else{aI=0}aH=aI<<aj|N;c[y>>2]=aH;aJ=aj+8|0;c[w>>2]=aJ;if((aJ|0)<25){N=aH;aj=aJ}else{aK=aJ;aL=aH;break}}}else{aK=H;aL=V}c[y>>2]=aL>>>(P>>>0);c[w>>2]=aK-P;aM=(aL&(1<<P)-1)+af|0}else{aM=af}aj=eZ(b,t)|0;if((aj|0)<0){G=2652;break L3221}N=c[5968+(aj<<2)>>2]|0;if((aj-4|0)>>>0<26>>>0){ae=c[6528+(aj<<2)>>2]|0;aj=c[w>>2]|0;U=c[y>>2]|0;if((aj|0)<(ae|0)){Y=U;E=aj;while(1){if(Y>>>0>=1<<E>>>0){G=2656;break L3221}aH=c[g>>2]|0;if(aH>>>0<(c[r>>2]|0)>>>0){c[g>>2]=aH+1;aN=d[aH]|0}else{aN=0}aH=aN<<E|Y;c[y>>2]=aH;aJ=E+8|0;c[w>>2]=aJ;if((aJ|0)<25){Y=aH;E=aJ}else{aO=aJ;aP=aH;break}}}else{aO=aj;aP=U}c[y>>2]=aP>>>(ae>>>0);c[w>>2]=aO-ae;aQ=(aP&(1<<ae)-1)+N|0}else{aQ=N}E=c[p>>2]|0;Y=c[o>>2]|0;af=Y;P=E-af|0;if((P|0)<(aQ|0)){G=2662;break L3221}V=c[q>>2]|0;if((E+aM|0)>>>0>V>>>0){if((c[f>>2]|0)==0){G=2665;break L3221}H=P+aM|0;aH=V-af|0;while(1){if((H|0)>(aH|0)){aH=aH<<1}else{break}}H=fu(Y,aH)|0;if((H|0)==0){G=2669;break L3221}c[o>>2]=H;N=H+P|0;c[p>>2]=N;c[q>>2]=H+aH;aR=N}else{aR=E}if((aM|0)==0){G=2630;continue}N=aR+(-aQ|0)|0;H=aM-1|0;ae=a[N]|0;c[p>>2]=aR+1;a[aR]=ae;if((H|0)==0){G=2630;continue}else{aS=N;aT=H}while(1){H=aS+1|0;N=c[p>>2]|0;ae=aT-1|0;U=a[H]|0;c[p>>2]=N+1;a[N]=U;if((ae|0)==0){G=2630;continue L3359}else{aS=H;aT=ae}}}}}while(0);if((c[1664]|0)==0){if((F|0)!=0){z=1;G=2700;break}}else{if(!(((c[p>>2]|0)-(c[o>>2]|0)|0)<65537&(F|0)==0)){z=1;G=2699;break}}C=c[w>>2]|0;D=c[y>>2]|0}if((G|0)==2618){bT(368,1472,2194,3512);return 0}else if((G|0)==2584){bT(416,1472,2058,3408);return 0}else if((G|0)==2599){bT(392,1472,2182,3512);return 0}else if((G|0)==2646){bT(416,1472,2058,3408);return 0}else if((G|0)==2591){bT(416,1472,2058,3408);return 0}else if((G|0)==2662){c[2832]=504;z=0;i=j;return z|0}else if((G|0)==2665){c[2832]=472;z=0;i=j;return z|0}else if((G|0)==2605){bT(416,1472,2058,3408);return 0}else if((G|0)==2627){c[2832]=344;z=0;i=j;return z|0}else if((G|0)==2652){c[2832]=552;z=0;i=j;return z|0}else if((G|0)==2656){bT(416,1472,2058,3408);return 0}else if((G|0)==2632){c[2832]=552;z=0;i=j;return z|0}else if((G|0)==2635){c[2832]=472;z=0;i=j;return z|0}else if((G|0)==2691){i=j;return z|0}else if((G|0)==2696){i=j;return z|0}else if((G|0)==2697){i=j;return z|0}else if((G|0)==2699){i=j;return z|0}else if((G|0)==2700){i=j;return z|0}else if((G|0)==2523){bT(416,1472,2058,3408);return 0}else if((G|0)==2529){bT(416,1472,2058,3408);return 0}else if((G|0)==2537){bT(416,1472,2058,3408);return 0}else if((G|0)==2549){bT(296,1472,2219,3480);return 0}else if((G|0)==2554){c[2832]=272;z=0;i=j;return z|0}else if((G|0)==2556){c[2832]=216;z=0;i=j;return z|0}else if((G|0)==2559){c[2832]=472;z=0;i=j;return z|0}else if((G|0)==2563){c[2832]=1560;z=0;i=j;return z|0}else if((G|0)==2572){bT(416,1472,2058,3408);return 0}else if((G|0)==2683){i=j;return z|0}else if((G|0)==2685){i=j;return z|0}else if((G|0)==2686){i=j;return z|0}else if((G|0)==2669){c[2832]=1560;z=0;i=j;return z|0}else if((G|0)==2621){bT(416,1472,2058,3408);return 0}else if((G|0)==2578){bT(416,1472,2058,3408);return 0}else if((G|0)==2639){c[2832]=1560;z=0;i=j;return z|0}else if((G|0)==2613){bT(416,1472,2058,3408);return 0}return 0}function ex(b,c){b=b|0;c=c|0;var e=0,f=0,g=0;e=a[b]|0;do{if((e<<24>>24|0)==116){if((a[b+1|0]|0)!=121){break}if((a[b+2|0]|0)==112){if((a[b+3|0]|0)==49){f=2716;break}}if(e<<24>>24==116){break}else{g=-1}return g|0}else if((e<<24>>24|0)==49){if((a[b+1|0]|0)!=0){g=-1;return g|0}if((a[b+2|0]|0)==0){if((a[b+3|0]|0)==0){f=2716;break}else{f=2717;break}}else{g=-1;return g|0}}else if((e<<24>>24|0)==79){if((a[b+1|0]|0)!=84){g=-1;return g|0}if((a[b+2|0]|0)!=84){f=2717;break}if((a[b+3|0]|0)==79){f=2716}else{f=2717}}else if((e<<24>>24|0)==0){if((a[b+1|0]|0)!=1){g=-1;return g|0}if((a[b+2|0]|0)!=0){f=2717;break}if((a[b+3|0]|0)==0){f=2716}else{f=2717}}else{g=-1;return g|0}}while(0);do{if((f|0)==2716){g=((c|0)!=0)<<31>>31;return g|0}else if((f|0)==2717){if(e<<24>>24==116){break}else{g=-1}return g|0}}while(0);if((a[b+1|0]|0)!=116){g=-1;return g|0}if((a[b+2|0]|0)!=99){g=-1;return g|0}if((a[b+3|0]|0)!=102){g=-1;return g|0}e=d[b+5|0]<<16|d[b+4|0]<<24|d[b+6|0]<<8|d[b+7|0];if(!((e|0)==65536|(e|0)==131072)){g=-1;return g|0}if((d[b+9|0]<<16|d[b+8|0]<<24|d[b+10|0]<<8|d[b+11|0]|0)<=(c|0)){g=-1;return g|0}e=c*14|0;g=d[b+(e+13)|0]<<16|d[b+(e+12)|0]<<24|d[b+(e+14)|0]<<8|d[b+(e+15)|0];return g|0}function ey(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c[a+4>>2]=b;c[a+8>>2]=e;f=ez(b,e,1464)|0;g=ez(b,e,1040)|0;c[a+16>>2]=g;h=ez(b,e,792)|0;c[a+20>>2]=h;i=ez(b,e,520)|0;c[a+24>>2]=i;j=ez(b,e,288)|0;c[a+28>>2]=j;k=ez(b,e,72)|0;c[a+32>>2]=k;c[a+36>>2]=ez(b,e,3112)|0;if((f|0)==0|(g|0)==0|(h|0)==0|(i|0)==0|(j|0)==0|(k|0)==0){l=0;return l|0}k=ez(b,e,3104)|0;if((k|0)==0){c[a+12>>2]=65535}else{c[a+12>>2]=((d[b+(k+4)|0]|0)<<8|(d[b+(k+5)|0]|0))&65535}k=(d[b+(f+2)|0]|0)<<8|(d[b+(f+3)|0]|0);e=k&65535;j=a+40|0;c[j>>2]=0;if(k<<16>>16==0){l=0;return l|0}k=f+4|0;i=0;g=0;while(1){m=k+(i<<3)|0;do{if(((d[b+m|0]|0)<<8|(d[b+(m+1)|0]|0))<<16>>16==3){n=((d[b+(m+2)|0]|0)<<8|(d[b+(m+3)|0]|0))&65535;if(!((n|0)==1|(n|0)==10)){o=g;break}n=((d[b+(m+5)|0]|0)<<16|(d[b+(m+4)|0]|0)<<24|(d[b+(m+6)|0]|0)<<8|(d[b+(m+7)|0]|0))+f|0;c[j>>2]=n;o=n}else{o=g}}while(0);m=i+1|0;if((m|0)<(e|0)){i=m;g=o}else{break}}if((o|0)==0){l=0;return l|0}c[a+44>>2]=((d[b+(h+50)|0]|0)<<8|(d[b+(h+51)|0]|0))&65535;l=1;return l|0}function ez(b,c,e){b=b|0;c=c|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=d[b+(c+4)|0]<<8|d[b+(c+5)|0];g=f&65535;h=c+12|0;if(f<<16>>16==0){i=0;return i|0}f=a[e]|0;c=e+1|0;j=e+2|0;k=e+3|0;e=0;L3536:while(1){l=h+(e<<4)|0;do{if((d[b+l|0]|0)==(f|0)){if((d[b+(l+1)|0]|0)!=(a[c]|0)){break}if((d[b+(l+2)|0]|0)!=(a[j]|0)){break}if((d[b+(l+3)|0]|0)==(a[k]|0)){break L3536}}}while(0);m=e+1|0;if((m|0)<(g|0)){e=m}else{i=0;n=2765;break}}if((n|0)==2765){return i|0}i=d[b+(l+9)|0]<<16|d[b+(l+8)|0]<<24|d[b+(l+10)|0]<<8|d[b+(l+11)|0];return i|0}function eA(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;e=c[a+4>>2]|0;f=c[a+40>>2]|0;a=(d[e+f|0]|0)<<8|(d[e+(f+1)|0]|0);if((a<<16>>16|0)==0){if(((((d[e+(f+2)|0]|0)<<8|(d[e+(f+3)|0]|0))&65535)-6|0)<=(b|0)){g=0;return g|0}g=d[e+(b+6+f)|0]|0;return g|0}else if((a<<16>>16|0)==4){h=(((d[e+(f+6)|0]|0)<<8|(d[e+(f+7)|0]|0))&65535)>>>1;i=f+14|0;if((b|0)>65535){g=0;return g|0}j=d[e+(f+11)|0]|0|(d[e+(f+10)|0]|0)<<8;k=((((d[e+(f+13)|0]|0|(d[e+(f+12)|0]|0)<<8)&65535)>>>1&65535)<<1)+i|0;l=((((d[e+k|0]|0)<<8|(d[e+(k+1)|0]|0))&65535|0)>(b|0)?i:k)-2|0;if(j<<16>>16==0){m=l}else{k=l;l=j;j=((d[e+(f+9)|0]|0|(d[e+(f+8)|0]|0)<<8)&65535)>>>1;while(1){n=(j&65535)>>>1;o=((n&65535)<<1)+k|0;p=(((d[e+o|0]|0)<<8|(d[e+(o+1)|0]|0))&65535|0)<(b|0)?o:k;o=l-1&65535;if(o<<16>>16==0){m=p;break}else{k=p;l=o;j=n}}}j=-14-f+2+m&131070;m=j+i|0;if((((d[e+m|0]|0)<<8|(d[e+(m+1)|0]|0))&65535|0)<(b|0)){bT(2680,2752,933,3384);return 0}m=h&65535;h=f+16|0;i=h+(m<<1)+j|0;l=((d[e+i|0]|0)<<8|(d[e+(i+1)|0]|0))&65535;if((l|0)>(b|0)){g=0;return g|0}i=h+(m*6|0)+j|0;k=(d[e+i|0]|0)<<8|(d[e+(i+1)|0]|0);if(k<<16>>16==0){n=h+(m<<2)+j|0;g=(((d[e+n|0]|0)<<8|(d[e+(n+1)|0]|0))&65535)+b&65535;return g|0}else{n=i+(b-l<<1)+(k&65535)|0;g=((d[e+n|0]|0)<<8|(d[e+(n+1)|0]|0))&65535;return g|0}}else if((a<<16>>16|0)==2){bT(2968,2752,895,3384);return 0}else if((a<<16>>16|0)==6){n=((d[e+(f+6)|0]|0)<<8|(d[e+(f+7)|0]|0))&65535;if(n>>>0>b>>>0){g=0;return g|0}if(((((d[e+(f+8)|0]|0)<<8|(d[e+(f+9)|0]|0))&65535)+n|0)>>>0<=b>>>0){g=0;return g|0}k=f+10+(b-n<<1)|0;g=((d[e+k|0]|0)<<8|(d[e+(k+1)|0]|0))&65535;return g|0}else{k=a<<16>>16==12;if((a-12&65535)>>>0>=2>>>0){bT(2968,2752,968,3384);return 0}a=f+16|0;n=(d[e+(f+13)|0]|0)<<16|(d[e+(f+12)|0]|0)<<24|(d[e+(f+14)|0]|0)<<8|(d[e+(f+15)|0]|0);f=0;L3579:while(1){l=n;while(1){if((f|0)>=(l|0)){g=0;q=2803;break L3579}r=(l-f>>1)+f|0;s=a+(r*12|0)|0;t=(d[e+(s+1)|0]|0)<<16|(d[e+s|0]|0)<<24|(d[e+(s+2)|0]|0)<<8|(d[e+(s+3)|0]|0);if(t>>>0>b>>>0){l=r}else{break}}if(((d[e+(s+4)|0]|0)<<24|(d[e+(s+5)|0]|0)<<16|(d[e+(s+6)|0]|0)<<8|(d[e+(s+7)|0]|0))>>>0<b>>>0){n=l;f=r+1|0}else{break}}if((q|0)==2803){return g|0}q=(d[e+(s+9)|0]|0)<<16|(d[e+(s+8)|0]|0)<<24|(d[e+(s+10)|0]|0)<<8|(d[e+(s+11)|0]|0);if(!k){g=q;return g|0}g=b-t+q|0;return g|0}return 0}function eB(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0.0,ax=0.0,ay=0,az=0.0,aA=0.0,aB=0.0,aC=0.0,aD=0,aE=0.0,aF=0.0,aG=0.0,aH=0.0,aI=0,aJ=0,aK=0;h=i;i=i+8|0;j=h|0;k=c[e+4>>2]|0;l=eD(e,f)|0;c[g>>2]=0;if((l|0)<0){m=0;i=h;return m|0}f=d[k+l|0]<<8|d[k+(l+1)|0];L3604:do{if(f<<16>>16>0){n=l+10|0;o=f<<16>>16<<1;p=o+n|0;q=a[k+p|0]|0;r=a[k+(p+1)|0]|0;s=((d[k+(p-2)|0]<<8|d[k+(p-1)|0])&65535)+1|0;t=fs((s+o|0)*10|0)|0;u=t;if((t|0)==0){m=0;i=h;return m|0}t=k+(p+2+(((q&255)<<8|r&255)&65535))|0;r=0;q=0;p=0;while(1){do{if(q<<24>>24==0){v=t+1|0;w=a[t]|0;if((w&8)==0){x=w;y=0;z=v;break}x=w;y=a[v]|0;z=t+2|0}else{x=p;y=q-1&255;z=t}}while(0);a[u+((r+o|0)*10|0)+8|0]=x;v=r+1|0;if((v|0)<(s|0)){t=z;r=v;q=y;p=x}else{A=0;B=z;C=0;break}}while(1){p=C+o|0;q=d[u+(p*10|0)+8|0]|0;do{if((q&2|0)==0){if((q&16|0)!=0){D=B;E=A;break}D=B+2|0;E=((d[B]<<8|d[B+1|0])<<16>>16)+A|0}else{r=d[B]|0;D=B+1|0;E=((q&16|0)!=0?r:-r|0)+A|0}}while(0);b[u+(p*10|0)>>1]=E&65535;q=C+1|0;if((q|0)<(s|0)){A=E;B=D;C=q}else{F=0;G=D;H=0;break}}while(1){q=H+o|0;r=d[u+(q*10|0)+8|0]|0;do{if((r&4|0)==0){if((r&32|0)!=0){I=G;J=F;break}I=G+2|0;J=((d[G]<<8|d[G+1|0])<<16>>16)+F|0}else{t=d[G]|0;I=G+1|0;J=((r&32|0)!=0?t:-t|0)+F|0}}while(0);b[u+(q*10|0)+2>>1]=J&65535;r=H+1|0;if((r|0)<(s|0)){F=J;G=I;H=r}else{K=0;L=0;M=0;N=0;O=0;Q=0;R=0;S=0;T=0;U=0;V=0;W=0;break}}while(1){r=V+o|0;p=a[u+(r*10|0)+8|0]|0;t=b[u+(r*10|0)>>1]|0;v=t<<16>>16;w=b[u+(r*10|0)+2>>1]|0;X=w<<16>>16;do{if((T|0)==(V|0)){if((V|0)==0){Y=W}else{Y=eE(u,W,S,K,N,O,Q,R,L,M)|0}Z=p&1;_=(Z^1)&255;do{if(Z<<24>>24==0){$=r+1|0;aa=b[u+($*10|0)>>1]|0;if((a[u+($*10|0)+8|0]&1)==0){ab=V;ac=X;ad=v;ae=(b[u+($*10|0)+2>>1]|0)+X>>1;af=aa+v>>1;break}else{ab=V+1|0;ac=X;ad=v;ae=b[u+($*10|0)+2>>1]|0;af=aa;break}}else{ab=V;ac=R;ad=Q;ae=X;af=v}}while(0);a[u+(Y*10|0)+8|0]=1;b[u+(Y*10|0)>>1]=af&65535;b[u+(Y*10|0)+2>>1]=ae&65535;b[u+(Y*10|0)+4>>1]=0;b[u+(Y*10|0)+6>>1]=0;Z=(U<<1)+n|0;ag=Y+1|0;ah=ab;ai=U+1|0;aj=((d[k+Z|0]<<8|d[k+(Z+1)|0])&65535)+1|0;ak=0;al=ac;am=ad;an=ae;ao=af;ap=M;aq=L;ar=_}else{Z=(S|0)!=0;if((p&1)==0){if(!Z){ag=W;ah=V;ai=U;aj=T;ak=1;al=R;am=Q;an=O;ao=N;ap=X;aq=v;ar=K;break}a[u+(W*10|0)+8|0]=3;b[u+(W*10|0)>>1]=(v+L|0)>>>1&65535;b[u+(W*10|0)+2>>1]=(X+M|0)>>>1&65535;b[u+(W*10|0)+4>>1]=L&65535;b[u+(W*10|0)+6>>1]=M&65535;ag=W+1|0;ah=V;ai=U;aj=T;ak=1;al=R;am=Q;an=O;ao=N;ap=X;aq=v;ar=K;break}aa=W+1|0;$=u+(W*10|0)|0;as=u+(W*10|0)+8|0;if(Z){a[as]=3;b[$>>1]=t;b[u+(W*10|0)+2>>1]=w;b[u+(W*10|0)+4>>1]=L&65535;b[u+(W*10|0)+6>>1]=M&65535;ag=aa;ah=V;ai=U;aj=T;ak=0;al=R;am=Q;an=O;ao=N;ap=M;aq=L;ar=K;break}else{a[as]=2;b[$>>1]=t;b[u+(W*10|0)+2>>1]=w;b[u+(W*10|0)+4>>1]=0;b[u+(W*10|0)+6>>1]=0;ag=aa;ah=V;ai=U;aj=T;ak=0;al=R;am=Q;an=O;ao=N;ap=M;aq=L;ar=K;break}}}while(0);w=ah+1|0;if((w|0)<(s|0)){K=ar;L=aq;M=ap;N=ao;O=an;Q=am;R=al;S=ak;T=aj;U=ai;V=w;W=ag}else{break}}at=u;au=eE(u,ag,ak,ar,ao,an,am,al,aq,ap)|0}else{if(f<<16>>16!=-1){if(f<<16>>16>=0){at=0;au=0;break}bT(2968,2752,1263,3360);return 0}s=k+(l+10)|0;n=0;o=0;while(1){c[j>>2]=0;w=d[s+2|0]<<8|d[s+3|0];t=(d[s]<<8|d[s+1|0])&65535;if((t&2|0)==0){av=2848;break}v=a[s+4|0]|0;if((t&1|0)==0){aw=+(v<<24>>24|0);ax=+(a[s+5|0]|0);ay=s+6|0}else{aw=+((d[s+5|0]|(v&255)<<8)<<16>>16|0);ax=+((d[s+6|0]<<8|d[s+7|0])<<16>>16|0);ay=s+8|0}do{if((t&8|0)==0){if((t&64|0)!=0){az=+((d[ay]<<8|d[ay+1|0])<<16>>16|0)*6103515625.0e-14;aA=0.0;aB=0.0;aC=+((d[ay+2|0]<<8|d[ay+3|0])<<16>>16|0)*6103515625.0e-14;aD=ay+4|0;break}if((t&128|0)==0){az=1.0;aA=0.0;aB=0.0;aC=1.0;aD=ay;break}az=+((d[ay]<<8|d[ay+1|0])<<16>>16|0)*6103515625.0e-14;aA=+((d[ay+2|0]<<8|d[ay+3|0])<<16>>16|0)*6103515625.0e-14;aB=+((d[ay+4|0]<<8|d[ay+5|0])<<16>>16|0)*6103515625.0e-14;aC=+((d[ay+6|0]<<8|d[ay+7|0])<<16>>16|0)*6103515625.0e-14;aD=ay+8|0}else{aE=+((d[ay]<<8|d[ay+1|0])<<16>>16|0)*6103515625.0e-14;az=aE;aA=0.0;aB=0.0;aC=aE;aD=ay+2|0}}while(0);aE=+P(aA*aA+az*az);aF=+P(aC*aC+aB*aB);v=eB(e,w&65535,j)|0;if((v|0)>0){X=c[j>>2]|0;p=0;do{r=X+(p*10|0)|0;q=X+(p*10|0)+2|0;aG=+(b[r>>1]|0);aH=+(b[q>>1]|0);b[r>>1]=~~(aE*(aw+(az*aG+aB*aH)));b[q>>1]=~~(aF*(ax+(aA*aG+aC*aH)));q=X+(p*10|0)+4|0;r=X+(p*10|0)+6|0;aH=+(b[q>>1]|0);aG=+(b[r>>1]|0);b[q>>1]=~~(aE*(aw+(az*aH+aB*aG)));b[r>>1]=~~(aF*(ax+(aA*aH+aC*aG)));p=p+1|0;}while((p|0)<(v|0));p=v+n|0;X=fs(p*10|0)|0;w=X;if((X|0)==0){break}if((n|0)>0){r=o;q=n*10|0;fG(X|0,r|0,q)|0}q=w+(n*10|0)|0;r=c[j>>2]|0;X=r;aa=v*10|0;fG(q|0,X|0,aa)|0;if((o|0)==0){aI=r}else{ft(o);aI=c[j>>2]|0}ft(aI);aJ=w;aK=p}else{aJ=o;aK=n}if((t&32|0)==0){at=aJ;au=aK;break L3604}else{s=aD;n=aK;o=aJ}}if((av|0)==2848){bT(2968,2752,1210,3360);return 0}if((o|0)!=0){ft(o)}n=c[j>>2]|0;if((n|0)==0){m=0;i=h;return m|0}ft(n);m=0;i=h;return m|0}}while(0);c[g>>2]=at;m=au;i=h;return m|0}function eC(a,b,e,f,g,h){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0;i=eD(a,b)|0;if((i|0)<0){j=0;return j|0}if((e|0)!=0){b=c[a+4>>2]|0;c[e>>2]=((d[b+(i+2)|0]|0)<<8|(d[b+(i+3)|0]|0))<<16>>16}if((f|0)!=0){b=c[a+4>>2]|0;c[f>>2]=((d[b+(i+4)|0]|0)<<8|(d[b+(i+5)|0]|0))<<16>>16}if((g|0)!=0){b=c[a+4>>2]|0;c[g>>2]=((d[b+(i+6)|0]|0)<<8|(d[b+(i+7)|0]|0))<<16>>16}if((h|0)==0){j=1;return j|0}b=c[a+4>>2]|0;c[h>>2]=((d[b+(i+8)|0]|0)<<8|(d[b+(i+9)|0]|0))<<16>>16;j=1;return j|0}function eD(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;if((c[a+12>>2]|0)<=(b|0)){e=-1;return e|0}f=c[a+44>>2]|0;if((f|0)>1){e=-1;return e|0}g=c[a+24>>2]|0;h=c[a+4>>2]|0;i=c[a+16>>2]|0;if((f|0)==0){f=i+(b<<1)|0;j=(((d[h+f|0]|0)<<8|(d[h+(f+1)|0]|0))&65535)<<1;k=(((d[h+(f+2)|0]|0)<<8|(d[h+(f+3)|0]|0))&65535)<<1}else{f=i+(b<<2)|0;j=(d[h+(f+1)|0]|0)<<16|(d[h+f|0]|0)<<24|(d[h+(f+2)|0]|0)<<8|(d[h+(f+3)|0]|0);k=(d[h+(f+5)|0]|0)<<16|(d[h+(f+4)|0]|0)<<24|(d[h+(f+6)|0]|0)<<8|(d[h+(f+7)|0]|0)}f=j+g|0;e=(f|0)==(k+g|0)?-1:f;return e|0}function eE(c,d,e,f,g,h,i,j,k,l){c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;m=(e|0)!=0;if((f|0)!=0){if(m){a[c+(d*10|0)+8|0]=3;b[c+(d*10|0)>>1]=(k+i|0)>>>1&65535;b[c+(d*10|0)+2>>1]=(l+j|0)>>>1&65535;b[c+(d*10|0)+4>>1]=k&65535;b[c+(d*10|0)+6>>1]=l&65535;n=d+1|0}else{n=d}a[c+(n*10|0)+8|0]=3;b[c+(n*10|0)>>1]=g&65535;b[c+(n*10|0)+2>>1]=h&65535;b[c+(n*10|0)+4>>1]=i&65535;b[c+(n*10|0)+6>>1]=j&65535;o=n+1|0;return o|0}n=d+1|0;j=c+(d*10|0)|0;i=c+(d*10|0)+8|0;if(m){a[i]=3;b[j>>1]=g&65535;b[c+(d*10|0)+2>>1]=h&65535;b[c+(d*10|0)+4>>1]=k&65535;b[c+(d*10|0)+6>>1]=l&65535;o=n;return o|0}else{a[i]=2;b[j>>1]=g&65535;b[c+(d*10|0)+2>>1]=h&65535;b[c+(d*10|0)+4>>1]=0;b[c+(d*10|0)+6>>1]=0;o=n;return o|0}return 0}function eF(a,b,e,f){a=a|0;b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;g=a+4|0;h=c[g>>2]|0;i=c[a+28>>2]|0;j=((d[h+(i+34)|0]|0)<<8|(d[h+(i+35)|0]|0))&65535;i=(e|0)!=0;if((j|0)>(b|0)){if(i){k=(c[a+32>>2]|0)+(b<<2)|0;c[e>>2]=((d[h+k|0]|0)<<8|(d[h+(k+1)|0]|0))<<16>>16}if((f|0)==0){return}k=c[g>>2]|0;l=(c[a+32>>2]|0)+(b<<2)|0;c[f>>2]=((d[k+(l+2)|0]|0)<<8|(d[k+(l+3)|0]|0))<<16>>16;return}else{if(i){i=(j<<2)-4+(c[a+32>>2]|0)|0;c[e>>2]=((d[h+i|0]|0)<<8|(d[h+(i+1)|0]|0))<<16>>16}if((f|0)==0){return}i=c[g>>2]|0;g=(b-j<<1)+(j<<2)+(c[a+32>>2]|0)|0;c[f>>2]=((d[i+g|0]|0)<<8|(d[i+(g+1)|0]|0))<<16>>16;return}}function eG(a,b,d,e,f,g,h,j,k,l){a=a|0;b=b|0;d=+d;e=+e;f=+f;g=+g;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0;m=i;i=i+32|0;n=m|0;o=m+8|0;p=m+16|0;q=m+24|0;if((eC(a,b,n,o,p,q)|0)==0){c[q>>2]=0;c[p>>2]=0;c[o>>2]=0;c[n>>2]=0}if((h|0)!=0){c[h>>2]=~~+N(+(c[n>>2]|0)*d+f)}if((j|0)!=0){c[j>>2]=-~~+_(+(c[q>>2]|0)*e+g)}if((k|0)!=0){c[k>>2]=~~+_(+(c[p>>2]|0)*d+f)}if((l|0)==0){i=m;return}c[l>>2]=-~~+N(+(c[o>>2]|0)*e+g);i=m;return}function eH(e,f,h,j,k,l){e=e|0;f=f|0;h=+h;j=j|0;k=k|0;l=l|0;var m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0,G=0,H=0.0,I=0.0,J=0,K=0,L=0,M=0;l=i;i=i+8|0;m=l|0;c[m>>2]=0;n=h*h;o=(f|0)>0;if(o){p=0;q=0}else{c[k>>2]=0;r=0;i=l;return r|0}do{q=((a[e+(p*10|0)+8|0]|0)==1)+q|0;p=p+1|0;}while((p|0)<(f|0));c[k>>2]=q;if((q|0)==0){r=0;i=l;return r|0}p=fs(q<<2)|0;c[j>>2]=p;if((p|0)==0){c[k>>2]=0;r=0;i=l;return r|0}else{s=0;t=0;u=0}while(1){if((u|0)==1){p=fs(c[m>>2]<<3)|0;if((p|0)==0){break}else{v=p}}else{v=s}c[m>>2]=0;if(o){p=(v|0)==0;q=0;w=-1;x=t;h=0.0;y=0.0;while(1){z=e+(q*10|0)|0;A=d[e+(q*10|0)+8|0]|0;do{if((A|0)==3){B=z|0;C=e+(q*10|0)+2|0;eI(v,m,h,y,+(b[e+(q*10|0)+4>>1]|0),+(b[e+(q*10|0)+6>>1]|0),+(b[B>>1]|0),+(b[C>>1]|0),n,0);D=+(b[C>>1]|0);E=+(b[B>>1]|0);F=x;G=w}else if((A|0)==1){if((w|0)>-1){c[(c[j>>2]|0)+(w<<2)>>2]=(c[m>>2]|0)-x}B=w+1|0;C=c[m>>2]|0;H=+(b[z>>1]|0);I=+(b[e+(q*10|0)+2>>1]|0);c[m>>2]=C+1;if(p){D=I;E=H;F=C;G=B;break}g[v+(C<<3)>>2]=H;g[v+(C<<3)+4>>2]=I;D=I;E=H;F=C;G=B}else if((A|0)==2){H=+(b[z>>1]|0);I=+(b[e+(q*10|0)+2>>1]|0);B=c[m>>2]|0;c[m>>2]=B+1;if(p){D=I;E=H;F=x;G=w;break}g[v+(B<<3)>>2]=H;g[v+(B<<3)+4>>2]=I;D=I;E=H;F=x;G=w}else{D=y;E=h;F=x;G=w}}while(0);z=q+1|0;if((z|0)<(f|0)){q=z;w=G;x=F;h=E;y=D}else{break}}J=G;K=F;L=c[m>>2]|0}else{J=-1;K=t;L=0}c[(c[j>>2]|0)+(J<<2)>>2]=L-K;x=u+1|0;if((x|0)<2){s=v;t=K;u=x}else{r=v;M=2966;break}}if((M|0)==2966){i=l;return r|0}ft(c[j>>2]|0);c[j>>2]=0;c[k>>2]=0;r=0;i=l;return r|0}function eI(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=+d;e=+e;f=+f;h=+h;i=+i;j=+j;k=+k;l=l|0;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0;m=(f*2.0+d+i)*.25;n=(h*2.0+e+j)*.25;if((l|0)>16){return}o=d;p=e;q=f;f=h;r=l;h=m;s=n;t=(i+d)*.5-m;m=(j+e)*.5-n;while(1){if(t*t+m*m<=k){break}l=r+1|0;eI(a,b,o,p,(o+q)*.5,(p+f)*.5,h,s,k,l);n=(q+i)*.5;e=(f+j)*.5;d=(h+n*2.0+i)*.25;u=(s+e*2.0+j)*.25;v=(h+i)*.5-d;w=(s+j)*.5-u;if((l|0)>16){x=2977;break}else{o=h;p=s;q=n;f=e;r=l;h=d;s=u;t=v;m=w}}if((x|0)==2977){return}x=c[b>>2]|0;if((a|0)==0){y=x}else{g[a+(x<<3)>>2]=i;g[a+(x<<3)+4>>2]=j;y=c[b>>2]|0}c[b>>2]=y+1;return}function eJ(b,e,f,h,j,k,l,m,n,o,p,q){b=b|0;e=+e;f=f|0;h=h|0;j=+j;k=+k;l=+l;m=+m;n=n|0;o=o|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0.0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0;q=i;i=i+536|0;r=q|0;s=q+8|0;t=q+520|0;u=q+528|0;v=eH(f,h,e/(j>k?k:j),u,t,0)|0;if((v|0)==0){i=q;return}h=c[u>>2]|0;f=c[t>>2]|0;t=(p|0)!=0;if(t){w=-0.0-k}else{w=k}p=b+4|0;x=(c[p>>2]|0)<8?15:5;y=(f|0)>0;if(y){z=0;A=0;do{A=(c[h+(z<<2)>>2]|0)+A|0;z=z+1|0;}while((z|0)<(f|0));B=(A*20|0)+20|0}else{B=20}A=fs(B)|0;B=A;if((A|0)==0){C=h}else{if(y){k=+(x|0);y=0;z=0;D=0;while(1){E=c[h+(z<<2)>>2]|0;F=E+y|0;if((E|0)>0){G=E-1|0;H=0;I=D;while(1){e=+g[v+(G+y<<3)+4>>2];J=+g[v+(H+y<<3)+4>>2];if(e==J){K=I}else{L=B+(I*20|0)+16|0;c[L>>2]=0;if(t){if(e>J){M=2993}else{O=G;P=H}}else{if(e<J){M=2993}else{O=G;P=H}}if((M|0)==2993){M=0;c[L>>2]=1;O=H;P=G}L=P+y|0;g[B+(I*20|0)>>2]=+g[v+(L<<3)>>2]*j+l;g[B+(I*20|0)+4>>2]=k*w*+g[v+(L<<3)+4>>2]+m;L=O+y|0;g[B+(I*20|0)+8>>2]=+g[v+(L<<3)>>2]*j+l;g[B+(I*20|0)+12>>2]=k*w*+g[v+(L<<3)+4>>2]+m;K=I+1|0}L=H+1|0;if((L|0)<(E|0)){G=H;H=L;I=K}else{Q=K;break}}}else{Q=D}I=z+1|0;if((I|0)<(f|0)){y=F;z=I;D=Q}else{R=Q;break}}}else{R=0}bo(A|0,R|0,20,4);Q=s|0;c[r>>2]=0;s=255/(x>>>0)|0;D=b|0;z=c[D>>2]|0;if((z|0)>512){S=fs(z)|0}else{S=Q}y=c[p>>2]|0;g[B+(R*20|0)+4>>2]=+(x|0)*+(y+o|0)+1.0;do{if((y|0)>0){R=b+12|0;f=b+8|0;K=n<<10;O=0;P=$(x,o)|0;t=B;h=0;I=z;L3865:while(1){fF(S|0,0,I|0);H=0;G=P;E=t;L=h;while(1){m=+(G|0)+.5;L3869:do{if((L|0)==0){T=0;U=r}else{V=r;W=L;while(1){X=W;while(1){if(+g[X+8>>2]>m){break}c[V>>2]=c[X+12>>2];if((c[X+16>>2]|0)==0){M=3007;break L3865}ft(X);Y=c[V>>2]|0;if((Y|0)==0){T=0;U=r;break L3869}else{X=Y}}Y=X|0;c[Y>>2]=(c[Y>>2]|0)+(c[X+4>>2]|0);Y=(c[V>>2]|0)+12|0;Z=c[Y>>2]|0;if((Z|0)==0){T=0;U=r;break}else{V=Y;W=Z}}}}while(0);L3877:while(1){W=c[U>>2]|0;do{if((W|0)!=0){V=W+12|0;Z=c[V>>2]|0;if((Z|0)==0){break}if((c[W>>2]|0)>(c[Z>>2]|0)){Y=Z+12|0;c[V>>2]=c[Y>>2];c[Y>>2]=W;c[U>>2]=Z;_=1;aa=Z}else{_=T;aa=W}T=_;U=aa+12|0;continue L3877}}while(0);if((T|0)==0){break}else{T=0;U=r}}W=E+4|0;if(+g[W>>2]>m){ab=E}else{Z=E;Y=W;while(1){W=Z+12|0;do{if(+g[W>>2]>m){V=fs(20)|0;ac=V;w=+g[Z>>2];k=+g[W>>2];l=+g[Y>>2];j=(+g[Z+8>>2]-w)/(k-l);if(l>m){M=3019;break L3865}if((V|0)==0){ad=0}else{if(j<0.0){c[V+4>>2]=-~~+N(j*-1024.0)}else{c[V+4>>2]=~~+N(j*1024.0)}ae=~~+N((w+j*(m-l))*1024.0)-K|0;c[V>>2]=ae;g[V+8>>2]=k;c[V+12>>2]=0;c[V+16>>2]=(c[Z+16>>2]|0)!=0?1:-1;ad=ae}ae=c[r>>2]|0;if((ae|0)==0){c[r>>2]=ac;break}if((ad|0)<(c[ae>>2]|0)){c[V+12>>2]=ae;c[r>>2]=ac;break}else{af=ae}while(1){ag=af+12|0;ae=c[ag>>2]|0;if((ae|0)==0){ah=0;break}if((c[ae>>2]|0)<(ad|0)){af=ae}else{ah=ae;break}}c[V+12>>2]=ah;c[ag>>2]=ac}}while(0);W=Z+20|0;X=Z+24|0;if(+g[X>>2]>m){ab=W;break}else{Z=W;Y=X}}}ai=c[r>>2]|0;aj=(ai|0)==0;if(!aj){Y=c[D>>2]|0;Z=0;X=0;W=ai;while(1){ae=c[W>>2]|0;ak=(c[W+16>>2]|0)+X|0;do{if((X|0)==0){al=ae}else{if((ak|0)!=0){al=Z;break}am=Z>>10;an=ae>>10;if(!((am|0)<(Y|0)&(an|0)>-1)){al=Z;break}if((am|0)==(an|0)){ao=S+am|0;a[ao]=(d[ao]|0)+(($(ae-Z|0,s)|0)>>>10)&255;al=Z;break}if((am|0)>-1){ao=S+am|0;a[ao]=(d[ao]|0)+(($(1024-(Z&1023)|0,s)|0)>>>10)&255;ap=am+1|0}else{ap=0}if((an|0)<(Y|0)){am=S+an|0;a[am]=(d[am]|0)+(($(ae&1023,s)|0)>>>10)&255;aq=an}else{aq=Y}if((ap|0)<(aq|0)){ar=ap}else{al=Z;break}while(1){an=S+ar|0;a[an]=(d[an]|0)+s&255;an=ar+1|0;if((an|0)<(aq|0)){ar=an}else{al=Z;break}}}}while(0);ae=c[W+12>>2]|0;if((ae|0)==0){break}else{Z=al;X=ak;W=ae}}}as=G+1|0;W=H+1|0;if((W|0)<(x|0)){H=W;G=as;E=ab;L=ai}else{break}}L=c[D>>2]|0;E=(c[R>>2]|0)+($(c[f>>2]|0,O)|0)|0;fG(E|0,S|0,L)|0;L=O+1|0;if((L|0)>=(c[p>>2]|0)){M=3001;break}O=L;P=as;t=ab;h=ai;I=c[D>>2]|0}if((M|0)==3001){if(aj){break}else{at=ai}while(1){I=c[at+12>>2]|0;ft(at);if((I|0)==0){break}else{at=I}}c[r>>2]=0;break}else if((M|0)==3007){bT(2544,2752,1499,3448)}else if((M|0)==3019){bT(2512,2752,1410,3648)}}}while(0);if((S|0)!=(Q|0)){ft(S)}ft(A);C=c[u>>2]|0}ft(C);ft(v);i=q;return}function eK(a,b,d,e,f,g,h,j,k,l){a=a|0;b=+b;d=+d;e=+e;f=+f;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0,w=0.0,x=0,y=0;m=i;i=i+56|0;n=m|0;o=m+8|0;p=m+16|0;q=m+24|0;r=m+32|0;s=m+48|0;t=eB(a,g,s)|0;u=b==0.0?d:b;do{if(d==0.0){if(u==0.0){v=0}else{w=u;break}i=m;return v|0}else{w=d}}while(0);eG(a,g,u,w,e,f,n,o,p,q);g=c[p>>2]|0;p=c[n>>2]|0;n=g-p|0;c[r>>2]=n;a=c[q>>2]|0;q=c[o>>2]|0;o=a-q|0;c[r+4>>2]=o;x=r+12|0;c[x>>2]=0;if((h|0)!=0){c[h>>2]=n}if((j|0)!=0){c[j>>2]=o}if((k|0)!=0){c[k>>2]=p}if((l|0)!=0){c[l>>2]=q}do{if((g|0)==(p|0)|(a|0)==(q|0)){y=0}else{l=fs($(o,n)|0)|0;c[x>>2]=l;if((l|0)==0){y=0;break}c[r+8>>2]=n;eJ(r,.3499999940395355,c[s>>2]|0,t,u,w,e,f,p,q,1,0);y=c[x>>2]|0}}while(0);ft(c[s>>2]|0);v=y;i=m;return v|0}function eL(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+200|0;e=d|0;f=d+184|0;g=d+192|0;c[e+16>>2]=0;c[e+32>>2]=0;c[e+176>>2]=a;c[e+168>>2]=a;c[e+172>>2]=a+b;b=eu(e,f,g,0,4)|0;e=fx(24)|0;dK(e,c[f>>2]|0,c[g>>2]|0,b);ft(b);i=d;return e|0}function eM(b,e,f,h,j){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;e=i;i=i+144|0;k=f;f=i;i=i+16|0;c[f>>2]=c[k>>2];c[f+4>>2]=c[k+4>>2];c[f+8>>2]=c[k+8>>2];c[f+12>>2]=c[k+12>>2];k=e|0;l=e+48|0;m=e+56|0;n=e+64|0;o=e+72|0;p=e+80|0;q=e+88|0;r=e+96|0;s=e+104|0;t=e+112|0;u=e+120|0;v=e+128|0;w=e+136|0;ey(k,b,ex(b,0)|0)|0;x=+(h|0)*1.25;h=~~x;b=c[k+4>>2]|0;y=c[k+28>>2]|0;z=d[b+(y+6)|0]<<8|d[b+(y+7)|0];A=x/+(((d[b+(y+4)|0]<<8|d[b+(y+5)|0])<<16>>16)-(z<<16>>16)|0);y=~~(A*+(z<<16>>16|0));z=a[j]|0;if(z<<24>>24==0){B=0;C=0}else{b=0;D=0;E=j;F=z;do{ft(eK(k,A,A,0.0,0.0,eA(k,F<<24>>24)|0,l,m,n,o)|0);eF(k,eA(k,a[E]|0)|0,p,q);z=~~(A*+(c[p>>2]|0));c[p>>2]=z;c[q>>2]=~~(A*+(c[q>>2]|0));G=(c[n>>2]|0)+(c[l>>2]|0)|0;D=((G|0)<(z|0)?z:G)+D|0;b=b+1|0;E=j+b|0;F=a[E]|0;}while(F<<24>>24!=0);B=D;C=a[j]|0}D=$(h<<2,B)|0;F=fs(D)|0;fF(F|0,0,D|0);if(C<<24>>24!=0){D=y+h|0;y=~~(+g[f>>2]*255.0);E=~~(+g[f+4>>2]*255.0);b=~~(+g[f+8>>2]*255.0);f=0;l=0;n=j;q=C;while(1){C=eK(k,A,A,0.0,0.0,eA(k,q<<24>>24)|0,r,s,t,u)|0;eF(k,eA(k,a[n]|0)|0,v,w);p=~~(A*+(c[v>>2]|0));c[v>>2]=p;o=~~(A*+(c[w>>2]|0));c[w>>2]=o;m=(c[t>>2]|0)+l|0;G=c[r>>2]|0;if((G|0)>0){z=D+(c[u>>2]|0)|0;H=c[s>>2]|0;I=0;do{if((H|0)>0){J=I+m|0;K=(J|0)>-1&(J|0)<(B|0);L=0;do{do{if(K){M=z+L|0;if(!((M|0)>-1&(M|0)<(h|0))){break}N=($(M,B)|0)+J<<2;a[F+N|0]=y;a[F+(N|1)|0]=E;a[F+(N|2)|0]=b;M=F+(N|3)|0;N=(d[C+(($(G,L)|0)+I)|0]|0)+(d[M]|0)|0;a[M]=(N|0)<255?N&255:-1}}while(0);L=L+1|0;}while((L|0)<(H|0))}I=I+1|0;}while((I|0)<(G|0))}ft(C);G=f+1|0;I=j+G|0;H=a[I]|0;if(H<<24>>24==0){break}else{f=G;l=p+m-o|0;n=I;q=H}}}q=fx(24)|0;dK(q,B,h,F);ft(F);i=e;return q|0}function eN(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0;c=+g[a+4>>2];d=+g[b+4>>2];if(c<d){e=-1;return e|0}e=c>d|0;return e|0}function eO(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=b+168|0;e=c[d>>2]|0;f=b+172|0;if(e>>>0<(c[f>>2]|0)>>>0){c[d>>2]=e+1;g=a[e]|0;return g|0}e=b+32|0;if((c[e>>2]|0)==0){g=0;return g|0}h=b+40|0;i=cl[c[b+16>>2]&3](c[b+28>>2]|0,h,c[b+36>>2]|0)|0;if((i|0)==0){c[e>>2]=0;e=(c[f>>2]|0)-1|0;c[d>>2]=e;a[e]=0;j=c[d>>2]|0}else{c[d>>2]=h;c[f>>2]=b+40+i;j=h}c[d>>2]=j+1;g=a[j]|0;return g|0}function eP(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=b+168|0;f=c[e>>2]|0;g=b+172|0;if(f>>>0<(c[g>>2]|0)>>>0){c[e>>2]=f+1;h=d[f]|0;return h|0}f=b+32|0;if((c[f>>2]|0)==0){h=0;return h|0}i=b+40|0;j=cl[c[b+16>>2]&3](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if((j|0)==0){c[f>>2]=0;f=(c[g>>2]|0)-1|0;c[e>>2]=f;a[f]=0;k=c[e>>2]|0}else{c[e>>2]=i;c[g>>2]=b+40+j;k=i}c[e>>2]=k+1;h=d[k]|0;return h|0}function eQ(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=(eP(b)|0)&255;L4029:do{if((eR(b)|0)!=0|d<<24>>24==10){e=0}else{f=0;g=d;while(1){h=f+1|0;a[c+f|0]=g;if((h|0)==1023){break}i=(eP(b)|0)&255;if((eR(b)|0)!=0|i<<24>>24==10){e=h;break L4029}else{f=h;g=i}}while(1){if((eR(b)|0)!=0){e=1023;break L4029}if((eP(b)|0)==10){e=1023;break}}}}while(0);a[c+e|0]=0;return c|0}function eR(a){a=a|0;var b=0;do{if((c[a+16>>2]|0)!=0){if((cf[c[a+24>>2]&15](c[a+28>>2]|0)|0)==0){b=0;return b|0}if((c[a+32>>2]|0)==0){b=1}else{break}return b|0}}while(0);b=(c[a+168>>2]|0)>>>0>=(c[a+172>>2]|0)>>>0|0;return b|0}function eS(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;h=b+168|0;i=c[h>>2]|0;j=b+172|0;do{if(i>>>0<(c[j>>2]|0)>>>0){k=i;l=6}else{m=b+32|0;if((c[m>>2]|0)==0){break}n=b+40|0;o=cl[c[b+16>>2]&3](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[j>>2]|0)-1|0;c[h>>2]=m;a[m]=0;k=c[h>>2]|0;l=6;break}else{c[h>>2]=n;c[j>>2]=b+40+o;k=n;l=6;break}}}while(0);L7:do{if((l|0)==6){i=k+1|0;c[h>>2]=i;if((a[k]|0)!=71){break}do{if(i>>>0<(c[j>>2]|0)>>>0){p=i}else{n=b+32|0;if((c[n>>2]|0)==0){break L7}o=b+40|0;m=cl[c[b+16>>2]&3](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((m|0)==0){c[n>>2]=0;n=(c[j>>2]|0)-1|0;c[h>>2]=n;a[n]=0;p=c[h>>2]|0;break}else{c[h>>2]=o;c[j>>2]=b+40+m;p=o;break}}}while(0);i=p+1|0;c[h>>2]=i;if((a[p]|0)!=73){break}do{if(i>>>0<(c[j>>2]|0)>>>0){q=i}else{o=b+32|0;if((c[o>>2]|0)==0){break L7}m=b+40|0;n=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((n|0)==0){c[o>>2]=0;o=(c[j>>2]|0)-1|0;c[h>>2]=o;a[o]=0;q=c[h>>2]|0;break}else{c[h>>2]=m;c[j>>2]=b+40+n;q=m;break}}}while(0);i=q+1|0;c[h>>2]=i;if((a[q]|0)!=70){break}do{if(i>>>0<(c[j>>2]|0)>>>0){r=i}else{m=b+32|0;if((c[m>>2]|0)==0){break L7}n=b+40|0;o=cl[c[b+16>>2]&3](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[j>>2]|0)-1|0;c[h>>2]=m;a[m]=0;r=c[h>>2]|0;break}else{c[h>>2]=n;c[j>>2]=b+40+o;r=n;break}}}while(0);i=r+1|0;c[h>>2]=i;if((a[r]|0)!=56){break}do{if(i>>>0<(c[j>>2]|0)>>>0){s=i;l=31}else{n=b+32|0;if((c[n>>2]|0)==0){break}o=b+40|0;m=cl[c[b+16>>2]&3](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((m|0)==0){c[n>>2]=0;n=(c[j>>2]|0)-1|0;c[h>>2]=n;a[n]=0;s=c[h>>2]|0;l=31;break}else{c[h>>2]=o;c[j>>2]=b+40+m;s=o;l=31;break}}}while(0);do{if((l|0)==31){i=s+1|0;c[h>>2]=i;o=a[s]|0;if(!((o<<24>>24|0)==55|(o<<24>>24|0)==57)){break}do{if(i>>>0<(c[j>>2]|0)>>>0){t=i;l=38}else{o=b+32|0;if((c[o>>2]|0)==0){break}m=b+40|0;n=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((n|0)==0){c[o>>2]=0;o=(c[j>>2]|0)-1|0;c[h>>2]=o;a[o]=0;t=c[h>>2]|0;l=38;break}else{c[h>>2]=m;c[j>>2]=b+40+n;t=m;l=38;break}}}while(0);do{if((l|0)==38){c[h>>2]=t+1;if((a[t]|0)!=97){break}c[2832]=6688;i=c[h>>2]|0;m=c[j>>2]|0;do{if(i>>>0<m>>>0){n=i+1|0;c[h>>2]=n;u=d[i]|0;v=n;w=m}else{n=b+32|0;if((c[n>>2]|0)==0){u=0;v=i;w=m;break}o=b+40|0;x=cl[c[b+16>>2]&3](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((x|0)==0){c[n>>2]=0;n=(c[j>>2]|0)-1|0;c[h>>2]=n;a[n]=0;y=c[h>>2]|0;z=c[j>>2]|0}else{c[h>>2]=o;n=b+40+x|0;c[j>>2]=n;y=o;z=n}n=y+1|0;c[h>>2]=n;u=d[y]|0;v=n;w=z}}while(0);do{if(v>>>0<w>>>0){c[h>>2]=v+1;A=d[v]|0}else{m=b+32|0;if((c[m>>2]|0)==0){A=0;break}i=b+40|0;n=cl[c[b+16>>2]&3](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if((n|0)==0){c[m>>2]=0;m=(c[j>>2]|0)-1|0;c[h>>2]=m;a[m]=0;B=c[h>>2]|0}else{c[h>>2]=i;c[j>>2]=b+40+n;B=i}c[h>>2]=B+1;A=d[B]|0}}while(0);c[e>>2]=A<<8|u;i=c[h>>2]|0;n=c[j>>2]|0;do{if(i>>>0<n>>>0){m=i+1|0;c[h>>2]=m;C=d[i]|0;D=m;E=n}else{m=b+32|0;if((c[m>>2]|0)==0){C=0;D=i;E=n;break}o=b+40|0;x=cl[c[b+16>>2]&3](c[b+28>>2]|0,o,c[b+36>>2]|0)|0;if((x|0)==0){c[m>>2]=0;m=(c[j>>2]|0)-1|0;c[h>>2]=m;a[m]=0;F=c[h>>2]|0;G=c[j>>2]|0}else{c[h>>2]=o;m=b+40+x|0;c[j>>2]=m;F=o;G=m}m=F+1|0;c[h>>2]=m;C=d[F]|0;D=m;E=G}}while(0);do{if(D>>>0<E>>>0){c[h>>2]=D+1;H=d[D]|0}else{n=b+32|0;if((c[n>>2]|0)==0){H=0;break}i=b+40|0;m=cl[c[b+16>>2]&3](c[b+28>>2]|0,i,c[b+36>>2]|0)|0;if((m|0)==0){c[n>>2]=0;n=(c[j>>2]|0)-1|0;c[h>>2]=n;a[n]=0;I=c[h>>2]|0}else{c[h>>2]=i;c[j>>2]=b+40+m;I=i}c[h>>2]=I+1;H=d[I]|0}}while(0);c[e+4>>2]=H<<8|C;i=c[h>>2]|0;do{if(i>>>0<(c[j>>2]|0)>>>0){c[h>>2]=i+1;J=d[i]|0}else{m=b+32|0;if((c[m>>2]|0)==0){J=0;break}n=b+40|0;o=cl[c[b+16>>2]&3](c[b+28>>2]|0,n,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[j>>2]|0)-1|0;c[h>>2]=m;a[m]=0;K=c[h>>2]|0}else{c[h>>2]=n;c[j>>2]=b+40+o;K=n}c[h>>2]=K+1;J=d[K]|0}}while(0);i=e+12|0;c[i>>2]=J;n=c[h>>2]|0;do{if(n>>>0<(c[j>>2]|0)>>>0){c[h>>2]=n+1;L=d[n]|0}else{o=b+32|0;if((c[o>>2]|0)==0){L=0;break}m=b+40|0;x=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((x|0)==0){c[o>>2]=0;o=(c[j>>2]|0)-1|0;c[h>>2]=o;a[o]=0;M=c[h>>2]|0}else{c[h>>2]=m;c[j>>2]=b+40+x;M=m}c[h>>2]=M+1;L=d[M]|0}}while(0);c[e+16>>2]=L;n=c[h>>2]|0;do{if(n>>>0<(c[j>>2]|0)>>>0){c[h>>2]=n+1;N=d[n]|0}else{m=b+32|0;if((c[m>>2]|0)==0){N=0;break}x=b+40|0;o=cl[c[b+16>>2]&3](c[b+28>>2]|0,x,c[b+36>>2]|0)|0;if((o|0)==0){c[m>>2]=0;m=(c[j>>2]|0)-1|0;c[h>>2]=m;a[m]=0;O=c[h>>2]|0}else{c[h>>2]=x;c[j>>2]=b+40+o;O=x}c[h>>2]=O+1;N=d[O]|0}}while(0);c[e+20>>2]=N;c[e+24>>2]=-1;if((f|0)!=0){c[f>>2]=4}if((g|0)!=0){P=1;return P|0}n=c[i>>2]|0;if((n&128|0)==0){P=1;return P|0}x=2<<(n&7);if((x|0)<=0){P=1;return P|0}n=b+32|0;o=b+16|0;m=b+28|0;Q=b+40|0;R=b+36|0;S=0;while(1){T=c[h>>2]|0;do{if(T>>>0<(c[j>>2]|0)>>>0){c[h>>2]=T+1;U=a[T]|0}else{if((c[n>>2]|0)==0){U=0;break}V=cl[c[o>>2]&3](c[m>>2]|0,Q,c[R>>2]|0)|0;if((V|0)==0){c[n>>2]=0;W=(c[j>>2]|0)-1|0;c[h>>2]=W;a[W]=0;X=c[h>>2]|0}else{c[h>>2]=Q;c[j>>2]=b+40+V;X=Q}c[h>>2]=X+1;U=a[X]|0}}while(0);a[e+32+(S<<2)+2|0]=U;T=c[h>>2]|0;do{if(T>>>0<(c[j>>2]|0)>>>0){c[h>>2]=T+1;Y=a[T]|0}else{if((c[n>>2]|0)==0){Y=0;break}V=cl[c[o>>2]&3](c[m>>2]|0,Q,c[R>>2]|0)|0;if((V|0)==0){c[n>>2]=0;W=(c[j>>2]|0)-1|0;c[h>>2]=W;a[W]=0;Z=c[h>>2]|0}else{c[h>>2]=Q;c[j>>2]=b+40+V;Z=Q}c[h>>2]=Z+1;Y=a[Z]|0}}while(0);a[e+32+(S<<2)+1|0]=Y;T=c[h>>2]|0;do{if(T>>>0<(c[j>>2]|0)>>>0){c[h>>2]=T+1;_=a[T]|0}else{if((c[n>>2]|0)==0){_=0;break}V=cl[c[o>>2]&3](c[m>>2]|0,Q,c[R>>2]|0)|0;if((V|0)==0){c[n>>2]=0;W=(c[j>>2]|0)-1|0;c[h>>2]=W;a[W]=0;$=c[h>>2]|0}else{c[h>>2]=Q;c[j>>2]=b+40+V;$=Q}c[h>>2]=$+1;_=a[$]|0}}while(0);a[e+32+(S<<2)|0]=_;a[e+32+(S<<2)+3|0]=0;T=S+1|0;if((T|0)<(x|0)){S=T}else{P=1;break}}return P|0}}while(0);c[2832]=2192;P=0;return P|0}}while(0);c[2832]=2192;P=0;return P|0}}while(0);c[2832]=2192;P=0;return P|0}function eT(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0,aW=0,aX=0,aY=0,aZ=0,a_=0,a$=0,a0=0,a1=0,a2=0,a3=0,a4=0,a5=0,a6=0,a7=0,a8=0,a9=0,ba=0,bb=0,bc=0,bd=0,be=0,bf=0,bg=0,bh=0,bi=0,bj=0,bk=0,bl=0,bm=0,bn=0,bo=0,bp=0,bq=0,br=0,bs=0,bt=0,bu=0,bv=0,bw=0,bx=0,by=0,bz=0,bA=0,bB=0,bC=0,bD=0,bE=0,bF=0,bG=0,bH=0,bI=0,bJ=0,bK=0,bL=0,bM=0,bN=0,bO=0,bP=0,bQ=0,bR=0,bS=0,bU=0,bV=0,bW=0,bX=0,bY=0,bZ=0,b_=0,b$=0,b0=0,b1=0,b2=0,b3=0,b4=0,b5=0,b6=0,b7=0,b8=0,b9=0,ca=0,cb=0,cc=0,cd=0,ce=0,cf=0,cg=0,ch=0,ci=0,ck=0,cm=0,cn=0,co=0,cp=0,cq=0,cr=0,cs=0,ct=0,cu=0,cv=0,cw=0,cx=0,cy=0,cz=0,cA=0;g=i;i=i+5104|0;h=g|0;j=g+4072|0;k=g+5096|0;l=b|0;m=c[l>>2]|0;n=b+8|0;c[n>>2]=0;o=b+4|0;c[o>>2]=0;p=b+12|0;c[p>>2]=0;q=m+168|0;r=m+172|0;s=m+32|0;t=m+16|0;u=m+28|0;v=m+40|0;w=m+36|0;x=0;while(1){if((x|0)>=8){break}y=c[q>>2]|0;do{if(y>>>0<(c[r>>2]|0)>>>0){c[q>>2]=y+1;z=a[y]|0}else{if((c[s>>2]|0)==0){z=0;break}A=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((A|0)==0){c[s>>2]=0;B=(c[r>>2]|0)-1|0;c[q>>2]=B;a[B]=0;C=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+A;C=v}c[q>>2]=C+1;z=a[C]|0}}while(0);if(z<<24>>24==(a[4e3+x|0]|0)){x=x+1|0}else{D=135;break}}if((D|0)==135){c[2832]=1136;E=0;i=g;return E|0}if((e|0)==1){E=1;i=g;return E|0}x=m+20|0;z=m|0;C=m+4|0;y=m+8|0;A=(e|0)==2;B=0;F=0;G=0;H=0;I=0;J=0;K=1;L=0;M=c[q>>2]|0;L183:while(1){N=c[r>>2]|0;do{if(M>>>0<N>>>0){O=M+1|0;c[q>>2]=O;P=d[M]|0;Q=O;R=N}else{if((c[s>>2]|0)==0){P=0;Q=M;R=N;break}O=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((O|0)==0){c[s>>2]=0;S=(c[r>>2]|0)-1|0;c[q>>2]=S;a[S]=0;T=c[q>>2]|0;U=c[r>>2]|0}else{c[q>>2]=v;S=m+40+O|0;c[r>>2]=S;T=v;U=S}S=T+1|0;c[q>>2]=S;P=d[T]|0;Q=S;R=U}}while(0);N=P<<8;do{if(Q>>>0<R>>>0){S=Q+1|0;c[q>>2]=S;V=d[Q]|0;W=S;X=R}else{if((c[s>>2]|0)==0){V=0;W=Q;X=R;break}S=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((S|0)==0){c[s>>2]=0;O=(c[r>>2]|0)-1|0;c[q>>2]=O;a[O]=0;Y=c[q>>2]|0;Z=c[r>>2]|0}else{c[q>>2]=v;O=m+40+S|0;c[r>>2]=O;Y=v;Z=O}O=Y+1|0;c[q>>2]=O;V=d[Y]|0;W=O;X=Z}}while(0);O=(V|N)<<16;do{if(W>>>0<X>>>0){S=W+1|0;c[q>>2]=S;_=d[W]|0;aa=S;ab=X}else{if((c[s>>2]|0)==0){_=0;aa=W;ab=X;break}S=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((S|0)==0){c[s>>2]=0;ac=(c[r>>2]|0)-1|0;c[q>>2]=ac;a[ac]=0;ad=c[q>>2]|0;ae=c[r>>2]|0}else{c[q>>2]=v;ac=m+40+S|0;c[r>>2]=ac;ad=v;ae=ac}ac=ad+1|0;c[q>>2]=ac;_=d[ad]|0;aa=ac;ab=ae}}while(0);N=_<<8;do{if(aa>>>0<ab>>>0){ac=aa+1|0;c[q>>2]=ac;af=d[aa]|0;ag=ac;ah=ab}else{if((c[s>>2]|0)==0){af=0;ag=aa;ah=ab;break}ac=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((ac|0)==0){c[s>>2]=0;S=(c[r>>2]|0)-1|0;c[q>>2]=S;a[S]=0;ai=c[q>>2]|0;aj=c[r>>2]|0}else{c[q>>2]=v;S=m+40+ac|0;c[r>>2]=S;ai=v;aj=S}S=ai+1|0;c[q>>2]=S;af=d[ai]|0;ag=S;ah=aj}}while(0);S=N|O|af;do{if(ag>>>0<ah>>>0){ac=ag+1|0;c[q>>2]=ac;ak=d[ag]|0;al=ac;am=ah}else{if((c[s>>2]|0)==0){ak=0;al=ag;am=ah;break}ac=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((ac|0)==0){c[s>>2]=0;an=(c[r>>2]|0)-1|0;c[q>>2]=an;a[an]=0;ao=c[q>>2]|0;ap=c[r>>2]|0}else{c[q>>2]=v;an=m+40+ac|0;c[r>>2]=an;ao=v;ap=an}an=ao+1|0;c[q>>2]=an;ak=d[ao]|0;al=an;am=ap}}while(0);O=ak<<8;do{if(al>>>0<am>>>0){N=al+1|0;c[q>>2]=N;aq=d[al]|0;ar=N;as=am}else{if((c[s>>2]|0)==0){aq=0;ar=al;as=am;break}N=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((N|0)==0){c[s>>2]=0;an=(c[r>>2]|0)-1|0;c[q>>2]=an;a[an]=0;at=c[q>>2]|0;au=c[r>>2]|0}else{c[q>>2]=v;an=m+40+N|0;c[r>>2]=an;at=v;au=an}an=at+1|0;c[q>>2]=an;aq=d[at]|0;ar=an;as=au}}while(0);an=(aq|O)<<16;do{if(ar>>>0<as>>>0){N=ar+1|0;c[q>>2]=N;av=d[ar]|0;aw=N;ax=as}else{if((c[s>>2]|0)==0){av=0;aw=ar;ax=as;break}N=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((N|0)==0){c[s>>2]=0;ac=(c[r>>2]|0)-1|0;c[q>>2]=ac;a[ac]=0;ay=c[q>>2]|0;az=c[r>>2]|0}else{c[q>>2]=v;ac=m+40+N|0;c[r>>2]=ac;ay=v;az=ac}ac=ay+1|0;c[q>>2]=ac;av=d[ay]|0;aw=ac;ax=az}}while(0);O=av<<8;do{if(aw>>>0<ax>>>0){ac=aw+1|0;c[q>>2]=ac;aA=d[aw]|0;aB=ac}else{if((c[s>>2]|0)==0){aA=0;aB=aw;break}ac=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((ac|0)==0){c[s>>2]=0;N=(c[r>>2]|0)-1|0;c[q>>2]=N;a[N]=0;aC=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+ac;aC=v}ac=aC+1|0;c[q>>2]=ac;aA=d[aC]|0;aB=ac}}while(0);ac=O|an|aA;L257:do{if((ac|0)==1130840649){N=c[2822]|0;do{if((c[t>>2]|0)!=0){aD=c[r>>2]|0;aE=aD-aB|0;if((aE|0)>=(S|0)){break}c[q>>2]=aD;cj[c[x>>2]&63](c[u>>2]|0,S-aE|0);aF=B;aG=F;aH=G;aI=H;aJ=N;aK=J;aL=K;aM=L;break L257}}while(0);c[q>>2]=aB+S;aF=B;aG=F;aH=G;aI=H;aJ=N;aK=J;aL=K;aM=L}else if((ac|0)==1229472850){if((K|0)==0){D=200;break L183}if((S|0)!=13){D=202;break L183}aE=c[r>>2]|0;do{if(aB>>>0<aE>>>0){aD=aB+1|0;c[q>>2]=aD;aN=d[aB]|0;aO=aD;aP=aE}else{if((c[s>>2]|0)==0){aN=0;aO=aB;aP=aE;break}aD=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aD|0)==0){c[s>>2]=0;aQ=(c[r>>2]|0)-1|0;c[q>>2]=aQ;a[aQ]=0;aR=c[q>>2]|0;aS=c[r>>2]|0}else{c[q>>2]=v;aQ=m+40+aD|0;c[r>>2]=aQ;aR=v;aS=aQ}aQ=aR+1|0;c[q>>2]=aQ;aN=d[aR]|0;aO=aQ;aP=aS}}while(0);aE=aN<<8;do{if(aO>>>0<aP>>>0){N=aO+1|0;c[q>>2]=N;aT=d[aO]|0;aU=N;aV=aP}else{if((c[s>>2]|0)==0){aT=0;aU=aO;aV=aP;break}N=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((N|0)==0){c[s>>2]=0;aQ=(c[r>>2]|0)-1|0;c[q>>2]=aQ;a[aQ]=0;aW=c[q>>2]|0;aX=c[r>>2]|0}else{c[q>>2]=v;aQ=m+40+N|0;c[r>>2]=aQ;aW=v;aX=aQ}aQ=aW+1|0;c[q>>2]=aQ;aT=d[aW]|0;aU=aQ;aV=aX}}while(0);aQ=(aT|aE)<<16;do{if(aU>>>0<aV>>>0){N=aU+1|0;c[q>>2]=N;aY=d[aU]|0;aZ=N;a_=aV}else{if((c[s>>2]|0)==0){aY=0;aZ=aU;a_=aV;break}N=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((N|0)==0){c[s>>2]=0;aD=(c[r>>2]|0)-1|0;c[q>>2]=aD;a[aD]=0;a$=c[q>>2]|0;a0=c[r>>2]|0}else{c[q>>2]=v;aD=m+40+N|0;c[r>>2]=aD;a$=v;a0=aD}aD=a$+1|0;c[q>>2]=aD;aY=d[a$]|0;aZ=aD;a_=a0}}while(0);aE=aY<<8;do{if(aZ>>>0<a_>>>0){aD=aZ+1|0;c[q>>2]=aD;a1=d[aZ]|0;a2=aD}else{if((c[s>>2]|0)==0){a1=0;a2=aZ;break}aD=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aD|0)==0){c[s>>2]=0;N=(c[r>>2]|0)-1|0;c[q>>2]=N;a[N]=0;a3=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+aD;a3=v}aD=a3+1|0;c[q>>2]=aD;a1=d[a3]|0;a2=aD}}while(0);aD=aE|aQ|a1;c[z>>2]=aD;if(aD>>>0>16777216>>>0){D=232;break L183}aD=c[r>>2]|0;do{if(a2>>>0<aD>>>0){N=a2+1|0;c[q>>2]=N;a4=d[a2]|0;a5=N;a6=aD}else{if((c[s>>2]|0)==0){a4=0;a5=a2;a6=aD;break}N=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((N|0)==0){c[s>>2]=0;a7=(c[r>>2]|0)-1|0;c[q>>2]=a7;a[a7]=0;a8=c[q>>2]|0;a9=c[r>>2]|0}else{c[q>>2]=v;a7=m+40+N|0;c[r>>2]=a7;a8=v;a9=a7}a7=a8+1|0;c[q>>2]=a7;a4=d[a8]|0;a5=a7;a6=a9}}while(0);aD=a4<<8;do{if(a5>>>0<a6>>>0){aQ=a5+1|0;c[q>>2]=aQ;ba=d[a5]|0;bb=aQ;bc=a6}else{if((c[s>>2]|0)==0){ba=0;bb=a5;bc=a6;break}aQ=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aQ|0)==0){c[s>>2]=0;aE=(c[r>>2]|0)-1|0;c[q>>2]=aE;a[aE]=0;bd=c[q>>2]|0;be=c[r>>2]|0}else{c[q>>2]=v;aE=m+40+aQ|0;c[r>>2]=aE;bd=v;be=aE}aE=bd+1|0;c[q>>2]=aE;ba=d[bd]|0;bb=aE;bc=be}}while(0);aE=(ba|aD)<<16;do{if(bb>>>0<bc>>>0){aQ=bb+1|0;c[q>>2]=aQ;bf=d[bb]|0;bg=aQ;bh=bc}else{if((c[s>>2]|0)==0){bf=0;bg=bb;bh=bc;break}aQ=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aQ|0)==0){c[s>>2]=0;a7=(c[r>>2]|0)-1|0;c[q>>2]=a7;a[a7]=0;bi=c[q>>2]|0;bj=c[r>>2]|0}else{c[q>>2]=v;a7=m+40+aQ|0;c[r>>2]=a7;bi=v;bj=a7}a7=bi+1|0;c[q>>2]=a7;bf=d[bi]|0;bg=a7;bh=bj}}while(0);aD=bf<<8;do{if(bg>>>0<bh>>>0){a7=bg+1|0;c[q>>2]=a7;bk=d[bg]|0;bl=a7}else{if((c[s>>2]|0)==0){bk=0;bl=bg;break}a7=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((a7|0)==0){c[s>>2]=0;aQ=(c[r>>2]|0)-1|0;c[q>>2]=aQ;a[aQ]=0;bm=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+a7;bm=v}a7=bm+1|0;c[q>>2]=a7;bk=d[bm]|0;bl=a7}}while(0);a7=aD|aE|bk;c[C>>2]=a7;if(a7>>>0>16777216>>>0){D=262;break L183}do{if(bl>>>0<(c[r>>2]|0)>>>0){bn=bl}else{if((c[s>>2]|0)==0){D=269;break L183}a7=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((a7|0)==0){c[s>>2]=0;aQ=(c[r>>2]|0)-1|0;c[q>>2]=aQ;a[aQ]=0;bn=c[q>>2]|0;break}else{c[q>>2]=v;c[r>>2]=m+40+a7;bn=v;break}}}while(0);aE=bn+1|0;c[q>>2]=aE;if((a[bn]|0)!=8){D=269;break L183}do{if(aE>>>0<(c[r>>2]|0)>>>0){bo=aE;D=275}else{if((c[s>>2]|0)==0){bp=B;bq=0;br=aE;break}aD=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aD|0)==0){c[s>>2]=0;a7=(c[r>>2]|0)-1|0;c[q>>2]=a7;a[a7]=0;bo=c[q>>2]|0;D=275;break}else{c[q>>2]=v;c[r>>2]=m+40+aD;bo=v;D=275;break}}}while(0);do{if((D|0)==275){D=0;aE=bo+1|0;c[q>>2]=aE;aD=a[bo]|0;a7=aD&255;if((aD&255)>>>0>6>>>0){D=276;break L183}if(aD<<24>>24==3){bp=3;bq=3;br=aE;break}if((a7&1|0)==0){bp=B;bq=a7;br=aE}else{D=279;break L183}}}while(0);aE=c[r>>2]|0;do{if(br>>>0<aE>>>0){bs=br;D=285}else{if((c[s>>2]|0)==0){bt=br;bu=aE;break}a7=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((a7|0)==0){c[s>>2]=0;aD=(c[r>>2]|0)-1|0;c[q>>2]=aD;a[aD]=0;bs=c[q>>2]|0;D=285;break}else{c[q>>2]=v;c[r>>2]=m+40+a7;bs=v;D=285;break}}}while(0);if((D|0)==285){D=0;aE=bs+1|0;c[q>>2]=aE;if((a[bs]|0)!=0){D=287;break L183}bt=aE;bu=c[r>>2]|0}do{if(bt>>>0<bu>>>0){bv=bt;D=293}else{if((c[s>>2]|0)==0){bw=bt;bx=bu;break}aE=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aE|0)==0){c[s>>2]=0;a7=(c[r>>2]|0)-1|0;c[q>>2]=a7;a[a7]=0;bv=c[q>>2]|0;D=293;break}else{c[q>>2]=v;c[r>>2]=m+40+aE;bv=v;D=293;break}}}while(0);if((D|0)==293){D=0;aE=bv+1|0;c[q>>2]=aE;if((a[bv]|0)!=0){D=295;break L183}bw=aE;bx=c[r>>2]|0}do{if(bw>>>0<bx>>>0){by=bw;D=301}else{if((c[s>>2]|0)==0){bz=0;break}aE=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aE|0)==0){c[s>>2]=0;a7=(c[r>>2]|0)-1|0;c[q>>2]=a7;a[a7]=0;by=c[q>>2]|0;D=301;break}else{c[q>>2]=v;c[r>>2]=m+40+aE;by=v;D=301;break}}}while(0);if((D|0)==301){D=0;c[q>>2]=by+1;aE=a[by]|0;if((aE&255)>>>0>1>>>0){D=303;break L183}bz=aE&255}aE=c[z>>2]|0;if((aE|0)==0){D=306;break L183}a7=c[C>>2]|0;if((a7|0)==0){D=306;break L183}if(bp<<24>>24!=0){c[y>>2]=1;if((1073741824/(aE>>>0)|0)>>>2>>>0<a7>>>0){D=312;break L183}else{aF=bp;aG=F;aH=G;aI=H;aJ=I;aK=bz;aL=0;aM=L;break}}aD=(bq&2|1)+(bq>>>2&1)|0;c[y>>2]=aD;if((((1073741824/(aE>>>0)|0)>>>0)/(aD>>>0)|0)>>>0<a7>>>0){D=309;break L183}if(A){E=1;D=516;break L183}else{aF=0;aG=F;aH=G;aI=H;aJ=I;aK=bz;aL=0;aM=L}}else if((ac|0)==1347179589){if((K|0)!=0){D=314;break L183}if(S>>>0>768>>>0){D=316;break L183}a7=(S>>>0)/3|0;if((a7*3|0|0)!=(S|0)){D=319;break L183}if(S>>>0>2>>>0){bA=0;bB=aB}else{aF=B;aG=F;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=a7;break}while(1){aD=c[r>>2]|0;do{if(bB>>>0<aD>>>0){aE=bB+1|0;c[q>>2]=aE;bC=a[bB]|0;bD=aE;bE=aD}else{if((c[s>>2]|0)==0){bC=0;bD=bB;bE=aD;break}aE=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aE|0)==0){c[s>>2]=0;aQ=(c[r>>2]|0)-1|0;c[q>>2]=aQ;a[aQ]=0;bF=c[q>>2]|0;bG=c[r>>2]|0}else{c[q>>2]=v;aQ=m+40+aE|0;c[r>>2]=aQ;bF=v;bG=aQ}aQ=bF+1|0;c[q>>2]=aQ;bC=a[bF]|0;bD=aQ;bE=bG}}while(0);aD=bA<<2;a[j+aD|0]=bC;do{if(bD>>>0<bE>>>0){aQ=bD+1|0;c[q>>2]=aQ;bH=a[bD]|0;bI=aQ;bJ=bE}else{if((c[s>>2]|0)==0){bH=0;bI=bD;bJ=bE;break}aQ=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aQ|0)==0){c[s>>2]=0;aE=(c[r>>2]|0)-1|0;c[q>>2]=aE;a[aE]=0;bK=c[q>>2]|0;bL=c[r>>2]|0}else{c[q>>2]=v;aE=m+40+aQ|0;c[r>>2]=aE;bK=v;bL=aE}aE=bK+1|0;c[q>>2]=aE;bH=a[bK]|0;bI=aE;bJ=bL}}while(0);a[j+(aD|1)|0]=bH;do{if(bI>>>0<bJ>>>0){aE=bI+1|0;c[q>>2]=aE;bM=a[bI]|0;bN=aE}else{if((c[s>>2]|0)==0){bM=0;bN=bI;break}aE=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aE|0)==0){c[s>>2]=0;aQ=(c[r>>2]|0)-1|0;c[q>>2]=aQ;a[aQ]=0;bO=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+aE;bO=v}aE=bO+1|0;c[q>>2]=aE;bM=a[bO]|0;bN=aE}}while(0);a[j+(aD|2)|0]=bM;a[j+(aD|3)|0]=-1;aE=bA+1|0;if(aE>>>0<a7>>>0){bA=aE;bB=bN}else{aF=B;aG=F;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=a7;break}}}else if((ac|0)==1951551059){if((K|0)!=0){D=343;break L183}if((c[o>>2]|0)!=0){D=345;break L183}if(B<<24>>24!=0){if(A){D=348;break L183}if((L|0)==0){D=350;break L183}if(S>>>0>L>>>0){D=353;break L183}if((S|0)==0){aF=4;aG=F;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=L;break}else{bP=0;bQ=aB}while(1){do{if(bQ>>>0<(c[r>>2]|0)>>>0){a7=bQ+1|0;c[q>>2]=a7;bR=a[bQ]|0;bS=a7}else{if((c[s>>2]|0)==0){bR=0;bS=bQ;break}a7=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((a7|0)==0){c[s>>2]=0;aE=(c[r>>2]|0)-1|0;c[q>>2]=aE;a[aE]=0;bU=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+a7;bU=v}a7=bU+1|0;c[q>>2]=a7;bR=a[bU]|0;bS=a7}}while(0);a[j+(bP<<2|3)|0]=bR;aD=bP+1|0;if(aD>>>0<S>>>0){bP=aD;bQ=bS}else{aF=4;aG=F;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=L;break L257}}}aD=c[y>>2]|0;if((aD&1|0)==0){D=363;break L183}if((S|0)!=(aD<<1|0)){D=366;break L183}if((aD|0)>0){bV=0;bW=aB}else{aF=0;aG=1;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=L;break}while(1){aD=c[r>>2]|0;do{if(bW>>>0<aD>>>0){a7=bW+1|0;c[q>>2]=a7;bX=a7;bY=aD}else{if((c[s>>2]|0)==0){bX=bW;bY=aD;break}a7=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((a7|0)==0){c[s>>2]=0;aE=(c[r>>2]|0)-1|0;c[q>>2]=aE;a[aE]=0;bZ=c[q>>2]|0;b_=c[r>>2]|0}else{c[q>>2]=v;aE=m+40+a7|0;c[r>>2]=aE;bZ=v;b_=aE}aE=bZ+1|0;c[q>>2]=aE;bX=aE;bY=b_}}while(0);do{if(bX>>>0<bY>>>0){aD=bX+1|0;c[q>>2]=aD;b$=a[bX]|0;b0=aD}else{if((c[s>>2]|0)==0){b$=0;b0=bX;break}aD=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((aD|0)==0){c[s>>2]=0;aE=(c[r>>2]|0)-1|0;c[q>>2]=aE;a[aE]=0;b1=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+aD;b1=v}aD=b1+1|0;c[q>>2]=aD;b$=a[b1]|0;b0=aD}}while(0);a[k+bV|0]=b$;aD=bV+1|0;if((aD|0)<(c[y>>2]|0)){bV=aD;bW=b0}else{aF=0;aG=1;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=L;break}}}else if((ac|0)==1229209940){if((K|0)!=0){D=383;break L183}if(B<<24>>24!=0&(L|0)==0){D=385;break L183}if(A){D=387;break L183}aD=S+G|0;if(aD>>>0>H>>>0){if((H|0)==0){b2=S>>>0>4096>>>0?S:4096}else{b2=H}while(1){if(aD>>>0>b2>>>0){b2=b2<<1}else{break}}aE=fu(c[o>>2]|0,b2)|0;if((aE|0)==0){D=394;break L183}c[o>>2]=aE;b3=b2;b4=aE}else{b3=H;b4=c[o>>2]|0}aE=b4+G|0;do{if((c[t>>2]|0)==0){b5=c[q>>2]|0;b6=c[r>>2]|0}else{a7=c[r>>2]|0;aQ=c[q>>2]|0;N=a7-aQ|0;if((N|0)>=(S|0)){b5=aQ;b6=a7;break}fG(aE|0,aQ|0,N)|0;aQ=S-N|0;a7=(cl[c[t>>2]&3](c[u>>2]|0,b4+(N+G)|0,aQ)|0)==(aQ|0);c[q>>2]=c[r>>2];if(a7){aF=B;aG=F;aH=aD;aI=b3;aJ=I;aK=J;aL=0;aM=L;break L257}else{D=402;break L183}}}while(0);if((b5+S|0)>>>0>b6>>>0){D=402;break L183}fG(aE|0,b5|0,S)|0;c[q>>2]=(c[q>>2]|0)+S;aF=B;aG=F;aH=aD;aI=b3;aJ=I;aK=J;aL=0;aM=L}else if((ac|0)==1229278788){D=403;break L183}else{if((K|0)!=0){D=468;break L183}if((an&536870912|0)==0){D=470;break L183}do{if((c[t>>2]|0)!=0){a7=c[r>>2]|0;aQ=a7-aB|0;if((aQ|0)>=(S|0)){break}c[q>>2]=a7;cj[c[x>>2]&63](c[u>>2]|0,S-aQ|0);aF=B;aG=F;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=L;break L257}}while(0);c[q>>2]=aB+S;aF=B;aG=F;aH=G;aI=H;aJ=I;aK=J;aL=0;aM=L}}while(0);S=c[q>>2]|0;an=c[r>>2]|0;do{if(S>>>0<an>>>0){ac=S+1|0;c[q>>2]=ac;b7=ac;b8=an}else{if((c[s>>2]|0)==0){b7=S;b8=an;break}ac=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((ac|0)==0){c[s>>2]=0;O=(c[r>>2]|0)-1|0;c[q>>2]=O;a[O]=0;b9=c[q>>2]|0;ca=c[r>>2]|0}else{c[q>>2]=v;O=m+40+ac|0;c[r>>2]=O;b9=v;ca=O}O=b9+1|0;c[q>>2]=O;b7=O;b8=ca}}while(0);do{if(b7>>>0<b8>>>0){an=b7+1|0;c[q>>2]=an;cb=an;cc=b8}else{if((c[s>>2]|0)==0){cb=b7;cc=b8;break}an=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((an|0)==0){c[s>>2]=0;S=(c[r>>2]|0)-1|0;c[q>>2]=S;a[S]=0;cd=c[q>>2]|0;ce=c[r>>2]|0}else{c[q>>2]=v;S=m+40+an|0;c[r>>2]=S;cd=v;ce=S}S=cd+1|0;c[q>>2]=S;cb=S;cc=ce}}while(0);do{if(cb>>>0<cc>>>0){S=cb+1|0;c[q>>2]=S;cf=S;cg=cc}else{if((c[s>>2]|0)==0){cf=cb;cg=cc;break}S=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((S|0)==0){c[s>>2]=0;an=(c[r>>2]|0)-1|0;c[q>>2]=an;a[an]=0;ch=c[q>>2]|0;ci=c[r>>2]|0}else{c[q>>2]=v;an=m+40+S|0;c[r>>2]=an;ch=v;ci=an}an=ch+1|0;c[q>>2]=an;cf=an;cg=ci}}while(0);if(cf>>>0<cg>>>0){an=cf+1|0;c[q>>2]=an;B=aF;F=aG;G=aH;H=aI;I=aJ;J=aK;K=aL;L=aM;M=an;continue}if((c[s>>2]|0)==0){B=aF;F=aG;G=aH;H=aI;I=aJ;J=aK;K=aL;L=aM;M=cf;continue}an=cl[c[t>>2]&3](c[u>>2]|0,v,c[w>>2]|0)|0;if((an|0)==0){c[s>>2]=0;S=(c[r>>2]|0)-1|0;c[q>>2]=S;a[S]=0;ck=c[q>>2]|0}else{c[q>>2]=v;c[r>>2]=m+40+an;ck=v}an=ck+1|0;c[q>>2]=an;B=aF;F=aG;G=aH;H=aI;I=aJ;J=aK;K=aL;L=aM;M=an}if((D|0)==200){c[2832]=2168;E=0;i=g;return E|0}else if((D|0)==202){c[2832]=2128;E=0;i=g;return E|0}else if((D|0)==232){c[2832]=2088;E=0;i=g;return E|0}else if((D|0)==262){c[2832]=2088;E=0;i=g;return E|0}else if((D|0)==269){c[2832]=2072;E=0;i=g;return E|0}else if((D|0)==276){c[2832]=2032;E=0;i=g;return E|0}else if((D|0)==279){c[2832]=2032;E=0;i=g;return E|0}else if((D|0)==287){c[2832]=1992;E=0;i=g;return E|0}else if((D|0)==295){c[2832]=1968;E=0;i=g;return E|0}else if((D|0)==303){c[2832]=1944;E=0;i=g;return E|0}else if((D|0)==306){c[2832]=1768;E=0;i=g;return E|0}else if((D|0)==309){c[2832]=2088;E=0;i=g;return E|0}else if((D|0)==312){c[2832]=2088;E=0;i=g;return E|0}else if((D|0)==314){c[2832]=1712;E=0;i=g;return E|0}else if((D|0)==316){c[2832]=1696;E=0;i=g;return E|0}else if((D|0)==319){c[2832]=1696;E=0;i=g;return E|0}else if((D|0)==343){c[2832]=1712;E=0;i=g;return E|0}else if((D|0)==345){c[2832]=1680;E=0;i=g;return E|0}else if((D|0)==348){c[y>>2]=4;E=1;i=g;return E|0}else if((D|0)==350){c[2832]=1648;E=0;i=g;return E|0}else if((D|0)==353){c[2832]=1632;E=0;i=g;return E|0}else if((D|0)==363){c[2832]=1600;E=0;i=g;return E|0}else if((D|0)==366){c[2832]=1632;E=0;i=g;return E|0}else if((D|0)==383){c[2832]=1712;E=0;i=g;return E|0}else if((D|0)==385){c[2832]=1592;E=0;i=g;return E|0}else if((D|0)==387){c[y>>2]=B&255;E=1;i=g;return E|0}else if((D|0)==394){c[2832]=1560;E=0;i=g;return E|0}else if((D|0)==402){c[2832]=1544;E=0;i=g;return E|0}else if((D|0)==403){if((K|0)!=0){c[2832]=1712;E=0;i=g;return E|0}if((e|0)!=0){E=1;i=g;return E|0}e=c[o>>2]|0;if((e|0)==0){c[2832]=1536;E=0;i=g;return E|0}K=(I|0)!=0;I=fs(16384)|0;do{if((I|0)!=0){c[h>>2]=e;c[h+4>>2]=e+G;if((ew(h,I,16384,1,K&1^1)|0)==0){ft(c[h+20>>2]|0);break}M=c[h+20>>2]|0;aM=(c[h+16>>2]|0)-M|0;c[n>>2]=M;if((M|0)==0){E=0;i=g;return E|0}ft(c[o>>2]|0);c[o>>2]=0;M=c[y>>2]|0;L=M+1|0;aL=B<<24>>24==0;aK=F<<24>>24==0;aJ=m+12|0;aI=aK&((L|0)==(f|0)&(f|0)!=3&aL^1)?M:L;c[aJ>>2]=aI;L=c[n>>2]|0;do{if((J|0)==0){M=c[l>>2]|0;if((eU(b,L,aM,aI,c[M>>2]|0,c[M+4>>2]|0)|0)==0){E=0}else{break}i=g;return E|0}else{M=c[1664]|0;c[1664]=0;H=c[l>>2]|0;aH=fs($($(c[H>>2]|0,aI)|0,c[H+4>>2]|0)|0)|0;aG=0;aF=aM;q=L;ck=H;while(1){H=c[3904+(aG<<2)>>2]|0;v=c[3968+(aG<<2)>>2]|0;r=(((c[ck>>2]|0)-1-H+v|0)>>>0)/(v>>>0)|0;s=c[3872+(aG<<2)>>2]|0;w=c[3936+(aG<<2)>>2]|0;u=(((c[ck+4>>2]|0)-1-s+w|0)>>>0)/(w>>>0)|0;if((r|0)==0|(u|0)==0){cm=q;cn=aF}else{if((eU(b,q,aF,aI,r,u)|0)==0){break}if((u|0)>0){t=(r|0)>0;cf=0;do{if(t){cg=($(cf,w)|0)+s|0;ci=$(cf,r)|0;ch=c[p>>2]|0;cc=c[l>>2]|0;cb=0;do{ce=aH+($(($(cb,v)|0)+H+($(c[cc>>2]|0,cg)|0)|0,aI)|0)|0;cd=ch+($(cb+ci|0,aI)|0)|0;fG(ce|0,cd|0,aI)|0;cb=cb+1|0;}while((cb|0)<(r|0))}cf=cf+1|0;}while((cf|0)<(u|0))}ft(c[p>>2]|0);cf=$(u,($(r,aI)|0)+1|0)|0;cm=q+cf|0;cn=aF-cf|0}cf=aG+1|0;if((cf|0)>=7){D=427;break}aG=cf;aF=cn;q=cm;ck=c[l>>2]|0}if((D|0)==427){c[p>>2]=aH;c[1664]=M;break}ft(aH);E=0;i=g;return E|0}}while(0);L636:do{if(!aK){aI=k|0;L=c[aJ>>2]|0;aM=c[l>>2]|0;ck=c[p>>2]|0;q=$(c[aM+4>>2]|0,c[aM>>2]|0)|0;if((L|0)==4){if((q|0)==0){break}aM=k+1|0;aF=k+2|0;aG=1;cf=ck;while(1){do{if((a[cf]|0)==(a[aI]|0)){if((a[cf+1|0]|0)!=(a[aM]|0)){break}if((a[cf+2|0]|0)!=(a[aF]|0)){break}a[cf+3|0]=0}}while(0);if(aG>>>0>=q>>>0){break L636}aG=aG+1|0;cf=cf+4|0}}else if((L|0)==2){if((q|0)==0){break}else{co=1;cp=ck}while(1){a[cp+1|0]=((a[cp]|0)!=(a[aI]|0))<<31>>31;if(co>>>0>=q>>>0){break L636}co=co+1|0;cp=cp+2|0}}else{bT(1296,1472,2569,3560);return 0}}}while(0);L655:do{if(K){if((c[aJ>>2]|0)<=2){break}aK=c[l>>2]|0;q=c[p>>2]|0;aI=c[aK+12>>2]|0;ck=$(c[aK+4>>2]|0,c[aK>>2]|0)|0;if((aI|0)==3){if((ck|0)==0){break}else{cq=q;cr=0}while(1){aK=a[cq]|0;L=cq+2|0;a[cq]=a[L]|0;a[L]=aK;aK=cr+1|0;if(aK>>>0<ck>>>0){cq=cq+3|0;cr=aK}else{break}}}else if((aI|0)==4){aK=(ck|0)==0;if((c[2820]|0)==0){if(aK){break}else{cs=q;ct=0}while(1){L=a[cs]|0;cf=cs+2|0;a[cs]=a[cf]|0;a[cf]=L;L=ct+1|0;if(L>>>0<ck>>>0){cs=cs+4|0;ct=L}else{break L655}}}if(aK){break}else{cu=q;cv=0}while(1){aI=a[cu+3|0]|0;L=a[cu]|0;cf=cu+2|0;aG=a[cf]|0;if(aI<<24>>24==0){a[cu]=aG;cw=L}else{aF=aI&255;a[cu]=((((aG&255)*255|0)>>>0)/(aF>>>0)|0)&255;aG=cu+1|0;a[aG]=((((d[aG]|0)*255|0)>>>0)/(aF>>>0)|0)&255;cw=((((L&255)*255|0)>>>0)/(aF>>>0)|0)&255}a[cf]=cw;cf=cv+1|0;if(cf>>>0<ck>>>0){cu=cu+4|0;cv=cf}else{break}}}else{bT(1512,1472,2649,3616);return 0}}}while(0);if(!aL){ck=B&255;c[y>>2]=ck;q=(f|0)>2?f:ck;c[aJ>>2]=q;ck=c[l>>2]|0;aK=$(c[ck+4>>2]|0,c[ck>>2]|0)|0;ck=c[p>>2]|0;cf=fs($(aK,q)|0)|0;if((cf|0)==0){c[2832]=1560;E=0;i=g;return E|0}aF=(aK|0)==0;do{if((q|0)==3){if(aF){break}else{cx=cf;cy=0}while(1){L=d[ck+cy|0]<<2;a[cx]=a[j+L|0]|0;a[cx+1|0]=a[j+(L|1)|0]|0;a[cx+2|0]=a[j+(L|2)|0]|0;L=cy+1|0;if(L>>>0<aK>>>0){cx=cx+3|0;cy=L}else{break}}}else{if(aF){break}else{cz=cf;cA=0}while(1){L=d[ck+cA|0]<<2;a[cz]=a[j+L|0]|0;a[cz+1|0]=a[j+(L|1)|0]|0;a[cz+2|0]=a[j+(L|2)|0]|0;a[cz+3|0]=a[j+(L|3)|0]|0;L=cA+1|0;if(L>>>0<aK>>>0){cz=cz+4|0;cA=L}else{break}}}}while(0);ft(c[p>>2]|0);c[p>>2]=cf}ft(c[n>>2]|0);c[n>>2]=0;E=1;i=g;return E|0}}while(0);c[n>>2]=0;E=0;i=g;return E|0}else if((D|0)==468){c[2832]=1712;E=0;i=g;return E|0}else if((D|0)==470){a[4008]=ak&255;a[4009]=aq&255;a[4010]=av&255;a[4011]=aA&255;c[2832]=4008;E=0;i=g;return E|0}else if((D|0)==516){i=g;return E|0}return 0}function eU(b,e,f,g,h,i){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0;j=c[b>>2]|0;k=$(h,g)|0;l=c[j+8>>2]|0;m=(l|0)==(g|0);n=l+1|0;o=(n|0)==(g|0);if(!(m|o)){bT(1216,1472,2449,3536);return 0}p=(c[1664]|0)==0?i:1;i=fs($(k,p)|0)|0;q=b+12|0;c[q>>2]=i;if((i|0)==0){c[2832]=1560;r=0;return r|0}L707:do{if((c[1664]|0)==0){do{if((c[j>>2]|0)==(h|0)){if((c[j+4>>2]|0)!=(p|0)){break}if(($(p,($(l,h)|0)+1|0)|0)==(f|0)){break L707}c[2832]=1192;r=0;return r|0}}while(0);if(($(p,($(l,h)|0)+1|0)|0)>>>0<=f>>>0){break}c[2832]=1192;r=0;return r|0}}while(0);if((p|0)==0){r=1;return r|0}f=(l|0)>0;j=h-1|0;b=(j|0)==0;s=($(l,h)|0)+1|0;h=0;t=e;e=i;L721:while(1){i=$(h,k)|0;u=i-k|0;v=a[t]|0;w=v&255;if((v&255)>>>0>4>>>0){x=560;break}if((h|0)==0){y=d[6248+w|0]|0}else{y=w}L727:do{if(f){if((y|0)==1){w=0;do{a[e+(w+i)|0]=a[t+(w+1)|0]|0;w=w+1|0;}while((w|0)<(l|0))}else if((y|0)==0){w=0;do{a[e+(w+i)|0]=a[t+(w+1)|0]|0;w=w+1|0;}while((w|0)<(l|0))}else{w=0;while(1){switch(y|0){case 3:{a[e+(w+i)|0]=((d[e+(w+u)|0]|0)>>>1)+(a[t+(w+1)|0]|0)&255;break};case 4:{a[e+(w+i)|0]=(a[e+(w+u)|0]|0)+(a[t+(w+1)|0]|0)&255;break};case 5:{a[e+(w+i)|0]=a[t+(w+1)|0]|0;break};case 6:{a[e+(w+i)|0]=a[t+(w+1)|0]|0;break};case 2:{a[e+(w+i)|0]=(a[e+(w+u)|0]|0)+(a[t+(w+1)|0]|0)&255;break};default:{}}w=w+1|0;if((w|0)>=(l|0)){break L727}}}}}while(0);L744:do{if(m){w=t+n|0;v=e+(i+g)|0;z=e+(u+g)|0;switch(y|0){case 6:{if(b){A=w;break L744}else{B=w;C=v;D=j}while(1){if(f){E=0;do{a[C+E|0]=(a[C+(E-g)|0]|0)+(a[B+E|0]|0)&255;E=E+1|0;}while((E|0)<(g|0))}E=D-1|0;if((E|0)==0){break}else{B=B+g|0;C=C+g|0;D=E}}A=t+s|0;break L744;break};case 0:{if(b){A=w;break L744}else{F=w;G=v;H=j}while(1){if(f){E=0;do{a[G+E|0]=a[F+E|0]|0;E=E+1|0;}while((E|0)<(g|0))}E=H-1|0;if((E|0)==0){break}else{F=F+g|0;G=G+g|0;H=E}}A=t+s|0;break L744;break};case 1:{if(b){A=w;break L744}else{I=w;J=v;K=j}while(1){if(f){E=0;do{a[J+E|0]=(a[J+(E-g)|0]|0)+(a[I+E|0]|0)&255;E=E+1|0;}while((E|0)<(g|0))}E=K-1|0;if((E|0)==0){break}else{I=I+g|0;J=J+g|0;K=E}}A=t+s|0;break L744;break};case 2:{if(b){A=w;break L744}else{L=w;M=v;N=z;O=j}while(1){if(f){E=0;do{a[M+E|0]=(a[N+E|0]|0)+(a[L+E|0]|0)&255;E=E+1|0;}while((E|0)<(g|0))}E=O-1|0;if((E|0)==0){break}else{L=L+g|0;M=M+g|0;N=N+g|0;O=E}}A=t+s|0;break L744;break};case 3:{if(b){A=w;break L744}else{P=w;Q=v;R=z;S=j}while(1){if(f){E=0;do{a[Q+E|0]=(((d[Q+(E-g)|0]|0)+(d[R+E|0]|0)|0)>>>1)+(d[P+E|0]|0)&255;E=E+1|0;}while((E|0)<(g|0))}E=S-1|0;if((E|0)==0){break}else{P=P+g|0;Q=Q+g|0;R=R+g|0;S=E}}A=t+s|0;break L744;break};case 4:{if(b){A=w;break L744}else{T=w;U=v;V=z;W=j}while(1){if(f){E=0;do{X=E-g|0;Y=a[U+X|0]|0;Z=Y&255;_=a[V+E|0]|0;aa=_&255;ab=a[V+X|0]|0;X=ab&255;ac=aa+Z-X|0;ad=ac-Z|0;Z=(ad|0)>-1?ad:-ad|0;ad=ac-aa|0;aa=(ad|0)>-1?ad:-ad|0;ad=ac-X|0;X=(ad|0)>-1?ad:-ad|0;if((Z|0)>(aa|0)|(Z|0)>(X|0)){ae=(aa|0)>(X|0)?ab:_}else{ae=Y}a[U+E|0]=ae+(a[T+E|0]|0)&255;E=E+1|0;}while((E|0)<(g|0))}E=W-1|0;if((E|0)==0){break}else{T=T+g|0;U=U+g|0;V=V+g|0;W=E}}A=t+s|0;break L744;break};case 5:{if(b){A=w;break L744}else{af=w;ag=v;ah=j}while(1){if(f){z=0;do{a[ag+z|0]=((d[ag+(z-g)|0]|0)>>>1)+(a[af+z|0]|0)&255;z=z+1|0;}while((z|0)<(g|0))}z=ah-1|0;if((z|0)==0){break}else{af=af+g|0;ag=ag+g|0;ah=z}}A=t+s|0;break L744;break};default:{A=w;break L744}}}else{a[e+(i+l)|0]=-1;v=t+n|0;z=e+(i+g)|0;E=e+(u+g)|0;if(!o){x=607;break L721}switch(y|0){case 0:{if(b){A=v;break L744}else{ai=v;aj=z;ak=j}while(1){if(f){Y=0;do{a[aj+Y|0]=a[ai+Y|0]|0;Y=Y+1|0;}while((Y|0)<(l|0))}a[aj+l|0]=-1;Y=ak-1|0;if((Y|0)==0){break}else{ai=ai+l|0;aj=aj+g|0;ak=Y}}A=t+s|0;break L744;break};case 1:{if(b){A=v;break L744}else{al=v;am=z;an=j}while(1){if(f){w=0;do{a[am+w|0]=(a[am+(w-g)|0]|0)+(a[al+w|0]|0)&255;w=w+1|0;}while((w|0)<(l|0))}a[am+l|0]=-1;w=an-1|0;if((w|0)==0){break}else{al=al+l|0;am=am+g|0;an=w}}A=t+s|0;break L744;break};case 2:{if(b){A=v;break L744}else{ao=v;ap=z;aq=E;ar=j}while(1){if(f){w=0;do{a[ap+w|0]=(a[aq+w|0]|0)+(a[ao+w|0]|0)&255;w=w+1|0;}while((w|0)<(l|0))}a[ap+l|0]=-1;w=ar-1|0;if((w|0)==0){break}else{ao=ao+l|0;ap=ap+g|0;aq=aq+g|0;ar=w}}A=t+s|0;break L744;break};case 3:{if(b){A=v;break L744}else{as=v;at=z;au=E;av=j}while(1){if(f){w=0;do{a[at+w|0]=(((d[at+(w-g)|0]|0)+(d[au+w|0]|0)|0)>>>1)+(d[as+w|0]|0)&255;w=w+1|0;}while((w|0)<(l|0))}a[at+l|0]=-1;w=av-1|0;if((w|0)==0){break}else{as=as+l|0;at=at+g|0;au=au+g|0;av=w}}A=t+s|0;break L744;break};case 4:{if(b){A=v;break L744}else{aw=v;ax=z;ay=E;az=j}while(1){if(f){w=0;do{Y=w-g|0;_=a[ax+Y|0]|0;ab=_&255;X=a[ay+w|0]|0;aa=X&255;Z=a[ay+Y|0]|0;Y=Z&255;ad=aa+ab-Y|0;ac=ad-ab|0;ab=(ac|0)>-1?ac:-ac|0;ac=ad-aa|0;aa=(ac|0)>-1?ac:-ac|0;ac=ad-Y|0;Y=(ac|0)>-1?ac:-ac|0;if((ab|0)>(aa|0)|(ab|0)>(Y|0)){aA=(aa|0)>(Y|0)?Z:X}else{aA=_}a[ax+w|0]=aA+(a[aw+w|0]|0)&255;w=w+1|0;}while((w|0)<(l|0))}a[ax+l|0]=-1;w=az-1|0;if((w|0)==0){break}else{aw=aw+l|0;ax=ax+g|0;ay=ay+g|0;az=w}}A=t+s|0;break L744;break};case 5:{if(b){A=v;break L744}else{aB=v;aC=z;aD=j}while(1){if(f){E=0;do{a[aC+E|0]=((d[aC+(E-g)|0]|0)>>>1)+(a[aB+E|0]|0)&255;E=E+1|0;}while((E|0)<(l|0))}a[aC+l|0]=-1;E=aD-1|0;if((E|0)==0){break}else{aB=aB+l|0;aC=aC+g|0;aD=E}}A=t+s|0;break L744;break};case 6:{if(b){A=v;break L744}else{aE=v;aF=z;aG=j}while(1){if(f){E=0;do{a[aF+E|0]=(a[aF+(E-g)|0]|0)+(a[aE+E|0]|0)&255;E=E+1|0;}while((E|0)<(l|0))}a[aF+l|0]=-1;E=aG-1|0;if((E|0)==0){break}else{aE=aE+l|0;aF=aF+g|0;aG=E}}A=t+s|0;break L744;break};default:{A=v;break L744}}}}while(0);u=h+1|0;if(u>>>0>=p>>>0){r=1;x=659;break}h=u;t=A;e=c[q>>2]|0}if((x|0)==659){return r|0}else if((x|0)==607){bT(1152,1472,2500,3536);return 0}else if((x|0)==560){c[2832]=1176;r=0;return r|0}return 0}function eV(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0;f=b+13956|0;a[f]=-1;g=b|0;h=c[g>>2]|0;i=h+168|0;j=c[i>>2]|0;k=h+172|0;do{if(j>>>0<(c[k>>2]|0)>>>0){l=j;m=667}else{n=h+32|0;if((c[n>>2]|0)==0){break}o=h+40|0;p=cl[c[h+16>>2]&3](c[h+28>>2]|0,o,c[h+36>>2]|0)|0;if((p|0)==0){c[n>>2]=0;n=(c[k>>2]|0)-1|0;c[i>>2]=n;a[n]=0;l=c[i>>2]|0;m=667;break}else{c[i>>2]=o;c[k>>2]=h+40+p;l=o;m=667;break}}}while(0);L882:do{if((m|0)==667){c[i>>2]=l+1;if((a[l]|0)!=-1){break}while(1){h=c[g>>2]|0;k=h+168|0;j=c[k>>2]|0;o=h+172|0;do{if(j>>>0<(c[o>>2]|0)>>>0){q=j}else{p=h+32|0;if((c[p>>2]|0)==0){break L882}n=h+40|0;r=cl[c[h+16>>2]&3](c[h+28>>2]|0,n,c[h+36>>2]|0)|0;if((r|0)==0){c[p>>2]=0;p=(c[o>>2]|0)-1|0;c[k>>2]=p;a[p]=0;q=c[k>>2]|0;break}else{c[k>>2]=n;c[o>>2]=h+40+r;q=n;break}}}while(0);c[k>>2]=q+1;h=a[q]|0;if((h<<24>>24|0)==(-40|0)){break}else if((h<<24>>24|0)!=(-1|0)){break L882}}if((e|0)==1){s=1;return s|0}h=a[f]|0;L897:do{if(h<<24>>24==-1){o=c[g>>2]|0;j=o+168|0;n=c[j>>2]|0;r=o+172|0;do{if(n>>>0<(c[r>>2]|0)>>>0){t=n}else{p=o+32|0;if((c[p>>2]|0)==0){u=-1;m=692;break L897}v=o+40|0;w=cl[c[o+16>>2]&3](c[o+28>>2]|0,v,c[o+36>>2]|0)|0;if((w|0)==0){c[p>>2]=0;p=(c[r>>2]|0)-1|0;c[j>>2]=p;a[p]=0;t=c[j>>2]|0;break}else{c[j>>2]=v;c[r>>2]=o+40+w;t=v;break}}}while(0);c[j>>2]=t+1;if((a[t]|0)!=-1){u=-1;m=692;break}while(1){o=c[g>>2]|0;r=o+168|0;n=c[r>>2]|0;k=o+172|0;do{if(n>>>0<(c[k>>2]|0)>>>0){x=n}else{v=o+32|0;if((c[v>>2]|0)==0){u=0;m=692;break L897}w=o+40|0;p=cl[c[o+16>>2]&3](c[o+28>>2]|0,w,c[o+36>>2]|0)|0;if((p|0)==0){c[v>>2]=0;v=(c[k>>2]|0)-1|0;c[r>>2]=v;a[v]=0;x=c[r>>2]|0;break}else{c[r>>2]=w;c[k>>2]=o+40+p;x=w;break}}}while(0);c[r>>2]=x+1;o=a[x]|0;if(o<<24>>24!=-1){y=o;m=690;break}}}else{a[f]=-1;y=h;m=690}}while(0);if((m|0)==690){if((y+64&255)>>>0>1>>>0){u=y;m=692}}L918:do{if((m|0)==692){L919:while(1){m=0;if((eW(b,u&255)|0)==0){s=0;m=838;break}h=a[f]|0;L922:do{if(h<<24>>24==-1){j=c[g>>2]|0;o=j+168|0;k=c[o>>2]|0;n=j+172|0;do{if(k>>>0<(c[n>>2]|0)>>>0){z=k;m=699}else{w=j+32|0;if((c[w>>2]|0)==0){break}p=j+40|0;v=cl[c[j+16>>2]&3](c[j+28>>2]|0,p,c[j+36>>2]|0)|0;if((v|0)==0){c[w>>2]=0;w=(c[n>>2]|0)-1|0;c[o>>2]=w;a[w]=0;z=c[o>>2]|0;m=699;break}else{c[o>>2]=p;c[n>>2]=j+40+v;z=p;m=699;break}}}while(0);do{if((m|0)==699){m=0;c[o>>2]=z+1;if((a[z]|0)!=-1){break}while(1){j=c[g>>2]|0;n=j+168|0;k=c[n>>2]|0;p=j+172|0;do{if(k>>>0<(c[p>>2]|0)>>>0){A=k}else{v=j+32|0;if((c[v>>2]|0)==0){u=0;m=692;continue L919}w=j+40|0;B=cl[c[j+16>>2]&3](c[j+28>>2]|0,w,c[j+36>>2]|0)|0;if((B|0)==0){c[v>>2]=0;v=(c[p>>2]|0)-1|0;c[n>>2]=v;a[v]=0;A=c[n>>2]|0;break}else{c[n>>2]=w;c[p>>2]=j+40+B;A=w;break}}}while(0);c[n>>2]=A+1;j=a[A]|0;if(j<<24>>24!=-1){C=j;break L922}}}}while(0);L941:while(1){o=c[g>>2]|0;do{if((c[o+16>>2]|0)==0){m=710}else{if((cf[c[o+24>>2]&15](c[o+28>>2]|0)|0)==0){break}if((c[o+32>>2]|0)==0){break L919}else{m=710}}}while(0);if((m|0)==710){m=0;if((c[o+168>>2]|0)>>>0>=(c[o+172>>2]|0)>>>0){break L919}}D=a[f]|0;if(D<<24>>24!=-1){m=713;break}j=c[g>>2]|0;p=j+168|0;k=c[p>>2]|0;w=j+172|0;do{if(k>>>0<(c[w>>2]|0)>>>0){E=k}else{B=j+32|0;if((c[B>>2]|0)==0){continue L941}v=j+40|0;F=cl[c[j+16>>2]&3](c[j+28>>2]|0,v,c[j+36>>2]|0)|0;if((F|0)==0){c[B>>2]=0;B=(c[w>>2]|0)-1|0;c[p>>2]=B;a[B]=0;E=c[p>>2]|0;break}else{c[p>>2]=v;c[w>>2]=j+40+F;E=v;break}}}while(0);c[p>>2]=E+1;if((a[E]|0)==-1){break}}if((m|0)==713){m=0;a[f]=-1;C=D;break}while(1){j=c[g>>2]|0;w=j+168|0;k=c[w>>2]|0;o=j+172|0;do{if(k>>>0<(c[o>>2]|0)>>>0){G=k}else{v=j+32|0;if((c[v>>2]|0)==0){u=0;m=692;continue L919}F=j+40|0;B=cl[c[j+16>>2]&3](c[j+28>>2]|0,F,c[j+36>>2]|0)|0;if((B|0)==0){c[v>>2]=0;v=(c[o>>2]|0)-1|0;c[w>>2]=v;a[v]=0;G=c[w>>2]|0;break}else{c[w>>2]=F;c[o>>2]=j+40+B;G=F;break}}}while(0);c[w>>2]=G+1;j=a[G]|0;if(j<<24>>24!=-1){C=j;break}}}else{a[f]=-1;C=h}}while(0);if((C+64&255)>>>0>1>>>0){u=C;m=692}else{break L918}}if((m|0)==838){return s|0}c[2832]=1104;s=0;return s|0}}while(0);h=c[g>>2]|0;r=h+168|0;j=c[r>>2]|0;o=h+172|0;k=c[o>>2]|0;do{if(j>>>0<k>>>0){p=j+1|0;c[r>>2]=p;H=d[j]|0;I=p;J=k}else{p=h+32|0;if((c[p>>2]|0)==0){H=0;I=j;J=k;break}F=h+40|0;B=cl[c[h+16>>2]&3](c[h+28>>2]|0,F,c[h+36>>2]|0)|0;if((B|0)==0){c[p>>2]=0;p=(c[o>>2]|0)-1|0;c[r>>2]=p;a[p]=0;K=c[r>>2]|0;L=c[o>>2]|0}else{c[r>>2]=F;p=h+40+B|0;c[o>>2]=p;K=F;L=p}p=K+1|0;c[r>>2]=p;H=d[K]|0;I=p;J=L}}while(0);k=H<<8;do{if(I>>>0<J>>>0){j=I+1|0;c[r>>2]=j;M=d[I]|0;N=j}else{j=h+32|0;if((c[j>>2]|0)==0){M=0;N=I;break}p=h+40|0;F=cl[c[h+16>>2]&3](c[h+28>>2]|0,p,c[h+36>>2]|0)|0;if((F|0)==0){c[j>>2]=0;j=(c[o>>2]|0)-1|0;c[r>>2]=j;a[j]=0;O=c[r>>2]|0}else{c[r>>2]=p;c[o>>2]=h+40+F;O=p}p=O+1|0;c[r>>2]=p;M=d[O]|0;N=p}}while(0);p=M|k;if(p>>>0<11>>>0){c[2832]=1064;s=0;return s|0}do{if(N>>>0<(c[o>>2]|0)>>>0){P=N;m=747}else{F=h+32|0;if((c[F>>2]|0)==0){break}j=h+40|0;B=cl[c[h+16>>2]&3](c[h+28>>2]|0,j,c[h+36>>2]|0)|0;if((B|0)==0){c[F>>2]=0;F=(c[o>>2]|0)-1|0;c[r>>2]=F;a[F]=0;P=c[r>>2]|0;m=747;break}else{c[r>>2]=j;c[o>>2]=h+40+B;P=j;m=747;break}}}while(0);do{if((m|0)==747){k=P+1|0;c[r>>2]=k;if((a[P]|0)!=8){break}j=c[o>>2]|0;do{if(k>>>0<j>>>0){B=P+2|0;c[r>>2]=B;Q=d[k]|0;R=B;S=j}else{B=h+32|0;if((c[B>>2]|0)==0){Q=0;R=k;S=j;break}F=h+40|0;v=cl[c[h+16>>2]&3](c[h+28>>2]|0,F,c[h+36>>2]|0)|0;if((v|0)==0){c[B>>2]=0;B=(c[o>>2]|0)-1|0;c[r>>2]=B;a[B]=0;T=c[r>>2]|0;U=c[o>>2]|0}else{c[r>>2]=F;B=h+40+v|0;c[o>>2]=B;T=F;U=B}B=T+1|0;c[r>>2]=B;Q=d[T]|0;R=B;S=U}}while(0);j=Q<<8;do{if(R>>>0<S>>>0){k=R+1|0;c[r>>2]=k;V=d[R]|0;W=k}else{k=h+32|0;if((c[k>>2]|0)==0){V=0;W=R;break}B=h+40|0;F=cl[c[h+16>>2]&3](c[h+28>>2]|0,B,c[h+36>>2]|0)|0;if((F|0)==0){c[k>>2]=0;k=(c[o>>2]|0)-1|0;c[r>>2]=k;a[k]=0;X=c[r>>2]|0}else{c[r>>2]=B;c[o>>2]=h+40+F;X=B}B=X+1|0;c[r>>2]=B;V=d[X]|0;W=B}}while(0);B=V|j;F=h+4|0;c[F>>2]=B;if((B|0)==0){c[2832]=1016;s=0;return s|0}B=c[o>>2]|0;do{if(W>>>0<B>>>0){k=W+1|0;c[r>>2]=k;Y=d[W]|0;Z=k;_=B}else{k=h+32|0;if((c[k>>2]|0)==0){Y=0;Z=W;_=B;break}v=h+40|0;aa=cl[c[h+16>>2]&3](c[h+28>>2]|0,v,c[h+36>>2]|0)|0;if((aa|0)==0){c[k>>2]=0;k=(c[o>>2]|0)-1|0;c[r>>2]=k;a[k]=0;ab=c[r>>2]|0;ac=c[o>>2]|0}else{c[r>>2]=v;k=h+40+aa|0;c[o>>2]=k;ab=v;ac=k}k=ab+1|0;c[r>>2]=k;Y=d[ab]|0;Z=k;_=ac}}while(0);B=Y<<8;do{if(Z>>>0<_>>>0){j=Z+1|0;c[r>>2]=j;ad=d[Z]|0;ae=j}else{j=h+32|0;if((c[j>>2]|0)==0){ad=0;ae=Z;break}k=h+40|0;v=cl[c[h+16>>2]&3](c[h+28>>2]|0,k,c[h+36>>2]|0)|0;if((v|0)==0){c[j>>2]=0;j=(c[o>>2]|0)-1|0;c[r>>2]=j;a[j]=0;af=c[r>>2]|0}else{c[r>>2]=k;c[o>>2]=h+40+v;af=k}k=af+1|0;c[r>>2]=k;ad=d[af]|0;ae=k}}while(0);k=ad|B;v=h|0;c[v>>2]=k;if((k|0)==0){c[2832]=968;s=0;return s|0}do{if(ae>>>0<(c[o>>2]|0)>>>0){ag=ae;m=786}else{k=h+32|0;if((c[k>>2]|0)==0){break}j=h+40|0;aa=cl[c[h+16>>2]&3](c[h+28>>2]|0,j,c[h+36>>2]|0)|0;if((aa|0)==0){c[k>>2]=0;k=(c[o>>2]|0)-1|0;c[r>>2]=k;a[k]=0;ag=c[r>>2]|0;m=786;break}else{c[r>>2]=j;c[o>>2]=h+40+aa;ag=j;m=786;break}}}while(0);do{if((m|0)==786){c[r>>2]=ag+1;B=a[ag]|0;j=B&255;if(!((j|0)==3|(j|0)==1)){break}aa=h+8|0;c[aa>>2]=j;if(B<<24>>24==0){ah=j}else{B=0;do{c[b+13724+(B*56|0)+44>>2]=0;c[b+13724+(B*56|0)+52>>2]=0;B=B+1|0;}while((B|0)<(j|0));ah=c[aa>>2]|0}if((p|0)!=((ah*3|0)+8|0)){c[2832]=1064;s=0;return s|0}L1068:do{if((ah|0)>0){j=h+32|0;B=h+16|0;k=h+28|0;ai=h+40|0;aj=h+36|0;ak=0;L1070:while(1){al=c[r>>2]|0;do{if(al>>>0<(c[o>>2]|0)>>>0){c[r>>2]=al+1;am=d[al]|0}else{if((c[j>>2]|0)==0){am=0;break}an=cl[c[B>>2]&3](c[k>>2]|0,ai,c[aj>>2]|0)|0;if((an|0)==0){c[j>>2]=0;ao=(c[o>>2]|0)-1|0;c[r>>2]=ao;a[ao]=0;ap=c[r>>2]|0}else{c[r>>2]=ai;c[o>>2]=h+40+an;ap=ai}c[r>>2]=ap+1;am=d[ap]|0}}while(0);c[b+13724+(ak*56|0)>>2]=am;al=ak+1|0;if(!((am|0)==(al|0)|(am|0)==(ak|0))){m=803;break}w=c[r>>2]|0;do{if(w>>>0<(c[o>>2]|0)>>>0){aq=w}else{if((c[j>>2]|0)==0){m=806;break L1070}an=cl[c[B>>2]&3](c[k>>2]|0,ai,c[aj>>2]|0)|0;if((an|0)==0){c[j>>2]=0;ao=(c[o>>2]|0)-1|0;c[r>>2]=ao;a[ao]=0;aq=c[r>>2]|0;break}else{c[r>>2]=ai;c[o>>2]=h+40+an;aq=ai;break}}}while(0);c[r>>2]=aq+1;w=a[aq]|0;an=w&255;ao=an>>>4;c[b+13724+(ak*56|0)+4>>2]=ao;if((ao|0)==0|(w&255)>>>0>79>>>0){break}w=an&15;c[b+13724+(ak*56|0)+8>>2]=w;if((w|0)==0|w>>>0>4>>>0){m=813;break}w=c[r>>2]|0;do{if(w>>>0<(c[o>>2]|0)>>>0){ar=w;m=820}else{if((c[j>>2]|0)==0){c[b+13724+(ak*56|0)+12>>2]=0;break}an=cl[c[B>>2]&3](c[k>>2]|0,ai,c[aj>>2]|0)|0;if((an|0)==0){c[j>>2]=0;ao=(c[o>>2]|0)-1|0;c[r>>2]=ao;a[ao]=0;ar=c[r>>2]|0;m=820;break}else{c[r>>2]=ai;c[o>>2]=h+40+an;ar=ai;m=820;break}}}while(0);if((m|0)==820){m=0;c[r>>2]=ar+1;w=a[ar]|0;c[b+13724+(ak*56|0)+12>>2]=w&255;if((w&255)>>>0>3>>>0){m=822;break}}w=c[aa>>2]|0;if((al|0)<(w|0)){ak=al}else{as=w;break L1068}}if((m|0)==803){c[2832]=904;s=0;return s|0}else if((m|0)==806){c[b+13724+(ak*56|0)+4>>2]=0}else if((m|0)==813){c[2832]=888;s=0;return s|0}else if((m|0)==822){c[2832]=880;s=0;return s|0}c[2832]=896;s=0;return s|0}else{as=ah}}while(0);if((e|0)!=0){s=1;return s|0}if((((1073741824/((c[v>>2]|0)>>>0)|0)>>>0)/(as>>>0)|0)>>>0<(c[F>>2]|0)>>>0){c[2832]=2088;s=0;return s|0}if((as|0)>0){ai=0;j=1;aj=1;while(1){k=c[b+13724+(ai*56|0)+4>>2]|0;B=(k|0)>(j|0)?k:j;k=c[b+13724+(ai*56|0)+8>>2]|0;w=(k|0)>(aj|0)?k:aj;k=ai+1|0;if((k|0)<(as|0)){ai=k;j=B;aj=w}else{at=B;au=w;break}}}else{at=1;au=1}c[b+13700>>2]=at;c[b+13704>>2]=au;aj=at<<3;c[b+13716>>2]=aj;j=au<<3;c[b+13720>>2]=j;ai=b+13708|0;c[ai>>2]=(((c[v>>2]|0)-1+aj|0)>>>0)/(aj>>>0)|0;aj=b+13712|0;c[aj>>2]=((j-1+(c[F>>2]|0)|0)>>>0)/(j>>>0)|0;if((c[aa>>2]|0)<=0){s=1;return s|0}j=at-1|0;w=au-1|0;B=0;while(1){k=c[b+13724+(B*56|0)+4>>2]|0;c[b+13724+(B*56|0)+28>>2]=((j+($(k,c[v>>2]|0)|0)|0)>>>0)/(at>>>0)|0;an=c[b+13724+(B*56|0)+8>>2]|0;c[b+13724+(B*56|0)+32>>2]=((w+($(an,c[F>>2]|0)|0)|0)>>>0)/(au>>>0)|0;ao=$(c[ai>>2]<<3,k)|0;c[b+13724+(B*56|0)+36>>2]=ao;k=$(c[aj>>2]<<3,an)|0;c[b+13724+(B*56|0)+40>>2]=k;an=fs($(k,ao)|0|15)|0;c[b+13724+(B*56|0)+48>>2]=an;if((an|0)==0){break}c[b+13724+(B*56|0)+44>>2]=an+15&-16;c[b+13724+(B*56|0)+52>>2]=0;an=B+1|0;if((an|0)<(c[aa>>2]|0)){B=an}else{s=1;m=854;break}}if((m|0)==854){return s|0}if((B|0)>0){aa=B;do{aa=aa-1|0;ft(c[b+13724+(aa*56|0)+48>>2]|0);c[b+13724+(aa*56|0)+44>>2]=0;}while((aa|0)>0)}c[2832]=1560;s=0;return s|0}}while(0);c[2832]=944;s=0;return s|0}}while(0);c[2832]=1048;s=0;return s|0}}while(0);c[2832]=1128;s=0;return s|0}function eW(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0;f=i;i=i+64|0;g=f|0;switch(e|0){case 255:{c[2832]=848;h=0;i=f;return h|0};case 194:{c[2832]=824;h=0;i=f;return h|0};case 221:{j=b|0;k=c[j>>2]|0;l=k+168|0;m=c[l>>2]|0;n=k+172|0;o=c[n>>2]|0;do{if(m>>>0<o>>>0){p=m+1|0;c[l>>2]=p;q=d[m]|0;r=p;s=o}else{p=k+32|0;if((c[p>>2]|0)==0){q=0;r=m;s=o;break}t=k+40|0;u=cl[c[k+16>>2]&3](c[k+28>>2]|0,t,c[k+36>>2]|0)|0;if((u|0)==0){c[p>>2]=0;p=(c[n>>2]|0)-1|0;c[l>>2]=p;a[p]=0;v=c[l>>2]|0;w=c[n>>2]|0}else{c[l>>2]=t;p=k+40+u|0;c[n>>2]=p;v=t;w=p}p=v+1|0;c[l>>2]=p;q=d[v]|0;r=p;s=w}}while(0);w=q<<8;do{if(r>>>0<s>>>0){c[l>>2]=r+1;x=d[r]|0}else{q=k+32|0;if((c[q>>2]|0)==0){x=0;break}v=k+40|0;o=cl[c[k+16>>2]&3](c[k+28>>2]|0,v,c[k+36>>2]|0)|0;if((o|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;y=c[l>>2]|0}else{c[l>>2]=v;c[n>>2]=k+40+o;y=v}c[l>>2]=y+1;x=d[y]|0}}while(0);if((x|w|0)!=4){c[2832]=800;h=0;i=f;return h|0}w=c[j>>2]|0;j=w+168|0;x=c[j>>2]|0;y=w+172|0;l=c[y>>2]|0;do{if(x>>>0<l>>>0){k=x+1|0;c[j>>2]=k;z=d[x]|0;A=k;B=l}else{k=w+32|0;if((c[k>>2]|0)==0){z=0;A=x;B=l;break}n=w+40|0;r=cl[c[w+16>>2]&3](c[w+28>>2]|0,n,c[w+36>>2]|0)|0;if((r|0)==0){c[k>>2]=0;k=(c[y>>2]|0)-1|0;c[j>>2]=k;a[k]=0;C=c[j>>2]|0;D=c[y>>2]|0}else{c[j>>2]=n;k=w+40+r|0;c[y>>2]=k;C=n;D=k}k=C+1|0;c[j>>2]=k;z=d[C]|0;A=k;B=D}}while(0);D=z<<8;do{if(A>>>0<B>>>0){c[j>>2]=A+1;E=d[A]|0}else{z=w+32|0;if((c[z>>2]|0)==0){E=0;break}C=w+40|0;l=cl[c[w+16>>2]&3](c[w+28>>2]|0,C,c[w+36>>2]|0)|0;if((l|0)==0){c[z>>2]=0;z=(c[y>>2]|0)-1|0;c[j>>2]=z;a[z]=0;F=c[j>>2]|0}else{c[j>>2]=C;c[y>>2]=w+40+l;F=C}c[j>>2]=F+1;E=d[F]|0}}while(0);c[b+13984>>2]=E|D;h=1;i=f;return h|0};case 219:{D=b|0;E=c[D>>2]|0;F=E+168|0;j=c[F>>2]|0;w=E+172|0;y=c[w>>2]|0;do{if(j>>>0<y>>>0){A=j+1|0;c[F>>2]=A;G=d[j]|0;H=A;I=y}else{A=E+32|0;if((c[A>>2]|0)==0){G=0;H=j;I=y;break}B=E+40|0;C=cl[c[E+16>>2]&3](c[E+28>>2]|0,B,c[E+36>>2]|0)|0;if((C|0)==0){c[A>>2]=0;A=(c[w>>2]|0)-1|0;c[F>>2]=A;a[A]=0;J=c[F>>2]|0;K=c[w>>2]|0}else{c[F>>2]=B;A=E+40+C|0;c[w>>2]=A;J=B;K=A}A=J+1|0;c[F>>2]=A;G=d[J]|0;H=A;I=K}}while(0);K=G<<8;do{if(H>>>0<I>>>0){c[F>>2]=H+1;L=d[H]|0}else{G=E+32|0;if((c[G>>2]|0)==0){L=0;break}J=E+40|0;y=cl[c[E+16>>2]&3](c[E+28>>2]|0,J,c[E+36>>2]|0)|0;if((y|0)==0){c[G>>2]=0;G=(c[w>>2]|0)-1|0;c[F>>2]=G;a[G]=0;M=c[F>>2]|0}else{c[F>>2]=J;c[w>>2]=E+40+y;M=J}c[F>>2]=M+1;L=d[M]|0}}while(0);M=(L|K)-2|0;L1211:do{if((M|0)>0){K=M;while(1){L=c[D>>2]|0;F=L+168|0;E=c[F>>2]|0;w=L+172|0;do{if(E>>>0<(c[w>>2]|0)>>>0){N=E;O=910}else{H=L+32|0;if((c[H>>2]|0)==0){P=0;break}I=L+40|0;J=cl[c[L+16>>2]&3](c[L+28>>2]|0,I,c[L+36>>2]|0)|0;if((J|0)==0){c[H>>2]=0;H=(c[w>>2]|0)-1|0;c[F>>2]=H;a[H]=0;N=c[F>>2]|0;O=910;break}else{c[F>>2]=I;c[w>>2]=L+40+J;N=I;O=910;break}}}while(0);if((O|0)==910){O=0;c[F>>2]=N+1;L=a[N]|0;w=L&15;if((L&255)>>>0>15>>>0){O=911;break}if(w>>>0>3>>>0){O=913;break}else{P=w}}w=0;do{L=c[D>>2]|0;E=L+168|0;I=c[E>>2]|0;J=L+172|0;do{if(I>>>0<(c[J>>2]|0)>>>0){c[E>>2]=I+1;Q=a[I]|0}else{H=L+32|0;if((c[H>>2]|0)==0){Q=0;break}y=L+40|0;G=cl[c[L+16>>2]&3](c[L+28>>2]|0,y,c[L+36>>2]|0)|0;if((G|0)==0){c[H>>2]=0;H=(c[J>>2]|0)-1|0;c[E>>2]=H;a[H]=0;R=c[E>>2]|0}else{c[E>>2]=y;c[J>>2]=L+40+G;R=y}c[E>>2]=R+1;Q=a[R]|0}}while(0);a[(d[6096+w|0]|0)+(b+13444+(P<<6))|0]=Q;w=w+1|0;}while((w|0)<64);w=K-65|0;if((w|0)>0){K=w}else{S=w;break L1211}}if((O|0)==911){c[2832]=776;h=0;i=f;return h|0}else if((O|0)==913){c[2832]=752;h=0;i=f;return h|0}}else{S=M}}while(0);h=(S|0)==0|0;i=f;return h|0};case 196:{S=b|0;M=c[S>>2]|0;Q=M+168|0;P=c[Q>>2]|0;R=M+172|0;D=c[R>>2]|0;do{if(P>>>0<D>>>0){N=P+1|0;c[Q>>2]=N;T=d[P]|0;U=N;V=D}else{N=M+32|0;if((c[N>>2]|0)==0){T=0;U=P;V=D;break}K=M+40|0;w=cl[c[M+16>>2]&3](c[M+28>>2]|0,K,c[M+36>>2]|0)|0;if((w|0)==0){c[N>>2]=0;N=(c[R>>2]|0)-1|0;c[Q>>2]=N;a[N]=0;W=c[Q>>2]|0;X=c[R>>2]|0}else{c[Q>>2]=K;N=M+40+w|0;c[R>>2]=N;W=K;X=N}N=W+1|0;c[Q>>2]=N;T=d[W]|0;U=N;V=X}}while(0);X=T<<8;do{if(U>>>0<V>>>0){c[Q>>2]=U+1;Y=d[U]|0}else{T=M+32|0;if((c[T>>2]|0)==0){Y=0;break}W=M+40|0;D=cl[c[M+16>>2]&3](c[M+28>>2]|0,W,c[M+36>>2]|0)|0;if((D|0)==0){c[T>>2]=0;T=(c[R>>2]|0)-1|0;c[Q>>2]=T;a[T]=0;Z=c[Q>>2]|0}else{c[Q>>2]=W;c[R>>2]=M+40+D;Z=W}c[Q>>2]=Z+1;Y=d[Z]|0}}while(0);Z=(Y|X)-2|0;L1262:do{if((Z|0)>0){X=g|0;Y=Z;while(1){Q=c[S>>2]|0;M=Q+168|0;R=c[M>>2]|0;U=Q+172|0;do{if(R>>>0<(c[U>>2]|0)>>>0){c[M>>2]=R+1;_=d[R]|0}else{V=Q+32|0;if((c[V>>2]|0)==0){_=0;break}W=Q+40|0;D=cl[c[Q+16>>2]&3](c[Q+28>>2]|0,W,c[Q+36>>2]|0)|0;if((D|0)==0){c[V>>2]=0;V=(c[U>>2]|0)-1|0;c[M>>2]=V;a[V]=0;$=c[M>>2]|0}else{c[M>>2]=W;c[U>>2]=Q+40+D;$=W}c[M>>2]=$+1;_=d[$]|0}}while(0);M=_&15;if(_>>>0>31>>>0|M>>>0>3>>>0){O=948;break}else{aa=0;ab=0}do{Q=c[S>>2]|0;U=Q+168|0;R=c[U>>2]|0;W=Q+172|0;do{if(R>>>0<(c[W>>2]|0)>>>0){c[U>>2]=R+1;ac=d[R]|0}else{D=Q+32|0;if((c[D>>2]|0)==0){ac=0;break}V=Q+40|0;T=cl[c[Q+16>>2]&3](c[Q+28>>2]|0,V,c[Q+36>>2]|0)|0;if((T|0)==0){c[D>>2]=0;D=(c[W>>2]|0)-1|0;c[U>>2]=D;a[D]=0;ad=c[U>>2]|0}else{c[U>>2]=V;c[W>>2]=Q+40+T;ad=V}c[U>>2]=ad+1;ac=d[ad]|0}}while(0);c[g+(aa<<2)>>2]=ac;ab=ac+ab|0;aa=aa+1|0;}while((aa|0)<16);U=Y-17|0;if((_&240|0)==0){if((eX(b+4+(M*1680|0)|0,X)|0)==0){h=0;O=1001;break}ae=b+4+(M*1680|0)+1024|0}else{if((eX(b+6724+(M*1680|0)|0,X)|0)==0){h=0;O=1002;break}ae=b+6724+(M*1680|0)+1024|0}if((ab|0)>0){Q=0;do{W=c[S>>2]|0;R=W+168|0;V=c[R>>2]|0;T=W+172|0;do{if(V>>>0<(c[T>>2]|0)>>>0){c[R>>2]=V+1;af=a[V]|0}else{D=W+32|0;if((c[D>>2]|0)==0){af=0;break}P=W+40|0;N=cl[c[W+16>>2]&3](c[W+28>>2]|0,P,c[W+36>>2]|0)|0;if((N|0)==0){c[D>>2]=0;D=(c[T>>2]|0)-1|0;c[R>>2]=D;a[D]=0;ag=c[R>>2]|0}else{c[R>>2]=P;c[T>>2]=W+40+N;ag=P}c[R>>2]=ag+1;af=a[ag]|0}}while(0);a[ae+Q|0]=af;Q=Q+1|0;}while((Q|0)<(ab|0))}Q=U-ab|0;if((Q|0)>0){Y=Q}else{ah=Q;break L1262}}if((O|0)==948){c[2832]=736;h=0;i=f;return h|0}else if((O|0)==1002){i=f;return h|0}else if((O|0)==1001){i=f;return h|0}}else{ah=Z}}while(0);h=(ah|0)==0|0;i=f;return h|0};default:{if(!((e-224|0)>>>0<16>>>0|(e|0)==254)){h=0;i=f;return h|0}e=c[b>>2]|0;b=e+168|0;ah=c[b>>2]|0;Z=e+172|0;O=c[Z>>2]|0;do{if(ah>>>0<O>>>0){ab=ah+1|0;c[b>>2]=ab;ai=d[ah]|0;aj=ab;ak=O}else{ab=e+32|0;if((c[ab>>2]|0)==0){ai=0;aj=ah;ak=O;break}af=e+40|0;ae=cl[c[e+16>>2]&3](c[e+28>>2]|0,af,c[e+36>>2]|0)|0;if((ae|0)==0){c[ab>>2]=0;ab=(c[Z>>2]|0)-1|0;c[b>>2]=ab;a[ab]=0;al=c[b>>2]|0;am=c[Z>>2]|0}else{c[b>>2]=af;ab=e+40+ae|0;c[Z>>2]=ab;al=af;am=ab}ab=al+1|0;c[b>>2]=ab;ai=d[al]|0;aj=ab;ak=am}}while(0);am=ai<<8;do{if(aj>>>0<ak>>>0){ai=aj+1|0;c[b>>2]=ai;an=d[aj]|0;ao=ai}else{ai=e+32|0;if((c[ai>>2]|0)==0){an=0;ao=aj;break}al=e+40|0;O=cl[c[e+16>>2]&3](c[e+28>>2]|0,al,c[e+36>>2]|0)|0;if((O|0)==0){c[ai>>2]=0;ai=(c[Z>>2]|0)-1|0;c[b>>2]=ai;a[ai]=0;ap=c[b>>2]|0}else{c[b>>2]=al;c[Z>>2]=e+40+O;ap=al}al=ap+1|0;c[b>>2]=al;an=d[ap]|0;ao=al}}while(0);ap=(an|am)-2|0;do{if((c[e+16>>2]|0)!=0){am=c[Z>>2]|0;an=am-ao|0;if((an|0)>=(ap|0)){break}c[b>>2]=am;cj[c[e+20>>2]&63](c[e+28>>2]|0,ap-an|0);h=1;i=f;return h|0}}while(0);c[b>>2]=ao+ap;h=1;i=f;return h|0}}return 0}function eX(f,g){f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;h=0;i=0;while(1){j=g+(i<<2)|0;k=i+1|0;if((c[j>>2]|0)>0){l=k&255;m=h;n=0;while(1){o=m+1|0;a[f+1280+m|0]=l;p=n+1|0;if((p|0)<(c[j>>2]|0)){m=o;n=p}else{q=o;break}}}else{q=h}if((k|0)<16){h=q;i=k}else{break}}a[f+1280+q|0]=0;q=0;i=0;h=1;while(1){c[f+1612+(h<<2)>>2]=q-i;if((d[f+1280+q|0]|0|0)==(h|0)){g=q;n=i;while(1){r=n+1|0;s=g+1|0;b[f+512+(g<<1)>>1]=n&65535;if((d[f+1280+s|0]|0|0)==(h|0)){g=s;n=r}else{break}}if((n|0)<(1<<h|0)){t=r;u=s}else{v=1016;break}}else{t=i;u=q}c[f+1540+(h<<2)>>2]=t<<16-h;w=h+1|0;if((w|0)<17){q=u;i=t<<1;h=w}else{break}}if((v|0)==1016){c[2832]=712;x=0;return x|0}c[f+1540+(w<<2)>>2]=-1;fF(f|0,-1|0,512);if((u|0)>0){y=0}else{x=1;return x|0}while(1){w=a[f+1280+y|0]|0;do{if((w&255)>>>0<10>>>0){v=9-(w&255)|0;h=1<<v;if((h|0)<=0){break}fF(f+((e[f+512+(y<<1)>>1]|0)<<v)|0,y&255|0,h|0)}}while(0);w=y+1|0;if((w|0)<(u|0)){y=w}else{x=1;break}}return x|0}function eY(f,g,h){f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;j=i;i=i+136|0;k=j|0;l=j+64|0;fF(l|0,0,68);fF(f|0,-1|0,1024);m=(h|0)>0;if(m){n=0;do{o=l+((d[g+n|0]|0)<<2)|0;c[o>>2]=(c[o>>2]|0)+1;n=n+1|0;}while((n|0)<(h|0))}c[l>>2]=0;n=1;while(1){if((n|0)>=16){p=0;q=0;r=1;break}if((c[l+(n<<2)>>2]|0)>(1<<n|0)){s=1032;break}else{n=n+1|0}}if((s|0)==1032){bT(320,1472,1996,3600);return 0}while(1){c[k+(r<<2)>>2]=q;b[f+1024+(r<<1)>>1]=q&65535;b[f+1124+(r<<1)>>1]=p&65535;n=c[l+(r<<2)>>2]|0;o=n+q|0;if((n|0)!=0){if((o-1|0)>=(1<<r|0)){s=1035;break}}c[f+1056+(r<<2)>>2]=o<<16-r;t=r+1|0;if((t|0)<16){p=n+p|0;q=o<<1;r=t}else{break}}if((s|0)==1035){c[2832]=344;u=0;i=j;return u|0}c[f+1120>>2]=65536;if(m){v=0}else{u=1;i=j;return u|0}while(1){m=a[g+v|0]|0;s=m&255;if(m<<24>>24!=0){r=k+(s<<2)|0;q=c[r>>2]|0;p=q-(e[f+1024+(s<<1)>>1]|0)+(e[f+1124+(s<<1)>>1]|0)|0;a[f+1156+p|0]=m;b[f+1444+(p<<1)>>1]=v&65535;do{if((m&255)>>>0<10>>>0){l=q>>>1&21845|q<<1&43690;t=l>>>2&13107|l<<2&52428;l=t>>>4&3855|t<<4&61680;t=(l<<8&65280|l>>>8)>>>((16-s|0)>>>0);if((t|0)>=512){break}l=p&65535;o=1<<s;n=t;do{b[f+(n<<1)>>1]=l;n=n+o|0;}while((n|0)<512)}}while(0);c[r>>2]=q+1}s=v+1|0;if((s|0)<(h|0)){v=s}else{u=1;break}}i=j;return u|0}function eZ(a,f){a=a|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=a+8|0;h=c[g>>2]|0;i=a+12|0;L1404:do{if((h|0)<16){j=a|0;k=a+4|0;l=c[i>>2]|0;m=h;while(1){if(l>>>0>=1<<m>>>0){break}n=c[j>>2]|0;if(n>>>0<(c[k>>2]|0)>>>0){c[j>>2]=n+1;o=d[n]|0}else{o=0}n=o<<m|l;c[i>>2]=n;p=m+8|0;c[g>>2]=p;if((p|0)<25){l=n;m=p}else{q=p;r=n;break L1404}}bT(416,1472,2058,3408);return 0}else{q=h;r=c[i>>2]|0}}while(0);i=a+12|0;a=b[f+((r&511)<<1)>>1]|0;h=a&65535;if(a<<16>>16!=-1){a=d[f+1156+h|0]|0;c[i>>2]=r>>>(a>>>0);c[g>>2]=q-a;s=e[f+1444+(h<<1)>>1]|0;return s|0}h=r>>>1&21845|r<<1&43690;a=h>>>2&13107|h<<2&52428;h=a>>>4&3855|a<<4&61680;a=h<<8&65280|h>>>8;h=10;while(1){if((a|0)<(c[f+1056+(h<<2)>>2]|0)){break}else{h=h+1|0}}if((h|0)==16){s=-1;return s|0}o=(a>>>((16-h|0)>>>0))-(e[f+1024+(h<<1)>>1]|0)+(e[f+1124+(h<<1)>>1]|0)|0;if((d[f+1156+o|0]|0|0)!=(h|0)){bT(456,1472,2095,3584);return 0}c[i>>2]=r>>>(h>>>0);c[g>>2]=q-h;s=e[f+1444+(o<<1)>>1]|0;return s|0}function e_(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;if((f|0)==(e|0)){i=b;return i|0}if((f-1|0)>>>0>=4>>>0){bT(104,1472,840,3632);return 0}j=fs($($(g,f)|0,h)|0)|0;if((j|0)==0){ft(b);c[2832]=1560;i=0;return i|0}L1440:do{if((h|0)>0){k=(e<<3)+f|0;l=g-1|0;m=(l|0)>-1;n=0;L1442:while(1){o=$(n,g)|0;p=b+($(o,e)|0)|0;q=j+($(o,f)|0)|0;L1444:do{switch(k|0){case 19:{if(m){r=p;s=q;t=l}else{break L1444}while(1){o=a[r]|0;a[s+2|0]=o;a[s+1|0]=o;a[s]=o;o=t-1|0;if((o|0)>-1){r=r+2|0;s=s+3|0;t=o}else{break}}break};case 26:{if(m){u=p;v=q;w=l}else{break L1444}while(1){a[v]=(((d[u+1|0]|0)*150|0)+((d[u]|0)*77|0)+((d[u+2|0]|0)*29|0)|0)>>>8&255;a[v+1|0]=-1;o=w-1|0;if((o|0)>-1){u=u+3|0;v=v+2|0;w=o}else{break}}break};case 33:{if(m){x=p;y=q;z=l}else{break L1444}while(1){a[y]=(((d[x+1|0]|0)*150|0)+((d[x]|0)*77|0)+((d[x+2|0]|0)*29|0)|0)>>>8&255;o=z-1|0;if((o|0)>-1){x=x+4|0;y=y+1|0;z=o}else{break}}break};case 11:{if(m){A=p;B=q;C=l}else{break L1444}while(1){o=a[A]|0;a[B+2|0]=o;a[B+1|0]=o;a[B]=o;o=C-1|0;if((o|0)>-1){A=A+1|0;B=B+3|0;C=o}else{break}}break};case 12:{if(m){D=p;E=q;F=l}else{break L1444}while(1){o=a[D]|0;a[E+2|0]=o;a[E+1|0]=o;a[E]=o;a[E+3|0]=-1;o=F-1|0;if((o|0)>-1){D=D+1|0;E=E+4|0;F=o}else{break}}break};case 28:{if(m){G=p;H=q;I=l}else{break L1444}while(1){a[H]=a[G]|0;a[H+1|0]=a[G+1|0]|0;a[H+2|0]=a[G+2|0]|0;a[H+3|0]=-1;o=I-1|0;if((o|0)>-1){G=G+3|0;H=H+4|0;I=o}else{break}}break};case 25:{if(m){J=p;K=q;L=l}else{break L1444}while(1){a[K]=(((d[J+1|0]|0)*150|0)+((d[J]|0)*77|0)+((d[J+2|0]|0)*29|0)|0)>>>8&255;o=L-1|0;if((o|0)>-1){J=J+3|0;K=K+1|0;L=o}else{break}}break};case 20:{if(m){M=p;N=q;O=l}else{break L1444}while(1){o=a[M]|0;a[N+2|0]=o;a[N+1|0]=o;a[N]=o;a[N+3|0]=a[M+1|0]|0;o=O-1|0;if((o|0)>-1){M=M+2|0;N=N+4|0;O=o}else{break}}break};case 17:{if(m){P=p;Q=q;R=l}else{break L1444}while(1){a[Q]=a[P]|0;o=R-1|0;if((o|0)>-1){P=P+2|0;Q=Q+1|0;R=o}else{break}}break};case 34:{if(m){S=p;T=q;U=l}else{break L1444}while(1){a[T]=(((d[S+1|0]|0)*150|0)+((d[S]|0)*77|0)+((d[S+2|0]|0)*29|0)|0)>>>8&255;a[T+1|0]=a[S+3|0]|0;o=U-1|0;if((o|0)>-1){S=S+4|0;T=T+2|0;U=o}else{break}}break};case 35:{if(m){V=p;W=q;X=l}else{break L1444}while(1){a[W]=a[V]|0;a[W+1|0]=a[V+1|0]|0;a[W+2|0]=a[V+2|0]|0;o=X-1|0;if((o|0)>-1){V=V+4|0;W=W+3|0;X=o}else{break}}break};case 10:{if(m){Y=p;Z=q;_=l}else{break L1444}while(1){a[Z]=a[Y]|0;a[Z+1|0]=-1;o=_-1|0;if((o|0)>-1){Y=Y+1|0;Z=Z+2|0;_=o}else{break}}break};default:{break L1442}}}while(0);n=n+1|0;if((n|0)>=(h|0)){break L1440}}bT(2968,1472,869,3632);return 0}}while(0);ft(b);i=j;return i|0}function e$(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=b+16|0;g=b+168|0;h=b+172|0;i=b+24|0;j=b+28|0;k=b+32|0;L1486:do{if((d&128|0)==0){l=1115}else{do{if((c[f>>2]|0)==0){l=1112}else{if((cf[c[i>>2]&15](c[j>>2]|0)|0)==0){break}if((c[k>>2]|0)==0){break L1486}else{l=1112}}}while(0);if((l|0)==1112){if((c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0){break}}a[e]=eO(b)|0;l=1115}}while(0);L1494:do{if((l|0)==1115){if((d&64|0)!=0){do{if((c[f>>2]|0)==0){l=1120}else{if((cf[c[i>>2]&15](c[j>>2]|0)|0)==0){break}if((c[k>>2]|0)==0){break L1494}else{l=1120}}}while(0);if((l|0)==1120){if((c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0){break}}a[e+1|0]=eO(b)|0}if((d&32|0)!=0){do{if((c[f>>2]|0)==0){l=1126}else{if((cf[c[i>>2]&15](c[j>>2]|0)|0)==0){break}if((c[k>>2]|0)==0){break L1494}else{l=1126}}}while(0);if((l|0)==1126){if((c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0){break}}a[e+2|0]=eO(b)|0}if((d&16|0)==0){m=e;return m|0}do{if((c[f>>2]|0)==0){l=1132}else{if((cf[c[i>>2]&15](c[j>>2]|0)|0)==0){break}if((c[k>>2]|0)==0){break L1494}else{l=1132}}}while(0);if((l|0)==1132){if((c[g>>2]|0)>>>0>=(c[h>>2]|0)>>>0){break}}a[e+3|0]=eO(b)|0;m=e;return m|0}}while(0);c[2832]=136;m=0;return m|0}function e0(e,f){e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=f&65535;f=b[e+2080+(g<<2)>>1]|0;if(f<<16>>16>-1){e0(e,f)}f=e+18500|0;h=c[f>>2]|0;i=e+18492|0;if((h|0)>=(c[i>>2]|0)){return}j=e+18496|0;k=c[j>>2]|0;l=k+h|0;h=c[e+8>>2]|0;m=d[e+2080+(g<<2)+3|0]<<2;g=c[e+18464>>2]|0;n=g+(m|3)|0;if((a[n]|0)<0){a[h+l|0]=a[g+(m|2)|0]|0;a[h+(l+1)|0]=a[g+(m|1)|0]|0;a[h+(l+2)|0]=a[g+m|0]|0;a[h+(l+3)|0]=a[n]|0;o=c[j>>2]|0}else{o=k}k=o+4|0;c[j>>2]=k;if((k|0)<(c[e+18488>>2]|0)){return}c[j>>2]=c[e+18480>>2];j=e+18472|0;k=(c[f>>2]|0)+(c[j>>2]|0)|0;c[f>>2]=k;o=e+18468|0;n=c[i>>2]|0;if((k|0)<(n|0)){return}k=e+18504|0;i=e+18484|0;e=c[o>>2]|0;while(1){if((e|0)<=0){p=1148;break}l=c[k>>2]<<e;c[j>>2]=l;h=(l>>1)+(c[i>>2]|0)|0;c[f>>2]=h;l=e-1|0;c[o>>2]=l;if((h|0)<(n|0)){p=1149;break}else{e=l}}if((p|0)==1148){return}else if((p|0)==1149){return}}
function e1(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0,aW=0,aX=0,aY=0,aZ=0,a_=0,a$=0,a0=0,a1=0,a2=0,a3=0,a4=0,a5=0,a6=0,a7=0,a8=0,a9=0,ba=0,bb=0,bc=0,bd=0,be=0,bf=0,bg=0,bh=0,bi=0,bj=0,bk=0,bl=0,bm=0,bn=0,bo=0,bp=0,bq=0,br=0,bs=0,bt=0,bu=0,bv=0,bw=0,bx=0,by=0,bz=0,bA=0,bB=0,bC=0,bD=0,bE=0,bF=0,bG=0,bH=0,bI=0,bJ=0,bK=0,bL=0,bM=0,bN=0,bO=0,bP=0,bQ=0,bR=0,bS=0,bU=0,bV=0,bW=0,bX=0,bY=0,bZ=0,b_=0,b$=0,b0=0,b1=0,b2=0,b3=0,b4=0,b5=0,b6=0,b7=0,b8=0,b9=0,ca=0,cb=0,cc=0,cd=0,ce=0,cf=0,cg=0,ch=0,ci=0,ck=0,cm=0,cn=0,co=0,cp=0,cq=0,cr=0,cs=0,ct=0,cu=0,cv=0,cw=0,cx=0,cy=0,cz=0,cA=0,cB=0,cC=0,cD=0,cE=0,cF=0,cG=0,cH=0,cI=0,cJ=0,cK=0,cL=0,cM=0,cN=0,cO=0,cP=0,cQ=0,cR=0,cS=0,cT=0,cU=0,cV=0,cW=0,cX=0,cY=0,cZ=0,c_=0,c$=0,c0=0,c1=0,c2=0,c3=0,c4=0,c5=0,c6=0,c7=0,c8=0,c9=0,da=0,db=0,dc=0,dd=0,de=0,df=0,dg=0,dh=0,di=0,dj=0,dk=0,dl=0,dm=0,dn=0,dp=0,dq=0,dr=0,ds=0,dt=0,du=0,dv=0,dw=0,dx=0,dy=0,dz=0,dA=0,dB=0,dC=0,dD=0,dE=0,dF=0,dG=0,dH=0,dI=0,dJ=0,dK=0,dL=0,dM=0,dN=0,dO=0,dP=0,dQ=0,dR=0,dS=0,dT=0,dU=0,dV=0,dW=0,dX=0,dY=0,dZ=0,d_=0,d$=0,d0=0,d1=0,d2=0,d3=0,d4=0,d5=0,d6=0,d7=0,d8=0,d9=0,ea=0,eb=0,ec=0,ed=0,ee=0,ef=0,eg=0,eh=0,ei=0,ej=0,ek=0,el=0,em=0,en=0,eo=0,ep=0,eq=0,er=0,es=0,et=0,eu=0,ev=0,ew=0,ex=0,ey=0,ez=0,eA=0,eB=0,eC=0,eD=0,eE=0,eF=0,eG=0,eH=0,eI=0,eJ=0,eK=0,eL=0,eM=0,eN=0,eO=0,eP=0,eQ=0,eR=0,eS=0,eT=0,eU=0,eV=0,eW=0,eX=0,eY=0,eZ=0,e$=0,e0=0,e1=0,e2=0,e3=0,e4=0,e5=0,e6=0,e7=0,e8=0,e9=0,fa=0,fb=0,fc=0,fd=0,fe=0,ff=0,fg=0,fh=0,fi=0,fj=0,fk=0,fl=0,fm=0,fn=0,fo=0,fp=0,fq=0,fr=0,fu=0,fv=0,fw=0,fx=0,fy=0,fz=0,fA=0,fB=0,fC=0,fD=0,fE=0,fF=0,fG=0,fH=0,fI=0,fJ=0,fK=0,fL=0,fM=0,fN=0,fO=0,fP=0,fQ=0,fR=0,fS=0,fT=0,fU=0,fV=0,fW=0,fX=0,fY=0,fZ=0,f_=0,f$=0,f0=0,f1=0,f2=0,f3=0,f4=0,f5=0,f6=0,f7=0,f8=0,f9=0,ga=0,gb=0,gc=0,gd=0,ge=0,gf=0,gg=0,gh=0,gi=0,gj=0,gk=0,gl=0,gm=0,gn=0,go=0,gp=0,gq=0,gr=0,gs=0,gt=0,gu=0,gv=0,gw=0,gx=0,gy=0,gz=0,gA=0,gB=0,gC=0,gD=0,gE=0,gF=0,gG=0,gH=0,gI=0,gJ=0,gK=0,gL=0,gM=0,gN=0,gO=0,gP=0,gQ=0,gR=0,gS=0,gT=0,gU=0,gV=0,gW=0,gX=0,gY=0,gZ=0,g_=0,g$=0,g0=0,g1=0,g2=0,g3=0,g4=0,g5=0,g6=0,g7=0,g8=0,g9=0,ha=0,hb=0,hc=0,hd=0,he=0,hf=0,hg=0,hh=0,hi=0,hj=0,hk=0,hl=0,hm=0,hn=0,ho=0,hp=0,hq=0,hr=0,hs=0,ht=0,hu=0,hv=0,hw=0,hx=0,hy=0,hz=0,hA=0,hB=0,hC=0,hD=0,hE=0,hF=0,hG=0,hH=0,hI=0,hJ=0,hK=0,hL=0,hM=0,hN=0,hO=0,hP=0,hQ=0,hR=0,hS=0,hT=0,hU=0,hV=0,hW=0,hX=0,hY=0,hZ=0,h_=0,h$=0,h0=0,h1=0,h2=0,h3=0,h4=0,h5=0,h6=0,h7=0,h8=0,h9=0,ia=0,ib=0,ic=0,id=0,ie=0,ig=0,ih=0,ii=0,ij=0,ik=0,il=0,im=0,io=0,ip=0,iq=0,ir=0,is=0,it=0,iu=0,iv=0,iw=0,ix=0,iy=0,iz=0,iA=0,iB=0,iC=0,iD=0,iE=0,iF=0,iG=0,iH=0,iI=0,iJ=0,iK=0,iL=0,iM=0,iN=0,iO=0,iP=0,iQ=0,iR=0,iS=0,iT=0,iU=0,iV=0,iW=0,iX=0,iY=0,iZ=0,i_=0,i$=0,i0=0,i1=0,i2=0,i3=0,i4=0,i5=0,i6=0,i7=0,i8=0,i9=0,ja=0,jb=0,jc=0,jd=0,je=0,jf=0,jg=0,jh=0,ji=0,jj=0,jk=0,jl=0,jm=0,jn=0,jo=0,jp=0,jq=0,jr=0,js=0,jt=0,ju=0,jv=0,jw=0,jx=0,jy=0,jz=0,jA=0,jB=0,jC=0,jD=0,jE=0,jF=0,jG=0,jH=0,jI=0,jJ=0,jK=0,jL=0;j=i;i=i+1024|0;k=j|0;l=b+168|0;m=c[l>>2]|0;n=b+172|0;do{if(m>>>0<(c[n>>2]|0)>>>0){o=m;p=1158}else{q=b+32|0;if((c[q>>2]|0)==0){break}r=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,r,c[b+36>>2]|0)|0;if((s|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;o=c[l>>2]|0;p=1158;break}else{c[l>>2]=r;c[n>>2]=b+40+s;o=r;p=1158;break}}}while(0);L1555:do{if((p|0)==1158){m=o+1|0;c[l>>2]=m;if((a[o]|0)!=66){break}do{if(m>>>0<(c[n>>2]|0)>>>0){t=m}else{r=b+32|0;if((c[r>>2]|0)==0){break L1555}s=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((q|0)==0){c[r>>2]=0;r=(c[n>>2]|0)-1|0;c[l>>2]=r;a[r]=0;t=c[l>>2]|0;break}else{c[l>>2]=s;c[n>>2]=b+40+q;t=s;break}}}while(0);m=t+1|0;c[l>>2]=m;if((a[t]|0)!=77){break}s=c[n>>2]|0;do{if(m>>>0<s>>>0){q=t+2|0;c[l>>2]=q;u=q;v=s}else{q=b+32|0;if((c[q>>2]|0)==0){u=m;v=s;break}r=b+40|0;w=cl[c[b+16>>2]&3](c[b+28>>2]|0,r,c[b+36>>2]|0)|0;if((w|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;x=c[l>>2]|0;y=c[n>>2]|0}else{c[l>>2]=r;q=b+40+w|0;c[n>>2]=q;x=r;y=q}q=x+1|0;c[l>>2]=q;u=q;v=y}}while(0);do{if(u>>>0<v>>>0){s=u+1|0;c[l>>2]=s;z=s;A=v}else{s=b+32|0;if((c[s>>2]|0)==0){z=u;A=v;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;B=c[l>>2]|0;C=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;B=m;C=s}s=B+1|0;c[l>>2]=s;z=s;A=C}}while(0);do{if(z>>>0<A>>>0){s=z+1|0;c[l>>2]=s;D=s;E=A}else{s=b+32|0;if((c[s>>2]|0)==0){D=z;E=A;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;F=c[l>>2]|0;G=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;F=m;G=s}s=F+1|0;c[l>>2]=s;D=s;E=G}}while(0);do{if(D>>>0<E>>>0){s=D+1|0;c[l>>2]=s;H=s;I=E}else{s=b+32|0;if((c[s>>2]|0)==0){H=D;I=E;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;J=c[l>>2]|0;K=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;J=m;K=s}s=J+1|0;c[l>>2]=s;H=s;I=K}}while(0);do{if(H>>>0<I>>>0){s=H+1|0;c[l>>2]=s;L=s;M=I}else{s=b+32|0;if((c[s>>2]|0)==0){L=H;M=I;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;N=c[l>>2]|0;O=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;N=m;O=s}s=N+1|0;c[l>>2]=s;L=s;M=O}}while(0);do{if(L>>>0<M>>>0){s=L+1|0;c[l>>2]=s;P=s;Q=M}else{s=b+32|0;if((c[s>>2]|0)==0){P=L;Q=M;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;R=c[l>>2]|0;S=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;R=m;S=s}s=R+1|0;c[l>>2]=s;P=s;Q=S}}while(0);do{if(P>>>0<Q>>>0){s=P+1|0;c[l>>2]=s;T=s;U=Q}else{s=b+32|0;if((c[s>>2]|0)==0){T=P;U=Q;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;V=c[l>>2]|0;W=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;V=m;W=s}s=V+1|0;c[l>>2]=s;T=s;U=W}}while(0);do{if(T>>>0<U>>>0){s=T+1|0;c[l>>2]=s;X=s;Y=U}else{s=b+32|0;if((c[s>>2]|0)==0){X=T;Y=U;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;Z=c[l>>2]|0;_=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;Z=m;_=s}s=Z+1|0;c[l>>2]=s;X=s;Y=_}}while(0);do{if(X>>>0<Y>>>0){s=X+1|0;c[l>>2]=s;aa=d[X]|0;ab=s;ac=Y}else{s=b+32|0;if((c[s>>2]|0)==0){aa=0;ab=X;ac=Y;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;ad=c[l>>2]|0;ae=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;ad=m;ae=s}s=ad+1|0;c[l>>2]=s;aa=d[ad]|0;ab=s;ac=ae}}while(0);do{if(ab>>>0<ac>>>0){s=ab+1|0;c[l>>2]=s;af=d[ab]|0;ag=s;ah=ac}else{s=b+32|0;if((c[s>>2]|0)==0){af=0;ag=ab;ah=ac;break}m=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,m,c[b+36>>2]|0)|0;if((q|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;ai=c[l>>2]|0;aj=c[n>>2]|0}else{c[l>>2]=m;s=b+40+q|0;c[n>>2]=s;ai=m;aj=s}s=ai+1|0;c[l>>2]=s;af=d[ai]|0;ag=s;ah=aj}}while(0);s=af<<8|aa;do{if(ag>>>0<ah>>>0){m=ag+1|0;c[l>>2]=m;ak=d[ag]|0;al=m;am=ah}else{m=b+32|0;if((c[m>>2]|0)==0){ak=0;al=ag;am=ah;break}q=b+40|0;r=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((r|0)==0){c[m>>2]=0;m=(c[n>>2]|0)-1|0;c[l>>2]=m;a[m]=0;an=c[l>>2]|0;ao=c[n>>2]|0}else{c[l>>2]=q;m=b+40+r|0;c[n>>2]=m;an=q;ao=m}m=an+1|0;c[l>>2]=m;ak=d[an]|0;al=m;am=ao}}while(0);do{if(al>>>0<am>>>0){m=al+1|0;c[l>>2]=m;ap=d[al]|0;aq=m;ar=am}else{m=b+32|0;if((c[m>>2]|0)==0){ap=0;aq=al;ar=am;break}q=b+40|0;r=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((r|0)==0){c[m>>2]=0;m=(c[n>>2]|0)-1|0;c[l>>2]=m;a[m]=0;as=c[l>>2]|0;at=c[n>>2]|0}else{c[l>>2]=q;m=b+40+r|0;c[n>>2]=m;as=q;at=m}m=as+1|0;c[l>>2]=m;ap=d[as]|0;aq=m;ar=at}}while(0);m=s|(ap<<8|ak)<<16;do{if(aq>>>0<ar>>>0){q=aq+1|0;c[l>>2]=q;au=d[aq]|0;av=q;aw=ar}else{q=b+32|0;if((c[q>>2]|0)==0){au=0;av=aq;aw=ar;break}r=b+40|0;w=cl[c[b+16>>2]&3](c[b+28>>2]|0,r,c[b+36>>2]|0)|0;if((w|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;ax=c[l>>2]|0;ay=c[n>>2]|0}else{c[l>>2]=r;q=b+40+w|0;c[n>>2]=q;ax=r;ay=q}q=ax+1|0;c[l>>2]=q;au=d[ax]|0;av=q;aw=ay}}while(0);do{if(av>>>0<aw>>>0){s=av+1|0;c[l>>2]=s;az=d[av]|0;aA=s;aB=aw}else{s=b+32|0;if((c[s>>2]|0)==0){az=0;aA=av;aB=aw;break}q=b+40|0;r=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((r|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;aC=c[l>>2]|0;aD=c[n>>2]|0}else{c[l>>2]=q;s=b+40+r|0;c[n>>2]=s;aC=q;aD=s}s=aC+1|0;c[l>>2]=s;az=d[aC]|0;aA=s;aB=aD}}while(0);s=az<<8|au;do{if(aA>>>0<aB>>>0){q=aA+1|0;c[l>>2]=q;aE=d[aA]|0;aF=q;aG=aB}else{q=b+32|0;if((c[q>>2]|0)==0){aE=0;aF=aA;aG=aB;break}r=b+40|0;w=cl[c[b+16>>2]&3](c[b+28>>2]|0,r,c[b+36>>2]|0)|0;if((w|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;aH=c[l>>2]|0;aI=c[n>>2]|0}else{c[l>>2]=r;q=b+40+w|0;c[n>>2]=q;aH=r;aI=q}q=aH+1|0;c[l>>2]=q;aE=d[aH]|0;aF=q;aG=aI}}while(0);do{if(aF>>>0<aG>>>0){q=aF+1|0;c[l>>2]=q;aJ=d[aF]|0;aK=q}else{q=b+32|0;if((c[q>>2]|0)==0){aJ=0;aK=aF;break}r=b+40|0;w=cl[c[b+16>>2]&3](c[b+28>>2]|0,r,c[b+36>>2]|0)|0;if((w|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;aL=c[l>>2]|0}else{c[l>>2]=r;c[n>>2]=b+40+w;aL=r}r=aL+1|0;c[l>>2]=r;aJ=d[aL]|0;aK=r}}while(0);r=s|(aJ<<8|aE)<<16;w=(r|0)==12;if(!((r|0)==108|(r|0)==56|(r|0)==40|(r|0)==12)){c[2832]=3056;aM=0;i=j;return aM|0}q=c[n>>2]|0;aN=aK>>>0<q>>>0;if(w){do{if(aN){aO=aK+1|0;c[l>>2]=aO;aP=d[aK]|0;aQ=aO;aR=q}else{aO=b+32|0;if((c[aO>>2]|0)==0){aP=0;aQ=aK;aR=q;break}aS=b+40|0;aT=cl[c[b+16>>2]&3](c[b+28>>2]|0,aS,c[b+36>>2]|0)|0;if((aT|0)==0){c[aO>>2]=0;aO=(c[n>>2]|0)-1|0;c[l>>2]=aO;a[aO]=0;aU=c[l>>2]|0;aV=c[n>>2]|0}else{c[l>>2]=aS;aO=b+40+aT|0;c[n>>2]=aO;aU=aS;aV=aO}aO=aU+1|0;c[l>>2]=aO;aP=d[aU]|0;aQ=aO;aR=aV}}while(0);do{if(aQ>>>0<aR>>>0){s=aQ+1|0;c[l>>2]=s;aW=d[aQ]|0;aX=s;aY=aR}else{s=b+32|0;if((c[s>>2]|0)==0){aW=0;aX=aQ;aY=aR;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;aZ=c[l>>2]|0;a_=c[n>>2]|0}else{c[l>>2]=aO;s=b+40+aS|0;c[n>>2]=s;aZ=aO;a_=s}s=aZ+1|0;c[l>>2]=s;aW=d[aZ]|0;aX=s;aY=a_}}while(0);c[b>>2]=aW<<8|aP;do{if(aX>>>0<aY>>>0){s=aX+1|0;c[l>>2]=s;a$=d[aX]|0;a0=s;a1=aY}else{s=b+32|0;if((c[s>>2]|0)==0){a$=0;a0=aX;a1=aY;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;a2=c[l>>2]|0;a3=c[n>>2]|0}else{c[l>>2]=aO;s=b+40+aS|0;c[n>>2]=s;a2=aO;a3=s}s=a2+1|0;c[l>>2]=s;a$=d[a2]|0;a0=s;a1=a3}}while(0);do{if(a0>>>0<a1>>>0){s=a0+1|0;c[l>>2]=s;a4=d[a0]|0;a5=s}else{s=b+32|0;if((c[s>>2]|0)==0){a4=0;a5=a0;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;a6=c[l>>2]|0}else{c[l>>2]=aO;c[n>>2]=b+40+aS;a6=aO}aO=a6+1|0;c[l>>2]=aO;a4=d[a6]|0;a5=aO}}while(0);c[b+4>>2]=a4<<8|a$;a7=a5}else{do{if(aN){aO=aK+1|0;c[l>>2]=aO;a8=d[aK]|0;a9=aO;ba=q}else{aO=b+32|0;if((c[aO>>2]|0)==0){a8=0;a9=aK;ba=q;break}aS=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,aS,c[b+36>>2]|0)|0;if((s|0)==0){c[aO>>2]=0;aO=(c[n>>2]|0)-1|0;c[l>>2]=aO;a[aO]=0;bb=c[l>>2]|0;bc=c[n>>2]|0}else{c[l>>2]=aS;aO=b+40+s|0;c[n>>2]=aO;bb=aS;bc=aO}aO=bb+1|0;c[l>>2]=aO;a8=d[bb]|0;a9=aO;ba=bc}}while(0);do{if(a9>>>0<ba>>>0){q=a9+1|0;c[l>>2]=q;bd=d[a9]|0;be=q;bf=ba}else{q=b+32|0;if((c[q>>2]|0)==0){bd=0;be=a9;bf=ba;break}aN=b+40|0;aO=cl[c[b+16>>2]&3](c[b+28>>2]|0,aN,c[b+36>>2]|0)|0;if((aO|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;bg=c[l>>2]|0;bh=c[n>>2]|0}else{c[l>>2]=aN;q=b+40+aO|0;c[n>>2]=q;bg=aN;bh=q}q=bg+1|0;c[l>>2]=q;bd=d[bg]|0;be=q;bf=bh}}while(0);q=bd<<8|a8;do{if(be>>>0<bf>>>0){aN=be+1|0;c[l>>2]=aN;bi=d[be]|0;bj=aN;bk=bf}else{aN=b+32|0;if((c[aN>>2]|0)==0){bi=0;bj=be;bk=bf;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[aN>>2]=0;aN=(c[n>>2]|0)-1|0;c[l>>2]=aN;a[aN]=0;bl=c[l>>2]|0;bm=c[n>>2]|0}else{c[l>>2]=aO;aN=b+40+aS|0;c[n>>2]=aN;bl=aO;bm=aN}aN=bl+1|0;c[l>>2]=aN;bi=d[bl]|0;bj=aN;bk=bm}}while(0);do{if(bj>>>0<bk>>>0){aN=bj+1|0;c[l>>2]=aN;bn=d[bj]|0;bo=aN;bp=bk}else{aN=b+32|0;if((c[aN>>2]|0)==0){bn=0;bo=bj;bp=bk;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[aN>>2]=0;aN=(c[n>>2]|0)-1|0;c[l>>2]=aN;a[aN]=0;bq=c[l>>2]|0;br=c[n>>2]|0}else{c[l>>2]=aO;aN=b+40+aS|0;c[n>>2]=aN;bq=aO;br=aN}aN=bq+1|0;c[l>>2]=aN;bn=d[bq]|0;bo=aN;bp=br}}while(0);c[b>>2]=q|(bn<<8|bi)<<16;do{if(bo>>>0<bp>>>0){aN=bo+1|0;c[l>>2]=aN;bs=d[bo]|0;bt=aN;bu=bp}else{aN=b+32|0;if((c[aN>>2]|0)==0){bs=0;bt=bo;bu=bp;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[aN>>2]=0;aN=(c[n>>2]|0)-1|0;c[l>>2]=aN;a[aN]=0;bv=c[l>>2]|0;bw=c[n>>2]|0}else{c[l>>2]=aO;aN=b+40+aS|0;c[n>>2]=aN;bv=aO;bw=aN}aN=bv+1|0;c[l>>2]=aN;bs=d[bv]|0;bt=aN;bu=bw}}while(0);do{if(bt>>>0<bu>>>0){q=bt+1|0;c[l>>2]=q;bx=d[bt]|0;by=q;bz=bu}else{q=b+32|0;if((c[q>>2]|0)==0){bx=0;by=bt;bz=bu;break}aN=b+40|0;aO=cl[c[b+16>>2]&3](c[b+28>>2]|0,aN,c[b+36>>2]|0)|0;if((aO|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;bA=c[l>>2]|0;bB=c[n>>2]|0}else{c[l>>2]=aN;q=b+40+aO|0;c[n>>2]=q;bA=aN;bB=q}q=bA+1|0;c[l>>2]=q;bx=d[bA]|0;by=q;bz=bB}}while(0);q=bx<<8|bs;do{if(by>>>0<bz>>>0){aN=by+1|0;c[l>>2]=aN;bC=d[by]|0;bD=aN;bE=bz}else{aN=b+32|0;if((c[aN>>2]|0)==0){bC=0;bD=by;bE=bz;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[aN>>2]=0;aN=(c[n>>2]|0)-1|0;c[l>>2]=aN;a[aN]=0;bF=c[l>>2]|0;bG=c[n>>2]|0}else{c[l>>2]=aO;aN=b+40+aS|0;c[n>>2]=aN;bF=aO;bG=aN}aN=bF+1|0;c[l>>2]=aN;bC=d[bF]|0;bD=aN;bE=bG}}while(0);do{if(bD>>>0<bE>>>0){aN=bD+1|0;c[l>>2]=aN;bH=d[bD]|0;bI=aN}else{aN=b+32|0;if((c[aN>>2]|0)==0){bH=0;bI=bD;break}aO=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aS|0)==0){c[aN>>2]=0;aN=(c[n>>2]|0)-1|0;c[l>>2]=aN;a[aN]=0;bJ=c[l>>2]|0}else{c[l>>2]=aO;c[n>>2]=b+40+aS;bJ=aO}aO=bJ+1|0;c[l>>2]=aO;bH=d[bJ]|0;bI=aO}}while(0);c[b+4>>2]=q|(bH<<8|bC)<<16;a7=bI}aO=c[n>>2]|0;do{if(a7>>>0<aO>>>0){aS=a7+1|0;c[l>>2]=aS;bK=d[a7]|0;bL=aS;bM=aO}else{aS=b+32|0;if((c[aS>>2]|0)==0){bK=0;bL=a7;bM=aO;break}aN=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,aN,c[b+36>>2]|0)|0;if((s|0)==0){c[aS>>2]=0;aS=(c[n>>2]|0)-1|0;c[l>>2]=aS;a[aS]=0;bN=c[l>>2]|0;bO=c[n>>2]|0}else{c[l>>2]=aN;aS=b+40+s|0;c[n>>2]=aS;bN=aN;bO=aS}aS=bN+1|0;c[l>>2]=aS;bK=d[bN]|0;bL=aS;bM=bO}}while(0);do{if(bL>>>0<bM>>>0){aO=bL+1|0;c[l>>2]=aO;bP=d[bL]|0;bQ=aO}else{aO=b+32|0;if((c[aO>>2]|0)==0){bP=0;bQ=bL;break}q=b+40|0;aS=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((aS|0)==0){c[aO>>2]=0;aO=(c[n>>2]|0)-1|0;c[l>>2]=aO;a[aO]=0;bR=c[l>>2]|0}else{c[l>>2]=q;c[n>>2]=b+40+aS;bR=q}q=bR+1|0;c[l>>2]=q;bP=d[bR]|0;bQ=q}}while(0);if((bP<<8|bK|0)!=1){c[2832]=3048;aM=0;i=j;return aM|0}q=c[n>>2]|0;do{if(bQ>>>0<q>>>0){aS=bQ+1|0;c[l>>2]=aS;bS=d[bQ]|0;bU=aS;bV=q}else{aS=b+32|0;if((c[aS>>2]|0)==0){bS=0;bU=bQ;bV=q;break}aO=b+40|0;aN=cl[c[b+16>>2]&3](c[b+28>>2]|0,aO,c[b+36>>2]|0)|0;if((aN|0)==0){c[aS>>2]=0;aS=(c[n>>2]|0)-1|0;c[l>>2]=aS;a[aS]=0;bW=c[l>>2]|0;bX=c[n>>2]|0}else{c[l>>2]=aO;aS=b+40+aN|0;c[n>>2]=aS;bW=aO;bX=aS}aS=bW+1|0;c[l>>2]=aS;bS=d[bW]|0;bU=aS;bV=bX}}while(0);do{if(bU>>>0<bV>>>0){q=bU+1|0;c[l>>2]=q;bY=d[bU]|0;bZ=q}else{q=b+32|0;if((c[q>>2]|0)==0){bY=0;bZ=bU;break}aS=b+40|0;aO=cl[c[b+16>>2]&3](c[b+28>>2]|0,aS,c[b+36>>2]|0)|0;if((aO|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;b_=c[l>>2]|0}else{c[l>>2]=aS;c[n>>2]=b+40+aO;b_=aS}aS=b_+1|0;c[l>>2]=aS;bY=d[b_]|0;bZ=aS}}while(0);aS=bY<<8|bS;if((aS|0)==1){c[2832]=3032;aM=0;i=j;return aM|0}aO=b+4|0;q=c[aO>>2]|0;aN=(q|0)>0;c[aO>>2]=(q|0)>-1?q:-q|0;do{if(w){if(aS>>>0>=24>>>0){b$=0;b0=0;b1=0;b2=0;b3=0;b4=bZ;break}b$=0;b0=0;b1=0;b2=0;b3=(m-38|0)/3|0;b4=bZ}else{q=c[n>>2]|0;do{if(bZ>>>0<q>>>0){s=bZ+1|0;c[l>>2]=s;b5=d[bZ]|0;b6=s;b7=q}else{s=b+32|0;if((c[s>>2]|0)==0){b5=0;b6=bZ;b7=q;break}aT=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,aT,c[b+36>>2]|0)|0;if((b8|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;b9=c[l>>2]|0;ca=c[n>>2]|0}else{c[l>>2]=aT;s=b+40+b8|0;c[n>>2]=s;b9=aT;ca=s}s=b9+1|0;c[l>>2]=s;b5=d[b9]|0;b6=s;b7=ca}}while(0);do{if(b6>>>0<b7>>>0){q=b6+1|0;c[l>>2]=q;cb=d[b6]|0;cc=q;cd=b7}else{q=b+32|0;if((c[q>>2]|0)==0){cb=0;cc=b6;cd=b7;break}s=b+40|0;aT=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((aT|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;ce=c[l>>2]|0;cf=c[n>>2]|0}else{c[l>>2]=s;q=b+40+aT|0;c[n>>2]=q;ce=s;cf=q}q=ce+1|0;c[l>>2]=q;cb=d[ce]|0;cc=q;cd=cf}}while(0);q=cb<<8|b5;do{if(cc>>>0<cd>>>0){s=cc+1|0;c[l>>2]=s;cg=d[cc]|0;ch=s;ci=cd}else{s=b+32|0;if((c[s>>2]|0)==0){cg=0;ch=cc;ci=cd;break}aT=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,aT,c[b+36>>2]|0)|0;if((b8|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;ck=c[l>>2]|0;cm=c[n>>2]|0}else{c[l>>2]=aT;s=b+40+b8|0;c[n>>2]=s;ck=aT;cm=s}s=ck+1|0;c[l>>2]=s;cg=d[ck]|0;ch=s;ci=cm}}while(0);do{if(ch>>>0<ci>>>0){s=ch+1|0;c[l>>2]=s;cn=d[ch]|0;co=s}else{s=b+32|0;if((c[s>>2]|0)==0){cn=0;co=ch;break}aT=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,aT,c[b+36>>2]|0)|0;if((b8|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;cp=c[l>>2]|0}else{c[l>>2]=aT;c[n>>2]=b+40+b8;cp=aT}aT=cp+1|0;c[l>>2]=aT;cn=d[cp]|0;co=aT}}while(0);aT=q|(cn<<8|cg)<<16;if((aT-1|0)>>>0<2>>>0){c[2832]=3024;aM=0;i=j;return aM|0}b8=c[n>>2]|0;do{if(co>>>0<b8>>>0){s=co+1|0;c[l>>2]=s;cq=s;cr=b8}else{s=b+32|0;if((c[s>>2]|0)==0){cq=co;cr=b8;break}cs=b+40|0;ct=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((ct|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;cu=c[l>>2]|0;cv=c[n>>2]|0}else{c[l>>2]=cs;s=b+40+ct|0;c[n>>2]=s;cu=cs;cv=s}s=cu+1|0;c[l>>2]=s;cq=s;cr=cv}}while(0);do{if(cq>>>0<cr>>>0){b8=cq+1|0;c[l>>2]=b8;cw=b8;cx=cr}else{b8=b+32|0;if((c[b8>>2]|0)==0){cw=cq;cx=cr;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cy=c[l>>2]|0;cz=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cy=q;cz=b8}b8=cy+1|0;c[l>>2]=b8;cw=b8;cx=cz}}while(0);do{if(cw>>>0<cx>>>0){b8=cw+1|0;c[l>>2]=b8;cA=b8;cB=cx}else{b8=b+32|0;if((c[b8>>2]|0)==0){cA=cw;cB=cx;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cC=c[l>>2]|0;cD=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cC=q;cD=b8}b8=cC+1|0;c[l>>2]=b8;cA=b8;cB=cD}}while(0);do{if(cA>>>0<cB>>>0){b8=cA+1|0;c[l>>2]=b8;cE=b8;cF=cB}else{b8=b+32|0;if((c[b8>>2]|0)==0){cE=cA;cF=cB;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cG=c[l>>2]|0;cH=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cG=q;cH=b8}b8=cG+1|0;c[l>>2]=b8;cE=b8;cF=cH}}while(0);do{if(cE>>>0<cF>>>0){b8=cE+1|0;c[l>>2]=b8;cI=b8;cJ=cF}else{b8=b+32|0;if((c[b8>>2]|0)==0){cI=cE;cJ=cF;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cK=c[l>>2]|0;cL=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cK=q;cL=b8}b8=cK+1|0;c[l>>2]=b8;cI=b8;cJ=cL}}while(0);do{if(cI>>>0<cJ>>>0){b8=cI+1|0;c[l>>2]=b8;cM=b8;cN=cJ}else{b8=b+32|0;if((c[b8>>2]|0)==0){cM=cI;cN=cJ;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cO=c[l>>2]|0;cP=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cO=q;cP=b8}b8=cO+1|0;c[l>>2]=b8;cM=b8;cN=cP}}while(0);do{if(cM>>>0<cN>>>0){b8=cM+1|0;c[l>>2]=b8;cQ=b8;cR=cN}else{b8=b+32|0;if((c[b8>>2]|0)==0){cQ=cM;cR=cN;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cS=c[l>>2]|0;cT=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cS=q;cT=b8}b8=cS+1|0;c[l>>2]=b8;cQ=b8;cR=cT}}while(0);do{if(cQ>>>0<cR>>>0){b8=cQ+1|0;c[l>>2]=b8;cU=b8;cV=cR}else{b8=b+32|0;if((c[b8>>2]|0)==0){cU=cQ;cV=cR;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;cW=c[l>>2]|0;cX=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;cW=q;cX=b8}b8=cW+1|0;c[l>>2]=b8;cU=b8;cV=cX}}while(0);do{if(cU>>>0<cV>>>0){b8=cU+1|0;c[l>>2]=b8;cY=b8;cZ=cV}else{b8=b+32|0;if((c[b8>>2]|0)==0){cY=cU;cZ=cV;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;c_=c[l>>2]|0;c$=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;c_=q;c$=b8}b8=c_+1|0;c[l>>2]=b8;cY=b8;cZ=c$}}while(0);do{if(cY>>>0<cZ>>>0){b8=cY+1|0;c[l>>2]=b8;c0=b8;c1=cZ}else{b8=b+32|0;if((c[b8>>2]|0)==0){c0=cY;c1=cZ;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;c2=c[l>>2]|0;c3=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;c2=q;c3=b8}b8=c2+1|0;c[l>>2]=b8;c0=b8;c1=c3}}while(0);do{if(c0>>>0<c1>>>0){b8=c0+1|0;c[l>>2]=b8;c4=b8;c5=c1}else{b8=b+32|0;if((c[b8>>2]|0)==0){c4=c0;c5=c1;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;c6=c[l>>2]|0;c7=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;c6=q;c7=b8}b8=c6+1|0;c[l>>2]=b8;c4=b8;c5=c7}}while(0);do{if(c4>>>0<c5>>>0){b8=c4+1|0;c[l>>2]=b8;c8=b8;c9=c5}else{b8=b+32|0;if((c[b8>>2]|0)==0){c8=c4;c9=c5;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;da=c[l>>2]|0;db=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;da=q;db=b8}b8=da+1|0;c[l>>2]=b8;c8=b8;c9=db}}while(0);do{if(c8>>>0<c9>>>0){b8=c8+1|0;c[l>>2]=b8;dc=b8;dd=c9}else{b8=b+32|0;if((c[b8>>2]|0)==0){dc=c8;dd=c9;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;de=c[l>>2]|0;df=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;de=q;df=b8}b8=de+1|0;c[l>>2]=b8;dc=b8;dd=df}}while(0);do{if(dc>>>0<dd>>>0){b8=dc+1|0;c[l>>2]=b8;dg=b8;dh=dd}else{b8=b+32|0;if((c[b8>>2]|0)==0){dg=dc;dh=dd;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;di=c[l>>2]|0;dj=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;di=q;dj=b8}b8=di+1|0;c[l>>2]=b8;dg=b8;dh=dj}}while(0);do{if(dg>>>0<dh>>>0){b8=dg+1|0;c[l>>2]=b8;dk=b8;dl=dh}else{b8=b+32|0;if((c[b8>>2]|0)==0){dk=dg;dl=dh;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;dm=c[l>>2]|0;dn=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;dm=q;dn=b8}b8=dm+1|0;c[l>>2]=b8;dk=b8;dl=dn}}while(0);do{if(dk>>>0<dl>>>0){b8=dk+1|0;c[l>>2]=b8;dp=b8;dq=dl}else{b8=b+32|0;if((c[b8>>2]|0)==0){dp=dk;dq=dl;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;dr=c[l>>2]|0;ds=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;dr=q;ds=b8}b8=dr+1|0;c[l>>2]=b8;dp=b8;dq=ds}}while(0);do{if(dp>>>0<dq>>>0){b8=dp+1|0;c[l>>2]=b8;dt=b8;du=dq}else{b8=b+32|0;if((c[b8>>2]|0)==0){dt=dp;du=dq;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;dv=c[l>>2]|0;dw=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;dv=q;dw=b8}b8=dv+1|0;c[l>>2]=b8;dt=b8;du=dw}}while(0);do{if(dt>>>0<du>>>0){b8=dt+1|0;c[l>>2]=b8;dx=b8;dy=du}else{b8=b+32|0;if((c[b8>>2]|0)==0){dx=dt;dy=du;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;dz=c[l>>2]|0;dA=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;dz=q;dA=b8}b8=dz+1|0;c[l>>2]=b8;dx=b8;dy=dA}}while(0);do{if(dx>>>0<dy>>>0){b8=dx+1|0;c[l>>2]=b8;dB=b8;dC=dy}else{b8=b+32|0;if((c[b8>>2]|0)==0){dB=dx;dC=dy;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;dD=c[l>>2]|0;dE=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+s|0;c[n>>2]=b8;dD=q;dE=b8}b8=dD+1|0;c[l>>2]=b8;dB=b8;dC=dE}}while(0);do{if(dB>>>0<dC>>>0){b8=dB+1|0;c[l>>2]=b8;dF=b8}else{b8=b+32|0;if((c[b8>>2]|0)==0){dF=dB;break}q=b+40|0;s=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((s|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;dG=c[l>>2]|0}else{c[l>>2]=q;c[n>>2]=b+40+s;dG=q}q=dG+1|0;c[l>>2]=q;dF=q}}while(0);L2094:do{if((r|0)==56){q=c[n>>2]|0;do{if(dF>>>0<q>>>0){c[l>>2]=dF+1;dH=q}else{s=b+32|0;if((c[s>>2]|0)==0){dH=q;break}b8=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,b8,c[b+36>>2]|0)|0;if((cs|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;dI=c[l>>2]|0;dJ=c[n>>2]|0}else{c[l>>2]=b8;s=b+40+cs|0;c[n>>2]=s;dI=b8;dJ=s}c[l>>2]=dI+1;dH=dJ}}while(0);q=c[l>>2]|0;do{if(q>>>0<dH>>>0){s=q+1|0;c[l>>2]=s;dK=s;dL=dH}else{s=b+32|0;if((c[s>>2]|0)==0){dK=q;dL=dH;break}b8=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,b8,c[b+36>>2]|0)|0;if((cs|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;dM=c[l>>2]|0;dN=c[n>>2]|0}else{c[l>>2]=b8;s=b+40+cs|0;c[n>>2]=s;dM=b8;dN=s}s=dM+1|0;c[l>>2]=s;dK=s;dL=dN}}while(0);do{if(dK>>>0<dL>>>0){q=dK+1|0;c[l>>2]=q;dO=q;dP=dL}else{q=b+32|0;if((c[q>>2]|0)==0){dO=dK;dP=dL;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;dQ=c[l>>2]|0;dR=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;dQ=s;dR=q}q=dQ+1|0;c[l>>2]=q;dO=q;dP=dR}}while(0);do{if(dO>>>0<dP>>>0){q=dO+1|0;c[l>>2]=q;dS=q;dT=dP}else{q=b+32|0;if((c[q>>2]|0)==0){dS=dO;dT=dP;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;dU=c[l>>2]|0;dV=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;dU=s;dV=q}q=dU+1|0;c[l>>2]=q;dS=q;dT=dV}}while(0);do{if(dS>>>0<dT>>>0){q=dS+1|0;c[l>>2]=q;dW=q;dX=dT}else{q=b+32|0;if((c[q>>2]|0)==0){dW=dS;dX=dT;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;dY=c[l>>2]|0;dZ=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;dY=s;dZ=q}q=dY+1|0;c[l>>2]=q;dW=q;dX=dZ}}while(0);do{if(dW>>>0<dX>>>0){q=dW+1|0;c[l>>2]=q;d_=q;d$=dX}else{q=b+32|0;if((c[q>>2]|0)==0){d_=dW;d$=dX;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;d0=c[l>>2]|0;d1=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;d0=s;d1=q}q=d0+1|0;c[l>>2]=q;d_=q;d$=d1}}while(0);do{if(d_>>>0<d$>>>0){q=d_+1|0;c[l>>2]=q;d2=q;d3=d$}else{q=b+32|0;if((c[q>>2]|0)==0){d2=d_;d3=d$;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;d4=c[l>>2]|0;d5=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;d4=s;d5=q}q=d4+1|0;c[l>>2]=q;d2=q;d3=d5}}while(0);do{if(d2>>>0<d3>>>0){q=d2+1|0;c[l>>2]=q;d6=q;d7=d3}else{q=b+32|0;if((c[q>>2]|0)==0){d6=d2;d7=d3;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;d8=c[l>>2]|0;d9=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;d8=s;d9=q}q=d8+1|0;c[l>>2]=q;d6=q;d7=d9}}while(0);do{if(d6>>>0<d7>>>0){q=d6+1|0;c[l>>2]=q;ea=q;eb=d7}else{q=b+32|0;if((c[q>>2]|0)==0){ea=d6;eb=d7;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;ec=c[l>>2]|0;ed=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;ec=s;ed=q}q=ec+1|0;c[l>>2]=q;ea=q;eb=ed}}while(0);do{if(ea>>>0<eb>>>0){q=ea+1|0;c[l>>2]=q;ee=q;ef=eb}else{q=b+32|0;if((c[q>>2]|0)==0){ee=ea;ef=eb;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;eg=c[l>>2]|0;eh=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;eg=s;eh=q}q=eg+1|0;c[l>>2]=q;ee=q;ef=eh}}while(0);do{if(ee>>>0<ef>>>0){q=ee+1|0;c[l>>2]=q;ei=q;ej=ef}else{q=b+32|0;if((c[q>>2]|0)==0){ei=ee;ej=ef;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;ek=c[l>>2]|0;el=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;ek=s;el=q}q=ek+1|0;c[l>>2]=q;ei=q;ej=el}}while(0);do{if(ei>>>0<ej>>>0){q=ei+1|0;c[l>>2]=q;em=q;en=ej}else{q=b+32|0;if((c[q>>2]|0)==0){em=ei;en=ej;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;eo=c[l>>2]|0;ep=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;eo=s;ep=q}q=eo+1|0;c[l>>2]=q;em=q;en=ep}}while(0);do{if(em>>>0<en>>>0){q=em+1|0;c[l>>2]=q;eq=q;er=en}else{q=b+32|0;if((c[q>>2]|0)==0){eq=em;er=en;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;es=c[l>>2]|0;et=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;es=s;et=q}q=es+1|0;c[l>>2]=q;eq=q;er=et}}while(0);do{if(eq>>>0<er>>>0){q=eq+1|0;c[l>>2]=q;eu=q;ev=er}else{q=b+32|0;if((c[q>>2]|0)==0){eu=eq;ev=er;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;ew=c[l>>2]|0;ex=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;ew=s;ex=q}q=ew+1|0;c[l>>2]=q;eu=q;ev=ex}}while(0);do{if(eu>>>0<ev>>>0){q=eu+1|0;c[l>>2]=q;ey=q;ez=ev}else{q=b+32|0;if((c[q>>2]|0)==0){ey=eu;ez=ev;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;eA=c[l>>2]|0;eB=c[n>>2]|0}else{c[l>>2]=s;q=b+40+b8|0;c[n>>2]=q;eA=s;eB=q}q=eA+1|0;c[l>>2]=q;ey=q;ez=eB}}while(0);if(ey>>>0<ez>>>0){q=ey+1|0;c[l>>2]=q;eC=q;p=1685;break}q=b+32|0;if((c[q>>2]|0)==0){eC=ey;p=1685;break}s=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,s,c[b+36>>2]|0)|0;if((b8|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;eD=c[l>>2]|0}else{c[l>>2]=s;c[n>>2]=b+40+b8;eD=s}s=eD+1|0;c[l>>2]=s;eC=s;p=1685}else if((r|0)==40){eC=dF;p=1685}else if((r|0)==108){s=c[n>>2]|0;do{if(dF>>>0<s>>>0){c[l>>2]=dF+1;eE=d[dF]|0;eF=s}else{b8=b+32|0;if((c[b8>>2]|0)==0){eE=0;eF=s;break}q=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((cs|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;eG=c[l>>2]|0;eH=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+cs|0;c[n>>2]=b8;eG=q;eH=b8}c[l>>2]=eG+1;eE=d[eG]|0;eF=eH}}while(0);s=c[l>>2]|0;do{if(s>>>0<eF>>>0){b8=s+1|0;c[l>>2]=b8;eI=d[s]|0;eJ=b8;eK=eF}else{b8=b+32|0;if((c[b8>>2]|0)==0){eI=0;eJ=s;eK=eF;break}q=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((cs|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;eL=c[l>>2]|0;eM=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+cs|0;c[n>>2]=b8;eL=q;eM=b8}b8=eL+1|0;c[l>>2]=b8;eI=d[eL]|0;eJ=b8;eK=eM}}while(0);s=eI<<8|eE;do{if(eJ>>>0<eK>>>0){b8=eJ+1|0;c[l>>2]=b8;eN=d[eJ]|0;eO=b8;eP=eK}else{b8=b+32|0;if((c[b8>>2]|0)==0){eN=0;eO=eJ;eP=eK;break}q=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((cs|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;eQ=c[l>>2]|0;eR=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+cs|0;c[n>>2]=b8;eQ=q;eR=b8}b8=eQ+1|0;c[l>>2]=b8;eN=d[eQ]|0;eO=b8;eP=eR}}while(0);do{if(eO>>>0<eP>>>0){b8=eO+1|0;c[l>>2]=b8;eS=d[eO]|0;eT=b8;eU=eP}else{b8=b+32|0;if((c[b8>>2]|0)==0){eS=0;eT=eO;eU=eP;break}q=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((cs|0)==0){c[b8>>2]=0;b8=(c[n>>2]|0)-1|0;c[l>>2]=b8;a[b8]=0;eV=c[l>>2]|0;eW=c[n>>2]|0}else{c[l>>2]=q;b8=b+40+cs|0;c[n>>2]=b8;eV=q;eW=b8}b8=eV+1|0;c[l>>2]=b8;eS=d[eV]|0;eT=b8;eU=eW}}while(0);b8=s|(eS<<8|eN)<<16;do{if(eT>>>0<eU>>>0){q=eT+1|0;c[l>>2]=q;eX=d[eT]|0;eY=q;eZ=eU}else{q=b+32|0;if((c[q>>2]|0)==0){eX=0;eY=eT;eZ=eU;break}cs=b+40|0;ct=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((ct|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;e$=c[l>>2]|0;e0=c[n>>2]|0}else{c[l>>2]=cs;q=b+40+ct|0;c[n>>2]=q;e$=cs;e0=q}q=e$+1|0;c[l>>2]=q;eX=d[e$]|0;eY=q;eZ=e0}}while(0);do{if(eY>>>0<eZ>>>0){s=eY+1|0;c[l>>2]=s;e1=d[eY]|0;e2=s;e3=eZ}else{s=b+32|0;if((c[s>>2]|0)==0){e1=0;e2=eY;e3=eZ;break}q=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((cs|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;e4=c[l>>2]|0;e5=c[n>>2]|0}else{c[l>>2]=q;s=b+40+cs|0;c[n>>2]=s;e4=q;e5=s}s=e4+1|0;c[l>>2]=s;e1=d[e4]|0;e2=s;e3=e5}}while(0);s=e1<<8|eX;do{if(e2>>>0<e3>>>0){q=e2+1|0;c[l>>2]=q;e6=d[e2]|0;e7=q;e8=e3}else{q=b+32|0;if((c[q>>2]|0)==0){e6=0;e7=e2;e8=e3;break}cs=b+40|0;ct=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((ct|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;e9=c[l>>2]|0;fa=c[n>>2]|0}else{c[l>>2]=cs;q=b+40+ct|0;c[n>>2]=q;e9=cs;fa=q}q=e9+1|0;c[l>>2]=q;e6=d[e9]|0;e7=q;e8=fa}}while(0);do{if(e7>>>0<e8>>>0){q=e7+1|0;c[l>>2]=q;fb=d[e7]|0;fc=q;fd=e8}else{q=b+32|0;if((c[q>>2]|0)==0){fb=0;fc=e7;fd=e8;break}cs=b+40|0;ct=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((ct|0)==0){c[q>>2]=0;q=(c[n>>2]|0)-1|0;c[l>>2]=q;a[q]=0;fe=c[l>>2]|0;ff=c[n>>2]|0}else{c[l>>2]=cs;q=b+40+ct|0;c[n>>2]=q;fe=cs;ff=q}q=fe+1|0;c[l>>2]=q;fb=d[fe]|0;fc=q;fd=ff}}while(0);q=s|(fb<<8|e6)<<16;do{if(fc>>>0<fd>>>0){cs=fc+1|0;c[l>>2]=cs;fg=d[fc]|0;fh=cs;fi=fd}else{cs=b+32|0;if((c[cs>>2]|0)==0){fg=0;fh=fc;fi=fd;break}ct=b+40|0;fj=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((fj|0)==0){c[cs>>2]=0;cs=(c[n>>2]|0)-1|0;c[l>>2]=cs;a[cs]=0;fk=c[l>>2]|0;fl=c[n>>2]|0}else{c[l>>2]=ct;cs=b+40+fj|0;c[n>>2]=cs;fk=ct;fl=cs}cs=fk+1|0;c[l>>2]=cs;fg=d[fk]|0;fh=cs;fi=fl}}while(0);do{if(fh>>>0<fi>>>0){s=fh+1|0;c[l>>2]=s;fm=d[fh]|0;fn=s;fo=fi}else{s=b+32|0;if((c[s>>2]|0)==0){fm=0;fn=fh;fo=fi;break}cs=b+40|0;ct=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((ct|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;fp=c[l>>2]|0;fq=c[n>>2]|0}else{c[l>>2]=cs;s=b+40+ct|0;c[n>>2]=s;fp=cs;fq=s}s=fp+1|0;c[l>>2]=s;fm=d[fp]|0;fn=s;fo=fq}}while(0);s=fm<<8|fg;do{if(fn>>>0<fo>>>0){cs=fn+1|0;c[l>>2]=cs;fr=d[fn]|0;fu=cs;fv=fo}else{cs=b+32|0;if((c[cs>>2]|0)==0){fr=0;fu=fn;fv=fo;break}ct=b+40|0;fj=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((fj|0)==0){c[cs>>2]=0;cs=(c[n>>2]|0)-1|0;c[l>>2]=cs;a[cs]=0;fw=c[l>>2]|0;fx=c[n>>2]|0}else{c[l>>2]=ct;cs=b+40+fj|0;c[n>>2]=cs;fw=ct;fx=cs}cs=fw+1|0;c[l>>2]=cs;fr=d[fw]|0;fu=cs;fv=fx}}while(0);do{if(fu>>>0<fv>>>0){cs=fu+1|0;c[l>>2]=cs;fy=d[fu]|0;fz=cs;fA=fv}else{cs=b+32|0;if((c[cs>>2]|0)==0){fy=0;fz=fu;fA=fv;break}ct=b+40|0;fj=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((fj|0)==0){c[cs>>2]=0;cs=(c[n>>2]|0)-1|0;c[l>>2]=cs;a[cs]=0;fB=c[l>>2]|0;fC=c[n>>2]|0}else{c[l>>2]=ct;cs=b+40+fj|0;c[n>>2]=cs;fB=ct;fC=cs}cs=fB+1|0;c[l>>2]=cs;fy=d[fB]|0;fz=cs;fA=fC}}while(0);cs=s|(fy<<8|fr)<<16;do{if(fz>>>0<fA>>>0){ct=fz+1|0;c[l>>2]=ct;fD=d[fz]|0;fE=ct;fF=fA}else{ct=b+32|0;if((c[ct>>2]|0)==0){fD=0;fE=fz;fF=fA;break}fj=b+40|0;fG=cl[c[b+16>>2]&3](c[b+28>>2]|0,fj,c[b+36>>2]|0)|0;if((fG|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;fH=c[l>>2]|0;fI=c[n>>2]|0}else{c[l>>2]=fj;ct=b+40+fG|0;c[n>>2]=ct;fH=fj;fI=ct}ct=fH+1|0;c[l>>2]=ct;fD=d[fH]|0;fE=ct;fF=fI}}while(0);do{if(fE>>>0<fF>>>0){s=fE+1|0;c[l>>2]=s;fJ=d[fE]|0;fK=s;fL=fF}else{s=b+32|0;if((c[s>>2]|0)==0){fJ=0;fK=fE;fL=fF;break}ct=b+40|0;fj=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((fj|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;fM=c[l>>2]|0;fN=c[n>>2]|0}else{c[l>>2]=ct;s=b+40+fj|0;c[n>>2]=s;fM=ct;fN=s}s=fM+1|0;c[l>>2]=s;fJ=d[fM]|0;fK=s;fL=fN}}while(0);s=fJ<<8|fD;do{if(fK>>>0<fL>>>0){ct=fK+1|0;c[l>>2]=ct;fO=d[fK]|0;fP=ct;fQ=fL}else{ct=b+32|0;if((c[ct>>2]|0)==0){fO=0;fP=fK;fQ=fL;break}fj=b+40|0;fG=cl[c[b+16>>2]&3](c[b+28>>2]|0,fj,c[b+36>>2]|0)|0;if((fG|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;fR=c[l>>2]|0;fS=c[n>>2]|0}else{c[l>>2]=fj;ct=b+40+fG|0;c[n>>2]=ct;fR=fj;fS=ct}ct=fR+1|0;c[l>>2]=ct;fO=d[fR]|0;fP=ct;fQ=fS}}while(0);do{if(fP>>>0<fQ>>>0){ct=fP+1|0;c[l>>2]=ct;fT=d[fP]|0;fU=ct;fV=fQ}else{ct=b+32|0;if((c[ct>>2]|0)==0){fT=0;fU=fP;fV=fQ;break}fj=b+40|0;fG=cl[c[b+16>>2]&3](c[b+28>>2]|0,fj,c[b+36>>2]|0)|0;if((fG|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;fW=c[l>>2]|0;fX=c[n>>2]|0}else{c[l>>2]=fj;ct=b+40+fG|0;c[n>>2]=ct;fW=fj;fX=ct}ct=fW+1|0;c[l>>2]=ct;fT=d[fW]|0;fU=ct;fV=fX}}while(0);ct=s|(fT<<8|fO)<<16;do{if(fU>>>0<fV>>>0){fj=fU+1|0;c[l>>2]=fj;fY=fj;fZ=fV}else{fj=b+32|0;if((c[fj>>2]|0)==0){fY=fU;fZ=fV;break}fG=b+40|0;f_=cl[c[b+16>>2]&3](c[b+28>>2]|0,fG,c[b+36>>2]|0)|0;if((f_|0)==0){c[fj>>2]=0;fj=(c[n>>2]|0)-1|0;c[l>>2]=fj;a[fj]=0;f$=c[l>>2]|0;f0=c[n>>2]|0}else{c[l>>2]=fG;fj=b+40+f_|0;c[n>>2]=fj;f$=fG;f0=fj}fj=f$+1|0;c[l>>2]=fj;fY=fj;fZ=f0}}while(0);do{if(fY>>>0<fZ>>>0){s=fY+1|0;c[l>>2]=s;f1=s;f2=fZ}else{s=b+32|0;if((c[s>>2]|0)==0){f1=fY;f2=fZ;break}fj=b+40|0;fG=cl[c[b+16>>2]&3](c[b+28>>2]|0,fj,c[b+36>>2]|0)|0;if((fG|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;f3=c[l>>2]|0;f4=c[n>>2]|0}else{c[l>>2]=fj;s=b+40+fG|0;c[n>>2]=s;f3=fj;f4=s}s=f3+1|0;c[l>>2]=s;f1=s;f2=f4}}while(0);do{if(f1>>>0<f2>>>0){s=f1+1|0;c[l>>2]=s;f5=s;f6=f2}else{s=b+32|0;if((c[s>>2]|0)==0){f5=f1;f6=f2;break}fj=b+40|0;fG=cl[c[b+16>>2]&3](c[b+28>>2]|0,fj,c[b+36>>2]|0)|0;if((fG|0)==0){c[s>>2]=0;s=(c[n>>2]|0)-1|0;c[l>>2]=s;a[s]=0;f7=c[l>>2]|0;f8=c[n>>2]|0}else{c[l>>2]=fj;s=b+40+fG|0;c[n>>2]=s;f7=fj;f8=s}s=f7+1|0;c[l>>2]=s;f5=s;f6=f8}}while(0);do{if(f5>>>0<f6>>>0){s=f5+1|0;c[l>>2]=s;f9=s;ga=b+32|0}else{s=b+32|0;if((c[s>>2]|0)==0){f9=f5;ga=s;break}fj=b+40|0;fG=cl[c[b+16>>2]&3](c[b+28>>2]|0,fj,c[b+36>>2]|0)|0;if((fG|0)==0){c[s>>2]=0;f_=(c[n>>2]|0)-1|0;c[l>>2]=f_;a[f_]=0;gb=c[l>>2]|0}else{c[l>>2]=fj;c[n>>2]=b+40+fG;gb=fj}fj=gb+1|0;c[l>>2]=fj;f9=fj;ga=s}}while(0);s=b+16|0;fj=b+28|0;fG=b+40|0;f_=b+36|0;gc=1;gd=f9;while(1){ge=c[n>>2]|0;do{if(gd>>>0<ge>>>0){gf=gd+1|0;c[l>>2]=gf;gg=gf;gh=ge}else{if((c[ga>>2]|0)==0){gg=gd;gh=ge;break}gf=cl[c[s>>2]&3](c[fj>>2]|0,fG,c[f_>>2]|0)|0;if((gf|0)==0){c[ga>>2]=0;gi=(c[n>>2]|0)-1|0;c[l>>2]=gi;a[gi]=0;gj=c[l>>2]|0;gk=c[n>>2]|0}else{c[l>>2]=fG;gi=b+40+gf|0;c[n>>2]=gi;gj=fG;gk=gi}gi=gj+1|0;c[l>>2]=gi;gg=gi;gh=gk}}while(0);do{if(gg>>>0<gh>>>0){ge=gg+1|0;c[l>>2]=ge;gl=ge;gm=gh}else{if((c[ga>>2]|0)==0){gl=gg;gm=gh;break}ge=cl[c[s>>2]&3](c[fj>>2]|0,fG,c[f_>>2]|0)|0;if((ge|0)==0){c[ga>>2]=0;gi=(c[n>>2]|0)-1|0;c[l>>2]=gi;a[gi]=0;gn=c[l>>2]|0;go=c[n>>2]|0}else{c[l>>2]=fG;gi=b+40+ge|0;c[n>>2]=gi;gn=fG;go=gi}gi=gn+1|0;c[l>>2]=gi;gl=gi;gm=go}}while(0);do{if(gl>>>0<gm>>>0){gi=gl+1|0;c[l>>2]=gi;gp=gi;gq=gm}else{if((c[ga>>2]|0)==0){gp=gl;gq=gm;break}gi=cl[c[s>>2]&3](c[fj>>2]|0,fG,c[f_>>2]|0)|0;if((gi|0)==0){c[ga>>2]=0;ge=(c[n>>2]|0)-1|0;c[l>>2]=ge;a[ge]=0;gr=c[l>>2]|0;gs=c[n>>2]|0}else{c[l>>2]=fG;ge=b+40+gi|0;c[n>>2]=ge;gr=fG;gs=ge}ge=gr+1|0;c[l>>2]=ge;gp=ge;gq=gs}}while(0);do{if(gp>>>0<gq>>>0){ge=gp+1|0;c[l>>2]=ge;gt=ge}else{if((c[ga>>2]|0)==0){gt=gp;break}ge=cl[c[s>>2]&3](c[fj>>2]|0,fG,c[f_>>2]|0)|0;if((ge|0)==0){c[ga>>2]=0;gi=(c[n>>2]|0)-1|0;c[l>>2]=gi;a[gi]=0;gu=c[l>>2]|0}else{c[l>>2]=fG;c[n>>2]=b+40+ge;gu=fG}ge=gu+1|0;c[l>>2]=ge;gt=ge}}while(0);if((gc|0)>=12){gv=b8;gw=q;gx=cs;gy=ct;gz=gt;break L2094}gc=gc+1|0;gd=gt}}else{bT(3008,1472,3022,3424);return 0}}while(0);do{if((p|0)==1685){gd=(aS|0)==32;if(!((aS|0)==32|(aS|0)==16)){gv=0;gw=0;gx=0;gy=0;gz=eC;break}if((aT|0)==0){gv=gd?16711680:31744;gw=gd?65280:992;gx=gd?255:31;gy=gd?-16777216:0;gz=eC;break}else if((aT|0)==3){gd=c[l>>2]|0;gc=c[n>>2]|0;do{if(gd>>>0<gc>>>0){ct=gd+1|0;c[l>>2]=ct;gA=d[gd]|0;gB=ct;gC=gc}else{ct=b+32|0;if((c[ct>>2]|0)==0){gA=0;gB=gd;gC=gc;break}cs=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((q|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;gD=c[l>>2]|0;gE=c[n>>2]|0}else{c[l>>2]=cs;ct=b+40+q|0;c[n>>2]=ct;gD=cs;gE=ct}ct=gD+1|0;c[l>>2]=ct;gA=d[gD]|0;gB=ct;gC=gE}}while(0);do{if(gB>>>0<gC>>>0){gc=gB+1|0;c[l>>2]=gc;gF=d[gB]|0;gG=gc;gH=gC}else{gc=b+32|0;if((c[gc>>2]|0)==0){gF=0;gG=gB;gH=gC;break}gd=b+40|0;ct=cl[c[b+16>>2]&3](c[b+28>>2]|0,gd,c[b+36>>2]|0)|0;if((ct|0)==0){c[gc>>2]=0;gc=(c[n>>2]|0)-1|0;c[l>>2]=gc;a[gc]=0;gI=c[l>>2]|0;gJ=c[n>>2]|0}else{c[l>>2]=gd;gc=b+40+ct|0;c[n>>2]=gc;gI=gd;gJ=gc}gc=gI+1|0;c[l>>2]=gc;gF=d[gI]|0;gG=gc;gH=gJ}}while(0);gc=gF<<8|gA;do{if(gG>>>0<gH>>>0){gd=gG+1|0;c[l>>2]=gd;gK=d[gG]|0;gL=gd;gM=gH}else{gd=b+32|0;if((c[gd>>2]|0)==0){gK=0;gL=gG;gM=gH;break}ct=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((cs|0)==0){c[gd>>2]=0;gd=(c[n>>2]|0)-1|0;c[l>>2]=gd;a[gd]=0;gN=c[l>>2]|0;gO=c[n>>2]|0}else{c[l>>2]=ct;gd=b+40+cs|0;c[n>>2]=gd;gN=ct;gO=gd}gd=gN+1|0;c[l>>2]=gd;gK=d[gN]|0;gL=gd;gM=gO}}while(0);do{if(gL>>>0<gM>>>0){gd=gL+1|0;c[l>>2]=gd;gP=d[gL]|0;gQ=gd;gR=gM}else{gd=b+32|0;if((c[gd>>2]|0)==0){gP=0;gQ=gL;gR=gM;break}ct=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((cs|0)==0){c[gd>>2]=0;gd=(c[n>>2]|0)-1|0;c[l>>2]=gd;a[gd]=0;gS=c[l>>2]|0;gT=c[n>>2]|0}else{c[l>>2]=ct;gd=b+40+cs|0;c[n>>2]=gd;gS=ct;gT=gd}gd=gS+1|0;c[l>>2]=gd;gP=d[gS]|0;gQ=gd;gR=gT}}while(0);gd=gc|(gP<<8|gK)<<16;do{if(gQ>>>0<gR>>>0){ct=gQ+1|0;c[l>>2]=ct;gU=d[gQ]|0;gV=ct;gW=gR}else{ct=b+32|0;if((c[ct>>2]|0)==0){gU=0;gV=gQ;gW=gR;break}cs=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((q|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;gX=c[l>>2]|0;gY=c[n>>2]|0}else{c[l>>2]=cs;ct=b+40+q|0;c[n>>2]=ct;gX=cs;gY=ct}ct=gX+1|0;c[l>>2]=ct;gU=d[gX]|0;gV=ct;gW=gY}}while(0);do{if(gV>>>0<gW>>>0){gc=gV+1|0;c[l>>2]=gc;gZ=d[gV]|0;g_=gc;g$=gW}else{gc=b+32|0;if((c[gc>>2]|0)==0){gZ=0;g_=gV;g$=gW;break}ct=b+40|0;cs=cl[c[b+16>>2]&3](c[b+28>>2]|0,ct,c[b+36>>2]|0)|0;if((cs|0)==0){c[gc>>2]=0;gc=(c[n>>2]|0)-1|0;c[l>>2]=gc;a[gc]=0;g0=c[l>>2]|0;g1=c[n>>2]|0}else{c[l>>2]=ct;gc=b+40+cs|0;c[n>>2]=gc;g0=ct;g1=gc}gc=g0+1|0;c[l>>2]=gc;gZ=d[g0]|0;g_=gc;g$=g1}}while(0);gc=gZ<<8|gU;do{if(g_>>>0<g$>>>0){ct=g_+1|0;c[l>>2]=ct;g2=d[g_]|0;g3=ct;g4=g$}else{ct=b+32|0;if((c[ct>>2]|0)==0){g2=0;g3=g_;g4=g$;break}cs=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((q|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;g5=c[l>>2]|0;g6=c[n>>2]|0}else{c[l>>2]=cs;ct=b+40+q|0;c[n>>2]=ct;g5=cs;g6=ct}ct=g5+1|0;c[l>>2]=ct;g2=d[g5]|0;g3=ct;g4=g6}}while(0);do{if(g3>>>0<g4>>>0){ct=g3+1|0;c[l>>2]=ct;g7=d[g3]|0;g8=ct;g9=g4}else{ct=b+32|0;if((c[ct>>2]|0)==0){g7=0;g8=g3;g9=g4;break}cs=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((q|0)==0){c[ct>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;ha=c[l>>2]|0;hb=c[n>>2]|0}else{c[l>>2]=cs;ct=b+40+q|0;c[n>>2]=ct;ha=cs;hb=ct}ct=ha+1|0;c[l>>2]=ct;g7=d[ha]|0;g8=ct;g9=hb}}while(0);ct=gc|(g7<<8|g2)<<16;do{if(g8>>>0<g9>>>0){cs=g8+1|0;c[l>>2]=cs;hc=d[g8]|0;hd=cs;he=g9}else{cs=b+32|0;if((c[cs>>2]|0)==0){hc=0;hd=g8;he=g9;break}q=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((b8|0)==0){c[cs>>2]=0;cs=(c[n>>2]|0)-1|0;c[l>>2]=cs;a[cs]=0;hf=c[l>>2]|0;hg=c[n>>2]|0}else{c[l>>2]=q;cs=b+40+b8|0;c[n>>2]=cs;hf=q;hg=cs}cs=hf+1|0;c[l>>2]=cs;hc=d[hf]|0;hd=cs;he=hg}}while(0);do{if(hd>>>0<he>>>0){gc=hd+1|0;c[l>>2]=gc;hh=d[hd]|0;hi=gc;hj=he}else{gc=b+32|0;if((c[gc>>2]|0)==0){hh=0;hi=hd;hj=he;break}cs=b+40|0;q=cl[c[b+16>>2]&3](c[b+28>>2]|0,cs,c[b+36>>2]|0)|0;if((q|0)==0){c[gc>>2]=0;gc=(c[n>>2]|0)-1|0;c[l>>2]=gc;a[gc]=0;hk=c[l>>2]|0;hl=c[n>>2]|0}else{c[l>>2]=cs;gc=b+40+q|0;c[n>>2]=gc;hk=cs;hl=gc}gc=hk+1|0;c[l>>2]=gc;hh=d[hk]|0;hi=gc;hj=hl}}while(0);gc=hh<<8|hc;do{if(hi>>>0<hj>>>0){cs=hi+1|0;c[l>>2]=cs;hm=d[hi]|0;hn=cs;ho=hj}else{cs=b+32|0;if((c[cs>>2]|0)==0){hm=0;hn=hi;ho=hj;break}q=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((b8|0)==0){c[cs>>2]=0;cs=(c[n>>2]|0)-1|0;c[l>>2]=cs;a[cs]=0;hp=c[l>>2]|0;hq=c[n>>2]|0}else{c[l>>2]=q;cs=b+40+b8|0;c[n>>2]=cs;hp=q;hq=cs}cs=hp+1|0;c[l>>2]=cs;hm=d[hp]|0;hn=cs;ho=hq}}while(0);do{if(hn>>>0<ho>>>0){cs=hn+1|0;c[l>>2]=cs;hr=d[hn]|0;hs=cs}else{cs=b+32|0;if((c[cs>>2]|0)==0){hr=0;hs=hn;break}q=b+40|0;b8=cl[c[b+16>>2]&3](c[b+28>>2]|0,q,c[b+36>>2]|0)|0;if((b8|0)==0){c[cs>>2]=0;cs=(c[n>>2]|0)-1|0;c[l>>2]=cs;a[cs]=0;ht=c[l>>2]|0}else{c[l>>2]=q;c[n>>2]=b+40+b8;ht=q}q=ht+1|0;c[l>>2]=q;hr=d[ht]|0;hs=q}}while(0);q=gc|(hr<<8|hm)<<16;if(!((gd|0)==(ct|0)&(ct|0)==(q|0))){gv=gd;gw=ct;gx=q;gy=0;gz=hs;break}c[2832]=3048;aM=0;i=j;return aM|0}else{c[2832]=3048;aM=0;i=j;return aM|0}}}while(0);if(aS>>>0>=16>>>0){b$=gv;b0=gw;b1=gx;b2=gy;b3=0;b4=gz;break}b$=gv;b0=gw;b1=gx;b2=gy;b3=m-14-r>>2;b4=gz}}while(0);aT=(b2|0)!=0;q=aT?4:3;b8=b+8|0;c[b8>>2]=q;cs=(h|0)==0;fG=(h|0)>2?h:q;q=b|0;f_=$(c[q>>2]|0,fG)|0;fj=fs($(f_,c[aO>>2]|0)|0)|0;if((fj|0)==0){c[2832]=1560;aM=0;i=j;return aM|0}L2585:do{if(aS>>>0<16>>>0){if((b3|0)==0|(b3|0)>256){ft(fj);c[2832]=3e3;aM=0;i=j;return aM|0}if((b3|0)>0){f_=b+32|0;s=b+16|0;ge=b+28|0;gi=b+40|0;gf=b+36|0;hu=0;hv=b4;while(1){hw=c[n>>2]|0;do{if(hv>>>0<hw>>>0){hx=hv+1|0;c[l>>2]=hx;hy=a[hv]|0;hz=hx;hA=hw}else{if((c[f_>>2]|0)==0){hy=0;hz=hv;hA=hw;break}hx=cl[c[s>>2]&3](c[ge>>2]|0,gi,c[gf>>2]|0)|0;if((hx|0)==0){c[f_>>2]=0;hB=(c[n>>2]|0)-1|0;c[l>>2]=hB;a[hB]=0;hC=c[l>>2]|0;hD=c[n>>2]|0}else{c[l>>2]=gi;hB=b+40+hx|0;c[n>>2]=hB;hC=gi;hD=hB}hB=hC+1|0;c[l>>2]=hB;hy=a[hC]|0;hz=hB;hA=hD}}while(0);a[k+(hu<<2)+2|0]=hy;do{if(hz>>>0<hA>>>0){hw=hz+1|0;c[l>>2]=hw;hE=a[hz]|0;hF=hw;hG=hA}else{if((c[f_>>2]|0)==0){hE=0;hF=hz;hG=hA;break}hw=cl[c[s>>2]&3](c[ge>>2]|0,gi,c[gf>>2]|0)|0;if((hw|0)==0){c[f_>>2]=0;ct=(c[n>>2]|0)-1|0;c[l>>2]=ct;a[ct]=0;hH=c[l>>2]|0;hI=c[n>>2]|0}else{c[l>>2]=gi;ct=b+40+hw|0;c[n>>2]=ct;hH=gi;hI=ct}ct=hH+1|0;c[l>>2]=ct;hE=a[hH]|0;hF=ct;hG=hI}}while(0);a[k+(hu<<2)+1|0]=hE;do{if(hF>>>0<hG>>>0){ct=hF+1|0;c[l>>2]=ct;hJ=a[hF]|0;hK=ct}else{if((c[f_>>2]|0)==0){hJ=0;hK=hF;break}ct=cl[c[s>>2]&3](c[ge>>2]|0,gi,c[gf>>2]|0)|0;if((ct|0)==0){c[f_>>2]=0;hw=(c[n>>2]|0)-1|0;c[l>>2]=hw;a[hw]=0;hL=c[l>>2]|0}else{c[l>>2]=gi;c[n>>2]=b+40+ct;hL=gi}ct=hL+1|0;c[l>>2]=ct;hJ=a[hL]|0;hK=ct}}while(0);a[k+(hu<<2)|0]=hJ;do{if(w){hM=hK}else{if(hK>>>0<(c[n>>2]|0)>>>0){ct=hK+1|0;c[l>>2]=ct;hM=ct;break}if((c[f_>>2]|0)==0){hM=hK;break}ct=cl[c[s>>2]&3](c[ge>>2]|0,gi,c[gf>>2]|0)|0;if((ct|0)==0){c[f_>>2]=0;hw=(c[n>>2]|0)-1|0;c[l>>2]=hw;a[hw]=0;hN=c[l>>2]|0}else{c[l>>2]=gi;c[n>>2]=b+40+ct;hN=gi}ct=hN+1|0;c[l>>2]=ct;hM=ct}}while(0);a[k+(hu<<2)+3|0]=-1;ct=hu+1|0;if((ct|0)<(b3|0)){hu=ct;hv=hM}else{hO=hM;hP=s;break}}}else{hO=b4;hP=b+16|0}s=m-14-r-($(b3,w?3:4)|0)|0;do{if((c[hP>>2]|0)==0){p=1990}else{hv=c[n>>2]|0;hu=hv-hO|0;if((hu|0)>=(s|0)){p=1990;break}c[l>>2]=hv;cj[c[b+20>>2]&63](c[b+28>>2]|0,s-hu|0)}}while(0);if((p|0)==1990){c[l>>2]=hO+s}hu=(aS|0)==4;do{if(hu){hv=c[q>>2]|0;hQ=(hv+1|0)>>>1;hR=hv}else{if((aS|0)==8){hv=c[q>>2]|0;hQ=hv;hR=hv;break}ft(fj);c[2832]=2992;aM=0;i=j;return aM|0}}while(0);s=-hQ&3;hv=c[aO>>2]|0;if((hv|0)<=0){hS=hv;break}hv=b+20|0;gi=b+28|0;f_=(fG|0)==4;gf=(aS|0)==8;ge=b+32|0;ct=b+40|0;hw=b+36|0;gd=1;gc=0;hB=hR;while(1){L2652:do{if((hB|0)>0){hx=0;hT=gc;hU=c[l>>2]|0;while(1){do{if(hU>>>0<(c[n>>2]|0)>>>0){hV=hU+1|0;c[l>>2]=hV;hW=d[hU]|0;hX=hV}else{if((c[ge>>2]|0)==0){hW=0;hX=hU;break}hV=cl[c[hP>>2]&3](c[gi>>2]|0,ct,c[hw>>2]|0)|0;if((hV|0)==0){c[ge>>2]=0;hY=(c[n>>2]|0)-1|0;c[l>>2]=hY;a[hY]=0;hZ=c[l>>2]|0}else{c[l>>2]=ct;c[n>>2]=b+40+hV;hZ=ct}hV=hZ+1|0;c[l>>2]=hV;hW=d[hZ]|0;hX=hV}}while(0);if(hu){h_=hW&15;h$=hW>>>4}else{h_=0;h$=hW}a[fj+hT|0]=a[k+(h$<<2)|0]|0;a[fj+(hT+1)|0]=a[k+(h$<<2)+1|0]|0;hV=hT+3|0;a[fj+(hT+2)|0]=a[k+(h$<<2)+2|0]|0;if(f_){a[fj+hV|0]=-1;h0=hT+4|0}else{h0=hV}if((hx|1|0)==(c[q>>2]|0)){h1=h0;break L2652}do{if(gf){if(hX>>>0<(c[n>>2]|0)>>>0){hV=hX+1|0;c[l>>2]=hV;h2=d[hX]|0;h3=hV;break}if((c[ge>>2]|0)==0){h2=0;h3=hX;break}hV=cl[c[hP>>2]&3](c[gi>>2]|0,ct,c[hw>>2]|0)|0;if((hV|0)==0){c[ge>>2]=0;hY=(c[n>>2]|0)-1|0;c[l>>2]=hY;a[hY]=0;h4=c[l>>2]|0}else{c[l>>2]=ct;c[n>>2]=b+40+hV;h4=ct}hV=h4+1|0;c[l>>2]=hV;h2=d[h4]|0;h3=hV}else{h2=h_;h3=hX}}while(0);a[fj+h0|0]=a[k+(h2<<2)|0]|0;a[fj+(h0+1)|0]=a[k+(h2<<2)+1|0]|0;hV=h0+3|0;a[fj+(h0+2)|0]=a[k+(h2<<2)+2|0]|0;if(f_){a[fj+hV|0]=-1;h5=h0+4|0}else{h5=hV}hV=hx+2|0;if((hV|0)<(c[q>>2]|0)){hx=hV;hT=h5;hU=h3}else{h1=h5;break}}}else{h1=gc}}while(0);do{if((c[hP>>2]|0)==0){h6=c[l>>2]|0;p=2027}else{hU=c[n>>2]|0;hT=c[l>>2]|0;hx=hU-hT|0;if((hx|0)>=(s|0)){h6=hT;p=2027;break}c[l>>2]=hU;cj[c[hv>>2]&63](c[gi>>2]|0,s-hx|0)}}while(0);if((p|0)==2027){p=0;c[l>>2]=h6+s}hx=c[aO>>2]|0;if((gd|0)>=(hx|0)){hS=hx;break L2585}gd=gd+1|0;gc=h1;hB=c[q>>2]|0}}else{hB=m-14-r|0;gc=b+16|0;do{if((c[gc>>2]|0)==0){p=2033}else{gd=c[n>>2]|0;s=gd-b4|0;if((s|0)>=(hB|0)){p=2033;break}c[l>>2]=gd;cj[c[b+20>>2]&63](c[b+28>>2]|0,hB-s|0)}}while(0);if((p|0)==2033){c[l>>2]=b4+hB}if((aS|0)==16){h7=c[q>>2]<<1;p=2037}else if((aS|0)==24){h8=0;h9=0;ia=0;ib=0;ic=0;id=((c[q>>2]|0)*-3|0)&3;ie=1;ig=1}else{h7=0;p=2037}do{if((p|0)==2037){s=-h7&2;gd=(aS|0)==32&(b1|0)==255&(b0|0)==65280&(b$|0)==16711680&(b2|0)==-16777216;gi=gd?2:0;if(gd){h8=0;h9=0;ia=0;ib=0;ic=0;id=s;ie=gi;ig=1;break}if((b$|0)==0|(b0|0)==0|(b1|0)==0){ft(fj);c[2832]=2976;aM=0;i=j;return aM|0}gd=b$>>>0>65535>>>0;hv=gd?b$>>>16:b$;f_=gd?16:0;if(hv>>>0>255>>>0){ih=f_|8;ii=hv>>>8}else{ih=f_;ii=hv}if(ii>>>0>15>>>0){ij=ih+4|0;ik=ii>>>4}else{ij=ih;ik=ii}if(ik>>>0>3>>>0){il=ij+2|0;im=ik>>>2}else{il=ij;im=ik}hv=il-7+(im>>>0>1>>>0)|0;f_=(b$>>>1&1431655765)+(b$&1431655765)|0;gd=(f_>>>2&858993459)+(f_&858993459)|0;f_=(gd>>>4)+gd&252645135;gd=(f_>>>8)+f_|0;f_=(gd>>>16)+gd&255;gd=b0>>>0>65535>>>0;ct=gd?b0>>>16:b0;ge=gd?16:0;if(ct>>>0>255>>>0){io=ge|8;ip=ct>>>8}else{io=ge;ip=ct}if(ip>>>0>15>>>0){iq=io+4|0;ir=ip>>>4}else{iq=io;ir=ip}if(ir>>>0>3>>>0){is=iq+2|0;it=ir>>>2}else{is=iq;it=ir}ct=is-7+(it>>>0>1>>>0)|0;ge=b1>>>0>65535>>>0;gd=ge?b1>>>16:b1;hw=ge?16:0;if(gd>>>0>255>>>0){iu=hw|8;iv=gd>>>8}else{iu=hw;iv=gd}if(iv>>>0>15>>>0){iw=iu+4|0;ix=iv>>>4}else{iw=iu;ix=iv}if(ix>>>0>3>>>0){iy=iw+2|0;iz=ix>>>2}else{iy=iw;iz=ix}gd=iy-7+(iz>>>0>1>>>0)|0;if((b2|0)==0){h8=f_;h9=-8;ia=gd;ib=ct;ic=hv;id=s;ie=gi;ig=0;break}hw=b2>>>0>65535>>>0;ge=hw?b2>>>16:b2;gf=hw?16:0;if(ge>>>0>255>>>0){iA=gf|8;iB=ge>>>8}else{iA=gf;iB=ge}if(iB>>>0>15>>>0){iC=iA+4|0;iD=iB>>>4}else{iC=iA;iD=iB}if(iD>>>0>3>>>0){iE=iC+2|0;iF=iD>>>2}else{iE=iC;iF=iD}h8=f_;h9=iE-7+(iF>>>0>1>>>0)|0;ia=gd;ib=ct;ic=hv;id=s;ie=gi;ig=0}}while(0);hB=c[aO>>2]|0;if((hB|0)<=0){hS=hB;break}hB=b+20|0;gi=b+28|0;s=(aS|0)==16;hv=b+32|0;ct=b+40|0;gd=b+36|0;f_=(ic|0)<0;ge=-ic|0;gf=h8>>>0<8>>>0;hw=(ib|0)<0;hu=-ib|0;hx=(ia|0)<0;hU=-ia|0;hT=(h9|0)<0;hV=-h9|0;hY=(fG|0)==4;iG=(ie|0)==2;iH=0;iI=0;while(1){iJ=(c[q>>2]|0)>0;L2753:do{if(ig){if(!iJ){iK=iI;break}iL=1;iM=iI;iN=c[l>>2]|0;while(1){iO=c[n>>2]|0;do{if(iN>>>0<iO>>>0){iP=iN+1|0;c[l>>2]=iP;iQ=a[iN]|0;iR=iP;iS=iO}else{if((c[hv>>2]|0)==0){iQ=0;iR=iN;iS=iO;break}iP=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iP|0)==0){c[hv>>2]=0;iT=(c[n>>2]|0)-1|0;c[l>>2]=iT;a[iT]=0;iU=c[l>>2]|0;iV=c[n>>2]|0}else{c[l>>2]=ct;iT=b+40+iP|0;c[n>>2]=iT;iU=ct;iV=iT}iT=iU+1|0;c[l>>2]=iT;iQ=a[iU]|0;iR=iT;iS=iV}}while(0);a[fj+(iM+2)|0]=iQ;do{if(iR>>>0<iS>>>0){iO=iR+1|0;c[l>>2]=iO;iW=a[iR]|0;iX=iO;iY=iS}else{if((c[hv>>2]|0)==0){iW=0;iX=iR;iY=iS;break}iO=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iO|0)==0){c[hv>>2]=0;iT=(c[n>>2]|0)-1|0;c[l>>2]=iT;a[iT]=0;iZ=c[l>>2]|0;i_=c[n>>2]|0}else{c[l>>2]=ct;iT=b+40+iO|0;c[n>>2]=iT;iZ=ct;i_=iT}iT=iZ+1|0;c[l>>2]=iT;iW=a[iZ]|0;iX=iT;iY=i_}}while(0);a[fj+(iM+1)|0]=iW;do{if(iX>>>0<iY>>>0){iT=iX+1|0;c[l>>2]=iT;i$=a[iX]|0;i0=iT}else{if((c[hv>>2]|0)==0){i$=0;i0=iX;break}iT=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iT|0)==0){c[hv>>2]=0;iO=(c[n>>2]|0)-1|0;c[l>>2]=iO;a[iO]=0;i1=c[l>>2]|0}else{c[l>>2]=ct;c[n>>2]=b+40+iT;i1=ct}iT=i1+1|0;c[l>>2]=iT;i$=a[i1]|0;i0=iT}}while(0);a[fj+iM|0]=i$;iT=iM+3|0;do{if(iG){if(i0>>>0<(c[n>>2]|0)>>>0){iO=i0+1|0;c[l>>2]=iO;i2=a[i0]|0;i3=iO;break}if((c[hv>>2]|0)==0){i2=0;i3=i0;break}iO=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iO|0)==0){c[hv>>2]=0;iP=(c[n>>2]|0)-1|0;c[l>>2]=iP;a[iP]=0;i4=c[l>>2]|0}else{c[l>>2]=ct;c[n>>2]=b+40+iO;i4=ct}iO=i4+1|0;c[l>>2]=iO;i2=a[i4]|0;i3=iO}else{i2=-1;i3=i0}}while(0);if(hY){a[fj+iT|0]=i2;i5=iM+4|0}else{i5=iT}if((iL|0)>=(c[q>>2]|0)){iK=i5;break L2753}iL=iL+1|0;iM=i5;iN=i3}}else{if(!iJ){iK=iI;break}iN=1;iM=iI;iL=c[l>>2]|0;while(1){iO=c[n>>2]|0;iP=iL>>>0<iO>>>0;if(s){do{if(iP){i6=iL+1|0;c[l>>2]=i6;i7=d[iL]|0;i8=i6;i9=iO}else{if((c[hv>>2]|0)==0){i7=0;i8=iL;i9=iO;break}i6=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((i6|0)==0){c[hv>>2]=0;ja=(c[n>>2]|0)-1|0;c[l>>2]=ja;a[ja]=0;jb=c[l>>2]|0;jc=c[n>>2]|0}else{c[l>>2]=ct;ja=b+40+i6|0;c[n>>2]=ja;jb=ct;jc=ja}ja=jb+1|0;c[l>>2]=ja;i7=d[jb]|0;i8=ja;i9=jc}}while(0);do{if(i8>>>0<i9>>>0){iT=i8+1|0;c[l>>2]=iT;jd=d[i8]|0;je=iT}else{if((c[hv>>2]|0)==0){jd=0;je=i8;break}iT=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iT|0)==0){c[hv>>2]=0;ja=(c[n>>2]|0)-1|0;c[l>>2]=ja;a[ja]=0;jf=c[l>>2]|0}else{c[l>>2]=ct;c[n>>2]=b+40+iT;jf=ct}iT=jf+1|0;c[l>>2]=iT;jd=d[jf]|0;je=iT}}while(0);jg=jd<<8|i7;jh=je}else{do{if(iP){iT=iL+1|0;c[l>>2]=iT;ji=d[iL]|0;jj=iT;jk=iO}else{if((c[hv>>2]|0)==0){ji=0;jj=iL;jk=iO;break}iT=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iT|0)==0){c[hv>>2]=0;ja=(c[n>>2]|0)-1|0;c[l>>2]=ja;a[ja]=0;jl=c[l>>2]|0;jm=c[n>>2]|0}else{c[l>>2]=ct;ja=b+40+iT|0;c[n>>2]=ja;jl=ct;jm=ja}ja=jl+1|0;c[l>>2]=ja;ji=d[jl]|0;jj=ja;jk=jm}}while(0);do{if(jj>>>0<jk>>>0){iO=jj+1|0;c[l>>2]=iO;jn=d[jj]|0;jo=iO;jp=jk}else{if((c[hv>>2]|0)==0){jn=0;jo=jj;jp=jk;break}iO=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iO|0)==0){c[hv>>2]=0;iP=(c[n>>2]|0)-1|0;c[l>>2]=iP;a[iP]=0;jq=c[l>>2]|0;jr=c[n>>2]|0}else{c[l>>2]=ct;iP=b+40+iO|0;c[n>>2]=iP;jq=ct;jr=iP}iP=jq+1|0;c[l>>2]=iP;jn=d[jq]|0;jo=iP;jp=jr}}while(0);iP=jn<<8|ji;do{if(jo>>>0<jp>>>0){iO=jo+1|0;c[l>>2]=iO;js=d[jo]|0;jt=iO;ju=jp}else{if((c[hv>>2]|0)==0){js=0;jt=jo;ju=jp;break}iO=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((iO|0)==0){c[hv>>2]=0;ja=(c[n>>2]|0)-1|0;c[l>>2]=ja;a[ja]=0;jv=c[l>>2]|0;jw=c[n>>2]|0}else{c[l>>2]=ct;ja=b+40+iO|0;c[n>>2]=ja;jv=ct;jw=ja}ja=jv+1|0;c[l>>2]=ja;js=d[jv]|0;jt=ja;ju=jw}}while(0);do{if(jt>>>0<ju>>>0){ja=jt+1|0;c[l>>2]=ja;jx=d[jt]|0;jy=ja}else{if((c[hv>>2]|0)==0){jx=0;jy=jt;break}ja=cl[c[gc>>2]&3](c[gi>>2]|0,ct,c[gd>>2]|0)|0;if((ja|0)==0){c[hv>>2]=0;iO=(c[n>>2]|0)-1|0;c[l>>2]=iO;a[iO]=0;jz=c[l>>2]|0}else{c[l>>2]=ct;c[n>>2]=b+40+ja;jz=ct}ja=jz+1|0;c[l>>2]=ja;jx=d[jz]|0;jy=ja}}while(0);jg=iP|(jx<<8|js)<<16;jh=jy}ja=jg&b$;iO=f_?ja<<ge:ja>>ic;ja=iO&255;if(gf){iT=iO;i6=h8;do{iT=(iO>>i6)+iT|0;i6=i6+h8|0;}while((i6|0)<8);jA=iT&255}else{jA=ja}i6=iM+1|0;a[fj+iM|0]=jA;iO=jg&b0;iP=hw?iO<<hu:iO>>ib;iO=iP&255;if(gf){jB=iP;jC=h8;do{jB=(iP>>jC)+jB|0;jC=jC+h8|0;}while((jC|0)<8);jD=jB&255}else{jD=iO}jC=iM+2|0;a[fj+i6|0]=jD;iP=jg&b1;ja=hx?iP<<hU:iP>>ia;iP=ja&255;if(gf){iT=ja;jE=h8;do{iT=(ja>>jE)+iT|0;jE=jE+h8|0;}while((jE|0)<8);jF=iT&255}else{jF=iP}jE=iM+3|0;a[fj+jC|0]=jF;do{if(aT){ja=jg&b2;i6=hT?ja<<hV:ja>>h9;if(gf){jG=i6;jH=h8}else{jI=i6&255;break}do{jG=(i6>>jH)+jG|0;jH=jH+h8|0;}while((jH|0)<8);jI=jG&255}else{jI=-1}}while(0);if(hY){a[fj+jE|0]=jI;jJ=iM+4|0}else{jJ=jE}if((iN|0)>=(c[q>>2]|0)){iK=jJ;break L2753}iN=iN+1|0;iM=jJ;iL=jh}}}while(0);do{if((c[gc>>2]|0)==0){jK=c[l>>2]|0;p=2172}else{iJ=c[n>>2]|0;iL=c[l>>2]|0;iM=iJ-iL|0;if((iM|0)>=(id|0)){jK=iL;p=2172;break}c[l>>2]=iJ;cj[c[hB>>2]&63](c[gi>>2]|0,id-iM|0)}}while(0);if((p|0)==2172){p=0;c[l>>2]=jK+id}iM=iH+1|0;iJ=c[aO>>2]|0;if((iM|0)<(iJ|0)){iH=iM;iI=iK}else{hS=iJ;break}}}}while(0);do{if(aN){aT=hS>>1;if((aT|0)<=0){break}aS=c[q>>2]|0;r=$(aS,fG)|0;m=(r|0)>0;w=0;do{iI=$($(w,fG)|0,aS)|0;iH=$($(hS+~w|0,fG)|0,aS)|0;if(m){gi=0;do{hB=fj+(gi+iI)|0;gc=a[hB]|0;hY=fj+(gi+iH)|0;a[hB]=a[hY]|0;a[hY]=gc;gi=gi+1|0;}while((gi|0)<(r|0))}w=w+1|0;}while((w|0)<(aT|0))}}while(0);do{if(cs|(fG|0)==(h|0)){jL=fj}else{aN=e_(fj,fG,h,c[q>>2]|0,hS)|0;if((aN|0)==0){aM=0}else{jL=aN;break}i=j;return aM|0}}while(0);c[e>>2]=c[q>>2];c[f>>2]=c[aO>>2];if((g|0)==0){aM=jL;i=j;return aM|0}c[g>>2]=c[b8>>2];aM=jL;i=j;return aM|0}}while(0);c[2832]=3072;aM=0;i=j;return aM|0}function e2(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return b|0}function e3(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0;if((f|0)>0){h=0}else{return b|0}do{a[b+h|0]=((d[e+h|0]|0)+2+((d[c+h|0]|0)*3|0)|0)>>>2&255;h=h+1|0;}while((h|0)<(f|0));return b|0}function e4(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;g=a[c]|0;if((f|0)==1){a[b+1|0]=g;a[b]=g;return b|0}a[b]=g;a[b+1|0]=((d[c+1|0]|0)+2+((d[c]|0)*3|0)|0)>>>2&255;g=f-1|0;if((g|0)>1){e=1;do{h=((d[c+e|0]|0)*3|0)+2|0;i=e<<1;a[b+i|0]=(h+(d[c+(e-1)|0]|0)|0)>>>2&255;e=e+1|0;a[b+(i|1)|0]=(h+(d[c+e|0]|0)|0)>>>2&255;}while((e|0)<(g|0));j=g<<1}else{j=2}e=c+g|0;a[b+j|0]=((d[e]|0)+2+((d[c+(f-2)|0]|0)*3|0)|0)>>>2&255;a[b+(j|1)|0]=a[e]|0;return b|0}function e5(b,c,e,f,g){b=b|0;c=c|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;g=((d[c]|0)*3|0)+(d[e]|0)|0;h=(g+2|0)>>>2&255;if((f|0)==1){a[b+1|0]=h;a[b]=h;return b|0}a[b]=h;if((f|0)>1){h=1;i=g;while(1){j=((d[c+h|0]|0)*3|0)+(d[e+h|0]|0)|0;k=h<<1;a[b+(k-1)|0]=((i*3|0)+8+j|0)>>>4&255;a[b+k|0]=(i+8+(j*3|0)|0)>>>4&255;k=h+1|0;if((k|0)<(f|0)){h=k;i=j}else{l=j;break}}}else{l=g}a[b+((f<<1)-1)|0]=(l+2|0)>>>2&255;return b|0}function e6(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;if((e|0)<=0){return b|0}d=(f|0)>0;g=0;do{if(d){h=c+g|0;i=$(g,f)|0;j=0;do{a[b+(j+i)|0]=a[h]|0;j=j+1|0;}while((j|0)<(f|0))}g=g+1|0;}while((g|0)<(e|0));return b|0}function e7(e,f,g,h,i){e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;j=e9(e,g)|0;if((j|0)<0){c[2832]=552;k=0;return k|0}fF(f|0,0,128);do{if((j|0)==0){l=0;m=e+13952|0}else{g=1<<j-1;n=e+13952|0;o=c[n>>2]|0;L2964:do{if((o|0)<(j|0)){p=e+13960|0;q=e|0;r=e+13948|0;L2966:while(1){L2968:do{if((c[p>>2]|0)==0){s=c[q>>2]|0;t=s+168|0;u=c[t>>2]|0;v=s+172|0;do{if(u>>>0<(c[v>>2]|0)>>>0){w=u}else{x=s+32|0;if((c[x>>2]|0)==0){y=0;break L2968}z=s+40|0;A=cl[c[s+16>>2]&3](c[s+28>>2]|0,z,c[s+36>>2]|0)|0;if((A|0)==0){c[x>>2]=0;x=(c[v>>2]|0)-1|0;c[t>>2]=x;a[x]=0;w=c[t>>2]|0;break}else{c[t>>2]=z;c[v>>2]=s+40+A;w=z;break}}}while(0);c[t>>2]=w+1;s=a[w]|0;if(s<<24>>24!=-1){y=s&255;break}s=c[q>>2]|0;v=s+168|0;u=c[v>>2]|0;z=s+172|0;do{if(u>>>0<(c[z>>2]|0)>>>0){B=u}else{A=s+32|0;if((c[A>>2]|0)==0){y=255;break L2968}x=s+40|0;C=cl[c[s+16>>2]&3](c[s+28>>2]|0,x,c[s+36>>2]|0)|0;if((C|0)==0){c[A>>2]=0;A=(c[z>>2]|0)-1|0;c[v>>2]=A;a[A]=0;B=c[v>>2]|0;break}else{c[v>>2]=x;c[z>>2]=s+40+C;B=x;break}}}while(0);c[v>>2]=B+1;D=a[B]|0;if(D<<24>>24==0){y=255}else{break L2966}}else{y=0}}while(0);s=c[n>>2]|0;c[r>>2]=y<<24-s|c[r>>2];z=s+8|0;c[n>>2]=z;if((z|0)>=25){E=z;F=r;break L2964}}a[e+13956|0]=D;c[p>>2]=1;E=c[n>>2]|0;F=r}else{E=o;F=e+13948|0}}while(0);o=c[F>>2]|0;q=o<<j|o>>>((32-j|0)>>>0);o=c[6176+(j<<2)>>2]|0;c[F>>2]=q&~o;z=q&o;c[n>>2]=E-j;if(z>>>0>=g>>>0){l=z;m=n;break}l=(-1<<j)+1+z|0;m=n}}while(0);j=e+13724+(i*56|0)+24|0;i=(c[j>>2]|0)+l|0;c[j>>2]=i;b[f>>1]=i&65535;i=e+13960|0;j=e|0;l=e+13948|0;E=e+13956|0;F=1;while(1){D=e9(e,h)|0;if((D|0)<0){G=2258;break}y=D&15;if((y|0)==0){if((D|0)!=240){k=1;G=2287;break}H=F+16|0}else{B=(D>>4)+F|0;D=1<<y-1;w=c[m>>2]|0;L2998:do{if((w|0)<(y|0)){L2999:while(1){L3001:do{if((c[i>>2]|0)==0){z=c[j>>2]|0;o=z+168|0;q=c[o>>2]|0;s=z+172|0;do{if(q>>>0<(c[s>>2]|0)>>>0){I=q}else{u=z+32|0;if((c[u>>2]|0)==0){J=0;break L3001}t=z+40|0;x=cl[c[z+16>>2]&3](c[z+28>>2]|0,t,c[z+36>>2]|0)|0;if((x|0)==0){c[u>>2]=0;u=(c[s>>2]|0)-1|0;c[o>>2]=u;a[u]=0;I=c[o>>2]|0;break}else{c[o>>2]=t;c[s>>2]=z+40+x;I=t;break}}}while(0);c[o>>2]=I+1;z=a[I]|0;if(z<<24>>24!=-1){J=z&255;break}z=c[j>>2]|0;s=z+168|0;q=c[s>>2]|0;v=z+172|0;do{if(q>>>0<(c[v>>2]|0)>>>0){K=q}else{t=z+32|0;if((c[t>>2]|0)==0){J=255;break L3001}x=z+40|0;u=cl[c[z+16>>2]&3](c[z+28>>2]|0,x,c[z+36>>2]|0)|0;if((u|0)==0){c[t>>2]=0;t=(c[v>>2]|0)-1|0;c[s>>2]=t;a[t]=0;K=c[s>>2]|0;break}else{c[s>>2]=x;c[v>>2]=z+40+u;K=x;break}}}while(0);c[s>>2]=K+1;L=a[K]|0;if(L<<24>>24==0){J=255}else{break L2999}}else{J=0}}while(0);z=c[m>>2]|0;c[l>>2]=J<<24-z|c[l>>2];v=z+8|0;c[m>>2]=v;if((v|0)>=25){M=v;break L2998}}a[E]=L;c[i>>2]=1;M=c[m>>2]|0}else{M=w}}while(0);w=c[l>>2]|0;n=w<<y|w>>>((32-y|0)>>>0);w=c[6176+(y<<2)>>2]|0;c[l>>2]=n&~w;g=n&w;c[m>>2]=M-y;if(g>>>0<D>>>0){N=(-1<<y)+1+g&65535}else{N=g&65535}b[f+((d[6096+B|0]|0)<<1)>>1]=N;H=B+1|0}if((H|0)<64){F=H}else{k=1;G=2284;break}}if((G|0)==2284){return k|0}else if((G|0)==2287){return k|0}else if((G|0)==2258){c[2832]=552;k=0;return k|0}return 0}function e8(e,f,g,h){e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;j=i;i=i+256|0;k=j|0;l=g;g=h;h=k;m=0;while(1){n=b[l+16>>1]|0;o=b[l+32>>1]|0;do{if((n|o)<<16>>16==0){if((b[l+48>>1]|0)!=0){p=0;q=2296;break}if((b[l+64>>1]|0)!=0){p=0;q=2296;break}if((b[l+80>>1]|0)!=0){p=0;q=2296;break}if((b[l+96>>1]|0)!=0){p=0;q=2296;break}if((b[l+112>>1]|0)!=0){p=0;q=2296;break}r=$(b[l>>1]<<2,d[g]|0)|0;c[h+224>>2]=r;c[h+192>>2]=r;c[h+160>>2]=r;c[h+128>>2]=r;c[h+96>>2]=r;c[h+64>>2]=r;c[h+32>>2]=r;c[h>>2]=r}else{p=o;q=2296}}while(0);if((q|0)==2296){q=0;o=$(d[g+16|0]|0,p<<16>>16)|0;r=$(d[g+48|0]|0,b[l+96>>1]|0)|0;s=(r+o|0)*2217|0;t=s+(r*-7567|0)|0;r=s+(o*3135|0)|0;o=$(d[g]|0,b[l>>1]|0)|0;s=$(d[g+32|0]|0,b[l+64>>1]|0)|0;u=s+o<<12;v=o-s<<12;s=$(d[g+56|0]|0,b[l+112>>1]|0)|0;o=$(d[g+40|0]|0,b[l+80>>1]|0)|0;w=$(d[g+24|0]|0,b[l+48>>1]|0)|0;x=$(d[g+8|0]|0,n<<16>>16)|0;y=w+s|0;z=x+o|0;A=(z+y|0)*4816|0;B=A+((x+s|0)*-3685|0)|0;C=A+((w+o|0)*-10497|0)|0;A=y*-8034|0;y=z*-1597|0;z=y+(x*6149|0)+B|0;x=A+(w*12586|0)+C|0;w=y+(o*8410|0)+C|0;C=A+(s*1223|0)+B|0;B=r+512+u|0;s=t+512+v|0;A=v-t+512|0;t=u-r+512|0;c[h>>2]=z+B>>10;c[h+224>>2]=B-z>>10;c[h+32>>2]=x+s>>10;c[h+192>>2]=s-x>>10;c[h+64>>2]=w+A>>10;c[h+160>>2]=A-w>>10;c[h+96>>2]=C+t>>10;c[h+128>>2]=t-C>>10}C=m+1|0;if((C|0)<8){l=l+2|0;g=g+1|0;h=h+4|0;m=C}else{D=e;E=k;F=0;break}}while(1){k=c[E+8>>2]|0;e=c[E+24>>2]|0;m=(e+k|0)*2217|0;h=m+(e*-7567|0)|0;e=m+(k*3135|0)|0;k=c[E>>2]|0;m=c[E+16>>2]|0;g=m+k<<12;l=k-m<<12;m=c[E+28>>2]|0;k=c[E+20>>2]|0;p=c[E+12>>2]|0;q=c[E+4>>2]|0;C=p+m|0;t=q+k|0;w=(t+C|0)*4816|0;A=w+((q+m|0)*-3685|0)|0;x=w+((p+k|0)*-10497|0)|0;w=C*-8034|0;C=t*-1597|0;t=C+(q*6149|0)+A|0;q=w+(p*12586|0)+x|0;p=C+(k*8410|0)+x|0;x=w+(m*1223|0)+A|0;A=e+16842752+g|0;m=h+16842752+l|0;w=l-h+16842752|0;h=g-e+16842752|0;e=t+A|0;g=e>>17;if(g>>>0>255>>>0){G=~(e>>31&255)}else{G=g&255}a[D]=G;g=A-t|0;t=g>>17;if(t>>>0>255>>>0){H=~(g>>31&255)}else{H=t&255}a[D+7|0]=H;t=q+m|0;g=t>>17;if(g>>>0>255>>>0){I=~(t>>31&255)}else{I=g&255}a[D+1|0]=I;g=m-q|0;q=g>>17;if(q>>>0>255>>>0){J=~(g>>31&255)}else{J=q&255}a[D+6|0]=J;q=p+w|0;g=q>>17;if(g>>>0>255>>>0){K=~(q>>31&255)}else{K=g&255}a[D+2|0]=K;g=w-p|0;p=g>>17;if(p>>>0>255>>>0){L=~(g>>31&255)}else{L=p&255}a[D+5|0]=L;p=x+h|0;g=p>>17;if(g>>>0>255>>>0){M=~(p>>31&255)}else{M=g&255}a[D+3|0]=M;g=h-x|0;x=g>>17;if(x>>>0>255>>>0){N=~(g>>31&255)}else{N=x&255}a[D+4|0]=N;x=F+1|0;if((x|0)<8){D=D+f|0;E=E+32|0;F=x}else{break}}i=j;return}function e9(b,f){b=b|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;g=b+13952|0;L3083:do{if((c[g>>2]|0)<16){h=b+13960|0;i=b|0;j=b+13948|0;L3086:while(1){L3088:do{if((c[h>>2]|0)==0){k=c[i>>2]|0;l=k+168|0;m=c[l>>2]|0;n=k+172|0;do{if(m>>>0<(c[n>>2]|0)>>>0){o=m}else{p=k+32|0;if((c[p>>2]|0)==0){q=0;break L3088}r=k+40|0;s=cl[c[k+16>>2]&3](c[k+28>>2]|0,r,c[k+36>>2]|0)|0;if((s|0)==0){c[p>>2]=0;p=(c[n>>2]|0)-1|0;c[l>>2]=p;a[p]=0;o=c[l>>2]|0;break}else{c[l>>2]=r;c[n>>2]=k+40+s;o=r;break}}}while(0);c[l>>2]=o+1;k=a[o]|0;if(k<<24>>24!=-1){q=k&255;break}k=c[i>>2]|0;n=k+168|0;m=c[n>>2]|0;r=k+172|0;do{if(m>>>0<(c[r>>2]|0)>>>0){t=m}else{s=k+32|0;if((c[s>>2]|0)==0){q=255;break L3088}p=k+40|0;u=cl[c[k+16>>2]&3](c[k+28>>2]|0,p,c[k+36>>2]|0)|0;if((u|0)==0){c[s>>2]=0;s=(c[r>>2]|0)-1|0;c[n>>2]=s;a[s]=0;t=c[n>>2]|0;break}else{c[n>>2]=p;c[r>>2]=k+40+u;t=p;break}}}while(0);c[n>>2]=t+1;v=a[t]|0;if(v<<24>>24==0){q=255}else{break L3086}}else{q=0}}while(0);k=c[g>>2]|0;c[j>>2]=q<<24-k|c[j>>2];r=k+8|0;c[g>>2]=r;if((r|0)>=25){w=j;break L3083}}a[b+13956|0]=v;c[h>>2]=1;w=j}else{w=b+13948|0}}while(0);b=c[w>>2]|0;v=a[f+(b>>>23)|0]|0;q=v&255;if(v<<24>>24!=-1){v=d[f+1280+q|0]|0;t=c[g>>2]|0;if((v|0)>(t|0)){x=-1;return x|0}c[w>>2]=b<<v;c[g>>2]=t-v;x=d[f+1024+q|0]|0;return x|0}q=b>>>16;v=10;while(1){if(q>>>0<(c[f+1540+(v<<2)>>2]|0)>>>0){break}else{v=v+1|0}}q=c[g>>2]|0;if((v|0)==17){c[g>>2]=q-16;x=-1;return x|0}if((v|0)>(q|0)){x=-1;return x|0}t=(b>>>((32-v|0)>>>0)&c[6176+(v<<2)>>2])+(c[f+1612+(v<<2)>>2]|0)|0;o=d[f+1280+t|0]|0;if((b>>>((32-o|0)>>>0)&c[6176+(o<<2)>>2]|0)!=(e[f+512+(t<<1)>>1]|0|0)){bT(2872,1472,1106,3440);return 0}c[g>>2]=q-v;c[w>>2]=b<<v;x=d[f+1024+t|0]|0;return x|0}function fa(a){a=a|0;return}function fb(a){a=a|0;fa(a|0);return}function fc(a){a=a|0;return}function fd(a){a=a|0;return}function fe(a){a=a|0;fa(a|0);fz(a);return}function ff(a){a=a|0;fa(a|0);fz(a);return}function fg(a){a=a|0;fa(a|0);fz(a);return}function fh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+56|0;f=e|0;if((a|0)==(b|0)){g=1;i=e;return g|0}if((b|0)==0){g=0;i=e;return g|0}h=fl(b,5568,5552,-1)|0;b=h;if((h|0)==0){g=0;i=e;return g|0}fF(f|0,0,56);c[f>>2]=b;c[f+8>>2]=a;c[f+12>>2]=-1;c[f+48>>2]=1;ct[c[(c[h>>2]|0)+28>>2]&15](b,f,c[d>>2]|0,1);if((c[f+24>>2]|0)!=1){g=0;i=e;return g|0}c[d>>2]=c[f+16>>2];g=1;i=e;return g|0}function fi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;if((c[d+8>>2]|0)!=(b|0)){return}b=d+16|0;g=c[b>>2]|0;if((g|0)==0){c[b>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;return}if((g|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;c[d+24>>2]=2;a[d+54|0]=1;return}e=d+24|0;if((c[e>>2]|0)!=2){return}c[e>>2]=f;return}function fj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;if((b|0)!=(c[d+8>>2]|0)){g=c[b+8>>2]|0;ct[c[(c[g>>2]|0)+28>>2]&15](g,d,e,f);return}g=d+16|0;b=c[g>>2]|0;if((b|0)==0){c[g>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;return}if((b|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;c[d+24>>2]=2;a[d+54|0]=1;return}e=d+24|0;if((c[e>>2]|0)!=2){return}c[e>>2]=f;return}function fk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;if((b|0)==(c[d+8>>2]|0)){g=d+16|0;h=c[g>>2]|0;if((h|0)==0){c[g>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;return}if((h|0)!=(e|0)){h=d+36|0;c[h>>2]=(c[h>>2]|0)+1;c[d+24>>2]=2;a[d+54|0]=1;return}h=d+24|0;if((c[h>>2]|0)!=2){return}c[h>>2]=f;return}h=c[b+12>>2]|0;g=b+16+(h<<3)|0;i=c[b+20>>2]|0;j=i>>8;if((i&1|0)==0){k=j}else{k=c[(c[e>>2]|0)+j>>2]|0}j=c[b+16>>2]|0;ct[c[(c[j>>2]|0)+28>>2]&15](j,d,e+k|0,(i&2|0)!=0?f:2);if((h|0)<=1){return}h=d+54|0;i=e;k=b+24|0;while(1){b=c[k+4>>2]|0;j=b>>8;if((b&1|0)==0){l=j}else{l=c[(c[i>>2]|0)+j>>2]|0}j=c[k>>2]|0;ct[c[(c[j>>2]|0)+28>>2]&15](j,d,e+l|0,(b&2|0)!=0?f:2);if((a[h]&1)!=0){m=2421;break}b=k+8|0;if(b>>>0<g>>>0){k=b}else{m=2424;break}}if((m|0)==2421){return}else if((m|0)==2424){return}}function fl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+56|0;g=f|0;h=c[a>>2]|0;j=a+(c[h-8>>2]|0)|0;k=c[h-4>>2]|0;h=k;c[g>>2]=d;c[g+4>>2]=a;c[g+8>>2]=b;c[g+12>>2]=e;e=g+16|0;b=g+20|0;a=g+24|0;l=g+28|0;m=g+32|0;n=g+40|0;fF(e|0,0,39);if((k|0)==(d|0)){c[g+48>>2]=1;cq[c[(c[k>>2]|0)+20>>2]&15](h,g,j,j,1,0);i=f;return((c[a>>2]|0)==1?j:0)|0}ch[c[(c[k>>2]|0)+24>>2]&7](h,g,j,1,0);j=c[g+36>>2]|0;if((j|0)==1){do{if((c[a>>2]|0)!=1){if((c[n>>2]|0)!=0){o=0;i=f;return o|0}if((c[l>>2]|0)!=1){o=0;i=f;return o|0}if((c[m>>2]|0)==1){break}else{o=0}i=f;return o|0}}while(0);o=c[e>>2]|0;i=f;return o|0}else if((j|0)==0){if((c[n>>2]|0)!=1){o=0;i=f;return o|0}if((c[l>>2]|0)!=1){o=0;i=f;return o|0}o=(c[m>>2]|0)==1?c[b>>2]|0:0;i=f;return o|0}else{o=0;i=f;return o|0}return 0}function fm(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;h=b|0;if((h|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){return}i=d+28|0;if((c[i>>2]|0)==1){return}c[i>>2]=f;return}if((h|0)==(c[d>>2]|0)){do{if((c[d+16>>2]|0)!=(e|0)){h=d+20|0;if((c[h>>2]|0)==(e|0)){break}c[d+32>>2]=f;i=d+44|0;if((c[i>>2]|0)==4){return}j=c[b+12>>2]|0;k=b+16+(j<<3)|0;L3261:do{if((j|0)>0){l=d+52|0;m=d+53|0;n=d+54|0;o=b+8|0;p=d+24|0;q=e;r=0;s=b+16|0;t=0;L3263:while(1){a[l]=0;a[m]=0;u=c[s+4>>2]|0;v=u>>8;if((u&1|0)==0){w=v}else{w=c[(c[q>>2]|0)+v>>2]|0}v=c[s>>2]|0;cq[c[(c[v>>2]|0)+20>>2]&15](v,d,e,e+w|0,2-(u>>>1&1)|0,g);if((a[n]&1)!=0){x=t;y=r;break}do{if((a[m]&1)==0){z=t;A=r}else{if((a[l]&1)==0){if((c[o>>2]&1|0)==0){x=1;y=r;break L3263}else{z=1;A=r;break}}if((c[p>>2]|0)==1){B=2474;break L3261}if((c[o>>2]&2|0)==0){B=2474;break L3261}else{z=1;A=1}}}while(0);u=s+8|0;if(u>>>0<k>>>0){r=A;s=u;t=z}else{x=z;y=A;break}}if(y){C=x;B=2473}else{D=x;B=2470}}else{D=0;B=2470}}while(0);do{if((B|0)==2470){c[h>>2]=e;k=d+40|0;c[k>>2]=(c[k>>2]|0)+1;if((c[d+36>>2]|0)!=1){C=D;B=2473;break}if((c[d+24>>2]|0)!=2){C=D;B=2473;break}a[d+54|0]=1;if(D){B=2474}else{B=2475}}}while(0);if((B|0)==2473){if(C){B=2474}else{B=2475}}if((B|0)==2474){c[i>>2]=3;return}else if((B|0)==2475){c[i>>2]=4;return}}}while(0);if((f|0)!=1){return}c[d+32>>2]=1;return}C=c[b+12>>2]|0;D=b+16+(C<<3)|0;x=c[b+20>>2]|0;y=x>>8;if((x&1|0)==0){E=y}else{E=c[(c[e>>2]|0)+y>>2]|0}y=c[b+16>>2]|0;ch[c[(c[y>>2]|0)+24>>2]&7](y,d,e+E|0,(x&2|0)!=0?f:2,g);x=b+24|0;if((C|0)<=1){return}C=c[b+8>>2]|0;do{if((C&2|0)==0){b=d+36|0;if((c[b>>2]|0)==1){break}if((C&1|0)==0){E=d+54|0;y=e;A=x;while(1){if((a[E]&1)!=0){B=2504;break}if((c[b>>2]|0)==1){B=2505;break}z=c[A+4>>2]|0;w=z>>8;if((z&1|0)==0){F=w}else{F=c[(c[y>>2]|0)+w>>2]|0}w=c[A>>2]|0;ch[c[(c[w>>2]|0)+24>>2]&7](w,d,e+F|0,(z&2|0)!=0?f:2,g);z=A+8|0;if(z>>>0<D>>>0){A=z}else{B=2510;break}}if((B|0)==2504){return}else if((B|0)==2505){return}else if((B|0)==2510){return}}A=d+24|0;y=d+54|0;E=e;i=x;while(1){if((a[y]&1)!=0){B=2512;break}if((c[b>>2]|0)==1){if((c[A>>2]|0)==1){B=2513;break}}z=c[i+4>>2]|0;w=z>>8;if((z&1|0)==0){G=w}else{G=c[(c[E>>2]|0)+w>>2]|0}w=c[i>>2]|0;ch[c[(c[w>>2]|0)+24>>2]&7](w,d,e+G|0,(z&2|0)!=0?f:2,g);z=i+8|0;if(z>>>0<D>>>0){i=z}else{B=2503;break}}if((B|0)==2503){return}else if((B|0)==2512){return}else if((B|0)==2513){return}}}while(0);G=d+54|0;F=e;C=x;while(1){if((a[G]&1)!=0){B=2516;break}x=c[C+4>>2]|0;i=x>>8;if((x&1|0)==0){H=i}else{H=c[(c[F>>2]|0)+i>>2]|0}i=c[C>>2]|0;ch[c[(c[i>>2]|0)+24>>2]&7](i,d,e+H|0,(x&2|0)!=0?f:2,g);x=C+8|0;if(x>>>0<D>>>0){C=x}else{B=2501;break}}if((B|0)==2501){return}else if((B|0)==2516){return}}function fn(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=b|0;if((h|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){return}i=d+28|0;if((c[i>>2]|0)==1){return}c[i>>2]=f;return}if((h|0)!=(c[d>>2]|0)){h=c[b+8>>2]|0;ch[c[(c[h>>2]|0)+24>>2]&7](h,d,e,f,g);return}do{if((c[d+16>>2]|0)!=(e|0)){h=d+20|0;if((c[h>>2]|0)==(e|0)){break}c[d+32>>2]=f;i=d+44|0;if((c[i>>2]|0)==4){return}j=d+52|0;a[j]=0;k=d+53|0;a[k]=0;l=c[b+8>>2]|0;cq[c[(c[l>>2]|0)+20>>2]&15](l,d,e,e,1,g);if((a[k]&1)==0){m=0;n=2530}else{if((a[j]&1)==0){m=1;n=2530}}L3363:do{if((n|0)==2530){c[h>>2]=e;j=d+40|0;c[j>>2]=(c[j>>2]|0)+1;do{if((c[d+36>>2]|0)==1){if((c[d+24>>2]|0)!=2){n=2533;break}a[d+54|0]=1;if(m){break L3363}}else{n=2533}}while(0);if((n|0)==2533){if(m){break}}c[i>>2]=4;return}}while(0);c[i>>2]=3;return}}while(0);if((f|0)!=1){return}c[d+32>>2]=1;return}function fo(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((c[d+8>>2]|0)==(b|0)){if((c[d+4>>2]|0)!=(e|0)){return}g=d+28|0;if((c[g>>2]|0)==1){return}c[g>>2]=f;return}if((c[d>>2]|0)!=(b|0)){return}do{if((c[d+16>>2]|0)!=(e|0)){b=d+20|0;if((c[b>>2]|0)==(e|0)){break}c[d+32>>2]=f;c[b>>2]=e;b=d+40|0;c[b>>2]=(c[b>>2]|0)+1;do{if((c[d+36>>2]|0)==1){if((c[d+24>>2]|0)!=2){break}a[d+54|0]=1}}while(0);c[d+44>>2]=4;return}}while(0);if((f|0)!=1){return}c[d+32>>2]=1;return}function fp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;if((b|0)!=(c[d+8>>2]|0)){i=d+52|0;j=a[i]&1;k=d+53|0;l=a[k]&1;m=c[b+12>>2]|0;n=b+16+(m<<3)|0;a[i]=0;a[k]=0;o=c[b+20>>2]|0;p=o>>8;if((o&1|0)==0){q=p}else{q=c[(c[f>>2]|0)+p>>2]|0}p=c[b+16>>2]|0;cq[c[(c[p>>2]|0)+20>>2]&15](p,d,e,f+q|0,(o&2|0)!=0?g:2,h);L3412:do{if((m|0)>1){o=d+24|0;q=b+8|0;p=d+54|0;r=f;s=b+24|0;do{if((a[p]&1)!=0){break L3412}do{if((a[i]&1)==0){if((a[k]&1)==0){break}if((c[q>>2]&1|0)==0){break L3412}}else{if((c[o>>2]|0)==1){break L3412}if((c[q>>2]&2|0)==0){break L3412}}}while(0);a[i]=0;a[k]=0;t=c[s+4>>2]|0;u=t>>8;if((t&1|0)==0){v=u}else{v=c[(c[r>>2]|0)+u>>2]|0}u=c[s>>2]|0;cq[c[(c[u>>2]|0)+20>>2]&15](u,d,e,f+v|0,(t&2|0)!=0?g:2,h);s=s+8|0;}while(s>>>0<n>>>0)}}while(0);a[i]=j;a[k]=l;return}a[d+53|0]=1;if((c[d+4>>2]|0)!=(f|0)){return}a[d+52|0]=1;f=d+16|0;l=c[f>>2]|0;if((l|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((c[d+48>>2]|0)==1&(g|0)==1)){return}a[d+54|0]=1;return}if((l|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54|0]=1;return}e=d+24|0;l=c[e>>2]|0;if((l|0)==2){c[e>>2]=g;w=g}else{w=l}if(!((c[d+48>>2]|0)==1&(w|0)==1)){return}a[d+54|0]=1;return}function fq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0;if((b|0)!=(c[d+8>>2]|0)){i=c[b+8>>2]|0;cq[c[(c[i>>2]|0)+20>>2]&15](i,d,e,f,g,h);return}a[d+53|0]=1;if((c[d+4>>2]|0)!=(f|0)){return}a[d+52|0]=1;f=d+16|0;h=c[f>>2]|0;if((h|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((c[d+48>>2]|0)==1&(g|0)==1)){return}a[d+54|0]=1;return}if((h|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54|0]=1;return}e=d+24|0;h=c[e>>2]|0;if((h|0)==2){c[e>>2]=g;j=g}else{j=h}if(!((c[d+48>>2]|0)==1&(j|0)==1)){return}a[d+54|0]=1;return}function fr(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;if((c[d+8>>2]|0)!=(b|0)){return}a[d+53|0]=1;if((c[d+4>>2]|0)!=(f|0)){return}a[d+52|0]=1;f=d+16|0;b=c[f>>2]|0;if((b|0)==0){c[f>>2]=e;c[d+24>>2]=g;c[d+36>>2]=1;if(!((c[d+48>>2]|0)==1&(g|0)==1)){return}a[d+54|0]=1;return}if((b|0)!=(e|0)){e=d+36|0;c[e>>2]=(c[e>>2]|0)+1;a[d+54|0]=1;return}e=d+24|0;b=c[e>>2]|0;if((b|0)==2){c[e>>2]=g;i=g}else{i=b}if(!((c[d+48>>2]|0)==1&(i|0)==1)){return}a[d+54|0]=1;return}function fs(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0;do{if(a>>>0<245>>>0){if(a>>>0<11>>>0){b=16}else{b=a+11&-8}d=b>>>3;e=c[1674]|0;f=e>>>(d>>>0);if((f&3|0)!=0){g=(f&1^1)+d|0;h=g<<1;i=6736+(h<<2)|0;j=6736+(h+2<<2)|0;h=c[j>>2]|0;k=h+8|0;l=c[k>>2]|0;do{if((i|0)==(l|0)){c[1674]=e&~(1<<g)}else{if(l>>>0<(c[1678]|0)>>>0){bV();return 0}m=l+12|0;if((c[m>>2]|0)==(h|0)){c[m>>2]=i;c[j>>2]=l;break}else{bV();return 0}}}while(0);l=g<<3;c[h+4>>2]=l|3;j=h+(l|4)|0;c[j>>2]=c[j>>2]|1;n=k;return n|0}if(b>>>0<=(c[1676]|0)>>>0){o=b;break}if((f|0)!=0){j=2<<d;l=f<<d&(j|-j);j=(l&-l)-1|0;l=j>>>12&16;i=j>>>(l>>>0);j=i>>>5&8;m=i>>>(j>>>0);i=m>>>2&4;p=m>>>(i>>>0);m=p>>>1&2;q=p>>>(m>>>0);p=q>>>1&1;r=(j|l|i|m|p)+(q>>>(p>>>0))|0;p=r<<1;q=6736+(p<<2)|0;m=6736+(p+2<<2)|0;p=c[m>>2]|0;i=p+8|0;l=c[i>>2]|0;do{if((q|0)==(l|0)){c[1674]=e&~(1<<r)}else{if(l>>>0<(c[1678]|0)>>>0){bV();return 0}j=l+12|0;if((c[j>>2]|0)==(p|0)){c[j>>2]=q;c[m>>2]=l;break}else{bV();return 0}}}while(0);l=r<<3;m=l-b|0;c[p+4>>2]=b|3;q=p;e=q+b|0;c[q+(b|4)>>2]=m|1;c[q+l>>2]=m;l=c[1676]|0;if((l|0)!=0){q=c[1679]|0;d=l>>>3;l=d<<1;f=6736+(l<<2)|0;k=c[1674]|0;h=1<<d;do{if((k&h|0)==0){c[1674]=k|h;s=f;t=6736+(l+2<<2)|0}else{d=6736+(l+2<<2)|0;g=c[d>>2]|0;if(g>>>0>=(c[1678]|0)>>>0){s=g;t=d;break}bV();return 0}}while(0);c[t>>2]=q;c[s+12>>2]=q;c[q+8>>2]=s;c[q+12>>2]=f}c[1676]=m;c[1679]=e;n=i;return n|0}l=c[1675]|0;if((l|0)==0){o=b;break}h=(l&-l)-1|0;l=h>>>12&16;k=h>>>(l>>>0);h=k>>>5&8;p=k>>>(h>>>0);k=p>>>2&4;r=p>>>(k>>>0);p=r>>>1&2;d=r>>>(p>>>0);r=d>>>1&1;g=c[7e3+((h|l|k|p|r)+(d>>>(r>>>0))<<2)>>2]|0;r=g;d=g;p=(c[g+4>>2]&-8)-b|0;while(1){g=c[r+16>>2]|0;if((g|0)==0){k=c[r+20>>2]|0;if((k|0)==0){break}else{u=k}}else{u=g}g=(c[u+4>>2]&-8)-b|0;k=g>>>0<p>>>0;r=u;d=k?u:d;p=k?g:p}r=d;i=c[1678]|0;if(r>>>0<i>>>0){bV();return 0}e=r+b|0;m=e;if(r>>>0>=e>>>0){bV();return 0}e=c[d+24>>2]|0;f=c[d+12>>2]|0;do{if((f|0)==(d|0)){q=d+20|0;g=c[q>>2]|0;if((g|0)==0){k=d+16|0;l=c[k>>2]|0;if((l|0)==0){v=0;break}else{w=l;x=k}}else{w=g;x=q}while(1){q=w+20|0;g=c[q>>2]|0;if((g|0)!=0){w=g;x=q;continue}q=w+16|0;g=c[q>>2]|0;if((g|0)==0){break}else{w=g;x=q}}if(x>>>0<i>>>0){bV();return 0}else{c[x>>2]=0;v=w;break}}else{q=c[d+8>>2]|0;if(q>>>0<i>>>0){bV();return 0}g=q+12|0;if((c[g>>2]|0)!=(d|0)){bV();return 0}k=f+8|0;if((c[k>>2]|0)==(d|0)){c[g>>2]=f;c[k>>2]=q;v=f;break}else{bV();return 0}}}while(0);L3702:do{if((e|0)!=0){f=d+28|0;i=7e3+(c[f>>2]<<2)|0;do{if((d|0)==(c[i>>2]|0)){c[i>>2]=v;if((v|0)!=0){break}c[1675]=c[1675]&~(1<<c[f>>2]);break L3702}else{if(e>>>0<(c[1678]|0)>>>0){bV();return 0}q=e+16|0;if((c[q>>2]|0)==(d|0)){c[q>>2]=v}else{c[e+20>>2]=v}if((v|0)==0){break L3702}}}while(0);if(v>>>0<(c[1678]|0)>>>0){bV();return 0}c[v+24>>2]=e;f=c[d+16>>2]|0;do{if((f|0)!=0){if(f>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[v+16>>2]=f;c[f+24>>2]=v;break}}}while(0);f=c[d+20>>2]|0;if((f|0)==0){break}if(f>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[v+20>>2]=f;c[f+24>>2]=v;break}}}while(0);if(p>>>0<16>>>0){e=p+b|0;c[d+4>>2]=e|3;f=r+(e+4)|0;c[f>>2]=c[f>>2]|1}else{c[d+4>>2]=b|3;c[r+(b|4)>>2]=p|1;c[r+(p+b)>>2]=p;f=c[1676]|0;if((f|0)!=0){e=c[1679]|0;i=f>>>3;f=i<<1;q=6736+(f<<2)|0;k=c[1674]|0;g=1<<i;do{if((k&g|0)==0){c[1674]=k|g;y=q;z=6736+(f+2<<2)|0}else{i=6736+(f+2<<2)|0;l=c[i>>2]|0;if(l>>>0>=(c[1678]|0)>>>0){y=l;z=i;break}bV();return 0}}while(0);c[z>>2]=e;c[y+12>>2]=e;c[e+8>>2]=y;c[e+12>>2]=q}c[1676]=p;c[1679]=m}f=d+8|0;if((f|0)==0){o=b;break}else{n=f}return n|0}else{if(a>>>0>4294967231>>>0){o=-1;break}f=a+11|0;g=f&-8;k=c[1675]|0;if((k|0)==0){o=g;break}r=-g|0;i=f>>>8;do{if((i|0)==0){A=0}else{if(g>>>0>16777215>>>0){A=31;break}f=(i+1048320|0)>>>16&8;l=i<<f;h=(l+520192|0)>>>16&4;j=l<<h;l=(j+245760|0)>>>16&2;B=14-(h|f|l)+(j<<l>>>15)|0;A=g>>>((B+7|0)>>>0)&1|B<<1}}while(0);i=c[7e3+(A<<2)>>2]|0;L3510:do{if((i|0)==0){C=0;D=r;E=0}else{if((A|0)==31){F=0}else{F=25-(A>>>1)|0}d=0;m=r;p=i;q=g<<F;e=0;while(1){B=c[p+4>>2]&-8;l=B-g|0;if(l>>>0<m>>>0){if((B|0)==(g|0)){C=p;D=l;E=p;break L3510}else{G=p;H=l}}else{G=d;H=m}l=c[p+20>>2]|0;B=c[p+16+(q>>>31<<2)>>2]|0;j=(l|0)==0|(l|0)==(B|0)?e:l;if((B|0)==0){C=G;D=H;E=j;break}else{d=G;m=H;p=B;q=q<<1;e=j}}}}while(0);if((E|0)==0&(C|0)==0){i=2<<A;r=k&(i|-i);if((r|0)==0){o=g;break}i=(r&-r)-1|0;r=i>>>12&16;e=i>>>(r>>>0);i=e>>>5&8;q=e>>>(i>>>0);e=q>>>2&4;p=q>>>(e>>>0);q=p>>>1&2;m=p>>>(q>>>0);p=m>>>1&1;I=c[7e3+((i|r|e|q|p)+(m>>>(p>>>0))<<2)>>2]|0}else{I=E}if((I|0)==0){J=D;K=C}else{p=I;m=D;q=C;while(1){e=(c[p+4>>2]&-8)-g|0;r=e>>>0<m>>>0;i=r?e:m;e=r?p:q;r=c[p+16>>2]|0;if((r|0)!=0){p=r;m=i;q=e;continue}r=c[p+20>>2]|0;if((r|0)==0){J=i;K=e;break}else{p=r;m=i;q=e}}}if((K|0)==0){o=g;break}if(J>>>0>=((c[1676]|0)-g|0)>>>0){o=g;break}q=K;m=c[1678]|0;if(q>>>0<m>>>0){bV();return 0}p=q+g|0;k=p;if(q>>>0>=p>>>0){bV();return 0}e=c[K+24>>2]|0;i=c[K+12>>2]|0;do{if((i|0)==(K|0)){r=K+20|0;d=c[r>>2]|0;if((d|0)==0){j=K+16|0;B=c[j>>2]|0;if((B|0)==0){L=0;break}else{M=B;N=j}}else{M=d;N=r}while(1){r=M+20|0;d=c[r>>2]|0;if((d|0)!=0){M=d;N=r;continue}r=M+16|0;d=c[r>>2]|0;if((d|0)==0){break}else{M=d;N=r}}if(N>>>0<m>>>0){bV();return 0}else{c[N>>2]=0;L=M;break}}else{r=c[K+8>>2]|0;if(r>>>0<m>>>0){bV();return 0}d=r+12|0;if((c[d>>2]|0)!=(K|0)){bV();return 0}j=i+8|0;if((c[j>>2]|0)==(K|0)){c[d>>2]=i;c[j>>2]=r;L=i;break}else{bV();return 0}}}while(0);L3560:do{if((e|0)!=0){i=K+28|0;m=7e3+(c[i>>2]<<2)|0;do{if((K|0)==(c[m>>2]|0)){c[m>>2]=L;if((L|0)!=0){break}c[1675]=c[1675]&~(1<<c[i>>2]);break L3560}else{if(e>>>0<(c[1678]|0)>>>0){bV();return 0}r=e+16|0;if((c[r>>2]|0)==(K|0)){c[r>>2]=L}else{c[e+20>>2]=L}if((L|0)==0){break L3560}}}while(0);if(L>>>0<(c[1678]|0)>>>0){bV();return 0}c[L+24>>2]=e;i=c[K+16>>2]|0;do{if((i|0)!=0){if(i>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[L+16>>2]=i;c[i+24>>2]=L;break}}}while(0);i=c[K+20>>2]|0;if((i|0)==0){break}if(i>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[L+20>>2]=i;c[i+24>>2]=L;break}}}while(0);do{if(J>>>0<16>>>0){e=J+g|0;c[K+4>>2]=e|3;i=q+(e+4)|0;c[i>>2]=c[i>>2]|1}else{c[K+4>>2]=g|3;c[q+(g|4)>>2]=J|1;c[q+(J+g)>>2]=J;i=J>>>3;if(J>>>0<256>>>0){e=i<<1;m=6736+(e<<2)|0;r=c[1674]|0;j=1<<i;do{if((r&j|0)==0){c[1674]=r|j;O=m;P=6736+(e+2<<2)|0}else{i=6736+(e+2<<2)|0;d=c[i>>2]|0;if(d>>>0>=(c[1678]|0)>>>0){O=d;P=i;break}bV();return 0}}while(0);c[P>>2]=k;c[O+12>>2]=k;c[q+(g+8)>>2]=O;c[q+(g+12)>>2]=m;break}e=p;j=J>>>8;do{if((j|0)==0){Q=0}else{if(J>>>0>16777215>>>0){Q=31;break}r=(j+1048320|0)>>>16&8;i=j<<r;d=(i+520192|0)>>>16&4;B=i<<d;i=(B+245760|0)>>>16&2;l=14-(d|r|i)+(B<<i>>>15)|0;Q=J>>>((l+7|0)>>>0)&1|l<<1}}while(0);j=7e3+(Q<<2)|0;c[q+(g+28)>>2]=Q;c[q+(g+20)>>2]=0;c[q+(g+16)>>2]=0;m=c[1675]|0;l=1<<Q;if((m&l|0)==0){c[1675]=m|l;c[j>>2]=e;c[q+(g+24)>>2]=j;c[q+(g+12)>>2]=e;c[q+(g+8)>>2]=e;break}if((Q|0)==31){R=0}else{R=25-(Q>>>1)|0}l=J<<R;m=c[j>>2]|0;while(1){if((c[m+4>>2]&-8|0)==(J|0)){break}S=m+16+(l>>>31<<2)|0;j=c[S>>2]|0;if((j|0)==0){T=2790;break}else{l=l<<1;m=j}}if((T|0)==2790){if(S>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[S>>2]=e;c[q+(g+24)>>2]=m;c[q+(g+12)>>2]=e;c[q+(g+8)>>2]=e;break}}l=m+8|0;j=c[l>>2]|0;i=c[1678]|0;if(m>>>0<i>>>0){bV();return 0}if(j>>>0<i>>>0){bV();return 0}else{c[j+12>>2]=e;c[l>>2]=e;c[q+(g+8)>>2]=j;c[q+(g+12)>>2]=m;c[q+(g+24)>>2]=0;break}}}while(0);q=K+8|0;if((q|0)==0){o=g;break}else{n=q}return n|0}}while(0);K=c[1676]|0;if(o>>>0<=K>>>0){S=K-o|0;J=c[1679]|0;if(S>>>0>15>>>0){R=J;c[1679]=R+o;c[1676]=S;c[R+(o+4)>>2]=S|1;c[R+K>>2]=S;c[J+4>>2]=o|3}else{c[1676]=0;c[1679]=0;c[J+4>>2]=K|3;S=J+(K+4)|0;c[S>>2]=c[S>>2]|1}n=J+8|0;return n|0}J=c[1677]|0;if(o>>>0<J>>>0){S=J-o|0;c[1677]=S;J=c[1680]|0;K=J;c[1680]=K+o;c[K+(o+4)>>2]=S|1;c[J+4>>2]=o|3;n=J+8|0;return n|0}do{if((c[1666]|0)==0){J=bz(30)|0;if((J-1&J|0)==0){c[1668]=J;c[1667]=J;c[1669]=-1;c[1670]=-1;c[1671]=0;c[1785]=0;c[1666]=(cd(0)|0)&-16^1431655768;break}else{bV();return 0}}}while(0);J=o+48|0;S=c[1668]|0;K=o+47|0;R=S+K|0;Q=-S|0;S=R&Q;if(S>>>0<=o>>>0){n=0;return n|0}O=c[1784]|0;do{if((O|0)!=0){P=c[1782]|0;L=P+S|0;if(L>>>0<=P>>>0|L>>>0>O>>>0){n=0}else{break}return n|0}}while(0);L3769:do{if((c[1785]&4|0)==0){O=c[1680]|0;L3771:do{if((O|0)==0){T=2820}else{L=O;P=7144;while(1){U=P|0;M=c[U>>2]|0;if(M>>>0<=L>>>0){V=P+4|0;if((M+(c[V>>2]|0)|0)>>>0>L>>>0){break}}M=c[P+8>>2]|0;if((M|0)==0){T=2820;break L3771}else{P=M}}if((P|0)==0){T=2820;break}L=R-(c[1677]|0)&Q;if(L>>>0>=2147483647>>>0){W=0;break}m=bN(L|0)|0;e=(m|0)==((c[U>>2]|0)+(c[V>>2]|0)|0);X=e?m:-1;Y=e?L:0;Z=m;_=L;T=2829}}while(0);do{if((T|0)==2820){O=bN(0)|0;if((O|0)==-1){W=0;break}g=O;L=c[1667]|0;m=L-1|0;if((m&g|0)==0){$=S}else{$=S-g+(m+g&-L)|0}L=c[1782]|0;g=L+$|0;if(!($>>>0>o>>>0&$>>>0<2147483647>>>0)){W=0;break}m=c[1784]|0;if((m|0)!=0){if(g>>>0<=L>>>0|g>>>0>m>>>0){W=0;break}}m=bN($|0)|0;g=(m|0)==(O|0);X=g?O:-1;Y=g?$:0;Z=m;_=$;T=2829}}while(0);L3791:do{if((T|0)==2829){m=-_|0;if((X|0)!=-1){aa=Y;ab=X;T=2840;break L3769}do{if((Z|0)!=-1&_>>>0<2147483647>>>0&_>>>0<J>>>0){g=c[1668]|0;O=K-_+g&-g;if(O>>>0>=2147483647>>>0){ac=_;break}if((bN(O|0)|0)==-1){bN(m|0)|0;W=Y;break L3791}else{ac=O+_|0;break}}else{ac=_}}while(0);if((Z|0)==-1){W=Y}else{aa=ac;ab=Z;T=2840;break L3769}}}while(0);c[1785]=c[1785]|4;ad=W;T=2837}else{ad=0;T=2837}}while(0);do{if((T|0)==2837){if(S>>>0>=2147483647>>>0){break}W=bN(S|0)|0;Z=bN(0)|0;if(!((Z|0)!=-1&(W|0)!=-1&W>>>0<Z>>>0)){break}ac=Z-W|0;Z=ac>>>0>(o+40|0)>>>0;Y=Z?W:-1;if((Y|0)!=-1){aa=Z?ac:ad;ab=Y;T=2840}}}while(0);do{if((T|0)==2840){ad=(c[1782]|0)+aa|0;c[1782]=ad;if(ad>>>0>(c[1783]|0)>>>0){c[1783]=ad}ad=c[1680]|0;L3811:do{if((ad|0)==0){S=c[1678]|0;if((S|0)==0|ab>>>0<S>>>0){c[1678]=ab}c[1786]=ab;c[1787]=aa;c[1789]=0;c[1683]=c[1666];c[1682]=-1;S=0;do{Y=S<<1;ac=6736+(Y<<2)|0;c[6736+(Y+3<<2)>>2]=ac;c[6736+(Y+2<<2)>>2]=ac;S=S+1|0;}while(S>>>0<32>>>0);S=ab+8|0;if((S&7|0)==0){ae=0}else{ae=-S&7}S=aa-40-ae|0;c[1680]=ab+ae;c[1677]=S;c[ab+(ae+4)>>2]=S|1;c[ab+(aa-36)>>2]=40;c[1681]=c[1670]}else{S=7144;while(1){af=c[S>>2]|0;ag=S+4|0;ah=c[ag>>2]|0;if((ab|0)==(af+ah|0)){T=2852;break}ac=c[S+8>>2]|0;if((ac|0)==0){break}else{S=ac}}do{if((T|0)==2852){if((c[S+12>>2]&8|0)!=0){break}ac=ad;if(!(ac>>>0>=af>>>0&ac>>>0<ab>>>0)){break}c[ag>>2]=ah+aa;ac=c[1680]|0;Y=(c[1677]|0)+aa|0;Z=ac;W=ac+8|0;if((W&7|0)==0){ai=0}else{ai=-W&7}W=Y-ai|0;c[1680]=Z+ai;c[1677]=W;c[Z+(ai+4)>>2]=W|1;c[Z+(Y+4)>>2]=40;c[1681]=c[1670];break L3811}}while(0);if(ab>>>0<(c[1678]|0)>>>0){c[1678]=ab}S=ab+aa|0;Y=7144;while(1){aj=Y|0;if((c[aj>>2]|0)==(S|0)){T=2862;break}Z=c[Y+8>>2]|0;if((Z|0)==0){break}else{Y=Z}}do{if((T|0)==2862){if((c[Y+12>>2]&8|0)!=0){break}c[aj>>2]=ab;S=Y+4|0;c[S>>2]=(c[S>>2]|0)+aa;S=ab+8|0;if((S&7|0)==0){ak=0}else{ak=-S&7}S=ab+(aa+8)|0;if((S&7|0)==0){al=0}else{al=-S&7}S=ab+(al+aa)|0;Z=S;W=ak+o|0;ac=ab+W|0;_=ac;K=S-(ab+ak)-o|0;c[ab+(ak+4)>>2]=o|3;do{if((Z|0)==(c[1680]|0)){J=(c[1677]|0)+K|0;c[1677]=J;c[1680]=_;c[ab+(W+4)>>2]=J|1}else{if((Z|0)==(c[1679]|0)){J=(c[1676]|0)+K|0;c[1676]=J;c[1679]=_;c[ab+(W+4)>>2]=J|1;c[ab+(J+W)>>2]=J;break}J=aa+4|0;X=c[ab+(J+al)>>2]|0;if((X&3|0)==1){$=X&-8;V=X>>>3;L3856:do{if(X>>>0<256>>>0){U=c[ab+((al|8)+aa)>>2]|0;Q=c[ab+(aa+12+al)>>2]|0;R=6736+(V<<1<<2)|0;do{if((U|0)!=(R|0)){if(U>>>0<(c[1678]|0)>>>0){bV();return 0}if((c[U+12>>2]|0)==(Z|0)){break}bV();return 0}}while(0);if((Q|0)==(U|0)){c[1674]=c[1674]&~(1<<V);break}do{if((Q|0)==(R|0)){am=Q+8|0}else{if(Q>>>0<(c[1678]|0)>>>0){bV();return 0}m=Q+8|0;if((c[m>>2]|0)==(Z|0)){am=m;break}bV();return 0}}while(0);c[U+12>>2]=Q;c[am>>2]=U}else{R=S;m=c[ab+((al|24)+aa)>>2]|0;P=c[ab+(aa+12+al)>>2]|0;do{if((P|0)==(R|0)){O=al|16;g=ab+(J+O)|0;L=c[g>>2]|0;if((L|0)==0){e=ab+(O+aa)|0;O=c[e>>2]|0;if((O|0)==0){an=0;break}else{ao=O;ap=e}}else{ao=L;ap=g}while(1){g=ao+20|0;L=c[g>>2]|0;if((L|0)!=0){ao=L;ap=g;continue}g=ao+16|0;L=c[g>>2]|0;if((L|0)==0){break}else{ao=L;ap=g}}if(ap>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[ap>>2]=0;an=ao;break}}else{g=c[ab+((al|8)+aa)>>2]|0;if(g>>>0<(c[1678]|0)>>>0){bV();return 0}L=g+12|0;if((c[L>>2]|0)!=(R|0)){bV();return 0}e=P+8|0;if((c[e>>2]|0)==(R|0)){c[L>>2]=P;c[e>>2]=g;an=P;break}else{bV();return 0}}}while(0);if((m|0)==0){break}P=ab+(aa+28+al)|0;U=7e3+(c[P>>2]<<2)|0;do{if((R|0)==(c[U>>2]|0)){c[U>>2]=an;if((an|0)!=0){break}c[1675]=c[1675]&~(1<<c[P>>2]);break L3856}else{if(m>>>0<(c[1678]|0)>>>0){bV();return 0}Q=m+16|0;if((c[Q>>2]|0)==(R|0)){c[Q>>2]=an}else{c[m+20>>2]=an}if((an|0)==0){break L3856}}}while(0);if(an>>>0<(c[1678]|0)>>>0){bV();return 0}c[an+24>>2]=m;R=al|16;P=c[ab+(R+aa)>>2]|0;do{if((P|0)!=0){if(P>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[an+16>>2]=P;c[P+24>>2]=an;break}}}while(0);P=c[ab+(J+R)>>2]|0;if((P|0)==0){break}if(P>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[an+20>>2]=P;c[P+24>>2]=an;break}}}while(0);aq=ab+(($|al)+aa)|0;ar=$+K|0}else{aq=Z;ar=K}J=aq+4|0;c[J>>2]=c[J>>2]&-2;c[ab+(W+4)>>2]=ar|1;c[ab+(ar+W)>>2]=ar;J=ar>>>3;if(ar>>>0<256>>>0){V=J<<1;X=6736+(V<<2)|0;P=c[1674]|0;m=1<<J;do{if((P&m|0)==0){c[1674]=P|m;as=X;at=6736+(V+2<<2)|0}else{J=6736+(V+2<<2)|0;U=c[J>>2]|0;if(U>>>0>=(c[1678]|0)>>>0){as=U;at=J;break}bV();return 0}}while(0);c[at>>2]=_;c[as+12>>2]=_;c[ab+(W+8)>>2]=as;c[ab+(W+12)>>2]=X;break}V=ac;m=ar>>>8;do{if((m|0)==0){au=0}else{if(ar>>>0>16777215>>>0){au=31;break}P=(m+1048320|0)>>>16&8;$=m<<P;J=($+520192|0)>>>16&4;U=$<<J;$=(U+245760|0)>>>16&2;Q=14-(J|P|$)+(U<<$>>>15)|0;au=ar>>>((Q+7|0)>>>0)&1|Q<<1}}while(0);m=7e3+(au<<2)|0;c[ab+(W+28)>>2]=au;c[ab+(W+20)>>2]=0;c[ab+(W+16)>>2]=0;X=c[1675]|0;Q=1<<au;if((X&Q|0)==0){c[1675]=X|Q;c[m>>2]=V;c[ab+(W+24)>>2]=m;c[ab+(W+12)>>2]=V;c[ab+(W+8)>>2]=V;break}if((au|0)==31){av=0}else{av=25-(au>>>1)|0}Q=ar<<av;X=c[m>>2]|0;while(1){if((c[X+4>>2]&-8|0)==(ar|0)){break}aw=X+16+(Q>>>31<<2)|0;m=c[aw>>2]|0;if((m|0)==0){T=2935;break}else{Q=Q<<1;X=m}}if((T|0)==2935){if(aw>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[aw>>2]=V;c[ab+(W+24)>>2]=X;c[ab+(W+12)>>2]=V;c[ab+(W+8)>>2]=V;break}}Q=X+8|0;m=c[Q>>2]|0;$=c[1678]|0;if(X>>>0<$>>>0){bV();return 0}if(m>>>0<$>>>0){bV();return 0}else{c[m+12>>2]=V;c[Q>>2]=V;c[ab+(W+8)>>2]=m;c[ab+(W+12)>>2]=X;c[ab+(W+24)>>2]=0;break}}}while(0);n=ab+(ak|8)|0;return n|0}}while(0);Y=ad;W=7144;while(1){ax=c[W>>2]|0;if(ax>>>0<=Y>>>0){ay=c[W+4>>2]|0;az=ax+ay|0;if(az>>>0>Y>>>0){break}}W=c[W+8>>2]|0}W=ax+(ay-39)|0;if((W&7|0)==0){aA=0}else{aA=-W&7}W=ax+(ay-47+aA)|0;ac=W>>>0<(ad+16|0)>>>0?Y:W;W=ac+8|0;_=ab+8|0;if((_&7|0)==0){aB=0}else{aB=-_&7}_=aa-40-aB|0;c[1680]=ab+aB;c[1677]=_;c[ab+(aB+4)>>2]=_|1;c[ab+(aa-36)>>2]=40;c[1681]=c[1670];c[ac+4>>2]=27;c[W>>2]=c[1786];c[W+4>>2]=c[1787];c[W+8>>2]=c[1788];c[W+12>>2]=c[1789];c[1786]=ab;c[1787]=aa;c[1789]=0;c[1788]=W;W=ac+28|0;c[W>>2]=7;if((ac+32|0)>>>0<az>>>0){_=W;while(1){W=_+4|0;c[W>>2]=7;if((_+8|0)>>>0<az>>>0){_=W}else{break}}}if((ac|0)==(Y|0)){break}_=ac-ad|0;W=Y+(_+4)|0;c[W>>2]=c[W>>2]&-2;c[ad+4>>2]=_|1;c[Y+_>>2]=_;W=_>>>3;if(_>>>0<256>>>0){K=W<<1;Z=6736+(K<<2)|0;S=c[1674]|0;m=1<<W;do{if((S&m|0)==0){c[1674]=S|m;aC=Z;aD=6736+(K+2<<2)|0}else{W=6736+(K+2<<2)|0;Q=c[W>>2]|0;if(Q>>>0>=(c[1678]|0)>>>0){aC=Q;aD=W;break}bV();return 0}}while(0);c[aD>>2]=ad;c[aC+12>>2]=ad;c[ad+8>>2]=aC;c[ad+12>>2]=Z;break}K=ad;m=_>>>8;do{if((m|0)==0){aE=0}else{if(_>>>0>16777215>>>0){aE=31;break}S=(m+1048320|0)>>>16&8;Y=m<<S;ac=(Y+520192|0)>>>16&4;W=Y<<ac;Y=(W+245760|0)>>>16&2;Q=14-(ac|S|Y)+(W<<Y>>>15)|0;aE=_>>>((Q+7|0)>>>0)&1|Q<<1}}while(0);m=7e3+(aE<<2)|0;c[ad+28>>2]=aE;c[ad+20>>2]=0;c[ad+16>>2]=0;Z=c[1675]|0;Q=1<<aE;if((Z&Q|0)==0){c[1675]=Z|Q;c[m>>2]=K;c[ad+24>>2]=m;c[ad+12>>2]=ad;c[ad+8>>2]=ad;break}if((aE|0)==31){aF=0}else{aF=25-(aE>>>1)|0}Q=_<<aF;Z=c[m>>2]|0;while(1){if((c[Z+4>>2]&-8|0)==(_|0)){break}aG=Z+16+(Q>>>31<<2)|0;m=c[aG>>2]|0;if((m|0)==0){T=2970;break}else{Q=Q<<1;Z=m}}if((T|0)==2970){if(aG>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[aG>>2]=K;c[ad+24>>2]=Z;c[ad+12>>2]=ad;c[ad+8>>2]=ad;break}}Q=Z+8|0;_=c[Q>>2]|0;m=c[1678]|0;if(Z>>>0<m>>>0){bV();return 0}if(_>>>0<m>>>0){bV();return 0}else{c[_+12>>2]=K;c[Q>>2]=K;c[ad+8>>2]=_;c[ad+12>>2]=Z;c[ad+24>>2]=0;break}}}while(0);ad=c[1677]|0;if(ad>>>0<=o>>>0){break}_=ad-o|0;c[1677]=_;ad=c[1680]|0;Q=ad;c[1680]=Q+o;c[Q+(o+4)>>2]=_|1;c[ad+4>>2]=o|3;n=ad+8|0;return n|0}}while(0);c[(bO()|0)>>2]=12;n=0;return n|0}function ft(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;if((a|0)==0){return}b=a-8|0;d=b;e=c[1678]|0;if(b>>>0<e>>>0){bV()}f=c[a-4>>2]|0;g=f&3;if((g|0)==1){bV()}h=f&-8;i=a+(h-8)|0;j=i;L4028:do{if((f&1|0)==0){k=c[b>>2]|0;if((g|0)==0){return}l=-8-k|0;m=a+l|0;n=m;o=k+h|0;if(m>>>0<e>>>0){bV()}if((n|0)==(c[1679]|0)){p=a+(h-4)|0;if((c[p>>2]&3|0)!=3){q=n;r=o;break}c[1676]=o;c[p>>2]=c[p>>2]&-2;c[a+(l+4)>>2]=o|1;c[i>>2]=o;return}p=k>>>3;if(k>>>0<256>>>0){k=c[a+(l+8)>>2]|0;s=c[a+(l+12)>>2]|0;t=6736+(p<<1<<2)|0;do{if((k|0)!=(t|0)){if(k>>>0<e>>>0){bV()}if((c[k+12>>2]|0)==(n|0)){break}bV()}}while(0);if((s|0)==(k|0)){c[1674]=c[1674]&~(1<<p);q=n;r=o;break}do{if((s|0)==(t|0)){u=s+8|0}else{if(s>>>0<e>>>0){bV()}v=s+8|0;if((c[v>>2]|0)==(n|0)){u=v;break}bV()}}while(0);c[k+12>>2]=s;c[u>>2]=k;q=n;r=o;break}t=m;p=c[a+(l+24)>>2]|0;v=c[a+(l+12)>>2]|0;do{if((v|0)==(t|0)){w=a+(l+20)|0;x=c[w>>2]|0;if((x|0)==0){y=a+(l+16)|0;z=c[y>>2]|0;if((z|0)==0){A=0;break}else{B=z;C=y}}else{B=x;C=w}while(1){w=B+20|0;x=c[w>>2]|0;if((x|0)!=0){B=x;C=w;continue}w=B+16|0;x=c[w>>2]|0;if((x|0)==0){break}else{B=x;C=w}}if(C>>>0<e>>>0){bV()}else{c[C>>2]=0;A=B;break}}else{w=c[a+(l+8)>>2]|0;if(w>>>0<e>>>0){bV()}x=w+12|0;if((c[x>>2]|0)!=(t|0)){bV()}y=v+8|0;if((c[y>>2]|0)==(t|0)){c[x>>2]=v;c[y>>2]=w;A=v;break}else{bV()}}}while(0);if((p|0)==0){q=n;r=o;break}v=a+(l+28)|0;m=7e3+(c[v>>2]<<2)|0;do{if((t|0)==(c[m>>2]|0)){c[m>>2]=A;if((A|0)!=0){break}c[1675]=c[1675]&~(1<<c[v>>2]);q=n;r=o;break L4028}else{if(p>>>0<(c[1678]|0)>>>0){bV()}k=p+16|0;if((c[k>>2]|0)==(t|0)){c[k>>2]=A}else{c[p+20>>2]=A}if((A|0)==0){q=n;r=o;break L4028}}}while(0);if(A>>>0<(c[1678]|0)>>>0){bV()}c[A+24>>2]=p;t=c[a+(l+16)>>2]|0;do{if((t|0)!=0){if(t>>>0<(c[1678]|0)>>>0){bV()}else{c[A+16>>2]=t;c[t+24>>2]=A;break}}}while(0);t=c[a+(l+20)>>2]|0;if((t|0)==0){q=n;r=o;break}if(t>>>0<(c[1678]|0)>>>0){bV()}else{c[A+20>>2]=t;c[t+24>>2]=A;q=n;r=o;break}}else{q=d;r=h}}while(0);d=q;if(d>>>0>=i>>>0){bV()}A=a+(h-4)|0;e=c[A>>2]|0;if((e&1|0)==0){bV()}do{if((e&2|0)==0){if((j|0)==(c[1680]|0)){B=(c[1677]|0)+r|0;c[1677]=B;c[1680]=q;c[q+4>>2]=B|1;if((q|0)!=(c[1679]|0)){return}c[1679]=0;c[1676]=0;return}if((j|0)==(c[1679]|0)){B=(c[1676]|0)+r|0;c[1676]=B;c[1679]=q;c[q+4>>2]=B|1;c[d+B>>2]=B;return}B=(e&-8)+r|0;C=e>>>3;L4130:do{if(e>>>0<256>>>0){u=c[a+h>>2]|0;g=c[a+(h|4)>>2]|0;b=6736+(C<<1<<2)|0;do{if((u|0)!=(b|0)){if(u>>>0<(c[1678]|0)>>>0){bV()}if((c[u+12>>2]|0)==(j|0)){break}bV()}}while(0);if((g|0)==(u|0)){c[1674]=c[1674]&~(1<<C);break}do{if((g|0)==(b|0)){D=g+8|0}else{if(g>>>0<(c[1678]|0)>>>0){bV()}f=g+8|0;if((c[f>>2]|0)==(j|0)){D=f;break}bV()}}while(0);c[u+12>>2]=g;c[D>>2]=u}else{b=i;f=c[a+(h+16)>>2]|0;t=c[a+(h|4)>>2]|0;do{if((t|0)==(b|0)){p=a+(h+12)|0;v=c[p>>2]|0;if((v|0)==0){m=a+(h+8)|0;k=c[m>>2]|0;if((k|0)==0){E=0;break}else{F=k;G=m}}else{F=v;G=p}while(1){p=F+20|0;v=c[p>>2]|0;if((v|0)!=0){F=v;G=p;continue}p=F+16|0;v=c[p>>2]|0;if((v|0)==0){break}else{F=v;G=p}}if(G>>>0<(c[1678]|0)>>>0){bV()}else{c[G>>2]=0;E=F;break}}else{p=c[a+h>>2]|0;if(p>>>0<(c[1678]|0)>>>0){bV()}v=p+12|0;if((c[v>>2]|0)!=(b|0)){bV()}m=t+8|0;if((c[m>>2]|0)==(b|0)){c[v>>2]=t;c[m>>2]=p;E=t;break}else{bV()}}}while(0);if((f|0)==0){break}t=a+(h+20)|0;u=7e3+(c[t>>2]<<2)|0;do{if((b|0)==(c[u>>2]|0)){c[u>>2]=E;if((E|0)!=0){break}c[1675]=c[1675]&~(1<<c[t>>2]);break L4130}else{if(f>>>0<(c[1678]|0)>>>0){bV()}g=f+16|0;if((c[g>>2]|0)==(b|0)){c[g>>2]=E}else{c[f+20>>2]=E}if((E|0)==0){break L4130}}}while(0);if(E>>>0<(c[1678]|0)>>>0){bV()}c[E+24>>2]=f;b=c[a+(h+8)>>2]|0;do{if((b|0)!=0){if(b>>>0<(c[1678]|0)>>>0){bV()}else{c[E+16>>2]=b;c[b+24>>2]=E;break}}}while(0);b=c[a+(h+12)>>2]|0;if((b|0)==0){break}if(b>>>0<(c[1678]|0)>>>0){bV()}else{c[E+20>>2]=b;c[b+24>>2]=E;break}}}while(0);c[q+4>>2]=B|1;c[d+B>>2]=B;if((q|0)!=(c[1679]|0)){H=B;break}c[1676]=B;return}else{c[A>>2]=e&-2;c[q+4>>2]=r|1;c[d+r>>2]=r;H=r}}while(0);r=H>>>3;if(H>>>0<256>>>0){d=r<<1;e=6736+(d<<2)|0;A=c[1674]|0;E=1<<r;do{if((A&E|0)==0){c[1674]=A|E;I=e;J=6736+(d+2<<2)|0}else{r=6736+(d+2<<2)|0;h=c[r>>2]|0;if(h>>>0>=(c[1678]|0)>>>0){I=h;J=r;break}bV()}}while(0);c[J>>2]=q;c[I+12>>2]=q;c[q+8>>2]=I;c[q+12>>2]=e;return}e=q;I=H>>>8;do{if((I|0)==0){K=0}else{if(H>>>0>16777215>>>0){K=31;break}J=(I+1048320|0)>>>16&8;d=I<<J;E=(d+520192|0)>>>16&4;A=d<<E;d=(A+245760|0)>>>16&2;r=14-(E|J|d)+(A<<d>>>15)|0;K=H>>>((r+7|0)>>>0)&1|r<<1}}while(0);I=7e3+(K<<2)|0;c[q+28>>2]=K;c[q+20>>2]=0;c[q+16>>2]=0;r=c[1675]|0;d=1<<K;do{if((r&d|0)==0){c[1675]=r|d;c[I>>2]=e;c[q+24>>2]=I;c[q+12>>2]=q;c[q+8>>2]=q}else{if((K|0)==31){L=0}else{L=25-(K>>>1)|0}A=H<<L;J=c[I>>2]|0;while(1){if((c[J+4>>2]&-8|0)==(H|0)){break}M=J+16+(A>>>31<<2)|0;E=c[M>>2]|0;if((E|0)==0){N=3147;break}else{A=A<<1;J=E}}if((N|0)==3147){if(M>>>0<(c[1678]|0)>>>0){bV()}else{c[M>>2]=e;c[q+24>>2]=J;c[q+12>>2]=q;c[q+8>>2]=q;break}}A=J+8|0;B=c[A>>2]|0;E=c[1678]|0;if(J>>>0<E>>>0){bV()}if(B>>>0<E>>>0){bV()}else{c[B+12>>2]=e;c[A>>2]=e;c[q+8>>2]=B;c[q+12>>2]=J;c[q+24>>2]=0;break}}}while(0);q=(c[1682]|0)-1|0;c[1682]=q;if((q|0)==0){O=7152}else{return}while(1){q=c[O>>2]|0;if((q|0)==0){break}else{O=q+8|0}}c[1682]=-1;return}function fu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;if((a|0)==0){d=fs(b)|0;return d|0}if(b>>>0>4294967231>>>0){c[(bO()|0)>>2]=12;d=0;return d|0}if(b>>>0<11>>>0){e=16}else{e=b+11&-8}f=fv(a-8|0,e)|0;if((f|0)!=0){d=f+8|0;return d|0}f=fs(b)|0;if((f|0)==0){d=0;return d|0}e=c[a-4>>2]|0;g=(e&-8)-((e&3|0)==0?8:4)|0;e=g>>>0<b>>>0?g:b;fG(f|0,a|0,e)|0;ft(a);d=f;return d|0}function fv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;d=a+4|0;e=c[d>>2]|0;f=e&-8;g=a;h=g+f|0;i=h;j=c[1678]|0;if(g>>>0<j>>>0){bV();return 0}k=e&3;if(!((k|0)!=1&g>>>0<h>>>0)){bV();return 0}l=g+(f|4)|0;m=c[l>>2]|0;if((m&1|0)==0){bV();return 0}if((k|0)==0){if(b>>>0<256>>>0){n=0;return n|0}do{if(f>>>0>=(b+4|0)>>>0){if((f-b|0)>>>0>c[1668]<<1>>>0){break}else{n=a}return n|0}}while(0);n=0;return n|0}if(f>>>0>=b>>>0){k=f-b|0;if(k>>>0<=15>>>0){n=a;return n|0}c[d>>2]=e&1|b|2;c[g+(b+4)>>2]=k|3;c[l>>2]=c[l>>2]|1;fw(g+b|0,k);n=a;return n|0}if((i|0)==(c[1680]|0)){k=(c[1677]|0)+f|0;if(k>>>0<=b>>>0){n=0;return n|0}l=k-b|0;c[d>>2]=e&1|b|2;c[g+(b+4)>>2]=l|1;c[1680]=g+b;c[1677]=l;n=a;return n|0}if((i|0)==(c[1679]|0)){l=(c[1676]|0)+f|0;if(l>>>0<b>>>0){n=0;return n|0}k=l-b|0;if(k>>>0>15>>>0){c[d>>2]=e&1|b|2;c[g+(b+4)>>2]=k|1;c[g+l>>2]=k;o=g+(l+4)|0;c[o>>2]=c[o>>2]&-2;p=g+b|0;q=k}else{c[d>>2]=e&1|l|2;e=g+(l+4)|0;c[e>>2]=c[e>>2]|1;p=0;q=0}c[1676]=q;c[1679]=p;n=a;return n|0}if((m&2|0)!=0){n=0;return n|0}p=(m&-8)+f|0;if(p>>>0<b>>>0){n=0;return n|0}q=p-b|0;e=m>>>3;L4317:do{if(m>>>0<256>>>0){l=c[g+(f+8)>>2]|0;k=c[g+(f+12)>>2]|0;o=6736+(e<<1<<2)|0;do{if((l|0)!=(o|0)){if(l>>>0<j>>>0){bV();return 0}if((c[l+12>>2]|0)==(i|0)){break}bV();return 0}}while(0);if((k|0)==(l|0)){c[1674]=c[1674]&~(1<<e);break}do{if((k|0)==(o|0)){r=k+8|0}else{if(k>>>0<j>>>0){bV();return 0}s=k+8|0;if((c[s>>2]|0)==(i|0)){r=s;break}bV();return 0}}while(0);c[l+12>>2]=k;c[r>>2]=l}else{o=h;s=c[g+(f+24)>>2]|0;t=c[g+(f+12)>>2]|0;do{if((t|0)==(o|0)){u=g+(f+20)|0;v=c[u>>2]|0;if((v|0)==0){w=g+(f+16)|0;x=c[w>>2]|0;if((x|0)==0){y=0;break}else{z=x;A=w}}else{z=v;A=u}while(1){u=z+20|0;v=c[u>>2]|0;if((v|0)!=0){z=v;A=u;continue}u=z+16|0;v=c[u>>2]|0;if((v|0)==0){break}else{z=v;A=u}}if(A>>>0<j>>>0){bV();return 0}else{c[A>>2]=0;y=z;break}}else{u=c[g+(f+8)>>2]|0;if(u>>>0<j>>>0){bV();return 0}v=u+12|0;if((c[v>>2]|0)!=(o|0)){bV();return 0}w=t+8|0;if((c[w>>2]|0)==(o|0)){c[v>>2]=t;c[w>>2]=u;y=t;break}else{bV();return 0}}}while(0);if((s|0)==0){break}t=g+(f+28)|0;l=7e3+(c[t>>2]<<2)|0;do{if((o|0)==(c[l>>2]|0)){c[l>>2]=y;if((y|0)!=0){break}c[1675]=c[1675]&~(1<<c[t>>2]);break L4317}else{if(s>>>0<(c[1678]|0)>>>0){bV();return 0}k=s+16|0;if((c[k>>2]|0)==(o|0)){c[k>>2]=y}else{c[s+20>>2]=y}if((y|0)==0){break L4317}}}while(0);if(y>>>0<(c[1678]|0)>>>0){bV();return 0}c[y+24>>2]=s;o=c[g+(f+16)>>2]|0;do{if((o|0)!=0){if(o>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[y+16>>2]=o;c[o+24>>2]=y;break}}}while(0);o=c[g+(f+20)>>2]|0;if((o|0)==0){break}if(o>>>0<(c[1678]|0)>>>0){bV();return 0}else{c[y+20>>2]=o;c[o+24>>2]=y;break}}}while(0);if(q>>>0<16>>>0){c[d>>2]=p|c[d>>2]&1|2;y=g+(p|4)|0;c[y>>2]=c[y>>2]|1;n=a;return n|0}else{c[d>>2]=c[d>>2]&1|b|2;c[g+(b+4)>>2]=q|3;d=g+(p|4)|0;c[d>>2]=c[d>>2]|1;fw(g+b|0,q);n=a;return n|0}return 0}function fw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;d=a;e=d+b|0;f=e;g=c[a+4>>2]|0;L4393:do{if((g&1|0)==0){h=c[a>>2]|0;if((g&3|0)==0){return}i=d+(-h|0)|0;j=i;k=h+b|0;l=c[1678]|0;if(i>>>0<l>>>0){bV()}if((j|0)==(c[1679]|0)){m=d+(b+4)|0;if((c[m>>2]&3|0)!=3){n=j;o=k;break}c[1676]=k;c[m>>2]=c[m>>2]&-2;c[d+(4-h)>>2]=k|1;c[e>>2]=k;return}m=h>>>3;if(h>>>0<256>>>0){p=c[d+(8-h)>>2]|0;q=c[d+(12-h)>>2]|0;r=6736+(m<<1<<2)|0;do{if((p|0)!=(r|0)){if(p>>>0<l>>>0){bV()}if((c[p+12>>2]|0)==(j|0)){break}bV()}}while(0);if((q|0)==(p|0)){c[1674]=c[1674]&~(1<<m);n=j;o=k;break}do{if((q|0)==(r|0)){s=q+8|0}else{if(q>>>0<l>>>0){bV()}t=q+8|0;if((c[t>>2]|0)==(j|0)){s=t;break}bV()}}while(0);c[p+12>>2]=q;c[s>>2]=p;n=j;o=k;break}r=i;m=c[d+(24-h)>>2]|0;t=c[d+(12-h)>>2]|0;do{if((t|0)==(r|0)){u=16-h|0;v=d+(u+4)|0;w=c[v>>2]|0;if((w|0)==0){x=d+u|0;u=c[x>>2]|0;if((u|0)==0){y=0;break}else{z=u;A=x}}else{z=w;A=v}while(1){v=z+20|0;w=c[v>>2]|0;if((w|0)!=0){z=w;A=v;continue}v=z+16|0;w=c[v>>2]|0;if((w|0)==0){break}else{z=w;A=v}}if(A>>>0<l>>>0){bV()}else{c[A>>2]=0;y=z;break}}else{v=c[d+(8-h)>>2]|0;if(v>>>0<l>>>0){bV()}w=v+12|0;if((c[w>>2]|0)!=(r|0)){bV()}x=t+8|0;if((c[x>>2]|0)==(r|0)){c[w>>2]=t;c[x>>2]=v;y=t;break}else{bV()}}}while(0);if((m|0)==0){n=j;o=k;break}t=d+(28-h)|0;l=7e3+(c[t>>2]<<2)|0;do{if((r|0)==(c[l>>2]|0)){c[l>>2]=y;if((y|0)!=0){break}c[1675]=c[1675]&~(1<<c[t>>2]);n=j;o=k;break L4393}else{if(m>>>0<(c[1678]|0)>>>0){bV()}i=m+16|0;if((c[i>>2]|0)==(r|0)){c[i>>2]=y}else{c[m+20>>2]=y}if((y|0)==0){n=j;o=k;break L4393}}}while(0);if(y>>>0<(c[1678]|0)>>>0){bV()}c[y+24>>2]=m;r=16-h|0;t=c[d+r>>2]|0;do{if((t|0)!=0){if(t>>>0<(c[1678]|0)>>>0){bV()}else{c[y+16>>2]=t;c[t+24>>2]=y;break}}}while(0);t=c[d+(r+4)>>2]|0;if((t|0)==0){n=j;o=k;break}if(t>>>0<(c[1678]|0)>>>0){bV()}else{c[y+20>>2]=t;c[t+24>>2]=y;n=j;o=k;break}}else{n=a;o=b}}while(0);a=c[1678]|0;if(e>>>0<a>>>0){bV()}y=d+(b+4)|0;z=c[y>>2]|0;do{if((z&2|0)==0){if((f|0)==(c[1680]|0)){A=(c[1677]|0)+o|0;c[1677]=A;c[1680]=n;c[n+4>>2]=A|1;if((n|0)!=(c[1679]|0)){return}c[1679]=0;c[1676]=0;return}if((f|0)==(c[1679]|0)){A=(c[1676]|0)+o|0;c[1676]=A;c[1679]=n;c[n+4>>2]=A|1;c[n+A>>2]=A;return}A=(z&-8)+o|0;s=z>>>3;L4493:do{if(z>>>0<256>>>0){g=c[d+(b+8)>>2]|0;t=c[d+(b+12)>>2]|0;h=6736+(s<<1<<2)|0;do{if((g|0)!=(h|0)){if(g>>>0<a>>>0){bV()}if((c[g+12>>2]|0)==(f|0)){break}bV()}}while(0);if((t|0)==(g|0)){c[1674]=c[1674]&~(1<<s);break}do{if((t|0)==(h|0)){B=t+8|0}else{if(t>>>0<a>>>0){bV()}m=t+8|0;if((c[m>>2]|0)==(f|0)){B=m;break}bV()}}while(0);c[g+12>>2]=t;c[B>>2]=g}else{h=e;m=c[d+(b+24)>>2]|0;l=c[d+(b+12)>>2]|0;do{if((l|0)==(h|0)){i=d+(b+20)|0;p=c[i>>2]|0;if((p|0)==0){q=d+(b+16)|0;v=c[q>>2]|0;if((v|0)==0){C=0;break}else{D=v;E=q}}else{D=p;E=i}while(1){i=D+20|0;p=c[i>>2]|0;if((p|0)!=0){D=p;E=i;continue}i=D+16|0;p=c[i>>2]|0;if((p|0)==0){break}else{D=p;E=i}}if(E>>>0<a>>>0){bV()}else{c[E>>2]=0;C=D;break}}else{i=c[d+(b+8)>>2]|0;if(i>>>0<a>>>0){bV()}p=i+12|0;if((c[p>>2]|0)!=(h|0)){bV()}q=l+8|0;if((c[q>>2]|0)==(h|0)){c[p>>2]=l;c[q>>2]=i;C=l;break}else{bV()}}}while(0);if((m|0)==0){break}l=d+(b+28)|0;g=7e3+(c[l>>2]<<2)|0;do{if((h|0)==(c[g>>2]|0)){c[g>>2]=C;if((C|0)!=0){break}c[1675]=c[1675]&~(1<<c[l>>2]);break L4493}else{if(m>>>0<(c[1678]|0)>>>0){bV()}t=m+16|0;if((c[t>>2]|0)==(h|0)){c[t>>2]=C}else{c[m+20>>2]=C}if((C|0)==0){break L4493}}}while(0);if(C>>>0<(c[1678]|0)>>>0){bV()}c[C+24>>2]=m;h=c[d+(b+16)>>2]|0;do{if((h|0)!=0){if(h>>>0<(c[1678]|0)>>>0){bV()}else{c[C+16>>2]=h;c[h+24>>2]=C;break}}}while(0);h=c[d+(b+20)>>2]|0;if((h|0)==0){break}if(h>>>0<(c[1678]|0)>>>0){bV()}else{c[C+20>>2]=h;c[h+24>>2]=C;break}}}while(0);c[n+4>>2]=A|1;c[n+A>>2]=A;if((n|0)!=(c[1679]|0)){F=A;break}c[1676]=A;return}else{c[y>>2]=z&-2;c[n+4>>2]=o|1;c[n+o>>2]=o;F=o}}while(0);o=F>>>3;if(F>>>0<256>>>0){z=o<<1;y=6736+(z<<2)|0;C=c[1674]|0;b=1<<o;do{if((C&b|0)==0){c[1674]=C|b;G=y;H=6736+(z+2<<2)|0}else{o=6736+(z+2<<2)|0;d=c[o>>2]|0;if(d>>>0>=(c[1678]|0)>>>0){G=d;H=o;break}bV()}}while(0);c[H>>2]=n;c[G+12>>2]=n;c[n+8>>2]=G;c[n+12>>2]=y;return}y=n;G=F>>>8;do{if((G|0)==0){I=0}else{if(F>>>0>16777215>>>0){I=31;break}H=(G+1048320|0)>>>16&8;z=G<<H;b=(z+520192|0)>>>16&4;C=z<<b;z=(C+245760|0)>>>16&2;o=14-(b|H|z)+(C<<z>>>15)|0;I=F>>>((o+7|0)>>>0)&1|o<<1}}while(0);G=7e3+(I<<2)|0;c[n+28>>2]=I;c[n+20>>2]=0;c[n+16>>2]=0;o=c[1675]|0;z=1<<I;if((o&z|0)==0){c[1675]=o|z;c[G>>2]=y;c[n+24>>2]=G;c[n+12>>2]=n;c[n+8>>2]=n;return}if((I|0)==31){J=0}else{J=25-(I>>>1)|0}I=F<<J;J=c[G>>2]|0;while(1){if((c[J+4>>2]&-8|0)==(F|0)){break}K=J+16+(I>>>31<<2)|0;G=c[K>>2]|0;if((G|0)==0){L=3427;break}else{I=I<<1;J=G}}if((L|0)==3427){if(K>>>0<(c[1678]|0)>>>0){bV()}c[K>>2]=y;c[n+24>>2]=J;c[n+12>>2]=n;c[n+8>>2]=n;return}K=J+8|0;L=c[K>>2]|0;I=c[1678]|0;if(J>>>0<I>>>0){bV()}if(L>>>0<I>>>0){bV()}c[L+12>>2]=y;c[K>>2]=y;c[n+8>>2]=L;c[n+12>>2]=J;c[n+24>>2]=0;return}function fx(a){a=a|0;var b=0,d=0,e=0;b=(a|0)==0?1:a;while(1){d=fs(b)|0;if((d|0)!=0){e=3471;break}a=(B=c[2906]|0,c[2906]=B+0,B);if((a|0)==0){break}cn[a&7]()}if((e|0)==3471){return d|0}d=b0(4)|0;c[d>>2]=4040;bp(d|0,5480,48);return 0}function fy(a){a=a|0;return fx(a)|0}function fz(a){a=a|0;if((a|0)==0){return}ft(a);return}function fA(a){a=a|0;fz(a);return}function fB(a){a=a|0;fz(a);return}function fC(a){a=a|0;return}function fD(a){a=a|0;return 2048}function fE(b){b=b|0;var c=0;c=b;while(a[c]|0){c=c+1|0}return c-b|0}function fF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=b+e|0;if((e|0)>=20){d=d&255;e=b&3;g=d|d<<8|d<<16|d<<24;h=f&~3;if(e){e=b+4-e|0;while((b|0)<(e|0)){a[b]=d;b=b+1|0}}while((b|0)<(h|0)){c[b>>2]=g;b=b+4|0}}while((b|0)<(f|0)){a[b]=d;b=b+1|0}}function fG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;f=b|0;if((b&3)==(d&3)){while(b&3){if((e|0)==0)return f|0;a[b]=a[d]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b]=a[d]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function fH(){b5()}function fI(a,b){a=a|0;b=b|0;return cf[a&15](b|0)|0}function fJ(a,b,c){a=a|0;b=b|0;c=+c;cg[a&3](b|0,+c)}function fK(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ch[a&7](b|0,c|0,d|0,e|0,f|0)}function fL(a,b){a=a|0;b=b|0;ci[a&127](b|0)}function fM(a,b,c){a=a|0;b=b|0;c=c|0;cj[a&63](b|0,c|0)}function fN(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return ck[a&3](b|0,c|0,d|0,e|0)|0}function fO(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return cl[a&3](b|0,c|0,d|0)|0}function fP(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;cm[a&15](b|0,c|0,d|0)}function fQ(a){a=a|0;cn[a&7]()}function fR(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;i=+i;co[a&3](b|0,c|0,d|0,e|0,f|0,g|0,+h,+i)}function fS(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;cp[a&3](b|0,c|0,d|0,e|0,f|0,g|0,+h)}function fT(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;cq[a&15](b|0,c|0,d|0,e|0,f|0,g|0)}function fU(a,b,c){a=a|0;b=b|0;c=c|0;return cr[a&15](b|0,c|0)|0}function fV(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return cs[a&15](b|0,c|0,d|0,e|0,f|0)|0}function fW(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ct[a&15](b|0,c|0,d|0,e|0)}function fX(a){a=a|0;aa(0);return 0}function fY(a,b){a=a|0;b=+b;aa(1)}function fZ(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;aa(2)}function f_(a){a=a|0;aa(3)}function f$(a,b){a=a|0;b=b|0;aa(4)}function f0(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aa(5);return 0}function f1(a,b,c){a=a|0;b=b|0;c=c|0;aa(6);return 0}function f2(a,b,c){a=a|0;b=b|0;c=c|0;aa(7)}function f3(){aa(8)}function f4(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=+g;h=+h;aa(9)}function f5(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=+g;aa(10)}function f6(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;aa(11)}function f7(a,b){a=a|0;b=b|0;aa(12);return 0}function f8(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;aa(13);return 0}function f9(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aa(14)}
// EMSCRIPTEN_END_FUNCS
var cf=[fX,fX,fD,fX,eq,fX,da,fX,c4,fX,d9,fX,fX,fX,fX,fX];var cg=[fY,fY,d5,fY];var ch=[fZ,fZ,fn,fZ,fm,fZ,fo,fZ];var ci=[f_,f_,dF,f_,dq,f_,d2,f_,eh,f_,cW,f_,ej,f_,d8,f_,dM,f_,dO,f_,dp,f_,ff,f_,d4,f_,dD,f_,cN,f_,c6,f_,fd,f_,df,f_,dw,f_,dR,f_,dG,f_,cQ,f_,dh,f_,es,f_,fC,f_,dz,f_,d3,f_,eg,f_,dt,f_,ei,f_,dk,f_,cX,f_,dH,f_,dP,f_,dL,f_,dc,f_,dn,f_,cM,f_,er,f_,dI,f_,dl,f_,c8,f_,fB,f_,dd,f_,fe,f_,d7,f_,fb,f_,db,f_,dZ,f_,dm,f_,fc,f_,dE,f_,du,f_,fg,f_,c7,f_,c3,f_,dg,f_,ef,f_,f_,f_,f_,f_,f_,f_,f_,f_,f_,f_,f_,f_];var cj=[f$,f$,cO,f$,dC,f$,cU,f$,d$,f$,dr,f$,c2,f$,c1,f$,c$,f$,ds,f$,dB,f$,c5,f$,d0,f$,c_,f$,d1,f$,cT,f$,cP,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$,f$];var ck=[f0,f0,em,f0];var cl=[f1,f1,fh,f1];var cm=[f2,f2,dQ,f2,dx,f2,dS,f2,cL,f2,cR,f2,f2,f2,f2,f2];var cn=[f3,f3,ep,f3,fH,f3,f3,f3];var co=[f4,f4,dT,f4];var cp=[f5,f5,dY,f5];var cq=[f6,f6,fr,f6,fp,f6,fq,f6,dX,f6,f6,f6,f6,f6,f6,f6];var cr=[f7,f7,dV,f7,eN,f7,en,f7,c9,f7,dW,f7,ek,f7,f7,f7];var cs=[f8,f8,e4,f8,e5,f8,e2,f8,e6,f8,e3,f8,f8,f8,f8,f8];var ct=[f9,f9,fi,f9,fj,f9,fk,f9,dK,f9,f9,f9,f9,f9,f9,f9];return{_strlen:fE,_free:ft,_main:eo,_realloc:fu,_memset:fF,_malloc:fs,_memcpy:fG,runPostSets:cK,stackAlloc:cu,stackSave:cv,stackRestore:cw,setThrew:cx,setTempRet0:cA,setTempRet1:cB,setTempRet2:cC,setTempRet3:cD,setTempRet4:cE,setTempRet5:cF,setTempRet6:cG,setTempRet7:cH,setTempRet8:cI,setTempRet9:cJ,dynCall_ii:fI,dynCall_vif:fJ,dynCall_viiiii:fK,dynCall_vi:fL,dynCall_vii:fM,dynCall_iiiii:fN,dynCall_iiii:fO,dynCall_viii:fP,dynCall_v:fQ,dynCall_viiiiiiff:fR,dynCall_viiiiiif:fS,dynCall_viiiiii:fT,dynCall_iii:fU,dynCall_iiiiii:fV,dynCall_viiii:fW}})
// EMSCRIPTEN_END_ASM
({ "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array }, { "abort": abort, "assert": assert, "asmPrintInt": asmPrintInt, "asmPrintFloat": asmPrintFloat, "min": Math_min, "invoke_ii": invoke_ii, "invoke_vif": invoke_vif, "invoke_viiiii": invoke_viiiii, "invoke_vi": invoke_vi, "invoke_vii": invoke_vii, "invoke_iiiii": invoke_iiiii, "invoke_iiii": invoke_iiii, "invoke_viii": invoke_viii, "invoke_v": invoke_v, "invoke_viiiiiiff": invoke_viiiiiiff, "invoke_viiiiiif": invoke_viiiiiif, "invoke_viiiiii": invoke_viiiiii, "invoke_iii": invoke_iii, "invoke_iiiiii": invoke_iiiiii, "invoke_viiii": invoke_viiii, "_llvm_lifetime_end": _llvm_lifetime_end, "_lseek": _lseek, "_glClearColor": _glClearColor, "_fclose": _fclose, "_glLinkProgram": _glLinkProgram, "_glBindTexture": _glBindTexture, "_fflush": _fflush, "_strtol": _strtol, "_fputc": _fputc, "_Mix_PlayChannel": _Mix_PlayChannel, "_fwrite": _fwrite, "_llvm_eh_exception": _llvm_eh_exception, "_fputs": _fputs, "_glCompileShader": _glCompileShader, "_isspace": _isspace, "_Mix_Init": _Mix_Init, "_glDeleteTextures": _glDeleteTextures, "_read": _read, "_Mix_OpenAudio": _Mix_OpenAudio, "_fsync": _fsync, "_glGenTextures": _glGenTextures, "___gxx_personality_v0": ___gxx_personality_v0, "___resumeException": ___resumeException, "_glCreateShader": _glCreateShader, "_strcmp": _strcmp, "_strncmp": _strncmp, "_glTexSubImage2D": _glTexSubImage2D, "_snprintf": _snprintf, "_SDL_RWFromFile": _SDL_RWFromFile, "_get_window_height": _get_window_height, "_ceilf": _ceilf, "_glGetProgramiv": _glGetProgramiv, "_glVertexAttribPointer": _glVertexAttribPointer, "_mknod": _mknod, "_glGetUniformLocation": _glGetUniformLocation, "_close": _close, "_strchr": _strchr, "_Mix_LoadWAV_RW": _Mix_LoadWAV_RW, "___setErrNo": ___setErrNo, "_glDrawArrays": _glDrawArrays, "_ftell": _ftell, "_exit": _exit, "_sprintf": _sprintf, "_strrchr": _strrchr, "_glAttachShader": _glAttachShader, "_asprintf": _asprintf, "___cxa_is_number_type": ___cxa_is_number_type, "___cxa_does_inherit": ___cxa_does_inherit, "_recv": _recv, "__ZSt18uncaught_exceptionv": __ZSt18uncaught_exceptionv, "_cos": _cos, "_puts": _puts, "___cxa_call_unexpected": ___cxa_call_unexpected, "_SDL_Init": _SDL_Init, "_get_window_width": _get_window_width, "__exit": __exit, "_fabsf": _fabsf, "_floorf": _floorf, "_qsort": _qsort, "___cxa_throw": ___cxa_throw, "_glDisableVertexAttribArray": _glDisableVertexAttribArray, "_ldexp": _ldexp, "_send": _send, "_glShaderSource": _glShaderSource, "_pread": _pread, "_SDL_SetVideoMode": _SDL_SetVideoMode, "_fopen": _fopen, "_open": _open, "_sqrtf": _sqrtf, "_sysconf": _sysconf, "_SDL_PollEvent": _SDL_PollEvent, "_glClear": _glClear, "_mkdir": _mkdir, "_glEnableVertexAttribArray": _glEnableVertexAttribArray, "___cxa_find_matching_catch": ___cxa_find_matching_catch, "_strdup": _strdup, "_glUniform4f": _glUniform4f, "__formatString": __formatString, "_SDL_GL_SwapBuffers": _SDL_GL_SwapBuffers, "_getenv": _getenv, "__ZSt9terminatev": __ZSt9terminatev, "_gettimeofday": _gettimeofday, "_llvm_pow_f64": _llvm_pow_f64, "_sbrk": _sbrk, "___errno_location": ___errno_location, "_llvm_lifetime_start": _llvm_lifetime_start, "__parseInt": __parseInt, "_glUseProgram": _glUseProgram, "_glTexImage2D": _glTexImage2D, "___assert_fail": ___assert_fail, "_fread": _fread, "_abort": _abort, "___buildEnvironment": ___buildEnvironment, "_glEnable": _glEnable, "__reallyNegative": __reallyNegative, "_fseek": _fseek, "_write": _write, "_glGetAttribLocation": _glGetAttribLocation, "___cxa_allocate_exception": ___cxa_allocate_exception, "_sin": _sin, "_glBlendFunc": _glBlendFunc, "_glCreateProgram": _glCreateProgram, "_stat": _stat, "___cxa_pure_virtual": ___cxa_pure_virtual, "_vasprintf": _vasprintf, "_glViewport": _glViewport, "_emscripten_set_main_loop": _emscripten_set_main_loop, "_Mix_FreeChunk": _Mix_FreeChunk, "_glUniformMatrix4fv": _glUniformMatrix4fv, "_pwrite": _pwrite, "_glTexParameteri": _glTexParameteri, "_time": _time, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "NaN": NaN, "Infinity": Infinity, "__ZTVN10__cxxabiv120__si_class_type_infoE": __ZTVN10__cxxabiv120__si_class_type_infoE, "__ZTVN10__cxxabiv117__class_type_infoE": __ZTVN10__cxxabiv117__class_type_infoE }, buffer);
var _strlen = Module["_strlen"] = asm["_strlen"];
var _free = Module["_free"] = asm["_free"];
var _main = Module["_main"] = asm["_main"];
var _realloc = Module["_realloc"] = asm["_realloc"];
var _memset = Module["_memset"] = asm["_memset"];
var _malloc = Module["_malloc"] = asm["_malloc"];
var _memcpy = Module["_memcpy"] = asm["_memcpy"];
var runPostSets = Module["runPostSets"] = asm["runPostSets"];
var dynCall_ii = Module["dynCall_ii"] = asm["dynCall_ii"];
var dynCall_vif = Module["dynCall_vif"] = asm["dynCall_vif"];
var dynCall_viiiii = Module["dynCall_viiiii"] = asm["dynCall_viiiii"];
var dynCall_vi = Module["dynCall_vi"] = asm["dynCall_vi"];
var dynCall_vii = Module["dynCall_vii"] = asm["dynCall_vii"];
var dynCall_iiiii = Module["dynCall_iiiii"] = asm["dynCall_iiiii"];
var dynCall_iiii = Module["dynCall_iiii"] = asm["dynCall_iiii"];
var dynCall_viii = Module["dynCall_viii"] = asm["dynCall_viii"];
var dynCall_v = Module["dynCall_v"] = asm["dynCall_v"];
var dynCall_viiiiiiff = Module["dynCall_viiiiiiff"] = asm["dynCall_viiiiiiff"];
var dynCall_viiiiiif = Module["dynCall_viiiiiif"] = asm["dynCall_viiiiiif"];
var dynCall_viiiiii = Module["dynCall_viiiiii"] = asm["dynCall_viiiiii"];
var dynCall_iii = Module["dynCall_iii"] = asm["dynCall_iii"];
var dynCall_iiiiii = Module["dynCall_iiiiii"] = asm["dynCall_iiiiii"];
var dynCall_viiii = Module["dynCall_viiii"] = asm["dynCall_viiii"];
Runtime.stackAlloc = function(size) { return asm['stackAlloc'](size) };
Runtime.stackSave = function() { return asm['stackSave']() };
Runtime.stackRestore = function(top) { asm['stackRestore'](top) };
// Warning: printing of i64 values may be slightly rounded! No deep i64 math used, so precise i64 code not included
var i64Math = null;
// === Auto-generated postamble setup entry stuff ===
if (memoryInitializer) {
  function applyData(data) {
    HEAPU8.set(data, STATIC_BASE);
  }
  if (ENVIRONMENT_IS_NODE || ENVIRONMENT_IS_SHELL) {
    applyData(Module['readBinary'](memoryInitializer));
  } else {
    addRunDependency('memory initializer');
    Browser.asyncLoad(memoryInitializer, function(data) {
      applyData(data);
      removeRunDependency('memory initializer');
    }, function(data) {
      throw 'could not load memory initializer ' + memoryInitializer;
    });
  }
}
function ExitStatus(status) {
  this.name = "ExitStatus";
  this.message = "Program terminated with exit(" + status + ")";
  this.status = status;
};
ExitStatus.prototype = new Error();
ExitStatus.prototype.constructor = ExitStatus;
var initialStackTop;
var preloadStartTime = null;
var calledMain = false;
dependenciesFulfilled = function runCaller() {
  // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
  if (!Module['calledRun'] && shouldRunNow) run();
  if (!Module['calledRun']) dependenciesFulfilled = runCaller; // try this again later, after new deps are fulfilled
}
Module['callMain'] = Module.callMain = function callMain(args) {
  assert(runDependencies == 0, 'cannot call main when async dependencies remain! (listen on __ATMAIN__)');
  assert(__ATPRERUN__.length == 0, 'cannot call main when preRun functions remain to be called');
  args = args || [];
  if (ENVIRONMENT_IS_WEB && preloadStartTime !== null) {
    Module.printErr('preload time: ' + (Date.now() - preloadStartTime) + ' ms');
  }
  ensureInitRuntime();
  var argc = args.length+1;
  function pad() {
    for (var i = 0; i < 4-1; i++) {
      argv.push(0);
    }
  }
  var argv = [allocate(intArrayFromString("/bin/this.program"), 'i8', ALLOC_NORMAL) ];
  pad();
  for (var i = 0; i < argc-1; i = i + 1) {
    argv.push(allocate(intArrayFromString(args[i]), 'i8', ALLOC_NORMAL));
    pad();
  }
  argv.push(0);
  argv = allocate(argv, 'i32', ALLOC_NORMAL);
  initialStackTop = STACKTOP;
  try {
    var ret = Module['_main'](argc, argv, 0);
    // if we're not running an evented main loop, it's time to exit
    if (!Module['noExitRuntime']) {
      exit(ret);
    }
  }
  catch(e) {
    if (e instanceof ExitStatus) {
      // exit() throws this once it's done to make sure execution
      // has been stopped completely
      return;
    } else if (e == 'SimulateInfiniteLoop') {
      // running an evented main loop, don't immediately exit
      Module['noExitRuntime'] = true;
      return;
    } else {
      if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
      throw e;
    }
  } finally {
    calledMain = true;
  }
}
function run(args) {
  args = args || Module['arguments'];
  if (preloadStartTime === null) preloadStartTime = Date.now();
  if (runDependencies > 0) {
    Module.printErr('run() called, but dependencies remain, so not running');
    return;
  }
  preRun();
  if (runDependencies > 0) {
    // a preRun added a dependency, run will be called later
    return;
  }
  function doRun() {
    ensureInitRuntime();
    preMain();
    Module['calledRun'] = true;
    if (Module['_main'] && shouldRunNow) {
      Module['callMain'](args);
    }
    postRun();
  }
  if (Module['setStatus']) {
    Module['setStatus']('Running...');
    setTimeout(function() {
      setTimeout(function() {
        Module['setStatus']('');
      }, 1);
      if (!ABORT) doRun();
    }, 1);
  } else {
    doRun();
  }
}
Module['run'] = Module.run = run;
function exit(status) {
  ABORT = true;
  EXITSTATUS = status;
  STACKTOP = initialStackTop;
  // exit the runtime
  exitRuntime();
  // TODO We should handle this differently based on environment.
  // In the browser, the best we can do is throw an exception
  // to halt execution, but in node we could process.exit and
  // I'd imagine SM shell would have something equivalent.
  // This would let us set a proper exit status (which
  // would be great for checking test exit statuses).
  // https://github.com/kripken/emscripten/issues/1371
  // throw an exception to halt the current execution
  throw new ExitStatus(status);
}
Module['exit'] = Module.exit = exit;
function abort(text) {
  if (text) {
    Module.print(text);
    Module.printErr(text);
  }
  ABORT = true;
  EXITSTATUS = 1;
  throw 'abort() at ' + stackTrace();
}
Module['abort'] = Module.abort = abort;
// {{PRE_RUN_ADDITIONS}}
if (Module['preInit']) {
  if (typeof Module['preInit'] == 'function') Module['preInit'] = [Module['preInit']];
  while (Module['preInit'].length > 0) {
    Module['preInit'].pop()();
  }
}
// shouldRunNow refers to calling main(), not run().
var shouldRunNow = true;
if (Module['noInitialRun']) {
  shouldRunNow = false;
}
run();
// {{POST_RUN_ADDITIONS}}
// {{MODULE_ADDITIONS}}
