$(document).ready(function(){
    $("#back").on('click', function(){
        $.mobile.changePage('#home');
    });
    var RSS = "http://gabrycaos.altervista.org/feed";
    $.ajaxPrefilter(function (options) {
        if (options.xhrConstructParam) {
            options.xhr = function () {
                return new window.XMLHttpRequest(options.xhrConstructParam);
            }
        }
    });
// for FirefoxOS (require "mozSystem" param in AJAX calls)
    var xhrConstructParam = null;
    xhrConstructParam = {
        mozSystem: true
    };
//default settings for AJAX methods
    $.ajaxSetup({
        xhrConstructParam: xhrConstructParam
    });
    $.ajax({
        url:RSS,
        success:function(res,code) {
            var entries = [];
            var xml = $(res);
            var items = xml.find("item");
            $.each(items, function(i, v) {
                entry = {
                    title: $(v).find("title").text(),
                    desc: $.trim($(v).find("content\\:encoded").html()),
                    img: $(v).find("enclosure").attr("url")
                };
                var d = entry.desc;
                entry.desc = $(d).text();
                entries.push(entry);
            });
            //store entries
           // localStorage["entries"] = JSON.stringify(entries);
            renderEntries(entries);
            listeners(entries);
        },
        error:function(jqXHR,status,error) {
            //try to use cache
            if(localStorage["entries"]) {
                $("#status").html("Using cached version...");
                entries = JSON.parse(localStorage["entries"])
                renderEntries(entries);
            } else {
                $("#status").html("Sorry, we are unable to get the RSS and there is no cache.");
            }
        }
    });
    function renderEntries(entries){
        var a = $('#feedList');
        $.each(entries, function(i, v){
            var li = '<li style="'+"background-image: url('"+ v.img+"')"+'" id="'+i+'" class="feedItem"><p>'+ v.title+'</p></li>';
            a.append(li);
        });
    }
    function listeners(entries) {
        $(".feedItem").on('click', function(){
            var a = $(this).attr('id');
            var obj = entries[a];
            $("#detImage").attr('src', obj.img);
            $("#news").empty();
            $("#news").append(obj.desc);
            $("#titleApp").empty();
            $("#titleApp").append(obj.title);
            $.mobile.changePage('#details');
        })
    }
})