// Built with IMPACT - impactjs.org
Number.prototype.map = function (istart, istop, ostart, ostop) {
    return ostart + (ostop - ostart) * ((this - istart) / (istop - istart));
};
Number.prototype.limit = function (min, max) {
    return Math.min(max, Math.max(min, this));
};
Number.prototype.round = function (precision) {
    precision = Math.pow(10, precision || 0);
    return Math.round(this * precision) / precision;
};
Number.prototype.floor = function () {
    return Math.floor(this);
};
Number.prototype.ceil = function () {
    return Math.ceil(this);
};
Number.prototype.toInt = function () {
    return (this | 0);
};
Array.prototype.erase = function (item) {
    for (var i = this.length; i--; i) {
        if (this[i] === item) this.splice(i, 1);
    }
    return this;
};
Array.prototype.random = function () {
    return this[(Math.random() * this.length).floor()];
};
Function.prototype.bind = function (bind) {
    var self = this;
    return function () {
        var args = Array.prototype.slice.call(arguments);
        return self.apply(bind || null, args);
    };
};
(function (window) {
    window.ig = {
        game: null,
        version: '1.16',
        global: window,
        modules: {},
        resources: [],
        ready: false,
        baked: false,
        nocache: '',
        ua: {},
        lib: 'lib/',
        _current: null,
        _loadQueue: [],
        _waitForOnload: 0,
        $: function (selector) {
            return selector.charAt(0) == '#' ? document.getElementById(selector.substr(1)) : document.getElementsByTagName(selector);
        },
        $new: function (name) {
            return document.createElement(name);
        },
        copy: function (object) {
            if (!object || typeof (object) != 'object' || object instanceof HTMLElement || object instanceof ig.Class) {
                return object;
            } else if (object instanceof Array) {
                var c = [];
                for (var i = 0, l = object.length; i < l; i++) {
                    c[i] = ig.copy(object[i]);
                }
                return c;
            } else {
                var c = {};
                for (var i in object) {
                    c[i] = ig.copy(object[i]);
                }
                return c;
            }
        },
        merge: function (original, extended) {
            for (var key in extended) {
                var ext = extended[key];
                if (typeof (ext) != 'object' || ext instanceof HTMLElement || ext instanceof ig.Class) {
                    original[key] = ext;
                } else {
                    if (!original[key] || typeof (original[key]) != 'object') {
                        original[key] = {};
                    }
                    ig.merge(original[key], ext);
                }
            }
            return original;
        },
        ksort: function (obj) {
            if (!obj || typeof (obj) != 'object') {
                return [];
            }
            var keys = [],
                values = [];
            for (var i in obj) {
                keys.push(i);
            }
            keys.sort();
            for (var i = 0; i < keys.length; i++) {
                values.push(obj[keys[i]]);
            }
            return values;
        },
        module: function (name) {
            if (ig._current) {
                throw ("Module '" + ig._current.name + "' defines nothing");
            }
            if (ig.modules[name] && ig.modules[name].body) {
                throw ("Module '" + name + "' is already defined");
            }
            ig._current = {
                name: name,
                requires: [],
                loaded: false,
                body: null
            };
            ig.modules[name] = ig._current;
            ig._loadQueue.push(ig._current);
            ig._initDOMReady();
            return ig;
        },
        requires: function () {
            ig._current.requires = Array.prototype.slice.call(arguments);
            return ig;
        },
        defines: function (body) {
            name = ig._current.name;
            ig._current.body = body;
            ig._current = null;
            ig._execModules();
        },
        addResource: function (resource) {
            ig.resources.push(resource);
        },
        setNocache: function (set) {
            ig.nocache = set ? '?' + Date.now() : '';
        },
        _loadScript: function (name, requiredFrom) {
            ig.modules[name] = {
                name: name,
                requires: [],
                loaded: false,
                body: null
            };
            ig._waitForOnload++;
            var path = ig.lib + name.replace(/\./g, '/') + '.js' + ig.nocache;
            var script = ig.$new('script');
            script.type = 'text/javascript';
            script.src = path;
            script.onload = function () {
                ig._waitForOnload--;
                ig._execModules();
            };
            script.onerror = function () {
                throw ('Failed to load module ' + name + ' at ' + path + ' ' + 'required from ' + requiredFrom);
            };
            ig.$('head')[0].appendChild(script);
        },
        _execModules: function () {
            var modulesLoaded = false;
            for (var i = 0; i < ig._loadQueue.length; i++) {
                var m = ig._loadQueue[i];
                var dependenciesLoaded = true;
                for (var j = 0; j < m.requires.length; j++) {
                    var name = m.requires[j];
                    if (!ig.modules[name]) {
                        dependenciesLoaded = false;
                        ig._loadScript(name, m.name);
                    } else if (!ig.modules[name].loaded) {
                        dependenciesLoaded = false;
                    }
                }
                if (dependenciesLoaded && m.body) {
                    ig._loadQueue.splice(i, 1);
                    m.loaded = true;
                    m.body();
                    modulesLoaded = true;
                    i--;
                }
            }
            if (modulesLoaded) {
                ig._execModules();
            } else if (!ig.baked && ig._waitForOnload == 0 && ig._loadQueue.length != 0) {
                var unresolved = [];
                for (var i = 0; i < ig._loadQueue.length; i++) {
                    var unloaded = [];
                    var requires = ig._loadQueue[i].requires;
                    for (var j = 0; j < requires.length; j++) {
                        var m = ig.modules[requires[j]];
                        if (!m || !m.loaded) {
                            unloaded.push(requires[j]);
                        }
                    }
                    unresolved.push(ig._loadQueue[i].name + ' (requires: ' + unloaded.join(', ') + ')');
                }
                throw ('Unresolved (circular?) dependencies. ' + "Most likely there's a name/path mismatch for one of the listed modules:\n" + unresolved.join('\n'));
            }
        },
        _DOMReady: function () {
            if (!ig.modules['dom.ready'].loaded) {
                if (!document.body) {
                    return setTimeout(ig._DOMReady, 13);
                }
                ig.modules['dom.ready'].loaded = true;
                ig._waitForOnload--;
                ig._execModules();
            }
            return 0;
        },
        _boot: function () {
            if (document.location.href.match(/\?nocache/)) {
                ig.setNocache(true);
            }
            ig.ua.pixelRatio = window.devicePixelRatio || 1;
            ig.ua.viewport = {
                width: window.innerWidth,
                height: window.innerHeight
            };
            ig.ua.screen = {
                width: window.screen.availWidth * ig.ua.pixelRatio,
                height: window.screen.availHeight * ig.ua.pixelRatio
            };
            ig.ua.iPhone = /iPhone/i.test(navigator.userAgent);
            ig.ua.iPhone4 = (ig.ua.iPhone && ig.ua.pixelRatio == 2);
            ig.ua.iPad = /iPad/i.test(navigator.userAgent);
            ig.ua.android = /android/i.test(navigator.userAgent);
            ig.ua.iOS = ig.ua.iPhone || ig.ua.iPad;
            ig.ua.mobile = ig.ua.iOS || ig.ua.android;
        },
        _initDOMReady: function () {
            if (ig.modules['dom.ready']) {
                return;
            }
            ig._boot();
            ig.modules['dom.ready'] = {
                requires: [],
                loaded: false,
                body: null
            };
            ig._waitForOnload++;
            if (document.readyState === 'complete') {
                ig._DOMReady();
            } else {
                document.addEventListener('DOMContentLoaded', ig._DOMReady, false);
                window.addEventListener('load', ig._DOMReady, false);
            }
        }
    };
    var initializing = false,
        fnTest = /xyz/.test(function () {
            xyz;
        }) ? /\bparent\b/ : /.*/;
    window.ig.Class = function () {};
    window.ig.Class.extend = function (prop) {
        var parent = this.prototype;
        initializing = true;
        var prototype = new this();
        initializing = false;
        for (var name in prop) {
            if (typeof (prop[name]) == "function" && typeof (parent[name]) == "function" && fnTest.test(prop[name])) {
                prototype[name] = (function (name, fn) {
                    return function () {
                        var tmp = this.parent;
                        this.parent = parent[name];
                        var ret = fn.apply(this, arguments);
                        this.parent = tmp;
                        return ret;
                    };
                })(name, prop[name])
            } else {
                prototype[name] = prop[name];
            }
        }

        function Class() {
            if (!initializing) {
                if (this.staticInstantiate) {
                    var obj = this.staticInstantiate.apply(this, arguments);
                    if (obj) {
                        return obj;
                    }
                }
                for (var p in this) {
                    this[p] = ig.copy(this[p]);
                }
                if (this.init) {
                    this.init.apply(this, arguments);
                }
            }
            return this;
        }
        Class.prototype = prototype;
        Class.constructor = Class;
        Class.extend = arguments.callee;
        return Class;
    };
})(window);

// lib/impact/image.js
ig.baked = true;
ig.module('impact.image').defines(function () {
    ig.Image = ig.Class.extend({
        data: null,
        width: 0,
        height: 0,
        loaded: false,
        failed: false,
        loadCallback: null,
        path: '',
        staticInstantiate: function (path) {
            return ig.Image.cache[path] || null;
        },
        init: function (path) {
            this.path = path;
            this.load();
        },
        load: function (loadCallback) {
            if (this.loaded) {
                if (loadCallback) {
                    loadCallback(this.path, true);
                }
                return;
            } else if (!this.loaded && ig.ready) {
                this.loadCallback = loadCallback || null;
                this.data = new Image();
                this.data.onload = this.onload.bind(this);
                this.data.onerror = this.onerror.bind(this);
                this.data.src = this.path + ig.nocache;
            } else {
                ig.addResource(this);
            }
            ig.Image.cache[this.path] = this;
        },
        reload: function () {
            this.loaded = false;
            this.data = new Image();
            this.data.onload = this.onload.bind(this);
            this.data.src = this.path + '?' + Date.now();
        },
        onload: function (event) {
            this.width = this.data.width;
            this.height = this.data.height;
            if (ig.system.scale != 1) {
                this.resize(ig.system.scale);
            }
            this.loaded = true;
            if (this.loadCallback) {
                this.loadCallback(this.path, true);
            }
        },
        onerror: function (event) {
            this.failed = true;
            if (this.loadCallback) {
                this.loadCallback(this.path, false);
            }
        },
        resize: function (scale) {
            var widthScaled = this.width * scale;
            var heightScaled = this.height * scale;
            var orig = ig.$new('canvas');
            orig.width = this.width;
            orig.height = this.height;
            var origCtx = orig.getContext('2d');
            origCtx.drawImage(this.data, 0, 0, this.width, this.height, 0, 0, this.width, this.height);
            var origPixels = origCtx.getImageData(0, 0, this.width, this.height);
            var scaled = ig.$new('canvas');
            scaled.width = widthScaled;
            scaled.height = heightScaled;
            var scaledCtx = scaled.getContext('2d');
            var scaledPixels = scaledCtx.getImageData(0, 0, widthScaled, heightScaled);
            for (var y = 0; y < heightScaled; y++) {
                for (var x = 0; x < widthScaled; x++) {
                    var index = ((y / scale).floor() * this.width + (x / scale).floor()) * 4;
                    var indexScaled = (y * widthScaled + x) * 4;
                    scaledPixels.data[indexScaled] = origPixels.data[index];
                    scaledPixels.data[indexScaled + 1] = origPixels.data[index + 1];
                    scaledPixels.data[indexScaled + 2] = origPixels.data[index + 2];
                    scaledPixels.data[indexScaled + 3] = origPixels.data[index + 3];
                }
            }
            scaledCtx.putImageData(scaledPixels, 0, 0);
            this.data = scaled;
        },
        draw: function (targetX, targetY, sourceX, sourceY, width, height) {
            if (!this.loaded) {
                return;
            }
            var scale = ig.system.scale;
            sourceX = sourceX ? sourceX * scale : 0;
            sourceY = sourceY ? sourceY * scale : 0;
            width = (width ? width : this.width) * scale;
            height = (height ? height : this.height) * scale;
            ig.system.context.drawImage(this.data, sourceX, sourceY, width, height, ig.system.getDrawPos(targetX), ig.system.getDrawPos(targetY), width, height);
        },
        drawTile: function (targetX, targetY, tile, tileWidth, tileHeight, flipX, flipY) {
            tileHeight = tileHeight ? tileHeight : tileWidth;
            if (!this.loaded || tileWidth > this.width || tileHeight > this.height) {
                return;
            }
            var scale = ig.system.scale;
            var tileWidthScaled = tileWidth * scale;
            var tileHeightScaled = tileHeight * scale;
            var scaleX = flipX ? -1 : 1;
            var scaleY = flipY ? -1 : 1;
            if (flipX || flipY) {
                ig.system.context.save();
                ig.system.context.scale(scaleX, scaleY);
            }
            ig.system.context.drawImage(this.data, ((tile * tileWidth).floor() % this.width) * scale, ((tile * tileWidth / this.width).floor() * tileHeight) * scale, tileWidthScaled, tileHeightScaled, ig.system.getDrawPos(targetX) * scaleX - (flipX ? tileWidthScaled : 0), ig.system.getDrawPos(targetY) * scaleY - (flipY ? tileHeightScaled : 0), tileWidthScaled, tileHeightScaled);
            if (flipX || flipY) {
                ig.system.context.restore();
            }
        }
    });
    ig.Image.cache = {};
    ig.Image.reloadCache = function () {
        for (path in ig.Image.cache) {
            ig.Image.cache[path].reload();
        }
    };
});

// lib/impact/font.js
ig.baked = true;
ig.module('impact.font').requires('impact.image').defines(function () {
    ig.Font = ig.Image.extend({
        widthMap: [],
        indices: [],
        firstChar: 32,
        height: 0,
        onload: function (ev) {
            this._loadMetrics(this.data);
            this.parent(ev);
        },
        widthForString: function (s) {
            var width = 0;
            for (var i = 0; i < s.length; i++) {
                width += this.widthMap[s.charCodeAt(i) - this.firstChar] + 1;
            }
            return width;
        },
        draw: function (text, x, y, align) {
            if (typeof (text) != 'string') {
                text = text.toString();
            }
            if (align == ig.Font.ALIGN.RIGHT || align == ig.Font.ALIGN.CENTER) {
                var width = 0;
                for (var i = 0; i < text.length; i++) {
                    var c = text.charCodeAt(i);
                    width += this.widthMap[c - this.firstChar] + 1;
                }
                x -= align == ig.Font.ALIGN.CENTER ? width / 2 : width;
            }
            for (var i = 0; i < text.length; i++) {
                var c = text.charCodeAt(i);
                x += this._drawChar(c - this.firstChar, x, y);
            }
        },
        _drawChar: function (c, targetX, targetY) {
            if (!this.loaded || c < 0 || c >= this.indices.length) {
                return 0;
            }
            var scale = ig.system.scale;
            var charX = this.indices[c] * scale;
            var charY = 0;
            var charWidth = this.widthMap[c] * scale;
            var charHeight = (this.height - 2) * scale;
            ig.system.context.drawImage(this.data, charX, charY, charWidth, charHeight, ig.system.getDrawPos(targetX), ig.system.getDrawPos(targetY), charWidth, charHeight);
            return this.widthMap[c] + 1;
        },
        _loadMetrics: function (image) {
            this.height = image.height - 1;
            this.widthMap = [];
            this.indices = [];
            var canvas = ig.$new('canvas');
            canvas.width = image.width;
            canvas.height = 1;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(image, 0, image.height - 1, image.width, 1, 0, 0, image.width, 1);
            var px = ctx.getImageData(0, 0, image.width, 1);
            var currentChar = 0;
            var currentWidth = 0;
            for (var x = 0; x < image.width; x++) {
                var index = x * 4 + 3;
                if (px.data[index] != 0) {
                    currentWidth++;
                } else if (px.data[index] == 0 && currentWidth) {
                    this.widthMap.push(currentWidth);
                    this.indices.push(x - currentWidth);
                    currentChar++;
                    currentWidth = 0;
                }
            }
            this.widthMap.push(currentWidth);
            this.indices.push(x - currentWidth);
        }
    });
    ig.Font.ALIGN = {
        LEFT: 0,
        RIGHT: 1,
        CENTER: 2
    };
});

// lib/impact/sound.js
ig.baked = true;
ig.module('impact.sound').defines(function () {
    ig.SoundManager = ig.Class.extend({
        clips: {},
        volume: 1,
        channels: 4,
        format: 'mp3',
        init: function () {
            this.format = ig.$new('audio').canPlayType('audio/mpeg') ? 'mp3' : 'ogg';
        },
        load: function (path, multiChannel, loadCallback) {
            if (this.clips[path]) {
                if (multiChannel && this.clips[path].length < this.channels) {
                    for (var i = this.clips[path].length; i < this.channels; i++) {
                        this.clips[path].push(this.clips[path][0].cloneNode(true));
                    }
                }
                return this.clips[path][0];
            }
            var realPath = path.match(/^(.*)\.[^\.]+$/)[1] + '.' + this.format + ig.nocache;
            var clip = ig.$new('audio');
            if (loadCallback) {
                clip.addEventListener('canplaythrough', function (ev) {
                    this.removeEventListener('canplaythrough', arguments.callee, false)
                    loadCallback(path, true, ev);
                }, false);
                clip.addEventListener('error', function (ev) {
                    loadCallback(path, true, ev);
                }, false);
            }
            clip.autobuffer = true;
            clip.preload = 'auto';
            clip.src = realPath;
            clip.load();
            this.clips[path] = [clip];
            if (multiChannel) {
                for (var i = 1; i < this.channels; i++) {
                    this.clips[path].push(clip.cloneNode(true));
                }
            }
            return clip;
        },
        get: function (path) {
            var channels = this.clips[path];
            for (var i = 0, clip; clip = channels[i++];) {
                if (clip.paused || clip.ended) {
                    if (clip.ended) {
                        clip.currentTime = 0;
                    }
                    return clip;
                }
            }
            channels[0].pause();
            channels[0].currentTime = 0;
            return channels[0];
        }
    });
    ig.Music = ig.Class.extend({
        tracks: [],
        currentTrack: null,
        currentIndex: 0,
        random: false,
        _volume: 1,
        _loop: false,
        _fadeInterval: 0,
        _fadeTimer: null,
        _endedCallbackBound: null,
        init: function () {
            this._endedCallbackBound = this._endedCallback.bind(this);
            if (Object.defineProperty) {
                Object.defineProperty(this, "volume", {
                    get: this.getVolume.bind(this),
                    set: this.setVolume.bind(this)
                });
                Object.defineProperty(this, "loop", {
                    get: this.getLooping.bind(this),
                    set: this.setLooping.bind(this)
                });
            } else if (this.__defineGetter__) {
                this.__defineGetter__('volume', this.getVolume.bind(this));
                this.__defineSetter__('volume', this.setVolume.bind(this));
                this.__defineGetter__('loop', this.getLooping.bind(this));
                this.__defineSetter__('loop', this.setLooping.bind(this));
            }
        },
        add: function (music) {
            if (!ig.Sound.enabled) {
                return;
            }
            var path = music instanceof ig.Sound ? music.path : music;
            var track = ig.soundManager.load(path, false);
            track.loop = this._loop;
            track.volume = this._volume;
            track.addEventListener('ended', this._endedCallbackBound, false);
            this.tracks.push(track);
            if (!this.currentTrack) {
                this.currentTrack = track;
            }
        },
        next: function () {
            if (!this.tracks.length) {
                return;
            }
            this.stop();
            this.currentIndex = this.random ? (Math.random() * this.tracks.length).floor() : (this.currentIndex + 1) % this.tracks.length;
            this.currentTrack = this.tracks[this.currentIndex];
            this.play();
        },
        pause: function () {
            if (!this.currentTrack) {
                return;
            }
            this.currentTrack.pause();
        },
        stop: function () {
            if (!this.currentTrack) {
                return;
            }
            this.currentTrack.pause();
            this.currentTrack.currentTime = 0;
        },
        play: function () {
            if (!this.currentTrack) {
                return;
            }
            this.currentTrack.play();
        },
        getLooping: function () {
            return this._loop;
        },
        setLooping: function (l) {
            this._loop = l;
            for (var i in this.tracks) {
                this.tracks[i].loop = l;
            }
        },
        getVolume: function () {
            return this._volume;
        },
        setVolume: function (v) {
            this._volume = v.limit(0, 1);
            for (var i in this.tracks) {
                this.tracks[i].volume = this._volume;
            }
        },
        fadeOut: function (time) {
            if (!this.currentTrack) {
                return;
            }
            clearInterval(this._fadeInterval);
            this.fadeTimer = new ig.Timer(time);
            this._fadeInterval = setInterval(this._fadeStep.bind(this), 50);
        },
        _fadeStep: function () {
            var v = this.fadeTimer.delta().map(-this.fadeTimer.target, 0, 1, 0).limit(0, 1) * this._volume;
            if (v <= 0.01) {
                this.stop();
                this.currentTrack.volume = this._volume;
                clearInterval(this._fadeInterval);
            } else {
                this.currentTrack.volume = v;
            }
        },
        _endedCallback: function () {
            if (this._loop) {
                this.play();
            } else {
                this.next();
            }
        }
    });
    ig.Sound = ig.Class.extend({
        path: '',
        volume: 1,
        currentClip: null,
        multiChannel: true,
        init: function (path, multiChannel) {
            this.path = path;
            this.multiChannel = (multiChannel !== false);
            this.load();
        },
        load: function (loadCallback) {
            if (!ig.Sound.enabled) {
                if (loadCallback) {
                    loadCallback(this.path, true);
                }
                return;
            }
            if (ig.ready) {
                ig.soundManager.load(this.path, this.multiChannel, loadCallback);
            } else {
                ig.addResource(this);
            }
        },
        play: function () {
            if (!ig.Sound.enabled) {
                return;
            }
            this.currentClip = ig.soundManager.get(this.path);
            this.currentClip.volume = ig.soundManager.volume * this.volume;
            this.currentClip.play();
        },
        stop: function () {
            if (this.currentClip) {
                this.currentClip.pause();
                this.currentClip.currentTime = 0;
            }
        }
    });
    ig.Sound.enabled = true;
});

// lib/impact/loader.js
ig.baked = true;
ig.module('impact.loader').requires('impact.image', 'impact.font', 'impact.sound').defines(function () {
    ig.Loader = ig.Class.extend({
        resources: [],
        gameClass: null,
        status: 0,
        done: false,
        _unloaded: [],
        _drawStatus: 0,
        _intervalId: 0,
        _loadCallbackBound: null,
        init: function (gameClass, resources) {
            this.gameClass = gameClass;
            this.resources = resources;
            this._loadCallbackBound = this._loadCallback.bind(this);
            for (var i = 0; i < this.resources.length; i++) {
                this._unloaded.push(this.resources[i].path);
            }
        },
        load: function () {
            ig.system.clear('#000');
            if (!this.resources.length) {
                this.end();
                return;
            }
            for (var i = 0; i < this.resources.length; i++) {
                this.loadResource(this.resources[i]);
            }
            this._intervalId = setInterval(this.draw.bind(this), 16);
        },
        loadResource: function (res) {
            res.load(this._loadCallbackBound);
        },
        end: function () {
            if (this.done) {
                return;
            }
            this.done = true;
            clearInterval(this._intervalId);
            ig.system.setGame(this.gameClass);
        },
        draw: function () {
            this._drawStatus += (this.status - this._drawStatus) / 5;
            var s = ig.system.scale;
            var w = ig.system.width * 0.6;
            var h = ig.system.height * 0.1;
            var x = ig.system.width * 0.5 - w / 2;
            var y = ig.system.height * 0.5 - h / 2;
            ig.system.context.fillStyle = '#000';
            ig.system.context.fillRect(0, 0, 480, 320);
            ig.system.context.fillStyle = '#fff';
            ig.system.context.fillRect(x * s, y * s, w * s, h * s);
            ig.system.context.fillStyle = '#000';
            ig.system.context.fillRect(x * s + s, y * s + s, w * s - s - s, h * s - s - s);
            ig.system.context.fillStyle = '#fff';
            ig.system.context.fillRect(x * s, y * s, w * s * this._drawStatus, h * s);
        },
        _loadCallback: function (path, status) {
            if (status) {
                this._unloaded.erase(path);
            } else {
                throw ('Failed to load resource: ' + path);
            }
            this.status = 1 - (this._unloaded.length / this.resources.length);
            if (this._unloaded.length == 0) {
                setTimeout(this.end.bind(this), 250);
            }
        }
    });
});

// lib/impact/timer.js
ig.baked = true;
ig.module('impact.timer').defines(function () {
    ig.Timer = ig.Class.extend({
        target: 0,
        base: 0,
        last: 0,
        init: function (seconds) {
            this.base = ig.Timer.time;
            this.last = ig.Timer.time;
            this.target = seconds || 0;
        },
        set: function (seconds) {
            this.target = seconds || 0;
            this.base = ig.Timer.time;
        },
        reset: function () {
            this.base = ig.Timer.time;
        },
        tick: function () {
            var delta = ig.Timer.time - this.last;
            this.last = ig.Timer.time;
            return delta;
        },
        delta: function () {
            return ig.Timer.time - this.base - this.target;
        }
    });
    ig.Timer._last = 0;
    ig.Timer.time = 0;
    ig.Timer.timeScale = 1;
    ig.Timer.maxStep = 0.05;
    ig.Timer.step = function () {
        var current = Date.now();
        var delta = (current - ig.Timer._last) / 1000;
        ig.Timer.time += Math.min(delta, ig.Timer.maxStep) * ig.Timer.timeScale;
        ig.Timer._last = current;
    };
});

// lib/impact/system.js
ig.baked = true;
ig.module('impact.system').requires('impact.timer', 'impact.image').defines(function () {
    ig.System = ig.Class.extend({
        fps: 30,
        width: 320,
        height: 240,
        realWidth: 320,
        realHeight: 240,
        scale: 1,
        tick: 0,
        intervalId: 0,
        newGameClass: null,
        running: false,
        delegate: null,
        clock: null,
        canvas: null,
        context: null,
        smoothPositioning: true,
        init: function (canvasId, fps, width, height, scale) {
            this.fps = fps;
            this.width = width;
            this.height = height;
            this.scale = scale;
            this.realWidth = width * scale;
            this.realHeight = height * scale;
            this.clock = new ig.Timer();
            this.canvas = ig.$(canvasId);
            this.canvas.width = this.realWidth;
            this.canvas.height = this.realHeight;
            this.context = this.canvas.getContext('2d');
        },
        setGame: function (gameClass) {
            if (this.running) {
                this.newGameClass = gameClass;
            } else {
                this.setGameNow(gameClass);
            }
        },
        setGameNow: function (gameClass) {
            ig.game = new(gameClass)();
            ig.system.setDelegate(ig.game);
        },
        setDelegate: function (object) {
            if (typeof (object.run) == 'function') {
                this.delegate = object;
                this.startRunLoop();
            } else {
                throw ('System.setDelegate: No run() function in object');
            }
        },
        stopRunLoop: function () {
            clearInterval(this.intervalId);
            this.running = false;
        },
        startRunLoop: function () {
            this.stopRunLoop();
            this.intervalId = setInterval(this.run.bind(this), 1000 / this.fps);
            this.running = true;
        },
        clear: function (color) {
            this.context.fillStyle = color;
            this.context.fillRect(0, 0, this.realWidth, this.realHeight);
        },
        run: function () {
            ig.Timer.step();
            this.tick = this.clock.tick();
            this.delegate.run();
            ig.input.clearPressed();
            if (this.newGameClass) {
                this.setGameNow(this.newGameClass);
                this.newGameClass = null;
            }
        },
        drawRect: function (x, y, width, height) {
            this.context.fillRect(x, y, width, 1);
            this.context.fillRect(x, y + height, width, 1);
            this.context.fillRect(x, y, 1, height);
            this.context.fillRect(x + width, y, 1, height);
        },
        getDrawPos: function (p) {
            return this.smoothPositioning ? (p * this.scale).round() : p.round() * this.scale;
        }
    });
});

// lib/impact/input.js
ig.baked = true;
ig.module('impact.input').defines(function () {
    ig.KEY = {
        'MOUSE1': -1,
        'MOUSE2': -3,
        'MWHEEL_UP': -4,
        'MWHEEL_DOWN': -5,
        'BACKSPACE': 8,
        'TAB': 9,
        'ENTER': 13,
        'PAUSE': 19,
        'CAPS': 20,
        'ESC': 27,
        'SPACE': 32,
        'PAGE_UP': 33,
        'PAGE_DOWN': 34,
        'END': 35,
        'HOME': 36,
        'LEFT_ARROW': 37,
        'UP_ARROW': 38,
        'RIGHT_ARROW': 39,
        'DOWN_ARROW': 40,
        'INSERT': 45,
        'DELETE': 46,
        '0': 48,
        '1': 49,
        '2': 50,
        '3': 51,
        '4': 52,
        '5': 53,
        '6': 54,
        '7': 55,
        '8': 56,
        '9': 57,
        'A': 65,
        'B': 66,
        'C': 67,
        'D': 68,
        'E': 69,
        'F': 70,
        'G': 71,
        'H': 72,
        'I': 73,
        'J': 74,
        'K': 75,
        'L': 76,
        'M': 77,
        'N': 78,
        'O': 79,
        'P': 80,
        'Q': 81,
        'R': 82,
        'S': 83,
        'T': 84,
        'U': 85,
        'V': 86,
        'W': 87,
        'X': 88,
        'Y': 89,
        'Z': 90,
        'NUMPAD_0': 96,
        'NUMPAD_1': 97,
        'NUMPAD_2': 98,
        'NUMPAD_3': 99,
        'NUMPAD_4': 100,
        'NUMPAD_5': 101,
        'NUMPAD_6': 102,
        'NUMPAD_7': 103,
        'NUMPAD_8': 104,
        'NUMPAD_9': 105,
        'MULTIPLY': 106,
        'ADD': 107,
        'SUBSTRACT': 109,
        'DECIMAL': 110,
        'DIVIDE': 111,
        'F1': 112,
        'F2': 113,
        'F3': 114,
        'F4': 115,
        'F5': 116,
        'F6': 117,
        'F7': 118,
        'F8': 119,
        'F9': 120,
        'F10': 121,
        'F11': 122,
        'F12': 123,
        'SHIFT': 16,
        'CTRL': 17,
        'ALT': 18,
        'PLUS': 187,
        'COMMA': 188,
        'MINUS': 189,
        'PERIOD': 190
    };
    ig.Input = ig.Class.extend({
        bindings: {},
        actions: {},
        locks: {},
        delayedKeyup: [],
        isUsingMouse: false,
        isUsingKeyboard: false,
        mouse: {
            x: 0,
            y: 0
        },
        initMouse: function () {
            if (this.isUsingMouse) {
                return;
            }
            this.isUsingMouse = true;
            window.addEventListener('mousewheel', this.mousewheel.bind(this), false);
            ig.system.canvas.addEventListener('contextmenu', this.contextmenu.bind(this), false);
            ig.system.canvas.addEventListener('mousedown', this.keydown.bind(this), false);
            ig.system.canvas.addEventListener('mouseup', this.keyup.bind(this), false);
            ig.system.canvas.addEventListener('mousemove', this.mousemove.bind(this), false);
            ig.system.canvas.addEventListener('touchstart', this.keydown.bind(this), false);
            ig.system.canvas.addEventListener('touchend', this.keyup.bind(this), false);
            ig.system.canvas.addEventListener('touchmove', this.mousemove.bind(this), false);
        },
        initKeyboard: function () {
            if (this.isUsingKeyboard) {
                return;
            }
            this.isUsingKeyboard = true;
            window.addEventListener('keydown', this.keydown.bind(this), false);
            window.addEventListener('keyup', this.keyup.bind(this), false);
        },
        mousewheel: function (event) {
            var code = event.wheel > 0 ? ig.KEY.MWHEEL_UP : ig.KEY.MWHEEL_DOWN;
            var action = this.bindings[code];
            if (action) {
                this.actions[action] = true;
                event.stopPropagation();
                this.delayedKeyup.push(action);
            }
        },
        mousemove: function (event) {
            var el = ig.system.canvas;
            var pos = {
                left: 0,
                top: 0
            };
            while (el != null) {
                pos.left += el.offsetLeft;
                pos.top += el.offsetTop;
                el = el.offsetParent;
            }
            var tx = event.pageX;
            var ty = event.pageY;
            if (event.touches) {
                tx = event.touches[0].clientX;
                ty = event.touches[0].clientY;
            }
            this.mouse.x = (tx - pos.left) / ig.system.scale;
            this.mouse.y = (ty - pos.top) / ig.system.scale;
        },
        contextmenu: function (event) {
            if (this.bindings[ig.KEY.MOUSE2]) {
                event.stopPropagation();
                event.preventDefault();
            }
        },
        keydown: function (event) {
            if (event.target.type == 'text') {
                return;
            }
            var code = event.type == 'keydown' ? event.keyCode : (event.button == 2 ? ig.KEY.MOUSE2 : ig.KEY.MOUSE1);
            if (event.type == 'touchstart') {
                this.mousemove(event);
            }
            var action = this.bindings[code];
            if (action) {
                this.actions[action] = true;
                event.stopPropagation();
                event.preventDefault();
            }
        },
        keyup: function (event) {
            if (event.target.type == 'text') {
                return;
            }
            var code = event.type == 'keyup' ? event.keyCode : (event.button == 2 ? ig.KEY.MOUSE2 : ig.KEY.MOUSE1);
            var action = this.bindings[code];
            if (action) {
                this.delayedKeyup.push(action);
                event.stopPropagation();
                event.preventDefault();
            }
        },
        bind: function (key, action) {
            if (key < 0) {
                this.initMouse();
            } else if (key > 0) {
                this.initKeyboard();
            }
            this.bindings[key] = action;
        },
        bindTouch: function (selector, action) {
            var element = ig.$(selector);
            var that = this;
            element.addEventListener('touchstart', function (ev) {
                that.touchStart(ev, action);
            }, false);
            element.addEventListener('touchend', function (ev) {
                that.touchEnd(ev, action);
            }, false);
        },
        unbind: function (key) {
            this.bindings[key] = null;
        },
        unbindAll: function () {
            this.bindings = [];
        },
        state: function (action) {
            return this.actions[action];
        },
        pressed: function (action) {
            if (!this.locks[action] && this.actions[action]) {
                this.locks[action] = true;
                return true;
            } else {
                return false;
            }
        },
        clearPressed: function () {
            for (var i = 0; i < this.delayedKeyup.length; i++) {
                var action = this.delayedKeyup[i];
                this.locks[action] = false;
                this.actions[action] = false;
            }
            this.delayedKeyup = [];
        },
        touchStart: function (event, action) {
            this.actions[action] = true;
            event.stopPropagation();
            event.preventDefault();
            return false;
        },
        touchEnd: function (event, action) {
            this.delayedKeyup.push(action);
            event.stopPropagation();
            event.preventDefault();
            return false;
        }
    });
});

// lib/impact/impact.js
ig.baked = true;
ig.module('impact.impact').requires('dom.ready', 'impact.loader', 'impact.system', 'impact.input', 'impact.sound').defines(function () {
    ig.main = function (canvasId, gameClass, fps, width, height, scale, loaderClass) {
        ig.system = new ig.System(canvasId, fps, width, height, scale || 1);
        ig.input = new ig.Input();
        ig.soundManager = new ig.SoundManager();
        ig.music = new ig.Music();
        ig.ready = true;
        var loader = new(loaderClass || ig.Loader)(gameClass, ig.resources);
        loader.load();
    };
});

// lib/impact/animation.js
ig.baked = true;
ig.module('impact.animation').requires('impact.timer', 'impact.image').defines(function () {
    ig.AnimationSheet = ig.Class.extend({
        width: 8,
        height: 8,
        image: null,
        init: function (path, width, height) {
            this.width = width;
            this.height = height;
            this.image = new ig.Image(path);
        }
    });
    ig.Animation = ig.Class.extend({
        sheet: null,
        timer: null,
        sequence: [],
        flip: {
            x: false,
            y: false
        },
        pivot: {
            x: 0,
            y: 0
        },
        frame: 0,
        tile: 0,
        loopCount: 0,
        alpha: 1,
        angle: 0,
        init: function (sheet, frameTime, sequence, stop) {
            this.sheet = sheet;
            this.pivot = {
                x: sheet.width / 2,
                y: sheet.height / 2
            };
            this.timer = new ig.Timer();
            this.frameTime = frameTime;
            this.sequence = sequence;
            this.stop = !! stop;
        },
        rewind: function () {
            this.timer.reset();
            this.loopCount = 0;
            this.tile = this.sequence[0];
            return this;
        },
        gotoFrame: function (f) {
            this.timer.set(this.frameTime * -f);
            this.update();
        },
        gotoRandomFrame: function () {
            this.gotoFrame((Math.random() * this.sequence.length).floor())
        },
        update: function () {
            var frameTotal = (this.timer.delta() / this.frameTime).floor();
            this.loopCount = (frameTotal / this.sequence.length).floor();
            if (this.stop && this.loopCount > 0) {
                this.frame = this.sequence.length - 1;
            } else {
                this.frame = frameTotal % this.sequence.length;
            }
            this.tile = this.sequence[this.frame];
        },
        draw: function (targetX, targetY) {
            var bbsize = Math.max(this.sheet.width, this.sheet.height);
            if (targetX > ig.system.width || targetY > ig.system.height || targetX + bbsize < 0 || targetY + bbsize < 0) {
                return;
            }
            if (this.alpha != 1) {
                ig.system.context.globalAlpha = this.alpha;
            }
            if (this.angle == 0) {
                this.sheet.image.drawTile(targetX, targetY, this.tile, this.sheet.width, this.sheet.height, this.flip.x, this.flip.y);
            } else {
                ig.system.context.save();
                ig.system.context.translate(ig.system.getDrawPos(targetX + this.pivot.x), ig.system.getDrawPos(targetY + this.pivot.y));
                ig.system.context.rotate(this.angle);
                this.sheet.image.drawTile(-this.pivot.x, -this.pivot.y, this.tile, this.sheet.width, this.sheet.height, this.flip.x, this.flip.y);
                ig.system.context.restore();
            }
            if (this.alpha != 1) {
                ig.system.context.globalAlpha = 1;
            }
        }
    });
});

// lib/impact/entity.js
ig.baked = true;
ig.module('impact.entity').requires('impact.animation', 'impact.impact').defines(function () {
    ig.Entity = ig.Class.extend({
        id: 0,
        settings: {},
        size: {
            x: 16,
            y: 16
        },
        offset: {
            x: 0,
            y: 0
        },
        pos: {
            x: 0,
            y: 0
        },
        last: {
            x: 0,
            y: 0
        },
        vel: {
            x: 0,
            y: 0
        },
        accel: {
            x: 0,
            y: 0
        },
        friction: {
            x: 0,
            y: 0
        },
        maxVel: {
            x: 100,
            y: 100
        },
        zIndex: 0,
        gravityFactor: 1,
        standing: false,
        bounciness: 0,
        minBounceVelocity: 40,
        anims: {},
        animSheet: null,
        currentAnim: null,
        health: 10,
        type: 0,
        checkAgainst: 0,
        collides: 0,
        _killed: false,
        init: function (x, y, settings) {
            this.id = ++ig.Entity._lastId;
            this.pos.x = x;
            this.pos.y = y;
            ig.merge(this, settings);
        },
        addAnim: function (name, frameTime, sequence, stop) {
            if (!this.animSheet) {
                throw ('No animSheet to add the animation ' + name + ' to.');
            }
            var a = new ig.Animation(this.animSheet, frameTime, sequence, stop);
            this.anims[name] = a;
            if (!this.currentAnim) {
                this.currentAnim = a;
            }
            return a;
        },
        update: function () {
            this.last.x = this.pos.x;
            this.last.y = this.pos.y;
            this.vel.y += ig.game.gravity * ig.system.tick * this.gravityFactor;
            this.vel.x = this.getNewVelocity(this.vel.x, this.accel.x, this.friction.x, this.maxVel.x);
            this.vel.y = this.getNewVelocity(this.vel.y, this.accel.y, this.friction.y, this.maxVel.y);
            var mx = this.vel.x * ig.system.tick;
            var my = this.vel.y * ig.system.tick;
            var res = ig.game.collisionMap.trace(this.pos.x, this.pos.y, mx, my, this.size.x, this.size.y);
            this.handleMovementTrace(res);
            if (this.currentAnim) {
                this.currentAnim.update();
            }
        },
        getNewVelocity: function (vel, accel, friction, max) {
            if (accel) {
                return (vel + accel * ig.system.tick).limit(-max, max);
            } else if (friction) {
                var delta = friction * ig.system.tick;
                if (vel - delta > 0) {
                    return vel - delta;
                } else if (vel + delta < 0) {
                    return vel + delta;
                } else {
                    return 0;
                }
            }
            return vel.limit(-max, max);
        },
        handleMovementTrace: function (res) {
            this.standing = false;
            if (res.collision.y) {
                if (this.bounciness > 0 && Math.abs(this.vel.y) > this.minBounceVelocity) {
                    this.vel.y *= -this.bounciness;
                } else {
                    if (this.vel.y > 0) {
                        this.standing = true;
                    }
                    this.vel.y = 0;
                }
            }
            if (res.collision.x) {
                if (this.bounciness > 0 && Math.abs(this.vel.x) > this.minBounceVelocity) {
                    this.vel.x *= -this.bounciness;
                } else {
                    this.vel.x = 0;
                }
            }
            this.pos = res.pos;
        },
        draw: function () {
            if (this.currentAnim) {
                this.currentAnim.draw(this.pos.x.round() - this.offset.x - ig.game.screen.x, this.pos.y.round() - this.offset.y - ig.game.screen.y);
            }
        },
        kill: function () {
            ig.game.removeEntity(this);
        },
        receiveDamage: function (amount, from) {
            this.health -= amount;
            if (this.health <= 0) {
                this.kill();
            }
        },
        touches: function (other) {
            return !(this.pos.x > other.pos.x + other.size.x || this.pos.x + this.size.x < other.pos.x || this.pos.y > other.pos.y + other.size.y || this.pos.y + this.size.y < other.pos.y);
        },
        distanceTo: function (other) {
            var xd = (this.pos.x + this.size.x / 2) - (other.pos.x + other.size.x / 2);
            var yd = (this.pos.y + this.size.y / 2) - (other.pos.y + other.size.y / 2);
            return Math.sqrt(xd * xd + yd * yd);
        },
        angleTo: function (other) {
            return Math.atan2((other.pos.y + other.size.y / 2) - (this.pos.y + this.size.y / 2), (other.pos.x + other.size.x / 2) - (this.pos.x + this.size.x / 2));
        },
        check: function (other) {},
        collideWith: function (other, axis) {}
    });
    ig.Entity._lastId = 0;
    ig.Entity.COLLIDES = {
        NEVER: 0,
        LITE: 1,
        PASSIVE: 2,
        ACTIVE: 4,
        FIXED: 8
    };
    ig.Entity.TYPE = {
        NONE: 0,
        A: 1,
        B: 2,
        BOTH: 3
    };
    ig.Entity.checkPair = function (a, b) {
        if (a.checkAgainst & b.type) {
            a.check(b);
        }
        if (b.checkAgainst & a.type) {
            b.check(a);
        }
        if (a.collides && b.collides && a.collides + b.collides > ig.Entity.COLLIDES.ACTIVE) {
            ig.Entity.solveCollision(a, b);
        }
    };
    ig.Entity.solveCollision = function (a, b) {
        var weak = null;
        if (a.collides == ig.Entity.COLLIDES.LITE || b.collides == ig.Entity.COLLIDES.FIXED) {
            weak = a;
        } else if (b.collides == ig.Entity.COLLIDES.LITE || a.collides == ig.Entity.COLLIDES.FIXED) {
            weak = b;
        }
        if (a.last.x + a.size.x > b.last.x && a.last.x < b.last.x + b.size.x) {
            if (a.last.y < b.last.y) {
                ig.Entity.seperateOnYAxis(a, b, weak);
            } else {
                ig.Entity.seperateOnYAxis(b, a, weak);
            }
            a.collideWith(b, 'y');
            b.collideWith(a, 'y');
        } else if (a.last.y + a.size.y > b.last.y && a.last.y < b.last.y + b.size.y) {
            if (a.last.x < b.last.x) {
                ig.Entity.seperateOnXAxis(a, b, weak);
            } else {
                ig.Entity.seperateOnXAxis(b, a, weak);
            }
            a.collideWith(b, 'x');
            b.collideWith(a, 'x');
        }
    };
    ig.Entity.seperateOnXAxis = function (left, right, weak) {
        var nudge = (left.pos.x + left.size.x - right.pos.x);
        if (weak) {
            var strong = left === weak ? right : left;
            weak.vel.x = -weak.vel.x * weak.bounciness + strong.vel.x;
            var resWeak = ig.game.collisionMap.trace(weak.pos.x, weak.pos.y, weak == left ? -nudge : nudge, 0, weak.size.x, weak.size.y);
            weak.pos.x = resWeak.pos.x;
        } else {
            var v2 = (left.vel.x - right.vel.x) / 2;
            left.vel.x = -v2;
            right.vel.x = v2;
            var resLeft = ig.game.collisionMap.trace(left.pos.x, left.pos.y, -nudge / 2, 0, left.size.x, left.size.y);
            left.pos.x = resLeft.pos.x.floor();
            var resRight = ig.game.collisionMap.trace(right.pos.x, right.pos.y, nudge / 2, 0, right.size.x, right.size.y);
            right.pos.x = resRight.pos.x.ceil();
        }
    };
    ig.Entity.seperateOnYAxis = function (top, bottom, weak) {
        var nudge = (top.pos.y + top.size.y - bottom.pos.y);
        if (weak) {
            var strong = top === weak ? bottom : top;
            weak.vel.y = -weak.vel.y * weak.bounciness + strong.vel.y;
            var nudgeX = 0;
            if (weak == top && Math.abs(weak.vel.y - strong.vel.y) < weak.minBounceVelocity) {
                weak.standing = true;
                nudgeX = strong.vel.x * ig.system.tick;
            }
            var resWeak = ig.game.collisionMap.trace(weak.pos.x, weak.pos.y, nudgeX, weak == top ? -nudge : nudge, weak.size.x, weak.size.y);
            weak.pos.y = resWeak.pos.y;
            weak.pos.x = resWeak.pos.x;
        } else if (ig.game.gravity && (bottom.standing || top.vel.y > 0)) {
            var resTop = ig.game.collisionMap.trace(top.pos.x, top.pos.y, 0, -(top.pos.y + top.size.y - bottom.pos.y), top.size.x, top.size.y);
            top.pos.y = resTop.pos.y;
            if (top.bounciness > 0 && top.vel.y > top.minBounceVelocity) {
                top.vel.y *= -top.bounciness;
            } else {
                top.standing = true;
                top.vel.y = 0;
            }
        } else {
            var v2 = (top.vel.y - bottom.vel.y) / 2;
            top.vel.y = -v2;
            bottom.vel.y = v2;
            var nudgeX = bottom.vel.x * ig.system.tick;
            var resTop = ig.game.collisionMap.trace(top.pos.x, top.pos.y, nudgeX, -nudge / 2, top.size.x, top.size.y);
            top.pos.y = resTop.pos.y;
            var resBottom = ig.game.collisionMap.trace(bottom.pos.x, bottom.pos.y, 0, nudge / 2, bottom.size.x, bottom.size.y);
            bottom.pos.y = resBottom.pos.y;
        }
    };
});

// lib/impact/map.js
ig.baked = true;
ig.module('impact.map').defines(function () {
    ig.Map = ig.Class.extend({
        tilesize: 8,
        width: 1,
        height: 1,
        data: [
            []
        ],
        init: function (tilesize, data) {
            this.tilesize = tilesize;
            this.data = data;
            this.height = data.length;
            this.width = data[0].length;
        },
        getTile: function (x, y) {
            var tx = (x / this.tilesize).floor();
            var ty = (y / this.tilesize).floor();
            if ((tx >= 0 && tx < this.width) && (ty >= 0 && ty < this.height)) {
                return this.data[ty][tx];
            } else {
                return 0;
            }
        },
        setTile: function (x, y, tile) {
            var tx = (x / this.tilesize).floor();
            var ty = (y / this.tilesize).floor();
            if ((tx >= 0 && tx < this.width) && (ty >= 0 && ty < this.height)) {
                this.data[ty][tx] = tile;
            }
        }
    });
});

// lib/impact/collision-map.js
ig.baked = true;
ig.module('impact.collision-map').requires('impact.map').defines(function () {
    ig.CollisionMap = ig.Map.extend({
        firstSolidTile: 1,
        lastSolidTile: 255,
        init: function (tilesize, data) {
            this.parent(tilesize, data);
        },
        trace: function (x, y, vx, vy, objectWidth, objectHeight) {
            var res = {
                collision: {
                    x: false,
                    y: false
                },
                pos: {
                    x: x,
                    y: y
                },
                tile: {
                    x: 0,
                    y: 0
                }
            };
            var steps = (Math.max(Math.abs(vx), Math.abs(vy)) / this.tilesize).ceil();
            if (steps > 1) {
                var sx = vx / steps;
                var sy = vy / steps;
                for (var i = 0; i < steps && (sx || sy); i++) {
                    this._traceStep(res, x, y, sx, sy, objectWidth, objectHeight);
                    x = res.pos.x;
                    y = res.pos.y;
                    if (res.collision.x) {
                        sx = 0;
                    }
                    if (res.collision.y) {
                        sy = 0;
                    }
                }
            } else {
                this._traceStep(res, x, y, vx, vy, objectWidth, objectHeight);
            }
            return res;
        },
        _traceStep: function (res, x, y, vx, vy, width, height) {
            res.pos.x += vx;
            res.pos.y += vy;
            if (vx) {
                var pxOffsetX = (vx > 0 ? width : 0);
                var tileOffsetX = (vx < 0 ? this.tilesize : 0);
                var firstTileY = (y / this.tilesize).floor();
                var lastTileY = ((y + height) / this.tilesize).ceil();
                var tileX = ((x + vx + pxOffsetX) / this.tilesize).floor();
                if (lastTileY >= 0 && firstTileY < this.height && tileX >= 0 && tileX < this.width) {
                    for (var tileY = firstTileY; tileY < lastTileY; tileY++) {
                        var t = this.data[tileY] && this.data[tileY][tileX];
                        if (t >= this.firstSolidTile && t <= this.lastSolidTile) {
                            res.collision.x = true;
                            res.tile.x = t;
                            res.pos.x = tileX * this.tilesize - pxOffsetX + tileOffsetX;
                            break;
                        }
                    }
                }
            }
            if (vy) {
                var pxOffsetY = (vy > 0 ? height : 0);
                var tileOffsetY = (vy < 0 ? this.tilesize : 0);
                var firstTileX = (res.pos.x / this.tilesize).floor();
                var lastTileX = ((res.pos.x + width) / this.tilesize).ceil();
                var tileY = ((y + vy + pxOffsetY) / this.tilesize).floor();
                if (lastTileX >= 0 && firstTileX < this.width && tileY >= 0 && tileY < this.height) {
                    for (var tileX = firstTileX; tileX < lastTileX; tileX++) {
                        var t = this.data[tileY] && this.data[tileY][tileX];
                        if (t >= this.firstSolidTile && t <= this.lastSolidTile) {
                            res.collision.y = true;
                            res.tile.y = t;
                            res.pos.y = tileY * this.tilesize - pxOffsetY + tileOffsetY;
                            break;
                        }
                    }
                }
            }
        }
    });
    ig.CollisionMap.staticNoCollision = {
        trace: function (x, y, vx, vy) {
            return {
                collision: {
                    x: false,
                    y: false
                },
                pos: {
                    x: x + vx,
                    y: y + vy
                },
                tile: {
                    x: 0,
                    y: 0
                }
            };
        }
    };
});

// lib/impact/background-map.js
ig.baked = true;
ig.module('impact.background-map').requires('impact.map', 'impact.image').defines(function () {
    ig.BackgroundMap = ig.Map.extend({
        tiles: null,
        scroll: {
            x: 0,
            y: 0
        },
        distance: 1,
        repeat: false,
        tilesetName: '',
        preRender: false,
        preRenderedChunks: null,
        chunkSize: 512,
        debugChunks: false,
        anims: {},
        init: function (tilesize, data, tileset) {
            this.parent(tilesize, data);
            this.setTileset(tileset);
        },
        setTileset: function (tileset) {
            this.tilesetName = tileset instanceof ig.Image ? tileset.path : tileset;
            this.tiles = new ig.Image(this.tilesetName);
            this.preRenderedChunks = null;
        },
        setScreenPos: function (x, y) {
            this.scroll.x = x / this.distance;
            this.scroll.y = y / this.distance;
        },
        preRenderMapToChunks: function () {
            var totalWidth = this.width * this.tilesize * ig.system.scale,
                totalHeight = this.height * this.tilesize * ig.system.scale;
            var chunkCols = (totalWidth / this.chunkSize).ceil(),
                chunkRows = (totalHeight / this.chunkSize).ceil();
            this.preRenderedChunks = [];
            for (var y = 0; y < chunkRows; y++) {
                this.preRenderedChunks[y] = [];
                for (var x = 0; x < chunkCols; x++) {
                    var chunkWidth = (x == chunkCols - 1) ? totalWidth - x * this.chunkSize : this.chunkSize;
                    var chunkHeight = (y == chunkRows - 1) ? totalHeight - y * this.chunkSize : this.chunkSize;
                    this.preRenderedChunks[y][x] = this.preRenderChunk(x, y, chunkWidth, chunkHeight);
                }
            }
        },
        preRenderChunk: function (cx, cy, w, h) {
            var tw = w / this.tilesize / ig.system.scale + 1;
            th = h / this.tilesize / ig.system.scale + 1;
            var nx = (cx * this.chunkSize / ig.system.scale) % this.tilesize,
                ny = (cy * this.chunkSize / ig.system.scale) % this.tilesize;
            var tx = (cx * this.chunkSize / this.tilesize / ig.system.scale).floor(),
                ty = (cy * this.chunkSize / this.tilesize / ig.system.scale).floor();
            var chunk = ig.$new('canvas');
            chunk.width = w;
            chunk.height = h;
            var oldContext = ig.system.context;
            ig.system.context = chunk.getContext("2d");
            for (var x = 0; x < tw; x++) {
                for (var y = 0; y < th; y++) {
                    if (x + tx < this.width && y + ty < this.height) {
                        var tile = this.data[y + ty][x + tx];
                        if (tile) {
                            this.tiles.drawTile(x * this.tilesize - nx, y * this.tilesize - ny, tile - 1, this.tilesize);
                        }
                    }
                }
            }
            ig.system.context = oldContext;
            return chunk;
        },
        draw: function () {
            if (!this.tiles.loaded) {
                return;
            }
            if (this.preRender) {
                this.drawPreRendered();
            } else {
                this.drawTiled();
            }
        },
        drawPreRendered: function () {
            if (!this.preRenderedChunks) {
                this.preRenderMapToChunks();
            }
            var dx = ig.system.getDrawPos(this.scroll.x),
                dy = ig.system.getDrawPos(this.scroll.y);
            if (this.repeat) {
                dx %= this.width * this.tilesize * ig.system.scale;
                dy %= this.height * this.tilesize * ig.system.scale;
            }
            var minChunkX = Math.max((dx / this.chunkSize).floor(), 0),
                minChunkY = Math.max((dy / this.chunkSize).floor(), 0),
                maxChunkX = ((dx + ig.system.realWidth) / this.chunkSize).ceil(),
                maxChunkY = ((dy + ig.system.realHeight) / this.chunkSize).ceil(),
                maxRealChunkX = this.preRenderedChunks[0].length,
                maxRealChunkY = this.preRenderedChunks.length;
            if (!this.repeat) {
                maxChunkX = Math.min(maxChunkX, maxRealChunkX);
                maxChunkY = Math.min(maxChunkY, maxRealChunkY);
            }
            var nudgeY = 0;
            for (var cy = minChunkY; cy < maxChunkY; cy++) {
                var nudgeX = 0;
                for (var cx = minChunkX; cx < maxChunkX; cx++) {
                    var chunk = this.preRenderedChunks[cy % maxRealChunkY][cx % maxRealChunkX];
                    var x = -dx + cx * this.chunkSize - nudgeX;
                    var y = -dy + cy * this.chunkSize - nudgeY;
                    ig.system.context.drawImage(chunk, x, y);
                    if (this.debugChunks) {
                        ig.system.context.strokeStyle = '#f0f';
                        ig.system.context.strokeRect(x, y, this.chunkSize, this.chunkSize);
                    }
                    if (this.repeat && chunk.width < this.chunkSize && x + chunk.width < ig.system.realWidth) {
                        nudgeX = this.chunkSize - chunk.width;
                        maxChunkX++;
                    }
                }
                if (this.repeat && chunk.height < this.chunkSize && y + chunk.height < ig.system.realHeight) {
                    nudgeY = this.chunkSize - chunk.height;
                    maxChunkY++;
                }
            }
        },
        drawTiled: function () {
            var tile = 0,
                anim = null,
                tileOffsetX = (this.scroll.x / this.tilesize).toInt(),
                tileOffsetY = (this.scroll.y / this.tilesize).toInt(),
                pxOffsetX = this.scroll.x % this.tilesize,
                pxOffsetY = this.scroll.y % this.tilesize,
                pxMinX = -pxOffsetX - this.tilesize,
                pxMinY = -pxOffsetY - this.tilesize,
                pxMaxX = ig.system.width + this.tilesize - pxOffsetX,
                pxMaxY = ig.system.height + this.tilesize - pxOffsetY;
            for (var mapY = -1, pxY = pxMinY; pxY < pxMaxY; mapY++, pxY += this.tilesize) {
                var tileY = mapY + tileOffsetY;
                if (tileY >= this.height || tileY < 0) {
                    if (!this.repeat) {
                        continue;
                    }
                    tileY = tileY > 0 ? tileY % this.height : ((tileY + 1) % this.height) + this.height - 1;
                }
                for (var mapX = -1, pxX = pxMinX; pxX < pxMaxX; mapX++, pxX += this.tilesize) {
                    var tileX = mapX + tileOffsetX;
                    if (tileX >= this.width || tileX < 0) {
                        if (!this.repeat) {
                            continue;
                        }
                        tileX = tileX > 0 ? tileX % this.width : ((tileX + 1) % this.width) + this.width - 1;
                    }
                    if ((tile = this.data[tileY][tileX])) {
                        if ((anim = this.anims[tile - 1])) {
                            anim.draw(pxX, pxY);
                        } else {
                            this.tiles.drawTile(pxX, pxY, tile - 1, this.tilesize);
                        }
                    }
                }
            }
        }
    });
});

// lib/impact/game.js
ig.baked = true;
ig.module('impact.game').requires('impact.impact', 'impact.entity', 'impact.collision-map', 'impact.background-map').defines(function () {
    ig.Game = ig.Class.extend({
        clearColor: '#000000',
        gravity: 0,
        screen: {
            x: 0,
            y: 0
        },
        entities: [],
        components: [],
        namedEntities: {},
        collisionMap: ig.CollisionMap.staticNoCollision,
        backgroundMaps: [],
        backgroundAnims: {},
        cellSize: 64,
        _deferredKill: [],
        _levelToLoad: null,
        loadLevel: function (data) {
            this.screen = {
                x: 0,
                y: 0
            };
            this.entities = [];
            this.namedEntities = {};
            for (var i = 0; i < data.entities.length; i++) {
                var ent = data.entities[i];
                this.spawnEntity(ent.type, ent.x, ent.y, ent.settings);
            }
            this.sortEntities();
            this.collisionMap = null;
            this.backgroundMaps = [];
            for (var i = 0; i < data.layer.length; i++) {
                var ld = data.layer[i];
                if (ld.name == 'collision') {
                    this.collisionMap = new ig.CollisionMap(ld.tilesize, ld.data);
                } else {
                    var newMap = new ig.BackgroundMap(ld.tilesize, ld.data, ld.tilesetName);
                    newMap.anims = this.backgroundAnims[ld.tilesetName] || {};
                    newMap.repeat = ld.repeat;
                    newMap.distance = ld.distance;
                    this.backgroundMaps.push(newMap);
                }
            }
        },
        loadLevelDeferred: function (data) {
            this._levelToLoad = data;
        },
        getEntityByName: function (name) {
            return this.namedEntities[name];
        },
        getEntitiesByType: function (type) {
            var entityClass = typeof (type) === 'string' ? ig.global[type] : type;
            var a = [];
            for (var i = 0; i < this.entities.length; i++) {
                var ent = this.entities[i];
                if (ent instanceof entityClass && !ent._killed) {
                    a.push(ent);
                }
            }
            return a;
        },
        spawnEntity: function (type, x, y, settings) {
            var entityClass = typeof (type) === 'string' ? ig.global[type] : type;
            if (!entityClass) {
                throw ("Can't spawn entity of type " + type);
            }
            var ent = new(entityClass)(x, y, settings || {});
            this.entities.push(ent);
            if (ent.name) {
                this.namedEntities[ent.name] = ent;
            }
            return ent;
        },
        getComponentsByType: function (type) {
            var componentClass = typeof (type) === 'string' ? ig.global[type] : type;
            var a = [];
            for (var i = 0; i < this.components.length; i++) {
                var com = this.components[i];
                if (com instanceof componentClass) {
                    a.push(com);
                }
            }
            return a;
        },
        spawnComponent: function (type, arrParams) {
            var componentClass = typeof (type) === 'string' ? ig.global[type] : type;
            if (!componentClass) {
                throw ("Can't spawn class of type " + type);
            }
            var com = new(componentClass)(arrParams);
            this.components.push(com);
            return com;
        },
        removeComponent: function (com) {
            this.components.erase(com);
        },
        sortEntities: function () {
            this.entities.sort(function (a, b) {
                if (a.zIndex != b.zIndex) return a.zIndex - b.zIndex;
                else return a.id - b.id;
            });
        },
        sortComponents: function () {
            this.components.sort(function (a, b) {
                return a.zIndex - b.zIndex;
            });
        },
        removeEntity: function (ent) {
            if (ent.name) {
                delete this.namedEntities[ent.name];
            }
            ent._killed = true;
            ent.checkAgainst = ig.Entity.TYPE.NONE;
            ent.collides = ig.Entity.COLLIDES.NEVER;
            this._deferredKill.push(ent);
        },
        run: function () {
            this.update();
            this.draw();
        },
        update: function () {
            if (this._levelToLoad) {
                this.loadLevel(this._levelToLoad);
                this._levelToLoad = null;
            }
            this.sortEntities();
            this.sortComponents();
            for (var i = 0; i < this.entities.length; i++) {
                var ent = this.entities[i];
                if (!ent._killed) {
                    ent.update();
                }
            }
            this.checkEntities();
            for (var i = 0; i < this._deferredKill.length; i++) {
                this.entities.erase(this._deferredKill[i]);
            }
            this._deferredKill = [];
            for (var i = 0; i < this.components.length; i++) {
                var com = this.components[i];
                com.update();
            }
            for (var tileset in this.backgroundAnims) {
                var anims = this.backgroundAnims[tileset];
                for (var a in anims) {
                    anims[a].update();
                }
            }
            for (var i = 0; i < this.backgroundMaps.length; i++) {
                this.backgroundMaps[i].setScreenPos(this.screen.x, this.screen.y);
            }
        },
        draw: function () {
            ig.system.clear(this.clearColor);
            for (var i = 0; i < this.backgroundMaps.length; i++) {
                this.backgroundMaps[i].draw();
            }
            for (var i = 0; i < this.components.length; i++) {
                this.components[i].draw();
            }
            for (var i = 0; i < this.entities.length; i++) {
                if (!this.entities[i]._killed) this.entities[i].draw();
            }
        },
        checkEntities: function () {
            var hash = {};
            for (var e = 0; e < this.entities.length; e++) {
                var entity = this.entities[e];
                if (e.type == ig.Entity.TYPE.NONE && e.checkAgainst == ig.Entity.TYPE.NONE && e.collides == ig.Entity.COLLIDES.NEVER) {
                    continue;
                }
                var checked = {}, xmin = (entity.pos.x / this.cellSize).floor(),
                    ymin = (entity.pos.y / this.cellSize).floor(),
                    xmax = ((entity.pos.x + entity.size.x) / this.cellSize).floor() + 1,
                    ymax = ((entity.pos.y + entity.size.y) / this.cellSize).floor() + 1;
                for (var x = xmin; x < xmax; x++) {
                    for (var y = ymin; y < ymax; y++) {
                        if (!hash[x]) {
                            hash[x] = {};
                            hash[x][y] = [entity];
                        } else if (!hash[x][y]) {
                            hash[x][y] = [entity];
                        } else {
                            var cell = hash[x][y];
                            for (var c = 0; c < cell.length; c++) {
                                if (entity.touches(cell[c]) && !checked[cell[c].id]) {
                                    checked[cell[c].id] = true;
                                    ig.Entity.checkPair(entity, cell[c]);
                                }
                            }
                            cell.push(entity);
                        }
                    }
                }
            }
        }
    });
});

// lib/game/customlib/component.js
ig.baked = true;
ig.module('game.customlib.component').defines(function () {
    Component = ig.Class.extend({
        arrParams: [],
        zIndex: 0,
        init: function (arrParams) {
            if (arrParams == null) return;
            for (var i = 0; i < arrParams.length; i++) {
                this.arrParams[i] = arrParams[i];
            }
        },
        update: function () {},
        draw: function () {},
        destroy: function () {
            ig.game.removeComponent(this);
        },
        checkCursorInArea: function (x, y, left, top, width, height) {
            if (x > left && x < left + width && y > top && y < top + height) return true;
            else return false;
        },
    });
});

// lib/game/customlib/graphics.js
ig.baked = true;
ig.module('game.customlib.graphics')
ig.requires('impact.system').defines(function () {
    Graphics = ig.Class.extend({
        init: function () {
            ig.system.context.strokeStyle = '0xffffff';
            ig.system.context.fillStyle = '0xffffff';
        },
        drawLine: function (x1, y1, x2, y2) {
            ig.system.context.beginPath();
            ig.system.context.moveTo(x1, y1);
            ig.system.context.lineTo(x2, y2);
            ig.system.context.stroke();
        },
        fillRect: function (left, top, width, height) {
            ig.system.context.fillRect(left, top, width, height);
        },
        setColor: function (color) {
            ig.system.context.strokeStyle = color;
        },
        setFillColor: function (color) {
            ig.system.context.fillStyle = color;
        }
    });
});

// lib/game/src/config.js
ig.baked = true;
ig.module('game.src.config').defines(function () {
    Config = ig.Class.extend({});
    Config.STATE_SPLASH = 0;
    Config.STATE_COVER = 10;
    Config.STATE_MAIN_MENU = 20;
    Config.STATE_INSTRUCTION = 30;
    Config.STATE_HELP = 40;
    Config.STATE_HIGH_SCORE = 50;
    Config.STATE_ABOUT = 60;
    Config.STATE_MORE_GAME = 70;
    Config.STATE_GAME_READY = 75;
    Config.STATE_GAME_SWING = 80;
    Config.STATE_GAME_DROP = 90;
    Config.STATE_GAME_QUIT = 100;
    Config.STATE_ENTER_NAME = 110;
    Config.STATE_GAME_OVER = 120;
    Config.STATE_LEVEL_COMPLETE = 130;
    Config.MAX_HIGHSCORE_COUNT = 10;
    Config.biPad = false;

    if (ig.ua.iPhone4 || ig.ua.iPhone) {
        if (ig.ua.viewport.height == 480 || ig.ua.viewport.height == 320) {
            Config.TOP_BAR_HEIGHT = 0;
        } else {
            Config.TOP_BAR_HEIGHT = -30;
        }
    } else {
        Config.TOP_BAR_HEIGHT = 0;
    }
    if (!Config.biPad) {
        Config.PATH_MEDIA = '../media/iphone/';
        Config.PATH_MEDIA_L10N = 'media/iphone/';
        Config.PATH_IMG_SPLASH = Config.PATH_MEDIA + 'bg_splash.jpg';
        Config.PATH_IMG_COVER = Config.PATH_MEDIA_L10N + 'bg_cover.jpg';
        Config.PATH_IMG_MENUBACK = Config.PATH_MEDIA + 'bg_mainmenu.jpg';
        Config.PATH_IMG_GAMEBACK = Config.PATH_MEDIA + 'bg_game.jpg';
        Config.PATH_IMG_OVERLAYBACK = Config.PATH_MEDIA + 'bg_overlay.png';
        Config.PATH_IMG_START_BUTTON = Config.PATH_MEDIA + 'btn_startgame.png';
        Config.PATH_IMG_HELP_BUTTON = Config.PATH_MEDIA + 'btn_help.png';
        Config.PATH_IMG_HIGHSCORE_BUTTON = Config.PATH_MEDIA + 'btn_highscore.png';
        Config.PATH_IMG_ABOUT_BUTTON = Config.PATH_MEDIA + 'btn_about.png';
        Config.PATH_IMG_MOREGAME_BUTTON = Config.PATH_MEDIA + 'btn_moregames.png';
        Config.PATH_IMG_ENTERHIGHSCORE_BUTTON = Config.PATH_MEDIA_L10N + 'btn_enterhighscore.png';
        Config.PATH_IMG_PLAYAGAIN_BUTTON = Config.PATH_MEDIA + 'btn_playagain.png';
        Config.PATH_IMG_BACK_BUTTON = Config.PATH_MEDIA_L10N + 'btn_back.png';
        Config.PATH_IMG_NEXT_BUTTON = Config.PATH_MEDIA_L10N + 'btn_next.png';
        Config.PATH_IMG_INSTRUCTION_BUTTON = Config.PATH_MEDIA + 'btn_instructions.png';
        Config.PATH_IMG_QUIT_BUTTON = Config.PATH_MEDIA + 'btn_quit.png';
        Config.PATH_IMG_INSTRUCTION_TEXT = Config.PATH_MEDIA + 'txt_help.png';
        Config.PATH_IMG_HELP_TEXT = Config.PATH_MEDIA_L10N + 'txt_help.png';
        Config.PATH_IMG_ABOUT_TEXT = Config.PATH_MEDIA + 'txt_about.png';
        Config.PATH_IMG_GAMEOVER_TEXT = Config.PATH_MEDIA_L10N + 'txt_gameover.png';
        Config.PATH_IMG_LEVEL_TEXT = Config.PATH_MEDIA + 'txt_level.png';
        Config.PATH_IMG_SCORE_TEXT = Config.PATH_MEDIA_L10N + 'txt_score.png';
        Config.PATH_IMG_LEVELCOMPLETE_TEXT = Config.PATH_MEDIA + 'txt_levelcomplete.png';
        Config.PATH_IMG_TOTALSCORE_TEXT = Config.PATH_MEDIA + 'txt_totalscore.png';
        Config.PATH_IMG_SUPER_TEXT = Config.PATH_MEDIA + 'txt_super.png';
        Config.PATH_IMG_TAPSCREEN_TEXT = Config.PATH_MEDIA_L10N + 'txt_tapscreen.png';
        Config.PATH_IMG_HIGHSCORE_BOX = Config.PATH_MEDIA + 'box_highscore.png';
        Config.PATH_IMG_DEFAULT_BOX = Config.PATH_MEDIA + 'box_default.png';
        Config.PATH_IMG_QUIT_BOX = Config.PATH_MEDIA_L10N + 'box_quit.png';
        Config.PATH_IMG_HELP_BOX = Config.PATH_MEDIA_L10N + 'box_help.png';
        Config.PATH_IMG_ATTACHER_ENT = Config.PATH_MEDIA + 'ent_attacher.png';
        Config.PATH_IMG_LINE_ENT = Config.PATH_MEDIA + 'ent_line.png';
        Config.PATH_IMG_RED_BLOCK_ENT = Config.PATH_MEDIA + 'ent_red_block.png';
        Config.PATH_IMG_STAND_ENT = Config.PATH_MEDIA + 'ent_greenback.png';
        Config.PATH_IMG_CLOUD1_ENT = Config.PATH_MEDIA + 'ent_cloud1.png';
        Config.PATH_IMG_CLOUD2_ENT = Config.PATH_MEDIA + 'ent_cloud2.png';
        Config.PATH_IMG_CLOUD3_ENT = Config.PATH_MEDIA + 'ent_cloud3.png';
        Config.PATH_IMG_STAR1_ENT = Config.PATH_MEDIA + 'ent_star1.png';
        Config.PATH_IMG_STAR2_ENT = Config.PATH_MEDIA + 'ent_star2.png';
        Config.PATH_IMG_LIFE_ENT = Config.PATH_MEDIA + 'ent_life.png';
        Config.PATH_IMG_BLOCKSHADOW_ENT = Config.PATH_MEDIA + 'ent_blockshadow.png';
        Config.PATH_IMG_STARS_ANIM = Config.PATH_MEDIA + 'anim_stars.png';
        Config.PATH_IMG_WAVE_ANIM = Config.PATH_MEDIA + 'anim_wave.png';
        Config.PATH_IMG_RED_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_red_block.png';
        Config.PATH_IMG_BLUE_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_blue_block.png';
        Config.PATH_IMG_CYAN_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_cyan_block.png';
        Config.PATH_IMG_GREEN_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_green_block.png';
        Config.PATH_IMG_LIME_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_lime_block.png';
        Config.PATH_IMG_PINK_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_pink_block.png';
        Config.PATH_IMG_PURPLE_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_purple_block.png';
        Config.PATH_IMG_YELLOW_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_yellow_block.png';
        Config.PATH_IMG_SMALL_BLOCKS = [];
        Config.PATH_IMG_SMALL_BLOCKS[0] = Config.PATH_MEDIA + 'ent_red_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[1] = Config.PATH_MEDIA + 'ent_blue_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[2] = Config.PATH_MEDIA + 'ent_cyan_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[3] = Config.PATH_MEDIA + 'ent_green_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[4] = Config.PATH_MEDIA + 'ent_lime_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[5] = Config.PATH_MEDIA + 'ent_pink_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[6] = Config.PATH_MEDIA + 'ent_purple_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[7] = Config.PATH_MEDIA + 'ent_yellow_small_block.png';
        Config.PATH_FONT_HIGHSCORE = Config.PATH_MEDIA + 'font_highscore.png';
        Config.PATH_FONT_BLOCKCOUNT = Config.PATH_MEDIA + 'font_blockcount.png';
        Config.PATH_FONT_SCORE = Config.PATH_MEDIA + 'font_score.png';
        Config.SCREEN_WIDTH = 320;
        Config.SCREEN_HEIGHT = 480;
        Config.TIME_SPLASH = 2;
        Config.TIME_LEVEL = 1;
        Config.TIME_OVER = 2;
        Config.ENTERNAME_INTENT = 0;
        Config.ENTERNAME_REAL_VALUE = -50;
        Config.MENU_ITEM_POSX = 55;
        Config.LETTER_SIZE = 14;
        Config.POS_ENTERNAME = {
            x: Config.SCREEN_WIDTH / 2,
            y: 230 + Config.TOP_BAR_HEIGHT
        };
        Config.MENU_ITEM_SIZE = {
            x: 216,
            y: 65
        };
        Config.SIZE_IMG_YES_BUTTON = {
            x: 41,
            y: 17
        };
        Config.SIZE_IMG_NO_BUTTON = {
            x: 32,
            y: 17
        };
        Config.SIZE_LINE_ENT = {
            x: 8,
            y: 366
        };
        Config.SIZE_ATTACHER_ENT = {
            x: 36,
            y: 27
        };
        Config.SIZE_CLOUD1_ENT = {
            x: 66,
            y: 44
        };
        Config.SIZE_CLOUD2_ENT = {
            x: 89,
            y: 68
        };
        Config.SIZE_CLOUD3_ENT = {
            x: 118,
            y: 89
        };
        Config.SIZE_STAR1_ENT = {
            x: 72,
            y: 72
        };
        Config.SIZE_STAR2_ENT = {
            x: 91,
            y: 91
        };
        Config.SIZE_STAND_ENT = {
            x: 320,
            y: 135
        };
        Config.SIZE_BLOCKSPARK_ENT = {
            x: 113,
            y: 94
        };
        Config.SIZE_WAVE_ENT = {
            x: 119,
            y: 52
        };
        Config.SIZE_BLOCK_ENT = {
            x: 82,
            y: 69
        };
        Config.SIZE_BLOCK_DEFAULT_ENT = {
            x: 66,
            y: 64
        };
        Config.SIZE_BLOCKS_ENT = [];
        Config.SIZE_BLOCKS_ENT[0] = {
            x: 66,
            y: 64
        };
        Config.SIZE_BLOCKS_ENT[1] = {
            x: 62,
            y: 69
        };
        Config.SIZE_BLOCKS_ENT[2] = {
            x: 62,
            y: 69
        };
        Config.SIZE_BLOCKS_ENT[3] = {
            x: 66,
            y: 62
        };
        Config.SIZE_BLOCKS_ENT[4] = {
            x: 82,
            y: 58
        };
        Config.SIZE_BLOCKS_ENT[5] = {
            x: 82,
            y: 58
        };
        Config.SIZE_BLOCKS_ENT[6] = {
            x: 66,
            y: 64
        };
        Config.SIZE_BLOCKS_ENT[7] = {
            x: 62,
            y: 69
        };
        Config.SIZE_BLOCKS_ENT[8] = {
            x: 68,
            y: 62
        };
        Config.SIZE_BLOCKS_ENT[9] = {
            x: 82,
            y: 58
        };
        Config.SIZE_BLOCKS_ENT[10] = {
            x: 79,
            y: 64
        };
        Config.SIZE_BLOCKS_ENT[11] = {
            x: 66,
            y: 64
        };
        Config.SIZE_INPUTBOX = {
            x: 320,
            y: 250
        };
        Config.SEQ_BLOCKSPARK_ANIM = [0, 1, 2, 3, 4];
        Config.SEQ_WAVE_ANIM = [0, 1, 2, 3];
        Config.POS_IMG_START_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 80 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_HELP_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 138 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_HIGHSCORE_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 198 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_ABOUT_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 260 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_MOREGAME_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 320 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_ENTERHIGHSCORE_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 228 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_PLAYAGAIN_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 314 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_BACK_BUTTON = {
            x: 5,
            y: 410 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_NEXT_BUTTON = {
            x: 263,
            y: 413 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_DEFAULT_BUTTON = {
            x: 55,
            y: 45 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_QUIT_BUTTON = {
            x: 296,
            y: 450 + Config.TOP_BAR_HEIGHT * 2
        };
        Config.POS_LEVELCOMPLETE_TEXT = {
            x: 80,
            y: 200 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_GAMEOVER_TEXT = {
            x: 82,
            y: 155 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_LEVEL_TEXT = {
            x: 100,
            y: 200 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_TOTALSCORE_TEXT = {
            x: 80,
            y: 110 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_INSTRUCTION_TEXT = {
            x: 20,
            y: 140 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_HELP_TEXT = {
            x: 20,
            y: 140 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_ABOUT_TEXT = {
            x: 20,
            y: 170 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_TAPSCREEN_TEXT = {
            x: 76,
            y: 20 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_HIGHSCORE_BOX = {
            x: 30,
            y: 100 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_DEFAULT_BOX = {
            x: 30,
            y: 130 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_DEFAULT_BOX2 = {
            x: 30,
            y: 130 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_QUIT_BOX = {
            x: 58,
            y: 167 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_HELP_BOX = {
            x: 26,
            y: 130 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_YES_BUTTON = {
            x: Config.POS_QUIT_BOX.x + 31,
            y: Config.POS_QUIT_BOX.y + 90
        };
        Config.POS_IMG_NO_BUTTON = {
            x: Config.POS_QUIT_BOX.x + 142,
            y: Config.POS_QUIT_BOX.y + 90
        };
        Config.POS_SCORE_STRING = {
            x: 258,
            y: 19 + Config.TOP_BAR_HEIGHT / 2
        };
        Config.POS_LEVEL_STRING = {
            x: 180,
            y: 197 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_BLOCKCOUNT_STRING = {
            x: 40,
            y: 340 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_TOTALSCORE_STRING = {
            x: 140,
            y: 160 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_LIFE_ENT = {
            x: 30,
            y: 19 + Config.TOP_BAR_HEIGHT / 2
        };
        Config.POS_SMALLBLOCKS_ENT = {
            x: 27,
            y: 365 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_START_SCORE_NUM = {
            x: Config.POS_HIGHSCORE_BOX.x + 30,
            y: 0 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_START_SCORE_NAME = {
            x: Config.POS_HIGHSCORE_BOX.x + 80,
            y: 0 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_START_SCORE = {
            x: Config.POS_HIGHSCORE_BOX.x + 180,
            y: 0 + Config.TOP_BAR_HEIGHT
        };
        Config.SIZE_SCORE_HEIGHT = 25;
        Config.SCORE_YSTART = Config.POS_HIGHSCORE_BOX.y + 30;
        Config.SIZE_BLOCK_OFFSET = 10;
        Config.SIZE_SUPER_OFFSET = {
            x: 50,
            y: 50
        };
        Config.SIZE_LINEBLOCK_OFFSET = 8;
        Config.LIFE = 3;
        Config.LEVEL_BLOCKCOUNT = 13;
        Config.BLOCK_ACCELERATION = 1000;
        Config.BLOCK_MISSTOLERANCE = 40;
        Config.BLOCK_MISSROTATESPEED = Math.PI;
        Config.BLOCK_MISSY = 500;
        Config.BLOCK_PERFECTTOLERANCE = 10;
        Config.BLOCK_SCROLLY = 300;
        Config.BLOCK_SCROLLSPEED = 150;
        Config.BLOCK_SWINGHEIGHT = 10;
        Config.BLOCK_SWINGINITIALAMPLITUDE = 1;
        Config.BLOCK_SWINGAMPLITUDEINCREASE = 5;
        Config.BLOCK_SWINGMAXAMPLITUDE = 200;
        Config.BLOCK_SWINGINITIALPERIOD = 2;
        Config.BLOCK_SWINGPERIODINCREASE = 0.1;
        Config.BLOCK_SWINGMAXPERIOD = 10;
        Config.LINE_TOPX = (Config.SCREEN_WIDTH - 8) / 2;
        Config.LINE_TOPY = -96;
        Config.LINE_COLOUR = 0x20110F;
        Config.LINE_THICKNESS = 3;
        Config.LINE_BLOCKSPACING = 50;
        Config.LINE_BLOCKSTARTX = 300;
        Config.LINE_BLOCKSTARTY = 40;
        Config.LINE_PERIOD = 2;
        Config.LINE_AMPLITUDE = 100;
        Config.LINE_MOVEDOWNSPEED = 200;
        Config.LINE_MOVEUPSPEED = 150;
        Config.LINE_OFFSETX = 1;
        Config.LINE_OFFSETY = 12;
        Config.SPARK_SHOWTIME = 0.8;
        Config.SCORE_NORMAL = 100;
        Config.SCORE_PERFECT = 200;
        Config.SCORE_COMBO = 50;
        Config.SCOREPOPUP_PREFIX = '+';
        Config.SCOREPOPUP_MOVETIME = 0.3;
        Config.SCOREPOPUP_MOVEHEIGHT = 50;
        Config.SCOREPOPUP_STAYTIME = 0.5;
        Config.CLOUDS_STARTY = -10;
        Config.CLOUDS_MINSPACING = 50;
        Config.CLOUDS_MAXSPACING = 200;
        Config.CLOUDS_MINSPEED = 5;
        Config.CLOUDS_MAXSPEED = 20;
        Config.CLOUDS_MINX = 0;
        Config.CLOUDS_MAXX = 320;
        Config.CLOUDS_MINY = 0;
        Config.CLOUDS_MAXY = 480;
        Config.CLOUDS_TOTALFRAMES = 3;
        Config.STARS_STARTY = -10;
        Config.STARS_MINSPACING = 50;
        Config.STARS_MAXSPACING = 200;
        Config.STARS_MINX = 0;
        Config.STARS_MAXX = 320;
        Config.STARS_MINY = 0;
        Config.STARS_MAXY = 480;
        Config.STARS_TOTALFRAMES = 2;
        Config.MESSAGE_MISSTIME = 2000;
        Config.MESSAGE_GAMEOVERTIME = 1000;
    } else {
        Config.PATH_MEDIA = 'media/ipad/';
        Config.TOP_BAR_HEIGHT = 0;
        Config.PATH_IMG_SPLASH = Config.PATH_MEDIA + 'bg_splash.jpg';
        Config.PATH_IMG_COVER = Config.PATH_MEDIA + 'bg_cover.jpg';
        Config.PATH_IMG_MENUBACK = Config.PATH_MEDIA + 'bg_mainmenu.jpg';
        Config.PATH_IMG_GAMEBACK = Config.PATH_MEDIA + 'bg_game.jpg';
        Config.PATH_IMG_OVERLAYBACK = Config.PATH_MEDIA + 'bg_overlay.png';
        Config.PATH_IMG_START_BUTTON = Config.PATH_MEDIA + 'btn_startgame.png';
        Config.PATH_IMG_HELP_BUTTON = Config.PATH_MEDIA + 'btn_help.png';
        Config.PATH_IMG_HIGHSCORE_BUTTON = Config.PATH_MEDIA + 'btn_highscore.png';
        Config.PATH_IMG_ABOUT_BUTTON = Config.PATH_MEDIA + 'btn_about.png';
        Config.PATH_IMG_MOREGAME_BUTTON = Config.PATH_MEDIA + 'btn_moregames.png';
        Config.PATH_IMG_ENTERHIGHSCORE_BUTTON = Config.PATH_MEDIA + 'btn_enterhighscore.png';
        Config.PATH_IMG_PLAYAGAIN_BUTTON = Config.PATH_MEDIA + 'btn_playagain.png';
        Config.PATH_IMG_BACK_BUTTON = Config.PATH_MEDIA + 'btn_back.png';
        Config.PATH_IMG_NEXT_BUTTON = Config.PATH_MEDIA + 'btn_next.png';
        Config.PATH_IMG_INSTRUCTION_BUTTON = Config.PATH_MEDIA + 'btn_instructions.png';
        Config.PATH_IMG_QUIT_BUTTON = Config.PATH_MEDIA + 'btn_quit.png';
        Config.PATH_IMG_INSTRUCTION_TEXT = Config.PATH_MEDIA + 'txt_help.png';
        Config.PATH_IMG_HELP_TEXT = Config.PATH_MEDIA + 'txt_help.png';
        Config.PATH_IMG_ABOUT_TEXT = Config.PATH_MEDIA + 'txt_about.png';
        Config.PATH_IMG_GAMEOVER_TEXT = Config.PATH_MEDIA + 'txt_gameover.png';
        Config.PATH_IMG_LEVEL_TEXT = Config.PATH_MEDIA + 'txt_level.png';
        Config.PATH_IMG_SCORE_TEXT = Config.PATH_MEDIA + 'txt_score.png';
        Config.PATH_IMG_LEVELCOMPLETE_TEXT = Config.PATH_MEDIA + 'txt_levelcomplete.png';
        Config.PATH_IMG_TOTALSCORE_TEXT = Config.PATH_MEDIA + 'txt_totalscore.png';
        Config.PATH_IMG_SUPER_TEXT = Config.PATH_MEDIA + 'txt_super.png';
        Config.PATH_IMG_TAPSCREEN_TEXT = Config.PATH_MEDIA + 'txt_tapscreen.png';
        Config.PATH_IMG_HIGHSCORE_BOX = Config.PATH_MEDIA + 'box_highscore.png';
        Config.PATH_IMG_DEFAULT_BOX = Config.PATH_MEDIA + 'box_default.png';
        Config.PATH_IMG_QUIT_BOX = Config.PATH_MEDIA + 'box_quit.png';
        Config.PATH_IMG_HELP_BOX = Config.PATH_MEDIA + 'box_help.png';
        Config.PATH_IMG_ATTACHER_ENT = Config.PATH_MEDIA + 'ent_attacher.png';
        Config.PATH_IMG_LINE_ENT = Config.PATH_MEDIA + 'ent_line.png';
        Config.PATH_IMG_RED_BLOCK_ENT = Config.PATH_MEDIA + 'ent_red_block.png';
        Config.PATH_IMG_STAND_ENT = Config.PATH_MEDIA + 'ent_greenback.png';
        Config.PATH_IMG_CLOUD1_ENT = Config.PATH_MEDIA + 'ent_cloud1.png';
        Config.PATH_IMG_CLOUD2_ENT = Config.PATH_MEDIA + 'ent_cloud2.png';
        Config.PATH_IMG_CLOUD3_ENT = Config.PATH_MEDIA + 'ent_cloud3.png';
        Config.PATH_IMG_STAR1_ENT = Config.PATH_MEDIA + 'ent_star1.png';
        Config.PATH_IMG_STAR2_ENT = Config.PATH_MEDIA + 'ent_star2.png';
        Config.PATH_IMG_LIFE_ENT = Config.PATH_MEDIA + 'ent_life.png';
        Config.PATH_IMG_BLOCKSHADOW_ENT = Config.PATH_MEDIA + 'ent_blockshadow.png';
        Config.PATH_IMG_STARS_ANIM = Config.PATH_MEDIA + 'anim_stars.png';
        Config.PATH_IMG_WAVE_ANIM = Config.PATH_MEDIA + 'anim_wave.png';
        Config.PATH_IMG_RED_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_red_block.png';
        Config.PATH_IMG_BLUE_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_blue_block.png';
        Config.PATH_IMG_CYAN_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_cyan_block.png';
        Config.PATH_IMG_GREEN_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_green_block.png';
        Config.PATH_IMG_LIME_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_lime_block.png';
        Config.PATH_IMG_PINK_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_pink_block.png';
        Config.PATH_IMG_PURPLE_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_purple_block.png';
        Config.PATH_IMG_YELLOW_BLOCK_ANIM = Config.PATH_MEDIA + 'anim_yellow_block.png';
        Config.PATH_IMG_SMALL_BLOCKS = [];
        Config.PATH_IMG_SMALL_BLOCKS[0] = Config.PATH_MEDIA + 'ent_red_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[1] = Config.PATH_MEDIA + 'ent_blue_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[2] = Config.PATH_MEDIA + 'ent_cyan_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[3] = Config.PATH_MEDIA + 'ent_green_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[4] = Config.PATH_MEDIA + 'ent_lime_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[5] = Config.PATH_MEDIA + 'ent_pink_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[6] = Config.PATH_MEDIA + 'ent_purple_small_block.png';
        Config.PATH_IMG_SMALL_BLOCKS[7] = Config.PATH_MEDIA + 'ent_yellow_small_block.png';
        Config.PATH_FONT_HIGHSCORE = Config.PATH_MEDIA + 'font_highscore.png';
        Config.PATH_FONT_BLOCKCOUNT = Config.PATH_MEDIA + 'font_blockcount.png';
        Config.PATH_FONT_SCORE = Config.PATH_MEDIA + 'font_score.png';
        Config.SCREEN_WIDTH = 700;
        Config.SCREEN_HEIGHT = 881;
        Config.TIME_SPLASH = 2;
        Config.TIME_LEVEL = 1;
        Config.TIME_OVER = 2;
        Config.ENTERNAME_INTENT = 0;
        Config.ENTERNAME_REAL_VALUE = 0;
        Config.MENU_ITEM_POSX = 126;
        Config.LETTER_SIZE = 14;
        Config.POS_ENTERNAME = {
            x: Config.SCREEN_WIDTH / 2,
            y: Config.SCREEN_HEIGHT / 2 + Config.TOP_BAR_HEIGHT
        };
        Config.MENU_ITEM_SIZE = {
            x: 500,
            y: 110
        };
        Config.SIZE_IMG_YES_BUTTON = {
            x: 86,
            y: 37
        };
        Config.SIZE_IMG_NO_BUTTON = {
            x: 67,
            y: 37
        };
        Config.SIZE_LINE_ENT = {
            x: 13,
            y: 670
        };
        Config.SIZE_ATTACHER_ENT = {
            x: 55,
            y: 40
        };
        Config.SIZE_CLOUD1_ENT = {
            x: 135,
            y: 118
        };
        Config.SIZE_CLOUD2_ENT = {
            x: 199,
            y: 161
        };
        Config.SIZE_CLOUD3_ENT = {
            x: 270,
            y: 209
        };
        Config.SIZE_STAR1_ENT = {
            x: 191,
            y: 188
        };
        Config.SIZE_STAR2_ENT = {
            x: 205,
            y: 196
        };
        Config.SIZE_STAND_ENT = {
            x: 700,
            y: 216
        };
        Config.SIZE_BLOCKSPARK_ENT = {
            x: 400,
            y: 250
        };
        Config.SIZE_WAVE_ENT = {
            x: 229,
            y: 100
        };
        Config.SIZE_BLOCK_ENT = {
            x: 170,
            y: 143
        };
        Config.SIZE_BLOCK_DEFAULT_ENT = {
            x: 133,
            y: 132
        };
        Config.SIZE_BLOCKS_ENT = [];
        Config.SIZE_BLOCKS_ENT[0] = {
            x: 133,
            y: 132
        };
        Config.SIZE_BLOCKS_ENT[1] = {
            x: 130,
            y: 143
        };
        Config.SIZE_BLOCKS_ENT[2] = {
            x: 130,
            y: 143
        };
        Config.SIZE_BLOCKS_ENT[3] = {
            x: 140,
            y: 126
        };
        Config.SIZE_BLOCKS_ENT[4] = {
            x: 170,
            y: 120
        };
        Config.SIZE_BLOCKS_ENT[5] = {
            x: 163,
            y: 128
        };
        Config.SIZE_BLOCKS_ENT[6] = {
            x: 136,
            y: 132
        };
        Config.SIZE_BLOCKS_ENT[7] = {
            x: 130,
            y: 140
        };
        Config.SIZE_BLOCKS_ENT[8] = {
            x: 140,
            y: 126
        };
        Config.SIZE_BLOCKS_ENT[9] = {
            x: 170,
            y: 120
        };
        Config.SIZE_BLOCKS_ENT[10] = {
            x: 163,
            y: 128
        };
        Config.SIZE_BLOCKS_ENT[11] = {
            x: 133,
            y: 132
        };
        Config.SIZE_INPUTBOX = {
            x: 768,
            y: 700
        };
        Config.SEQ_BLOCKSPARK_ANIM = [0, 1, 2, 3, 4, 5, 6];
        Config.SEQ_WAVE_ANIM = [0, 1, 2, 3];
        Config.POS_IMG_START_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 38 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_HELP_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 202 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_HIGHSCORE_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 362 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_ABOUT_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 514 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_MOREGAME_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 674 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_ENTERHIGHSCORE_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 320 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_PLAYAGAIN_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 564 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_BACK_BUTTON = {
            x: 11,
            y: 825 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_NEXT_BUTTON = {
            x: 572,
            y: 825 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_DEFAULT_BUTTON = {
            x: Config.MENU_ITEM_POSX,
            y: 21 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_QUIT_BUTTON = {
            x: 664,
            y: 850 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_LEVELCOMPLETE_TEXT = {
            x: (Config.SCREEN_WIDTH - 365) / 2,
            y: 265 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_GAMEOVER_TEXT = {
            x: 181,
            y: 222 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_LEVEL_TEXT = {
            x: 100,
            y: 200 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_TOTALSCORE_TEXT = {
            x: 80,
            y: 110 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_INSTRUCTION_TEXT = {
            x: 20,
            y: 140 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_HELP_TEXT = {
            x: 20,
            y: 140 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_ABOUT_TEXT = {
            x: 20,
            y: 170 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_TAPSCREEN_TEXT = {
            x: 182,
            y: 20 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_HIGHSCORE_BOX = {
            x: 60,
            y: 130 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_DEFAULT_BOX = {
            x: 80,
            y: 127 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_DEFAULT_BOX2 = {
            x: 80,
            y: 217 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_QUIT_BOX = {
            x: 100,
            y: 277 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_HELP_BOX = {
            x: 51,
            y: 127 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_IMG_YES_BUTTON = {
            x: Config.POS_QUIT_BOX.x + 63,
            y: Config.POS_QUIT_BOX.y + 190
        };
        Config.POS_IMG_NO_BUTTON = {
            x: Config.POS_QUIT_BOX.x + 354,
            y: Config.POS_QUIT_BOX.y + 190
        };
        Config.POS_SCORE_STRING = {
            x: 556,
            y: 8 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_LEVEL_STRING = {
            x: 180,
            y: 197 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_BLOCKCOUNT_STRING = {
            x: 60,
            y: 570 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_TOTALSCORE_STRING = {
            x: 140,
            y: 160 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_LIFE_ENT = {
            x: 70,
            y: 5 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_SMALLBLOCKS_ENT = {
            x: 28,
            y: 625 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_START_SCORE_NUM = {
            x: Config.POS_HIGHSCORE_BOX.x + 78,
            y: 92 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_START_SCORE_NAME = {
            x: Config.POS_HIGHSCORE_BOX.x + 156,
            y: 92 + Config.TOP_BAR_HEIGHT
        };
        Config.POS_START_SCORE = {
            x: Config.POS_HIGHSCORE_BOX.x + 385,
            y: 92 + Config.TOP_BAR_HEIGHT
        };
        Config.SIZE_SCORE_HEIGHT = 55;
        Config.SCORE_YSTART = Config.POS_HIGHSCORE_BOX.y + 80;
        Config.SIZE_BLOCK_OFFSET = 25;
        Config.SIZE_SUPER_OFFSET = {
            x: 70,
            y: 70
        };
        Config.SIZE_LINEBLOCK_OFFSET = 15;
        Config.LIFE = 3;
        Config.LEVEL_BLOCKCOUNT = 13;
        Config.BLOCK_ACCELERATION = 1800;
        Config.BLOCK_MISSTOLERANCE = 70;
        Config.BLOCK_MISSROTATESPEED = Math.PI;
        Config.BLOCK_MISSY = 900;
        Config.BLOCK_PERFECTTOLERANCE = 20;
        Config.BLOCK_SCROLLY = 650;
        Config.BLOCK_SCROLLSPEED = 270;
        Config.BLOCK_SWINGHEIGHT = 10;
        Config.BLOCK_SWINGINITIALAMPLITUDE = 2;
        Config.BLOCK_SWINGAMPLITUDEINCREASE = 9;
        Config.BLOCK_SWINGMAXAMPLITUDE = 200;
        Config.BLOCK_SWINGINITIALPERIOD = 2;
        Config.BLOCK_SWINGPERIODINCREASE = 0.1;
        Config.BLOCK_SWINGMAXPERIOD = 10;
        Config.LINE_TOPX = (Config.SCREEN_WIDTH - 14) / 2;
        Config.LINE_TOPY = -178;
        Config.LINE_COLOUR = 0x20110F;
        Config.LINE_THICKNESS = 3;
        Config.LINE_BLOCKSPACING = 100;
        Config.LINE_BLOCKSTARTX = 540;
        Config.LINE_BLOCKSTARTY = 80;
        Config.LINE_PERIOD = 2;
        Config.LINE_AMPLITUDE = 200;
        Config.LINE_MOVEDOWNSPEED = 360;
        Config.LINE_MOVEUPSPEED = 270;
        Config.LINE_OFFSETX = 4;
        Config.LINE_OFFSETY = 15;
        Config.SPARK_SHOWTIME = 0.8;
        Config.SCORE_NORMAL = 100;
        Config.SCORE_PERFECT = 200;
        Config.SCORE_COMBO = 50;
        Config.SCOREPOPUP_PREFIX = '+';
        Config.SCOREPOPUP_MOVETIME = 0.3;
        Config.SCOREPOPUP_MOVEHEIGHT = 100;
        Config.SCOREPOPUP_STAYTIME = 0.5;
        Config.CLOUDS_STARTY = -10;
        Config.CLOUDS_MINSPACING = 50;
        Config.CLOUDS_MAXSPACING = 200;
        Config.CLOUDS_MINSPEED = 10;
        Config.CLOUDS_MAXSPEED = 40;
        Config.CLOUDS_MINX = 0;
        Config.CLOUDS_MAXX = Config.SCREEN_WIDTH;
        Config.CLOUDS_MINY = 0;
        Config.CLOUDS_MAXY = Config.SCREEN_HEIGHT;
        Config.CLOUDS_TOTALFRAMES = 3;
        Config.STARS_STARTY = -20;
        Config.STARS_MINSPACING = 50;
        Config.STARS_MAXSPACING = 200;
        Config.STARS_MINX = 0;
        Config.STARS_MAXX = Config.SCREEN_WIDTH;
        Config.STARS_MINY = 0;
        Config.STARS_MAXY = Config.SCREEN_HEIGHT;
        Config.STARS_TOTALFRAMES = 2;
        Config.MESSAGE_MISSTIME = 2000;
        Config.MESSAGE_GAMEOVERTIME = 1000;
    }
});

// lib/game/src/menu.js
ig.baked = true;
ig.module('game.src.menu').requires('game.customlib.component', 'game.src.config', 'impact.image').defines(function () {
    Menu = Component.extend({
        gameState: 0,
        engine: null,
        arrHighScore: [],
        timerSplash: new ig.Timer(),
        fontHighScore: new ig.Font(Config.PATH_FONT_HIGHSCORE),
        imgSplash: new ig.Image(Config.PATH_IMG_SPLASH),
        imgCover: new ig.Image(Config.PATH_IMG_COVER),
        imgMenuBack: new ig.Image(Config.PATH_IMG_MENUBACK),
        imgGameBack: new ig.Image(Config.PATH_IMG_GAMEBACK),
        imgStartGameButton: new ig.Image(Config.PATH_IMG_START_BUTTON),
        imgHelpButton: new ig.Image(Config.PATH_IMG_HELP_BUTTON),
        imgHighScoreButton: new ig.Image(Config.PATH_IMG_HIGHSCORE_BUTTON),
        imgAboutButton: new ig.Image(Config.PATH_IMG_ABOUT_BUTTON),
        imgMoreGameButton: new ig.Image(Config.PATH_IMG_MOREGAME_BUTTON),
        imgInstructionButton: new ig.Image(Config.PATH_IMG_INSTRUCTION_BUTTON),
        imgBackButton: new ig.Image(Config.PATH_IMG_BACK_BUTTON),
        imgNextButton: new ig.Image(Config.PATH_IMG_NEXT_BUTTON),
        imgHighScoreBox: new ig.Image(Config.PATH_IMG_HIGHSCORE_BOX),
        imgDefaultBox: new ig.Image(Config.PATH_IMG_DEFAULT_BOX),
        imgHelpBox: new ig.Image(Config.PATH_IMG_HELP_BOX),
        imgInstructionText: new ig.Image(Config.PATH_IMG_INSTRUCTION_TEXT),
        imgHelpText: new ig.Image(Config.PATH_IMG_HELP_TEXT),
        imgAboutText: new ig.Image(Config.PATH_IMG_ABOUT_TEXT),
        init: function (arrParams) {
            this.parent(arrParams);
            this.gameState = this.arrParams[0];
            if (this.gameState == Config.STATE_SPLASH) this.timerSplash.set(Config.TIME_SPLASH);
            this.setState(this.gameState);
        },
        update: function () {
            this.parent();
            this.keyCheck();
            switch (this.gameState) {
                case Config.STATE_SPLASH:
                    if (this.timerSplash.delta() > 0) {
                        this.setState(Config.STATE_COVER);
                    }
                    break;
                case Config.STATE_COVER:
                    break;
                case Config.STATE_MAIN_MENU:
                    break;
                case Config.STATE_INSTRUCTION:
                    break;
                case Config.STATE_HELP:
                    break;
                case Config.STATE_HIGH_SCORE:
                    break;
            }
        },
        draw: function () {
            this.parent();
            switch (this.gameState) {
                case Config.STATE_SPLASH:
                    this.imgSplash.draw(0, 0);
                    break;
                case Config.STATE_COVER:
                    this.imgCover.draw(0, 0);
                    break;
                case Config.STATE_MAIN_MENU:
                    this.imgMenuBack.draw(0, 0);
                    this.imgStartGameButton.draw(Config.POS_IMG_START_BUTTON.x, Config.POS_IMG_START_BUTTON.y);
                    this.imgHelpButton.draw(Config.POS_IMG_HELP_BUTTON.x, Config.POS_IMG_HELP_BUTTON.y);
                    this.imgHighScoreButton.draw(Config.POS_IMG_HIGHSCORE_BUTTON.x, Config.POS_IMG_HIGHSCORE_BUTTON.y);
                    this.imgAboutButton.draw(Config.POS_IMG_ABOUT_BUTTON.x, Config.POS_IMG_ABOUT_BUTTON.y);
                    this.imgMoreGameButton.draw(Config.POS_IMG_MOREGAME_BUTTON.x, Config.POS_IMG_MOREGAME_BUTTON.y);
                    break;
                case Config.STATE_INSTRUCTION:
                    this.imgMenuBack.draw(0, 0);
                    this.imgInstructionButton.draw(Config.POS_IMG_DEFAULT_BUTTON.x, Config.POS_IMG_DEFAULT_BUTTON.y);
                    this.imgHelpBox.draw(Config.POS_HELP_BOX.x, Config.POS_HELP_BOX.y);
                    this.imgBackButton.draw(Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y);
                    this.imgNextButton.draw(Config.POS_IMG_NEXT_BUTTON.x, Config.POS_IMG_NEXT_BUTTON.y);
                    break;
                case Config.STATE_HELP:
                    this.imgMenuBack.draw(0, 0);
                    this.imgHelpButton.draw(Config.POS_IMG_DEFAULT_BUTTON.x, Config.POS_IMG_DEFAULT_BUTTON.y);
                    this.imgHelpBox.draw(Config.POS_HELP_BOX.x, Config.POS_HELP_BOX.y);
                    this.imgBackButton.draw(Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y);
                    break;
                case Config.STATE_HIGH_SCORE:
                    this.imgMenuBack.draw(0, 0);
                    this.imgHighScoreButton.draw(Config.POS_IMG_DEFAULT_BUTTON.x, Config.POS_IMG_DEFAULT_BUTTON.y);
                    this.imgHighScoreBox.draw(Config.POS_HIGHSCORE_BOX.x, Config.POS_HIGHSCORE_BOX.y);
                    this.drawHighScore();
                    this.imgBackButton.draw(Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y);
                    break;
                case Config.STATE_ABOUT:
                    this.imgMenuBack.draw(0, 0);
                    this.imgAboutButton.draw(Config.POS_IMG_DEFAULT_BUTTON.x, Config.POS_IMG_DEFAULT_BUTTON.y);
                    this.imgDefaultBox.draw(Config.POS_DEFAULT_BOX.x, Config.POS_DEFAULT_BOX.y);
                    this.imgAboutText.draw(Config.POS_DEFAULT_BOX.x, Config.POS_DEFAULT_BOX.y);
                    this.imgBackButton.draw(Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y);
                    break;
                case Config.STATE_MORE_GAME:
                    this.imgMenuBack.draw(0, 0);
                    break;
            }
        },
        setState: function (state) {
            this.gameState = state;
        },
        keyCheck: function () {
            if (ig.input.pressed('mouse')) {
                var x = ig.input.mouse.x;
                var y = ig.input.mouse.y;
                switch (this.gameState) {
                    case Config.STATE_COVER:
                        this.setState(Config.STATE_MAIN_MENU);
                        break;
                    case Config.STATE_MAIN_MENU:
                        this.keyCheckInMainMenu(x, y);
                        break;
                    case Config.STATE_HELP:
                    case Config.STATE_HIGH_SCORE:
                    case Config.STATE_ABOUT:
                        this.setState(Config.STATE_MAIN_MENU);
                        break;
                    case Config.STATE_INSTRUCTION:
                        if (this.checkCursorInArea(x, y, Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y, this.imgBackButton.width, this.imgBackButton.height)) {
                            this.setState(Config.STATE_MAIN_MENU);
                        } else {
                            this.engine = ig.game.spawnComponent(Engine);
                            this.destroy();
                        }
                        break;
                }
            }
        },
        keyCheckInMainMenu: function (x, y) {
            if (this.checkCursorInArea(x, y, Config.POS_IMG_START_BUTTON.x, Config.POS_IMG_START_BUTTON.y, this.imgStartGameButton.width, this.imgStartGameButton.height)) {
                this.setState(Config.STATE_INSTRUCTION);
                return;
            }
            if (this.checkCursorInArea(x, y, Config.POS_IMG_HELP_BUTTON.x, Config.POS_IMG_HELP_BUTTON.y, this.imgHelpButton.width, this.imgHelpButton.height)) {
                this.setState(Config.STATE_HELP);
                return;
            }
            if (this.checkCursorInArea(x, y, Config.POS_IMG_HIGHSCORE_BUTTON.x, Config.POS_IMG_HIGHSCORE_BUTTON.y, this.imgHighScoreButton.width, this.imgHighScoreButton.height)) {
                this.getArrayHighScore();
                this.setState(Config.STATE_HIGH_SCORE);
                return;
            }
            if (this.checkCursorInArea(x, y, Config.POS_IMG_ABOUT_BUTTON.x, Config.POS_IMG_ABOUT_BUTTON.y, this.imgAboutButton.width, this.imgAboutButton.height)) {
                this.setState(Config.STATE_ABOUT);
                return;
            }
            if (this.checkCursorInArea(x, y, Config.POS_IMG_MOREGAME_BUTTON.x, Config.POS_IMG_MOREGAME_BUTTON.y, this.imgMoreGameButton.width, this.imgMoreGameButton.height)) {
                location.href = 'http://justplaymobile.com/html5games/mozilla/coolgames/';
                return;
            }
        },
        getArrayHighScore: function () {
            var that = this;
            var req = $.ajax({
                url: ("http://towerjelly.justplaymobile.com/game.php" + '?nocache=' + Math.random()),
                data: {
                    a: 'l'
                },
                dataType: 'json',
                async: false,
                success: function (scores) {
                    that.arrHighScore = scores;
                }
            });
        },
        drawHighScore: function () {
            for (var i = 0; i < 10; i++) {
                this.fontHighScore.draw(i + 1 + '.', Config.POS_START_SCORE_NUM.x, Config.SIZE_SCORE_HEIGHT * i + Config.SCORE_YSTART);
                if (this.arrHighScore[i] != null) {
                    this.fontHighScore.draw(this.arrHighScore[i].name, Config.POS_START_SCORE_NAME.x, Config.SIZE_SCORE_HEIGHT * i + Config.SCORE_YSTART);
                    this.fontHighScore.draw(this.arrHighScore[i].score, Config.POS_START_SCORE.x, Config.SIZE_SCORE_HEIGHT * i + Config.SCORE_YSTART);
                } else {
                    this.fontHighScore.draw('.....', Config.POS_START_SCORE_NAME.x, Config.SIZE_SCORE_HEIGHT * i + Config.SCORE_YSTART);
                    this.fontHighScore.draw('.....', Config.POS_START_SCORE.x, Config.SIZE_SCORE_HEIGHT * i + Config.SCORE_YSTART);
                }
            }
        },
    });
});

// lib/game/src/clouds.js
ig.baked = true;
ig.module('game.src.clouds').requires('game.customlib.component', 'impact.timer').defines(function () {
    Clouds = Component.extend({
        clouds: [],
        nextCloudY: 0,
        lastTime: 0,
        pos: {
            x: 0,
            y: 0
        },
        init: function (arrParams) {
            this.parent(arrParams);
            var cloud = null
            this.clouds = new Array();
            this.nextCloudY = Config.CLOUDS_STARTY;
            this.generateNextCloud();
            this.lastTime = ig.Timer.time;
        },
        scroll: function (distance) {
            var i;
            for (i = 0; i < this.clouds.length; i++) {
                this.clouds[i].center.y += distance;
                if (this.clouds[i].center.y - this.clouds[i].size.y / 2 > Config.CLOUDS_MAXY) {
                    this.clouds[i].destroy();
                    this.clouds.splice(i, 1);
                    i--;
                }
            }
            this.nextCloudY += distance;
            while (this.nextCloudY > Config.CLOUDS_MINY) {
                this.generateNextCloud();
            }
        },
        generateNextCloud: function () {
            var cloud = null;
            var arrParams = [];
            arrParams[0] = this.nextCloudY;
            cloud = ig.game.spawnEntity(EntityCloud, 0, arrParams[0], {});
            this.clouds.push(cloud);
            this.generateNextCloudY();
        },
        generateNextCloudY: function () {
            var topCloud = this.clouds[this.clouds.length - 1];
            var spacing = Config.CLOUDS_MINSPACING + Math.random() * (Config.CLOUDS_MAXSPACING - Config.CLOUDS_MINSPACING);
            this.nextCloudY = topCloud.center.y - topCloud.size.y / 2 - spacing;
        },
        update: function () {
            var engine = ig.game.getComponentsByType(Engine)[0];
            if (engine != null && engine.bGamePause == true) {
                this.lastTime = ig.Timer.time;
                return;
            }
            var time = ig.Timer.time;
            var dTime = time - this.lastTime;
            var i;
            for (i = 0; i < this.clouds.length; i++) {
                if (this.clouds[i].center.y + this.clouds[i].size.y / 2 < Config.CLOUDS_MINY) continue;
                if (this.clouds[i].center.y - this.clouds[i].size.y / 2 > Config.CLOUDS_MAXY) continue;
                this.clouds[i].center.x += dTime * this.clouds[i].speed;
            }
            this.lastTime = time;
        },
        destroy: function () {
            for (var nI = 0; nI < this.clouds.length; nI++) {
                this.clouds[nI].destroy();
            }
            this.parent();
        }
    });
});

// lib/game/entities/cloud.js
ig.baked = true;
ig.module('game.entities.cloud').requires('impact.entity').defines(function () {
    EntityCloud = ig.Entity.extend({
        animNo: 0,
        speed: 0,
        center: {
            x: 0,
            y: 0
        },
        pos: {
            x: 0,
            y: 0
        },
        imgCloudEnt: null,
        zIndex: 20,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            var y = y;
            this.animNo = Math.floor(Math.random() * Config.CLOUDS_TOTALFRAMES);
            this.speed = Config.CLOUDS_MINSPEED + Math.random() * (Config.CLOUDS_MAXSPEED - Config.CLOUDS_MINSPEED);
            switch (this.animNo) {
                case 0:
                    this.imgCloudEnt = new ig.Image(Config.PATH_IMG_CLOUD1_ENT);
                    this.size = Config.SIZE_CLOUD1_ENT;
                    break;
                case 1:
                    this.imgCloudEnt = new ig.Image(Config.PATH_IMG_CLOUD2_ENT);
                    this.size = Config.SIZE_CLOUD2_ENT;
                    break;
                case 2:
                    this.imgCloudEnt = new ig.Image(Config.PATH_IMG_CLOUD3_ENT);
                    this.size = Config.SIZE_CLOUD3_ENT;
                    break;
                default:
                    this.imgCloudEnt = new ig.Image(Config.PATH_IMG_CLOUD1_ENT);
                    this.size = Config.SIZE_CLOUD1_ENT;
                    break;
            }
            this.center.x = Config.CLOUDS_MINX + Math.random() * (Config.CLOUDS_MAXX - Config.CLOUDS_MINX);
            this.center.y = y - this.size.y / 2;
            this.pos.x = this.center.x - this.size.x / 2;
            this.pos.y = this.center.y - this.size.y / 2;
        },
        update: function () {
            this.pos.x = this.center.x - this.size.x / 2;
            this.pos.y = this.center.y - this.size.y / 2;
        },
        draw: function () {
            this.imgCloudEnt.draw(this.pos.x, this.pos.y);
        },
        destroy: function () {
            this.kill();
        },
    });
});

// lib/game/src/stars.js
ig.baked = true;
ig.module('game.src.stars').requires('game.customlib.component', 'impact.timer').defines(function () {
    Stars = Component.extend({
        stars: [],
        nextStarY: 0,
        lastTime: 0,
        pos: {
            x: 0,
            y: 0
        },
        init: function (arrParams) {
            this.parent(arrParams);
            var star = null
            this.stars = new Array();
            this.nextStarY = Config.STARS_STARTY;
            this.generateNextStar();
            this.lastTime = ig.Timer.time;
        },
        scroll: function (distance) {
            var i;
            for (i = 0; i < this.stars.length; i++) {
                this.stars[i].center.y += distance;
                if (this.stars[i].center.y - this.stars[i].size.y / 2 > Config.STARS_MAXY) {
                    this.stars[i].destroy();
                    this.stars.splice(i, 1);
                    i--;
                }
            }
            this.nextStarY += distance;
            while (this.nextStarY > Config.STARS_MINY) {
                this.generateNextStar();
            }
        },
        generateNextStar: function () {
            var star = null;
            var arrParams = [];
            arrParams[0] = this.nextStarY;
            star = ig.game.spawnEntity(EntityStar, 0, arrParams[0], {});
            this.stars.push(star);
            this.generateNextStarY();
        },
        generateNextStarY: function () {
            var topStar = this.stars[this.stars.length - 1];
            var spacing = Config.STARS_MINSPACING + Math.random() * (Config.STARS_MAXSPACING - Config.STARS_MINSPACING);
            this.nextStarY = topStar.center.y - topStar.size.y / 2 - spacing;
        },
        update: function () {
            var time = ig.Timer.time;
            var dTime = time - this.lastTime;
            var i;
            for (i = 0; i < this.stars.length; i++) {
                if (this.stars[i].center.y + this.stars[i].size.y / 2 < Config.STARS_MINY) continue;
                if (this.stars[i].center.y - this.stars[i].size.y / 2 > Config.STARS_MAXY) continue;
                this.stars[i].center.x += dTime * this.stars[i].speed;
            }
            this.lastTime = time;
        },
        destroy: function () {
            for (var nI = 0; nI < this.stars.length; nI++) {
                this.stars[nI].destroy();
            }
            this.parent();
        }
    });
});

// lib/game/entities/star.js
ig.baked = true;
ig.module('game.entities.star').requires('impact.entity').defines(function () {
    EntityStar = ig.Entity.extend({
        animNo: 0,
        speed: 0,
        center: {
            x: 0,
            y: 0
        },
        pos: {
            x: 0,
            y: 0
        },
        imgStarEnt: null,
        zIndex: 10,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            var y = y;
            this.animNo = Math.floor(Math.random() * Config.STARS_TOTALFRAMES);
            switch (this.animNo) {
                case 0:
                    this.imgStarEnt = new ig.Image(Config.PATH_IMG_STAR1_ENT);
                    this.size = Config.SIZE_STAR1_ENT;
                    break;
                case 1:
                    this.imgStarEnt = new ig.Image(Config.PATH_IMG_STAR2_ENT);
                    this.size = Config.SIZE_STAR2_ENT;
                    break;
                default:
                    this.imgStarEnt = new ig.Image(Config.PATH_IMG_STAR1_ENT);
                    this.size = Config.SIZE_STAR1_ENT;
                    break;
            }
            this.center.x = Config.STARS_MINX + Math.random() * (Config.STARS_MAXX - Config.STARS_MINX);
            this.center.y = y - this.size.y / 2;
            this.pos.x = this.center.x - this.size.x / 2;
            this.pos.y = this.center.y - this.size.y / 2;
        },
        update: function () {
            this.pos.x = this.center.x - this.size.x / 2;
            this.pos.y = this.center.y - this.size.y / 2;
        },
        draw: function () {
            this.imgStarEnt.draw(this.pos.x, this.pos.y);
        },
        destroy: function () {
            this.kill();
        },
    });
});

// lib/game/entities/scorepopup.js
ig.baked = true;
ig.module('game.entities.scorepopup').requires('impact.entity', 'impact.font', 'impact.timer').defines(function () {
    EntityScorepopup = ig.Entity.extend({
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.NONE,
        collides: ig.Entity.COLLIDES.NEVER,
        animSheet: null,
        fontScore: new ig.Font(Config.PATH_FONT_SCORE),
        imgSuperText: new ig.Image(Config.PATH_IMG_SUPER_TEXT),
        strScore: null,
        startY: 0,
        timerStart: null,
        timerStay: null,
        engine: null,
        pos: {
            x: 0,
            y: 0
        },
        zIndex: 80,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            var score = settings.score;
            this.fontScore.firstChar = 43;
            this.strScore = Config.SCOREPOPUP_PREFIX + score;
            this.pos.x = x;
            this.pos.y = y;
            this.startY = y;
            this.timerStart = new ig.Timer();
            this.timerStay = new ig.Timer(Config.SCOREPOPUP_STAYTIME)
            this.timerStart.set(Config.SCOREPOPUP_MOVETIME);
            this.engine = ig.game.getComponentsByType(Engine)[0];
        },
        update: function () {
            this.parent();
            var ratio = 1;
            if (this.timerStart != null) {
                ratio = 1 - Math.abs(this.timerStart.delta()) / Config.SCOREPOPUP_MOVETIME;
            }
            if (ratio > 1) ratio = 1;
            this.pos.y = this.startY - Config.SCOREPOPUP_MOVEHEIGHT * Math.sin(ratio * Math.PI);
            if (this.timerStart != null && this.timerStart.delta() > 0) {
                this.timerStart = null;
                this.timerStay.set(Config.SCOREPOPUP_STAYTIME);
            }
            if (this.engine != null && this.engine.bGamePause == true) {
                return;
            }
            if (this.timerStay.delta() > 0) this.kill();
        },
        draw: function () {
            this.parent();
            this.fontScore.draw(this.strScore, this.pos.x - 20, this.pos.y);
            if (this.strScore != "+100") this.imgSuperText.draw(this.pos.x - Config.SIZE_SUPER_OFFSET.x, this.pos.y - Config.SIZE_SUPER_OFFSET.y);
        },
    });
});

// lib/game/entities/block.js
ig.baked = true;
ig.module('game.entities.block').requires('impact.entity').defines(function () {
    EntityBlock = ig.Entity.extend({
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.NONE,
        animNo: 0,
        center: {
            x: 0,
            y: 0
        },
        centreX: 0,
        arrSize: [
            []
        ],
        zIndex: 30,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            this.animNo = settings.animNo;
            this.center.x = x;
            this.center.y = y;
            this.animSheet = ig.game.animBlocks[this.animNo];
            this.addAnim('swing', 0.2, [0]);
            this.addAnim('drop', 0.1, [1, 1, 2], true);
            this.addAnim('collision', 0.05, [3, 4, 5, 6], true);
            this.addAnim('place', 0.2, [11]);
            this.arrSize['swing'] = [];
            this.arrSize['drop'] = [];
            this.arrSize['collision'] = [];
            this.arrSize['place'] = [];
            this.arrSize['swing'][0] = Config.SIZE_BLOCKS_ENT[0];
            this.arrSize['drop'][0] = Config.SIZE_BLOCKS_ENT[1];
            this.arrSize['drop'][1] = Config.SIZE_BLOCKS_ENT[1];
            this.arrSize['drop'][2] = Config.SIZE_BLOCKS_ENT[2];
            this.arrSize['collision'][0] = Config.SIZE_BLOCKS_ENT[3];
            this.arrSize['collision'][1] = Config.SIZE_BLOCKS_ENT[4];
            this.arrSize['collision'][2] = Config.SIZE_BLOCKS_ENT[5];
            this.arrSize['collision'][3] = Config.SIZE_BLOCKS_ENT[6];
            this.arrSize['collision'][4] = Config.SIZE_BLOCKS_ENT[7];
            this.arrSize['collision'][5] = Config.SIZE_BLOCKS_ENT[8];
            this.arrSize['collision'][6] = Config.SIZE_BLOCKS_ENT[9];
            this.arrSize['collision'][7] = Config.SIZE_BLOCKS_ENT[10];
            this.arrSize['collision'][8] = Config.SIZE_BLOCKS_ENT[11];
            this.arrSize['place'][0] = Config.SIZE_BLOCKS_ENT[11];
            this.currentAnim = this.anims.swing;
            this.size.x = Config.SIZE_BLOCK_DEFAULT_ENT.x;
            this.size.y = Config.SIZE_BLOCK_DEFAULT_ENT.y;
            this.pos.x = this.center.x - this.size.x / 2;
            this.pos.y = this.center.y - this.size.y / 2;
            this.engine = ig.game.getComponentsByType(Engine)[0];
        },
        update: function () {
            if (this.engine != null && this.engine.bGamePause == true) {
                this.currentAnim.gotoFrame(this.currentAnim.frame);
                return;
            }
            switch (this.currentAnim) {
                case this.anims.swing:
                    this.size.x = this.arrSize['swing'][this.currentAnim.frame].x;
                    this.size.y = this.arrSize['swing'][this.currentAnim.frame].y;
                    break;
                case this.anims.drop:
                    this.size.x = this.arrSize['drop'][this.currentAnim.frame].x;
                    this.size.y = this.arrSize['drop'][this.currentAnim.frame].y;
                    break;
                case this.anims.collision:
                    this.size.x = this.arrSize['collision'][this.currentAnim.frame].x;
                    this.size.y = this.arrSize['collision'][this.currentAnim.frame].y;
                    break;
                case this.anims.place:
                    this.size.x = this.arrSize['place'][this.currentAnim.frame].x;
                    this.size.y = this.arrSize['place'][this.currentAnim.frame].y;
                    break;
            }
            this.pos.x = this.center.x - this.size.x / 2;
            this.pos.y = this.center.y - this.size.y / 2;
            this.parent();
        }
    });
});

// lib/game/entities/block_spark.js
ig.baked = true;
ig.module('game.entities.block_spark').requires('impact.entity', 'game.entities.block').defines(function () {
    EntityBlockSpark = ig.Entity.extend({
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.NONE,
        block: null,
        zIndex: 70,
        engine: null,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            this.size = Config.SIZE_BLOCKSPARK_ENT;
            this.animSheet = new ig.AnimationSheet(Config.PATH_IMG_STARS_ANIM, this.size.x, this.size.y);
            this.block = settings.block;
            this.pos.x = this.block.center.x - this.size.x / 2;
            this.pos.y = this.block.center.y - this.size.y / 2;
            this.addAnim('stars', Config.SPARK_SHOWTIME / Config.SEQ_BLOCKSPARK_ANIM.length, Config.SEQ_BLOCKSPARK_ANIM);
            this.engine = ig.game.getComponentsByType(Engine)[0];
        },
        update: function () {
            this.parent();
            this.pos.x = this.block.center.x - this.size.x / 2;
            this.pos.y = this.block.center.y - this.size.y / 2;
            if (this.engine != null && this.engine.bGamePause == true) {
                this.currentAnim.gotoFrame(this.currentAnim.frame);
                return;
            }
            if (this.currentAnim.frame == (Config.SEQ_BLOCKSPARK_ANIM.length - 1)) {
                this.kill();
            }
        },
    });
});

// lib/impact/myimage.js
ig.baked = true;
ig.module('impact.myimage').defines(function () {
    ig.MyImage = ig.Image.extend({
        customScale: 1,
        angle: 0,
        pivot: {
            x: 0,
            y: 0
        },
        flip: {
            x: false,
            y: false
        },
        init: function (path) {
            this.parent(path);
            this.pivot.x = this.width / 2;
            this.pivot.y = this.height / 2;
        },
        getScale: function () {
            return this.customScale;
        },
        setScale: function (scale) {
            this.customScale = scale;
        },
        draw: function (targetX, targetY, sourceX, sourceY, width, height) {
            if (!this.loaded) {
                return;
            }
            var scale = ig.system.scale;
            sourceX = sourceX ? sourceX * scale : 0;
            sourceY = sourceY ? sourceY * scale : 0;
            width = (width ? width : this.width) * scale;
            height = (height ? height : this.height) * scale;
            if (this.angle == 0) {
                this.drawTile(targetX, targetY, 0, width * this.customScale, height * this.customScale, this.flip.x, this.flip.y);
            } else {
                ig.system.context.save();
                ig.system.context.translate(ig.system.getDrawPos(targetX + this.pivot.x * this.customScale), ig.system.getDrawPos(targetY + this.pivot.y * this.customScale));
                ig.system.context.rotate(this.angle);
                this.drawTile(-this.pivot.x * this.customScale, -this.pivot.y * this.customScale, 0, width * this.customScale, height * this.customScale, this.flip.x, this.flip.y);
                ig.system.context.restore();
            }
        },
    });
});

// lib/game/entities/line.js
ig.baked = true;
ig.module('game.entities.line').requires('impact.entity', 'impact.myimage', 'impact.image').defines(function () {
    EntityLine = ig.Entity.extend({
        size: {
            x: Config.SIZE_LINE_ENT.x,
            y: Config.SIZE_LINE_ENT.y
        },
        center: {
            x: 0,
            y: 0
        },
        pos: {
            x: 0,
            y: 0
        },
        zIndex: 60,
        attacher: {
            x: -Config.SIZE_ATTACHER_ENT.x / 2,
            y: -Config.SIZE_ATTACHER_ENT.y / 2,
            width: Config.SIZE_ATTACHER_ENT.x,
            height: Config.SIZE_ATTACHER_ENT.y
        },
        imgAttacherEnt: new ig.Image(Config.PATH_IMG_ATTACHER_ENT),
        imgLineEnt: new ig.MyImage(Config.PATH_IMG_LINE_ENT),
        block: null,
        lineLength: 0,
        targetLineLength: 0,
        startTime: 0,
        lastTime: 0,
        timerMoveUp: false,
        timerMoveDown: false,
        init: function (x, y, settings) {
            this.center.x = 0;
            this.center.y = 0;
        },
        startBlock: function (block, topY) {
            this.block = block;
            this.block.center.x = Config.LINE_BLOCKSTARTX;
            this.block.center.y = Config.LINE_BLOCKSTARTY;
            this.attacher.x = this.block.center.x;
            this.attacher.y = this.block.center.y - this.block.size.y / 2 - this.attacher.height / 2 + Config.SIZE_LINEBLOCK_OFFSET;
            this.lineLength = this.attacher.y - this.attacher.height / 2 - Config.LINE_TOPY;
            this.targetLineLength = topY - Config.LINE_BLOCKSPACING - this.block.size.y - this.attacher.height - Config.LINE_TOPY;
            this.startTime = ig.Timer.time;
            this.lastTime = this.startTime;
            this.onMoveDownTime();
            this.timerMoveDown = true;
        },
        endBlock: function () {
            if (this.timerMoveDown == true) this.timerMoveDown = false;
            this.targetLineLength = Config.LINE_BLOCKSTARTY - this.block.size.y / 2 - this.attacher.height - Config.LINE_TOPY;
            this.block.currentAnim = this.block.anims.drop;
            this.timerMoveUp = true;
        },
        onMoveDownTime: function () {
            var engine = ig.game.getComponentsByType(Engine)[0];
            if (engine != null && engine.bGamePause == true) {
                this.startTime += (ig.Timer.time - this.lastTime);
                this.lastTime = ig.Timer.time;
                return;
            }
            var time = ig.Timer.time;
            var dTime = time - this.lastTime;
            var phase = ((time - this.startTime) % Config.LINE_PERIOD) / Config.LINE_PERIOD - 0.25;
            var dx, dy;
            if (this.lineLength < this.targetLineLength) {
                this.lineLength += Config.LINE_MOVEDOWNSPEED * dTime;
                if (this.lineLength > this.targetLineLength) this.lineLength = this.targetLineLength;
            }
            dx = Config.LINE_AMPLITUDE * Math.sin(phase * Math.PI * 2);
            dy = Math.sqrt(Math.abs(this.lineLength * this.lineLength - dx * dx));
            this.attacher.x = Config.LINE_TOPX + dx;
            this.attacher.y = Config.LINE_TOPY + dy;
            this.block.center.x = this.attacher.x;
            this.block.center.y = this.attacher.y + this.attacher.height / 2 + this.block.size.y / 2 - Config.SIZE_LINEBLOCK_OFFSET;
            this.block.update();
            this.lastTime = time;
        },
        onMoveUpTime: function () {
            var engine = ig.game.getComponentsByType(Engine)[0];
            if (engine != null && engine.bGamePause == true) {
                this.startTime += (ig.Timer.time - this.lastTime);
                this.lastTime = ig.Timer.time;
                return;
            }
            var time = ig.Timer.time;
            var dTime = time - this.lastTime;
            var phase = ((time - this.startTime) % Config.LINE_PERIOD) / Config.LINE_PERIOD - 0.25;
            var dx, dy;
            if (this.lineLength > this.targetLineLength) {
                this.lineLength -= Config.LINE_MOVEUPSPEED * dTime;
                if (this.lineLength < this.targetLineLength) this.lineLength = this.targetLineLength;
            }
            dx = Config.LINE_AMPLITUDE * Math.sin(phase * Math.PI * 2);
            dy = Math.sqrt(Math.abs(this.lineLength * this.lineLength - dx * dx));
            this.attacher.x = Config.LINE_TOPX + dx;
            this.attacher.y = Config.LINE_TOPY + dy;
            this.lastTime = time;
            if (this.lineLength <= this.targetLineLength) {
                this.timerMoveUp = false;
            }
        },
        updateLine: function () {
            var dx, dy, angle, width, height;
            dx = this.attacher.x - Config.LINE_TOPX - 2;
            dy = this.attacher.y - Config.LINE_TOPY;
            width = this.imgLineEnt.width;
            height = Math.sqrt(dx * dx + (dy - Config.LINE_OFFSETY) * (dy - Config.LINE_OFFSETY));
            if (dx >= 0) this.imgLineEnt.angle = Math.atan((dy - Config.LINE_OFFSETY) / (dx - Config.LINE_OFFSETX)) - Math.PI / 2;
            else this.imgLineEnt.angle = Math.atan((dy - Config.LINE_OFFSETY) / (dx - Config.LINE_OFFSETX)) + Math.PI / 2;
            this.imgLineEnt.pivot.x = this.size.x / 2;
            this.imgLineEnt.pivot.y = 0;
            this.imgLineEnt.draw(Config.LINE_TOPX, Config.LINE_TOPY, 0, 0, width, height);
            this.imgAttacherEnt.draw(this.attacher.x - this.attacher.width / 2, this.attacher.y - this.attacher.height / 2);
        },
        update: function () {
            if (this.timerMoveDown == true) {
                this.onMoveDownTime();
            } else if (this.timerMoveUp == true) {
                this.onMoveUpTime();
            }
        },
        draw: function () {
            this.updateLine();
        },
        destroy: function () {
            this.kill();
        }
    });
});

// lib/game/entities/info.js
ig.baked = true;
ig.module('game.entities.info').requires('impact.entity', 'impact.font').defines(function () {
    EntityInfo = ig.Entity.extend({
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.NONE,
        animSheet: null,
        engine: null,
        zIndex: 90,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
        },
        update: function () {
            this.parent();
        },
        draw: function () {
            this.parent();
            this.engine = ig.game.getComponentsByType(Engine)[0];
            if (this.engine == null) return;
            switch (this.engine.gameState) {
                case Config.STATE_GAME_READY:
                    this.engine.imgLevelText.draw(Config.POS_LEVEL_TEXT.x, Config.POS_LEVEL_TEXT.y);
                    this.engine.fontBlockCount.draw(this.engine.curLevel, Config.POS_LEVEL_STRING.x, Config.POS_LEVEL_STRING.y);
                    break;
                case Config.STATE_GAME_SWING:
                case Config.STATE_GAME_DROP:
                    this.engine.fontScore.draw(this.engine.score, Config.POS_SCORE_STRING.x, Config.POS_SCORE_STRING.y);
                    this.engine.fontBlockCount.draw(this.engine.noOfBlocks, Config.POS_BLOCKCOUNT_STRING.x, Config.POS_BLOCKCOUNT_STRING.y, ig.Font.ALIGN.CENTER);
                    for (var nI = 0; nI < this.engine.life; nI++) {
                        this.engine.imgLifeEnt.draw(Config.POS_LIFE_ENT.x - nI * this.engine.imgLifeEnt.width * 0.5, Config.POS_LIFE_ENT.y);
                    }
                    for (nI = 0; nI < 4; nI++) {
                        if (this.engine.smallBlocks.length > 0 && this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1] != null) this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].draw(Config.POS_SMALLBLOCKS_ENT.x, Config.POS_SMALLBLOCKS_ENT.y + nI * this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].height);
                    }
                    this.engine.imgQuitButton.draw(Config.POS_IMG_QUIT_BUTTON.x, Config.POS_IMG_QUIT_BUTTON.y);
                    break;
                case Config.STATE_GAME_QUIT:
                    this.engine.fontScore.draw(this.engine.score, Config.POS_SCORE_STRING.x, Config.POS_SCORE_STRING.y);
                    this.engine.fontBlockCount.draw(this.engine.noOfBlocks, Config.POS_BLOCKCOUNT_STRING.x, Config.POS_BLOCKCOUNT_STRING.y, ig.Font.ALIGN.CENTER);
                    for (var nI = 0; nI < this.engine.life; nI++) {
                        this.engine.imgLifeEnt.draw(Config.POS_LIFE_ENT.x - nI * this.engine.imgLifeEnt.width * 0.5, Config.POS_LIFE_ENT.y);
                    }
                    for (nI = 0; nI < 4; nI++) {
                        if (this.engine.smallBlocks.length > 0 && this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1] != null) this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].draw(Config.POS_SMALLBLOCKS_ENT.x, Config.POS_SMALLBLOCKS_ENT.y + nI * this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].height);
                    }
                    this.engine.imgQuitBox.draw(Config.POS_QUIT_BOX.x, Config.POS_QUIT_BOX.y);
                    this.engine.imgQuitButton.draw(Config.POS_IMG_QUIT_BUTTON.x, Config.POS_IMG_QUIT_BUTTON.y);
                    break;
                case Config.STATE_GAME_OVER:
                    this.engine.fontScore.draw(this.engine.score, Config.POS_SCORE_STRING.x, Config.POS_SCORE_STRING.y);
                    this.engine.fontBlockCount.draw(this.engine.noOfBlocks, Config.POS_BLOCKCOUNT_STRING.x, Config.POS_BLOCKCOUNT_STRING.y, ig.Font.ALIGN.CENTER);
                    for (var nI = 0; nI < this.engine.life; nI++) {
                        this.engine.imgLifeEnt.draw(Config.POS_LIFE_ENT.x - nI * this.engine.imgLifeEnt.width * 0.5, Config.POS_LIFE_ENT.y);
                    }
                    for (nI = 0; nI < 4; nI++) {
                        if (this.engine.smallBlocks.length > 0 && this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1] != null) this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].draw(Config.POS_SMALLBLOCKS_ENT.x, Config.POS_SMALLBLOCKS_ENT.y + nI * this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].height);
                    }
                    this.engine.imgOverlayBack.draw(0, 0);
                    this.engine.imgGameOverText.draw(Config.POS_GAMEOVER_TEXT.x, Config.POS_GAMEOVER_TEXT.y);
                    this.engine.imgPlayAgainButton.draw(Config.POS_IMG_PLAYAGAIN_BUTTON.x, Config.POS_IMG_PLAYAGAIN_BUTTON.y);
                    this.engine.imgEnterHighScoreButton.draw(Config.POS_IMG_ENTERHIGHSCORE_BUTTON.x, Config.POS_IMG_ENTERHIGHSCORE_BUTTON.y);
                    break;
                case Config.STATE_LEVEL_COMPLETE:
                    this.engine.imgLevelCompleteText.draw(Config.POS_LEVELCOMPLETE_TEXT.x, Config.POS_LEVELCOMPLETE_TEXT.y);
                    this.engine.imgScoreText.draw(Config.POS_SCORE_TEXT.x, Config.POS_SCORE_TEXT.y);
                    this.engine.fontScore.draw(this.engine.score, Config.POS_SCORE_STRING.x, Config.POS_SCORE_STRING.y);
                    this.engine.fontBlockCount.draw(this.engine.noOfBlocks, Config.POS_BLOCKCOUNT_STRING.x, Config.POS_BLOCKCOUNT_STRING.y);
                    for (var nI = 0; nI < this.engine.lifes; nI++) {
                        this.engine.imgLifeEnt.draw(Config.POS_ENT_LIFE.x - nI * this.engine.imgLifeEnt.width, Config.POS_ENT_LIFE.y);
                    }
                    for (nI = 0; nI < 4; nI++) {
                        if (this.engine.smallBlocks.length > 0 && this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1] != null) this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].draw(Config.POS_SMALLBLOCKS_ENT.x, Config.POS_SMALLBLOCKS_ENT.y + nI * this.engine.arrImgSmallBlocks[this.engine.smallBlocks[this.engine.smallBlocks.length - nI - 1]].height);
                    }
                    break;
            }
        },
    });
});

// lib/game/entities/wave.js
ig.baked = true;
ig.module('game.entities.wave').requires('impact.entity', 'game.entities.block').defines(function () {
    EntityWave = ig.Entity.extend({
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.NONE,
        block: null,
        zIndex: 40,
        engine: null,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            this.size = Config.SIZE_WAVE_ENT;
            this.animSheet = new ig.AnimationSheet(Config.PATH_IMG_WAVE_ANIM, this.size.x, this.size.y);
            this.block = settings.block;
            this.block.zIndex = 50;
            ig.game.sortEntities();
            this.pos.x = this.block.center.x - this.size.x / 2;
            this.pos.y = this.block.center.y + this.block.size.y / 2 - this.size.y / 2;
            this.addAnim('wave', Config.SPARK_SHOWTIME / Config.SEQ_WAVE_ANIM.length, Config.SEQ_WAVE_ANIM);
            this.engine = ig.game.getComponentsByType(Engine)[0];
        },
        update: function () {
            this.parent();
            this.pos.x = this.block.center.x - this.size.x / 2;
            this.pos.y = this.block.center.y + this.block.size.y / 2 - this.size.y / 2;
            if (this.engine != null && this.engine.bGamePause == true) {
                this.currentAnim.gotoFrame(this.currentAnim.frame);
                return;
            }
            if (this.currentAnim.frame == (Config.SEQ_WAVE_ANIM.length - 1)) {
                this.block.zIndex = 30;
                ig.game.sortEntities();
                this.kill();
            }
        },
    });
});

// lib/game/src/engine.js
ig.baked = true;
ig.module('game.src.engine').requires('game.customlib.component', 'game.customlib.graphics', 'game.src.menu', 'game.src.config', 'game.src.clouds', 'game.entities.cloud', 'game.src.stars', 'game.entities.star', 'game.entities.scorepopup', 'game.entities.block_spark', 'game.entities.line', 'game.entities.block', 'game.entities.info', 'game.entities.wave').defines(function () {
    Engine = Component.extend({
        imgOverlayBack: new ig.Image(Config.PATH_IMG_OVERLAYBACK),
        imgGameOverText: new ig.Image(Config.PATH_IMG_GAMEOVER_TEXT),
        imgScoreText: new ig.Image(Config.PATH_IMG_SCORE_TEXT),
        imgTapScreenText: new ig.Image(Config.PATH_IMG_TAPSCREEN_TEXT),
        imgPlayAgainButton: new ig.Image(Config.PATH_IMG_PLAYAGAIN_BUTTON),
        imgEnterHighScoreButton: new ig.Image(Config.PATH_IMG_ENTERHIGHSCORE_BUTTON),
        imgBackButton: new ig.Image(Config.PATH_IMG_BACK_BUTTON),
        imgQuitButton: new ig.Image(Config.PATH_IMG_QUIT_BUTTON),
        imgHighScoreBox: new ig.Image(Config.PATH_IMG_HIGHSCORE_BOX),
        imgDefaultBox: new ig.Image(Config.PATH_IMG_DEFAULT_BOX),
        imgQuitBox: new ig.Image(Config.PATH_IMG_QUIT_BOX),
        imgGameBack: new ig.Image(Config.PATH_IMG_GAMEBACK),
        imgStandEnt: new ig.Image(Config.PATH_IMG_STAND_ENT),
        imgLifeEnt: new ig.Image(Config.PATH_IMG_LIFE_ENT),
        imgBlockShadowEnt: new ig.Image(Config.PATH_IMG_BLOCKSHADOW_ENT),
        fontBlockCount: new ig.Font(Config.PATH_FONT_BLOCKCOUNT),
        fontScore: new ig.Font(Config.PATH_FONT_SCORE),
        fontHighScore: new ig.Font(Config.PATH_FONT_HIGHSCORE),
        blocks: [],
        smallBlocks: [],
        arrImgSmallBlocks: [],
        line: null,
        info: null,
        stand: null,
        scoreText: null,
        noOfBlocksText: null,
        lifeText: null,
        clouds: null,
        stars: null,
        lineBlock: null,
        score: 0,
        life: 0,
        noOfBlocks: 0,
        startDropBlockY: 0,
        missBlockRotateSpeed: 0,
        combo: 0,
        swingPeriod: 0,
        swingAmplitude: 0,
        swingPhase: 0,
        swingDistanceFromCentre: 0,
        startDropTime: 0,
        prevDropTime: 0,
        lastScrollTime: 0,
        lastSwingTime: 0,
        lastAngleTime: 0,
        dAngle: 0,
        enterNameIntent: 0,
        dropTimer: null,
        scrollTimer: null,
        swingTimer: null,
        missTimer: null,
        timer: null,
        timerLevel: null,
        timerOver: null,
        gamePrevState: Config.STATE_GAME_SWING,
        bGamePause: false,
        gameState: Config.STATE_GAME_SWING,
        curLevel: 1,
        init: function (arrParams) {
            this.parent(arrParams);
            for (var nI = 0; nI < 8; nI++) {
                this.arrImgSmallBlocks[nI] = new ig.Image(Config.PATH_IMG_SMALL_BLOCKS[nI]);
            }
            this.smallBlocks = [];
            this.fontScore.firstChar = 43;
            this.fontBlockCount.firstChar = 48;
            if (this.line != null) {
                this.line.destroy();
            }
            this.line = ig.game.spawnEntity(EntityLine, 0, 0, {});
            this.stand = {
                x: Config.SCREEN_WIDTH / 2,
                y: Config.SCREEN_HEIGHT - Config.SIZE_STAND_ENT.y * 0.2,
                width: Config.SCREEN_WIDTH,
                height: Config.SIZE_STAND_ENT.y * 0.6
            };
            this.score = 0;
            this.life = Config.LIFE;
            this.noOfBlocks = 0;
            this.curLevel = 1;
            if (this.info != null) {
                this.info.kill();
            }
            this.info = ig.game.spawnEntity(EntityInfo, 0, 0, null);
            this.startGame();
        },
        startGame: function () {
            this.timerLevel = new ig.Timer();
            this.timerLevel.set(Config.TIME_LEVEL);
            this.dropTimer = false;
            this.swingTimer = false;
            this.missTimer = false;
            this.scrollTimer = false;
            this.stand = {
                x: Config.SCREEN_WIDTH / 2,
                y: Config.SCREEN_HEIGHT - Config.SIZE_STAND_ENT.y * 0.2,
                width: Config.SCREEN_WIDTH,
                height: Config.SIZE_STAND_ENT.y * 0.6
            };
            if (this.clouds != null) this.clouds.destroy();
            this.clouds = ig.game.spawnComponent(Clouds, null);
            if (this.stars != null) this.stars.destroy();
            this.stars = ig.game.spawnComponent(Stars, null);
            this.combo = 0;
            this.noOfBlocks = 0;
            if (this.blocks != null) {
                for (var nI = 0; nI < this.blocks.length; nI++) {
                    this.blocks[nI].kill();
                }
            }
            this.blocks = new Array();
            this.smallBlocks = [];
            this.swingPeriod = 0;
            this.swingAmplitude = 0;
            this.swingPhase = 0;
            this.swingDistanceFromCentre = 0;
            this.setState(Config.STATE_GAME_SWING);
            this.startLine();
        },
        startLine: function () {
            var temp;
            temp = ig.game.spawnEntity(EntityBlock, 0, 0, {
                animNo: Math.round(Math.random() * 7)
            });
            this.lineBlock = temp;
            this.lastSwingTime = ig.Timer.time;
            this.swingTimer = true;
            var topThing = {
                x: 0,
                y: 0,
                width: 0,
                height: 0
            };
            if (this.blocks == null || this.blocks.length == 0) {
                topThing.x = this.stand.x;
                topThing.y = this.stand.y;
                topThing.width = this.stand.width;
                topThing.height = this.stand.height;
            } else {
                topThing.x = this.blocks[this.blocks.length - 1].center.x;
                topThing.y = this.blocks[this.blocks.length - 1].center.y;
                topThing.width = this.blocks[this.blocks.length - 1].size.x;
                topThing.height = this.blocks[this.blocks.length - 1].size.y;
            }
            this.line.startBlock(this.lineBlock, topThing.y - topThing.height / 2);
        },
        onSwingTime: function () {
            var time = ig.Timer.time;
            var i;
            if (this.blocks.length >= Config.BLOCK_SWINGHEIGHT) {
                this.swingPhase += ((time - this.lastSwingTime) % this.swingPeriod) / this.swingPeriod;
                this.swingDistanceFromCentre = this.swingAmplitude * Math.sin(this.swingPhase * Math.PI * 2);
                for (i = this.blocks.length - 1; i >= 0; i--) {
                    if (this.blocks[i].center.y - this.blocks[i].size.y / 2 > Config.BLOCK_MISSY) break;
                    this.blocks[i].center.x = this.blocks[i].centreX + this.swingDistanceFromCentre;
                }
            }
            this.lastSwingTime = time;
        },
        onDropMouseDown: function () {
            this.startDropBlockY = this.lineBlock.center.y;
            this.startDropTime = ig.Timer.time;
            var topThing = {
                x: 0,
                y: 0,
                width: 0,
                height: 0
            };
            if (this.blocks == null || this.blocks.length == 0) {
                topThing.x = this.stand.x;
                topThing.y = this.stand.y;
                topThing.width = this.stand.width;
                topThing.height = this.stand.height;
            } else {
                topThing.x = this.blocks[this.blocks.length - 1].center.x;
                topThing.y = this.blocks[this.blocks.length - 1].center.y;
                topThing.width = this.blocks[this.blocks.length - 1].size.x;
                topThing.height = this.blocks[this.blocks.length - 1].size.y;
            }
            var towerHigh = (topThing.y - topThing.height / 2);
            if (this.lineBlock.center.y + this.lineBlock.size.y / 2 > towerHigh + 10) {
                this.missTimer = true;
            } else {
                this.dropTimer = true;
                this.line.endBlock();
            }
        },
        onDropBlockTime: function () {
            var time = ig.Timer.time;
            var dTime = time - this.startDropTime;
            var distance = Config.BLOCK_ACCELERATION * dTime * dTime / 2;
            var topThing = {
                x: 0,
                y: 0,
                width: 0,
                height: 0
            };
            if (this.blocks == null || this.blocks.length == 0) {
                topThing.x = this.stand.x;
                topThing.y = this.stand.y;
                topThing.width = this.stand.width;
                topThing.height = this.stand.height;
            } else {
                topThing.x = this.blocks[this.blocks.length - 1].center.x;
                topThing.y = this.blocks[this.blocks.length - 1].center.y;
                topThing.width = this.blocks[this.blocks.length - 1].size.x;
                topThing.height = this.blocks[this.blocks.length - 1].size.y;
            }
            var towerHigh = (topThing.y - topThing.height / 2);
            if (((this.startDropBlockY + distance + this.lineBlock.size.y / 2) - towerHigh) > 10) distance = towerHigh + 10 - this.startDropBlockY - this.lineBlock.size.y / 2;
            this.lineBlock.center.y = this.startDropBlockY + distance;
            if (this.startDropBlockY + distance + this.lineBlock.size.y / 2 >= topThing.y - topThing.height / 2) {
                if (Math.abs(this.lineBlock.center.x - topThing.x) >= (topThing.width + this.lineBlock.size.x) / 2 - Config.BLOCK_MISSTOLERANCE) {
                    if (Math.abs(this.lineBlock.center.x - topThing.x) >= (topThing.width + this.lineBlock.size.x) / 2) {
                        this.missBlockRotateSpeed = 0;
                    } else {
                        this.startDropBlockY = this.lineBlock.center.y;
                        this.startDropTime = time;
                        this.missBlockRotateSpeed = this.lineBlock.center.x > topThing.x ? Config.BLOCK_MISSROTATESPEED : -Config.BLOCK_MISSROTATESPEED;
                        this.dAngle = 0;
                        this.lastAngleTime = time;
                    }
                    this.combo = 0;
                    this.dropTimer = false;
                    this.missTimer = true;
                } else {
                    this.lineBlock.center.y = topThing.y - topThing.height / 2 - this.lineBlock.size.y / 2 + Config.SIZE_BLOCK_OFFSET;
                    if (this.blocks.length > 0 && Math.abs(this.lineBlock.center.x - topThing.x) <= Config.BLOCK_PERFECTTOLERANCE) {
                        this.lineBlock.center.x = topThing.x;
                        this.showSparks(this.lineBlock);
                        this.showWaves(this.lineBlock);
                        this.addScore(this.lineBlock.center.x, this.lineBlock.center.y, Config.SCORE_PERFECT + Config.SCORE_COMBO * this.combo);
                        this.combo++;
                    } else {
                        this.addScore(this.lineBlock.center.x, this.lineBlock.center.y, Config.SCORE_NORMAL);
                        this.combo = 0;
                    }
                    this.lineBlock.currentAnim = this.lineBlock.anims.collision;
                    this.lineBlock.currentAnim.rewind();
                    this.lineBlock.centreX = this.lineBlock.center.x - this.swingDistanceFromCentre;
                    this.lineBlock.update();
                    this.blocks.push(this.lineBlock);
                    this.smallBlocks.push(this.lineBlock.animNo);
                    this.adjustSwing();
                    this.noOfBlocks++;
                    this.checkScroll();
                    this.dropTimer = false;
                    this.setState(Config.STATE_GAME_SWING);
                    this.startLine();
                }
            }
        },
        showSparks: function (block) {
            ig.game.spawnEntity(EntityBlockSpark, 0, 0, {
                block: block
            });
        },
        showWaves: function (block) {
            ig.game.spawnEntity(EntityWave, 0, 0, {
                block: block
            });
        },
        addScore: function (x, y, score) {
            ig.game.spawnEntity(EntityScorepopup, x, y, {
                score: score
            });
            this.score += score;
        },
        adjustSwing: function () {
            var distance;
            if (this.blocks.length < Config.BLOCK_SWINGHEIGHT) return;
            this.swingPeriod = Config.BLOCK_SWINGINITIALPERIOD + (this.blocks.length - Config.BLOCK_SWINGHEIGHT) * Config.BLOCK_SWINGPERIODINCREASE;
            if (this.swingPeriod > Config.BLOCK_SWINGMAXPERIOD) this.swingPeriod = Config.BLOCK_SWINGMAXPERIOD;
            this.swingAmplitude = Config.BLOCK_SWINGINITIALAMPLITUDE + (this.blocks.length - Config.BLOCK_SWINGHEIGHT) * Config.BLOCK_SWINGAMPLITUDEINCREASE;
            if (this.swingAmplitude > Config.BLOCK_SWINGMAXAMPLITUDE) this.swingAmplitude = Config.BLOCK_SWINGMAXAMPLITUDE;
        },
        checkScroll: function () {
            var topBlock;
            if (this.blocks.length == 0 || this.blocks == null) return;
            topBlock = this.blocks[this.blocks.length - 1];
            if (topBlock.center.y - topBlock.size.y / 2 > Config.BLOCK_SCROLLY) return;
            this.lastScrollTime = ig.Timer.time;
            if (this.scrollTimer) this.scrollTimer = false;
            this.scrollTimer = true;
        },
        onScrollTime: function () {
            var time = ig.Timer.time;
            var distance = (time - this.lastScrollTime) * Config.BLOCK_SCROLLSPEED;
            var topBlock;
            var i;
            topBlock = this.blocks[this.blocks.length - 1];
            if (topBlock.center.y - topBlock.size.y / 2 + distance > Config.BLOCK_SCROLLY) {
                distance = Config.BLOCK_SCROLLY - topBlock.center.y + topBlock.size.y / 2;
                this.scollTimer = false;
            }
            this.stand.y += distance;
            for (i = 0; i < this.blocks.length; i++) {
                this.blocks[i].center.y += distance;
            }
            this.clouds.scroll(distance);
            this.stars.scroll(distance);
            this.lastScrollTime = time;
        },
        onMissBlockTime: function () {
            var time = ig.Timer.time;
            var dTime = time - this.startDropTime;
            var distance = Config.BLOCK_ACCELERATION * dTime * dTime / 2;
            var dAngleTime = time - this.lastAngleTime;
            this.dAngle += dAngleTime;
            this.lastAngleTime = time;
            this.lineBlock.center.y = this.startDropBlockY + distance;
            this.lineBlock.currentAnim.angle = this.missBlockRotateSpeed * this.dAngle;
            if (this.lineBlock.center.y > Config.BLOCK_MISSY) {
                this.missTimer = false;
                this.lineBlock.kill();
                this.life--;
                if (!this.checkGameOver()) {
                    this.setState(Config.STATE_GAME_SWING);
                    this.startLine();
                } else {
                    this.setState(Config.STATE_GAME_OVER);
                }
            }
        },
        checkGameOver: function () {
            if (this.life > 0) return false;
            return true;
        },
        keyCheck: function () {
            switch (this.gameState) {
                case Config.STATE_GAME_READY:
                    this.keyCheckGameReady();
                    break;
                case Config.STATE_GAME_SWING:
                    this.keyCheckGameSwing();
                    break;
                case Config.STATE_GAME_DROP:
                    this.keyCheckGameDrop();
                    break;
                case Config.STATE_GAME_QUIT:
                    this.keyCheckGameQuit();
                    break;
                case Config.STATE_GAME_OVER:
                    this.keyCheckGameOver();
                    break;
                case Config.STATE_ENTER_NAME:
                    this.keyCheckEnterName();
                    break;
                case Config.STATE_LEVEL_COMPLETE:
                    this.keyCheckLevelComplete();
                    break;
            }
        },
        setState: function (state) {
            this.gameState = state;
        },
        enterName: function () {
            var str = ig.$('#highscore').value.toUpperCase();
            var length = str.length;
            this.fontHighScore.draw(str, Config.POS_ENTERNAME.x - this.fontHighScore.widthForString(str) / 2, Config.POS_ENTERNAME.y + Config.ENTERNAME_INTENT);
        },
        isEnterName: function () {
            var that = this;
            var req = $.ajax({
                url: ("http://towerjelly.justplaymobile.com/game.php" + '?nocache=' + Math.random()),
                data: {
                    a: 'l'
                },
                dataType: 'json',
                async: false,
                success: function (scores) {
                    that.arrHighScore = scores;
                }
            });
            if (this.arrHighScore[Config.MAX_HIGHSCORE_COUNT - 1] == undefined || (this.arrHighScore[Config.MAX_HIGHSCORE_COUNT - 1] != undefined && this.score > this.arrHighScore[Config.MAX_HIGHSCORE_COUNT - 1].score)) {
                return true;
            } else {
                return false;
            }
        },
        createHighScoreEdit: function () {
            var elem = document.getElementById("myBody");
            var newChild = document.createElement("input");
            newChild.type = "text";
            newChild.id = "highscore";
            newChild.setAttribute('maxlength', 10);
            elem.appendChild(newChild);
            ig.$('#highscore').value = '';
            $('#highscore').css('position', 'absolute');
            $('#highscore').css('border', '3px solid');
            $('#highscore').css('left', 0);
            $('#highscore').css('top', 0);
            $('#highscore').css('width', Config.SIZE_INPUTBOX.x);
            $('#highscore').css('height', Config.SIZE_INPUTBOX.y);
            $('#highscore').css('background-color', 'transparent');
            $('#highscore').css('color', 'transparent');
            $('#highscore').css('z-index', 10);
            $('#canvas').css('z-index', 0);
            $('#highscore').bind('blur', function () {
                window.scrollTo(0, 1);
                Config.ENTERNAME_INTENT = 0;
            });
            $('#highscore').bind('focus', function () {
                Config.ENTERNAME_INTENT = Config.ENTERNAME_REAL_VALUE;
            });
            ig.$("#highscore").focus();
        },
        destroy: function () {
            if (this.clouds != null) this.clouds.destroy();
            if (this.stars != null) this.stars.destroy();
            if (this.line != null) this.line.destroy();
            if (this.lineBlock != null) this.lineBlock.kill();
            if (this.info != null) this.info.kill();
            if (this.blocks != null) {
                for (var nI = 0; nI < this.blocks.length; nI++) {
                    this.blocks[nI].kill();
                }
            }
            var arrScorePopup = ig.game.getEntitiesByType(EntityScorepopup);
            if (arrScorePopup != null) {
                for (var nI = 0; nI < arrScorePopup.length; nI++) {
                    if (arrScorePopup[nI] != undefined) arrScorePopup[nI].kill();
                }
            }
            var arrBlockSpark = ig.game.getEntitiesByType(EntityBlockSpark);
            if (arrBlockSpark != null) {
                for (var nI = 0; nI < arrBlockSpark.length; nI++) {
                    if (arrBlockSpark[nI] != undefined) arrBlockSpark[nI].kill();
                }
            }
            var arrWave = ig.game.getEntitiesByType(EntityWave);
            if (arrWave != null) {
                for (var nI = 0; nI < arrWave.length; nI++) {
                    if (arrWave[nI] != undefined) arrWave[nI].kill();
                }
            }
            this.parent();
        },
        update: function () {
            this.parent();
            this.keyCheck();
            switch (this.gameState) {
                case Config.STATE_GAME_READY:
                    this.doGameReady();
                    break;
                case Config.STATE_GAME_SWING:
                    this.doGameSwing();
                    break;
                case Config.STATE_GAME_DROP:
                    this.doGameDrop();
                    break;
                case Config.STATE_GAME_QUIT:
                    this.doGameQuit();
                    break;
                case Config.STATE_GAME_OVER:
                    this.doGameOver();
                    break;
                case Config.STATE_ENTER_NAME:
                    this.doEnterName();
                    break;
                case Config.STATE_LEVEL_COMPLETE:
                    this.doLevelComplete();
                    break;
            }
        },
        draw: function () {
            this.parent();
            switch (this.gameState) {
                case Config.STATE_GAME_READY:
                    this.drawGameReady();
                    break;
                case Config.STATE_GAME_SWING:
                    this.drawGameSwing();
                    break;
                case Config.STATE_GAME_DROP:
                    this.drawGameDrop();
                    break;
                case Config.STATE_GAME_QUIT:
                    this.drawGameQuit();
                    break;
                case Config.STATE_GAME_OVER:
                    this.drawGameOver();
                    break;
                case Config.STATE_ENTER_NAME:
                    this.drawEnterName();
                    break;
                case Config.STATE_LEVEL_COMPLETE:
                    this.drawLevelComplete();
                    break;
            }
        },
        keyCheckGameReady: function () {},
        keyCheckGameSwing: function () {
            if (ig.input.pressed('mouse')) {
                var x = ig.input.mouse.x;
                var y = ig.input.mouse.y;
                if (this.checkCursorInArea(x, y, Config.POS_IMG_QUIT_BUTTON.x, Config.POS_IMG_QUIT_BUTTON.y, this.imgQuitButton.width, this.imgQuitButton.height)) {
                    this.gamePrevState = Config.STATE_GAME_SWING;
                    this.bGamePause = true;
                    this.setState(Config.STATE_GAME_QUIT);
                    return;
                }
                this.setState(Config.STATE_GAME_DROP);
                this.onDropMouseDown();
            }
        },
        keyCheckGameDrop: function () {
            if (ig.input.pressed('mouse')) {
                var x = ig.input.mouse.x;
                var y = ig.input.mouse.y;
                if (this.checkCursorInArea(x, y, Config.POS_IMG_QUIT_BUTTON.x, Config.POS_IMG_QUIT_BUTTON.y, this.imgQuitButton.width, this.imgQuitButton.height)) {
                    this.gamePrevState = Config.STATE_GAME_DROP;
                    this.bGamePause = true;
                    this.setState(Config.STATE_GAME_QUIT);
                    return;
                }
            }
        },
        keyCheckGameQuit: function () {
            if (ig.input.pressed('mouse')) {
                var x = ig.input.mouse.x;
                var y = ig.input.mouse.y;
                if (this.checkCursorInArea(x, y, Config.POS_IMG_YES_BUTTON.x, Config.POS_IMG_YES_BUTTON.y, Config.SIZE_IMG_YES_BUTTON.x, Config.SIZE_IMG_YES_BUTTON.y)) {
                    var arrParams = [];
                    arrParams[0] = Config.STATE_MAIN_MENU;
                    var menu = ig.game.spawnComponent(Menu, arrParams);
                    this.destroy();
                    return;
                } else if (this.checkCursorInArea(x, y, Config.POS_IMG_NO_BUTTON.x, Config.POS_IMG_NO_BUTTON.y, Config.SIZE_IMG_NO_BUTTON.x, Config.SIZE_IMG_NO_BUTTON.y)) {
                    this.bGamePause = false;
                    if (this.gamePrevState == Config.STATE_GAME_SWING) {
                        this.setState(Config.STATE_GAME_SWING);
                    } else if (this.gamePrevState == Config.STATE_GAME_DROP) {
                        this.setState(Config.STATE_GAME_DROP);
                        this.onDropMouseDown();
                    }
                }
            }
        },
        keyCheckGameOver: function () {
            if (ig.input.pressed('mouse')) {
                var x = ig.input.mouse.x;
                var y = ig.input.mouse.y;
                if (this.checkCursorInArea(x, y, Config.POS_IMG_PLAYAGAIN_BUTTON.x, Config.POS_IMG_PLAYAGAIN_BUTTON.y, this.imgPlayAgainButton.width, this.imgPlayAgainButton.height)) {
                    this.init(null);
                    return;
                }
                if (this.checkCursorInArea(x, y, Config.POS_IMG_ENTERHIGHSCORE_BUTTON.x, Config.POS_IMG_ENTERHIGHSCORE_BUTTON.y, this.imgEnterHighScoreButton.width, this.imgEnterHighScoreButton.height)) {
                    if (this.clouds != null) this.clouds.destroy();
                    if (this.stars != null) this.stars.destroy();
                    if (this.info != null) this.info.kill();
                    if (this.blocks != null) {
                        for (var nI = 0; nI < this.blocks.length; nI++) {
                            this.blocks[nI].kill();
                        }
                    }
                    if (this.line != null) {
                        this.line.destroy();
                    }
                    if (this.isEnterName()) {
                        this.createHighScoreEdit();
                        this.setState(Config.STATE_ENTER_NAME);
                    } else {
                        var arrParams = [];
                        arrParams[0] = Config.STATE_HIGH_SCORE;
                        var menu = ig.game.spawnComponent(Menu, arrParams);
                        menu.getArrayHighScore();
                        this.destroy();
                    }
                    return;
                }
            }
        },
        keyCheckEnterName: function () {
            if (ig.input.pressed('mouse')) {
                var x = ig.input.mouse.x;
                var y = ig.input.mouse.y;
                if (this.checkCursorInArea(x, y, Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y, this.imgBackButton.width, this.imgBackButton.height)) {
                    var name = ig.$('#highscore').value.toUpperCase();
                    if (name == '') {
                        return;
                    }
                    var that = this;
                    var req = $.ajax({
                        url: ("http://towerjelly.justplaymobile.com/game.php" + '?nocache=' + Math.random()),
                        data: {
                            a: 's',
                            n: name,
                            s: this.score
                        },
                        dataType: 'json',
                        async: false,
                        success: function (scores) {
                            that.arrHighScore = scores;
                        }
                    });
                    var arrParams = [];
                    arrParams[0] = Config.STATE_HIGH_SCORE;
                    var menu = ig.game.spawnComponent(Menu, arrParams);
                    menu.getArrayHighScore();
                    this.destroy();
                    $('#highscore').css('width', 0);
                    $('#highscore').css('height', 0);
                    $('#highscore').css('z-index', 0);
                    $('#canvas').css('z-index', 10);
                    var elem = document.getElementById("myBody");
                    var elemChild = document.getElementById("highscore");
                    elem.removeChild(elemChild);
                    $('#canvas').focus();
                }
            }
        },
        keyCheckLevelComplete: function () {},
        doGameReady: function () {
            if (this.timerLevel.delta() >= 0) {
                this.setState(Config.STATE_GAME_SWING);
                this.startLine();
            }
        },
        doGameSwing: function () {
            if (this.swingTimer == true) {
                this.onSwingTime();
            }
            if (this.scrollTimer == true) {
                this.onScrollTime();
            }
        },
        doGameDrop: function () {
            if (this.dropTimer == true) {
                this.onDropBlockTime();
            } else if (this.missTimer == true) {
                this.onMissBlockTime();
            }
            if (this.swingTimer == true) {
                this.onSwingTime();
            }
            if (this.scrollTimer == true) {
                this.onScrollTime();
            }
        },
        doGameQuit: function () {
            if (this.bGamePause == true) {
                this.lastScrollTime = ig.Timer.time;
                this.lastSwingTime = ig.Timer.time;
                this.lastAngleTime = ig.Timer.time;
            }
        },
        doGameOver: function () {},
        doEnterName: function () {},
        doLevelComplete: function () {
            if (this.timerOver.delta() >= 0) {
                this.curLevel++;
                this.startGame();
            }
        },
        drawGameReady: function () {
            this.imgGameBack.draw(0, 0);
            this.imgStandEnt.draw(this.stand.x - this.stand.width / 2, this.stand.y - this.stand.height / 2 - Config.SIZE_STAND_ENT.y * 0.5);
        },
        drawGameSwing: function () {
            this.imgGameBack.draw(0, 0);
            this.imgStandEnt.draw(this.stand.x - this.stand.width / 2, this.stand.y - this.stand.height / 2 - Config.SIZE_STAND_ENT.y * 0.5);
            if (this.blocks != null && this.blocks.length > 0) this.imgBlockShadowEnt.draw(this.blocks[0].center.x - this.imgBlockShadowEnt.width / 2, this.stand.y - this.imgBlockShadowEnt.height / 2 - Config.SIZE_STAND_ENT.y * 0.35);
        },
        drawGameDrop: function () {
            this.imgGameBack.draw(0, 0);
            this.imgStandEnt.draw(this.stand.x - this.stand.width / 2, this.stand.y - this.stand.height / 2 - Config.SIZE_STAND_ENT.y * 0.5);
            if (this.blocks != null && this.blocks.length > 0) this.imgBlockShadowEnt.draw(this.blocks[0].center.x - this.imgBlockShadowEnt.width / 2, this.stand.y - this.imgBlockShadowEnt.height / 2 - Config.SIZE_STAND_ENT.y * 0.35);
        },
        drawGameQuit: function () {
            this.imgGameBack.draw(0, 0);
            this.imgStandEnt.draw(this.stand.x - this.stand.width / 2, this.stand.y - this.stand.height / 2 - Config.SIZE_STAND_ENT.y * 0.5);
            if (this.blocks != null && this.blocks.length > 0) this.imgBlockShadowEnt.draw(this.blocks[0].center.x - this.imgBlockShadowEnt.width / 2, this.stand.y - this.imgBlockShadowEnt.height / 2 - Config.SIZE_STAND_ENT.y * 0.35);
        },
        drawGameOver: function () {
            this.imgGameBack.draw(0, 0);
            this.imgStandEnt.draw(this.stand.x - this.stand.width / 2, this.stand.y - this.stand.height / 2 - Config.SIZE_STAND_ENT.y * 0.5);
            if (this.blocks != null && this.blocks.length > 0) this.imgBlockShadowEnt.draw(this.blocks[0].center.x - this.imgBlockShadowEnt.width / 2, this.stand.y - this.imgBlockShadowEnt.height / 2 - Config.SIZE_STAND_ENT.y * 0.35);
        },
        drawEnterName: function () {
            this.imgGameBack.draw(0, 0);
            this.imgDefaultBox.draw(Config.POS_DEFAULT_BOX2.x, Config.POS_DEFAULT_BOX2.y);
            this.imgTapScreenText.draw(Config.POS_TAPSCREEN_TEXT.x, Config.POS_TAPSCREEN_TEXT.y);
            this.imgBackButton.draw(Config.POS_IMG_BACK_BUTTON.x, Config.POS_IMG_BACK_BUTTON.y);
            this.enterName();
        },
        drawLevelComplete: function () {
            this.imgGameBack.draw(0, 0);
            this.imgStandEnt.draw(this.stand.x - this.stand.width / 2, this.stand.y - this.stand.height / 2 - Config.SIZE_STAND_ENT.y * 0.5);
        },
    });
});

// lib/game/main.js
ig.baked = true;
ig.module('game.main').requires('impact.game', 'game.src.engine', 'game.src.menu', 'game.src.config', 'impact.font').defines(function () {
    MyGame = ig.Game.extend({
        bStart: false,
        animBlocks: [],
        init: function () {
            if (ig.ua.android) {
                window.scrollTo(0, 10);
            } else {
                setTimeout(function () {
                    window.scrollTo(0, 0);
                }, 1);
            }
            ig.input.bind(ig.KEY.MOUSE1, 'mouse');
            ig.input.initMouse();
            this.animBlocks = [];
            this.animBlocks[0] = new ig.AnimationSheet(Config.PATH_IMG_RED_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[1] = new ig.AnimationSheet(Config.PATH_IMG_BLUE_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[2] = new ig.AnimationSheet(Config.PATH_IMG_CYAN_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[3] = new ig.AnimationSheet(Config.PATH_IMG_GREEN_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[4] = new ig.AnimationSheet(Config.PATH_IMG_LIME_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[5] = new ig.AnimationSheet(Config.PATH_IMG_PINK_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[6] = new ig.AnimationSheet(Config.PATH_IMG_PURPLE_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
            this.animBlocks[7] = new ig.AnimationSheet(Config.PATH_IMG_YELLOW_BLOCK_ANIM, Config.SIZE_BLOCK_ENT.x, Config.SIZE_BLOCK_ENT.y);
        },
        update: function () {
            this.parent();
            if (!this.bStart) {
                var arrParams = [];
                arrParams[0] = Config.STATE_SPLASH;
                this.spawnComponent(Menu, arrParams);
                this.bStart = true;
            }
        },
        draw: function () {
            this.parent();
        },
    });
    ig.main('#canvas', MyGame, 30, 320, 480, 1);
});