(function(window, undefined){

var Ant = {};

/**
 *  hozzáadja a hiányzó mezőket (nem ír felül)
 *  @param   {Object}   to     amihez hozzáadjuk a mezőket
 *  @param   {Object}   from   amiből kimásoljuk a mezőket
 * [@param   {String[]} fields mezőnevek amiket szeretnénk átvenni, ha üres akkor mindent]
 *  @return  {Object}          bővített objektum */
var include = Ant.include = function(to, from, fields){
    if (fields === undefined || fields.length === 0){
        fields = [];
        for (i in from)
            fields.push(i);
    }

    for (i in fields){
        var a = fields[i];
        if (to[a] === undefined)
            to[a] = from[a];
    }

    return to;
};

var extend = Ant.extend = function(a, b){
    for (i in b){
        if (a[i] === undefined)
            a[i] = b[i];
    }
/*
    var tmp = Child.prototype;
    Child.prototype = new Parent();
    Child.prototype.constructor = Child;

    for (i in Child.prototype)
        console.log(i);
    for (i in tmp)
        Child.prototype[i] = tmp[i];*/
};

var clone = Ant.clone = function(obj){
    var r = {};
    for (i in obj){
        if (typeof obj[i] === 'object')
            clone(obj);
        else
            r[i] = obj[i];
    }
    return r;
};

var isArray = function(a){
    return Array.isArray(a);
}

//TODO valami antes objektum összefésülés
/*var implement = Object.prototype.implement = function(obj){
    for (i in obj){
        if (typeof obj[i] === 'object'){
            if (this[i])
                this[i].implement(obj[i]);
            else{
                this[i] = {};
                this[i].implement(obj[i]);
            }
        }else{
            this[i] = obj[i];
        }
    }
};

var Any = Ant.Any = {
    implement: implement,
    clone: function(){
        var r = {};
        for (i in this){
            if (this[i] && typeof this[i] === 'object'){
                r[i] = this[i].clone();
            }else{
                r[i] = this[i];
            }
        }
        r.prototype = this.prototype;
        return r;
    }
};*/

Ant.Matrix = function(w, h, def){
    if (def === undefined)
        var def = 0;
    
    for (var i = 0; i < w; ++i){
        this[i] = [];
        for (var j = 0; j < h; ++j)
            this[i][j] = def;
    }
    this.width = this.w = w;
    this.height = this.h = h;
    this.def = def;
};
Ant.Matrix.prototype = [];

Ant.Point = function(x, y){
    this.x = x;
    this.y = y;
};
Ant.Point.prototype = {
    add: function(p){
        this.x += p.x;
        this.y += p.y;
        return this;
    },

    sub: function(p){
        this.x -= p.x;
        this.y -= p.y;
        return this;
    },

    multiply: function(z){
        if (typeof z === 'number'){
            this.x *= z;
            this.y *= z;
        }else if (z instanceof Ant.Point){
            //TODO vektor szorzás
        }
        return this;
    },

    magnitudesq: function(){
        return this.x * this.x + this.y * this.y;
    },

    magnitude: function(){
        return Math.sqrt(this.magnitudesq());
    },

    clone: function(){
        return new Ant.Point(this.x, this.y);
    },

    inRect: function(x, y, x2, y2){
        if (arguments.length === 2)
            return this.inRect(0, 0, x, y);
        return this.x >= x && this.y >= y && this.x < x2 && this.y < y2;
    }
};
Ant.Point.directions = [
    new Ant.Point(0, 1),
    new Ant.Point(1, 0),
    new Ant.Point(0, -1),
    new Ant.Point(-1, 0)
];

Ant.p = function(x, y){
    return new Ant.Point(x, y);
};

/**
 * megnézi két objektum ütközését, amiknek van x, y koordinátája
 * és (w, h) || (widht, height) || (x2, x2) -je
 * @param  {Rect} a
 * @param  {Rect} b
 * @return {Boolean}
 */
Ant.rectOverlaps = function(a, b){
    //TODO sztem ez nem jó mert nem csak akkor ütközhetnek ha csúcsok egymásban vannak, pl nagy méretkülnbségek
    if (a.x2 === undefined){
        if (a.w !== undefined)
            a.x2 = a.x + a.w;
        else if (a.width !== undefined)
            a.x2 = a.x + a.width;
    }
    if (a.y2 === undefined){
        if (a.h !== undefined)
            a.y2 = a.y + a.h;
        else if (a.height !== undefined)
            a.y2 = a.y + a.height;
    }

    return a.y <= b.y2 && a.y2 >= b.y && a.x <= b.x2 && a.x2 >= b.x;
}

var Nil = {
    depth: 0,
    maxTop: -1
};

/**
 * AVL fa...
 * rendező függvény felülírható: compare(a, b) -> -1|0|1
 */
Ant.AVL = function(){
    this.root = Nil;
};

Ant.AVL.Node = function(key, val){
    this.key = key;
    this.val = val;
    this.right = Nil;
    this.left = Nil;
    this.parent = Nil;
    this.depth = 1;
};

Ant.AVL.prototype = {
    compare: function(a, b){
        if(a == b)
            return 0;
        if(a < b)
            return -1;
        return 1;
    },
    
    getNode: function(key){
        var f = this.root;
        var c;
        while(f !== Nil && c !== 0){
            c = this.compare(f.key, key);
            if(c === -1)
                f = f.right;
            else if (c === 1)
                f = f.left;
        }
        
        return f;
    },

    get: function(key){
        var f = this.getNode(key);
        if (f === Nil)
            return null;
        return f.val;
    },

    /**
     * elem hozzáadása a fához, ha van már iylesn kulcs, akkor felülírja
     * @param key kulcs
     * @param val érték
     * @return {AVL.Node} gyorsabb törléshez pl, amúgy nem nyúlkapiszka
     */
    add: function(key, val){
        var node = new Ant.AVL.Node(key, val);
        if (this.root === Nil){
            this.root = node;
            return;
        }
        
        var c; //compare eredményét tároljuk
        var f = this.root;
        var parent = Nil;
        while(f !== Nil && c !== 0){
            parent = f;
            c = this.compare(f.key, key); //mindig a rootét használjuk
            if (c === -1)
                f = f.right;
            else if (c === 1)
                f = f.left;
        }
        
        if (f !== Nil){
            f.val = val;
            return;
        }
        
        if (c === -1)
            parent.right = node;
        else
            parent.left = node;
        node.parent = parent;
        this.update(node);
        return node;
    },
    
    remove: function(key){
        var node = this.getNode(key);
        if (node !== Nil)
            this.removeNode(node);
    },

    removeNode: function(node){
        if (isArray(node)){
            for (var i=0; i<node.length; ++i)
                this.removeNode(node[i]);
            return;
        }

        if (node.left !== Nil && node.right !== Nil){
            var prev = node.left;
            while(prev.right !== Nil)
                prev = prev.right;
            node.key = prev.key;
            node.val = prev.val;
            this.removeNode(prev);

        }else if(node.left !== Nil){
            this.changeChild(node, node.left);
            this.update(node.parent);
        
        }else if(node.right !== Nil){
            this.changeChild(node, node.right);
            this.update(node.parent);
        
        }else{
            this.changeChild(node, Nil);
            this.update(node.parent);
        }
    },

    getKeys: function(){
        var r = [];
        this._getKeys(this.root, r);
        return r;
    },

    _getKeys: function(node, r){
        if (node === Nil)
            return;
        this._getKeys(node.left, r);
        r.push(node.key);
        this._getKeys(node.right, r);
    },

    getVals: function(){
        var r = [];
        this._getVals(this.root, r);
        return r;
    },

    _getVals: function(node, r){
        if (node === Nil)
            return;
        this._getVals(node.left, r);
        r.push(node.val);
        this._getVals(node.right, r);
    },

    /**
     * fölfelé bejárja a fát és beálltija a mélységeket
     * ha kell balancol, utána  a balance küldi vissza updatelni
     * */
    update: function(node){
        var ld = node.left.depth;
        var rd = node.right.depth;
        var d = rd - ld;
        if (d > 1 || d < -1){
            this.balance(node, d);
            return;
        }

        node.depth = (ld > rd ? ld : rd) + 1;
        
        if (node.parent !== Nil)
            this.update(node.parent);
    },

    balance: function(node, d){
        if (d == 2){
            var rld = node.right.left.depth;
            var rrd = node.right.right.depth;
            if (node.right !== Nil && rld > rrd){
                this.rotateRight(node.right);

                var ld = node.right.left.depth;
                var rd = node.right.right.depth;
                node.right.depth = (ld > rd ? ld : rd) + 1;
            }
            this.rotateLeft(node);
        }else if (d == -2){
            var lld = node.left.left.depth;
            var lrd = node.left.right.depth;
            if (node.left !== Nil && lld < rrd){
                this.rotateLeft(node.left);

                var ld = node.left.left.depth;
                var rd = node.left.right.depth;
                node.left.depth = (ld > rd ? ld : rd) + 1;
            }
            this.rotateRight(node);
        }
        this.update(node);
    },

    rotateRight: function(x){
        var y = x.left;
        x.left = y.right;
        if (x.left !== Nil)
            x.left.parent = x;
        if (x.parent !== Nil)
            this.changeChild(x, y);
        else
            this.root = y;
        y.right = x;
        y.parent = x.parent;
        x.parent = y;
    },
    
    rotateLeft: function(x){
        var y = x.right;
        x.right = y.left;
        if (x.right !== Nil)
            x.right.parent = x;
        if (x.parent !== Nil)
            this.changeChild(x, y);
        else
            this.root = y;
        y.left = x;
        y.parent = x.parent;
        x.parent = y;
    },

    /**
     * kicseréli n-t nc-re a gyerekek közül
     * és beállitja a szülőt
     * @param {Node} c  cserélendő
     * @param {Node} nc amire cseréljük
     * */
    changeChild: function(c, nc){
        var node = c.parent;
        if (node === Nil)
            this.root = c;
        else if (node.right === c)
            node.right = nc;
        else if (node.left === c)
            node.left = nc;
        if (nc !== Nil)
            nc.parent = node;
    }
};

Ant.Interval = function(bottom, top){
    this.bottom = bottom;
    this.top = top;
};

Ant.IntervalTree = function(){
    this.root = Nil;
};
Ant.IntervalTree.Node = function(key, val){
    this.key = key;
    this.val = val;
    this.right = Nil;
    this.left = Nil;
    this.parent = Nil;
    this.depth = 1;
    this.maxTop = 0;
};
Ant.IntervalTree.prototype =  {
    compare: function(a, b){
        if(a.bottom <= b.bottom)
            return -1;
        return 1;
    },
    
    overlap: function(a, b){
        return a.bottom <= b.bottom && b.bottom <= a.top ||
               a.bottom <= b.top    && b.top    <= a.top ||
               a.bottom >= b.bottom && b.top    >= a.top ; 
    },

    /**
     * összes objektum amivel ütközik
     * @param  {Interval} irvl amivel ütköztetünk
     * @return {obj[]}         talált objektumok
     */
    getAll: function(irvl){
        var r = [];
        this._getAllVal(irvl, this.root, r);
        return r;
    },

    _getAllVal: function(irvl, node, r){
        if (this.overlap(node.key, irvl))
            r.push(node.val);
        
        if (node.left !== Nil && node.left.maxTop >= irvl.bottom)
            this._getAllVal(irvl, node.left, r);
        if (node.right !== Nil && node.right.key.bottom <= irvl.top)
            this._getAllVal(irvl, node.right, r);
    },
    
    /**
     * összes objektum node-ja amivel ütközik
     * @param  {Interval} irvl amivel ütköztetünk
     * @return {Node[]}        talált objektumok
     */
    getAllNodes: function(irvl){
        var r = [];
        this._getAllNodes(irvl, this.root, r);
        return r;
    },

    _getAllNodes: function(irvl, node, r){
        if (this.overlap(node.key, irvl))
            r.push(node);
        
        if (node.left !== Nil && node.left.maxTop >= irvl.bottom)
            this._getAllNodes(irvl, node.left, r);
        if (node.right !== Nil && node.right.key.bottom <= irvl.top)
            this._getAllNodes(irvl, node.right, r);
    },

    /**
     * visszadja a legelső objektumot amivel üzközik
     * @param  {Interval} irvl
     * @return {obj}
     */
    getFirst: function(irvl){
        var f = this.root;
        while (true){
            if (this.overlap(f.key, irvl))
                return f.val;
            if (f.left !== Nil && f.left.maxTop >= irvl.bottom)
                f = f.left;
            else if (f.right !== Nil && f.right.key.bottom <= irvl.top)
                f = f.right;
            else
                return null;
        }
    },

    /**
     * elem hozzáadása a fához, visszadja a létrehozott nodeot
     * a gyorsabb törléshez(nem kell majd megkeresni), amúgy nem nyúlkapiszka
     * @param key kulcs
     * @param val érték
     * @return {obj}
     */
    add: function(key, val){
        var node = new Ant.IntervalTree.Node(key, val);
        if (this.root === Nil){
            this.root = node;
            return;
        }
        
        var c; //compare eredményét tároljuk
        var f = this.root;
        var parent = Nil;
        while(f !== Nil){
            parent = f;
            c = this.compare(f.key, key); //mindig a rootét használjuk
            if (c === -1)
                f = f.right;
            else if (c === 1)
                f = f.left;
        }
        
        if (c === -1)
            parent.right = node;
        else
            parent.left = node;
        node.parent = parent;
        this.update(node);
        return node;
    },
    
    removeAll: function(irvl){
        this.removeNode(this.getAllNodes(irvl));
    },

    /**
     * fölfelé bejárja a fát és beálltija a mélységeket
     * ha kell balancol, utána  a balance küldi vissza updatelni
     * */
    update: function(node){
        var ld = node.left.depth;
        var rd = node.right.depth;
        var d = rd - ld;
        if (d > 1 || d < -1){
            this.balance(node, d);
            return;
        }

        var lm = node.left.maxTop;
        var rm = node.right.maxTop;
        node.maxTop = (lm > rm ? lm : rm);
        if (node.key.top > node.maxTop)
            node.maxTop = node.key.top;

        node.depth = (ld > rd ? ld : rd) + 1;
        
        if (node.parent !== Nil)
            this.update(node.parent);
    }
};
//extend(Ant.IntervalTree, Ant.IntervalTree);
include(Ant.IntervalTree.prototype, Ant.AVL.prototype, 
    ['rotateLeft', 'rotateRight', 'changeChild', 'removeNode', 'balance',
     'getVals', '_getVals', 'getKeys', '_getKeys']);

//export
window.Ant = window._ = Ant;

})(window);