(function(window, _, AntG, undefined){

var g, players, ball, interval, tickables = [];

var FingerBall = {};
FingerBall.init = function(playerCount, antg){
	g = antg;
	g.add(new AntG.Pic({
		url: "img/gms/fingerball/center.png",
		x: (window.width() - 500) / 2,
		y: (window.height() - 77) / 2,
		w: 500,
		h: 77
	}));
	g.add(new AntG.Pic({
		url: "img/gms/fingerball/line0.png",
		x: 0,
		y: 0,
		w: window.width(),
		h: 5
	}));
	g.add(new AntG.Pic({
		url: "img/gms/fingerball/line1.png",
		x: 0,
		y: window.height() - 5,
		w: window.width(),
		h: 5
	}));
	g.add(new AntG.Pic({
		url: "img/gms/fingerball/line2.png",
		x: 0,
		y: 0,
		w: 7,
		h: 1000
	}));
	g.add(new AntG.Pic({
		url: "img/gms/fingerball/line2.png",
		x: window.width() - 7,
		y: window.height() - 1000,
		w: 7,
		h: 1000
	}));

	FingerBall.players = players = [];
	if (playerCount == 2)
		players[0] = new Player(0);
	else
		players[0] = new CPU(0);
	
	players[1] = new Player(1);
	
	ball = new Ball();

	interval = setInterval(run, 60);
	window.ball = ball;
	window.players = players;
};

var run = function(){
	ball.run();

	var kapuSize = 10 / 32 * window.width();

	//gólok
	if (ball.pos.x > (window.width() - kapuSize) / 2 && ball.pos.x < (window.width() + kapuSize) / 2){
		if (ball.pos.y < ball.r){
			players[0].addPoint();
			if (players[0].point > 2)
				win(0)
			else
				goal();
		}else if (ball.pos.y > window.height() - ball.r){
			players[1].addPoint();
			if (players[1].point > 2)
				win(1)
			else
				goal();
		}
	}

	//playerejjek ütközés
	for (var i = players.length - 1; i >= 0; i--) {
		if (players[i].intersect()){
			var n = players[i].pos.clone().sub(ball.pos); //tengely normálvektora			
			var o = new _.Point( (ball.pos.x + players[i].pos.x) / 2, 
				(ball.pos.y + players[i].pos.y) / 2);
			var v = o.clone().sub(ball.speed);

			var a = - n.x / n.y;
			var c = n.x * o.x / n.y + o.y;
			var d = (v.x + (v.y - c) * a) / (1 + a * a);

			var t = new _.Point();
			t.x = 2 * d - v.x;
			t.y = 2 * d * a - v.y + 2 * c;

			ball.speed = o.clone().sub(t).multiply(1.1);
			ball.pos.add(ball.speed);
		}
	};

	for (var i = 0; i < tickables.length; ++i)
		tickables[i].run();
}

/**
 * a középpontot jelöli a pozíció és körökkel számolunk
 */
var Player  = FingerBall.Player = function (side) {
	this.imgR = this.r * 1.5;
	if (side === 0){
		this.pos = new _.Point( window.width() / 2 , window.height() / 4 );
	}else{
		this.pos = new _.Point(  window.width() / 2, window.height() * 3 / 4 );
	}
	this.side = side;

	this.pic = g.add(new AntG.Pic({
		url: "img/gms/fingerball/player-" + side + ".png",
		x: this.pos.x - this.imgR,
		y: this.pos.y - this.imgR,
		w: 2 * this.imgR,
		h: 2 * this.imgR
	}));

	this.point = 0;
};

Player.prototype = {
	r: 25,

	setPos: function(pos){
		var old = this.pos.clone();
		if (pos.x < this.r)
			this.pos.x = this.r;
		else if (pos.x > window.width() - this.r)
			this.pos.x = window.width() - this.r;
		else
			this.pos.x = pos.x;

		if (this.side === 0 && pos.y > window.height() / 2)
			this.pos.y = window.height() / 2;
		else if (this.side === 1 && pos.y < window.height() / 2)
			this.pos.y = window.height() / 2;
		else if (pos.y < this.r)
			this.pos.y = this.r;
		else if (pos.y > window.height() - this.r)
			this.pos.y = window.height() - this.r;
		else
			this.pos.y = pos.y;

		this.pic.x = this.pos.x - this.imgR;
		this.pic.y = this.pos.y - this.imgR;

		if (this.intersect()){
			var v = this.pos.clone().sub(old);
			if(v.magnitude() > 1){
				v.multiply(ball.SPEED / v.magnitude());
				ball.speed.add(v);
			}
		}
	},
	addPoint: function(){
		this.point++;
		window.$('#player-' + this.side + '-point').html(this.point);
	},
	intersect: function(){
		return this.pos.clone().sub(ball.pos).magnitude() < this.r + ball.r;
	}
};

var CPU  = FingerBall.CPU = function (side) {
	this.imgR = this.r * 1.5;
	if (side === 0){
		this.pos = new _.Point( window.width() / 2 , window.height() / 4 );
	}else{
		this.pos = new _.Point(  window.width() / 2, window.height() * 3 / 4 );
	}
	this.side = side;
	
	if (this.side === 0)
		this.kapu = new _.Point(window.width() / 2, 0);
	else
		this.kapu = new _.Point(window.width() / 2, window.height());

	this.pic = g.add(new AntG.Pic({
		url: "img/gms/fingerball/player-" + side + ".png",
		x: this.pos.x - this.imgR,
		y: this.pos.y - this.imgR,
		w: 2 * this.imgR,
		h: 2 * this.imgR
	}));

	this.point = 0;
	tickables.push(this);
};

CPU.prototype = _.clone(Player.prototype);
CPU.prototype.speed = 4;
CPU.prototype.run = function(){
	var c = new _.Point((ball.pos.x + this.kapu.x) / 2, (ball.pos.y + this.kapu.y) / 2);
	c.sub(this.pos);
	if (c.magnitude() < this.speed)
		this.setPos(this.pos.add(c));
	else{
		var a = this.speed / c.magnitude();
		this.setPos(this.pos.add( new _.Point(c.x * a, c.y * a) ));
	}
}

var Ball = function(){
	this.imgR = this.r * 1.5;
	this.pos = new _.Point( window.width() / 2, window.height() / 2 );
	this.speed = new _.Point(0, 0);
	
	this.pic = g.add(new AntG.Pic({
		url: "img/gms/fingerball/ball.png",
		x: this.pos.x - this.imgR,
		y: this.pos.y - this.imgR,
		w: 2 * this.imgR,
		h: 2 * this.imgR
	}));
};

Ball.prototype = {
	r: 14,
	SPEED: 15,
	randSpeed: function(){
		var a = Math.random() * Math.PI * 2;
		this.speed = new _.Point( Math.cos(a) * this.SPEED, Math.sin(a) * this.SPEED );
	},
	run: function(){
		var wall = false;
		if (this.pos.x + this.r > window.width() || this.pos.x - this.r < 0){
			this.speed.x *= -1;
			wall = true;
		}
		if (this.pos.y + this.r > window.height() || this.pos.y - this.r < 0){
			this.speed.y *= -1;
			wall = true;
		}

		var s = this.speed.magnitude();
		if (s != this.SPEED && s != 0 && !wall){
			var a = (this.SPEED + s + s) / 3 / s;
			this.speed.x *= a;
			this.speed.y *= a;
		}

		this.pos.x += this.speed.x;
		this.pos.y += this.speed.y;

		this.pic.x = this.pos.x - this.imgR;
		this.pic.y = this.pos.y - this.imgR;
	}
};

var goal = function(){
	ball.pos = new _.Point( window.width() / 2, window.height() / 2 );
	ball.speed = new _.Point(0, 0);

	g.add(new AntG.Pic({
		url: "img/gms/fingerball/goal.png",
		x: (window.width() - 170) / 2,
		y: (window.height() - 480) / 2,
		w: 170,
		h: 440,
		fadeSpeed: .1,
		lifespan: 10
	}));
}

var win = function(player){
	g.add(new AntG.Pic({
		url: "img/gms/fingerball/wins-" + player + ".png",
		x: (window.width() - 170) / 2,
		y: (window.height() - 480) / 2,
		w: 170,
		h: 440,
		lifespan: 30,
		after: function(){
			window.location = "index.html"
		}
	}));

	$('#end h1').html("Game over!");
    Gammy.tire(0.5);
    $('._money').html(((players[0].point + 1) / (players[1].point + 1) * 10).toFixed(2));
    $('._xp').html(((players[0].point + 1) / (players[1].point + 1) * 6).toFixed(2));
    Gammy.money += ((players[0].point + 1) / (players[1].point + 1) * 10);
    Gammy.xp += ((players[0].point + 1) / (players[1].point + 1) * 6);
    $('.xp').html(Gammy.xp.toFixed(2));

    $('#end').show();
}

window.FingerBall = FingerBall;

})(window, Ant, AntG)