var snap;

//jquery objectek
var $svg, $inventory;

//svg objectek
var g_bg, g_gammy, g_front, g_side;
var food, soap;

//canvas
var canvas, g;

var tick_interval;

var running = false;

var tiles;

var antG;


var tileCount = 4;
var tile_size = 32;
var map, pics;

var sounds = {
    coin: new Audio("sounds/coin.wav")
};

$(document).ready(function(){
    ////////////
    // JQUERY //
    ////////////
    
    $svg = $('#svg');
    $(window).resize(setScreen);
    $('#end').hide();
    $('#end_retry').click(function(){
        start_game();
        $('#end').hide();
    });
    $('#end_cancel').click(function(){
        window.location = "index.html";
    });
    $('#exit').click(function(){
        window.location = "index.html";
    });

    //////////
    // SNAP //
    //////////

    snap = Snap("#svg");
    
    g_bg = snap.g();
    g_gammy = snap.g();
    g_front = snap.g();
    g_side = snap.g();
    
    ///////////
    // GAMMY //
    ///////////

    Gammy.makeEntity(g_gammy, false);
    Gammy.entity.ready = function(){
        Gammy.entity.main.hover(function(){
            Gammy.entity.jump();
        });

        Gammy.entity.size(tile_size);
       // setScreen();
    };

    ///////////
    // WEBGL //
    ///////////

    canvas = document.getElementById('canvas');

    g = canvas.getContext("2d");
    tiles = genImgs();

    canvas.width = width();
    canvas.height = height();

    antG = new AntG(canvas);

    Gammy.observers.add('money', function(e){
        $('.money').html(e.toFixed(2));
    }, true);

    //___//_/_/_/_/_/_/_/_/

    document.addEventListener("touchstart", touchStart, false);
    document.addEventListener("touchend", touchEnd, false);
    document.addEventListener("touchcancel", touchEnd, false);
    document.addEventListener("touchleave", touchEnd, false);
    document.addEventListener("touchmove", touchMove, false);

    $(document).keypress(function( event ) {
        if (event.which === 119){
            //fel
            fel();
        } else if (event.which === 115){
            //le
            le();
        } else if (event.which === 100){
            //jobb
            jobbra();
        } else if (event.which === 97){
            //bal
            balra();
        }
    });

    start_game();
});

function genImgs(){
    tile_size = (width() / tileCount) | 0;
    canvas.width = tile_size;
    canvas.height = tile_size;
    var tiles = {};

    var number = 1;
    for (var i = 0; i <= 14; ++i){
        canvas.width = canvas.width;

        g.beginPath();
        g.fillStyle = "hsl(" + (98 + i * 20) + ", 84%, 67%)";
        g.rect(0, 0, tile_size, tile_size);
        g.fill();

        g.fillStyle = "#fff";
        g.font = "bold 24px Arial";
        var size = g.measureText(""+number);
        g.fillText(number, (tile_size - size.width) / 2, 18 + (tile_size - 24) / 2);
        
        tiles[number] = canvas.toDataURL();//g.getImageData(0, 0, tile_size, tile_size);
        number *= 2;

    }

    canvas.width = canvas.width;
    return tiles;
}

function setScreen(){
    var width = window.width();
    var height = window.height();
    tile_size = (width / tileCount) | 0;
}

function width(){
    return $(window).width();
}

function height(){
    return $(window).height();
}

/////////////////
// JÁTÉKELEMEK //
/////////////////

var player = {
    money: 0,
    xp: 0
};

function addMoney(e){
    Gammy.money += e / 35;
    player.money += e / 35;
    player.xp += e / 105;
}

function start_game(){
    map = new Ant.Matrix(tileCount, tileCount, 0);
    pics = new Ant.Matrix(tileCount, tileCount, null);
    antG.objs = [];
    genTile();
    genTile();
}

function moveTile(fx, fy, tx, ty){
    if (map[tx][ty] !== 0)
        addMoney(map[tx][ty] + map[fx][fy]);

    map[tx][ty] += map[fx][fy];
    var c = map[fx][fy];
    map[fx][fy] = 0;

    antG.remove(pics[fx][fy]);

    if (pics[tx][ty] !== null)
        antG.remove(pics[tx][ty]);
    
    pics[tx][ty] = antG.add(new AntG.Pic({
            url: tiles[map[tx][ty]],
            x: tx * tile_size,
            y: ty * tile_size,
            width: tile_size,
            height: tile_size,
        }));

    pics[fx][fy] = antG.add(new AntG.Pic({
        url: tiles[c],
        x: fx * tile_size,
        y: fy * tile_size,
        width: tile_size,
        height: tile_size,
        xMove: (tx - fx) * tile_size / 5,
        yMove: (ty - fy) * tile_size / 5,
        fadeSpeed: 0.2,
        lifespan: 5,
    }));
}

function fel(){
    var c = 0;
    for (var i = 0; i < tileCount; ++i){
        var last = -1;
        var original = true;
        for (var j = 0; j < tileCount; ++j){
            if (map[i][j] != 0){
                if (last !== -1 && map[i][j] === map[i][last] && original){
                    //összeadás
                    moveTile(i, j, i, last);
                    ++c;
                    original = false;
                }else if (last + 1 !== j){
                    //üres helyre tolás
                    moveTile(i, j, i, last + 1)
                    ++c;
                    last++;
                    original = true;
                }else{
                    //nem csinálunk semmit
                    last = j;
                    original = true;
                }
            }
        }
    }

    if (c > 0)
        genTile();
}

function le(){
    var c = 0;
    for (var i = 0; i < tileCount; ++i){
        var last = tileCount;
        var original = true;
        for (var j = tileCount - 1; j >= 0; --j){
            if (map[i][j] != 0){
                if (last !== tileCount && map[i][j] === map[i][last] && original){
                    //összeadás
                    moveTile(i, j, i, last);
                    ++c;
                    original = false;
                }else if (last - 1 !== j){
                    //üres helyre tolás
                    moveTile(i, j, i, last - 1)
                    --last;
                    ++c;
                    original = true;
                }else{
                    //nem csinálunk semmit
                    last = j;
                    original = true;
                }
            }
        }
    }
    if (c > 0)
        genTile();
}

function balra(){
    var c = 0;
    for (var i = 0; i < tileCount; ++i){
        var last = -1;
        var original = true;
        for (var j = 0; j < tileCount; ++j){
            if (map[j][i] != 0){
                if (last !== -1 && map[j][i] === map[last][i] && original){
                    //összeadás
                    moveTile(j, i, last, i);
                    ++c;
                    original = false;
                }else if (last + 1 !== j){
                    //üres helyre tolás
                    moveTile(j, i, last + 1, i)
                    last++;
                    ++c;
                    original = true;
                }else{
                    //nem csinálunk semmit
                    last = j;
                    original = true;
                }
            }
        }
    }

    if (c > 0)
        genTile();

}

function jobbra(){
    var c = 0;
    for (var i = 0; i < tileCount; ++i){
        var last = tileCount;
        var original = true;
        for (var j = tileCount - 1; j >= 0; --j){
            if (map[j][i] != 0){
                if (last !== tileCount && map[j][i] === map[last][i] && original){
                    //összeadás
                    moveTile(j, i, last, i);
                    ++c;
                    original = false;
                }else if (last - 1 !== j){
                    //üres helyre tolás
                    moveTile(j, i, last - 1, i)
                    --last;
                    ++c;
                    original = true;
                }else{
                    //nem csinálunk semmit
                    last = j;
                    original = true;
                }
            }
        }
    }

    if (c > 0)
        genTile();
}

function genTile(){
    var x, y;
    do{
        x = (Math.random() * tileCount) | 0;
        y = (Math.random() * tileCount) | 0;
    }while(map[x][y] != 0);

    map[x][y] = 1;
    
    pics[x][y] = antG.add(new AntG.Pic({
            url: tiles[1],
            x: x * tile_size,
            y: y * tile_size,
            width: tile_size,
            height: tile_size,
            opacity: 0.1,
            fadeSpeed: -0.2
        }));

    if (!vanHely())
        return die();
}

function vanHely(){
    function near(x, y){
        var e = map[x][y];
        return x > 0 && map[x-1][y] === e ||
               y > 0 && map[x][y-1] === e ||
               x < tileCount-1 && map[x+1][y] === e ||
               y < tileCount-1 && map[x][y+1] === e
    }

    for (var i = 0; i < tileCount; ++i)
        for (var j = 0; j < tileCount; ++j){
            if (map[i][j] === 0 || near(i, j))
                return true;
        }
    return false;
}

function die(){
    running = false;
    clearInterval(tick_interval);

    $('#end h1').html("Game over!");
    Gammy.tire(1);
    $('._money').html(player.money.toFixed(2));
    $('._xp').html(player.xp.toFixed(2));
    $('.xp').html(Gammy.xp.toFixed(2));

    $('#end').show();
}

//////////////////
// TOUCHOLGATÁS //
//////////////////

var direction = {x: 0, y:0};

var touches = [];
touches.getIndex = function(i){
    for(var j=0; j < this.length; ++j)
        if (this[j].identifier == i)
            return j;
    
    return -1;
}

function touchStart(evt) {
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        touches.push(t);
    }
}

function touchMove(evt){
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];
    }
}

function touchEnd(evt){
    evt.preventDefault();
    
    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];

        var x = t.pageX - last.pageX;
        var y = t.pageY - last.pageY;

        if (Math.abs(x) > Math.abs(y)){
            if (x >= 0)
                jobbra();
            else
                balra();
        }else{
            if(y >= 0)
                le();
            else
                fel();
        }
        
        direction = {x: 0, y:0};

        touches.splice(lastI, 1);
    }
}
