var snap;

//jquery objectek
var $svg, $inventory;

//svg objectek
var g_bg, g_gammy, g_front, g_side;
var food, soap;

//canvas
var canvas, g;

var tick_interval;

var running = false;

var sounds = {
    coin: new Audio("sounds/coin.wav")
};

$(document).ready(function(){
    ////////////
    // JQUERY //
    ////////////
    
    $svg = $('#svg');
    $(window).resize(setScreen);
    $('#end').hide();
    $('#end_retry').click(function(){
        start_game();
        $('#end').hide();
    });
    $('#end_cancel').click(function(){
        window.location = "index.html";
    });
    $('#exit').click(function(){
        window.location = "index.html";
    });

    //////////
    // SNAP //
    //////////

    snap = Snap("#svg");
    
    g_bg = snap.g();
    g_gammy = snap.g();
    g_front = snap.g();
    g_side = snap.g();
    
    ///////////
    // GAMMY //
    ///////////

    Gammy.makeEntity(g_gammy, false);
    Gammy.entity.ready = function(){
        Gammy.entity.main.hover(function(){
            Gammy.entity.jump();
        });

        Gammy.entity.size(tile_size);
        setScreen();
    };

    ///////////
    // WEBGL //
    ///////////

    canvas = document.getElementById('canvas');
    canvas.width = width();
    canvas.height = height();

    g = canvas.getContext("2d");
    g.mozImageSmoothingEnabled = false;
    g.imageSmoothingEnabled = false;

    for (i in tile_types){
        tile_types[i].img = new Image();
        tile_types[i].img.src = tile_types[i].img_src;
    }

    Gammy.observers.add('money', function(e){
        $('.money').html(e.toFixed(2));
    }, true);

    //___//_/_/_/_/_/_/_/_/

    document.addEventListener("touchstart", touchStart, false);
    document.addEventListener("touchend", touchEnd, false);
    document.addEventListener("touchcancel", touchEnd, false);
    document.addEventListener("touchleave", touchEnd, false);
    document.addEventListener("touchmove", touchMove, false);

    $(document).keypress(function( event ) {
        if (event.which === 119){
            //fel
            player.lep(0, -1);
        } else if (event.which === 115){
            //le
            player.lep(0, 1);
        } else if (event.which === 100){
            //jobb
            player.lep(1, 0);
        } else if (event.which === 97){
            //bal
            player.lep(-1, 0);
        }
    });

    start_game();
});

var tile_size = 32;
function draw(){
    var scroll_x = window.scroll_x * tile_size;
    var scroll_y = window.scroll_y * tile_size;

    for (i = 0; i < map.width; ++i)
        for (j = 0; j < map.height; ++j){
            g.drawImage(map[i][j].img, i*tile_size - scroll_x, j*tile_size - scroll_y, tile_size, tile_size);
        }

    Gammy.entity.pos((player.x - window.scroll_x) * tile_size, (player.y - window.scroll_y) * tile_size);
}

function setScreen(){
    var width = window.width();
    var height = window.height();
    var box = Gammy.entity.main.getBBox();
    width_tile = width / tile_size;
    height_tile = height/ tile_size;
}

function width(){
    return $(window).width();
}

function height(){
    return $(window).height();
}

/////////////////
// JÁTÉKELEMEK //
/////////////////

var map;
var scroll_x = 0,
    scroll_y = 0,
    scroll_margin = 5;
var width_tile, height_tile;
var player = {
    x: 0,
    y: 3,

    lep: function(x, y){
        if (!running)
            return;
        x += this.x;
        y += this.y;
        if (x < 0 || y < 0 || x >= map.width || y >= map.height || map[x][y].hard){
            return;
        }

        this.x = x;
        this.y = y;
        
        if (map[x][y].money){
            var sound = new Audio("sounds/coin.wav");
            sound.play();
            Gammy.money += map[x][y].money;
            player.money += map[x][y].money;
        }
        if (map[x][y].breakable)
            map[x][y] = tile_types.air;
        
        if (x - scroll_margin < scroll_x && scroll_x > 0)
            scroll_x--;
        else if (x - scroll_x + scroll_margin > width_tile && x < map.width - scroll_margin)
            scroll_x++;
        if (y - scroll_margin < scroll_y && scroll_y > 0)
            scroll_y--;
        else if (y - scroll_y + scroll_margin > height_tile && y < map.height - scroll_margin)
            scroll_y++;

        draw();
        if (map[x][y] === tile_types.exit)
            win();
    },

    money: 0,
    xp: 0
};

var tile_types = {
    air : {
        img_src : "img/gms/air.png"
    },
    
    dirt : {
        img_src : "img/gms/dirt.png",
        breakable : true
    },

    stone : {
        img_src : "img/gms/stone.png",
        hard : true
    },

    wall : {
        img_src : "img/gms/wall.png",
        hard : true
    },

    diamond : {
        img_src : "img/gms/diamond.png",
        breakable : true,
        money : 1
    },

    exit : {
        img_src : "img/gms/exit.png"
    }
}

function tick(){
    var dead = false;

    //player.lep(direction.x, direction.y);

    for (i = 0; i < map.width; ++i)
        for (j = map.height-2; j >= 0; --j){
            if (map[i][j] == tile_types.stone && map[i][j+1] == tile_types.air
                && !(player.x == i && player.y == j+1) ){
                map[i][j] = tile_types.air;
                map[i][j+1] = tile_types.stone;
                
                if (player.x == i && player.y == j+2)
                    dead = true;
            }
        }

    draw();
    if (dead)
        die();
}

function start_game(){
    map = gen_map(3, 3);
    player.x = 3;
    player.y = 3;
    map[player.x][player.y] = tile_types.exit;
    player.xp = 0;
    player.money = 0;

    scroll_x = 0;
    scroll_y = 0;

    if (tick_interval)
        clearInterval(tick_interval);
    running = true;
    tick_interval = setInterval(tick, 250);
    
    try{
        draw();
    }catch(e){}
}

function die(){
    running = false;
    clearInterval(tick_interval);

    $('#end h1').html("Game over!");
    player.xp = 0;
    Gammy.tire(1);
    $('._money').html(player.money);
    $('._xp').html(player.xp);
    $('.xp').html(Gammy.xp);

    $('#end').show();
}

function win(){
    running = false;
    clearInterval(tick_interval);

    $('#end h1').html("Win");
    player.xp = Math.round(20 + Math.sqrt(player.money) * 2);
    Gammy.xp += player.xp;
    Gammy.tire(1);
    $('._money').html(player.money);
    $('._xp').html(player.xp);
    $('.xp').html(Gammy.xp);

    $('#end').show();
}

function gen_map(width, height){
    var ROOMSIZE = 10;
    var map = new Ant.Matrix(width * ROOMSIZE, height * ROOMSIZE, tile_types.dirt);
    var rooms = new Ant.Matrix(width, height, false);
    var q = [Ant.p(0, 0)];
    
    for (var i = 0; i < map.width; i += ROOMSIZE)
        for (var j = 0; j < map.height; ++j)
            map[i][j] = tile_types.wall;
    for (var i = 0; i < map.width; i++)
        map[i][map.height - 1] = tile_types.wall;
    
    for (var i = 0; i < map.height; i += ROOMSIZE)
        for (var j = 0; j < map.width; ++j)
            map[j][i] = tile_types.wall;
    for (var i = 0; i < map.height; i++)
        map[map.width - 1][i] = tile_types.wall;
    
    function removeWall(r0, r1){
        if (r0.x === r1.x){
            var r = r0.y > r1.y ? r0 : r1;
            var y = r.y * ROOMSIZE;
            var x = r.x * ROOMSIZE;
            for (var i = 1; i < ROOMSIZE-1; ++i){
                map[x + i][y] = tile_types.dirt;
            }
        }else{
            var r = r0.x > r1.x ? r0 : r1;
            var x = r.x * ROOMSIZE;
            var y = r.y * ROOMSIZE;
            for (var i = 1; i < ROOMSIZE-1; ++i){
                map[x][y + i] = tile_types.dirt;
            }
        }
    }
    
    function buildDoor(r0, r1){
        if (r0.x === r1.x){
            var r = r0.y > r1.y ? r0 : r1;
            var x = (r.x + .5) * ROOMSIZE;
            var y = r.y * ROOMSIZE;
            map[x][y] = tile_types.dirt;
        }else{
            var r = r0.x > r1.x ? r0 : r1;
            var x = r.x * ROOMSIZE;
            var y = (r.y + .5) * ROOMSIZE;
            map[x][y] = tile_types.dirt;
        }
    }
    
    function buildRocks(r, l){
        for (var i = 0; i < l && r.inRect(1, 1, map.width-1, map.height-1) && (map[r.x][r.y+1].breakable || map[r.x][r.y-1].breakable ); ++i){
            map[r.x][r.y] = tile_types.stone;
            r.x++;
        }
    }
    
    while (q.length !== 0){
        var j = Math.floor(Math.random() * q.length);
        var p = q[j];
        q.splice(j, 1);
        
        var dirs = Ant.Point.directions.slice(0);
        var i;
        while (dirs.length !== 0){
            i = Math.floor(Math.random() * dirs.length);
            var np = p.clone().add(dirs[i]);
            dirs.splice(i, 1);
            
            if (np.inRect(width, height) && !rooms[np.x][np.y]){
                if (Math.random() < 0.5)
                    removeWall(p, np);
                else
                    buildDoor(p, np);
                
                rooms[np.x][np.y] = true;
                q.push(np);
                break;
            }
        }
        if (dirs.length !== 0)
            q.push(p);
    }

    var diamondCount = width * height * 10;
    for (var i=0; i<diamondCount; ++i){
        var x, y;
        do{
            x = (map.width * Math.random()) | 0;
            y = (map.height * Math.random()) | 0;
        }while(map[x][y] === tile_types.wall || map[x][y] === tile_types.diamond);
        
        map[x][y] = tile_types.diamond;
        var r = Math.random();
        if (r < .3)
            buildRocks(Ant.p(x, y), Math.random() * ROOMSIZE);
        else if (r < .33)
            map[x][y] = tile_types.exit;
    }

    return map;
}


//////////////////
// TOUCHOLGATÁS //
//////////////////

var direction = {x: 0, y:0};

var touches = [];
touches.getIndex = function(i){
    for(var j=0; j < this.length; ++j)
        if (this[j].identifier == i)
            return j;
    
    return -1;
}

function touchStart(evt) {
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        touches.push(t);
    }
}

function touchMove(evt){
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];
/*
        var x = t.pageX - last.pageX;
        var y = t.pageY - last.pageY;

        if (Math.abs(x) > Math.abs(y)){
            direction = {
                y : 0,
                x : ( x >= 0 ? 1 : -1 )
            }
        }else{
            direction = {
                x : 0,
                y : ( y >= 0 ? 1 : -1 )
            }
        }

        touches.splice(lastI, 1, t);*/
    }
}

function touchEnd(evt){
    evt.preventDefault();
    
    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];

        var x = t.pageX - last.pageX;
        var y = t.pageY - last.pageY;

        if (Math.abs(x) > Math.abs(y)){
            player.lep(( x >= 0 ? 1 : -1 ), 0);
        }else{
            player.lep(0, ( y >= 0 ? 1 : -1 ));
        }
        
        direction = {x: 0, y:0};

        touches.splice(lastI, 1);
    }
}
