var snap;

//jquery objectek
var $svg;

//canvas
var canvas, g;

var tick_interval;

var running = false;

var muted = false;

$(document).ready(function(){
    ////////////
    // JQUERY //
    ////////////
    
    $svg = $('#svg');
    $(window).resize(setScreen);
    $('#end').hide();
    $('#end_retry').click(function(){
        start_game();
        $('#end').hide();
    });
    $('#end_cancel').click(function(){
        window.location = "index.html";
    });
    $('#exit').click(function(){
        win();
    });

    //////////
    // SNAP //
    //////////

    snap = Snap("#svg");
    
    ///////////
    // GAMMY //
    ///////////

    Gammy.makeEntity(snap, false);
    Gammy.entity.ready = function(){
        Gammy.entity.size(ITEMSIZE*2);
        setScreen();
        start_game();
    };

    ////////////
    // CANVAS //
    ////////////

    canvas = document.getElementById('canvas');
    canvas.width = width();
    canvas.height = height();

    g = canvas.getContext("2d");
    g.mozImageSmoothingEnabled = false;
    g.imageSmoothingEnabled = false;

    for (i in GameItem.types){
        GameItem.types[i].img = new Image();
        GameItem.types[i].img.src = GameItem.types[i].imgSrc;
    }

    Gammy.observers.add('money', function(e){
        $('.money').html(e);
    }, true);

    //___//_/_/_/_/_/_/_/_/

    document.addEventListener("touchstart", touchStart, false);
    document.addEventListener("touchend", touchEnd, false);
    document.addEventListener("touchcancel", touchEnd, false);
    document.addEventListener("touchleave", touchEnd, false);
    document.addEventListener("touchmove", touchMove, false);
});

var ITEMSIZE = width() / 15;
var HALFWIDTH, HALFHEIGHT, WIDTH, HEIGHT;
function draw(){ 
    //TODO felhők
    g.fillStyle = '#8877ee';
    g.fillRect(0, 0, WIDTH, HEIGHT);
    g.fillStyle = '#77ee77';
    g.fillRect(0, WIDTH-ITEMSIZE, WIDTH, HEIGHT);
    
    for (var i = 0; i < items.length; ++i)
        items[i].draw(g); 
}
        
function setScreen(){
    var width = window.width();
    var height = window.height();

    WIDTH = width;
    HEIGHT = height;
    HALFWIDTH = width / 2;
    HALFHEIGHT = height / 2;

    var box = Gammy.entity.box;
    Gammy.entity.pos((width - box.w)/2, (height - box.h)/2);
    
    $('#fuel').css({height: (HEIGHT - 75) + "px"});
}

function width(){
    return $(window).width();
}

function height(){
    return $(window).height();
}

/////////////////
// JÁTÉKELEMEK //
/////////////////

var items = [];

var player = {
    pos: new Ant.Point(width()/2, height() - ITEMSIZE),
    xp: 0,
    money: 0,
    maxhigh: 0,
    get x (){
        return this.pos.x;
    },
    get y (){
        return this.pos.y;
    },
    step: function(e){
        this.pos.x += e * ITEMSIZE;
        Gammy.entity.pos(player.x, player.y);
        Gammy.entity.jump();
    }
};

function tick(){
    var r = Math.random();
    if (r < 0.02)
        items.push(new GameItem(Math.random()*width(), GameItem.types[0], Math.random() * (ITEMSIZE / 6) + ITEMSIZE / 12));
    if (r < 0.01)
        items.push(new GameItem(Math.random()*width(), GameItem.types[1], Math.random() * (ITEMSIZE / 6) + ITEMSIZE / 12));

    var newItems = [];
    for (i in items){
        items[i].pos.y += items[i].v;
        if (items[i].y >= height() - ITEMSIZE * 2.5
            && (items[i].x >= player.x && items[i].x <= player.x + ITEMSIZE*2
            || items[i].x + ITEMSIZE >= player.x && items[i].x + ITEMSIZE <= player.x + ITEMSIZE*2)){

            playSound("sounds/coin.wav");
            player.money += items[i].type.value;
            Gammy.money += items[i].type.value;
        }else if (items[i].y < height() + ITEMSIZE){
            newItems.push(items[i]);
        }
    }
    items = newItems;
    
    draw();
}

function start_game(){
    player.xp = 0;
    player.money = 0;
    player.pos = new Ant.Point(width()/2, height()-ITEMSIZE*2);

    Gammy.entity.pos(player.x, player.y);

    if (tick_interval)
        clearInterval(tick_interval);
    running = true;
    tick_interval = setInterval(tick, 1000 / 60);
    
    try{
        draw();
    }catch(e){}
}

function die(){
    clearInterval(tick_interval);

    $('#end h1').html("Game over!");
    player.xp = (player.maxhigh / 8) | 0;
    Gammy.xp = Gammy.xp + player.xp;
    Gammy.tire(0.5);
    $('._money').html(player.money);
    $('._xp').html(player.xp);
    $('.xp').html(Gammy.xp);

    $('#end').show();
}

function win(){
    clearInterval(tick_interval);

    $('#end h1').html("Good job!");
    player.xp = (player.maxhigh / 8) | 0;
    Gammy.xp = Gammy.xp + player.xp;
    Gammy.tire(.5);
    $('._money').html(player.money);
    $('._xp').html(player.xp);
    $('.xp').html(Gammy.xp);

    $('#end').show();
}

function GameItem(x, type, v){
    this.pos = new Ant.Point(x, -ITEMSIZE);
    this.type = type;
    this.v = v;
}

GameItem.prototype = {
    get x(){
        return this.pos.x;
    },
    get y(){
        return this.pos.y;
    },
    draw: function(g){
        g.drawImage(this.type.img, this.pos.x, this.pos.y, ITEMSIZE, ITEMSIZE);
    }
};
GameItem.types = [
    {
        imgSrc: "img/gms/coin.png",
        value: 1/16
    },
    {
        imgSrc: "img/gms/diamond.png",
        value: 1/8
    }
];

//////////////////
// TOUCHOLGATÁS //
//////////////////

var touches = [];
touches.getIndex = function(i){
    for(var j=0; j < this.length; ++j)
        if (this[j].identifier === i)
            return j;
    
    return -1;
};

function touchStart(evt) {
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        touches.push(t);
    }
}

function touchMove(evt){
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];
    }
}

function touchEnd(evt){
    evt.preventDefault();
    
    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];

        if (t.pageX > player.x)
            player.step(1);
        else
            player.step(-1);

        touches.splice(lastI, 1);
    }
}

function playSound(name){
    if (muted)
        return;
    var sound = new Audio(name);
    sound.play();
    return sound;
}