var canvas, g;
var playerCount;

var $svg;

$(document).ready(function(){

    $('#end').hide();
    $svg = $('#svg');

	canvas = document.getElementById("display");
	canvas.width = width();
	canvas.height = height();
    g = new AntG(canvas);

    playerCount = parseInt(location.hash[1]);
    FingerBall.init(playerCount, g);

    document.addEventListener("touchstart", touchStart, false);
    document.addEventListener("touchend", touchEnd, false);
    document.addEventListener("touchcancel", touchEnd, false);
    document.addEventListener("touchleave", touchEnd, false);
    document.addEventListener("touchmove", touchMove, false);

    $('#exit').click(function(){
        $('#end h1').html("Game over!");
        Gammy.tire(0.5);
        $('._money').html(((players[0].point + 1) / (players[1].point + 1) * 10).toFixed(2));
        $('._xp').html(((players[0].point + 1) / (players[1].point + 1) * 6).toFixed(2));
        Gammy.money += ((players[0].point + 1) / (players[1].point + 1) * 10);
        Gammy.xp += ((players[0].point + 1) / (players[1].point + 1) * 6);
        $('.xp').html(Gammy.xp.toFixed(2));

        $('#end').show();
    });

    $('#end_retry').click(function(){
        location = "game_fingerball.html"
    });
    $('#end_cancel').click(function(){
        window.location = "index.html";
    });


    snap = Snap("#svg");
    
    g_bg = snap.g();
    g_gammy = snap.g();
    g_front = snap.g();
    g_side = snap.g();

    Gammy.makeEntity(g_gammy, false);
    Gammy.entity.ready = function(){
        Gammy.entity.main.hover(function(){
            Gammy.entity.jump();
        });

        Gammy.entity.size(40);
    };
    $svg.css({left: "60px"})
});

//////////////////
// TOUCHOLGATÁS //
//////////////////

var touches = [];
touches.getIndex = function(i){
    for(var j=0; j < this.length; ++j)
        if (this[j].identifier === i)
            return j;
    
    return -1;
}

function touchStart(evt) {
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        if (playerCount > 1 &&  t.pageY - 40 < height() / 2)
            t.playerID = 0
        else
            t.playerID = 1;
        touches.push(t);
    }
}

function touchMove(evt){
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];

        t.playerID = last.playerID;
        FingerBall.players[t.playerID].setPos(new Ant.Point(t.pageX, t.pageY - 40));

        touches.splice(lastI, 1, t);
    }
}

function touchEnd(evt){
    evt.preventDefault();
    
    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];

        touches.splice(lastI, 1);
    }
}


function width(){
    return $(window).width();
}

function height(){
    return $(window).height() - 40;
}