var snap;

//jquery objectek
var $svg, $inventory;

//svg objectek
var rockets_g, rockets, smoke;

//canvas
var canvas, g;

var tick_interval;

var running = false;

var muted = false;

$(document).ready(function(){
    ////////////
    // JQUERY //
    ////////////
    
    $svg = $('#svg');
    $(window).resize(setScreen);
    $('#end').hide();
    $('#end_retry').click(function(){
        start_game();
        $('#end').hide();
    });
    $('#end_cancel').click(function(){
        window.location = "index.html";
    });
    $('#exit').click(function(){
        win();
    });

    //////////
    // SNAP //
    //////////

    snap = Snap("#svg");
    
    ///////////
    // GAMMY //
    ///////////

    Gammy.makeEntity(snap, false);
    Gammy.entity.ready = function(){
        Snap.load("svg/jetpack.svg", function(f){
            rockets_g = f.select("g");
            rockets = rockets_g.select("#rockets");
            smoke = rockets_g.select("#smoke");
            Gammy.entity._main.select(":first-child").before(rockets_g);
            
            var m = rockets_g.transform().localMatrix;
            rockets_g.transform("t" + (m.e - 40) +"," + (m.f - 80));
            smoke.attr({opacity: 0})
        });

        setScreen();
        start_game();
    };

    ////////////
    // CANVAS //
    ////////////

    canvas = document.getElementById('canvas');
    canvas.width = width();
    canvas.height = height();

    g = canvas.getContext("2d");
    g.mozImageSmoothingEnabled = false;
    g.imageSmoothingEnabled = false;

    for (i in GameItem.types){
        GameItem.types[i].img = new Image();
        GameItem.types[i].img.src = GameItem.types[i].imgSrc;
    }

    Gammy.observers.add('money', function(e){
        $('.money').html(e);
    }, true);

    //___//_/_/_/_/_/_/_/_/

    document.addEventListener("touchstart", touchStart, false);
    document.addEventListener("touchend", touchEnd, false);
    document.addEventListener("touchcancel", touchEnd, false);
    document.addEventListener("touchleave", touchEnd, false);
    document.addEventListener("touchmove", touchMove, false);
});

var ITEMSIZE = 16;
var HALFWIDTH, HALFHEIGHT, WIDTH, HEIGHT;
function draw(){ 
    //TODO felhők
    g.fillStyle = '#8877ee';
    g.fillRect(0, 0, WIDTH, HEIGHT);
    g.translate(scroll_x, scroll_y);
    g.fillStyle = '#77ee77';
    g.fillRect(-scroll_x, - ITEMSIZE, WIDTH, HEIGHT);
    
    for (var i = 0; i < items.length; ++i)
        items[i].draw(g);
        
    g.translate(-scroll_x, -scroll_y); 
}

function updateFuel(){
    $('#fuel > .activeBar').animate({
        height: player.fuel / player.maxfuel * 100 + "%"
    });
}
        
function setScreen(){
    var width = window.width();
    var height = window.height();

    WIDTH = width;
    HEIGHT = height;
    HALFWIDTH = width / 2;
    HALFHEIGHT = height / 2;
    ITEMSIZE = WIDTH / 20;
    
    Gammy.entity.size(ITEMSIZE * 3);
    var box = Gammy.entity.box;
    Gammy.entity.pos((width - box.w)/2, (height - box.h)/2);
    
    $('#fuel').css({height: (HEIGHT - 75) + "px"});
}

function width(){
    return $(window).width();
}

function height(){
    return $(window).height();
}

/////////////////
// JÁTÉKELEMEK //
/////////////////

var scroll_x = 0,
    scroll_y = 0;
var items = [];

var G = new _.Point(0, 1);

var player = {
    pos: new Ant.Point(0, 0),
    v: new Ant.Point(0, 0),
    fuel: 1000,
    maxfuel: 1500,
    xp: 0,
    money: 0,
    maxhigh: 0,
    get x (){
        return this.pos.x;
    },
    get y (){
        return this.pos.y;
    }
};

function tick(){
    player.pos.add(player.v);
    if (player.y !== 0)
        player.v.add(G);
    
    if (player.pos.y > 0){
        player.pos.y = 0;
        player.v = new _.Point(0, 0);
        die();
        return;
    }
    
    var high = (-player.y / Gammy.entity.box.h) | 0;
    $('.magassag').html(high + "m");
    if (high > player.maxhigh)
        player.maxhigh = high;
    
    var prevA = Gammy.entity.rotate();
    if (player.v.y < 0)
        var alpha = 90 - Math.acos(player.v.x / player.v.magnitude()) / Math.PI * 180;
    else
        var alpha = 90 + Math.acos(player.v.x / player.v.magnitude()) / Math.PI * 180;
    
    Gammy.entity.rotate(Gammy.entity.rotate() + (alpha - Gammy.entity.rotate()) / 2);
    //Gammy.entity.rotate(alpha);
    scroll_x = HALFWIDTH - player.x;
    scroll_y = HALFHEIGHT - player.y;
    
    var pb = {
        x:  Gammy.entity.box.x - ITEMSIZE - scroll_x,
        y:  Gammy.entity.box.y - ITEMSIZE - scroll_y,
        x2: Gammy.entity.box.x2 - scroll_x,
        y2: Gammy.entity.box.y2 - scroll_y
    };
    
    var newitems = [];
    for (var i = 0; i < items.length; ++i){
        var item = items[i];
        if (item.pos.inRect(
                player.x - WIDTH, player.y - HEIGHT,
                player.x + WIDTH, player.y + HEIGHT))
        {
            if (item.pos.inRect(pb.x, pb.y, pb.x2, pb.y2)){
                item.type.activate();
            }else{
                newitems.push(item);
            }
        }
    }
    
    spawnItems(newitems);
    
    items = newitems;
    
    draw();
    
    //console.log(player.pos.x + " : "+player.pos.y);
}

function spawnItems(items){
    //tud egymásre spawnolni itemeket de nem érdekel
    
    //csoportokat gyártunk mindig, az alap pos-t tologatjuk
    var pos =  new Ant.Point(
            ( player.x - WIDTH + (2 * WIDTH  * Math.random())) | 0,
            ( player.y - HALFHEIGHT - HEIGHT + (HALFHEIGHT * Math.random())) | 0);
    
    for (var i=items.length; i<20; ++i){
        var item;
        if (Math.random() < 0.05)
            item = new GameItem(GameItem.types.fuel, pos.clone());
        else
            item = new GameItem(GameItem.types.coin, pos.clone());
        
        items.push(item);
        
        //itt toljuk el a csoport elemeit
        pos.add(new Ant.Point(((Math.random() * 3) | 0) * ITEMSIZE,
                              ((Math.random() * 3) | 0) * ITEMSIZE));
    }
}

function start_game(){
    player.xp = 0;
    player.money = 0;
    player.v = new Ant.Point(0, 0);
    player.pos = new Ant.Point(0, 0);
    Gammy.entity.rotate(0);

    if (tick_interval)
        clearInterval(tick_interval);
    running = true;
    tick_interval = setInterval(tick, 60);
    
    updateFuel();
    
    try{
        draw();
    }catch(e){}
}

function die(){
    clearInterval(tick_interval);

    $('#end h1').html("Game over!");
    player.xp = (player.maxhigh / 8) | 0;
    Gammy.xp = Gammy.xp + player.xp;
    Gammy.tire(1.5);
    $('._money').html(player.money);
    $('._xp').html(player.xp);
    $('.xp').html(Gammy.xp);

    $('#end').show();
}

function win(){
    clearInterval(tick_interval);

    $('#end h1').html("Good job!");
    player.xp = (player.maxhigh / 8) | 0;
    Gammy.xp = Gammy.xp + player.xp;
    Gammy.tire(1.2);
    $('._money').html(player.money);
    $('._xp').html(player.xp);
    $('.xp').html(Gammy.xp);

    $('#end').show();
}

function GameItem(type, pos){
    this.type = type;
    this.pos = pos;
}
GameItem.prototype = {
    draw: function(g){
    //g.fillStyle = '#ff0';
    //g.fillRect(this.pos.x, this.pos.y, 100, 100);
        g.drawImage(this.type.img, this.pos.x, this.pos.y, ITEMSIZE, ITEMSIZE);
    }
};
GameItem.types = {
    coin: {
        imgSrc: "img/gms/coin.png",
        activate: function(){
            playSound("sounds/coin.wav");
            Gammy.money += 1/16;
            player.money += 1/16;
        }
    },
    fuel: {
        imgSrc: "img/gms/fuel.png",
        activate: function(){
            playSound("sounds/fuel.wav");
            player.fuel += player.maxfuel / 8;
            if (player.fuel > player.maxfuel)
                player.fuel = player.maxfuel;
            updateFuel();
        }
    }
};

//////////////////
// TOUCHOLGATÁS //
//////////////////

var touches = [];
touches.getIndex = function(i){
    for(var j=0; j < this.length; ++j)
        if (this[j].identifier === i)
            return j;
    
    return -1;
};

function touchStart(evt) {
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        touches.push(t);
    }
}

function touchMove(evt){
    evt.preventDefault();

    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];
/*
        var x = t.pageX - last.pageX;
        var y = t.pageY - last.pageY;

        if (Math.abs(x) > Math.abs(y)){
            direction = {
                y : 0,
                x : ( x >= 0 ? 1 : -1 )
            }
        }else{
            direction = {
                x : 0,
                y : ( y >= 0 ? 1 : -1 )
            }
        }

        touches.splice(lastI, 1, t);*/
    }
}

function touchEnd(evt){
    evt.preventDefault();
    
    for (var i=0; i < evt.changedTouches.length; i++){
        var t = evt.changedTouches[i];
        var lastI = touches.getIndex(t.identifier);
        var last = touches[lastI];

        var dir = new _.Point(t.pageX - last.pageX, t.pageY - last.pageY);
        dir.multiply(0.1);
        var d = dir.magnitude();
        if (d > player.fuel){
            dir.multiply(player.fuel / d);
        }
        
        if (player.fuel >= 0){
            smoke.animate({opacity: 1}, 100)
            setTimeout(function(){
                smoke.animate({opacity: 0}, 400);
            }, 500);
        }
        
        player.fuel -= d;
        if (player.fuel < 0)
            player.fuel = 0;
        updateFuel()
        
        player.v.add(dir);

        touches.splice(lastI, 1);
    }
}

function playSound(name){
    if (muted)
        return;
    var sound = new Audio(name);
    sound.play();
    return sound;
}