var Gammy = {
    _entity : null,
    get entity(){ return this._entity; },

    _consumeTime : 1000 * 60 * 5,
    _consumeInterval : null,

    init : function(){
        var stored = JSON.parse(localStorage.getItem('Gammy')) || this._defaults;
        this._addProps(stored, this._defaults);

        for (i in stored){
            if (i[0] === '_')
                continue;
            this.data.add(i, stored[i]);
        }

        // fogyasztás

        this._consumeInterval = setInterval(this.consume, this._consumeTime);
        this.consume();
    },

    data : {
        /**
         * hozzáad egy új fieldet
         * @param {String} name
         * @param {*} value
         */
        add : function(name, value){
            if (typeof value === 'undefined')
                value = null;

            //Gammyhez adunk get/setterek szal a this is az
            var props = {};
            props[name] = {
                get: function(){
                    return this.data[name];
                },
                set: Gammy._setters[name] || function(e){

                    this.data[name] = e;

                    if (name === "hygiene" || name === "food" || name === "energy"){
                        if (this.data[name] > 1)
                            this.data[name] = 1.0;
                        else if (this.data[name] < 0)
                            this.data[name] = 0;
                    }

                    this.observers.event(name);
                    this.save();
                }
            };

            Object.defineProperties(Gammy, props);
            this[name] = value;
        }
    },

    /**
     * eventek kezelése
     * @type {Object}
     */
    observers : {
        /**
         * megfigyelő beállitása egy adott field változásához
         * @param {String} field a field neve
         * @param {Function} func  függvény
         * @param {Bool} instantrun lefuttassa e egyszer beállitás után
         */
        add : function(field, func, instantrun){
            this[field] = func;
            if (instantrun)
                this[field](Gammy.data[field]);
        },

        /**
         * eltünteti az observert ah már nem akarjuk ahsználni
         * @param  {String} field field enve amiről töröljük
         */
        remove : function(field){
            delete this[field];
        },

        /**
         * event generálása, meghívja az observereit
         * @param  {String} name event neve, amihez rendelve vannak
         */
        event: function(name){
            if (this[name])
                this[name](Gammy[name]);
        }
    },

    /**
     * item megvétele, pénz levonása inventoryhoz dás
     * ha unique tipusu és már megvan akkor sem sikerül
     * @param  {Item} item megvevendő item
     * @return {bool}      siker (pl nincs pénz -> false)
     */
    buy: function(item){
        if (item.price > this.money)
            return false;
        var type = Item.types[item.type];

        var have = false;
        var i;
        for (i = 0; i < this.inventory.length && !have; ++i)
            have = this.inventory[i].name === item.name;
        i -= 1;

        if (type.unique && have){
            return this.inventory[i];
        }else if (!type.unique && have){
            this.money -= item.price;
            this.inventory[i].count += 1;
            return this.inventory[i];
        }

        //ha rendesen megvesszük
        this.money -= item.price;
        var r = type.buy(item, this);
        if (!type.unique)
            r.count = 1;
        if (r)
            this.inventory.push(r);

        return item;
    },

    /**
     * item aktiválása az invenoryból
     * @param  {Item} item aktiválandó item
     */
    activateItem : function(item){
        Item.types[item.type].activate(item, Gammy);
        this.save();
    },

    save : function(){
        var stored = {};
        //defaultsból tudjuk h miket kell kimenteni a databól
        //így nem kell a data függvényeivel szarakodni
        for (i in this._defaults){
            if (i[0] === '_')
                stored[i] = this._defaults[i];
            else
                stored[i] = this[i];
        }

        //valamiért arraynak hiszi a JSON, de amúgy meg object de néha mégse
        //gondolom getter, setter hüylíti meg
        stored.clothes = {};
        for (i in this.clothes){
            stored.clothes[i] = this.clothes[i];
        }

        stored.lastVisit = Date.now();

        localStorage.setItem('Gammy', JSON.stringify(stored));
    },

    /**
     * csökkenti a szükségleteket
     * (setIntervalból hívódik meg -> nincs this)
     */
    consume : function(){
        var now = Date.now();
        var time = now - Gammy.lastVisit;

        if (Gammy.sleeping){
            Gammy.energy += Gammy._consumption.energy * 1.5 * time / Gammy._consumeTime
            return;
        }

        for (i in Gammy._consumption)
            if (Gammy[i] > 0)
                Gammy[i] = Gammy[i] - Gammy._consumption[i] * time / Gammy._consumeTime;
            //for (j = 0; j<time / 500; ++j)
            //    Gammy[i] = (Gammy[i] - Gammy._consumption[i] * Gammy[i]);

        Gammy.lastVisit = now;
    },

    /**
    * koszol, fáraszt, éheztet - valamiylen súlyozásokkal
    * munka után
    */
    tire: function(e){
        this.hygiene -= e * 0.15;
        this.food -= e * 0.1;
        this.energy -= e * 0.07;
    },

    /**
     * Entity létrehozása a megjelenitéshez
     * @param {Snap} snap
     * @param {bool} shadow [legyen e árnyék, def = true]
     * @return {Entity} Entity
     */
    makeEntity : function(snap, shadow){
        this._entity = new Entity("svg/" + this.type + ".svg", snap, shadow);

        // vannak amiket át kell passzolnunk az entitynek

        this.observers.add('color', function(e){
            Gammy.entity.color = e;
        });

        return this._entity;
    },

    /**
     * aktiválja a Gammy.clothes-ban lévő itemeket
     * az entity meghívja ha elkészült
     * */
    dressUp : function(){
        if(this._entity === null)
            return;
        for (i in this.clothes){
            this.activateItem(this.clothes[i], this);
        }
    },

    /**
     * hiányzó propertiek feltöltése
     * @param {Object} a a feltöltendő
     * @param {Object} b amivel feltöltjük ha kell
     */
    _addProps : function(a, b){
        for (i in b){
            if(!a[i])
                a[i] = b[i];
        }
    },

    reset: function(){
        for (i in this._defaults)
            this[i] = this._defaults[i];
    },

    /**
     * fogyasztás
     * egység / 5 perc
     * */
    _consumption: {
        food: 0.01,
        hygiene: 0.02,
        energy: 0.01
    },

    _setters: {
        xp: function(e){
            this.data.xp = e;
            if (this.data.xp >= this.data.maxp){
                //console.log("lvlup");
                this.data.lvl++;
                this.data.xp = this.data.xp - this.data.maxp;
                var maxp = this.data.maxp;
                this.maxp = maxp + this.data.lastMaxp;
                this.lastMaxp = maxp;
                this.lvlupped = true;
            }
            this.observers.event('xp');
        }
    },

    /**
     * alap értékek, innen tudjuk azt si h miket kell elmenteni
     */
    _defaults: {
        money : 0,
        color : "#5adbb2",
        wallpaper: null,
        food : 1.0,
        hygiene : 1.0,
        energy: 1.0,
        sleeping: false,
        inventory : [],
        clothes : {},
        xp : 0,
        maxp : 20,
        lastMaxp : 20,
        lvl : 0,
        name : "Pet",
        type : "t-0",
        lastVisit: Date.now(),
        lvlupped: false,

        _version : 0
    }
};
Gammy.init();

/**
 * svg burkolat, amiben tartjuk az egységeket
 * @param {string} filename .svg fájl neve
 * @param {g} group     group, amihez hozzáadjuk a grafikát
 * @param {bool} shadow [legyen e árnyék, def = true]
 **/
var Entity = function(filename, group, shadow){
    _this = this;
    if (shadow === false)
        this._shadow = false;

    this._scale = 1;
    this._rotate = 0;
    this._pos = new Ant.Point(0, 0);

    Snap.load(filename, function(f){
        var g = f.select("#entity");
        group.add(g);
        var box = _this._box = g.getBBox();

        _this._main = g;
        _this._body = g.select("#body");
        _this._legs = g.select("#legs");
        if (_this._shadow !== false){
            _this._shadow = g.ellipse(box.w/2, box.h, box.w/2, box.h/12);
            if (_this._legs !== null)
                _this._shadow.insertBefore(_this._legs).attr({fill: "rgba(0, 0, 0, 0.15)"});
        }
        _this.color = Gammy.color;
        Gammy.dressUp();
        _this._box = _this._main.getBBox();

        if (_this.onReady)
            _this.onReady();
        _this.isReady = true;
    });
};

Entity.prototype = {
    _this : null,

    _main : null,
    /**@type {Element} */
    get main(){ return this._main; },
    _body : null,
    /**@type {Element} */
    get body(){ return this._body; },
    _legs : null,
    /**@type {Element} */
    get legs(){ return this._legs; },
    _sahdow : null,
    _box : null,
    /** a mainhez tartozó BBox @type {BBox} */
    get box(){ return this._box; },
    /** a tranfsormációkhoz kell, pozíciót a boxból ovlasunk */

    _color : null,
    /**@type {Element} */
    get color(){ return this._color; },
    set color(e){
        this._color = e;
        this.main.selectAll(".color").forEach(function(element){
            element.animate({ fill : e}, 1000);
        });
        //this.main.selectAll(".color").animate({fill: e});
    },

    _onReady : null,
    /**
     * függvény lefuttatása amikor elkészül az svg, ha már kész azonnal lefut
     * @param  {function} f függvény ami lefut
     */
    set ready(f){
        if (this.isReady)
            f();
        else
            this.onReady = f;
    },
    _isReady : false,
    get isReady(){ return this. _isReady; },

    /**
     * megemeli a testet
     * @return {void}
     */
    jump: function(){
        //this.body.animate({ transform: 'translate(0,-10)' }, 100, mina.backin);
        animateTranslate(this.body, 0, -20, 5, true);
    },
    _setTransform: function(){
        this._main.transform("s" + this._scale + "," + this._scale + ",0,0T0,0r" + this._rotate);
        this._box = this._main.getBBox();

        this._main.transform("s" + this._scale + "," + this._scale + ",0,0T"
            + this._pos.x + "," + (this._pos.y - this.box.y) + "r" + this._rotate);
        this._box = this._main.getBBox();
    },

    /**
     * beállitja a pozíciót és/vagy visszadja
     * @param  {int | Point} x
     * @param  {int} y
     * @return {Point}   koordináták
     */
    pos: function(x, y){
        if (typeof x === 'number' && typeof y === 'number' ){
            this._pos.x = x;
            this._pos.y = y;
            this._setTransform();
            this._box = this.main.getBBox();
        }else if (x instanceof Ant.Point){
            this._pos = x;
            this._setTransform();
            this._box = this.main.getBBox();
        }

        return new _.Point(this.box.x, this.box.y);
    },

    /**
     * beállítja az elforgatást és/vagy visszadja
     * @param  {int} r fokban?
     * @return {int}
     */
    rotate: function(r){
        if (typeof r === 'number' && !isNaN(r)){
            this._rotate = r;
            this._setTransform();
        }
        return this._rotate;
    },

    /**
     * beálltija úgy, hogy egy size méretu ngéyzetbe beférjen
     * vagy csak visszadja a méretet
     * @param {number} w maximális szélesség
     * @param {number} h [maximális magasság] = w
     * @return {{w, h}} méretek
     */
    size: function(w, h){
        if (typeof w === 'number'){
            if (typeof h !== 'number')
                h = w;

            this._main.transform("s1,1,0,0T0,0");
            var box = this._main.getBBox();

            sWidth = w / box.w;
            sHeight = h / box.h;
            this._scale = sWidth < sHeight ? sWidth : sHeight;

            this._setTransform();
        }

        return {w : this.box.w, h : this.box.h};
    }
};

/**
 * inventoryban tárolható elemek
 * @param {String} name
 * @param {String} img
 * @param {int} price az item ára
 * @param {string} type Item.types-ból, a szerializáció miatt név
 * [@param {Object} attr typusfüggő paraméterek objektben]
 */
function Item(name, img, price, type, attr){
    this.name = name;
    this.img = img;
    this.price = price;
    this.type = type;
    this.attr = attr;
}

Item.types = {};

Item.types.color = {
    name : "color",
    unique: true,
    buy : function(item, gammy){
        return item;
    },
    activate : function(item, gammy){
        gammy.color = item.attr.color;
    }
};

Item.types.food = {
    name : "food",
    unique: false,
    buy : function(item, gammy){
        return item;
    },
    activate : function(item, gammy){
        item.count--;
        var val = item.attr.foodvalue || 0.2;
        gammy.food += val;

        if (item.count <= 0){
            var index = gammy.inventory.indexOf(item);
            if (index > -1)
                gammy.inventory.splice(index, 1);
        }
    }
};

Item.types.wallpaper = {
    name : "wallpaper",
    unique: true,
    buy : function(item, gammy){
        return item;
    },
    activate : function(item, gammy){
        gammy.wallpaper = item.attr.url;
    }
};

Item.types.dress = {
    name: "dress",
    unique: true,
    buy: function(item, gammy){
        return item;
    },
    activate: function(item, gammy){
        var b = Gammy.entity.main.select("#" + item.attr.dressType);
        if (b === null)
            return;

        if (typeof gammy.clothes[item.attr.dressType] !== 'undefined' && gammy.clothes[item.attr.dressType].name == item.name && b.innerSVG() != ""){
            b.select("*").remove();
            delete gammy.clothes[item.attr.dressType];
            Gammy.observers.event('appearenceChange');
            return;
        }

        gammy.clothes[item.attr.dressType] = item;
        var _this = this;
        Snap.load("svg/"+item.attr.svg+".svg", function(f){
            var b = Gammy.entity.main.select("#" + item.attr.dressType);
            var g = f.select("g");
            if (b.select("*") != null)
                b.select("*").remove();
            b.add(g);

            var gb = g.getBBox();
            var bb = _this._makeBox(b);

            if (typeof item.attr.align === 'undefined' || item.attr.align == 'center')
                g.transform("t" + (bb.cx - gb.cx) + "," + (bb.cy - gb.cy));
            else if (item.attr.align == 'top')
                g.transform("t" + (bb.cx - gb.cx) + "," + (bb.y - gb.y));
            else if (item.attr.align == 'bottom')
                g.transform("t" + (bb.cx - gb.cx) + "," + (bb.y + bb.h - gb.y - gb.h));

            Gammy.entity._box = gammy.entity._main.getBBox();
            Gammy.observers.event('appearenceChange');
        });
    },
    _makeBox: function(g){
         var r = {
            x: parseFloat(g.attr("x")),
            y: parseFloat(g.attr("y")),
            w: parseFloat(g.attr("width")),
            h: parseFloat(g.attr("height"))
        };
        r.cx = r.x + r.w / 2;
        r.cy = r.y + r.h / 2;
        return r;
    }
};

function seq(func, times, delay, callback){
    var interval;
    var counter = times - 1;

    var delay = delay || 50;

    function run(){
        if (counter < 0){
            clearInterval(interval);
            if (typeof callback === 'function')
                callback();
            return;
        }
        counter--;
        func(counter);
    }
    interval = setInterval(run, delay);
}

function animateTranslate(paper, xr, yr, frames, back){
    if (paper.attr("data-animated") === "true")
        return;

    paper.attr({"data-animated": "true"});

    var x = xr / frames;
    var y = yr / frames;
    var m = paper.transform().localMatrix;

    var cx = m.e;
    var cy = m.f;

    function anim(count){
        cx += x;
        cy += y;
        paper.attr({transform:"translate(" + cx + "," + cy + ")"});
    }

    var backf;
    if (typeof back === 'function')
        backf = function(){
            paper.attr({"data-animated": "false"});
            back();
        };
    else if (back)
        backf = function(){
            paper.attr({"data-animated": "false"});
            animateTranslate(paper, -xr, -yr, frames, false);
        };
    else
        backf = function(){
            paper.attr({"data-animated": "false"});
        };

    seq(anim, frames, 50, backf);
}
