var snap;

//jquery objectek
var $svg, $inventory;

$(document).ready(function(){
    ////////////
    // JQUERY //
    ////////////
    
    $svg = $('#svg');
    setScreen();
    $(window).resize(setScreen);

    //////////
    // SNAP //
    //////////

    snap = Snap("#svg");
    
    GammyTypes[0].build(0, 0);
    
    for (var i = 0; i < GammyTypes.length; ++i){
        GammyTypes[i].makeSvg();
    }
    
    ///////////
    // GAMMY //
    ///////////

});

var GAMMYWIDTH = 100;
var readySvgs = 0;

function GammyType(name, svg, minlev, forebearName){
    this.name = name;
    this.svg = svg;
    this.minlev = minlev;
    this.forebearName = forebearName;
    this.forebear =  this.forebearName !== null ? GammyTypes[this.forebearName] : null;
    this.active = Gammy.lvl >= minlev;
    this.pos = null;
    this.children = [];
}
GammyType.prototype = {
    //TODO közös prototype -> Entitynél megnzéni a dolgokat
    /**
     * x: unokaöccsek miatti eltölódás
     * y: szülők miatt eltolódás
     * 
     * visszaadja a részfa szléességét
     * */
    build: function(x, y){
        if (this.children.length === 0){
            this.pos = new Ant.Point(x, y);
            return GAMMYWIDTH;
        }
        
        y += 150;
        var w = 0;
        for (var i = 0; i < this.children.length; ++i){
            w += this.children[i].build(x + w, y);
        }
        this.pos = new Ant.Point(x + (w - GAMMYWIDTH) / 2, y - 150);
        
        return w;
    },
    makeSvg: function(){
        var _this = this;
        Snap.load("svg/" + this.svg + ".svg", function(f){
            var g = snap.g();
            g.attr({id: this.svg});
            _this._g = g;
            g.add(f.select("#entity"));
            var box = g.getBBox();
            
            var sWidth = GAMMYWIDTH / box.w;
            var sHeight = GAMMYWIDTH / box.h;
            
            if (sWidth < sHeight){
                g.transform("s" + sWidth + "," + sWidth + ",0,0T" + _this.pos.x + "," + _this.pos.y);
            }else{
                g.transform("s" + sHeight + "," + sHeight + ",0,0T" + ( _this.pos.x + (GAMMYWIDTH-box.w*sHeight)/2 ) + "," + _this.pos.y);
            }
            box = g.getBBox();
            
            if (_this.active){
                g.click(function(){
                    //console.log(_this.name);
                    Gammy.type = _this.svg;
                    Gammy.save();
                    location = "index.html";
                });
            }else{
                var t = g.text(0, 0, _this.minlev + " lvl").transform("s" + box.w/17 + "," + box.w/17 + ",0,0t0," + (box.h - 30));
                g.attr({opacity: "0.4"});
            }
            
            readySvgs++;
            if (readySvgs === GammyTypes.length)
                allSvgReady();
        });
    },
    findForebear: function(name){
        for (var i = 0; i < GammyTypes.length; ++i)
            if (GammyTypes[i].name === name)
                return GammyTypes[i];
        //console.log("missing gammy type: " + name);
        return null;
    }
};

function allSvgReady(){
    for (var i = 0; i < GammyTypes.length; ++i){
        if (GammyTypes[i].forebear === null)
            continue;
        
        var g = GammyTypes[i]._g;
        var gb = g.getBBox();
        var fg = GammyTypes[i].forebear._g;
        var fgb = fg.getBBox();
        
        var l = snap.polyline(fgb.cx, fgb.y2, fgb.cx, fgb.y2 + 20, gb.cx, gb.y-20, gb.cx, gb.y-5);
        
        l.attr({class: "tree-line"});
    }
    snap.transform("T" + (($(window).width() - snap.getBBox().w) / 2) + ",0");
    
}

var GammyTypes = [];
GammyTypes.add = function(e){
    //TODO ant.js-es object összefésülés a gammy mentésénél
    
    this.push(e);
    this[e.name] = e;
    if (e.forebear !== null)
        e.forebear.children.push(e);
};
GammyTypes.add(new GammyType("baby", "t-0", 0, null));
GammyTypes.add(new GammyType("baby", "t-1", 1, 0));
GammyTypes.add(new GammyType("baby", "t-2", 3, 0));
GammyTypes.add(new GammyType("baby", "t-3", 5, 0));
GammyTypes.add(new GammyType("baby", "t-4", 7, 3));
GammyTypes.add(new GammyType("baby", "t-5", 9, 1));
GammyTypes.add(new GammyType("baby", "t-6", 12, 4));
GammyTypes.add(new GammyType("baby", "t-7", 15, 3));

function setScreen(){
    var width = $(window).width();
    var height = $(window).height();
    
    $svg.css({
        width: width + "px",
        height: height + "px"
    });
}