var snap;

//jquery objectek
var $svg, $inventory, $fridge, $jobs, $shop, $shops, $care;
var $food_btn, $soap_btn, $sleep_btn, $jobs_btn;
var nameIsEditable = false;

//svg objectek
var g_bg, g_gammy, g_front, g_side;
var food;

//canvas
var canvas, g;
var antG;

$(document).ready(function(){
    ////////////
    // JQUERY //
    ////////////

    $svg = $('#svg');
    
    $inventory = $('#inventory');
    $('#inventory_btn').click(function(){
    	loadInventory();
    	$shop.hide();
        $shops.hide();
        $inventory.toggle();
    	$jobs.hide();
        $care.hide();
        $fridge.hide();
    });
    $inventory.hide();

    $shop = $('#shop');
    $shops = $('#shops');
    $('#shop_btn').click(function(){
        $inventory.hide();
    	$jobs.hide();
        $care.hide();
        $fridge.hide();

        if ($shop.is(":visible")){
            $shops.hide();
            $shop.hide();
        }else{
            $shops.toggle();
        }
    });
    $shop.hide();
    $shops.hide()

    $jobs = $('#jobs');
    $jobs_btn = $('#jobs_btn')
    $jobs_btn.click(function(){
        if (Gammy.sleeping)
            return;
    	$jobs.toggle();
    	$inventory.hide();
    	$shop.hide();
        $care.hide();
        $fridge.hide();
        $shops.hide();
    });
    $jobs.hide();

    $care = $('#care');
    $('#care_btn').click(function(){
    	$care.toggle();
    	$inventory.hide();
    	$shop.hide();
    	$jobs.hide();
        $fridge.hide();
        $shops.hide();
    });
    $care.hide();

    $fridge = $('#fridge');
    $fridge.hide();

    $('#fingerball_btn').click(function(){
        location = "game_fingerball.html"
    });

    $('#_2048_btn').click(function(){
        location = "game_2048.html"
    });

    $('#miner_btn').click(function(){
        location = "game_bulderdash.html"
    });

    $('#catcher_btn').click(function(){
        location = "game_catcher.html"
    });

    $('#jetpack_btn').click(function(){
        location = "game_jetpack.html"
    });

    $food_btn = $('#food_btn');
    $soap_btn = $('#soap_btn');
    $sleep_btn = $('#sleep_btn');
    $food_btn.click(function(){
        if (Gammy.sleeping)
            return;
        loadFridge();
        $care.hide();
        $inventory.hide();
        $shop.hide();
        $jobs.hide();
        $fridge.toggle();
        $shops.hide();
    });
    $soap_btn.click(function(){
        if (Gammy.sleeping)
            return;
        if (Gammy.money < 10){
            $('#money').animate({color: "#f00"})
                .delay(2000)
                .animate({color: "#7F7F7F"});
            return;
        }
        Gammy.hygiene += 0.2;
        Gammy.money -= 5;
        addBubi(8);
    });
    $sleep_btn.click(function(){
        if (Gammy.sleeping){
            Gammy.sleeping = false;
            makeEyesAwake();
        }else{
            Gammy.sleeping = true;
            makeEyesSleeping();
        }
    });

    $('#dna').click(function(){
        Gammy.lvlupped = false;
        location = "tree.html";
    });

    $('#nameSpan').click(function(){
        if (!nameIsEditable){
            $(this).html("")
            $(this).html("<input id=\"nameInput\" value=\"" + Gammy.name + "\">");
            nameIsEditable = true;
            $('#nameInput').keypress(function (e) {
                //e.preventDefault();
                if (e.which === 13) {
                    Gammy.name = $('#nameInput').val();
                    Gammy.save();
                    nameIsEditable = false;
                    return false;
                }
                return true;
            })
        }
        return false;
    });

    $('#shops-foods-btn').click(function(){
        loadShop('food');
    });
    $('#shops-dresses-btn').click(function(){
        loadShop('dress');
    });
    $('#shops-colors-btn').click(function(){
        loadShop('color');
    });
    $('#shops-wallpapers-btn').click(function(){
        loadShop('wallpaper');
    });

    //////////
    // SNAP //
    //////////

    snap = Snap("#svg");

    g_bg = snap.g().attr({id : 'bg'});
    g_gammy = snap.g().attr({id : 'gammy'});
    g_front = snap.g().attr({id : 'front'});
    g_side = snap.g().attr({id : 'side'});

    ////////////
    // CANVAS //
    ////////////

    canvas = document.getElementById("canvas");
    g = canvas.getContext("2d");

    antG = new AntG(canvas);

    ///////////
    // GAMMY //
    ///////////

    Gammy.makeEntity(g_gammy);
    Gammy.entity.ready = function(){
        setScreen();
        $(window).resize(setScreen);

        if (Gammy.sleeping){
            makeEyesSleeping();
        }
    };

    $(canvas).hover(function(){
        if (!Gammy.sleeping)
            Gammy.entity.jump();
    }).click(function(){
        if (!Gammy.sleeping)
            Gammy.entity.jump();
    });

    Gammy.observers.add('money', function(e){
        $('#money').html(e.toFixed(2));
    }, true);
    Gammy.observers.add('name', function(e){
    	$('#nameSpan').html(e);
    }, true);
    Gammy.observers.add('food', function(e){
    	$('#food > .activeBar').animate({
    		width: e * 100 + "%"
    	});
    }, true);
    Gammy.observers.add('hygiene', function(e){
    	$('#hygiene > .activeBar').animate({
            width: e * 100 + "%"
    	});
    }, true);
    Gammy.observers.add('energy', function(e){
        $('#energy > .activeBar').animate({
            width: e * 100 + "%"
        });
    }, true);
    Gammy.observers.add('xp', function(e){
        $('#xp > .activeBar').animate({
            width: e / Gammy.maxp * 100 + "%"
        });
        $('#xp_val').html(Gammy.xp);
        $('#xp_max_val').html(Gammy.maxp);
    }, true);
    Gammy.observers.add('lvlupped', function(e){
        if (e)
            $('#dna').attr("src", "img/dna-active.png");
        else
            $('#dna').attr("src", "img/dna.png");
    }, true);
    Gammy.observers.add('sleeping', function(e){
        e = !e;
        $jobs_btn.attr("data-enabled", e);
        $soap_btn.attr("data-enabled", e);
        $food_btn.attr("data-enabled", e);
    }, true);
    Gammy.observers.add('appearenceChange', function(){
        setScreen();
    });
    Gammy.observers.add('wallpaper', function(e){
        if (e === null)
          $('body').css({"background" : "none"});

        $('body').css({"background-image" : "url(" + e + ")"});
    }, true);

});

function setScreen(){
    var width = window.width();
    var height = window.height();

    canvas.width = width;
    canvas.height = height;

    Gammy.entity.size(width - 40, height - 95);//130
    var box = Gammy.entity.box;
    Gammy.entity.pos((width - box.w) / 2, height - 95 - box.h);
    var box = Gammy.entity.box;

    setZZZ();
}

function loadInventory(){
    var inventory = Gammy.inventory;

    $inventory.html("");
    for (i = 0; i < inventory.length; ++i){
        if (inventory[i].type === "food")
            continue;

    	$e = $("<div>").data('id', i).addClass("item_btn");
    	$e.add($("<img>").addClass("item_img").attr("src", inventory[i].img)).appendTo($e);
    	$e.add($("<div>").addClass("item_name").html(inventory[i].name)).appendTo($e);

    	$inventory.append($e);
    }

    if (inventory.length === 0){
        $inventory.html("<div class=\"center\">Your inventory is empty</div>");
    }

    $("#inventory > div").click(function(){
    	var id = $(this).data('id')

    	Gammy.activateItem(Gammy.inventory[id]);

    	$inventory.hide();
    });
}

function loadFridge(){
    var inventory = Gammy.inventory;

    var foodCount = 0;
    $fridge.html("");
    for (i = 0; i < inventory.length; ++i){
        if (inventory[i].type === 'food'){
            $e = $("<div>").data('id', i).addClass("item_btn");
            $e.add($("<img>").addClass("item_img").attr("src", inventory[i].img)).appendTo($e);
            $e.add($("<div>").addClass("item_name").html(inventory[i].name + " (" + inventory[i].count + ")")).appendTo($e);

            $fridge.append($e);
            foodCount++;
        }
    }

    if (foodCount === 0){
        $fridge.html("<div class=\"center\">Your fridge is empty<br>Buy some food in the shop!</div>");
    }

    $("#fridge > div").click(function(){
        var id = $(this).data('id');
        var item = Gammy.inventory[id];
        Gammy.activateItem(item);

        $fridge.hide();

        var w = width() / 2;
        var h = height() / 2;
        antG.add(new AntG.Pic({
            url: item.img,
            x: width(),
            y: height(),
            xMove: -w / 20,
            yMove: -h / 20,
            width: w,
            height: h,
            wChange: -(w - 64) / 20,
            hChange: -(h - 64) / 20,
            lifespan: 20,
            after: function(){
                this.wChange = 0;
                this.hChange = 0;
                this.lifeTime = 10;
                this.yMove = 0;
                this.xMove = 0;
                this.fadeSpeed = 0.1;
                this.after = null;
            }
        }));
    });
}

function loadShop(type){
    $shop.html("");
    for (i = 0; i < Shop.length; ++i){
        if (Shop[i].type !== type)
            continue;

        $e = $("<div>").data('id', i).addClass("item_btn");
        if(Shop[i].price > Gammy.money)
            $e.addClass("tooexpensive");
        $e.add($("<img>").addClass("item_img").attr("src", Shop[i].img)).appendTo($e);
        $e.add($("<div>").addClass("item_name").html(Shop[i].name)).appendTo($e);
        $e.add($("<div>").addClass("item_price").html(Shop[i].price + " $")).appendTo($e);
        $shop.append($e);
    }

    $("#shop > div").click(function(){
    	var id = $(this).data('id')

        var r = Gammy.buy(Shop[id]);
    	if (r){
            if (r.type !== 'food')
                Gammy.activateItem(r);
            $shop.hide();
        }
    });

    $shops.hide();
    $shop.show();
}

function setZZZ(){
    var box = Gammy.entity.box;
    var zzz = g_front.select('#zzz');
    if (zzz){
        zzz.transform("t0,0s1,1,0,0");
        var zbox = zzz.getBBox();
        var w_2 = width()/2;
        var sc = w_2 / zbox.w;
        zzz.transform("t" + w_2 + ",0s" + sc + "," + sc + ",0,0");
    }
}

function makeEyesSleeping(){
    snap.selectAll('.eye').forEach(function(element){
        var box = element.getBBox();
        element.selectAll('*').forEach(function(e){
            e.attr({opacity: 0});
        })
        Snap.load("svg/sleepingeye.svg", function(f){
            eye = f.select("path");
            element.add(eye);
            eye.attr({"data-lifetime": "sleeping"});
            var eyeBox = eye.getBBox();
            eye.transform("s" + (box.w / eyeBox.w) + "," + (box.h / 3 / eyeBox.h));
            var eyeBox1 = eye.getBBox();
            eye.transform("t" + (box.x - eyeBox1.x) + "," + (box.y - eyeBox1.y + box.h * 0.45) + "s" + (box.w / eyeBox.w) + "," + (box.h / 3 / eyeBox.h));
        });
    });

    Snap.load("svg/zzz.svg", function(f){
        zzz = f.select("path");
        zzz.attr({"data-lifetime": "sleeping", id: "zzz"});
        g_front.add(zzz);
        setZZZ();
    });
}

function makeEyesAwake(){
    snap.selectAll('*[data-lifetime=sleeping]').forEach(function(e){
        e.remove();
    });
    snap.selectAll('.eye').forEach(function(element){
        var box = element.getBBox();
        element.selectAll('*').forEach(function(e){
            e.attr({opacity: 1});
        });
    });
    Gammy.entity.jump();
}

function addBubi(i){
    var radius = 30 + 40 * Math.random();
    var x = canvas.width / 2 - radius;
    var y = canvas.height / 2 - radius;
    var w = canvas.width * 0.013;

    antG.add(new AntG.Pic({
        url: "img/bubi.png",
        x: x,
        y: y,
        xMove: w * (Math.random() * 2 - 1),
        yMove: w * (Math.random() * 2 - 1),
        lifespan: 30,
        fadeSpeed: 0.033333333333334,
        height: radius * 2,
        width: radius * 2
    }));

    if (i >= 0)
        setTimeout(addBubi, 150, i-1);
}

function size(rel){
    var r = re;
    return r;
}

function width(){
    return $(window).width();
}

function height(){
    return $(window).height();
}
