﻿ServiceProxy = function (serviceUrl) {
    this._serviceURL = serviceUrl;
    this._appType = 'firefoxOS';
};

ServiceProxy.prototype =
{
    _defaultErrorHandler: function (xhr, status, error) {
        alert(xhr.statusText);
    },

    _doGet: function (method, data, fnSuccess, fnError) {
        if (!data) data = {};

        if (!fnError) fnError = this._defaultErrorHandler;
        $.ajax({
            url: this._serviceURL + method,
            headers: { "appType": this._appType },
            data: data,
            cache: false,
            dataType: "json",
            success: fnSuccess,
            error: fnError
        });
    },

    _doPost: function (method, postData, fnSuccess, fnError) {
        if (!postData) postData = {};

        if (!fnError) fnError = this._defaultErrorHandler;
        $.ajax({
            url: this._serviceURL + method,
            type: "POST",
            data: postData,
            cache: false,
            dataType: "json",
            contentType: "application/json",
            success: fnSuccess,
            error: fnError
        });
    },

    GetCalendarRecords: function (regions, rear, front, success, error) {
        var method = 'api/calendar?&regions=' + regions + '&rear=' + rear + '&front=' + front;
        this._doGet(method, null, success, error);
    },

    GetAthleteProfile: function (id, success, error) {
        var method = 'api/profile/' + id;
        this._doGet(method, null, success, error);
    },

    GetRecords: function (regions, rear, front, fitarcoId, success, error) {
        var method = 'api/syncv1?&regions=' + regions + '&rear=' + rear + '&front=' + front + '&fitarcoId=' + fitarcoId;
        this._doGet(method, null, success, error);
    }

}