﻿var serviceProxy = new ServiceProxy('http://arco.dottor.net/');
kendo.culture("it-IT");


function ChartRecord(desc, val) {
    this.category = desc;
    this.value = val;
}

function ChartRaceRecord(desc, val) {
    this.name = desc;
    this.data = [val];
}

function FindRecordInArray(array, desc) {
    for (var i = 0; i < array.length; i++) {
        if (array[i].category == desc)
            return array[i];
    }
    return null;
}

function FindRecordInRaceArray(array, desc) {
    for (var i = 0; i < array.length; i++) {
        if (array[i].name == desc)
            return array[i];
    }
    return null;
}

function testSvg() {
    return !!document.createElementNS && !!document.createElementNS('http://www.w3.org/2000/svg', 'svg').createSVGRect;
}

/*****************************************************
 LOCAL STORAGE
 *****************************************************/

// Salvataggio dei settings dell'applicazione nel localStorage
//
function setAppSettings(settings) {
    window.localStorage.setItem('settings', JSON.stringify(settings));
}
function getAppSettings() {
    if (window.localStorage.getItem('settings') != null)
        return JSON.parse(window.localStorage.getItem("settings"));

    return null;
}

// Salvataggio del calendario nel localStorage
//
function setCalendar(calendar) {
    window.localStorage.setItem('calendar', JSON.stringify(calendar));
}
function getCalendar() {
    if (window.localStorage.getItem('calendar') != null)
        return JSON.parse(window.localStorage.getItem("calendar"));

    return null;
}

// Salvataggio del profilo utente nel localStorage
//
function setAthleteProfile(athlete) {
    if (athlete == null)
        window.localStorage.removeItem('athlete');
    else
        window.localStorage.setItem('athlete', JSON.stringify(athlete));
}
function getAthleteProfile() {
    if (window.localStorage.getItem('athlete') != null)
        return JSON.parse(window.localStorage.getItem("athlete"));

    return null;
}

// Salvataggio dei dati utili a creare i grafici
//
function setChartsData(chartsData) {
    if (chartsData == null)
        window.localStorage.removeItem('chartsData');
    else
        window.localStorage.setItem('chartsData', JSON.stringify(chartsData));
}
function getChartsData() {
    if (window.localStorage.getItem('chartsData') != null)
        return JSON.parse(window.localStorage.getItem("chartsData"));

    return null;
}

/*****************************************************
 CLASSI
 *****************************************************/

// Settings
//
var AppSettings = function (regions, rear, front, fitarcoId) {
    var self = this;

    self.Regions = regions;
    self.Rear = rear;
    self.Front = front;
    self.DateLastSync = null;
    self.FitarcoId = fitarcoId;
};


var calendarVM;
var CalendarViewModel = function () {
    var self = this;

    self.Waiting = ko.observable(false);
    self.Items = ko.observableArray(getCalendar());
    self.FilterSelectedRaceType = ko.observable();

    self.FilteredItems = ko.computed(function () {
        var filter = self.FilterSelectedRaceType();
        if (filter == '' || filter == null) {
            return self.Items();
        } else {
            return ko.utils.arrayFilter(self.Items(), function (item) {
                return item.Type.toLowerCase() == filter.toLowerCase();
            });
        }
    }, self);

    self.JustRaceTypes = ko.computed(function () {
        var types = ko.utils.arrayMap(self.Items(), function (item) {
            return item.Type;
        });
        return types.sort();
    }, self);

    self.RaceTypes = ko.dependentObservable(function () {
        return ko.utils.arrayGetDistinctValues(self.JustRaceTypes()).sort();
    }, self);

    self.SelectedRace = ko.observable(null);
    self.Profile = ko.observable(getAthleteProfile());
    self.AppSettings = ko.observable(null);
    self.SelectedRaceType = ko.observable(null);
    self.SelectedRaceDivision = ko.observable(null);
    self.RaceWithMinScore = ko.observable(null);
    self.RaceWithMaxScore = ko.observable(null);
    self.ShowNoSettings = ko.observable(true);

    // Settings
    self.Region00 = ko.observable(false);
    self.Region01 = ko.observable(false);
    self.Region02 = ko.observable(false);
    self.Region03 = ko.observable(false);
    self.Region04 = ko.observable(false);
    self.Region05 = ko.observable(false);
    self.Region06 = ko.observable(false);
    self.Region07 = ko.observable(false);
    self.Region08 = ko.observable(false);
    self.Region09 = ko.observable(false);
    self.Region10 = ko.observable(false);
    self.Region11 = ko.observable(false);
    self.Region12 = ko.observable(false);
    self.Region13 = ko.observable(false);
    self.Region14 = ko.observable(false);
    self.Region15 = ko.observable(false);
    self.Region16 = ko.observable(false);
    self.Region17 = ko.observable(false);
    self.Region18 = ko.observable(false);
    self.Region19 = ko.observable(false);
    self.Region20 = ko.observable(false);
    self.Region21 = ko.observable(false);

    self.RearSyncValue = ko.observable('rear0');
    self.FrontSyncValue = ko.observable('front7');
    self.FitarcoId = ko.observable(null);

    self.GoToDetails = function (race) {
        self.SelectedRace(race);
        window.location.href = "#raceDetail";
    };

    self.GoToStatsRace = function (race) {
        self.SelectedRaceType(race.Type);
        self.SelectedRaceDivision(race.Division);

        var racesData = getChartsData();
        if (racesData == null) {
            alert("Aggiornare i dati per visualizare le statistiche");
            return;
        }
        window.location.href = "#statsRace";
        self.CreateRacesChart(race.Type, race.Division, racesData);
    };

    self.RefreshRecords = function () {
        self.Items(null);

        if (!self.Waiting()) {
            var settings = getAppSettings();
            self.Waiting(true);
            serviceProxy.GetRecords(
                settings.Regions,
                settings.Rear,
                settings.Front,
                (settings.FitarcoId == null || settings.FitarcoId == '') ? 0 : settings.FitarcoId,
                function (result) {
                    setCalendar(result.CalendarItems);
                    self.Items(result.CalendarItems);

                    if (result.AthleteProfile != undefined && result.AthleteProfile != null) {
                        setAthleteProfile(result.AthleteProfile);
                        setChartsData(result.ChartRaceTypes);
                        result.AthleteProfile.DisplayRaceDetails = result.AthleteProfile.RaceDetails;
                        self.Profile(result.AthleteProfile);
                        self.CreateProfileChart();
                    } else {
                        self.Profile(null);
                        setAthleteProfile(null);
                        setChartsData(null);
                    }
                    self.Waiting(false);
                },
                function (xhr, status, error) {
                    self.Waiting(false);
                    alert("Errore durante l'aggiornamento. Verificare la connessione ad internet e riprovare ad eseguire l'aggiornamento");
                }
            );
        }
    };

    self.LoadSettings = function (settings) {
        try {
            self.RearSyncValue(settings.Rear);
            self.FrontSyncValue(settings.Front);
            self.FitarcoId(settings.FitarcoId);

            var regions = settings.Regions.split('-');
            for (var i = 0; i < regions.length; i++) {
                var region = regions[i];

                if (region == '00')
                    self.Region00(true);
                if (region == '01')
                    self.Region01(true);
                if (region == '02')
                    self.Region02(true);
                if (region == '03')
                    self.Region03(true);
                if (region == '04')
                    self.Region04(true);
                if (region == '05')
                    self.Region05(true);
                if (region == '06')
                    self.Region06(true);
                if (region == '07')
                    self.Region07(true);
                if (region == '08')
                    self.Region08(true);
                if (region == '09')
                    self.Region09(true);
                if (region == '10')
                    self.Region10(true);
                if (region == '11')
                    self.Region11(true);
                if (region == '12')
                    self.Region12(true);
                if (region == '13')
                    self.Region13(true);
                if (region == '14')
                    self.Region14(true);
                if (region == '15')
                    self.Region15(true);
                if (region == '16')
                    self.Region16(true);
                if (region == '17')
                    self.Region17(true);
                if (region == '18')
                    self.Region18(true);
                if (region == '19')
                    self.Region19(true);
                if (region == '20')
                    self.Region20(true);
                if (region == '21')
                    self.Region21(true);
            }
        } catch(e) {
            alert("Le impostazioni non sono state caricate correttamente.");
        }
    };

    self.SaveSettings = function () {
        var regions = '';
        if (self.Region00())
            regions = regions + "00-";
        if (self.Region01())
            regions = regions + "01-";
        if (self.Region02())
            regions = regions + "02-";
        if (self.Region03())
            regions = regions + "03-";
        if (self.Region04())
            regions = regions + "04-";
        if (self.Region05())
            regions = regions + "05-";
        if (self.Region06())
            regions = regions + "06-";
        if (self.Region07())
            regions = regions + "07-";
        if (self.Region08())
            regions = regions + "08-";
        if (self.Region09())
            regions = regions + "09-";
        if (self.Region10())
            regions = regions + "10-";
        if (self.Region11())
            regions = regions + "11-";
        if (self.Region12())
            regions = regions + "12-";
        if (self.Region13())
            regions = regions + "13-";
        if (self.Region14())
            regions = regions + "14-";
        if (self.Region15())
            regions = regions + "15-";
        if (self.Region16())
            regions = regions + "16-";
        if (self.Region17())
            regions = regions + "17-";
        if (self.Region18())
            regions = regions + "18-";
        if (self.Region19())
            regions = regions + "19-";
        if (self.Region20())
            regions = regions + "20-";
        if (self.Region21())
            regions = regions + "21-";

        var settings = new AppSettings(regions, self.RearSyncValue(), self.FrontSyncValue(), self.FitarcoId());
        setAppSettings(settings);

        self.RefreshRecords();
        window.location.href = "#start";
    };

    self.CreateProfileChart = function () {
        if (self.Profile() == null)
            return;

        try {
            var records = new Array();
            var racesData = getChartsData();
            if (racesData == null)
                return;

            for (var i = 0; i < racesData.length; i++) {
                var race = racesData[i];
                var obj = FindRecordInArray(records, race.Type);
                if (obj == null) {
                    records.push(new ChartRecord(race.Type, race.Count));
                } else {
                    obj.value = obj.value + race.Count;
                }
            }

            $("#chartProfile").width($(window).width());

            $("#chartProfile").kendoChart({
                theme: "metro",
                title: {
                    text: "Gare effettuate"
                },
                legend: {
                    position: "bottom",
                    labels: {
                        template: "#= text # (#= value #)"
                    }
                },
                seriesDefaults: {
                    labels: {
                        visible: true,
                        position: "outsideEnd",
                        format: "{0}"
                    }
                },
                series: [{
                    type: "donut",
                    data: records
                }],
                tooltip: {
                    visible: true,
                    //format: "{0} #= text #",
                    template: "#= category  #  [#= value #]"
                }
            });

            //Handle Android
            if (!testSvg()) {
                //Get chart SVG and output to canvas
                var chartEle = $("#chartProfile"),
                    chart = chartEle.data("kendoChart"),
                    svg = chart.svg();

                var canvas = document.createElement("canvas");
                canvas.setAttribute("style", "height:" + chartEle.height() + ";width:" + chartEle.width() + ";");

                canvg(canvas, svg);

                chartEle.empty(); //NOTE: Android 2.1 is hit and miss here
                chartEle.append(canvas);
            }
        } catch(e) {
            console.log(JSON.stringify(e));
        }
    };

    self.CreateRacesChart = function (type, division, racesData) {
        var records = new Array();
        var races = new Array();
        var dates = new Array();
        self.RaceWithMaxScore(null);
        self.RaceWithMinScore(null);

        if (racesData == null) {
            return;
        }

        for (var k = 0; k < racesData.length; k++) {
            if (racesData[k].Type == type && racesData[k].Division == division) {
                self.RaceWithMaxScore(racesData[k].MaxPointRace);
                self.RaceWithMinScore(racesData[k].MinPointRace);
            }
        }

        for (var j = 0; j < self.Profile().RaceDetails.length; j++) {
            var temp = self.Profile().RaceDetails[j];
            if (temp.Type == type && temp.Division == division && temp.Score != "0") {
                races.push(temp);
            }
        }

        races = races.slice(0, 20).reverse();

        for (var i = 0; i < races.length; i++) {
            var race = races[i];

            if (records.length == 0)
                records.push(new ChartRaceRecord(race.Type + ' ' + race.Division, parseInt(race.Score.replace('.', ''))));
            else
                records[0].data.push(parseInt(race.Score.replace('.', '')));

            dates.push(kendo.toString(new Date(race.Date), 'dd/MM/yyyy'));
        }

        $("#chartRaces").width($(window).width() - 20);

        $("#chartRaces").kendoChart({
            theme: "metro",
            title: {
                text: "Andamento ultime " + dates.length + " gare"
            },
            legend: {
                position: "bottom"
            },
            chartArea: {
                background: ""
            },
            seriesDefaults: {
                type: "line",
                missingValues: "interpolate",
            },
            series: records,
            valueAxis: {
                labels: {
                    format: "{0}"
                }
            },
            categoryAxis: {
                baseUnit: "",
                categories: dates,
                labels: {
                    //format: "dd MMM yyyy",
                    rotation: -90,
                    //visible: false
                },
            },
            tooltip: {
                visible: true,
                template: "Data:#= category #; Punteggio: ${value}"
            }
        });

        //Handle Android
        if (!testSvg()) {
            //Get chart SVG and output to canvas
            var chartEle = $("#chartRaces"),
                chart = chartEle.data("kendoChart"),
                svg = chart.svg();

            var canvas = document.createElement("canvas");
            canvas.setAttribute("style", "height:" + chartEle.height() + ";width:" + chartEle.width() + ";");

            canvg(canvas, svg);

            chartEle.empty(); //NOTE: Android 2.1 is hit and miss here
            chartEle.append(canvas);
        }
    };

    if (self.Items() != null && self.Items().length > 0)
        self.CreateProfileChart();
};

/*****************************************************
 PROGRAM
 *****************************************************/

function InitializeApp(){
    calendarVM = new CalendarViewModel();

    try {
        // load settings
        //
        var settings = getAppSettings();
        if (settings == null) {
            settings = new AppSettings(null, 'rear0', 'front7', null);
            // avviso l'utente di impostare i settings
            //
            calendarVM.ShowNoSettings(true);
        } else {
            calendarVM.LoadSettings(settings);
        }

        // imposto i settings nel ViewModel corrente
        //
        calendarVM.AppSettings(settings);
    } catch(e) {

    }

    pager.extendWithPage(calendarVM);
    window.VM = calendarVM;
    ko.applyBindings(calendarVM);
    pager.start();
}

//document.addEventListener('deviceready', InitializeApp);
$(document).ready(InitializeApp);