(function ($) {
    var getScript = function (url, callback, options) {
            var settings  = $.extend({
                'url': url,
                'success' : callback || function () {},
                'dataType' : 'script'
            }, options || {});
            $.ajax(settings);
        };

    $.getScript = getScript;
}($ || Zepto));

var navigation = {
	push: function(page, data) {
		var current = $('section[data-position="current"]');
		$.get(page + '.html', {dataType: 'html'}, function(response) {
			var right = $(response);
			right.data('position', 'right');
			right.insertAfter(current);
			
			$(document.head).append('<link id="' + page + 'ScreenStyle" rel="stylesheet" type="text/css" href="style/' + page + '.css"/>');
			
			$.getScript('js/' + page + '.js', function() {
				current.attr('class', 'left');
				right.attr('class', 'current');
			});
		});
	},
	pop: function() {
		var current = $('section[class="current"]');
		var left = current.prev('section[class="left"]');
		var currentStyle = $('#' + current.attr('id') + 'Style');
		
		current.attr('class', 'right');
		left.attr('class', 'current');
		setTimeout(function() {
			current.remove();
			// TODO: count how many ages use this!!!
			currentStyle.remove();
		}, 500);
	}
};
