var context = $('#coordinateFormatter');

$('.close-button', context).click(function() {
	navigation.pop();
});

var latitudeInput = $('.latitudeInput', context);
var longitudeInput = $('.longitudeInput', context);
var outputFormat = $('select', context);
var latitudeOutput = $('.latitudeOutput', context);
var longitudeOutput = $('.longitudeOutput', context);

latitudeInput.on('input', function() {
	computeLatitude();
});
longitudeInput.on('input', function() {
	computeLongitude();
});

outputFormat.on('change', function() {
	compute();
});

function computeLatitude() {
	var result = converting(latitudeInput.val(), outputFormat.val(), 'latitude');
	latitudeOutput.val(result.text);
	return result.double;
}

function computeLongitude() {
	var result = converting(longitudeInput.val(), outputFormat.val(), 'longitude');
	longitudeOutput.val(result.text);
	return result.double;
}

function compute() {	
	computeLatitude();
	computeLongitude();
}

var LatLng = function() {
	this.latitude = 0;
	this.longitude = 0;
};

var regExprs = {
	/**
	 * Index = Result
	 * 0 = N|S or W|E
	 * 1 = Degree
	 * 2 = Minutes
	 * 3 = Seconds
	 * 4 = .Seconds-Fraction
	 */
	DMS: {
		latitude: /^(N|S)\s*([1-8]?\d|90)(°\s*|\s+)([0-5]?\d)('\s*|\s+)([0-5]?\d)(\.\d)?"?$/i,
		longitude: /^(W|E)\s*(180|1[0-7]\d|0?\d{1,2})(°\s*|\s+)([0-5]?\d)('\s*|\s+)([0-5]?\d)(\.\d+)?"?$/i,
		match: "$1&$2&$4&$6&$7"
	},
	/**
	 * Index = Result
	 * 0 = N|S or W|E
	 * 1 = Degree
	 * 2 = Minutes
	 * 3 = .Seconds
	 */
	DM: {
		latitude: /^(N|S)\s*([1-8]?\d|90)(°\s*|\s+)([0-5]?\d)(\.\d+)?$/i,
		longitude: /^(W|E)\s*(180|1[0-7]\d|0?\d{1,2})(°\s*|\s+)([0-5]?\d)(\.\d+)?$/i,
		match: "$1&$2&$4&$5"
	},
	/**
	 * Index = Result
	 * 0 = -, + or nothing
	 * 1 = Degree
	 * 2 = .Minutes
	 */
	D: {
		latitude: /^(-|\+)?([1-8]?\d|90)(\.\d+)?$/i,
		longitude: /^(-|\+)?(180|1[0-7]\d|0?\d{1,2})(\.\d+)?$/i,
		match: "$1&$2&$3"
	}
};

function getFrom(latOrLon, type) {
	if (regExprs.DMS[type].test(latOrLon)) {
		return 'DMS';
	} else if (regExprs.DM[type].test(latOrLon)) {
		return 'DM';
	} else if (regExprs.D[type].test(latOrLon)) {
 		return 'D';
	} else {
		return null;
	}
}

function toDouble(latOrLon, type) {
	var from = getFrom(latOrLon, type);
	if (from == null) {
		return null;
	}
	
	var parsed = latOrLon.replace(regExprs[from][type], regExprs[from].match).split('&');
	switch (from) {
	case 'DMS':
		return (parseInt(parsed[1]) + (parseInt(parsed[2]) * 60 + parseFloat(parsed[3] + parsed[4])) / 3600) * (parsed[0].toUpperCase() == (type == 'latitude' ? 'N' : 'E') ? 1 : -1);
		
	case 'DM':
		return (parseInt(parsed[1]) + parseFloat(parsed[2] + parsed[3]) / 60) * (parsed[0].toUpperCase() == (type == 'latitude' ? 'N' : 'E') ? 1 : -1);
		
	default:
		return parseFloat(parsed[1] + parsed[2]) * (parsed[0] == (type == 'latitude' ? 'S' : 'W') || parsed[0] == '-' ? -1 : 1);
	}	
}

function convert(from, type, to) {
	if (from == null) {
		return "Invalid input format.";
	}
	var result;
	var degree;
	switch (to) {
	case 'DMS':
		result = (type == 'latitude' ? (from < 0 ? 'S ' : 'N ') : (from < 0 ? 'W ' : 'E '));
		degree = parseInt(from) * (from < 0 ? -1 : 1);
		if (degree < 10) {
			result += '0';
		}
		result += degree;
		result += '\u00B0 ';
		var mins = ((from - degree) * 60);
		result += parseInt(mins) + "' ";
		result += ((mins - parseInt(mins)) * 60).toFixed(0) + '"';
		break;
		
	case 'DM':
		result = (type == 'latitude' ? (from < 0 ? 'S ' : 'N ') : (from < 0 ? 'W ' : 'E '));
		degree = parseInt(from) * (from < 0 ? -1 : 1);
		if (degree < 10) {
			result += '0';
		}
		result += degree;
		result += '\u00B0 ';
		result += ((from - degree) * 60).toFixed(3);
		break;
		
	default:
		result = from.toFixed(5) + '\u00B0';
		break;
	}
	return result;
}

function converting(latOrLon, format, type) {
	if (latOrLon.length == 0) {
		return "";
	}
	var double = toDouble(latOrLon, type);
	return {
		double: double,
		text: convert(double, type, format)
	};
}