var context = $('#romanNumbers');

$('.close-button', context).click(function() {
	navigation.pop();
});

var numeralInput = $('input', context);
var numeralOutput = $('textarea', context);

numeralInput.on('input', function() {
	calculate();
});

function calculate() {
	var input = numeralInput.val();
	var func;
	if (romanRegExp().test(input)) {
		func = romanToArabic;
	} else if (numberRegExp().test(input)) {
		func = arabicToRoman;
	} else {
		numeralOutput.val("Your input neither matches a valid roman nor an arabic number.");
		return;
	}

	try {
		numeralOutput.val(func(input));
	} catch (error) {
		numeralOutput.val(error);
	}	
}

function numbers() {
	if (!arguments.callee.values) {
		arguments.callee.values = [ 1000, 900, 500, 400, 100, 90, 50, 40, 10,
				9, 5, 4, 1 ];
	}
	return arguments.callee.values;
}

function letters() {
	if (!arguments.callee.values) {
		arguments.callee.values = [ "M", "CM", "D", "CD", "C", "XC", "L", "XL",
				"X", "IX", "V", "IV", "I" ];
	}
	return arguments.callee.values;
}

function romanRegExp() {
	if (!arguments.callee.values) {
		arguments.callee.values = /^M{0,3}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$/i;
	}
	return arguments.callee.values;
}

function numberRegExp() {
	if (!arguments.callee.values) {
		arguments.callee.values = /^\d+$/i;
	}
	return arguments.callee.values;
}

function letterToNumber(letter) {
	switch (letter) {
	case 'I':
		return 1;
	case 'V':
		return 5;
	case 'X':
		return 10;
	case 'L':
		return 50;
	case 'C':
		return 100;
	case 'D':
		return 500;
	case 'M':
		return 1000;
	default:
		return -1;
	}
}

function romanToArabic(numberInput) {
	var roman = numberInput.toUpperCase();
	if (roman.length == 0) {
		return "";
	}
	if (!romanRegExp().test(numberInput)) {
		throw "The given input is not a valid roman numeral.";
	}
	var i = 0;
	var arabic = 0;
	while (i < roman.length) {
		var letter = roman.charAt(i);
		var number = letterToNumber(letter);
		if (number < 0) {
			throw "Roman numerals can't contain the character " + letter + ".";
		}
		++i;
		if (i == roman.length) {
			arabic += number;
		} else {
			var nextNumber = letterToNumber(roman.charAt(i));
			if (nextNumber > number) {
				arabic += (nextNumber - number);
				++i;
			} else {
				arabic += number;
			}
		}
	}
	if (arabic > 3999) {
		throw "Roman numerals can't be bigger than MMMCMXCIX (3999).";
	}
	return arabic;
}

function arabicToRoman(numberInput) {
	var roman = "";
	var N = parseInt(numberInput);
	if (!N) {
		throw "Not a valid number to be converted. Valid: 1 - 3999.";
	}
	if (N > 3999) {
		throw "Roman numerals can't be bigger than 3999.";
	}
	var nbrs = numbers();
	var ltrs = letters();
	for ( var i = 0; i < nbrs.length; ++i) {
		while (N >= nbrs[i]) {
			roman += ltrs[i];
			N -= nbrs[i];
		}
	}
	return roman;
}
