var context = $('#textCalculator');

$('.close-button', context).click(function() {
	navigation.pop();
});

var textInput = $('textarea', context);
var modeSelect = $('select', context);
var resultCharCount = $('.resultCharCount', context);
var resultCharValueSum = $('.resultCharValueSum', context);
var resultDigitSum = $('.resultDigitSum', context);
var resultLastDigitSum = $('.resultLastDigitSum', context);

var currentMode = a1;

modeSelect.on('change', function() {
	switch(modeSelect.val()) {
	case "a1":
		currentMode = a1;
		break;

	case "z1":
		currentMode = z1;
		break;

	case "t9":
		currentMode = t9;
		break;
	}
	calculate();
});

textInput.on('input', function() {
	calculate();
});

function calculate() {
	var result = currentMode.apply(null, [textInput.val()]);
	resultCharCount.text(result.charCount);
	resultCharValueSum.text(result.charSum);
	resultDigitSum.text(result.digitSum);
	resultLastDigitSum.text(result.reducedDigitSum);
}

function calculateDigitSum(v, reduced) {
	if (arguments.length == 1) {
		reduced = false;
	}
	if (v <= 9) {
		return v;
	} else if (reduced) {
		return calculateDigitSum(v % 10 + parseInt(v / 10), reduced);
	} else {
		return v % 10 + calculateDigitSum(parseInt(v / 10));
	}
}

function a1(text) {
	var result = {
		charCount : 0,
		charSum : 0,
		digitSum : 0,
		reducedDigitSum : 0
	};
	var charCountResult = 0;
	var charSumResult = 0;
	var digitSumResult = 0;
	for ( var i = 0; i < text.length; ++i) {
		++charCountResult;
		var c = text.charCodeAt(i);
		if (c >= 'A'.charCodeAt(0) && c <= 'Z'.charCodeAt(0)) {
			charSumResult += c - 'A'.charCodeAt(0) + 1;
			digitSumResult += calculateDigitSum(c - 'A'.charCodeAt(0) + 1);
		} else if (c >= 'a'.charCodeAt(0) && c <= 'z'.charCodeAt(0)) {
			charSumResult += c - 'a'.charCodeAt(0) + 1;
			digitSumResult += calculateDigitSum(c - 'a'.charCodeAt(0) + 1);
		}
		if (c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0)) {
			charSumResult += c - '0'.charCodeAt(0);
			digitSumResult += calculateDigitSum(c - '0'.charCodeAt(0));
		}
	}
	result.charCount = charCountResult;
	result.charSum = charSumResult;
	result.digitSum = digitSumResult;
	result.reducedDigitSum = calculateDigitSum(digitSumResult, true);
	return result;
}

function z1(text) {
	var result = {
		charCount : 0,
		charSum : 0,
		digitSum : 0,
		reducedDigitSum : 0
	};
	var charCountResult = 0;
	var charSumResult = 0;
	var digitSumResult = 0;
	for ( var i = 0; i < text.length; ++i) {
		++charCountResult;
		var c = text.charCodeAt(i);
		if (c >= 'A'.charCodeAt(0) && c <= 'Z'.charCodeAt(0)) {
			charSumResult += -c + 1 + 'Z'.charCodeAt(0);
			digitSumResult += calculateDigitSum(-c + 1 + 'Z'.charCodeAt(0));
		} else if (c >= 'a'.charCodeAt(0) && c <= 'z'.charCodeAt(0)) {
			charSumResult += -c + 1 + 'z'.charCodeAt(0);
			digitSumResult += calculateDigitSum(-c + 1 + 'z'.charCodeAt(0));
		}
		if (c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0)) {
			charSumResult += c - '0'.charCodeAt(0);
			digitSumResult += calculateDigitSum(c - '0'.charCodeAt(0));
		}
	}
	result.charCount = charCountResult;
	result.charSum = charSumResult;
	result.digitSum = digitSumResult;
	result.reducedDigitSum = calculateDigitSum(digitSumResult, true);
	return result;
}

function t9(text) {
	var result = {
		charCount : 0,
		charSum : 0,
		digitSum : 0,
		reducedDigitSum : 0
	};
	var charCountResult = 0;
	var charSumResult = 0;
	var digitSumResult = 0;
	for ( var i = 0; i < text.length; ++i) {
		++charCountResult;
		var c = text.charCodeAt(i);
		var tmp = NaN;
		if (c >= 'A'.charCodeAt(0) && c <= 'Z'.charCodeAt(0)) {
			tmp = c - 'A'.charCodeAt(0);
		} else if (c >= 'a'.charCodeAt(0) && c <= 'z'.charCodeAt(0)) {
			tmp = c - 'a'.charCodeAt(0);
		}
		if (tmp) {
			tmp = parseInt(tmp / 3) + 2;
			if (c == 'S'.charCodeAt(0) || c == 's'.charCodeAt(0)
					|| c == 'V'.charCodeAt(0) || c == 'v'.charCodeAt(0)
					|| c == 'Y'.charCodeAt(0) || c == 'y'.charCodeAt(0)
					|| c == 'Z'.charCodeAt(0) || c == 'z'.charCodeAt(0)) {
				--tmp;
			}
			charSumResult += tmp;
			digitSumResult += calculateDigitSum(tmp);
		}
		if (c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0)) {
			charSumResult += c - '0'.charCodeAt(0);
			digitSumResult += calculateDigitSum(c - '0'.charCodeAt(0));
		}
	}
	result.charCount = charCountResult;
	result.charSum = charSumResult;
	result.digitSum = digitSumResult;
	result.reducedDigitSum = calculateDigitSum(digitSumResult, true);
	return result;
}
