var loc=new LatLon(0,0),dest=new LatLon(90,0);
var realDest=false;

$(document).ready(function() {
  var latitude = $( "#latitude" ),
      longitude = $( "#longitude" ),
      tips = $( "#validateTips" );
  
  function errormsg(t)
  {
    tips
      .text( t )
      .addClass( "ui-state-highlight" );
  }
    
  function check(o,n,min,max)
  {
    if(o.val()===""||isNaN(o.val())||o.val()<min||o.val()>max)
    {
      errormsg("a "+n+" "+min+" és "+max+" közötti tizedestört!");
      return(false);
    }
    return(true);
  }
  
  $( "div#dialog-form" ).dialog({
        autoOpen: false,
        modal: true,
        buttons: {
          "OK": function() {
            if(check(longitude,"hosszúság",-180,180)&&
              check(latitude,"szélesség",-90,90))
            {
              dest=new LatLon(latitude.val(),longitude.val());
              realDest=true;
              $( this ).dialog( "close" );
              alert("Az új cél:\n"+dest._lat+"\n"+dest._lon);
            }
          },
          Cancel: function() {
            $( this ).dialog( "close" );
          }
        }
  });
  
  $( "#set-destination" ).click(function()
  {
		$( "div#dialog-form" ).dialog( "open" );
	});
  
  $( "#get-location" ).click(function ()
  {
    alert(loc._lat+"\n"+loc._lon);
  });
});
 
function rotate(object, degrees)
{
    object.css({'-moz-transform' : 'rotate('+degrees+'deg)'});
}

function setDistance(text)
{
  $( "#distance" ).text(text);
}

window.ondeviceorientation = function (event)
{
  var brng = loc.bearingTo(dest);
  var pointer = $("#pointer");
  var sum=-event.alpha+brng;
  rotate(pointer, sum);
};

navigator.geolocation.watchPosition(
  function (position)
  {
    loc=new LatLon(position.coords.latitude,position.coords.longitude);
    if(realDest)
    {
      var dst=loc.distanceTo(dest)*1000;
      if(dst>3)
      {
        setDistance(dst.toFixed()+"m");
      }
      else
      {
        setDistance("megérkeztél");
      }
    }
    $( ".onGPS" ).css( {"display" : "inline"} );
    $( "#GPS-error" ).css( {"display" : "none"} );
  },
  function (error) {
    $( ".onGPS" ).css( {"display" : "none"} );
    $( "#GPS-error" )
      .text("Helymeghatározás (egyenlőre) sikertelen:\n"+error.message)
      .css( {"display" : "inline"} );
  }
);