var appName;
var pkgName;
var aclInstallState;

function onLoad() {
    appName = sessionStorage.getItem('appName');
    pkgName = sessionStorage.getItem('pkgName');
    var hdr = sessionStorage.getItem('header');
    var msg1 = sessionStorage.getItem('msg1');
    var msg2 = sessionStorage.getItem('msg2');
    var waitstate = sessionStorage.getItem('waitstate');

    console.log("In pleasewait.js...");

    document.getElementById('pleasewait_header').textContent = hdr;
    document.getElementById('pleasewait_body').textContent = msg1 + ' ' + appName + ' ' + msg2;

    if (waitstate === 'appinstall') {
        document.getElementById('appicon').src = 'style/icons/main.png';
        setInterval(function(){checkInstallStatus();}, 1000);
    }
    else {
        document.getElementById('appicon').src = 'style/icons/ACL.png';
        navigator.getFeature("acl.install_status").then(function(installStatus) {
            console.log("onLoad: install status is " + installStatus);
            if (installStatus !== 'installing' &&
                installStatus !== 'uninstalling' &&
                installStatus !== 'upgrading') {
                if(installStatus === '' || installStatus === 'uninstalled') {
                    console.log("redirecting to download.html");
                    window.location.href = "/download.html";
                }
                else {
                    console.log("redirecting to reboot.html");
                    window.location.href = "/reboot.html";
                }
            }
            else {
                aclInstallState = installStatus;
                setInterval(function(){waitForAclStateChange();}, 1000);
            }
        });
    }
}

function checkInstallStatus() {
    console.log("pleasewait: checking install status");
    navigator.getFeature("acl." + pkgName + ".is").then(function(installStatus) {
        if (installStatus === "installed") {
            console.log("Installed, going to main");
            window.location.href = "/index.html";
        }
        else {
            console.log("...still waiting");
        }
    });
}

function waitForAclStateChange() {
    console.log("pleasewait: checking ACL install status");
    navigator.getFeature("acl.install_status").then(function(installStatus) {
        if(installStatus === aclInstallState) {
            console.log("...status is still " + installStatus + "; waiting");
        }
        else {
            if(installStatus === '' || installStatus === 'uninstalled') {
                console.log("redirecting to download.html");
                window.location.href = "/download.html";
            }
            else {
                console.log("redirecting to reboot.html");
                window.location.href = "/reboot.html";
            }
        }
    });
}



window.onload = onLoad;
