
$(document).ready(function() {    	     
    
    // Get Canvas & Context
    var canvas = document.getElementById('clockCanvas');
    var ctx = canvas.getContext('2d');  
    var audioBeep = document.getElementById('alarmBeep');
    var color = "#FFFFFF"; 


color = prompt("Select Color of Your Clock:\ne.g:red, blue, green, yellow, golden, skyblue", "");



    // Initialize Settings        
    var x = 10, 
        y = 10, 
        size = 50, 
        pointSize = 14,
        setting = "hours",
        i = 0;
    
    
switch(color){
        
        
        
        case 'red':
        color = "#FF0009";
        break;
        
        case 'green':
        color = "#22FF00";
        break;
        
        case 'yellow':
        color = "#FFFF00";
        break;
        
        case 'orange':
        color = "#F87A17";
        break;
        
        case 'golden':
        color = "#D4A017";
        break;
        
        case 'blue':
        color = "#0000FF";
        break;
        
        case 'skyblue':
        color = "#3BB9FF";
        break;
        
        default:
        color="#FFFFFF";
        
        
        
}
     
         
    var alarmClock = new alarm(x, y, size, pointSize, color, "rgb(10, 10, 10)",  ctx);          
        

    // Pick up keypresses 
    $(document).keydown(function(e) {
        if (alarmClock.status === "set"){
            switch(e.which){
                case 38:	
            	    if (setting === "hours"){
        		        alarmClock.alarmHour = alarmClock.alarmHour === 24 ? 0 : alarmClock.alarmHour + 1;
        		    }else{
         		        alarmClock.alarmMin = alarmClock.alarmMin === 59 ? 0 : alarmClock.alarmMin + 1;
               		    }  
          		    break;
          	    case 40:	
          	        if (setting == "hours"){
          	            alarmClock.alarmHour = alarmClock.alarmHour === 0 ? 24 : alarmClock.alarmHour - 1;
          	        }else{
          	    	    alarmClock.alarmMin = alarmClock.alarmMin === 0 ? 59 : alarmClock.alarmMin - 1;
          	    	}  
          	    	break;
            	case 37:
                case 39:
            	    setting = setting === "mins" ? "hours" : "mins";
        		    break;
            }
        }
          
    });
    
    
     
    // Draw Alarm     
    setInterval(function(){
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        alarmClock.draw();          
        if (alarmClock.status == "alarm" && i == 0){
                // Play Beep
                audioBeep.play();   
        }  
        i = i > 8 ? 0 : i +1;        
    }, 100); 
        
    // Set Alarm
    $('#setAlarm').click(function(){
        alarmClock.status = alarmClock.status == "set" ? "clock" : "set";
        alarmClock.alarmStatus = "on";
        $(this).toggleClass("activated");       
        return false;
    });    
    
    $('#cancel').click(function(){
        alarmClock.alarmStatus = "off";
        if (alarmClock.status == "set"){
            $('#setAlarm').toggleClass("activated");
        }
        return false;
    });   
 
 
    
    
});   


        
       
    
      


 