/*
 * Copyright (C) 2015, Nicola Spanti (also known as RyDroid) <dev@nicola-spanti.info>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


/**
 * @constructor
 */
function GnuRunner(img_path)
{
	"use strict";
	
	if(isString(img_path))
		this.imageAlive = ImagesStatusCache.getImageStatus(img_path);
	else
		this.imageAlive = ImagesStatusCache.getImageStatus('images/runners/gnu-head_30-years-anniversary.svg');
	this.imageDead = ImagesStatusCache.getImageStatus('images/runners/gnu-head_ghost.svg');
	
	this.isAlive = true;
	
	this.nbGoodItemsCollected = 0;
}

GnuRunner.prototype.getImageStatus = function()
{
	"use strict";
	return this.isAlive ? this.imageAlive : this.imageDead;
};

GnuRunner.prototype.getImage = function()
{
	"use strict";
	return this.getImageStatus().image;
};

GnuRunner.prototype.isReady = function()
{
	"use strict";
	return this.imageAlive.isReady && this.imageDead.isReady;
};

GnuRunner.prototype.setDrawingInformation = function(drawingInformation)
{
	if(!(drawingInformation instanceof ObjectDrawing2DInformation))
		throw new TypeError('drawingInformation must be an instance of ObjectDrawing2DInformation');
	this.drawingInformation = drawingInformation;
};

GnuRunner.prototype.die = function()
{
	"use strict";
	this.isAlive = false;
};

GnuRunner.prototype.hitBy = function(object)
{
	"use strict";
	
	if(object instanceof RunnerPathItem)
	{
		if(object.isGood)
		{
			++this.nbGoodItemsCollected;
			/* TODO */
		}
		else
			this.die();
	}
};

GnuRunner.prototype.getScore = function()
{
	"use strict";
	return this.nbGoodItemsCollected;
};
