/*
 * Copyright (C) 2014, Nicola Spanti (also known as RyDroid) <dev@nicola-spanti.info>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


(function()
{
	/**
	 * Decimal adjustment of a number.
	 * @source https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round
	 * @param  {String}	 type     The type of adjustment.
	 * @param  {Number}	 value    The number.
	 * @param  {Integer} exponent The exponent (the 10 logarithm of the adjustment base).
	 * @return {Number}	          The adjusted value.
	 */
	function decimalAdjust(type, value, exponent)
	{
		// If the exp is undefined or zero...
		if (typeof(exponent) === 'undefined' || +exponent === 0)
			return Math[type](value);
		
		value = +value;
		exponent = +exponent;
		// If the value is not a number or the exp is not an integer...
		if (isNaN(value) || !(typeof(exponent) === 'number' && exponent % 1 === 0))
			return NaN;
		
		// Shift
		value = value.toString().split('e');
		value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exponent) : -exponent)));
		// Shift back
		value = value.toString().split('e');
		return +(value[0] + 'e' + (value[1] ? (+value[1] + exponent) : exponent));
	}
	
	// Decimal round
	if (!Math.round10)
	{
		Math.round10 = function(value, exponent)
		{
			'use strict';
			return decimalAdjust('round', value, exponent);
		};
	}
	
	// Decimal floor
	if (!Math.floor10)
	{
		Math.floor10 = function(value, exponent)
		{
			'use strict';
			return decimalAdjust('floor', value, exponent);
		};
	}
	
	// Decimal ceil
	if (!Math.ceil10)
	{
		Math.ceil10 = function(value, exponent)
		{
			'use strict';
			return decimalAdjust('ceil', value, exponent);
		};
	}
})();
