function Controller() {
    function openTeamSelect() {
        $.teamSelect.visible = true;
    }
    function finishSelection() {
        gli.setFaveTeams(favoriteTeams);
        Ti.App.Properties.setBool("notFirstRun", true);
        var menu = Alloy.createController("menu").getView();
        Alloy.Globals.winIndex.add(menu);
        Alloy.Globals.winIndex.remove($.firstRun);
    }
    function toggleFavorite(e) {
        var row = e.row;
        var icon = _.find(row.children, function(i) {
            return "favoriteIcon" === i.id;
        });
        if (row.active) {
            icon.backgroundImage = "images/iconFavouriteOff.png";
            favoriteTeams = _.without(favoriteTeams, row.teamId);
            row.active = false;
        } else {
            icon.backgroundImage = "images/iconFavouriteOn.png";
            favoriteTeams.push(row.teamId);
            row.active = true;
        }
        gli.is("favoriteTeams", favoriteTeams);
    }
    function searchClicked(e) {
        gli.is("search return", e);
        Alloy.Globals.loading.showHide("show");
        _.defer(function() {
            doSearch(e.source.value);
        });
    }
    function doSearch(text) {
        gli.i("doing team search for: " + text);
        var results = _.filter(Alloy.Globals.teams, function(i) {
            return -1 !== i.name.toLowerCase().indexOf(text.toLowerCase());
        });
        var tableData = [];
        _.each(results, function(i) {
            tableData.push(Alloy.createController("firstRunTeamRow", {
                name: i.name,
                logo: i.logo,
                id: i.teamId
            }).getView());
        });
        $.table.data = tableData;
        _.defer(function() {
            $.searchField.blur();
            Alloy.Globals.loading.showHide("hide");
        });
    }
    function tableScrolled(e) {
        gli.i("scrolling... y: " + e.contentOffset.y + " | next load point: " + scrollNextRenderY);
        if (e.contentOffset.y > scrollNextRenderY) {
            scrollNextRenderY += 600;
            lazyLoad(12);
        }
    }
    function lazyLoad(n) {
        Alloy.Globals.loading.showHide("show");
        _.defer(function() {
            var itemsToRender = _.first(teams, n);
            teams = _.rest(teams, n);
            _.each(itemsToRender, function(i) {
                $.table.appendRow(Alloy.createController("firstRunTeamRow", {
                    id: i.teamId,
                    name: i.name,
                    logo: i.logo
                }).getView());
            });
            _.defer(function() {
                Alloy.Globals.loading.showHide("hide");
            });
        });
    }
    function buildTeamList() {
        if (Alloy.Globals.dataValidTeams) {
            teams = Alloy.Globals.teams;
            lazyLoad(12);
        } else setTimeout(buildTeamList, 300);
    }
    function activateButton() {
        if (Alloy.Globals.dataValidTeams) {
            buttonTeamSelect.touchEnabled = true;
            buttonTeamSelect.text = L("Button_FirstLaunch");
        } else setTimeout(activateButton, 1e3);
    }
    function init() {
        buttonTeamSelect = $.UI.create("Label", {
            text: L("Alert_LoadingTeams"),
            classes: [ "buttonWideGreen", "bold", "colorWhite" ],
            textAlign: Ti.UI.TEXT_ALIGNMENT_CENTER,
            bottom: 72,
            touchEnabled: false
        });
        buttonSkipTeamSelect = $.UI.create("Label", {
            text: L("Alert_LoadingTeams"),
            classes: [ "buttonWideGreen", "bold", "colorWhite" ],
            textAlign: Ti.UI.TEXT_ALIGNMENT_CENTER,
            bottom: 12,
            touchEnabled: false,
            text: L("Button_SkipFirstLaunch"),
            touchEnabled: true
        });
        buttonTeamSelect.addEventListener("click", openTeamSelect);
        buttonSkipTeamSelect.addEventListener("click", finishSelection);
        var screenContent = [ {
            title: L("Startup_Page1Title"),
            text: L("Startup_Page1Text")
        }, {
            title: L("Startup_Page2Title")
        }, {
            title: L("Startup_Page3Title")
        }, {
            title: L("Startup_Page4Title")
        }, {
            title: L("Startup_Page5Title")
        }, {
            title: L("Startup_Page6Title"),
            view: buttonTeamSelect,
            view1: buttonSkipTeamSelect
        } ];
        _.each(screenContent, function(i) {
            gli.i("creating screen for scrollable");
            var view = Alloy.createController("firstRunContentItem", {
                title: i.title,
                text: i.text,
                view: i.view,
                view1: i.view1
            }).getView();
            $.scrollable.addView(view);
        });
        buildTeamList();
        _.defer(activateButton);

        openTeamSelect();
    }
    require("alloy/controllers/BaseController").apply(this, Array.prototype.slice.call(arguments));
    this.__controllerPath = "firstRun";
    arguments[0] ? arguments[0]["__parentSymbol"] : null;
    arguments[0] ? arguments[0]["$model"] : null;
    arguments[0] ? arguments[0]["__itemTemplate"] : null;
    var $ = this;
    var exports = {};
    var __defers = {};
    $.__views.firstRun = Ti.UI.createView({
        id: "firstRun"
    });
    $.__views.firstRun && $.addTopLevelView($.__views.firstRun);
    var __alloyId0 = [];
    $.__views.scrollable = Ti.UI.createScrollableView({
        backgroundImage: "images/bgFirstRun.png",
        views: __alloyId0,
        id: "scrollable"
    });
    $.__views.firstRun.add($.__views.scrollable);
    $.__views.teamSelect = Ti.UI.createView({
        backgroundColor: Alloy.CFG.colors.darkBlue,
        layout: "vertical",
        visible: false,
        id: "teamSelect"
    });
    $.__views.firstRun.add($.__views.teamSelect);
    $.__views.titleBar = Ti.UI.createView({
        backgroundColor: Alloy.CFG.colors.darkBlue,
        height: 40,
        top: 0,
        id: "titleBar"
    });
    $.__views.teamSelect.add($.__views.titleBar);
    $.__views.title = Ti.UI.createLabel({
        font: {
            fontSize: 20,
            fontFamily: Alloy.CFG.fonts.bold
        },
        color: Alloy.CFG.colors.white,
        text: L("FirstRun_TitleTeamSelect"),
        id: "title"
    });
    $.__views.titleBar.add($.__views.title);
    $.__views.doneButton = Ti.UI.createLabel({
        font: {
            fontSize: 13,
            fontFamily: Alloy.CFG.fonts.bold
        },
        color: Alloy.CFG.colors.white,
        width: 48,
        height: 36,
        backgroundImage: "/images/buttonBlue.png",
        right: 10,
        text: L("Button_Done"),
        textAlign: Ti.UI.TEXT_ALIGNMENT_CENTER,
        id: "doneButton"
    });
    $.__views.titleBar.add($.__views.doneButton);
    finishSelection ? $.__views.doneButton.addEventListener("click", finishSelection) : __defers["$.__views.doneButton!click!finishSelection"] = true;
    $.__views.searchWrapper = Ti.UI.createView({
        height: Ti.UI.SIZE,
        id: "searchWrapper"
    });
    $.__views.teamSelect.add($.__views.searchWrapper);
    $.__views.searchField = Ti.UI.createTextField({
        height: 30,
        backgroundColor: Alloy.CFG.colors.black,
        borderRadius: 10,
        borderColor: "transparent",
        borderWidth: 3,
        color: Alloy.CFG.colors.white,
        paddingLeft: 10,
        width: 300,
        bottom: 10,
        id: "searchField"
    });
    $.__views.searchWrapper.add($.__views.searchField);
    searchClicked ? $.__views.searchField.addEventListener("return", searchClicked) : __defers["$.__views.searchField!return!searchClicked"] = true;
    $.__views.table = Ti.UI.createTableView({
        separatorColor: Alloy.CFG.colors.darkGrey,
        backgroundColor: "transparent",
        id: "table"
    });
    $.__views.teamSelect.add($.__views.table);
    toggleFavorite ? $.__views.table.addEventListener("click", toggleFavorite) : __defers["$.__views.table!click!toggleFavorite"] = true;
    tableScrolled ? $.__views.table.addEventListener("scroll", tableScrolled) : __defers["$.__views.table!scroll!tableScrolled"] = true;
    exports.destroy = function() {};
    _.extend($, $.__views);
    var gli = require("helpers");
    require("feedSigner"), require("netConnect");
    var buttonTeamSelect, teams, favoriteTeams = [], scrollNextRenderY = 80;
    init();
    __defers["$.__views.doneButton!click!finishSelection"] && $.__views.doneButton.addEventListener("click", finishSelection);
    __defers["$.__views.searchField!return!searchClicked"] && $.__views.searchField.addEventListener("return", searchClicked);
    __defers["$.__views.table!click!toggleFavorite"] && $.__views.table.addEventListener("click", toggleFavorite);
    __defers["$.__views.table!scroll!tableScrolled"] && $.__views.table.addEventListener("scroll", tableScrolled);
    _.extend($, exports);
}

var Alloy = require("alloy"), Backbone = Alloy.Backbone, _ = Alloy._;

module.exports = Controller;