﻿var app = app || {};
app.Models.MatchModel = app.Models.BaseModel.extend({
    getIsLive: function () {
        return this.get("matchState") == 1 || this.get("matchState") == 2 || this.get("matchState") == 3 || this.get("matchState") == 5 || this.get("matchState") == 7;
    },
    getIsLiveOrNotStarted: function () {
        return this.getIsLive() || this.get("matchState") == 0;
    },

    getIsFinished: function () {
        return !this.getIsLiveOrNotStarted();
    }
});

app.Models.MatchCollection = Backbone.Collection.extend({
    model: app.Models.BaseModel,

    getSummary: function () {
        var filtered = this.filter(function (model) {
            var matchNotItem = { assetId: model.get("id"), assetType: 1 };
            var homeNotItem = { assetId: model.get("homeTeamId"), assetType: 2 };
            var awayNotItem = { assetId: model.get("awayTeamId"), assetType: 2 };
            return model.get("isSummary") && !(Settings.isSubscribed(matchNotItem)
                || Settings.isSubscribed(homeNotItem)
                || Settings.isSubscribed(awayNotItem));
        });
        return new app.Models.MatchCollection(filtered);
    },
    
    getFavorite: function(isLive) {
        var filtered = this.filter(function(model) {
            var matchNotItem = { assetId: model.get("id"), assetType: 1 };
            var homeNotItem = { assetId: model.get("homeTeamId"), assetType: 2 };
            var awayNotItem = { assetId: model.get("awayTeamId"), assetType: 2 };
           
            return (Settings.isSubscribed(matchNotItem)
                || Settings.isSubscribed(homeNotItem)
                || Settings.isSubscribed(awayNotItem))
                && (!isLive || model.get("isLive"));
                
        });
        return new app.Models.MatchCollection(filtered);
    },
    
    getNotFavorite: function (isLive) {
        var filtered = this.filter(function (model) {
            var matchNotItem = { assetId: model.get("id"), assetType: 1 };
            var homeNotItem = { assetId: model.get("homeTeamId"), assetType: 2 };
            var awayNotItem = { assetId: model.get("awayTeamId"), assetType: 2 };

            return !(Settings.isSubscribed(matchNotItem)
                || Settings.isSubscribed(homeNotItem)
                || Settings.isSubscribed(awayNotItem));
        });
        return new app.Models.MatchCollection(filtered);
    },
    
    
    getLive: function () {
        var filtered = this.filter(function (model) {
            var matchNotItem = { assetId: model.get("id"), assetType: 1 };
            var homeNotItem = { assetId: model.get("homeTeamId"), assetType: 2 };
            var awayNotItem = { assetId: model.get("awayTeamId"), assetType: 2 };
            return model.getIsLive() && !(Settings.isSubscribed(matchNotItem)
                || Settings.isSubscribed(homeNotItem)
                || Settings.isSubscribed(awayNotItem));
        });
        return new app.Models.MatchCollection(filtered);
    },

    updateMinutes: function () {
        this.each(function (model) {
            if (model instanceof app.Models.MatchModel && model.getIsLive()) {
                var time = model.get("time");
                var timeValue = time.replace("'", "");
                if (!isNaN(parseFloat(timeValue)) && isFinite(timeValue)) {
                    if (!(parseInt(timeValue) == 45) && !(parseInt(timeValue) == 90)) {
                        model.set("time", (parseInt(timeValue) + 1) + "'");
                    }
                }
            }
        });
    }
});