﻿var app = app || {};

app.Models = app.Models || {};

Backbone.Model.prototype.forward = function (attribute, subModel, options) {
    var self = this; // parent model
    var property = (options && options.property) ?
		options.property : attribute;
    self[property] = subModel; // save the subModel in the specified property
    subModel.set(self.get(attribute)); // add any existing data to the subModel
    self.on("change:" + attribute, function (model, value, options) {
        subModel.set(value, options);
    });

    // Implement here all methods on the child that you need to trigger change
    // events up in the rest of the model tree.
    // 
    // For example, here is how you could implement the "add" function for
    // Backbone.Collection.
    subModel.add = function (model, options) {
        var collection = _.clone(self.get(attribute));
        collection.push(model.attributes);
        self.set(attribute, collection);
    };
};