﻿app.Services.NotificationService = app.Services.NotificationService || {

    changeSubscription: function (callback, notificationItem) {
        var request = { "T": 200, "assetId": notificationItem.assetId, "assetType": notificationItem.assetType, "gameType": 1, "changeType": notificationItem.changeType, "deviceId": Settings.getDeviceId() };
        app.Services.makeRequest(request, app.Services.NotificationService.parseChangeSubscription, callback);
    },

    getSubscribedNotifications: function (callback, isInit) {
        var request = { "T": 211, "deviceId": Settings.getDeviceId(), "init": (isInit ? 1 : 0) };
        app.Services.makeRequest(request, function (data) {
            if (isInit) {
                app.Services.NotificationService.parseSubscriptions(data);
            } else {
                app.Services.NotificationService.parseSubscribedMatchesTeams(data, request, callback);
            }
        }, callback);
    },
    
    sendNotificationCount: function() {
        var request = { "T": 213, "deviceId": Settings.getDeviceId(), "c": Settings.getReadCount() };
        app.Services.makeRequest(request, function(data) {
            if (!data.err) {
                Settings.setCountSentDate();
            }
        });
    },
    
    updateDeviceId: function(newDeviceId) {
        
        var request = { "T": 206, "deviceId": Settings.getDeviceId(), "newDeviceId":newDeviceId};
        app.Services.makeRequest(request, function(data) {
            if (!data.err) {
                Settings.setDeviceId(newDeviceId);
            }
        });
    },
    
    getSubscriptionDetails: function(callback, notItem) {
        var request = { "T": 208, "deviceId": Settings.getDeviceId(), "assetId": notItem.assetId, "assetType": notItem.assetType, "gameType": 1 };
        app.Services.makeRequest(request, app.Services.NotificationService.parseSubscriptionDetails, callback);
    },
    
    updateSubscriptionDetails: function(detail) {
        var request = { "T": 209, "s": detail.subscriptionId, "sl": [{ "e": detail.event, "s": detail.status }] };
        app.Services.makeRequest(request, function(data) {
            console.log("success");
        });
    },

    getNotification: function(callback, headerId) {
        var request = { "T": 214, "deviceId": Settings.getDeviceId(), "id": headerId };
        app.Services.makeRequest(request, function(data) {
            callback(data);
        });
    },
    
    suspendNotifications: function(callback, hour) {
        var request = { "T": 210, "deviceId": Settings.getDeviceId(), "sH": hour };
        app.Services.makeRequest(request, function(data) {
            callback(data);
        });
    },

    parseSubscriptions: function(data) {
        Settings.clearSubscriptions();
        for (var i = 0; i < data.G.length; i++) {
            var subData = data.G[i];
            Settings.addToSubscriptions({ assetId: subData.mI, assetType: 1 });
        }
        
        for (var i = 0; i < data.t.length; i++) {
            var subData = data.t[i];
            Settings.addToSubscriptions({ assetId: subData.tId, assetType: 2 });
        }

        Settings.setSubscriptionRefreshDate();
    },

    parseChangeSubscription: function(data, request, callback) {
        if (data.cT) {
            var notItem = { assetId: request.assetId, assetType: request.assetType };
            if (data.cT == "add") {
                Settings.addToSubscriptions(notItem);
            } else {
                Settings.removeFromSubscriptions(notItem);
            }
            callback(data.cT);
        }
    },
    
    parseSubscribedMatchesTeams: function (data, request, callback) {
        var teamData = data.t || [];
        var matchData = data.G || [];
        Settings.clearFavorites();
        var teams = new Backbone.Collection([], { model: app.Models.TeamModel });
        for (var i = 0; i < teamData.length; i++) {
            var subData = teamData[i];
            var team = new app.Models.TeamModel({
                id: subData.tId,
                name: subData.tAd,
                subscriptionId: subData.subId,
                isSelected: true,
                logo: "http://im.cdn.md/img/logo/75/" + subData.tId + ".png",
            });
            //var notItem = { assetId: team.get("id"), assetType: 2, assetName: team.get("name") };
            //Settings.addToFavorites(notItem);

            teams.add(team);


        }
        var matches = new app.Models.MatchCollection();
        for (var i = 0; i < matchData.length; i++) {
            var subData = matchData[i];
            var match = new app.Models.MatchModel({
                id: subData.mI,
                homeTeam: subData.hT,
                awayTeam: subData.aT,
                homeTeamId: subData.hTId,
                awayTeamId: subData.aTId,
                homeScore: subData.hS,
                awayScore:subData.aS,
                matchState: subData.mS,
                matchDate: subData.mD,
                time: subData.mS == 0 ? DateUtils.getShortDate(subData.mD, true) : subData.gT,
                subscriptionId: subData.subId,
                isFavorite: true,
                isSelected: (subData.assetType && subData.assetType == 1)
            });
            match.set({ isLive: match.getIsLive(), isLiveOrNotStarted: match.getIsLiveOrNotStarted(), isFinished: match.getIsFinished() });
            //var notItem = { assetId: match.get("id"), assetType: 1, value: match.get("id") + "," + match.get("homeTeam") + "," + match.get("awayTeam") + "," + match.get("homeTeamId") + "," + match.get("awayTeamId") + "," + match.get("homeScore") + "," + match.get("awayScore") + "," + match.get("matchState") + "," + match.get("matchDate") + "," + match.get("time") };
            //Settings.addToFavorites(notItem);
            matches.add(match);
        }
        callback(matches, teams, Settings.getFavoriteLeagues());

    },
    
    parseSubscriptionDetails: function(data, request, callback) {
        var subs = [];
        var subscriptionId = data.sub;
        var subModel = Backbone.Model.extend({});
        for (var i = 0; i < data.D.length; i++) {
            var subData = data.D[i];
            var sd = new subModel({
                subType: subData.e,
                isChecked: subData.s == 1,
                name: subData.n
            });

            subs.push(sd);
        }

        callback(subscriptionId, subs);
    }
};




