﻿app.Services.SearchService = app.Services.SearchService || {
    getSearchResults: function (callback, searchText) {
        var request = { "T": 89, "st": searchText };
        app.Services.makeRequest(request, app.Services.SearchService.parseSearchResults, callback);
    },

    parseSearchResults: function (data, request, callback) {
        var searchResults = new Backbone.Collection([], { model: app.Models.SearchResultModel });
        for (var i = 0; i < data.S.length; i++) {
            var searchData = data.S[i];
            if (searchData.aT != 1) {
                var searchResult = new app.Models.SearchResultModel({
                    id: searchData.i,
                    name: searchData.n,
                    searchType: searchData.aT
                });
                if (searchData.aT == 0) {
                    searchResult.set("logo", "http://im.cdn.md/img/logo/75/" + searchResult.get("id") + ".png");
                } else if (searchData.aT == 2) {
                    searchResult.set("logo", "/img/football/" + searchData.gF);
                    searchResult.set("groupId", searchData.gF.replace(".gif", ""));
                }
                searchResults.add(searchResult);
            }
        }

        callback(searchResults);
    }
};