﻿
app.Services.StandingService = app.Services.StandingService || {
    getStandings: function (callback, criteria) {
        var request = { "T": 9, "t": 1, "s": -1, "sT": 0 };
        if (criteria.leagueId) {
            request.l = criteria.leagueId;
            if (criteria.hasStandings == "0") {
                request.hS = 0;
            }
        } else if (criteria.teamId) {
            request.tId = criteria.teamId;
            app.Services.makeRequest(request, app.Services.StandingService.parseTeamStandings, callback);
            return;
        } else if (criteria.matchId) {
            request.m = criteria.matchId;
        }

        app.Services.makeRequest(request, app.Services.StandingService.parseStandings, callback);

    },

    getForm: function (callback, leagueId) {
        var request = { "T": 9, "t": 1, "l": leagueId, "s": -1, "sT": 1 };
        app.Services.makeRequest(request, app.Services.StandingService.parseForm, callback);
    },

    getPlayerStats: function (callback, leagueId) {
        var request = { "T": 73, "sG": leagueId, "s": -1 };
        app.Services.makeRequest(request, app.Services.StandingService.parseStatistics, callback);
    },

    parseStandings: function (data, request, callback) {
        var standings = new Backbone.Collection([], { model: app.Models.StandingModel });

        for (var i = 0; i < data.S.length; i++) {
            var standingData = data.S[i];
            var standing = new app.Models.StandingModel({
                teamRank: i + 1,
                teamName: standingData.n,
                teamId: standingData.i
            });

            standing.set("played", standingData.ph[0] + standingData.pa[0]);
            standing.set("won", standingData.ph[1] + standingData.pa[1]);
            standing.set("draw", standingData.ph[2] + standingData.pa[2]);
            standing.set("lost", standingData.ph[3] + standingData.pa[3]);
            standing.set("average", (standingData.ph[4] + standingData.pa[4]) - (standingData.ph[5] + standingData.pa[5]));
            standing.set("points", standingData.ph[6] + standingData.pa[6]);
            standings.add(standing);
        }


        var fixtures = new app.Models.MatchCollection;
        var results = new app.Models.MatchCollection;
        if (data.F && data.R) {

            for (var i = 0; i < data.F.length; i++) {
                var matchData = data.F[i];
                var match = new app.Models.MatchModel({
                    id: matchData.mI,
                    homeTeam: matchData.hT,
                    awayTeam: matchData.aT,
                    homeScore: 0,
                    awayScore: 0,
                    matchState: 0,
                    time: "v",
                    matchDate: DateUtils.getShortDate(matchData.mD, true),
                    matchResult: matchData.mR
                });
                match.set({ isLive: match.getIsLive(), isLiveOrNotStarted: match.getIsLiveOrNotStarted(), isFinished: match.getIsFinished() });
                match.set("isSelected", Settings.isSubscribed({ assetId: match.get("id"), assetType: 1 }));
                fixtures.add(match);
            }

            for (var i = 0; i < data.R.length; i++) {
                var matchData = data.R[i];
                var match = new app.Models.MatchModel({
                    id: matchData.mI,
                    homeTeam: matchData.hT,
                    awayTeam: matchData.aT,
                    homeScore: matchData.hS,
                    awayScore: matchData.aS,
                    matchState: 4,
                    matchDate: DateUtils.getShortDate(matchData.mD, true),
                    matchResult: matchData.mR
                });
                results.add(match);
            }
        }
        if (request.l) {
            callback(standings, fixtures, results, data.ns, data.n, data.ibl == "1");
        } else if (request.tId) {
            return standings;
        } else if (request.m) {
            callback(standings);
        }
    },

    parseForm: function (data, request, callback) {
        var forms = new Backbone.Collection([], { model: app.Models.StandingModel });
        for (var i = 0; i < data.S.length; i++) {
            var standingData = data.S[i];
            var standing = new app.Models.StandingModel({
                teamRank: i + 1,
                teamName: standingData.n,
                teamId: standingData.i,
                points: standingData.pt[1]
            });
            var last6Games = standingData.pt[2].slice(-6);
            last6Games = (last6Games + "999999").slice(0, 6).split("");
            standing.set("last6Games", last6Games);
            forms.add(standing);
        }

        callback(forms);
    },

    parseStatistics: function (data, request, callback) {
        var playerStats = new Backbone.Collection([], { model: app.Models.PlayerModel });

        for (var i = 0; i < data.PG.length; i++) {
            var playerData = data.PG[i];
            var player = new app.Models.PlayerModel({
                id: playerData.id,
                name: playerData.n,
                averageGoal: playerData.avg,
                matchCount: playerData.mC,
                goalCount: playerData.d
            });
            playerStats.add(player);
        }
        callback(playerStats);
    },

    parseTeamStandings: function (data, request, callback) {
        var leagues = [];
        for (var i = 0; i < data.L.length; i++) {
            var leagueData = data.L[i];
            var league = new app.Models.LeagueModel({
                id: leagueData.i,
                name: leagueData.n,
                groupId: leagueData.g
            });

            league.set("standings", app.Services.StandingService.parseStandings(leagueData, request));
            leagues.push(league);
        }

        callback(leagues);
    }
};