﻿
app.Services.TeamService = app.Services.TeamService || {
    getTeamDetail: function (callback, teamId) {
        var request = { "T": 71, "t": 1, "id": teamId, "s": -1, "k": 1, "sDs":1 };
        app.Services.makeRequest(request, app.Services.TeamService.parseTeamDetail, callback);
    },

    parseTeamDetail: function (data, request, callback) {
        var team = new app.Models.TeamModel({
            id: data.tId,
            name: data.tN,
            seasonName: data.sDN,
            isInBlacklist: data.ibl == 1,
            logo: "http://im.cdn.md/img/logo/75/" + data.tId + ".png"
        });

        var matches = new Backbone.Collection([], { model: app.Models.BaseModel });
        for (var i = 0; i < data.A.length; i++) {

            var matchData = data.A[i];
            var match = new app.Models.MatchModel({
                id: matchData.mId,
                homeTeam: matchData.hN,
                awayTeam: matchData.aN,
                homeScore: matchData.hS,
                awayScore: matchData.aS,
                matchState: matchData.mS,
                leagueId: matchData.mSGId,
                groupId: matchData.mGId,
                leagueName: matchData.mSGN,
                isElimination: matchData.mEl == 1,
                matchDate: DateUtils.getShortDate(matchData.mD),
                time: matchData.mS == 0 ? "v" : "",
                matchResult: matchData.mR,
                isInBlacklist: matchData.ibl == 1
            });
            match.set({ isLive: match.getIsLive(), isLiveOrNotStarted: match.getIsLiveOrNotStarted(), isFinished: match.getIsFinished() });
            match.set("isSelected", Settings.isSubscribed({ assetId: match.get("id"), assetType: 1 }));
            matches.add(match);
        }

        var players = new Backbone.Collection([], { model: app.Models.PlayerModel });
        for (var i = 0; i < data.S.length; i++) {

            var playerData = data.S[i];
            var player = new app.Models.MatchModel({
                id: playerData.id,
                name: playerData.n,
                position: playerData.pN,
                matchCount: playerData.pM,
                goalCount: playerData.pG,
                yellowCount: playerData.pY,
                redCount: playerData.pR,
                shirtNumber: playerData.sN,
                countryFlag: "http://im.cdn.md/img/flags/" + playerData.pC + ".gif"
            });
            players.add(player);
        }

        team.set("matches",matches);
        team.set("squad", players);
        team.set("isSelected", Settings.isSubscribed({ assetId: team.get("id"), assetType: 2}));
        callback(team);
    }
};