﻿var DateUtils = {
    week_days : ['SUNDAY','MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY', 'SATURDAY'],

    getWeekDay: function(date) {
        var index = date.getDay();
        return this.week_days[index];
    },
    
    getDateRangeForMatch: function(today) {
        var dateList = [];
        
        for (var i = -8; i < 9; i++) {
            var tempDate = new Date();
            var dateObj = {};
            tempDate.setDate(today.getDate() + i);
            if (i == 0) {
                dateObj.weekDay = "TODAY";
                dateObj.weekdayIndex = "today";
                dateObj.requestString = "";
            } else {
                dateObj.weekDay = this.getWeekDay(tempDate);
                dateObj.weekdayIndex = tempDate.getDay();
                dateObj.requestString = ("00" + (tempDate.getDate())).slice(-2) + "." + ("00" + (tempDate.getMonth() + 1)).slice(-2) + "." + tempDate.getFullYear();
            }
            dateObj.day = tempDate.getDate();
            
            dateList.push(dateObj);
        }

        return dateList;
    },
    
    getShortDate: function(longDate, returnTimeIfToday) {
        var dateParts = longDate.split(" ");
        var time = "";
        var dates = [];
        if (dateParts.length > 1) {
            time = dateParts[1];
            dates = dateParts[0].split(".");
        } else {
            dates = longDate.split(".");    
        }
        
        if (!returnTimeIfToday) {
            return dates[0] + "/" + dates[1];
        } else {
            var tempDate = new Date();
            if (("00" + (tempDate.getDate())).slice(-2) == dates[0] && ("00" + (tempDate.getMonth() + 1)).slice(-2) == dates[1] && tempDate.getFullYear() == dates[2]) {
                return time;
            } else {
                return dates[0] + "/" + dates[1];
            }
        }
    }
    
    
    

}

