﻿var Notifications = function Notifications() {

    var app,
        notifications = [];

    /*
      Uses the mozApps api to get a reference to the an app
      object representing the current application.
  
      We will use this to build the icon url and as well
      to call the method 'launch' over the application object
      that will bring our application to foreground 
    */
    var getAppReference = function getAppReference(cb) {
        var request = navigator.mozApps.getSelf();
        request.onsuccess = function onApp(evt) {
            cb(evt.target.result);
        };
    };

    /*
      Build the icon full url for this app
    */
    var getAppIcon = function getAppIcon(cb) {
        function buildIconURI(a) {
            var icons = a.manifest.icons;
            return a.installOrigin + icons['60'];
        }

        if (app != null) {
            cb(buildIconURI(app));
            return;
        }

        getAppReference(function onsuccess(a) {
            app = a;
            cb(buildIconURI(app));
        });
    };

    var forgetNotification = function onForget(not) {
        notifications.splice(notifications.indexOf(not), 1);
    };

    // Creates a notification using our app icon and adding some actions when clicking or closing
    var createNotification = function createAdvancedNotification(data) {
        getAppIcon(function onAppIcon(icon) {
            var texts = data.t.split("|");

            var notification = navigator.mozNotification.createNotification(
              texts[0],
              texts[1],
              icon);

            notification.onclick = function onclick() {
                forgetNotification();
                app.launch();
            };

            notification.onclose = function onclose() {
                forgetNotification();
            };

            notification.show();
            notifications.push(notification);
        });
    };

    var notify = function notify(data) {
        
        if (document.hidden) {
            createNotification(data);
        } else {
            var texts = data.t.split("|");
            alert(texts[0] + "\n" + texts[1]);
        }
        // Don't show notification if we are in foreground
    };

    return {
        'notify': notify
    };

}();