﻿var Settings = {
    keys: {
        userId: "userId",
        votes: "votes",
        deviceId: "deviceId",
        subscriptionRefreshDate: "subRefreshDate",
        countSentDate: "countSentDate",
        readCount: "readCount",
        subscriptions: "subscriptions",
        favorites: "favorites",
        language: "language",
        suspend: "suspend"
    },

    getUserId: function() {
        if (!window.localStorage.getItem(this.keys.userId)) {
            this.setUserId();
        }
        return window.localStorage.getItem(this.keys.userId);
    },

    setUserId: function() {
        if (!window.localStorage.getItem(this.keys.userId)) {
            window.localStorage.setItem(this.keys.userId, this.generateUserId());
        }
    },

    generateUserId: function() {
        var userId = "";
        for (var i = 0; i < 10; i++) {
            userId += (Math.floor((Math.random() * 10)) + "");
        }
        return userId;
    },

    getVotedOption: function(matchId) {
        var votesJson = window.localStorage.getItem(this.keys.votes);
        if (votesJson) {
            var votes = JSON.parse(votesJson);
            return votes[matchId];
        }
        return "";
    },

    setVotes: function(matchId, optionId) {
        var votesJson = window.localStorage.getItem(this.keys.votes);
        if (votesJson) {
            var votes = JSON.parse(votesJson);
            votes[matchId] = optionId;
            window.localStorage.setItem(this.keys.votes, JSON.stringify(votes));
        } else {
            var votes = {};
            votes[matchId] = optionId;
            window.localStorage.setItem(this.keys.votes, JSON.stringify(votes));
        }
    },

    getDeviceId: function() {
        return window.localStorage.getItem(this.keys.deviceId);
    },

    setDeviceId: function(deviceId) {
        if (deviceId) {
            window.localStorage.setItem(this.keys.deviceId, deviceId);
        }
    },

    deleteDeviceId: function() {
        delete window.localStorage[this.keys.deviceId];
    },

    shouldRefreshSubscriptions: function() {
        var refreshDate = window.localStorage.getItem(this.keys.subscriptionRefreshDate);
        if (refreshDate) {
            refreshDate = refreshDate * 1;
            var today = new Date();
            today.setHours(0, 0, 0, 0);
            var dayDiff = (today.valueOf() - refreshDate) / (1000 * 60 * 60 * 24);
            return dayDiff > 1;
        } else {
            return true;
        }
    },

    setSubscriptionRefreshDate: function() {
        var today = new Date();
        today.setHours(0, 0, 0, 0);
        window.localStorage.setItem(this.keys.subscriptionRefreshDate, today.valueOf());
    },

    shouldSendReadCount: function() {
        var sentDate = window.localStorage.getItem(this.keys.countSentDate);
        if (sentDate) {
            var count = this.getReadCount();
            sentDate = sentDate * 1;
            var today = new Date();
            if (count > 0) {
                var hourDiff = (today.valueOf() - sentDate) / (1000 * 60 * 60);
                return hourDiff > 1;
            } else {
                var dayDiff = (today.valueOf() - sentDate) / (1000 * 60 * 60 * 24);
                return dayDiff > 1;
            }
        } else {
            return true;
        }
    },

    setCountSentDate: function() {
        var today = new Date();
        window.localStorage.setItem(this.keys.countSentDate, today.valueOf());
        window.localStorage.setItem(this.keys.readCount, 0);
    },

    incrementReadCount: function() {
        var count = window.localStorage.getItem(this.keys.readCount);
        if (count) {
            count = count * 1;
            count++;
            window.localStorage.setItem(this.keys.readCount, count);
        } else {
            window.localStorage.setItem(this.keys.readCount, 1);
        }
    },

    getReadCount: function() {
        var count = window.localStorage.getItem(this.keys.readCount);
        return count || 0;
    },

    isSubscribed: function(notItem) {
        var subscriptionsJson = window.localStorage.getItem(this.keys.subscriptions);
        if (subscriptionsJson) {
            var subscriptions = JSON.parse(subscriptionsJson);
            var key = notItem.assetId + "-" + notItem.assetType;
            var sub = subscriptions[key];
            if (sub) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    },

    addToSubscriptions: function(notItem) {
        var subscriptionsJson = window.localStorage.getItem(this.keys.subscriptions);
        var subscriptions;
        if (subscriptionsJson) {
            subscriptions = JSON.parse(subscriptionsJson);
        } else {
            subscriptions = {};
        }

        var key = notItem.assetId + "-" + notItem.assetType;
        var sub = subscriptions[key];
        if (!sub) {
            subscriptions[key] = notItem.assetId;
        }
        window.localStorage.setItem(this.keys.subscriptions, JSON.stringify(subscriptions));
    },

    removeFromSubscriptions: function(notItem) {
        var subscriptionsJson = window.localStorage.getItem(this.keys.subscriptions);
        var subscriptions;
        if (subscriptionsJson) {
            subscriptions = JSON.parse(subscriptionsJson);
            var key = notItem.assetId + "-" + notItem.assetType;
            var sub = subscriptions[key];
            if (sub) {
                delete subscriptions[key];
            }
            window.localStorage.setItem(this.keys.subscriptions, JSON.stringify(subscriptions));
        }
    },

    clearSubscriptions: function() {
        window.localStorage.setItem(this.keys.subscriptions, JSON.stringify({}));
    },

    isFavorite: function(notItem) {
        var favoritesJson = window.localStorage.getItem(this.keys.favorites);
        if (favoritesJson) {
            var favorites = JSON.parse(favoritesJson);
            var key = notItem.assetId + "-" + notItem.assetType;
            var fav = favorites[key];
            if (fav) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    },

    addToFavorites: function(notItem) {
        var favoritesJson = window.localStorage.getItem(this.keys.favorites);
        var favorites;
        if (favoritesJson) {
            favorites = JSON.parse(favoritesJson);
        } else {
            favorites = {};
        }

        var key = notItem.assetId + "-" + notItem.assetType;
        var fav = favorites[key];
        if (!fav) {
            if (notItem.assetType == 4 || notItem.assetType == 0) {
                favorites[key] = notItem.assetId + "," + notItem.assetName + "," + notItem.groupId;
            } else if (notItem.assetType == 2) {
                favorites[key] = notItem.assetId + "," + notItem.assetName;
            } else if (notItem.assetType == 1) {
                favorites[key] = notItem.value;
            }
        }
        window.localStorage.setItem(this.keys.favorites, JSON.stringify(favorites));
    },

    removeFromFavorites: function(notItem) {
        var favoritesJson = window.localStorage.getItem(this.keys.favorites);
        var favorites;
        if (favoritesJson) {
            favorites = JSON.parse(favoritesJson);
            var key = notItem.assetId + "-" + notItem.assetType;
            var fav = favorites[key];
            if (fav) {
                delete favorites[key];
            }
            window.localStorage.setItem(this.keys.favorites, JSON.stringify(favorites));
        }
    },

    clearFavorites: function() {
        var favoritesJson = window.localStorage.getItem(this.keys.favorites);
        var favorites;
        if (favoritesJson) {
            favorites = JSON.parse(favoritesJson);
            for (var key in favorites) {
                var assetType = key.split("-")[1];
                if (assetType == "1" || assetType == "2") {
                    delete favorites[key];
                }
            }

            window.localStorage.setItem(this.keys.favorites, JSON.stringify(favorites));
        }
    },

    getFavoriteLeagues: function() {
        var favoritesJson = window.localStorage.getItem(this.keys.favorites);
        var favorites;
        var leagues = new Backbone.Collection([], { model: app.Models.LeagueModel });
        if (favoritesJson) {
            favorites = JSON.parse(favoritesJson);

            for (var key in favorites) {
                var assetType = key.split("-")[1];
                if (assetType == "0" || assetType == "4") {
                    var value = favorites[key];
                    var values = value.split(",");
                    var league = new app.Models.LeagueModel({
                        id: values[0],
                        name: values[1],
                        groupId: values[2],
                        isCup: assetType == "0",
                        isSelected: true
                    });
                    leagues.add(league);
                }
            }
        }
        return leagues;
    },

    getLanguage: function() {
        var langJson = window.localStorage.getItem(this.keys.language);
        if (langJson) {
            return JSON.parse(langJson);
        } else {
            var navLang = window.navigator.language;
            var lang = navLang.split("-")[0];
            if (lang == "en" || lang == "es" || lang == "pt") {
                var langObj = { "id": (lang == "en" ? 2 : (lang == "es" ? 3 : 8)), "name": lang };
                this.setLanguage(langObj);
                return langObj;
            }
            return { "id": "2", "name": "en" };
        }
    },
    

    setLanguage: function (langObj) {
        window.localStorage.setItem(this.keys.language, JSON.stringify(langObj));
    },
    
    getSuspend: function() {
        var suspend = window.localStorage.getItem(this.keys.suspend);
        if (suspend) {
            return parseInt(suspend);
        } else {
            return 0;
        }
    },

    setSuspend: function(suspend) {
        window.localStorage.setItem(this.keys.suspend, suspend);
    }
}