﻿var TabUtils = {

    init: function (maxTabs, startTabIndex, speed, tabSwitchedHandler) {
        var self = this;
        app.width = $(document).width();
        app.height = document.body.clientHeight - $("#tab-content").position().top;
        this.numberOfTabs = maxTabs;
        this.currentTab = startTabIndex;
        this.speed = speed;
        this.tapSpeed = speed / 4;
        this.tabs = $("#tabs");
        this.tabHeaderHolder = $("#tab-headers");
        this.tabHeaders = this.tabHeaderHolder.find("li").slice(0,-1);
        this.tabWidth = this.tabHeaders.width();
        this.tabHeaders.off("tap");
        this.tabHeaders.tap(function () {
            var $this = $(this);
            var tabIndex = $this.index();

            TabUtils.currentTab = tabIndex;
            TabUtils.scrollImages(app.width * TabUtils.currentTab, TabUtils.tapSpeed);
            
            self.tabHeaderHolder.find("li.selected").removeClass("selected").find("img").attr("src", function () {
                return this.src.replace(".png", "_dis.png");
            });
            $this.addClass("selected").find("img").attr("src", function () {
                return this.src.replace("_dis", "");
            });
            
            self.tabHeaderHolder.animate({ scrollLeft: (tabIndex * self.tabWidth - (self.tabHeaderHolder.width() - self.tabWidth) / 2) }, 200);
            tabSwitchedHandler(tabIndex);
        });
        
        var swipeOptions =
                {
                    triggerOnTouchEnd: true,
                    swipeStatus: this.swipeStatus,
                    swipe: function (ev, direction) {
                        var tabIndex = TabUtils.currentTab;
                        self.tabHeaderHolder.find("li.selected").removeClass("selected").find("img").attr("src", function () {
                            return this.src.replace(".png", "_dis.png");
                        });
                        self.tabHeaderHolder.find("li:eq(" + tabIndex + ")").addClass("selected").find("img").attr("src", function () {
                            return this.src.replace("_dis", "");
                        });
                        if (direction == "left" && tabIndex > 1) {
                            self.tabHeaderHolder.animate({ scrollLeft: (tabIndex * self.tabWidth - (self.tabHeaderHolder.width() - self.tabWidth) / 2) }, 200);
                        } else if (direction == "right" && TabUtils.numberOfTabs - tabIndex - 1 > 1) {
                            self.tabHeaderHolder.animate({ scrollLeft: (tabIndex * self.tabWidth - (self.tabHeaderHolder.width() - self.tabWidth) / 2) }, 200);
                        }
                        tabSwitchedHandler(tabIndex);
                    },
                    allowPageScroll: "vertical"
                };
        this.tabHeaderHolder.find("ul").css("width", this.tabWidth * this.numberOfTabs + "px");
        this.tabs.find(">div").slice(0,-1).css({ "width": app.width + "px", "height": app.height + "px", "overflow":"scroll"});
        this.tabs.css("width", (app.width * this.tabs.find("div").length) + "px");
        this.tabs.swipe(swipeOptions);
    },

    swipeStatus: function (event, phase, direction, distance) {
        var threshold = 75;
        if (phase == "move" && (direction == "left" || direction == "right")) {
            var duration = 0;

            if (direction == "left" && TabUtils.currentTab != TabUtils.numberOfTabs - 1)
                TabUtils.scrollImages((app.width * TabUtils.currentTab) + distance, duration);

            else if (direction == "right" && TabUtils.currentTab != 0)
                TabUtils.scrollImages((app.width * TabUtils.currentTab) - distance, duration);

        }

        else if (phase == "cancel") {
            TabUtils.scrollImages(app.width * TabUtils.currentTab, TabUtils.speed);
        }

        else if (phase == "end") {
            if (direction == "right") {
                if (distance >= threshold) {
                    TabUtils.previousTab();
                } else {
                    TabUtils.scrollImages(app.width * TabUtils.currentTab, TabUtils.speed);
                }
            }

            else if (direction == "left") {
                if (distance >= threshold) {
                    TabUtils.nextTab();
                } else {
                    TabUtils.scrollImages(app.width * TabUtils.currentTab, TabUtils.speed);
                }
            }
        }
    },

    previousTab: function () {
        TabUtils.currentTab = Math.max(TabUtils.currentTab - 1, 0);
        TabUtils.scrollImages(app.width * TabUtils.currentTab, TabUtils.speed);
    },

    nextTab: function () {
        TabUtils.currentTab = Math.min(TabUtils.currentTab + 1, TabUtils.numberOfTabs - 1);
        TabUtils.scrollImages(app.width * TabUtils.currentTab, TabUtils.speed);
    },

    scrollImages: function (distance, duration) {
        TabUtils.tabs.css("transition-duration", (duration / 1000).toFixed(1) + "s");
        var value = (distance < 0 ? "" : "-") + Math.abs(distance).toString();
        TabUtils.tabs.css("transform", "translate3d(" + value + "px,0px,0px)");
    }

}