﻿var app = app || {};
app.LeagueHeaderView = Backbone.View.extend({
    tagName: "tr",
    className: "league-header",
    initialize: function () {
        this.listenTo(this.model, "change", this.render);
        Handlebars.registerHelper('flagFinder', function () {
            if (this.groupId) {
                var imageUrl = "/img/football/" + this.groupId + ".gif";
                if (this.type && this.type == 2) {
                    imageUrl = "/img/football/0.gif";
                }
                return imageUrl;
            } else {
                return "";
            }

        });
    },

    events: {
        "tap td:not(.favorite)": "navigateTo",
        "tap td.favorite": "subscribe"
    },

    navigateTo: function () {
        
        if (app.Models.GroupModel && this.model instanceof app.Models.GroupModel) {
            console.log("nav: " + this.model.attributes);
            if (this.model.get("type") == 2) {
                window.location.href = "/competitions.html?continentId=" + this.model.get("groupId");
            } else {
                window.location.href = "/competitions.html?groupId=" + this.model.get("groupId") + "&groupName=" + this.model.get("name");
            }
        } else if (app.Models.LeagueModel && this.model instanceof app.Models.LeagueModel && !this.model.get("isElimination") && this.model.get("id")) {
            console.log("nav: " + this.model.attributes);
            if (!this.model.get("isCup")) {
                var url = "/standings.html?leagueId=" + this.model.get("id");
                if (this.model.get("groupId")) {
                    url += "&groupId=" + this.model.get("groupId");
                } else if (this.model.get("group")) {
                    url += "&groupId=" + this.model.get("group");
                }
                url += (this.model.get("hasStandings") == false ? "&hasStandings=0" : "");
                window.location.href = url;
            } else {
                var url = "/competitions.html?cupId=" + this.model.get("id") + "&cupName=" + this.model.get("name") + "&groupId=" + (this.model.get("groupId") || this.model.get("group"));
                window.location.href = url;
            }

        }
    },

    subscribe: function (e) {
        e.preventDefault();
        var notItem = { assetId: this.model.get("id"), assetType: this.model.get("isCup") ? 0 : 4, assetName: this.model.get("name") };
        
        if (this.model.get("group")) {
            notItem.groupId = this.model.get("group");
        } else if (this.model.get("groupId")) {
            notItem.groupId = this.model.get("groupId");
        }
        if (Settings.isFavorite(notItem)) {
            console.log("remove: " + JSON.stringify(notItem));
            this.model.set("isSelected", false);
            Settings.removeFromFavorites(notItem);
        } else {
            console.log("add: " + JSON.stringify(notItem));
            this.model.set("isSelected", true);
            Settings.addToFavorites(notItem);
        }
    },

    render: function (isHeader, colCount) {
        var template;
        if (app.Models.GroupModel && this.model instanceof app.Models.GroupModel) {
            template = Handlebars.templates.group;
        } else if (app.Models.LeagueModel && this.model instanceof app.Models.LeagueModel) {
            template = isHeader == true ? Handlebars.templates.leagueHeader : Handlebars.templates.league;
        }
        this.$el.html(template(this.model.toJSON()));
        if (colCount) {
            this.$el.find("td").attr("colspan", colCount);
        }
        if (isHeader == true && this.model.get("isFavorite")) {
            this.$el.addClass("favorite");
            this.$el.find("img").css("visibility", "hidden");
        }
        return this;
    }
});
