﻿var app = app || {};
app.MatchView = Backbone.View.extend({
    tagName: "tr",
    className: "match",
    isForm: false,
    initialize: function () {
        this.listenTo(this.model, "change", function () { this.render(this.isForm); });
        Handlebars.registerHelper('scoreString', function () {
            if (this.matchState == 0) {
                return this.time;
            }else if (this.matchState == 9) {
                return "P - P";
            }
            return this.homeScore + " - " + this.awayScore;
        });

        Handlebars.registerHelper('timeString', function () {
            if (this.matchState != 0) {
                return this.time;
            }
            return undefined;
        });

        Handlebars.registerHelper('scoreColor', function () {
            if (this.isLive) {
                return "#F18216";
            }
            return "#FFF";
        });

        Handlebars.registerHelper('minColor', function () {
            if (this.isLive) {
                return "#FFF";
            }
            return "#666";
        });

        Handlebars.registerHelper('matchResultClass', function () {
            switch (this.matchResult) {
                case 0:
                    return "draw";
                case 1:
                    return "won";
                case 2:
                    return "lost";
                default:
                    return "";
            }

        });

        Handlebars.registerHelper('matchResultString', function () {
            switch (this.matchResult) {
                case 0:
                    return "D";
                case 1:
                    return "W";
                case 2:
                    return "L";
                default:
                    return "";
            }
        });
        
        Handlebars.registerHelper('matchResultLocalize', function () {
            switch (this.matchResult) {
                case 0:
                    return "standing.draw";
                case 1:
                    return "standing.won";
                case 2:
                    return "standing.lost";
                default:
                    return "";
            }
        });
    },

    events: {
        "tap td:not(:last)": "navigateTo",
        "tap td:last": "subscribe"
    },

    navigateTo: function () {
        window.location.href = "/match-detail.html?matchId=" + this.model.get("id");
    },

    subscribe: function () {
        var self = this;
        app.Services.NotificationService.changeSubscription(function (changeType) {
            self.model.set("isSelected", changeType == "add");
        }, { assetId: this.model.get("id"), assetType:"1", changeType: this.model.get("isSelected") ? "delete" : "add"});
    },
    render: function (isForm) {
        this.isForm = isForm == true;
        var template = isForm == true ? Handlebars.templates.matchForm : Handlebars.templates.match;
        this.$el.html(template(this.model.toJSON()));
        this.$el.attr("id", "match_" + this.model.get("id"));
        if (!isForm && this.model.get("isFavorite")) {
            this.$el.addClass("favorite");
        }
        return this;
    }
});