﻿var app = app || {};

app.SearchResultsView = Backbone.View.extend({

    initialize: function () {
        var self = this;
        $("#menu").mmenu({ position: "right" }, {});
        $("#txt-search").on('input', function () {
            var text = $(this).val();
            if (text.length > 2 || text.length == 0) {
                app.Services.SearchService.getSearchResults(function (searchResults) {
                    self.collection = searchResults;
                    self.render();
                }, text);
            }
        });
        app.Services.SearchService.getSearchResults(function (searchResults) {
            self.collection = searchResults;
            self.render();
        }, "");
    },
    render: function () {
        var searchHolder = $("#search-list");
        searchHolder.html("");
        for (var i = 0; i < this.collection.length; i++) {
            var item = this.collection.at(i);
            var search = new app.SearchView({ model: item });
            searchHolder.append(search.render().el);
        }
    },
});



