﻿var app = app || {};

app.SettingsView = Backbone.View.extend({

    initialize: function () {
        var self = this;
        $("#menu").mmenu({ position: "right" }, {});
        var request = navigator.mozApps.getSelf();
        request.onsuccess = function (evt) {
            $("#version").text(evt.target.result.manifest.version);
        };
        var currentLanguage = Settings.getLanguage();
        var suspendDate = Settings.getSuspend();
        var now = new Date();
        if (suspendDate > 0) {
            if (now.getTime() > suspendDate) {
                $("#mute-options").val("-1");
            } else {
                $("#mute-options").hide();
                var tempDate = new Date();
                tempDate.setTime(suspendDate);
                var hr = tempDate.getHours();
                var min = tempDate.getMinutes();
                if (localizationOptions.language == "en") {
                    $("#cancel-mute").text("Muted until " + hr + ":" + min + ". Click to cancel mute.");
                }
                $("#cancel-mute").show();
            }
        }
        var optionId = currentLanguage.id + "_" + currentLanguage.name;
        $("#language-options").val(optionId);

        $("#language-options").change(function () {
            var lang = $(this).val();
            var langId = lang.split("_")[0];
            var langName = lang.split("_")[1];
            Settings.setLanguage({ id: langId, name: langName });
            if (langName == "en") {
                window.location.reload();
            } else {
                localizationOptions.language = Settings.getLanguage().name;
                $("[data-localize]").localize("lang", localizationOptions);
            }
        });

        $("#mute-options").change(function () {
            var muteSelect = $(this);
            var muteHr = parseInt(muteSelect.val());
            if (muteHr != -1) {
                app.Services.NotificationService.suspendNotifications(function (data) {
                    var now = new Date();
                    var tempDate = new Date();
                    tempDate.setHours(now.getHours() + muteHr);
                    var hr = tempDate.getHours();
                    Settings.setSuspend(tempDate.getTime());
                    muteSelect.hide();
                    if (localizationOptions.language == "en") {
                        $("#cancel-mute").text("Muted until " + hr + ":" + now.getMinutes() + ". Click to cancel mute.");
                    }
                    $("#cancel-mute").show();
                }, muteHr);
            }
        });

        $("#cancel-mute").tap(function () {
            var muteSelect = $("#mute-options");
            var cancel = $(this);
            app.Services.NotificationService.suspendNotifications(function (data) {
                Settings.setSuspend(0);
                cancel.hide();
                muteSelect.val("-1");
                muteSelect.show();
            }, 0);
        });
    }

});



