﻿var app = app || {};
app.StandingView = Backbone.View.extend({
    tagName: "tr",

    initialize: function() {
        Handlebars.registerHelper('formClass', function (formstate) {
            switch (formstate) {
                case "0":
                    return "draw";
                case "1":
                    return "won";
                case "2":
                    return "lost";
                default:
                    return "";
            }

        });

        Handlebars.registerHelper('formString', function (formstate) {
            switch (formstate) {
                case "0":
                    return "D";
                case "1":
                    return "W";
                case "2":
                    return "L";
                default:
                    return "";
            }
        });
        
        Handlebars.registerHelper('formLocalize', function (formstate) {
            switch (formstate) {
                case "0":
                    return "standing.draw";
                case "1":
                    return "standing.won";
                case "2":
                    return "standing.lost";
                default:
                    return "";
            }
        });
    },
    events: {
        "tap": 'navigateTo'
    },

    navigateTo: function () {
        window.location.href = "/team-detail.html?teamId=" + this.model.get("teamId");
    },

    render: function (isForm) {
        var template = isForm ? Handlebars.templates.form : Handlebars.templates.standing;
        this.$el.html(template(this.model.toJSON()));
        return this;
    }
});
