﻿var app = app || {};

app.StandingsView = Backbone.View.extend({
    initialize: function (criteria) {
        var self = this;
        self.criteria = criteria;

        $("#menu").mmenu({ position: "right" }, {});
        $("#back").tap(function () {
            window.history.back();
        });

        if (criteria.hasStandings == "0") {
            $("#tab-headers,#tab-standings,#tab-stats,#tab-form").hide();
            $("#content").css("margin-top", "80px");
            TabUtils.init(1, 0, 500, self.tabHandler);
        } else {
            TabUtils.init(4, 0, 500, self.tabHandler);
        }




        app.Services.StandingService.getStandings(function (standings, fixtures, results, leagueName, seasonName, isInBlacklist) {
            if (!isInBlacklist) {
                var notItem = { assetId: criteria.leagueId, assetType: 4, assetName: leagueName, groupId: criteria.groupId };
                $("#favorite img").attr("src", Settings.isFavorite(notItem) ? "/img/ic_star_top_selected.png" : "/img/ic_star_top.png");
                $("#favorite").tap(function () {
                    if (Settings.isFavorite(notItem)) {
                        Settings.removeFromFavorites(notItem);
                        $("#favorite img").attr("src", "/img/ic_star_top.png");
                    } else {
                        Settings.addToFavorites(notItem);
                        $("#favorite img").attr("src", "/img/ic_star_top_selected.png");
                    }
                });
                $("#favorite").show();
            } else {
                $("#favorite").hide();
            }
            self.collection = standings;
            self.render(fixtures, results);
            $("#league-header .flag img").attr("src", "/img/football/" + criteria.groupId + ".gif");
            $("#league-header .league-name").text(leagueName);
            $("#league-header .season").text(seasonName);
        }, criteria);
    },

    tabHandler: function (tabIndex) {
        switch (tabIndex) {
            case 2:
                if (!$("#tab-stats").attr("loaded")) {
                    app.CurrentView.showStats();
                }
                break;
            case 3:
                if (!$("#tab-form").attr("loaded")) {
                    app.CurrentView.showForm();
                }
                break;
        }
    },

    render: function (fixtures, results) {
        var standingHolder = $("#standing-list");
        for (var i = 0; i < this.collection.length; i++) {
            var standing = this.collection.at(i);
            var standingView = new app.StandingView({ model: standing });
            standingHolder.append(standingView.render().el);
        }

        var fixtureHolder = $("#fixture-list");
        for (var i = 0; i < fixtures.length; i++) {
            var fixture = fixtures.at(i);
            var matchView = new app.MatchView({ model: fixture });
            fixtureHolder.append(matchView.render(true).el);
        }

        var resultHolder = $("#result-list");
        for (var i = 0; i < results.length; i++) {
            var result = results.at(i);
            var matchView = new app.MatchView({ model: result });
            resultHolder.append(matchView.render(true).el);
        }

        $("[data-dynamic='true']").localize("lang", localizationOptions);
        return this;
    },

    showStats: function () {
        var self = this;
        app.Services.StandingService.getPlayerStats(function (playerStats) {
            $("#tab-stats").attr("loaded", true);
            var playerStatsHolder = $("#player-stat-list");
            for (var i = 0; i < playerStats.length; i++) {
                var player = playerStats.at(i);
                playerStatsHolder.append(Handlebars.templates.playerStat(player.toJSON()));
            }
        }, self.criteria.leagueId);
    },

    showForm: function () {
        var self = this;
        app.Services.StandingService.getForm(function (forms) {
            $("#tab-form").attr("loaded", true);
            var formHolder = $("#form-list");
            for (var i = 0; i < forms.length; i++) {
                var form = forms.at(i);
                var standingView = new app.StandingView({ model: form });
                formHolder.append(standingView.render(true).el);
            }

        }, self.criteria.leagueId);
    }
});




