﻿var app = app || {};
app.SubscriptionDetailView = Backbone.View.extend({
    tagName: "tr",
   
    initialize: function () {
        this.listenTo(this.model, "change", this.render);
    },

    events: {
        "change input": "change"
    },

    change: function () {
        var isChecked = this.model.get("isChecked");
        this.model.set("isChecked", !isChecked);
        var detail = { "event": this.model.get("subType"), "status": this.model.get("isChecked") ? 1 : 0 };
        app.CurrentView.updateAlerts(detail);
    },
    
    render: function () {
        var template = Handlebars.templates.subDetail;
        this.$el.html(template(this.model.toJSON()));
        return this;
    }
});