﻿var app = app || {};
app.SurveyView = Backbone.View.extend({
    el:"#option-list",
    initialize: function () {
        this.listenTo(this.model, "change", this.render);
        Handlebars.registerHelper('voteImage', function (optionIndex) {
            if (this.isVotable) {
                return "vote_btn.png";
            } else {
                
                var option = this.options[optionIndex];
                if (option.isSelected) {
                    return "vote_btn_sel.png";
                } else {
                    return "vote_btn_dis.png";
                }
            }
        });
    },
    render: function (isForm) {
        var template = Handlebars.templates.survey;
        this.$el.html(template(this.model.toJSON()));
        return this;
    }
});