﻿var app = app || {};
app.TeamView = Backbone.View.extend({
    tagName: "tr",
    className: "team-header",
    initialize: function() {
        this.listenTo(this.model, "change", this.render);
    },
    events: {
        "tap td:not(.favorite)": "navigateTo",
        "tap td.favorite": "subscribe"
    },

    navigateTo: function () {
        var url = "/team-detail.html?teamId=" + this.model.get("id");
        window.location.href = url;
    },


    subscribe: function () {
        var self = this;
        var notItem = { assetId: this.model.get("id"), assetType: 2, assetName: this.model.get("name"), changeType: this.model.get("isSelected") ? "delete" : "add" };
        app.Services.NotificationService.changeSubscription(function (changeType) {
            self.model.set("isSelected", changeType == "add");
            if (Settings.isFavorite(notItem)) {
                this.model.set("isSelected", false);
                Settings.removeFromFavorites(notItem);
            } else {
                this.model.set("isSelected", true);
                Settings.addToFavorites(notItem);
            }
        }, notItem);
        
    },

    render: function () {
        this.$el.html(Handlebars.templates.team(this.model.toJSON()));
        return this;
    }
});
