﻿Handlebars.registerHelper('ifCond', function (v1, operator, v2, options) {
    switch (operator) {
        case '==':
            return (v1 == v2) ? options.fn(this) : options.inverse(this);
        case '===':
            return (v1 === v2) ? options.fn(this) : options.inverse(this);
        case '<':
            return (v1 < v2) ? options.fn(this) : options.inverse(this);
        case '<=':
            return (v1 <= v2) ? options.fn(this) : options.inverse(this);
        case '>':
            return (v1 > v2) ? options.fn(this) : options.inverse(this);
        case '>=':
            return (v1 >= v2) ? options.fn(this) : options.inverse(this);
        case '&&':
            return (v1 && v2) ? options.fn(this) : options.inverse(this);
        case '||':
            return (v1 || v2) ? options.fn(this) : options.inverse(this);
        default:
            return options.inverse(this);
    }
});


Handlebars.registerHelper('eventImage', function (eventType, isJoined) {
    var eventImage = "/img/";

    switch (eventType) {
        case 1:
            eventImage += "ic_card_yellow.png";
            break;
        case 2:
            eventImage += "ic_card_red.png";
            break;
        case 3:
            eventImage += "ic_card_yellow_red.png";
            break;
        case 4:
            eventImage += "ic_ball.png";
            break;
        case 5:
            eventImage += (isJoined ? "player_subs_ico.png" : "entry_player.png");
            break;
        case 6:
            eventImage += "out_player.png";
            break;
    }

    return eventImage;    
});

Handlebars.registerHelper('scoreColor', function () {
    if (this.isLive) {
        return "#F18216";
    }
    return "#FFF";
});
