var importedPackages = ["keosu-jeu","keosu-base","angularJs","jQuery","keosu-push"];
var app = angular.module('keosuApp', ['angular-chrono', 'angularSpinner','angular-carousel','ngSanitize', 'ngTouch', 'ngRoute','angular-inview','LocalStorageModule','CacheManagerModule']);

app.controller('main_Controller', function($http, $scope) {
		$http.get('data/globalParam.json').success( function (data) {
			$scope.appName = data.name;
		});
});

// Don't forget to take a look at exportListener.php before edit this file
app.directive('keosuPush', function(){
	return {
		restrict : 'E',
		templateUrl : 'plugins/keosu-push/templates/default.html',
		controller : ['$scope','$http', function ($scope, $http) {

			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";

			$scope.init = function() {
				console.log('function init');
				document.addEventListener('deviceready', function() {
					console.log('i\'m ready');
					// if push notification is enabled
					pushNotification = window.plugins.pushNotification;
					if(typeof(device) != 'undefined' && typeof(pushNotificationData) != 'undefined') {
						$http.get('data/globalParam.json').success(function(data) {
							$scope.host = data.host;
							if(device.platform == 'android' || device.platform == 'Android' || device.platform == "amazon-fireos") {
								$scope.androidPush();
							} else {
								$scope.applePush();
							}
						});
					}
				},false);
			};

			////////////////////////
			// Android part
			////////////////////////
			$scope.androidPush = function() {
				appAndroid = {
					successHandler: function(result) {
						console.log("Push success : "+result);
					},
					errorHandler: function(error) {
						console.log("Push error : "+error);
					},
					onNotification: function(e) {
						switch( e.event ) {
							case 'registered':
							if ( e.regid.length > 0 ) {
								$http.post($scope.host+'service/push/plugin/addDevice/2','token='+e.regid);
							}
							break;

							case 'message':
							// this is the actual push notification. its format depends on the data model from the push server
							console.log('message = '+e.message+' msgcnt = '+e.msgcnt);
							break;

							case 'error':
							console.log('GCM error = '+e.msg);
							break;

							default:
							console.log('An unknown GCM event has occurred');
							break;
						}
					}
				};

				pushNotification.register(
					appAndroid.successHandler,
					appAndroid.errorHandler,
					{'senderID':pushNotificationData.senderID+"",'ecb': "appAndroid.onNotification" }
				);
			};
		
			/////////////////////
			// Apple part
			/////////////////////
			$scope.applePush = function() {
				console.log('I\'m an Iphone...');
				appPushNotification = {
					tokenHandler: function(result) {
						console.log('iphone id');
						console.log(result);
						if( result.length > 0 ) {
							$http.post($scope.host+'service/push/plugin/addDevice/1','token='+result);
						}
					},
					errorHandler: function(error){console.log('the eoor is '+error)},
					onNotificationAPN: function(event) {
						if( event.alert )
							navigator.notification.alert(event.alert);
						if( event.sound ) {
							var snd = new Media(event.sound);
							snd.play();
						}
						if( event.badge )
							pushNotification.setApplicationIconBadgeNumber(successHandler, errorHandler, event.badge);
					}
				};

				pushNotification.register(
					appPushNotification.tokenHandler,
					appPushNotification.errorHandler,
					{
						'badge' : 'true',
						'sound' : 'true',
						'alert' : 'true',
						'ecb'   : 'appPushNotification.onNotificationAPN'
					}
				);
			};

		}]
	};
});


app.config(function($routeProvider,$locationProvider){
	$routeProvider.when("/Page/:pageName",{
		templateUrl: function(params) {
			return params.pageName+".html";
		}
	})
	.otherwise({redirectTo:"/Page/1"});
});/************************************************************************
	Keosu is an open source CMS for mobile app
	Copyright (C) 2014  Vincent Le Borgne

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ************************************************************************/
app.controller('keosu-jeuController', function ($scope, $http,$window,$interval, $sce,localStorageService, usSpinnerService, cacheManagerService) {

	$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";

	/////////////////////////
	// Init part
	/////////////////////////
	$scope.init = function(params){
		$scope.param = params;

		$scope.width = 5;
		$scope.height = 8;
		$scope.minCell = 1;
		$scope.maxCell = 11;
		$scope.screenWidth=$window.innerWidth;
		$scope.cellWidth = ($window.innerWidth*0.8)/$scope.width;
		$scope.tableWidth = ($scope.cellWidth+2)*$scope.width;

		$scope.jeuInit();
		$scope.bestscore = localStorageService.get("bestlevel");
		if($scope.bestscore==null)
			$scope.bestscore = 0;
		$scope.isFinish=false;

		$scope.showGame = false;
		$scope.showTuto=true;
		if(localStorageService.get("newtutoDone")==null){
			$scope.routing('tuto');
			$scope.showGame = false;
			$scope.showTuto=true;
		}else{
			$scope.routing('game');
		}

	};

	$scope.routing = function(page){
		$scope.showGame = false;
		$scope.showTuto=false;
		$scope.showTuto2=false;
		$scope.showTuto3=false;
		$scope.showTuto4=false;

		if(page=='tuto'){
			$scope.showTuto=true;
		}else if(page=='tuto2'){
			$scope.showTuto2=true;
		}else if(page=='tuto3'){
			$scope.showTuto3=true;
		}else if(page=='tuto4'){
			$scope.showTuto4=true;
		}else if(page=='game'){
			$scope.showGame = true;
		}else{
			$scope.showGame = true;
		}

	}
	
	/////////////////////////
	// Init part
	/////////////////////////
	$scope.jeuInit = function() {
		$scope.score=0;
		$scope.level=1;
		//create a array
		$scope.table = new Array($scope.height);
		for (var i = 0; i < $scope.height; i++) {
			$scope.table[i] = new Array($scope.width);
		}
		for (var i = 0; i < $scope.height; i++) {
			for (var j = 0; j < $scope.width; j++) {
				$scope.generateNewCell();
				$scope.table[i][j] = 0;
			}
		}
		$scope.generateNewCell();
	};
	$scope.generateNewCell= function(){
		var max = $scope.level;
		if($scope.level == 1){
			max = 2;
		}
		if(max >= $scope.maxCell){
			max = $scope.maxCell;
		}
		console.log("max "+max);
		$scope.curCellValue = Math.round(Math.random() * (max - $scope.minCell) + $scope.minCell);
	}
	$scope.pushBlock = function(index){
		for (var i = ($scope.height-1); i >=0; i--) {
			if($scope.table[i][index]==0){
				$scope.table[i][index]=$scope.curCellValue;
				$scope.checkAssemble(index,i,$scope.curCellValue);
				$scope.checkLine();
				$scope.generateNewCell();
				break;
			}
		}
		$scope.checkFinich();
	}
	$scope.checkAssemble= function(x,y,value){
		if(value<$scope.maxCell){
			if(x>=0 && x < $scope.width && y>=0 && y< $scope.height){
				if(y+1>=0 && y+1 <$scope.height && y+2>=0 && y+2 <$scope.height){
					if($scope.table[y+1][x]==value && $scope.table[y+2][x]==value){
						$scope.table[y][x]=0;
						$scope.table[y+1][x]=0;
						$scope.table[y+2][x]+=1;
						$scope.score+=$scope.table[y+2][x]*50;
						$scope.checkAssemble(x,y+2,$scope.table[y+2][x]);
					}
				}
			}
		}
	}
	$scope.checkLine=function(){
		for (var i = 0; i < $scope.height; i++) {
			isLine = true;
			firstVal = $scope.table[i][0];
			for (var j = 0; j < $scope.width; j++) {
				if($scope.table[i][j] != firstVal || firstVal==0){
					isLine=false;
				}
			}
			if(isLine){
				$scope.removeLine(i);
				if(firstVal>$scope.level){
					$scope.updateScore();
				}
			}
		}
	}
	$scope.updateScore = function(){
		$scope.level+=1;
		if($scope.level>$scope.bestscore){
			localStorageService.set("bestlevel",$scope.level);
			$scope.bestscore = $scope.level;
		}
		//Animate score
		$scope.flashclass = "flashscore";
		$interval(function() {
			$scope.flashclass = "";
		}, 200);
	}
	$scope.removeLine=function(line){
		$scope.score+=1000;
		for (var i = line; i >= 0; i--) {
			for (var j = 0; j < $scope.width; j++) {
				if(i==0){
					$scope.table[i][j]=0;
				}else{
					$scope.table[i][j]=$scope.table[i-1][j];
				}
			}
		}
	}
	$scope.checkFinich=function(){
		var isFinish = true;
		for (var j = 0; j < $scope.width; j++) {
			if($scope.table[0][j] == 0){
				isFinish=false;
			}
		}
		if(isFinish){
			localStorageService.set("bestlevel",$scope.level);
			$scope.isFinish=true;
			$scope.showGame=false;
		}
	}
	$scope.restart=function(){
		localStorageService.set("bestlevel",$scope.level);
		$scope.init();
	}
	$scope.closeTuto = function(){
		localStorageService.set("newtutoDone",true);
		$scope.routing('game');
	}
	$scope.share = function(){
		window.plugins.socialsharing.share("J'ai atteint le level "+$scope.bestscore+" sur #Gommette", null, null, 'https://play.google.com/store/apps/details?id=com.keosu.demo&referrer=utm_source%3DAndroidPIT%26utm_medium%3DAndroidPIT%26utm_campaign%3DAndroidPIT');
	}
	
});
