// wiecej niz 5
var who = 0;
var size = 20;
var game = new Array(15);
var action;

create_tab();

var request = navigator.mozApps.install("http://gomoku.michalpb1.pl/manifest.webapp");
	request.onsuccess = function() {
	};
	request.onerror = function() {
	}

window.onload = function() {
	canvas = document.getElementById('canvas');
	ctx = canvas.getContext('2d');
	draw_bg(); 
	draw_menu();
}

function init_game() {
	canvas.onclick = function(e) { klik(e); };
	canvas.setAttribute('width', 15*size);
	canvas.setAttribute('height', 15*size);
	for(var i = size; i <= canvas.width; i += size) {
		ctx.beginPath();
		ctx.moveTo(i, 0);
		ctx.lineTo(i, canvas.height);
		ctx.stroke();
	}
	for(var i = size; i <= canvas.height; i += size) {
		ctx.beginPath();
		ctx.moveTo(0, i);
		ctx.lineTo(canvas.width, i);
		ctx.stroke();
	}
}

function draw_bg() {
	canvas.setAttribute('width', window.innerWidth);
	canvas.setAttribute('height', window.innerHeight);
	ctx.fillStyle = '#FD8720';
	ctx.rect(0, 0, canvas.width, canvas.height);
	ctx.fill();
}

function draw_menu() {
	canvas.onclick = function(e) { if(e.pageY < 200 && e.pageY > 170) { draw_bg(); init_game(); }
									else if (e.pageY < 250 && e.pageY > 220) { draw_bg(); about_game();}};
	ctx.font = 'bold 60px Calibri';
	ctx.textAlign = 'center';
	ctx.fillStyle = 'black';
	ctx.fillText('Gomoku', canvas.width / 2, 100);
	ctx.font = 'bold 30px Calibri';
	ctx.textAlign = 'center';
	ctx.fillStyle = 'black';
	ctx.fillText('New game', canvas.width / 2, 200);
	ctx.fillText('About', canvas.width / 2, 250);
}

function about_game() {
	ctx.font = 'bold 60px Calibri';
	ctx.textAlign = 'center';
	ctx.fillStyle = 'black';
	ctx.fillText('About', canvas.width / 2, 100);
	ctx.font = 'bold 20px Calibri';
	ctx.textAlign = 'center';
	ctx.fillStyle = 'black';
	//var text = 'Gomoku is an abstract strategy board game. Also called Gobang or Five in a Row. Black plays first, and players alternate in placing a stone of their color on an empty intersection. The winner is the first player to get an unbroken row of five stones horizontally, vertically, or diagonally.';
	ctx.fillText('You must have 5 in row to WIN.', canvas.width / 2, 200);
}

function create_tab() {
	for(var i = 0; i < 15; i++) {
		var tab = [];
		for(var j = 0; j < 15; j++) {
			tab.push('x');
		}
		game[i] = tab;
	}
}

function klik(event) {
	var x = event.pageX/size;
	var y = event.pageY/size;
	var x1 = Math.floor((parseInt(x)*size < event.pageX) ? x++ : x);
	var y1 = Math.floor((parseInt(y)*size < event.pageY) ? y++ : y);
	if(game[y1][x1] === 'x') {
		circle(x1+1, y1+1, who);
		game[y1][x1] = who;
		spr(x1, y1, who);
		if(who == 1) who = 0;
		else who = 1;
	}
}

function circle(x, y, col) {
	ctx.beginPath();
	ctx.moveTo((x*size)-(size/2), (y*size)-(size/2));
	ctx.arc((x*size)-(size/2), (y*size)-(size/2), (size/2)-1, 2*Math.PI, 0, false);
	ctx.fillStyle = (col == 0) ? 'white' : 'black';
	ctx.fill();
	ctx.closePath();
}

function spr(x, y, color) {
	check_row(y, color);
	check_col(x, color);
	check_slant(x, y, color);
}

function check_row(y, color) {
	for(var j = 0, q = 0; j < 15; j++) {
		if(q == 5) { alert('Player ' + color + ' is WINNER'); draw_bg(); draw_menu(); create_tab(); break; }
		if(game[y][j] == color) q++;
		else q = 0;
	}
}

function check_col(x, color) {
	for(var j = 0, q = 0; j < 15; j++) {
		if(q == 5) { alert('Player ' + color + ' is WINNER'); draw_bg(); draw_menu(); create_tab(); break; }
		if(game[j][x] == color) q++;
		else q = 0;
	}
}

function check_slant(x, y, color) {
	for(var i = 0, q = 0; i <= 5; i++) {
		if(q == 5) { alert('Player ' + color + ' is WINNER'); draw_bg(); draw_menu(); create_tab(); break; }
		if((y-i) >= 0) {
			if(game[y-i][x+i] == color) q++; 
			else break;
		}
	}
	for(var i = 0, q = 0; i <= 5; i++) {
		if(q == 5) { alert('Player ' + color + ' is WINNER'); draw_bg(); draw_menu(); create_tab(); break; }
		if(((x-i) >= 0) && ((y+i) < 15)) {
			if(game[y+i][x-i] == color) q++; 
			else break;
		}
	}
	for(var i = 0, q = 0; i <= 5; i++) {
		if(q == 5) { alert('Player ' + color + ' is WINNER'); draw_bg(); draw_menu(); create_tab(); break; }
		if((y-i) >= 0 && (x-i) >= 0) {
			if(game[y-i][x-i] == color) q++; 
			else break;
		}
	}
	
	for(var i = 0, q = 0; i <= 5; i++) {
		if(q == 5) { alert('Player ' + color + ' is WINNER'); draw_bg(); draw_menu(); create_tab(); break; }
		if(((y+i) <= 14) && ((x+i) <= 14)) {
			if(game[y+i][x+i] == color) q++; 
			else break;
		}
	}
}

function read_game() {
	for(var i = 0; i < 15; i++) {
		for(var j = 0; j < 15; j++) {
			if(game[j][i] == 0 || game[j][i] == 1) {
				circle(i+1, j+1, game[j][i]); 
			}
		}
	}
}

function changesize(what) {
	if(what == 'add') {
		size += 2;
	}
	else {
		size -= 2;
	}
	draw_bg(); 
	init_game();
	read_game();
}	